/**
 * Modifications copyright (C) 2020 <SuperMap Software Co., Ltd.>
 * Cesium - https://github.com/CesiumGS/cesium
 *
 * Copyright 2011-2020 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * See https://github.com/CesiumGS/cesium/blob/master/LICENSE.md for full licensing details.
 */


/**
 * Cesium - 
 *
 * Copyright 2011-2020 Cesium Contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Columbus View (Pat. Pend.)
 *
 * Portions licensed separately.
 * 
 */

var Cesium=(()=>{var lbt=Object.create;var KG=Object.defineProperty;var ubt=Object.getOwnPropertyDescriptor;var cbt=Object.getOwnPropertyNames;var fbt=Object.getPrototypeOf,xbt=Object.prototype.hasOwnProperty;var y=(e,r)=>KG(e,"name",{value:r,configurable:!0}),Bs=(e=>typeof require<"u"?require:typeof Proxy<"u"?new Proxy(e,{get:(r,n)=>(typeof require<"u"?require:r)[n]}):e)(function(e){if(typeof require<"u")return require.apply(this,arguments);throw new Error('Dynamic require of "'+e+'" is not supported')});var Ee=(e,r)=>()=>(e&&(r=e(e=0)),r);var X7=(e,r)=>()=>(r||e((r={exports:{}}).exports,r),r.exports),ZG=(e,r)=>{for(var n in r)KG(e,n,{get:r[n],enumerable:!0})},d3e=(e,r,n,o)=>{if(r&&typeof r=="object"||typeof r=="function")for(let a of cbt(r))!xbt.call(e,a)&&a!==n&&KG(e,a,{get:()=>r[a],enumerable:!(o=ubt(r,a))||o.enumerable});return e};var hbt=(e,r,n)=>(n=e!=null?lbt(fbt(e)):{},d3e(r||!e||!e.__esModule?KG(n,"default",{value:e,enumerable:!0}):n,e)),dbt=e=>d3e(KG({},"__esModule",{value:!0}),e);function mbt(e){return e!=null}var p,De=Ee(()=>{y(mbt,"defined");p=mbt});function VM(e){this.name="DeveloperError",this.message=e;var r;try{throw new Error}catch(n){r=n.stack}this.stack=r}var G,st=Ee(()=>{De();y(VM,"DeveloperError");p(Object.create)&&(VM.prototype=Object.create(Error.prototype),VM.prototype.constructor=VM);VM.prototype.toString=function(){var e=this.name+": "+this.message;return p(this.stack)&&(e+=`
`+this.stack.toString()),e};VM.throwInstantiationError=function(){throw new VM("This function defines an interface and should not be called directly.")};G=VM});function pbt(e){return e+" is required, actual value was undefined"}function JG(e,r,n){return"Expected "+n+" to be typeof "+r+", actual typeof was "+e}var gx,X,cr=Ee(()=>{De();st();gx={};gx.typeOf={};y(pbt,"getUndefinedErrorMessage");y(JG,"getFailedTypeErrorMessage");gx.defined=function(e,r){if(!p(r))throw new G(pbt(e))};gx.typeOf.func=function(e,r){if(typeof r!="function")throw new G(JG(typeof r,"function",e))};gx.typeOf.string=function(e,r){if(typeof r!="string")throw new G(JG(typeof r,"string",e))};gx.typeOf.number=function(e,r){if(typeof r!="number")throw new G(JG(typeof r,"number",e))};gx.typeOf.number.lessThan=function(e,r,n){if(gx.typeOf.number(e,r),r>=n)throw new G("Expected "+e+" to be less than "+n+", actual value was "+r)};gx.typeOf.number.lessThanOrEquals=function(e,r,n){if(gx.typeOf.number(e,r),r>n)throw new G("Expected "+e+" to be less than or equal to "+n+", actual value was "+r)};gx.typeOf.number.greaterThan=function(e,r,n){if(gx.typeOf.number(e,r),r<=n)throw new G("Expected "+e+" to be greater than "+n+", actual value was "+r)};gx.typeOf.number.greaterThanOrEquals=function(e,r,n){if(gx.typeOf.number(e,r),r<n)throw new G("Expected "+e+" to be greater than or equal to"+n+", actual value was "+r)};gx.typeOf.object=function(e,r){if(typeof r!="object")throw new G(JG(typeof r,"object",e))};gx.typeOf.bool=function(e,r){if(typeof r!="boolean")throw new G(JG(typeof r,"boolean",e))};gx.typeOf.number.equals=function(e,r,n,o){if(gx.typeOf.number(e,n),gx.typeOf.number(r,o),n!==o)throw new G(e+" must be equal to "+r+", the actual values are "+n+" and "+o)};X=gx});function m3e(e,r){return e!=null?e:r}var B,Ze=Ee(()=>{y(m3e,"defaultValue");m3e.EMPTY_OBJECT=Object.freeze({});B=m3e});var K7,$G,zxe=Ee(()=>{/**
@license

   Copyright (C) 1997 - 2002, Makoto Matsumoto and Takuji Nishimura,
   All rights reserved.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

     1. Redistributions of source code must retain the above copyright
        notice, this list of conditions and the following disclaimer.

     2. Redistributions in binary form must reproduce the above copyright
        notice, this list of conditions and the following disclaimer in the
        documentation and/or other materials provided with the distribution.

     3. The names of its contributors may not be used to endorse or promote
        products derived from this software without specific prior written
        permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
   A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/K7=y(function(e){e==null&&(e=new Date().getTime()),this.N=624,this.M=397,this.MATRIX_A=2567483615,this.UPPER_MASK=2147483648,this.LOWER_MASK=2147483647,this.mt=new Array(this.N),this.mti=this.N+1,this.init_genrand(e)},"MersenneTwister");K7.prototype.init_genrand=function(e){for(this.mt[0]=e>>>0,this.mti=1;this.mti<this.N;this.mti++){var e=this.mt[this.mti-1]^this.mt[this.mti-1]>>>30;this.mt[this.mti]=(((e&4294901760)>>>16)*1812433253<<16)+(e&65535)*1812433253+this.mti,this.mt[this.mti]>>>=0}};K7.prototype.genrand_int32=function(){var e,r=new Array(0,this.MATRIX_A);if(this.mti>=this.N){var n;for(this.mti==this.N+1&&this.init_genrand(5489),n=0;n<this.N-this.M;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+this.M]^e>>>1^r[e&1];for(;n<this.N-1;n++)e=this.mt[n]&this.UPPER_MASK|this.mt[n+1]&this.LOWER_MASK,this.mt[n]=this.mt[n+(this.M-this.N)]^e>>>1^r[e&1];e=this.mt[this.N-1]&this.UPPER_MASK|this.mt[0]&this.LOWER_MASK,this.mt[this.N-1]=this.mt[this.M-1]^e>>>1^r[e&1],this.mti=0}return e=this.mt[this.mti++],e^=e>>>11,e^=e<<7&2636928640,e^=e<<15&4022730752,e^=e>>>18,e>>>0};K7.prototype.random=function(){return this.genrand_int32()*(1/4294967296)};$G=K7});var Li,Z7,p3e,K,nr=Ee(()=>{zxe();cr();Ze();De();st();Li={};Li.Radius=6378137;Li.EPSILON1=.1;Li.EPSILON2=.01;Li.EPSILON3=.001;Li.EPSILON4=1e-4;Li.EPSILON5=1e-5;Li.EPSILON6=1e-6;Li.EPSILON7=1e-7;Li.EPSILON8=1e-8;Li.EPSILON9=1e-9;Li.EPSILON10=1e-10;Li.EPSILON11=1e-11;Li.EPSILON12=1e-12;Li.EPSILON13=1e-13;Li.EPSILON14=1e-14;Li.EPSILON15=1e-15;Li.EPSILON16=1e-16;Li.EPSILON17=1e-17;Li.EPSILON18=1e-18;Li.EPSILON19=1e-19;Li.EPSILON20=1e-20;Li.EPSILON21=1e-21;Li.GRAVITATIONALPARAMETER=3986004418e5;Li.SOLAR_RADIUS=6955e5;Li.LUNAR_RADIUS=1737400;Li.SIXTY_FOUR_KILOBYTES=64*1024;Li.sign=B(Math.sign,y(function(r){return r=+r,r===0||r!==r?r:r>0?1:-1},"sign"));Li.signNotZero=function(e){return e<0?-1:1};Li.toSNorm=function(e,r){return r=B(r,255),Math.round((Li.clamp(e,-1,1)*.5+.5)*r)};Li.fromSNorm=function(e,r){return r=B(r,255),Li.clamp(e,0,r)/r*2-1};Li.normalize=function(e,r,n){return n=Math.max(n-r,0),n===0?0:Li.clamp((e-r)/n,0,1)};Li.sinh=B(Math.sinh,y(function(r){return(Math.exp(r)-Math.exp(-r))/2},"sinh"));Li.cosh=B(Math.cosh,y(function(r){return(Math.exp(r)+Math.exp(-r))/2},"cosh"));Li.lerp=function(e,r,n){return(1-n)*e+n*r};Li.PI=Math.PI;Li.ONE_OVER_PI=1/Math.PI;Li.PI_OVER_TWO=Math.PI/2;Li.PI_OVER_THREE=Math.PI/3;Li.PI_OVER_FOUR=Math.PI/4;Li.PI_OVER_SIX=Math.PI/6;Li.THREE_PI_OVER_TWO=3*Math.PI/2;Li.TWO_PI=2*Math.PI;Li.ONE_OVER_TWO_PI=1/(2*Math.PI);Li.RADIANS_PER_DEGREE=Math.PI/180;Li.DEGREES_PER_RADIAN=180/Math.PI;Li.RADIANS_PER_ARCSECOND=Li.RADIANS_PER_DEGREE/3600;Li.toRadians=function(e){if(!p(e))throw new G("degrees is required.");return e*Li.RADIANS_PER_DEGREE};Li.toDegrees=function(e){if(!p(e))throw new G("radians is required.");return e*Li.DEGREES_PER_RADIAN};Li.convertLongitudeRange=function(e){if(!p(e))throw new G("angle is required.");var r=Li.TWO_PI,n=e-Math.floor(e/r)*r;return n<-Math.PI?n+r:n>=Math.PI?n-r:n};Li.clampToLatitudeRange=function(e){if(!p(e))throw new G("angle is required.");return Li.clamp(e,-1*Li.PI_OVER_TWO,Li.PI_OVER_TWO)};Li.negativePiToPi=function(e){if(!p(e))throw new G("angle is required.");return Li.zeroToTwoPi(e+Li.PI)-Li.PI};Li.zeroToTwoPi=function(e){if(!p(e))throw new G("angle is required.");var r=Li.mod(e,Li.TWO_PI);return Math.abs(r)<Li.EPSILON14&&Math.abs(e)>Li.EPSILON14?Li.TWO_PI:r};Li.mod=function(e,r){if(!p(e))throw new G("m is required.");if(!p(r))throw new G("n is required.");return(e%r+r)%r};Li.equalsEpsilon=function(e,r,n,o){if(!p(e))throw new G("left is required.");if(!p(r))throw new G("right is required.");if(!p(n))throw new G("relativeEpsilon is required.");o=B(o,n);var a=Math.abs(e-r);return a<=o||a<=n*Math.max(Math.abs(e),Math.abs(r))};Li.lessThan=function(e,r,n){if(!p(e))throw new G("first is required.");if(!p(r))throw new G("second is required.");if(!p(n))throw new G("relativeEpsilon is required.");return e-r<-n};Li.lessThanOrEquals=function(e,r,n){if(!p(e))throw new G("first is required.");if(!p(r))throw new G("second is required.");if(!p(n))throw new G("relativeEpsilon is required.");return e-r<n};Li.greaterThan=function(e,r,n){if(!p(e))throw new G("first is required.");if(!p(r))throw new G("second is required.");if(!p(n))throw new G("relativeEpsilon is required.");return e-r>n};Li.greaterThanOrEquals=function(e,r,n){if(!p(e))throw new G("first is required.");if(!p(r))throw new G("second is required.");if(!p(n))throw new G("relativeEpsilon is required.");return e-r>-n};Z7=[1];Li.factorial=function(e){if(typeof e!="number"||e<0)throw new G("A number greater than or equal to 0 is required.");var r=Z7.length;if(e>=r)for(var n=Z7[r-1],o=r;o<=e;o++){var a=n*o;Z7.push(a),n=a}return Z7[e]};Li.incrementWrap=function(e,r,n){if(n=B(n,0),!p(e))throw new G("n is required.");if(r<=n)throw new G("maximumValue must be greater than minimumValue.");return++e,e>r&&(e=n),e};Li.isPowerOfTwo=function(e){if(typeof e!="number"||e<0)throw new G("A number greater than or equal to 0 is required.");return e!==0&&(e&e-1)===0};Li.nextPowerOfTwo=function(e){if(typeof e!="number"||e<0)throw new G("A number greater than or equal to 0 is required.");return--e,e|=e>>1,e|=e>>2,e|=e>>4,e|=e>>8,e|=e>>16,++e,e};Li.clamp=function(e,r,n){if(!p(e))throw new G("value is required");if(!p(r))throw new G("min is required.");if(!p(n))throw new G("max is required.");return e<r?r:e>n?n:e};p3e=new $G;Li.setRandomNumberSeed=function(e){if(!p(e))throw new G("seed is required.");p3e=new $G(e)};Li.nextRandomNumber=function(){return p3e.random()};Li.randomBetween=function(e,r){return Li.nextRandomNumber()*(r-e)+e};Li.acosClamped=function(e){if(!p(e))throw new G("value is required.");return Math.acos(Li.clamp(e,-1,1))};Li.asinClamped=function(e){if(!p(e))throw new G("value is required.");return Math.asin(Li.clamp(e,-1,1))};Li.chordLength=function(e,r){if(!p(e))throw new G("angle is required.");if(!p(r))throw new G("radius is required.");return 2*r*Math.sin(e*.5)};Li.logBase=function(e,r){if(!p(e))throw new G("number is required.");if(!p(r))throw new G("base is required.");return Math.log(e)/Math.log(r)};Li.cbrt=B(Math.cbrt,y(function(r){var n=Math.pow(Math.abs(r),.3333333333333333);return r<0?-n:n},"cbrt"));Li.log2=B(Math.log2,y(function(r){return Math.log(r)*Math.LOG2E},"log2"));Li.fog=function(e,r){var n=e*r;return 1-Math.exp(-(n*n))};Li.fastApproximateAtan=function(e){return X.typeOf.number("x",e),e*(-.1784*Math.abs(e)-.0663*e*e+1.0301)};Li.fastApproximateAtan2=function(e,r){X.typeOf.number("x",e),X.typeOf.number("y",r);var n,o,a=Math.abs(e);n=Math.abs(r),o=Math.max(a,n),n=Math.min(a,n);var s=n/o;if(isNaN(s))throw new G("either x or y must be nonzero");return a=Li.fastApproximateAtan(s),a=Math.abs(r)>Math.abs(e)?Li.PI_OVER_TWO-a:a,a=e<0?Li.PI-a:a,a=r<0?-a:a,a};K=Li});function Cn(e,r){this.x=B(e,0),this.y=B(r,0)}var J7,v3e,g3e,_3e,vbt,de,Fr=Ee(()=>{cr();Ze();De();st();nr();y(Cn,"Cartesian2");Cn.fromElements=function(e,r,n){return p(n)?(n.x=e,n.y=r,n):new Cn(e,r)};Cn.clone=function(e,r){if(!!p(e))return p(r)?(r.x=e.x,r.y=e.y,r):new Cn(e.x,e.y)};Cn.fromCartesian3=Cn.clone;Cn.fromCartesian4=Cn.clone;Cn.packedLength=2;Cn.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.x,r[n]=e.y,r};Cn.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Cn),n.x=e[r++],n.y=e[r],n};Cn.packArray=function(e,r){X.defined("array",e);var n=e.length,o=n*2;if(!p(r))r=new Array(o);else{if(!Array.isArray(r)&&r.length!==o)throw new G("If result is a typed array, it must have exactly array.length * 2 elements");r.length!==o&&(r.length=o)}for(var a=0;a<n;++a)Cn.pack(e[a],r,a*2);return r};Cn.unpackArray=function(e,r){if(X.defined("array",e),X.typeOf.number.greaterThanOrEquals("array.length",e.length,2),e.length%2!==0)throw new G("array length must be a multiple of 2.");var n=e.length;p(r)?r.length=n/2:r=new Array(n/2);for(var o=0;o<n;o+=2){var a=o/2;r[a]=Cn.unpack(e,o,r[a])}return r};Cn.fromArray=Cn.unpack;Cn.maximumComponent=function(e){return X.typeOf.object("cartesian",e),Math.max(e.x,e.y)};Cn.minimumComponent=function(e){return X.typeOf.object("cartesian",e),Math.min(e.x,e.y)};Cn.minimumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n};Cn.maximumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n};Cn.magnitudeSquared=function(e){return X.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y};Cn.magnitude=function(e){return Math.sqrt(Cn.magnitudeSquared(e))};J7=new Cn;Cn.distance=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),Cn.subtract(e,r,J7),Cn.magnitude(J7)};Cn.distanceSquared=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),Cn.subtract(e,r,J7),Cn.magnitudeSquared(J7)};Cn.normalize=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=Cn.magnitude(e);if(r.x=e.x/n,r.y=e.y/n,isNaN(r.x)||isNaN(r.y))throw new G("normalized result is not a number");return r};Cn.dot=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),e.x*r.x+e.y*r.y};Cn.multiplyComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x*r.x,n.y=e.y*r.y,n};Cn.divideComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x/r.x,n.y=e.y/r.y,n};Cn.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n};Cn.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n};Cn.multiplyByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n};Cn.divideByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n};Cn.negate=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r};Cn.abs=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=Math.abs(e.x),r.y=Math.abs(e.y),r};v3e=new Cn;Cn.lerp=function(e,r,n,o){return X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o),Cn.multiplyByScalar(r,n,v3e),o=Cn.multiplyByScalar(e,1-n,o),Cn.add(v3e,o,o)};g3e=new Cn,_3e=new Cn;Cn.angleBetween=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),Cn.normalize(e,g3e),Cn.normalize(r,_3e),K.acosClamped(Cn.dot(g3e,_3e))};vbt=new Cn;Cn.mostOrthogonalAxis=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=Cn.normalize(e,vbt);return Cn.abs(n,n),n.x<=n.y?r=Cn.clone(Cn.UNIT_X,r):r=Cn.clone(Cn.UNIT_Y,r),r};Cn.equals=function(e,r){return e===r||p(e)&&p(r)&&e.x===r.x&&e.y===r.y};Cn.equalsArray=function(e,r,n){return e.x===r[n]&&e.y===r[n+1]};Cn.equalsEpsilon=function(e,r,n,o){return e===r||p(e)&&p(r)&&K.equalsEpsilon(e.x,r.x,n,o)&&K.equalsEpsilon(e.y,r.y,n,o)};Cn.ZERO=Object.freeze(new Cn(0,0));Cn.UNIT_X=Object.freeze(new Cn(1,0));Cn.UNIT_Y=Object.freeze(new Cn(0,1));Cn.prototype.clone=function(e){return Cn.clone(this,e)};Cn.prototype.equals=function(e){return Cn.equals(this,e)};Cn.prototype.equalsEpsilon=function(e,r,n){return Cn.equalsEpsilon(this,e,r,n)};Cn.prototype.toString=function(){return"("+this.x+", "+this.y+")"};de=Cn});function si(e,r,n){this.x=B(e,0),this.y=B(r,0),this.z=B(n,0)}var eY,y3e,$7,Vxe,gbt,xg,fF,_bt,ybt,E,bt=Ee(()=>{cr();Ze();De();st();nr();y(si,"Cartesian3");si.fromSpherical=function(e,r){X.typeOf.object("spherical",e),p(r)||(r=new si);var n=e.clock,o=e.cone,a=B(e.magnitude,1),s=a*Math.sin(o);return r.x=s*Math.cos(n),r.y=s*Math.sin(n),r.z=a*Math.cos(o),r};si.fromElements=function(e,r,n,o){return p(o)?(o.x=e,o.y=r,o.z=n,o):new si(e,r,n)};si.clone=function(e,r){if(!!p(e))return p(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r):new si(e.x,e.y,e.z)};si.fromCartesian4=si.clone;si.packedLength=3;si.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.x,r[n++]=e.y,r[n]=e.z,r};si.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new si),n.x=e[r++],n.y=e[r++],n.z=e[r],n};si.packArray=function(e,r){X.defined("array",e);var n=e.length;p(r)?r.length=n*3:r=new Array(n*3);for(var o=0;o<n;++o)si.pack(e[o],r,o*3);return r};si.unpackArray=function(e,r){if(X.defined("array",e),X.typeOf.number.greaterThanOrEquals("array.length",e.length,3),e.length%3!==0)throw new G("array length must be a multiple of 3.");var n=e.length;p(r)?r.length=n/3:r=new Array(n/3);for(var o=0;o<n;o+=3){var a=o/3;r[a]=si.unpack(e,o,r[a])}return r};si.fromArray=si.unpack;si.maximumComponent=function(e){return X.typeOf.object("cartesian",e),Math.max(e.x,e.y,e.z)};si.minimumComponent=function(e){return X.typeOf.object("cartesian",e),Math.min(e.x,e.y,e.z)};si.minimumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n};si.maximumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n};si.magnitudeSquared=function(e){return X.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y+e.z*e.z};si.magnitude=function(e){return Math.sqrt(si.magnitudeSquared(e))};eY=new si;si.distance=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),si.subtract(e,r,eY),si.magnitude(eY)};si.distanceSquared=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),si.subtract(e,r,eY),si.magnitudeSquared(eY)};si.normalize=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=si.magnitude(e);if(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,isNaN(r.x)||isNaN(r.y)||isNaN(r.z))throw new G("normalized result is not a number");return r};si.dot=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z};si.multiplyComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n};si.divideComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x/r.x,n.y=e.y/r.y,n.z=e.z/r.z,n};si.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n};si.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n};si.multiplyByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n};si.divideByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n};si.negate=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r};si.abs=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r};y3e=new si;si.lerp=function(e,r,n,o){return X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o),si.multiplyByScalar(r,n,y3e),o=si.multiplyByScalar(e,1-n,o),si.add(y3e,o,o)};$7=new si,Vxe=new si;si.angleBetween=function(e,r){X.typeOf.object("left",e),X.typeOf.object("right",r),si.normalize(e,$7),si.normalize(r,Vxe);var n=si.dot($7,Vxe),o=si.magnitude(si.cross($7,Vxe,$7));return Math.atan2(o,n)};gbt=new si;si.mostOrthogonalAxis=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=si.normalize(e,gbt);return si.abs(n,n),n.x<=n.y?n.x<=n.z?r=si.clone(si.UNIT_X,r):r=si.clone(si.UNIT_Z,r):n.y<=n.z?r=si.clone(si.UNIT_Y,r):r=si.clone(si.UNIT_Z,r),r};si.projectVector=function(e,r,n){X.defined("a",e),X.defined("b",r),X.defined("result",n);var o=si.dot(e,r)/si.dot(r,r);return si.multiplyByScalar(r,o,n)};si.equals=function(e,r){return e===r||p(e)&&p(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z};si.equalsArray=function(e,r,n){return e.x===r[n]&&e.y===r[n+1]&&e.z===r[n+2]};si.equalsEpsilon=function(e,r,n,o){return e===r||p(e)&&p(r)&&K.equalsEpsilon(e.x,r.x,n,o)&&K.equalsEpsilon(e.y,r.y,n,o)&&K.equalsEpsilon(e.z,r.z,n,o)};si.cross=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e.x,a=e.y,s=e.z,l=r.x,h=r.y,x=r.z,m=a*x-s*h,v=s*l-o*x,_=o*h-a*l;return n.x=m,n.y=v,n.z=_,n};si.midpoint=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=(e.x+r.x)*.5,n.y=(e.y+r.y)*.5,n.z=(e.z+r.z)*.5,n};si.fromDegrees=function(e,r,n,o,a){return X.typeOf.number("longitude",e),X.typeOf.number("latitude",r),e=K.toRadians(e),r=K.toRadians(r),si.fromRadians(e,r,n,o,a)};xg=new si,fF=new si,_bt=new si(6378137*6378137,6378137*6378137,6356752314245179e-9*6356752314245179e-9),ybt=new si(6378137*6378137,6378137*6378137,6378137*6378137);si.fromRadians=function(e,r,n,o,a){X.typeOf.number("longitude",e),X.typeOf.number("latitude",r),n=B(n,0);var s=p(o)?o.radiiSquared:ybt;K.equalsEpsilon(K.Radius,6356752314245179e-9,K.EPSILON10)&&(s=p(o)?o.radiiSquared:_bt);var l=Math.cos(r);xg.x=l*Math.cos(e),xg.y=l*Math.sin(e),xg.z=Math.sin(r),xg=si.normalize(xg,xg),si.multiplyComponents(s,xg,fF);var h=Math.sqrt(si.dot(xg,fF));return fF=si.divideByScalar(fF,h,fF),xg=si.multiplyByScalar(xg,n,xg),p(a)||(a=new si),si.add(fF,xg,a)};si.fromDegreesArray=function(e,r,n){if(X.defined("coordinates",e),e.length<2||e.length%2!==0)throw new G("the number of coordinates must be a multiple of 2 and at least 2");var o=e.length;p(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var s=e[a],l=e[a+1],h=a/2;n[h]=si.fromDegrees(s,l,0,r,n[h])}return n};si.fromRadiansArray=function(e,r,n){if(X.defined("coordinates",e),e.length<2||e.length%2!==0)throw new G("the number of coordinates must be a multiple of 2 and at least 2");var o=e.length;p(n)?n.length=o/2:n=new Array(o/2);for(var a=0;a<o;a+=2){var s=e[a],l=e[a+1],h=a/2;n[h]=si.fromRadians(s,l,0,r,n[h])}return n};si.fromDegreesArrayHeights=function(e,r,n){if(X.defined("coordinates",e),e.length<3||e.length%3!==0)throw new G("the number of coordinates must be a multiple of 3 and at least 3");var o=e.length;p(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var s=e[a],l=e[a+1],h=e[a+2],x=a/3;n[x]=si.fromDegrees(s,l,h,r,n[x])}return n};si.fromRadiansArrayHeights=function(e,r,n){if(X.defined("coordinates",e),e.length<3||e.length%3!==0)throw new G("the number of coordinates must be a multiple of 3 and at least 3");var o=e.length;p(n)?n.length=o/3:n=new Array(o/3);for(var a=0;a<o;a+=3){var s=e[a],l=e[a+1],h=e[a+2],x=a/3;n[x]=si.fromRadians(s,l,h,r,n[x])}return n};si.ZERO=Object.freeze(new si(0,0,0));si.UNIT_X=Object.freeze(new si(1,0,0));si.UNIT_Y=Object.freeze(new si(0,1,0));si.UNIT_Z=Object.freeze(new si(0,0,1));si.UNIT_XYZ=Object.freeze(new si(1,1,1));si.prototype.clone=function(e){return si.clone(this,e)};si.prototype.equals=function(e){return si.equals(this,e)};si.prototype.equalsEpsilon=function(e,r,n){return si.equalsEpsilon(this,e,r,n)};si.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+")"};si.globalOffset=new si(0,0,0);E=si});function Tbt(e,r,n,o,a){if(!p(e))throw new G("cartesian is required.");if(!p(r))throw new G("oneOverRadii is required.");if(!p(n))throw new G("oneOverRadiiSquared is required.");if(!p(o))throw new G("centerToleranceSquared is required.");var s=e.x,l=e.y,h=e.z,x=r.x,m=r.y,v=r.z,_=s*s*x*x,A=l*l*m*m,T=h*h*v*v,w=_+A+T,S=Math.sqrt(1/w),P=E.multiplyByScalar(e,S,Abt);if(w<o)return isFinite(S)?E.clone(P,a):void 0;var M=n.x,L=n.y,R=n.z,O=Cbt;O.x=P.x*M*2,O.y=P.y*L*2,O.z=P.z*R*2;var N=(1-S)*E.magnitude(e)/(.5*E.magnitude(O)),k=0,z,W,j,q,I,F,V,U,Q,J,oe;do{N-=k,j=1/(1+N*M),q=1/(1+N*L),I=1/(1+N*R),F=j*j,V=q*q,U=I*I,Q=F*j,J=V*q,oe=U*I,z=_*F+A*V+T*U-1,W=_*Q*M+A*J*L+T*oe*R;var $=-2*W;k=z/$}while(Math.abs(z)>K.EPSILON12);return p(a)?(a.x=s*j,a.y=l*q,a.z=h*I,a):new E(s*j,l*q,h*I)}var Abt,Cbt,xF,tY=Ee(()=>{bt();De();st();nr();Abt=new E,Cbt=new E;y(Tbt,"scaleToGeodeticSurface");xF=Tbt});function qc(e,r,n){this.longitude=B(e,0),this.latitude=B(r,0),this.height=B(n,0)}var wbt,Ebt,bbt,Sbt,Ibt,Pbt,Dbt,Mbt,qe,Si=Ee(()=>{bt();cr();Ze();De();nr();tY();y(qc,"Cartographic");qc.fromRadians=function(e,r,n,o){return X.typeOf.number("longitude",e),X.typeOf.number("latitude",r),n=B(n,0),p(o)?(o.longitude=e,o.latitude=r,o.height=n,o):new qc(e,r,n)};qc.fromDegrees=function(e,r,n,o){return X.typeOf.number("longitude",e),X.typeOf.number("latitude",r),e=K.toRadians(e),r=K.toRadians(r),qc.fromRadians(e,r,n,o)};wbt=new E,Ebt=new E,bbt=new E,Sbt=new E(1/6378137,1/6378137,1/6356752314245179e-9),Ibt=new E(1/6378137,1/6378137,1/6378137),Pbt=new E(1/(6378137*6378137),1/(6378137*6378137),1/(6356752314245179e-9*6356752314245179e-9)),Dbt=new E(1/(6378137*6378137),1/(6378137*6378137),1/(6378137*6378137)),Mbt=K.EPSILON1;qc.fromCartesian=function(e,r,n){var o=p(r)?r.oneOverRadii:Ibt,a=p(r)?r.oneOverRadiiSquared:Dbt,s=p(r)?r._centerToleranceSquared:Mbt;K.equalsEpsilon(K.Radius,6356752314245179e-9,K.EPSILON10)&&(o=p(r)?r.oneOverRadii:Sbt,a=p(r)?r.oneOverRadiiSquared:Pbt);var l=xF(e,o,a,s,Ebt);if(!!p(l)){var h=E.multiplyComponents(l,a,wbt);h=E.normalize(h,h);var x=E.subtract(e,l,bbt),m=Math.atan2(h.y,h.x),v=Math.asin(h.z),_=K.sign(E.dot(x,e))*E.magnitude(x);return p(n)?(n.longitude=m,n.latitude=v,n.height=_,n):new qc(m,v,_)}};qc.toCartesian=function(e,r,n){return X.defined("cartographic",e),E.fromRadians(e.longitude,e.latitude,e.height,r,n)};qc.sphericalDistance=function(e,r,n,o){if(X.defined("longitudeA",e),X.defined("longitudeB",n),X.defined("latitudeA",r),X.defined("latitudeB",o),e===n&&r===o)return 0;var a=K.toRadians(r),s=K.toRadians(o),l=K.toRadians(e),h=K.toRadians(n),x=l*l+a*a,m=h*h+s*s,v=(l-h)*(l-h)+(a-s)*(a-s),_=(x+m-v)/(2*Math.sqrt(x)*Math.sqrt(m));return _=K.clamp(_,-1,1),Math.acos(_)*K.Radius};qc.clone=function(e,r){if(!!p(e))return p(r)?(r.longitude=e.longitude,r.latitude=e.latitude,r.height=e.height,r):new qc(e.longitude,e.latitude,e.height)};qc.equals=function(e,r){return e===r||p(e)&&p(r)&&e.longitude===r.longitude&&e.latitude===r.latitude&&e.height===r.height};qc.equalsEpsilon=function(e,r,n){return X.typeOf.number("epsilon",n),e===r||p(e)&&p(r)&&Math.abs(e.longitude-r.longitude)<=n&&Math.abs(e.latitude-r.latitude)<=n&&Math.abs(e.height-r.height)<=n};qc.ZERO=Object.freeze(new qc(0,0,0));qc.prototype.clone=function(e){return qc.clone(this,e)};qc.prototype.equals=function(e){return qc.equals(this,e)};qc.prototype.equalsEpsilon=function(e,r){return qc.equalsEpsilon(this,e,r)};qc.prototype.toString=function(){return"("+this.longitude+", "+this.latitude+", "+this.height+")"};qe=qc});function A3e(e,r,n,o){r=B(r,0),n=B(n,0),o=B(o,0),X.typeOf.number.greaterThanOrEquals("x",r,0),X.typeOf.number.greaterThanOrEquals("y",n,0),X.typeOf.number.greaterThanOrEquals("z",o,0),K.equalsEpsilon(o,6356752314245179e-9,K.EPSILON10)&&(K.Radius=o),e._radii=new E(r,n,o),e._radiiSquared=new E(r*r,n*n,o*o),e._radiiToTheFourth=new E(r*r*r*r,n*n*n*n,o*o*o*o),e._oneOverRadii=new E(r===0?0:1/r,n===0?0:1/n,o===0?0:1/o),e._oneOverRadiiSquared=new E(r===0?0:1/(r*r),n===0?0:1/(n*n),o===0?0:1/(o*o)),e._minimumRadius=Math.min(r,n,o),e._maximumRadius=Math.max(r,n,o),e._centerToleranceSquared=K.EPSILON1,e._radii.x>0&&(e._f=(e._radii.x-e._radii.z)/e._radii.x,e._e2=2*e._f-e._f*e._f),e._radiiSquared.z!==0&&(e._squaredXOverSquaredZ=e._radiiSquared.x/e._radiiSquared.z)}function zs(e,r,n){this._radii=void 0,this._radiiSquared=void 0,this._radiiToTheFourth=void 0,this._oneOverRadii=void 0,this._oneOverRadiiSquared=void 0,this._minimumRadius=void 0,this._maximumRadius=void 0,this._centerToleranceSquared=void 0,this._squaredXOverSquaredZ=void 0,A3e(this,e,r,n)}var Bbt,Rbt,Lbt,Obt,Fbt,nt,Ii=Ee(()=>{bt();Si();cr();Ze();De();st();nr();tY();y(A3e,"initialize");y(zs,"Ellipsoid");Object.defineProperties(zs.prototype,{radii:{get:function(){return this._radii}},radiiSquared:{get:function(){return this._radiiSquared}},radiiToTheFourth:{get:function(){return this._radiiToTheFourth}},oneOverRadii:{get:function(){return this._oneOverRadii}},oneOverRadiiSquared:{get:function(){return this._oneOverRadiiSquared}},minimumRadius:{get:function(){return this._minimumRadius}},maximumRadius:{get:function(){return this._maximumRadius}}});zs.clone=function(e,r){if(!!p(e)){var n=e._radii;return p(r)?(E.clone(n,r._radii),E.clone(e._radiiSquared,r._radiiSquared),E.clone(e._radiiToTheFourth,r._radiiToTheFourth),E.clone(e._oneOverRadii,r._oneOverRadii),r._f=e._f,r._e2=e._e2,r._minimumRadius=e._minimumRadius,r._maximumRadius=e._maximumRadius,r._centerToleranceSquared=e._centerToleranceSquared,r):new zs(n.x,n.y,n.z)}};zs.fromCartesian3=function(e,r){return p(r)||(r=new zs),p(e)&&A3e(r,e.x,e.y,e.z),r};zs.WGS84=Object.freeze(new zs(6378137,6378137,K.Radius));zs.XIAN80=Object.freeze(new zs(6378140,6378140,635675529e-2));zs.CGCS2000=Object.freeze(new zs(6378137,6378137,635675231e-2));zs.UNIT_SPHERE=Object.freeze(new zs(1,1,1));zs.MOON=Object.freeze(new zs(K.LUNAR_RADIUS,K.LUNAR_RADIUS,K.LUNAR_RADIUS));zs.prototype.clone=function(e){return zs.clone(this,e)};zs.packedLength=E.packedLength;zs.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),E.pack(e._radii,r,n),r};zs.unpack=function(e,r,n){X.defined("array",e),r=B(r,0);var o=E.unpack(e,r);return zs.fromCartesian3(o,n)};zs.prototype.geocentricSurfaceNormal=E.normalize;zs.prototype.geodeticSurfaceNormalCartographic=function(e,r){X.typeOf.object("cartographic",e);var n=e.longitude,o=e.latitude,a=Math.cos(o),s=a*Math.cos(n),l=a*Math.sin(n),h=Math.sin(o);return p(r)||(r=new E),r.x=s,r.y=l,r.z=h,E.normalize(r,r)};zs.prototype.geodeticSurfaceNormal=function(e,r){return p(r)||(r=new E),r=E.multiplyComponents(e,this._oneOverRadiiSquared,r),E.normalize(r,r)};Bbt=new E,Rbt=new E;zs.prototype.cartographicToCartesian=function(e,r){var n=Bbt,o=Rbt;this.geodeticSurfaceNormalCartographic(e,n),E.multiplyComponents(this._radiiSquared,n,o);var a=Math.sqrt(E.dot(n,o));return E.divideByScalar(o,a,o),E.multiplyByScalar(n,e.height,n),p(r)||(r=new E),E.add(o,n,r)};zs.prototype.cartographicArrayToCartesianArray=function(e,r){X.defined("cartographics",e);var n=e.length;p(r)?r.length=n:r=new Array(n);for(var o=0;o<n;o++)r[o]=this.cartographicToCartesian(e[o],r[o]);return r};Lbt=new E,Obt=new E,Fbt=new E;zs.prototype.cartesianToCartographic=function(e,r){var n=this.scaleToGeodeticSurface(e,Obt);if(!!p(n)){var o=this.geodeticSurfaceNormal(n,Lbt),a=E.subtract(e,n,Fbt),s=Math.atan2(o.y,o.x),l=Math.asin(o.z),h=K.sign(E.dot(a,e))*E.magnitude(a);return p(r)?(r.longitude=s,r.latitude=l,r.height=h,r):new qe(s,l,h)}};zs.prototype.cartesianArrayToCartographicArray=function(e,r){X.defined("cartesians",e);var n=e.length;p(r)?r.length=n:r=new Array(n);for(var o=0;o<n;++o)r[o]=this.cartesianToCartographic(e[o],r[o]);return r};zs.prototype.scaleToGeodeticSurface=function(e,r){return xF(e,this._oneOverRadii,this._oneOverRadiiSquared,this._centerToleranceSquared,r)};zs.prototype.scaleToGeocentricSurface=function(e,r){X.typeOf.object("cartesian",e),p(r)||(r=new E);var n=e.x,o=e.y,a=e.z,s=this._oneOverRadiiSquared,l=1/Math.sqrt(n*n*s.x+o*o*s.y+a*a*s.z);return E.multiplyByScalar(e,l,r)};zs.prototype.transformPositionToScaledSpace=function(e,r){return p(r)||(r=new E),E.multiplyComponents(e,this._oneOverRadii,r)};zs.prototype.transformPositionFromScaledSpace=function(e,r){return p(r)||(r=new E),E.multiplyComponents(e,this._radii,r)};zs.prototype.equals=function(e){return this===e||p(e)&&E.equals(this._radii,e._radii)};zs.prototype.toString=function(){return this._radii.toString()};zs.prototype.getSurfaceNormalIntersectionWithZAxis=function(e,r,n){if(X.typeOf.object("position",e),!K.equalsEpsilon(this._radii.x,this._radii.y,K.EPSILON15))throw new G("Ellipsoid must be an ellipsoid of revolution (radii.x == radii.y)");X.typeOf.number.greaterThan("Ellipsoid.radii.z",this._radii.z,0),r=B(r,0);var o=this._squaredXOverSquaredZ;if(p(n)||(n=new E),n.x=0,n.y=0,n.z=e.z*(1-o),!(Math.abs(n.z)>=this._radii.z-r))return n};nt=zs});function rY(e){this._ellipsoid=B(e,nt.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}var yo,iu=Ee(()=>{bt();Si();Ze();De();st();Ii();y(rY,"GeographicProjection");Object.defineProperties(rY.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}});rY.prototype.project=function(e,r){var n=this._semimajorAxis,o=e.longitude*n,a=e.latitude*n,s=e.height;return p(r)?(r.x=o,r.y=a,r.z=s,r):new E(o,a,s)};rY.prototype.unproject=function(e,r){if(!p(e))throw new G("cartesian is required");var n=this._oneOverSemimajorAxis,o=e.x*n,a=e.y*n,s=e.z;return p(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new qe(o,a,s)};yo=rY});var Nbt,wi,Ql=Ee(()=>{Nbt={OUTSIDE:-1,INTERSECTING:0,INSIDE:1},wi=Object.freeze(Nbt)});function Wo(e,r,n,o){this.west=B(e,0),this.south=B(r,0),this.east=B(n,0),this.north=B(o,0)}var zbt,iY,He,Ni=Ee(()=>{Si();cr();Ze();De();Ii();nr();y(Wo,"Rectangle");Object.defineProperties(Wo.prototype,{width:{get:function(){return Wo.computeWidth(this)}},height:{get:function(){return Wo.computeHeight(this)}}});Wo.packedLength=4;Wo.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.west,r[n++]=e.south,r[n++]=e.east,r[n]=e.north,r};Wo.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Wo),n.west=e[r++],n.south=e[r++],n.east=e[r++],n.north=e[r],n};Wo.computeWidth=function(e){X.typeOf.object("rectangle",e);var r=e.east,n=e.west;return r<n&&(r+=K.TWO_PI),r-n};Wo.computeHeight=function(e){return X.typeOf.object("rectangle",e),e.north-e.south};Wo.fromDegrees=function(e,r,n,o,a){return e=K.toRadians(B(e,0)),r=K.toRadians(B(r,0)),n=K.toRadians(B(n,0)),o=K.toRadians(B(o,0)),p(a)?(a.west=e,a.south=r,a.east=n,a.north=o,a):new Wo(e,r,n,o)};Wo.fromRadians=function(e,r,n,o,a){return p(a)?(a.west=B(e,0),a.south=B(r,0),a.east=B(n,0),a.north=B(o,0),a):new Wo(e,r,n,o)};Wo.fromCartographicArray=function(e,r){X.defined("cartographics",e);for(var n=Number.MAX_VALUE,o=-Number.MAX_VALUE,a=Number.MAX_VALUE,s=-Number.MAX_VALUE,l=Number.MAX_VALUE,h=-Number.MAX_VALUE,x=0,m=e.length;x<m;x++){var v=e[x];n=Math.min(n,v.longitude),o=Math.max(o,v.longitude),l=Math.min(l,v.latitude),h=Math.max(h,v.latitude);var _=v.longitude>=0?v.longitude:v.longitude+K.TWO_PI;a=Math.min(a,_),s=Math.max(s,_)}return o-n>s-a&&(n=a,o=s,o>K.PI&&(o=o-K.TWO_PI),n>K.PI&&(n=n-K.TWO_PI)),p(r)?(r.west=n,r.south=l,r.east=o,r.north=h,r):new Wo(n,l,o,h)};Wo.fromCartesianArray=function(e,r,n){X.defined("cartesians",e),r=B(r,nt.WGS84);for(var o=Number.MAX_VALUE,a=-Number.MAX_VALUE,s=Number.MAX_VALUE,l=-Number.MAX_VALUE,h=Number.MAX_VALUE,x=-Number.MAX_VALUE,m=0,v=e.length;m<v;m++){var _=r.cartesianToCartographic(e[m]);o=Math.min(o,_.longitude),a=Math.max(a,_.longitude),h=Math.min(h,_.latitude),x=Math.max(x,_.latitude);var A=_.longitude>=0?_.longitude:_.longitude+K.TWO_PI;s=Math.min(s,A),l=Math.max(l,A)}return a-o>l-s&&(o=s,a=l,a>K.PI&&(a=a-K.TWO_PI),o>K.PI&&(o=o-K.TWO_PI)),p(n)?(n.west=o,n.south=h,n.east=a,n.north=x,n):new Wo(o,h,a,x)};Wo.clone=function(e,r){if(!!p(e))return p(r)?(r.west=e.west,r.south=e.south,r.east=e.east,r.north=e.north,r):new Wo(e.west,e.south,e.east,e.north)};Wo.equalsEpsilon=function(e,r,n){return X.typeOf.number("absoluteEpsilon",n),e===r||p(e)&&p(r)&&Math.abs(e.west-r.west)<=n&&Math.abs(e.south-r.south)<=n&&Math.abs(e.east-r.east)<=n&&Math.abs(e.north-r.north)<=n};Wo.prototype.clone=function(e){return Wo.clone(this,e)};Wo.prototype.equals=function(e){return Wo.equals(this,e)};Wo.equals=function(e,r){return e===r||p(e)&&p(r)&&e.west===r.west&&e.south===r.south&&e.east===r.east&&e.north===r.north};Wo.prototype.equalsEpsilon=function(e,r){return X.typeOf.number("epsilon",r),Wo.equalsEpsilon(this,e,r)};Wo.validate=function(e){X.typeOf.object("rectangle",e);var r=e.north;X.typeOf.number.greaterThanOrEquals("north",r,-K.PI_OVER_TWO),X.typeOf.number.lessThanOrEquals("north",r,K.PI_OVER_TWO);var n=e.south;X.typeOf.number.greaterThanOrEquals("south",n,-K.PI_OVER_TWO),X.typeOf.number.lessThanOrEquals("south",n,K.PI_OVER_TWO);var o=e.west;X.typeOf.number.greaterThanOrEquals("west",o,-Math.PI),X.typeOf.number.lessThanOrEquals("west",o,Math.PI);var a=e.east;X.typeOf.number.greaterThanOrEquals("east",a,-Math.PI),X.typeOf.number.lessThanOrEquals("east",a,Math.PI)};Wo.southwest=function(e,r){return X.typeOf.object("rectangle",e),p(r)?(r.longitude=e.west,r.latitude=e.south,r.height=0,r):new qe(e.west,e.south)};Wo.northwest=function(e,r){return X.typeOf.object("rectangle",e),p(r)?(r.longitude=e.west,r.latitude=e.north,r.height=0,r):new qe(e.west,e.north)};Wo.northeast=function(e,r){return X.typeOf.object("rectangle",e),p(r)?(r.longitude=e.east,r.latitude=e.north,r.height=0,r):new qe(e.east,e.north)};Wo.southeast=function(e,r){return X.typeOf.object("rectangle",e),p(r)?(r.longitude=e.east,r.latitude=e.south,r.height=0,r):new qe(e.east,e.south)};Wo.center=function(e,r){X.typeOf.object("rectangle",e);var n=e.east,o=e.west;n<o&&(n+=K.TWO_PI);var a=K.negativePiToPi((o+n)*.5),s=(e.south+e.north)*.5;return p(r)?(r.longitude=a,r.latitude=s,r.height=0,r):new qe(a,s)};Wo.intersection=function(e,r,n){X.typeOf.object("rectangle",e),X.typeOf.object("otherRectangle",r);var o=e.east,a=e.west,s=r.east,l=r.west;o<a&&s>0?o+=K.TWO_PI:s<l&&o>0&&(s+=K.TWO_PI),o<a&&l<0?l+=K.TWO_PI:s<l&&a<0&&(a+=K.TWO_PI);var h=K.negativePiToPi(Math.max(a,l)),x=K.negativePiToPi(Math.min(o,s));if(!((e.west<e.east||r.west<r.east)&&x<=h)){var m=Math.max(e.south,r.south),v=Math.min(e.north,r.north);if(!(m>=v))return p(n)?(n.west=h,n.south=m,n.east=x,n.north=v,n):new Wo(h,m,x,v)}};Wo.simpleIntersection=function(e,r,n){X.typeOf.object("rectangle",e),X.typeOf.object("otherRectangle",r);var o=Math.max(e.west,r.west),a=Math.max(e.south,r.south),s=Math.min(e.east,r.east),l=Math.min(e.north,r.north);if(!(a>=l||o>=s))return p(n)?(n.west=o,n.south=a,n.east=s,n.north=l,n):new Wo(o,a,s,l)};Wo.union=function(e,r,n){X.typeOf.object("rectangle",e),X.typeOf.object("otherRectangle",r),p(n)||(n=new Wo);var o=e.east,a=e.west,s=r.east,l=r.west;o<a&&s>0?o+=K.TWO_PI:s<l&&o>0&&(s+=K.TWO_PI),o<a&&l<0?l+=K.TWO_PI:s<l&&a<0&&(a+=K.TWO_PI);var h=K.convertLongitudeRange(Math.min(a,l)),x=K.convertLongitudeRange(Math.max(o,s));return n.west=h,n.south=Math.min(e.south,r.south),n.east=x,n.north=Math.max(e.north,r.north),n};Wo.expand=function(e,r,n){return X.typeOf.object("rectangle",e),X.typeOf.object("cartographic",r),p(n)||(n=new Wo),n.west=Math.min(e.west,r.longitude),n.south=Math.min(e.south,r.latitude),n.east=Math.max(e.east,r.longitude),n.north=Math.max(e.north,r.latitude),n};Wo.contains=function(e,r){X.typeOf.object("rectangle",e),X.typeOf.object("cartographic",r);var n=r.longitude,o=r.latitude,a=e.west,s=e.east;return s<a&&(s+=K.TWO_PI,n<0&&(n+=K.TWO_PI)),(n>a||K.equalsEpsilon(n,a,K.EPSILON14))&&(n<s||K.equalsEpsilon(n,s,K.EPSILON14))&&o>=e.south&&o<=e.north};zbt=new qe;Wo.subsample=function(e,r,n,o){X.typeOf.object("rectangle",e),r=B(r,nt.WGS84),n=B(n,0),p(o)||(o=[]);var a=0,s=e.north,l=e.south,h=e.east,x=e.west,m=zbt;m.height=n,m.longitude=x,m.latitude=s,o[a]=r.cartographicToCartesian(m,o[a]),a++,m.longitude=h,o[a]=r.cartographicToCartesian(m,o[a]),a++,m.latitude=l,o[a]=r.cartographicToCartesian(m,o[a]),a++,m.longitude=x,o[a]=r.cartographicToCartesian(m,o[a]),a++,s<0?m.latitude=s:l>0?m.latitude=l:m.latitude=0;for(var v=1;v<8;++v)m.longitude=-Math.PI+v*K.PI_OVER_TWO,Wo.contains(e,m)&&(o[a]=r.cartographicToCartesian(m,o[a]),a++);return m.latitude===0&&(m.longitude=x,o[a]=r.cartographicToCartesian(m,o[a]),a++,m.longitude=h,o[a]=r.cartographicToCartesian(m,o[a]),a++),o.length=a,o};iY=new qe;Wo.prototype.contains=function(e){return Wo.contains(this,Wo.southwest(e,iY))&&Wo.contains(this,Wo.northwest(e,iY))&&Wo.contains(this,Wo.southeast(e,iY))&&Wo.contains(this,Wo.northeast(e,iY))};Wo.MAX_VALUE=Object.freeze(new Wo(-Math.PI,-K.PI_OVER_TWO,Math.PI,K.PI_OVER_TWO));He=Wo});function yc(e,r,n,o){this.x=B(e,0),this.y=B(r,0),this.width=B(n,0),this.height=B(o,0)}var Vbt,kbt,Ubt,Ft,vo=Ee(()=>{Fr();Si();cr();Ze();De();iu();Ql();Ni();y(yc,"BoundingRectangle");yc.packedLength=4;yc.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.width,r[n]=e.height,r};yc.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new yc),n.x=e[r++],n.y=e[r++],n.width=e[r++],n.height=e[r],n};yc.fromPoints=function(e,r){if(p(r)||(r=new yc),!p(e)||e.length===0)return r.x=0,r.y=0,r.width=0,r.height=0,r;for(var n=e.length,o=e[0].x,a=e[0].y,s=e[0].x,l=e[0].y,h=1;h<n;h++){var x=e[h],m=x.x,v=x.y;o=Math.min(m,o),s=Math.max(m,s),a=Math.min(v,a),l=Math.max(v,l)}return r.x=o,r.y=a,r.width=s-o,r.height=l-a,r};Vbt=new yo,kbt=new qe,Ubt=new qe;yc.fromRectangle=function(e,r,n){if(p(n)||(n=new yc),!p(e))return n.x=0,n.y=0,n.width=0,n.height=0,n;r=B(r,Vbt);var o=r.project(He.southwest(e,kbt)),a=r.project(He.northeast(e,Ubt));return de.subtract(a,o,a),n.x=o.x,n.y=o.y,n.width=a.x,n.height=a.y,n};yc.clone=function(e,r){if(!!p(e))return p(r)?(r.x=e.x,r.y=e.y,r.width=e.width,r.height=e.height,r):new yc(e.x,e.y,e.width,e.height)};yc.union=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),p(n)||(n=new yc);var o=Math.min(e.x,r.x),a=Math.min(e.y,r.y),s=Math.max(e.x+e.width,r.x+r.width),l=Math.max(e.y+e.height,r.y+r.height);return n.x=o,n.y=a,n.width=s-o,n.height=l-a,n};yc.expand=function(e,r,n){X.typeOf.object("rectangle",e),X.typeOf.object("point",r),n=yc.clone(e,n);var o=r.x-n.x,a=r.y-n.y;return o>n.width?n.width=o:o<0&&(n.width-=o,n.x=r.x),a>n.height?n.height=a:a<0&&(n.height-=a,n.y=r.y),n};yc.intersect=function(e,r){X.typeOf.object("left",e),X.typeOf.object("right",r);var n=e.x,o=e.y,a=r.x,s=r.y;return n>a+r.width||n+e.width<a||o+e.height<s||o>s+r.height?wi.OUTSIDE:wi.INTERSECTING};yc.equals=function(e,r){return e===r||p(e)&&p(r)&&e.x===r.x&&e.y===r.y&&e.width===r.width&&e.height===r.height};yc.prototype.clone=function(e){return yc.clone(this,e)};yc.prototype.intersect=function(e){return yc.intersect(this,e)};yc.prototype.equals=function(e){return yc.equals(this,e)};Ft=yc});function Gbt(e,r){this.start=B(e,0),this.stop=B(r,0)}var Ip,hF=Ee(()=>{Ze();y(Gbt,"Interval");Ip=Gbt});function Pi(e,r,n,o,a,s,l,h,x){this[0]=B(e,0),this[1]=B(o,0),this[2]=B(l,0),this[3]=B(r,0),this[4]=B(a,0),this[5]=B(h,0),this[6]=B(n,0),this[7]=B(s,0),this[8]=B(x,0)}function Wbt(e){for(var r=0,n=0;n<9;++n){var o=e[n];r+=o*o}return Math.sqrt(r)}function qbt(e){for(var r=0,n=0;n<3;++n){var o=e[Pi.getElementIndex(Gxe[n],Uxe[n])];r+=2*o*o}return Math.sqrt(r)}function jbt(e,r){for(var n=K.EPSILON15,o=0,a=1,s=0;s<3;++s){var l=Math.abs(e[Pi.getElementIndex(Gxe[s],Uxe[s])]);l>o&&(a=s,o=l)}var h=1,x=0,m=Uxe[a],v=Gxe[a];if(Math.abs(e[Pi.getElementIndex(v,m)])>n){var _=e[Pi.getElementIndex(v,v)],A=e[Pi.getElementIndex(m,m)],T=e[Pi.getElementIndex(v,m)],w=(_-A)/2/T,S;w<0?S=-1/(-w+Math.sqrt(1+w*w)):S=1/(w+Math.sqrt(1+w*w)),h=1/Math.sqrt(1+S*S),x=S*h}return r=Pi.clone(Pi.IDENTITY,r),r[Pi.getElementIndex(m,m)]=r[Pi.getElementIndex(v,v)]=h,r[Pi.getElementIndex(v,m)]=x,r[Pi.getElementIndex(m,v)]=-x,r}var kxe,oY,Hbt,Uxe,Gxe,nY,C3e,We,to=Ee(()=>{bt();cr();Ze();De();st();nr();y(Pi,"Matrix3");Pi.packedLength=9;Pi.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8],r};Pi.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Pi),n[0]=e[r++],n[1]=e[r++],n[2]=e[r++],n[3]=e[r++],n[4]=e[r++],n[5]=e[r++],n[6]=e[r++],n[7]=e[r++],n[8]=e[r++],n};Pi.clone=function(e,r){if(!!p(e))return p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):new Pi(e[0],e[3],e[6],e[1],e[4],e[7],e[2],e[5],e[8])};Pi.fromArray=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Pi),n[0]=e[r],n[1]=e[r+1],n[2]=e[r+2],n[3]=e[r+3],n[4]=e[r+4],n[5]=e[r+5],n[6]=e[r+6],n[7]=e[r+7],n[8]=e[r+8],n};Pi.fromColumnMajorArray=function(e,r){return X.defined("values",e),Pi.clone(e,r)};Pi.fromRowMajorArray=function(e,r){return X.defined("values",e),p(r)?(r[0]=e[0],r[1]=e[3],r[2]=e[6],r[3]=e[1],r[4]=e[4],r[5]=e[7],r[6]=e[2],r[7]=e[5],r[8]=e[8],r):new Pi(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8])};Pi.fromQuaternion=function(e,r){X.typeOf.object("quaternion",e);var n=e.x*e.x,o=e.x*e.y,a=e.x*e.z,s=e.x*e.w,l=e.y*e.y,h=e.y*e.z,x=e.y*e.w,m=e.z*e.z,v=e.z*e.w,_=e.w*e.w,A=n-l-m+_,T=2*(o-v),w=2*(a+x),S=2*(o+v),P=-n+l-m+_,M=2*(h-s),L=2*(a-x),R=2*(h+s),O=-n-l+m+_;return p(r)?(r[0]=A,r[1]=S,r[2]=L,r[3]=T,r[4]=P,r[5]=R,r[6]=w,r[7]=M,r[8]=O,r):new Pi(A,T,w,S,P,M,L,R,O)};Pi.fromHeadingPitchRoll=function(e,r){X.typeOf.object("headingPitchRoll",e);var n=Math.cos(-e.pitch),o=Math.cos(-e.heading),a=Math.cos(e.roll),s=Math.sin(-e.pitch),l=Math.sin(-e.heading),h=Math.sin(e.roll),x=n*o,m=-a*l+h*s*o,v=h*l+a*s*o,_=n*l,A=a*o+h*s*l,T=-h*o+a*s*l,w=-s,S=h*n,P=a*n;return p(r)?(r[0]=x,r[1]=_,r[2]=w,r[3]=m,r[4]=A,r[5]=S,r[6]=v,r[7]=T,r[8]=P,r):new Pi(x,m,v,_,A,T,w,S,P)};Pi.fromScale=function(e,r){return X.typeOf.object("scale",e),p(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=e.y,r[5]=0,r[6]=0,r[7]=0,r[8]=e.z,r):new Pi(e.x,0,0,0,e.y,0,0,0,e.z)};Pi.fromUniformScale=function(e,r){return X.typeOf.number("scale",e),p(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=e,r[5]=0,r[6]=0,r[7]=0,r[8]=e,r):new Pi(e,0,0,0,e,0,0,0,e)};Pi.fromCrossProduct=function(e,r){return X.typeOf.object("vector",e),p(r)?(r[0]=0,r[1]=e.z,r[2]=-e.y,r[3]=-e.z,r[4]=0,r[5]=e.x,r[6]=e.y,r[7]=-e.x,r[8]=0,r):new Pi(0,-e.z,e.y,e.z,0,-e.x,-e.y,e.x,0)};Pi.fromRotationX=function(e,r){X.typeOf.number("angle",e);var n=Math.cos(e),o=Math.sin(e);return p(r)?(r[0]=1,r[1]=0,r[2]=0,r[3]=0,r[4]=n,r[5]=o,r[6]=0,r[7]=-o,r[8]=n,r):new Pi(1,0,0,0,n,-o,0,o,n)};Pi.fromRotationY=function(e,r){X.typeOf.number("angle",e);var n=Math.cos(e),o=Math.sin(e);return p(r)?(r[0]=n,r[1]=0,r[2]=-o,r[3]=0,r[4]=1,r[5]=0,r[6]=o,r[7]=0,r[8]=n,r):new Pi(n,0,o,0,1,0,-o,0,n)};Pi.fromRotationZ=function(e,r){X.typeOf.number("angle",e);var n=Math.cos(e),o=Math.sin(e);return p(r)?(r[0]=n,r[1]=o,r[2]=0,r[3]=-o,r[4]=n,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new Pi(n,-o,0,o,n,0,0,0,1)};Pi.toArray=function(e,r){return X.typeOf.object("matrix",e),p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8]]};Pi.getElementIndex=function(e,r){return X.typeOf.number.greaterThanOrEquals("row",r,0),X.typeOf.number.lessThanOrEquals("row",r,2),X.typeOf.number.greaterThanOrEquals("column",e,0),X.typeOf.number.lessThanOrEquals("column",e,2),e*3+r};Pi.getColumn=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,2),X.typeOf.object("result",n);var o=r*3,a=e[o],s=e[o+1],l=e[o+2];return n.x=a,n.y=s,n.z=l,n};Pi.setColumn=function(e,r,n,o){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,2),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=Pi.clone(e,o);var a=r*3;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o};Pi.getRow=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,2),X.typeOf.object("result",n);var o=e[r],a=e[r+3],s=e[r+6];return n.x=o,n.y=a,n.z=s,n};Pi.setRow=function(e,r,n,o){return X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,2),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=Pi.clone(e,o),o[r]=n.x,o[r+3]=n.y,o[r+6]=n.z,o};kxe=new E;Pi.getScale=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r.x=E.magnitude(E.fromElements(e[0],e[1],e[2],kxe)),r.y=E.magnitude(E.fromElements(e[3],e[4],e[5],kxe)),r.z=E.magnitude(E.fromElements(e[6],e[7],e[8],kxe)),r};oY=new E;Pi.getMaximumScale=function(e){return Pi.getScale(e,oY),E.maximumComponent(oY)};Pi.multiply=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e[0]*r[0]+e[3]*r[1]+e[6]*r[2],a=e[1]*r[0]+e[4]*r[1]+e[7]*r[2],s=e[2]*r[0]+e[5]*r[1]+e[8]*r[2],l=e[0]*r[3]+e[3]*r[4]+e[6]*r[5],h=e[1]*r[3]+e[4]*r[4]+e[7]*r[5],x=e[2]*r[3]+e[5]*r[4]+e[8]*r[5],m=e[0]*r[6]+e[3]*r[7]+e[6]*r[8],v=e[1]*r[6]+e[4]*r[7]+e[7]*r[8],_=e[2]*r[6]+e[5]*r[7]+e[8]*r[8];return n[0]=o,n[1]=a,n[2]=s,n[3]=l,n[4]=h,n[5]=x,n[6]=m,n[7]=v,n[8]=_,n};Pi.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n};Pi.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n};Pi.multiplyByVector=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("cartesian",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z,l=e[0]*o+e[3]*a+e[6]*s,h=e[1]*o+e[4]*a+e[7]*s,x=e[2]*o+e[5]*a+e[8]*s;return n.x=l,n.y=h,n.z=x,n};Pi.multiplyByScalar=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n};Pi.multiplyByScale=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.object("scale",r),X.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.x,n[3]=e[3]*r.y,n[4]=e[4]*r.y,n[5]=e[5]*r.y,n[6]=e[6]*r.z,n[7]=e[7]*r.z,n[8]=e[8]*r.z,n};Pi.negate=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r};Pi.transpose=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[0],o=e[3],a=e[6],s=e[1],l=e[4],h=e[7],x=e[2],m=e[5],v=e[8];return r[0]=n,r[1]=o,r[2]=a,r[3]=s,r[4]=l,r[5]=h,r[6]=x,r[7]=m,r[8]=v,r};Hbt=new E(1,1,1);Pi.getRotation=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=E.divideComponents(Hbt,Pi.getScale(e,oY),oY);return r=Pi.multiplyByScale(e,n,r),r};y(Wbt,"computeFrobeniusNorm");Uxe=[1,0,0],Gxe=[2,2,1];y(qbt,"offDiagonalFrobeniusNorm");y(jbt,"shurDecomposition");nY=new Pi,C3e=new Pi;Pi.computeEigenDecomposition=function(e,r){X.typeOf.object("matrix",e);var n=K.EPSILON20,o=10,a=0,s=0;p(r)||(r={});for(var l=r.unitary=Pi.clone(Pi.IDENTITY,r.unitary),h=r.diagonal=Pi.clone(e,r.diagonal),x=n*Wbt(h);s<o&&qbt(h)>x;)jbt(h,nY),Pi.transpose(nY,C3e),Pi.multiply(h,nY,h),Pi.multiply(C3e,h,h),Pi.multiply(l,nY,l),++a>2&&(++s,a=0);return r};Pi.abs=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r};Pi.determinant=function(e){X.typeOf.object("matrix",e);var r=e[0],n=e[3],o=e[6],a=e[1],s=e[4],l=e[7],h=e[2],x=e[5],m=e[8];return r*(s*m-x*l)+a*(x*o-n*m)+h*(n*l-s*o)};Pi.inverse=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],s=e[3],l=e[4],h=e[5],x=e[6],m=e[7],v=e[8],_=Pi.determinant(e);if(Math.abs(_)<=K.EPSILON15)throw new G("matrix is not invertible");r[0]=l*v-m*h,r[1]=m*a-o*v,r[2]=o*h-l*a,r[3]=x*h-s*v,r[4]=n*v-x*a,r[5]=s*a-n*h,r[6]=s*m-x*l,r[7]=x*o-n*m,r[8]=n*l-s*o;var A=1/_;return Pi.multiplyByScalar(r,A,r)};Pi.equals=function(e,r){return e===r||p(e)&&p(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[7]===r[7]&&e[8]===r[8]};Pi.equalsEpsilon=function(e,r,n){return X.typeOf.number("epsilon",n),e===r||p(e)&&p(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n};Pi.IDENTITY=Object.freeze(new Pi(1,0,0,0,1,0,0,0,1));Pi.ZERO=Object.freeze(new Pi(0,0,0,0,0,0,0,0,0));Pi.COLUMN0ROW0=0;Pi.COLUMN0ROW1=1;Pi.COLUMN0ROW2=2;Pi.COLUMN1ROW0=3;Pi.COLUMN1ROW1=4;Pi.COLUMN1ROW2=5;Pi.COLUMN2ROW0=6;Pi.COLUMN2ROW1=7;Pi.COLUMN2ROW2=8;Object.defineProperties(Pi.prototype,{length:{get:function(){return Pi.packedLength}}});Pi.prototype.clone=function(e){return Pi.clone(this,e)};Pi.prototype.equals=function(e){return Pi.equals(this,e)};Pi.equalsArray=function(e,r,n){return e[0]===r[n]&&e[1]===r[n+1]&&e[2]===r[n+2]&&e[3]===r[n+3]&&e[4]===r[n+4]&&e[5]===r[n+5]&&e[6]===r[n+6]&&e[7]===r[n+7]&&e[8]===r[n+8]};Pi.prototype.equalsEpsilon=function(e,r){return Pi.equalsEpsilon(this,e,r)};Pi.prototype.toString=function(){return"("+this[0]+", "+this[3]+", "+this[6]+`)
(`+this[1]+", "+this[4]+", "+this[7]+`)
(`+this[2]+", "+this[5]+", "+this[8]+")"};We=Pi});function Wi(e,r,n,o){this.x=B(e,0),this.y=B(r,0),this.z=B(n,0),this.w=B(o,0)}var sY,T3e,Ybt,w3e,aY,Qbt,Xbt,Kbt,Zbt,Jbt,lY,Ce,Ci=Ee(()=>{cr();Ze();De();st();nr();y(Wi,"Cartesian4");Wi.fromElements=function(e,r,n,o,a){return p(a)?(a.x=e,a.y=r,a.z=n,a.w=o,a):new Wi(e,r,n,o)};Wi.fromColor=function(e,r){return X.typeOf.object("color",e),p(r)?(r.x=e.red,r.y=e.green,r.z=e.blue,r.w=e.alpha,r):new Wi(e.red,e.green,e.blue,e.alpha)};Wi.clone=function(e,r){if(!!p(e))return p(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new Wi(e.x,e.y,e.z,e.w)};Wi.packedLength=4;Wi.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r};Wi.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Wi),n.x=e[r++],n.y=e[r++],n.z=e[r++],n.w=e[r],n};Wi.packArray=function(e,r){X.defined("array",e);var n=e.length,o=n*4;if(!p(r))r=new Array(o);else{if(!Array.isArray(r)&&r.length!==o)throw new G("If result is a typed array, it must have exactly array.length * 4 elements");r.length!==o&&(r.length=o)}for(var a=0;a<n;++a)Wi.pack(e[a],r,a*4);return r};Wi.unpackArray=function(e,r){if(X.defined("array",e),X.typeOf.number.greaterThanOrEquals("array.length",e.length,4),e.length%4!==0)throw new G("array length must be a multiple of 4.");var n=e.length;p(r)?r.length=n/4:r=new Array(n/4);for(var o=0;o<n;o+=4){var a=o/4;r[a]=Wi.unpack(e,o,r[a])}return r};Wi.fromArray=Wi.unpack;Wi.maximumComponent=function(e){return X.typeOf.object("cartesian",e),Math.max(e.x,e.y,e.z,e.w)};Wi.minimumComponent=function(e){return X.typeOf.object("cartesian",e),Math.min(e.x,e.y,e.z,e.w)};Wi.minimumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.min(e.x,r.x),n.y=Math.min(e.y,r.y),n.z=Math.min(e.z,r.z),n.w=Math.min(e.w,r.w),n};Wi.maximumByComponent=function(e,r,n){return X.typeOf.object("first",e),X.typeOf.object("second",r),X.typeOf.object("result",n),n.x=Math.max(e.x,r.x),n.y=Math.max(e.y,r.y),n.z=Math.max(e.z,r.z),n.w=Math.max(e.w,r.w),n};Wi.magnitudeSquared=function(e){return X.typeOf.object("cartesian",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w};Wi.magnitude=function(e){return Math.sqrt(Wi.magnitudeSquared(e))};sY=new Wi;Wi.distance=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),Wi.subtract(e,r,sY),Wi.magnitude(sY)};Wi.distanceSquared=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),Wi.subtract(e,r,sY),Wi.magnitudeSquared(sY)};Wi.normalize=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=Wi.magnitude(e);if(r.x=e.x/n,r.y=e.y/n,r.z=e.z/n,r.w=e.w/n,isNaN(r.x)||isNaN(r.y)||isNaN(r.z)||isNaN(r.w))throw new G("normalized result is not a number");return r};Wi.dot=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w};Wi.multiplyComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x*r.x,n.y=e.y*r.y,n.z=e.z*r.z,n.w=e.w*r.w,n};Wi.divideComponents=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x/r.x,n.y=e.y/r.y,n.z=e.z/r.z,n.w=e.w/r.w,n};Wi.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n};Wi.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n};Wi.multiplyByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n};Wi.divideByScalar=function(e,r,n){return X.typeOf.object("cartesian",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n};Wi.negate=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r};Wi.abs=function(e,r){return X.typeOf.object("cartesian",e),X.typeOf.object("result",r),r.x=Math.abs(e.x),r.y=Math.abs(e.y),r.z=Math.abs(e.z),r.w=Math.abs(e.w),r};T3e=new Wi;Wi.lerp=function(e,r,n,o){return X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o),Wi.multiplyByScalar(r,n,T3e),o=Wi.multiplyByScalar(e,1-n,o),Wi.add(T3e,o,o)};Ybt=new Wi;Wi.mostOrthogonalAxis=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=Wi.normalize(e,Ybt);return Wi.abs(n,n),n.x<=n.y?n.x<=n.z?n.x<=n.w?r=Wi.clone(Wi.UNIT_X,r):r=Wi.clone(Wi.UNIT_W,r):n.z<=n.w?r=Wi.clone(Wi.UNIT_Z,r):r=Wi.clone(Wi.UNIT_W,r):n.y<=n.z?n.y<=n.w?r=Wi.clone(Wi.UNIT_Y,r):r=Wi.clone(Wi.UNIT_W,r):n.z<=n.w?r=Wi.clone(Wi.UNIT_Z,r):r=Wi.clone(Wi.UNIT_W,r),r};Wi.equals=function(e,r){return e===r||p(e)&&p(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w};Wi.equalsArray=function(e,r,n){return e.x===r[n]&&e.y===r[n+1]&&e.z===r[n+2]&&e.w===r[n+3]};Wi.equalsEpsilon=function(e,r,n,o){return e===r||p(e)&&p(r)&&K.equalsEpsilon(e.x,r.x,n,o)&&K.equalsEpsilon(e.y,r.y,n,o)&&K.equalsEpsilon(e.z,r.z,n,o)&&K.equalsEpsilon(e.w,r.w,n,o)};Wi.ZERO=Object.freeze(new Wi(0,0,0,0));Wi.UNIT_X=Object.freeze(new Wi(1,0,0,0));Wi.UNIT_Y=Object.freeze(new Wi(0,1,0,0));Wi.UNIT_Z=Object.freeze(new Wi(0,0,1,0));Wi.UNIT_W=Object.freeze(new Wi(0,0,0,1));Wi.prototype.clone=function(e){return Wi.clone(this,e)};Wi.prototype.equals=function(e){return Wi.equals(this,e)};Wi.prototype.equalsEpsilon=function(e,r,n){return Wi.equalsEpsilon(this,e,r,n)};Wi.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};w3e=new Float32Array(1),aY=256,Qbt=65536,Xbt=16777216,Kbt=1/aY,Zbt=1/Qbt,Jbt=1/Xbt,lY=38;Wi.packFloat=function(e,r){if(X.typeOf.number("value",e),p(r)||(r=new Wi),w3e[0]=e,e=w3e[0],e===0)return Wi.clone(Wi.ZERO,r);var n=e<0?1:0,o;isFinite(e)?(e=Math.abs(e),o=Math.floor(K.logBase(e,10))+1,e=e/Math.pow(10,o)):(e=.1,o=lY);var a=e*aY;return r.x=Math.floor(a),a=(a-r.x)*aY,r.y=Math.floor(a),a=(a-r.y)*aY,r.z=Math.floor(a),r.w=(o+lY)*2+n,r};Wi.unpackFloat=function(e){X.typeOf.object("packedFloat",e);var r=e.w/2,n=Math.floor(r),o=(r-n)*2;if(n=n-lY,o=o*2-1,o=-o,n>=lY)return o<0?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY;var a=o*e.x*Kbt;return a+=o*e.y*Zbt,a+=o*e.z*Jbt,a*Math.pow(10,n)};Ce=Wi});function eH(e){this.name="RuntimeError",this.message=e;var r;try{throw new Error}catch(n){r=n.stack}this.stack=r}var Ht,zo=Ee(()=>{De();y(eH,"RuntimeError");p(Object.create)&&(eH.prototype=Object.create(Error.prototype),eH.prototype.constructor=eH);eH.prototype.toString=function(){var e=this.name+": "+this.message;return p(this.stack)&&(e+=`
`+this.stack.toString()),e};Ht=eH});function _i(e,r,n,o,a,s,l,h,x,m,v,_,A,T,w,S){this[0]=B(e,0),this[1]=B(a,0),this[2]=B(x,0),this[3]=B(A,0),this[4]=B(r,0),this[5]=B(s,0),this[6]=B(m,0),this[7]=B(T,0),this[8]=B(n,0),this[9]=B(l,0),this[10]=B(v,0),this[11]=B(w,0),this[12]=B(o,0),this[13]=B(h,0),this[14]=B(_,0),this[15]=B(S,0)}var dF,mF,tH,E3e,Hxe,b3e,uY,$bt,eSt,tSt,rSt,Z,Rr=Ee(()=>{bt();Ci();cr();Ze();De();nr();to();zo();y(_i,"Matrix4");_i.packedLength=16;_i.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r[n++]=e[4],r[n++]=e[5],r[n++]=e[6],r[n++]=e[7],r[n++]=e[8],r[n++]=e[9],r[n++]=e[10],r[n++]=e[11],r[n++]=e[12],r[n++]=e[13],r[n++]=e[14],r[n]=e[15],r};_i.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new _i),n[0]=e[r++],n[1]=e[r++],n[2]=e[r++],n[3]=e[r++],n[4]=e[r++],n[5]=e[r++],n[6]=e[r++],n[7]=e[r++],n[8]=e[r++],n[9]=e[r++],n[10]=e[r++],n[11]=e[r++],n[12]=e[r++],n[13]=e[r++],n[14]=e[r++],n[15]=e[r],n};_i.clone=function(e,r){if(!!p(e))return p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):new _i(e[0],e[4],e[8],e[12],e[1],e[5],e[9],e[13],e[2],e[6],e[10],e[14],e[3],e[7],e[11],e[15])};_i.fromArray=_i.unpack;_i.fromColumnMajorArray=function(e,r){return X.defined("values",e),_i.clone(e,r)};_i.fromRowMajorArray=function(e,r){return X.defined("values",e),p(r)?(r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=e[1],r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=e[2],r[9]=e[6],r[10]=e[10],r[11]=e[14],r[12]=e[3],r[13]=e[7],r[14]=e[11],r[15]=e[15],r):new _i(e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15])};_i.fromRotationTranslation=function(e,r,n){return X.typeOf.object("rotation",e),r=B(r,E.ZERO),p(n)?(n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=0,n[4]=e[3],n[5]=e[4],n[6]=e[5],n[7]=0,n[8]=e[6],n[9]=e[7],n[10]=e[8],n[11]=0,n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=1,n):new _i(e[0],e[3],e[6],r.x,e[1],e[4],e[7],r.y,e[2],e[5],e[8],r.z,0,0,0,1)};_i.fromTranslationQuaternionRotationScale=function(e,r,n,o){X.typeOf.object("translation",e),X.typeOf.object("rotation",r),X.typeOf.object("scale",n),p(o)||(o=new _i);var a=n.x,s=n.y,l=n.z,h=r.x*r.x,x=r.x*r.y,m=r.x*r.z,v=r.x*r.w,_=r.y*r.y,A=r.y*r.z,T=r.y*r.w,w=r.z*r.z,S=r.z*r.w,P=r.w*r.w,M=h-_-w+P,L=2*(x-S),R=2*(m+T),O=2*(x+S),N=-h+_-w+P,k=2*(A-v),z=2*(m-T),W=2*(A+v),j=-h-_+w+P;return o[0]=M*a,o[1]=O*a,o[2]=z*a,o[3]=0,o[4]=L*s,o[5]=N*s,o[6]=W*s,o[7]=0,o[8]=R*l,o[9]=k*l,o[10]=j*l,o[11]=0,o[12]=e.x,o[13]=e.y,o[14]=e.z,o[15]=1,o};_i.fromTranslationRotationScale=function(e,r){return X.typeOf.object("translationRotationScale",e),_i.fromTranslationQuaternionRotationScale(e.translation,e.rotation,e.scale,r)};_i.fromTranslation=function(e,r){return X.typeOf.object("translation",e),_i.fromRotationTranslation(We.IDENTITY,e,r)};_i.fromScale=function(e,r){return X.typeOf.object("scale",e),p(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e.y,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e.z,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new _i(e.x,0,0,0,0,e.y,0,0,0,0,e.z,0,0,0,0,1)};_i.fromUniformScale=function(e,r){return X.typeOf.number("scale",e),p(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=e,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=e,r[11]=0,r[12]=0,r[13]=0,r[14]=0,r[15]=1,r):new _i(e,0,0,0,0,e,0,0,0,0,e,0,0,0,0,1)};dF=new E,mF=new E,tH=new E;_i.fromCamera=function(e,r){X.typeOf.object("camera",e);var n=e.position,o=e.direction,a=e.up;X.typeOf.object("camera.position",n),X.typeOf.object("camera.direction",o),X.typeOf.object("camera.up",a),E.normalize(o,dF),E.normalize(E.cross(dF,a,mF),mF),E.normalize(E.cross(mF,dF,tH),tH);var s=mF.x,l=mF.y,h=mF.z,x=dF.x,m=dF.y,v=dF.z,_=tH.x,A=tH.y,T=tH.z,w=n.x,S=n.y,P=n.z,M=s*-w+l*-S+h*-P,L=_*-w+A*-S+T*-P,R=x*w+m*S+v*P;return p(r)?(r[0]=s,r[1]=_,r[2]=-x,r[3]=0,r[4]=l,r[5]=A,r[6]=-m,r[7]=0,r[8]=h,r[9]=T,r[10]=-v,r[11]=0,r[12]=M,r[13]=L,r[14]=R,r[15]=1,r):new _i(s,l,h,M,_,A,T,L,-x,-m,-v,R,0,0,0,1)};_i.computePerspectiveFieldOfView=function(e,r,n,o,a){X.typeOf.number.greaterThan("fovY",e,0),X.typeOf.number.lessThan("fovY",e,Math.PI),X.typeOf.number.greaterThan("near",n,0),X.typeOf.number.greaterThan("far",o,0),X.typeOf.object("result",a);var s=Math.tan(e*.5),l=1/s,h=l/r,x=(o+n)/(n-o),m=2*o*n/(n-o);return a[0]=h,a[1]=0,a[2]=0,a[3]=0,a[4]=0,a[5]=l,a[6]=0,a[7]=0,a[8]=0,a[9]=0,a[10]=x,a[11]=-1,a[12]=0,a[13]=0,a[14]=m,a[15]=0,a};_i.computeOrthographicOffCenter=function(e,r,n,o,a,s,l){X.typeOf.number("left",e),X.typeOf.number("right",r),X.typeOf.number("bottom",n),X.typeOf.number("top",o),X.typeOf.number("near",a),X.typeOf.number("far",s),X.typeOf.object("result",l);var h=1/(r-e),x=1/(o-n),m=1/(s-a),v=-(r+e)*h,_=-(o+n)*x,A=-(s+a)*m;return h*=2,x*=2,m*=-2,l[0]=h,l[1]=0,l[2]=0,l[3]=0,l[4]=0,l[5]=x,l[6]=0,l[7]=0,l[8]=0,l[9]=0,l[10]=m,l[11]=0,l[12]=v,l[13]=_,l[14]=A,l[15]=1,l};_i.computePerspectiveOffCenter=function(e,r,n,o,a,s,l){X.typeOf.number("left",e),X.typeOf.number("right",r),X.typeOf.number("bottom",n),X.typeOf.number("top",o),X.typeOf.number("near",a),X.typeOf.number("far",s),X.typeOf.object("result",l);var h=2*a/(r-e),x=2*a/(o-n),m=(r+e)/(r-e),v=(o+n)/(o-n),_=-(s+a)/(s-a),A=-1,T=-2*s*a/(s-a);return l[0]=h,l[1]=0,l[2]=0,l[3]=0,l[4]=0,l[5]=x,l[6]=0,l[7]=0,l[8]=m,l[9]=v,l[10]=_,l[11]=A,l[12]=0,l[13]=0,l[14]=T,l[15]=0,l};_i.computeInfinitePerspectiveOffCenter=function(e,r,n,o,a,s){X.typeOf.number("left",e),X.typeOf.number("right",r),X.typeOf.number("bottom",n),X.typeOf.number("top",o),X.typeOf.number("near",a),X.typeOf.object("result",s);var l=2*a/(r-e),h=2*a/(o-n),x=(r+e)/(r-e),m=(o+n)/(o-n),v=-1,_=-1,A=-2*a;return s[0]=l,s[1]=0,s[2]=0,s[3]=0,s[4]=0,s[5]=h,s[6]=0,s[7]=0,s[8]=x,s[9]=m,s[10]=v,s[11]=_,s[12]=0,s[13]=0,s[14]=A,s[15]=0,s};_i.computeViewportTransformation=function(e,r,n,o){X.typeOf.object("result",o),e=B(e,B.EMPTY_OBJECT);var a=B(e.x,0),s=B(e.y,0),l=B(e.width,0),h=B(e.height,0);r=B(r,0),n=B(n,1);var x=l*.5,m=h*.5,v=(n-r)*.5,_=x,A=m,T=v,w=a+x,S=s+m,P=r+v,M=1;return o[0]=_,o[1]=0,o[2]=0,o[3]=0,o[4]=0,o[5]=A,o[6]=0,o[7]=0,o[8]=0,o[9]=0,o[10]=T,o[11]=0,o[12]=w,o[13]=S,o[14]=P,o[15]=M,o};_i.computeView=function(e,r,n,o,a){return X.typeOf.object("position",e),X.typeOf.object("direction",r),X.typeOf.object("up",n),X.typeOf.object("right",o),X.typeOf.object("result",a),a[0]=o.x,a[1]=n.x,a[2]=-r.x,a[3]=0,a[4]=o.y,a[5]=n.y,a[6]=-r.y,a[7]=0,a[8]=o.z,a[9]=n.z,a[10]=-r.z,a[11]=0,a[12]=-E.dot(o,e),a[13]=-E.dot(n,e),a[14]=E.dot(r,e),a[15]=1,a};_i.toArray=function(e,r){return X.typeOf.object("matrix",e),p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r[4]=e[4],r[5]=e[5],r[6]=e[6],r[7]=e[7],r[8]=e[8],r[9]=e[9],r[10]=e[10],r[11]=e[11],r[12]=e[12],r[13]=e[13],r[14]=e[14],r[15]=e[15],r):[e[0],e[1],e[2],e[3],e[4],e[5],e[6],e[7],e[8],e[9],e[10],e[11],e[12],e[13],e[14],e[15]]};_i.getElementIndex=function(e,r){return X.typeOf.number.greaterThanOrEquals("row",r,0),X.typeOf.number.lessThanOrEquals("row",r,3),X.typeOf.number.greaterThanOrEquals("column",e,0),X.typeOf.number.lessThanOrEquals("column",e,3),e*4+r};_i.getColumn=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,3),X.typeOf.object("result",n);var o=r*4,a=e[o],s=e[o+1],l=e[o+2],h=e[o+3];return n.x=a,n.y=s,n.z=l,n.w=h,n};_i.setColumn=function(e,r,n,o){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,3),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=_i.clone(e,o);var a=r*4;return o[a]=n.x,o[a+1]=n.y,o[a+2]=n.z,o[a+3]=n.w,o};_i.setTranslation=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.object("translation",r),X.typeOf.object("result",n),n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=r.x,n[13]=r.y,n[14]=r.z,n[15]=e[15],n};E3e=new E;_i.setScale=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("scale",r),X.typeOf.object("result",n);var o=_i.getScale(e,E3e),a=E.divideComponents(r,o,E3e);return _i.multiplyByScale(e,a,n)};_i.getRow=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,3),X.typeOf.object("result",n);var o=e[r],a=e[r+4],s=e[r+8],l=e[r+12];return n.x=o,n.y=a,n.z=s,n.w=l,n};_i.setRow=function(e,r,n,o){return X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,3),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=_i.clone(e,o),o[r]=n.x,o[r+4]=n.y,o[r+8]=n.z,o[r+12]=n.w,o};Hxe=new E;_i.getScale=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r.x=E.magnitude(E.fromElements(e[0],e[1],e[2],Hxe)),r.y=E.magnitude(E.fromElements(e[4],e[5],e[6],Hxe)),r.z=E.magnitude(E.fromElements(e[8],e[9],e[10],Hxe)),r};b3e=new E;_i.getMaximumScale=function(e){return _i.getScale(e,b3e),E.maximumComponent(b3e)};_i.multiply=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e[0],a=e[1],s=e[2],l=e[3],h=e[4],x=e[5],m=e[6],v=e[7],_=e[8],A=e[9],T=e[10],w=e[11],S=e[12],P=e[13],M=e[14],L=e[15],R=r[0],O=r[1],N=r[2],k=r[3],z=r[4],W=r[5],j=r[6],q=r[7],I=r[8],F=r[9],V=r[10],U=r[11],Q=r[12],J=r[13],oe=r[14],$=r[15],re=o*R+h*O+_*N+S*k,ne=a*R+x*O+A*N+P*k,le=s*R+m*O+T*N+M*k,ue=l*R+v*O+w*N+L*k,ie=o*z+h*W+_*j+S*q,ce=a*z+x*W+A*j+P*q,he=s*z+m*W+T*j+M*q,_e=l*z+v*W+w*j+L*q,Ae=o*I+h*F+_*V+S*U,be=a*I+x*F+A*V+P*U,pe=s*I+m*F+T*V+M*U,ge=l*I+v*F+w*V+L*U,Te=o*Q+h*J+_*oe+S*$,Pe=a*Q+x*J+A*oe+P*$,ye=s*Q+m*J+T*oe+M*$,ve=l*Q+v*J+w*oe+L*$;return n[0]=re,n[1]=ne,n[2]=le,n[3]=ue,n[4]=ie,n[5]=ce,n[6]=he,n[7]=_e,n[8]=Ae,n[9]=be,n[10]=pe,n[11]=ge,n[12]=Te,n[13]=Pe,n[14]=ye,n[15]=ve,n};_i.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n[4]=e[4]+r[4],n[5]=e[5]+r[5],n[6]=e[6]+r[6],n[7]=e[7]+r[7],n[8]=e[8]+r[8],n[9]=e[9]+r[9],n[10]=e[10]+r[10],n[11]=e[11]+r[11],n[12]=e[12]+r[12],n[13]=e[13]+r[13],n[14]=e[14]+r[14],n[15]=e[15]+r[15],n};_i.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n[4]=e[4]-r[4],n[5]=e[5]-r[5],n[6]=e[6]-r[6],n[7]=e[7]-r[7],n[8]=e[8]-r[8],n[9]=e[9]-r[9],n[10]=e[10]-r[10],n[11]=e[11]-r[11],n[12]=e[12]-r[12],n[13]=e[13]-r[13],n[14]=e[14]-r[14],n[15]=e[15]-r[15],n};_i.multiplyTransformation=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e[0],a=e[1],s=e[2],l=e[4],h=e[5],x=e[6],m=e[8],v=e[9],_=e[10],A=e[12],T=e[13],w=e[14],S=r[0],P=r[1],M=r[2],L=r[4],R=r[5],O=r[6],N=r[8],k=r[9],z=r[10],W=r[12],j=r[13],q=r[14],I=o*S+l*P+m*M,F=a*S+h*P+v*M,V=s*S+x*P+_*M,U=o*L+l*R+m*O,Q=a*L+h*R+v*O,J=s*L+x*R+_*O,oe=o*N+l*k+m*z,$=a*N+h*k+v*z,re=s*N+x*k+_*z,ne=o*W+l*j+m*q+A,le=a*W+h*j+v*q+T,ue=s*W+x*j+_*q+w;return n[0]=I,n[1]=F,n[2]=V,n[3]=0,n[4]=U,n[5]=Q,n[6]=J,n[7]=0,n[8]=oe,n[9]=$,n[10]=re,n[11]=0,n[12]=ne,n[13]=le,n[14]=ue,n[15]=1,n};_i.multiplyByMatrix3=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("rotation",r),X.typeOf.object("result",n);var o=e[0],a=e[1],s=e[2],l=e[4],h=e[5],x=e[6],m=e[8],v=e[9],_=e[10],A=r[0],T=r[1],w=r[2],S=r[3],P=r[4],M=r[5],L=r[6],R=r[7],O=r[8],N=o*A+l*T+m*w,k=a*A+h*T+v*w,z=s*A+x*T+_*w,W=o*S+l*P+m*M,j=a*S+h*P+v*M,q=s*S+x*P+_*M,I=o*L+l*R+m*O,F=a*L+h*R+v*O,V=s*L+x*R+_*O;return n[0]=N,n[1]=k,n[2]=z,n[3]=0,n[4]=W,n[5]=j,n[6]=q,n[7]=0,n[8]=I,n[9]=F,n[10]=V,n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=e[15],n};_i.multiplyByTranslation=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("translation",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z,l=o*e[0]+a*e[4]+s*e[8]+e[12],h=o*e[1]+a*e[5]+s*e[9]+e[13],x=o*e[2]+a*e[6]+s*e[10]+e[14];return n[0]=e[0],n[1]=e[1],n[2]=e[2],n[3]=e[3],n[4]=e[4],n[5]=e[5],n[6]=e[6],n[7]=e[7],n[8]=e[8],n[9]=e[9],n[10]=e[10],n[11]=e[11],n[12]=l,n[13]=h,n[14]=x,n[15]=e[15],n};uY=new E;_i.multiplyByUniformScale=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.number("scale",r),X.typeOf.object("result",n),uY.x=r,uY.y=r,uY.z=r,_i.multiplyByScale(e,uY,n)};_i.multiplyByScale=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("scale",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z;return o===1&&a===1&&s===1?_i.clone(e,n):(n[0]=o*e[0],n[1]=o*e[1],n[2]=o*e[2],n[3]=0,n[4]=a*e[4],n[5]=a*e[5],n[6]=a*e[6],n[7]=0,n[8]=s*e[8],n[9]=s*e[9],n[10]=s*e[10],n[11]=0,n[12]=e[12],n[13]=e[13],n[14]=e[14],n[15]=1,n)};_i.multiplyByVector=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("cartesian",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z,l=r.w,h=e[0]*o+e[4]*a+e[8]*s+e[12]*l,x=e[1]*o+e[5]*a+e[9]*s+e[13]*l,m=e[2]*o+e[6]*a+e[10]*s+e[14]*l,v=e[3]*o+e[7]*a+e[11]*s+e[15]*l;return n.x=h,n.y=x,n.z=m,n.w=v,n};_i.multiplyByPointAsVector=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("cartesian",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z,l=e[0]*o+e[4]*a+e[8]*s,h=e[1]*o+e[5]*a+e[9]*s,x=e[2]*o+e[6]*a+e[10]*s;return n.x=l,n.y=h,n.z=x,n};_i.multiplyByPoint=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("cartesian",r),X.typeOf.object("result",n);var o=r.x,a=r.y,s=r.z,l=e[0]*o+e[4]*a+e[8]*s+e[12],h=e[1]*o+e[5]*a+e[9]*s+e[13],x=e[2]*o+e[6]*a+e[10]*s+e[14];return n.x=l,n.y=h,n.z=x,n};_i.multiplyByScalar=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n[4]=e[4]*r,n[5]=e[5]*r,n[6]=e[6]*r,n[7]=e[7]*r,n[8]=e[8]*r,n[9]=e[9]*r,n[10]=e[10]*r,n[11]=e[11]*r,n[12]=e[12]*r,n[13]=e[13]*r,n[14]=e[14]*r,n[15]=e[15]*r,n};_i.multiplyByPlane=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("plane",r),X.typeOf.object("result",n);var o=new _i,a=new _i;_i.inverse(e,o),_i.transpose(o,a);var s=new Ce(r.normal.x,r.normal.y,r.normal.z,r.distance);_i.multiplyByVector(a,s,s),n.normal.x=s.x,n.normal.y=s.y,n.normal.z=s.z;var l=E.magnitude(n.normal);return E.normalize(n.normal,n.normal),n.distance=s.w/l,n};_i.negate=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r[4]=-e[4],r[5]=-e[5],r[6]=-e[6],r[7]=-e[7],r[8]=-e[8],r[9]=-e[9],r[10]=-e[10],r[11]=-e[11],r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=-e[15],r};_i.transpose=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[1],o=e[2],a=e[3],s=e[6],l=e[7],h=e[11];return r[0]=e[0],r[1]=e[4],r[2]=e[8],r[3]=e[12],r[4]=n,r[5]=e[5],r[6]=e[9],r[7]=e[13],r[8]=o,r[9]=s,r[10]=e[10],r[11]=e[14],r[12]=a,r[13]=l,r[14]=h,r[15]=e[15],r};_i.abs=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r[4]=Math.abs(e[4]),r[5]=Math.abs(e[5]),r[6]=Math.abs(e[6]),r[7]=Math.abs(e[7]),r[8]=Math.abs(e[8]),r[9]=Math.abs(e[9]),r[10]=Math.abs(e[10]),r[11]=Math.abs(e[11]),r[12]=Math.abs(e[12]),r[13]=Math.abs(e[13]),r[14]=Math.abs(e[14]),r[15]=Math.abs(e[15]),r};_i.equals=function(e,r){return e===r||p(e)&&p(r)&&e[12]===r[12]&&e[13]===r[13]&&e[14]===r[14]&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[4]===r[4]&&e[5]===r[5]&&e[6]===r[6]&&e[8]===r[8]&&e[9]===r[9]&&e[10]===r[10]&&e[3]===r[3]&&e[7]===r[7]&&e[11]===r[11]&&e[15]===r[15]};_i.equalsEpsilon=function(e,r,n){return X.typeOf.number("epsilon",n),e===r||p(e)&&p(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n&&Math.abs(e[4]-r[4])<=n&&Math.abs(e[5]-r[5])<=n&&Math.abs(e[6]-r[6])<=n&&Math.abs(e[7]-r[7])<=n&&Math.abs(e[8]-r[8])<=n&&Math.abs(e[9]-r[9])<=n&&Math.abs(e[10]-r[10])<=n&&Math.abs(e[11]-r[11])<=n&&Math.abs(e[12]-r[12])<=n&&Math.abs(e[13]-r[13])<=n&&Math.abs(e[14]-r[14])<=n&&Math.abs(e[15]-r[15])<=n};_i.getTranslation=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r.x=e[12],r.y=e[13],r.z=e[14],r};_i.getMatrix3=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};_i.getRotation=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[4],r[4]=e[5],r[5]=e[6],r[6]=e[8],r[7]=e[9],r[8]=e[10],r};$bt=new We,eSt=new We,tSt=new Ce,rSt=new Ce(0,0,0,1);_i.inverse=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[0],o=e[4],a=e[8],s=e[12],l=e[1],h=e[5],x=e[9],m=e[13],v=e[2],_=e[6],A=e[10],T=e[14],w=e[3],S=e[7],P=e[11],M=e[15],L=A*M,R=T*P,O=_*M,N=T*S,k=_*P,z=A*S,W=v*M,j=T*w,q=v*P,I=A*w,F=v*S,V=_*w,U=L*h+N*x+k*m-(R*h+O*x+z*m),Q=R*l+W*x+I*m-(L*l+j*x+q*m),J=O*l+j*h+F*m-(N*l+W*h+V*m),oe=z*l+q*h+V*x-(k*l+I*h+F*x),$=R*o+O*a+z*s-(L*o+N*a+k*s),re=L*n+j*a+q*s-(R*n+W*a+I*s),ne=N*n+W*o+V*s-(O*n+j*o+F*s),le=k*n+I*o+F*a-(z*n+q*o+V*a);L=a*m,R=s*x,O=o*m,N=s*h,k=o*x,z=a*h,W=n*m,j=s*l,q=n*x,I=a*l,F=n*h,V=o*l;var ue=L*S+N*P+k*M-(R*S+O*P+z*M),ie=R*w+W*P+I*M-(L*w+j*P+q*M),ce=O*w+j*S+F*M-(N*w+W*S+V*M),he=z*w+q*S+V*P-(k*w+I*S+F*P),_e=O*A+z*T+R*_-(k*T+L*_+N*A),Ae=q*T+L*v+j*A-(W*A+I*T+R*v),be=W*_+V*T+N*v-(F*T+O*v+j*_),pe=F*A+k*v+I*_-(q*_+V*A+z*v),ge=n*U+o*Q+a*J+s*oe;if(Math.abs(ge)<K.EPSILON21){if(We.equalsEpsilon(_i.getRotation(e,$bt),eSt,K.EPSILON5)&&Ce.equals(_i.getRow(e,3,tSt),rSt))return r[0]=0,r[1]=0,r[2]=0,r[3]=0,r[4]=0,r[5]=0,r[6]=0,r[7]=0,r[8]=0,r[9]=0,r[10]=0,r[11]=0,r[12]=-e[12],r[13]=-e[13],r[14]=-e[14],r[15]=1,r;throw new Ht("matrix is not invertible because its determinate is zero.")}return ge=1/ge,r[0]=U*ge,r[1]=Q*ge,r[2]=J*ge,r[3]=oe*ge,r[4]=$*ge,r[5]=re*ge,r[6]=ne*ge,r[7]=le*ge,r[8]=ue*ge,r[9]=ie*ge,r[10]=ce*ge,r[11]=he*ge,r[12]=_e*ge,r[13]=Ae*ge,r[14]=be*ge,r[15]=pe*ge,r};_i.inverseTransformation=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[0],o=e[1],a=e[2],s=e[4],l=e[5],h=e[6],x=e[8],m=e[9],v=e[10],_=e[12],A=e[13],T=e[14],w=-n*_-o*A-a*T,S=-s*_-l*A-h*T,P=-x*_-m*A-v*T;return r[0]=n,r[1]=s,r[2]=x,r[3]=0,r[4]=o,r[5]=l,r[6]=m,r[7]=0,r[8]=a,r[9]=h,r[10]=v,r[11]=0,r[12]=w,r[13]=S,r[14]=P,r[15]=1,r};_i.IDENTITY=Object.freeze(new _i(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1));_i.ZERO=Object.freeze(new _i(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0));_i.COLUMN0ROW0=0;_i.COLUMN0ROW1=1;_i.COLUMN0ROW2=2;_i.COLUMN0ROW3=3;_i.COLUMN1ROW0=4;_i.COLUMN1ROW1=5;_i.COLUMN1ROW2=6;_i.COLUMN1ROW3=7;_i.COLUMN2ROW0=8;_i.COLUMN2ROW1=9;_i.COLUMN2ROW2=10;_i.COLUMN2ROW3=11;_i.COLUMN3ROW0=12;_i.COLUMN3ROW1=13;_i.COLUMN3ROW2=14;_i.COLUMN3ROW3=15;Object.defineProperties(_i.prototype,{length:{get:function(){return _i.packedLength}}});_i.prototype.clone=function(e){return _i.clone(this,e)};_i.prototype.equals=function(e){return _i.equals(this,e)};_i.equalsArray=function(e,r,n){return e[0]===r[n]&&e[1]===r[n+1]&&e[2]===r[n+2]&&e[3]===r[n+3]&&e[4]===r[n+4]&&e[5]===r[n+5]&&e[6]===r[n+6]&&e[7]===r[n+7]&&e[8]===r[n+8]&&e[9]===r[n+9]&&e[10]===r[n+10]&&e[11]===r[n+11]&&e[12]===r[n+12]&&e[13]===r[n+13]&&e[14]===r[n+14]&&e[15]===r[n+15]};_i.prototype.equalsEpsilon=function(e,r){return _i.equalsEpsilon(this,e,r)};_i.prototype.toString=function(){return"("+this[0]+", "+this[4]+", "+this[8]+", "+this[12]+`)
(`+this[1]+", "+this[5]+", "+this[9]+", "+this[13]+`)
(`+this[2]+", "+this[6]+", "+this[10]+", "+this[14]+`)
(`+this[3]+", "+this[7]+", "+this[11]+", "+this[15]+")"};Z=_i});function Lo(e,r){this.center=E.clone(B(e,E.ZERO)),this.radius=B(r,0)}var jxe,Yxe,Qxe,Xxe,Kxe,Zxe,Jxe,$x,$xe,ehe,the,rhe,iSt,nSt,oSt,aSt,Wxe,qxe,sSt,lSt,uSt,cSt,fSt,xSt,hSt,dSt,mSt,pSt,S3e,vSt,gSt,_St,ySt,ASt,I3e,cY,CSt,Ue,hi=Ee(()=>{bt();Si();cr();Ze();De();Ii();iu();Ql();hF();nr();to();Rr();Ni();y(Lo,"BoundingSphere");jxe=new E,Yxe=new E,Qxe=new E,Xxe=new E,Kxe=new E,Zxe=new E,Jxe=new E,$x=new E,$xe=new E,ehe=new E,the=new E,rhe=new E,iSt=4/3*K.PI;Lo.fromPoints=function(e,r){if(p(r)||(r=new Lo),!p(e)||e.length===0)return r.center=E.clone(E.ZERO,r.center),r.radius=0,r;var n=E.clone(e[0],Jxe),o=E.clone(n,jxe),a=E.clone(n,Yxe),s=E.clone(n,Qxe),l=E.clone(n,Xxe),h=E.clone(n,Kxe),x=E.clone(n,Zxe),m=e.length,v;for(v=1;v<m;v++){E.clone(e[v],n);var _=n.x,A=n.y,T=n.z;_<o.x&&E.clone(n,o),_>l.x&&E.clone(n,l),A<a.y&&E.clone(n,a),A>h.y&&E.clone(n,h),T<s.z&&E.clone(n,s),T>x.z&&E.clone(n,x)}var w=E.magnitudeSquared(E.subtract(l,o,$x)),S=E.magnitudeSquared(E.subtract(h,a,$x)),P=E.magnitudeSquared(E.subtract(x,s,$x)),M=o,L=l,R=w;S>R&&(R=S,M=a,L=h),P>R&&(R=P,M=s,L=x);var O=$xe;O.x=(M.x+L.x)*.5,O.y=(M.y+L.y)*.5,O.z=(M.z+L.z)*.5;var N=E.magnitudeSquared(E.subtract(L,O,$x)),k=Math.sqrt(N),z=ehe;z.x=o.x,z.y=a.y,z.z=s.z;var W=the;W.x=l.x,W.y=h.y,W.z=x.z;var j=E.midpoint(z,W,rhe),q=0;for(v=0;v<m;v++){E.clone(e[v],n);var I=E.magnitude(E.subtract(n,j,$x));I>q&&(q=I);var F=E.magnitudeSquared(E.subtract(n,O,$x));if(F>N){var V=Math.sqrt(F);k=(k+V)*.5,N=k*k;var U=V-k;O.x=(k*O.x+U*n.x)/V,O.y=(k*O.y+U*n.y)/V,O.z=(k*O.z+U*n.z)/V}}return k<q?(E.clone(O,r.center),r.radius=k):(E.clone(j,r.center),r.radius=q),r};nSt=new yo,oSt=new E,aSt=new E,Wxe=new qe,qxe=new qe;Lo.fromRectangle2D=function(e,r,n){return Lo.fromRectangleWithHeights2D(e,r,0,0,n)};Lo.fromRectangleWithHeights2D=function(e,r,n,o,a){if(p(a)||(a=new Lo),!p(e))return a.center=E.clone(E.ZERO,a.center),a.radius=0,a;r=B(r,nSt),He.southwest(e,Wxe),Wxe.height=n,He.northeast(e,qxe),qxe.height=o;var s=r.project(Wxe,oSt),l=r.project(qxe,aSt),h=l.x-s.x,x=l.y-s.y,m=l.z-s.z;a.radius=Math.sqrt(h*h+x*x+m*m)*.5;var v=a.center;return v.x=s.x+h*.5,v.y=s.y+x*.5,v.z=s.z+m*.5,a};sSt=[];Lo.fromRectangle3D=function(e,r,n,o){if(r=B(r,nt.WGS84),n=B(n,0),p(o)||(o=new Lo),!p(e))return o.center=E.clone(E.ZERO,o.center),o.radius=0,o;var a=He.subsample(e,r,n,sSt);return Lo.fromPoints(a,o)};Lo.fromVertices=function(e,r,n,o){if(p(o)||(o=new Lo),!p(e)||e.length===0)return o.center=E.clone(E.ZERO,o.center),o.radius=0,o;r=B(r,E.ZERO),n=B(n,3),X.typeOf.number.greaterThanOrEquals("stride",n,3);var a=Jxe;a.x=e[0]+r.x,a.y=e[1]+r.y,a.z=e[2]+r.z;var s=E.clone(a,jxe),l=E.clone(a,Yxe),h=E.clone(a,Qxe),x=E.clone(a,Xxe),m=E.clone(a,Kxe),v=E.clone(a,Zxe),_=e.length,A;for(A=0;A<_;A+=n){var T=e[A]+r.x,w=e[A+1]+r.y,S=e[A+2]+r.z;a.x=T,a.y=w,a.z=S,T<s.x&&E.clone(a,s),T>x.x&&E.clone(a,x),w<l.y&&E.clone(a,l),w>m.y&&E.clone(a,m),S<h.z&&E.clone(a,h),S>v.z&&E.clone(a,v)}var P=E.magnitudeSquared(E.subtract(x,s,$x)),M=E.magnitudeSquared(E.subtract(m,l,$x)),L=E.magnitudeSquared(E.subtract(v,h,$x)),R=s,O=x,N=P;M>N&&(N=M,R=l,O=m),L>N&&(N=L,R=h,O=v);var k=$xe;k.x=(R.x+O.x)*.5,k.y=(R.y+O.y)*.5,k.z=(R.z+O.z)*.5;var z=E.magnitudeSquared(E.subtract(O,k,$x)),W=Math.sqrt(z),j=ehe;j.x=s.x,j.y=l.y,j.z=h.z;var q=the;q.x=x.x,q.y=m.y,q.z=v.z;var I=E.midpoint(j,q,rhe),F=0;for(A=0;A<_;A+=n){a.x=e[A]+r.x,a.y=e[A+1]+r.y,a.z=e[A+2]+r.z;var V=E.magnitude(E.subtract(a,I,$x));V>F&&(F=V);var U=E.magnitudeSquared(E.subtract(a,k,$x));if(U>z){var Q=Math.sqrt(U);W=(W+Q)*.5,z=W*W;var J=Q-W;k.x=(W*k.x+J*a.x)/Q,k.y=(W*k.y+J*a.y)/Q,k.z=(W*k.z+J*a.z)/Q}}return W<F?(E.clone(k,o.center),o.radius=W):(E.clone(I,o.center),o.radius=F),o};Lo.fromEncodedCartesianVertices=function(e,r,n){if(p(n)||(n=new Lo),!p(e)||!p(r)||e.length!==r.length||e.length===0)return n.center=E.clone(E.ZERO,n.center),n.radius=0,n;var o=Jxe;o.x=e[0]+r[0],o.y=e[1]+r[1],o.z=e[2]+r[2];var a=E.clone(o,jxe),s=E.clone(o,Yxe),l=E.clone(o,Qxe),h=E.clone(o,Xxe),x=E.clone(o,Kxe),m=E.clone(o,Zxe),v=e.length,_;for(_=0;_<v;_+=3){var A=e[_]+r[_],T=e[_+1]+r[_+1],w=e[_+2]+r[_+2];o.x=A,o.y=T,o.z=w,A<a.x&&E.clone(o,a),A>h.x&&E.clone(o,h),T<s.y&&E.clone(o,s),T>x.y&&E.clone(o,x),w<l.z&&E.clone(o,l),w>m.z&&E.clone(o,m)}var S=E.magnitudeSquared(E.subtract(h,a,$x)),P=E.magnitudeSquared(E.subtract(x,s,$x)),M=E.magnitudeSquared(E.subtract(m,l,$x)),L=a,R=h,O=S;P>O&&(O=P,L=s,R=x),M>O&&(O=M,L=l,R=m);var N=$xe;N.x=(L.x+R.x)*.5,N.y=(L.y+R.y)*.5,N.z=(L.z+R.z)*.5;var k=E.magnitudeSquared(E.subtract(R,N,$x)),z=Math.sqrt(k),W=ehe;W.x=a.x,W.y=s.y,W.z=l.z;var j=the;j.x=h.x,j.y=x.y,j.z=m.z;var q=E.midpoint(W,j,rhe),I=0;for(_=0;_<v;_+=3){o.x=e[_]+r[_],o.y=e[_+1]+r[_+1],o.z=e[_+2]+r[_+2];var F=E.magnitude(E.subtract(o,q,$x));F>I&&(I=F);var V=E.magnitudeSquared(E.subtract(o,N,$x));if(V>k){var U=Math.sqrt(V);z=(z+U)*.5,k=z*z;var Q=U-z;N.x=(z*N.x+Q*o.x)/U,N.y=(z*N.y+Q*o.y)/U,N.z=(z*N.z+Q*o.z)/U}}return z<I?(E.clone(N,n.center),n.radius=z):(E.clone(q,n.center),n.radius=I),n};Lo.fromCornerPoints=function(e,r,n){X.typeOf.object("corner",e),X.typeOf.object("oppositeCorner",r),p(n)||(n=new Lo);var o=E.midpoint(e,r,n.center);return n.radius=E.distance(o,r),n};Lo.fromEllipsoid=function(e,r){return X.typeOf.object("ellipsoid",e),p(r)||(r=new Lo),E.clone(E.ZERO,r.center),r.radius=e.maximumRadius,r};lSt=new E;Lo.fromBoundingSpheres=function(e,r){if(p(r)||(r=new Lo),!p(e)||e.length===0)return r.center=E.clone(E.ZERO,r.center),r.radius=0,r;var n=e.length;if(n===1)return Lo.clone(e[0],r);if(n===2)return Lo.union(e[0],e[1],r);var o=[],a;for(a=0;a<n;a++)o.push(e[a].center);r=Lo.fromPoints(o,r);var s=r.center,l=r.radius;for(a=0;a<n;a++){var h=e[a];l=Math.max(l,E.distance(s,h.center,lSt)+h.radius)}return r.radius=l,r};uSt=new E,cSt=new E,fSt=new E;Lo.fromOrientedBoundingBox=function(e,r){X.defined("orientedBoundingBox",e),p(r)||(r=new Lo);var n=e.halfAxes,o=We.getColumn(n,0,uSt),a=We.getColumn(n,1,cSt),s=We.getColumn(n,2,fSt);return E.add(o,a,o),E.add(o,s,o),r.center=E.clone(e.center,r.center),r.radius=E.magnitude(o),r};Lo.clone=function(e,r){if(!!p(e))return p(r)?(r.center=E.clone(e.center,r.center),r.radius=e.radius,r):new Lo(e.center,e.radius)};Lo.packedLength=4;Lo.pack=function(e,r,n){X.typeOf.object("value",e),X.defined("array",r),n=B(n,0);var o=e.center;return r[n++]=o.x,r[n++]=o.y,r[n++]=o.z,r[n]=e.radius,r};Lo.unpack=function(e,r,n){X.defined("array",e),r=B(r,0),p(n)||(n=new Lo);var o=n.center;return o.x=e[r++],o.y=e[r++],o.z=e[r++],n.radius=e[r],n};xSt=new E,hSt=new E;Lo.union=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),p(n)||(n=new Lo);var o=e.center,a=e.radius,s=r.center,l=r.radius,h=E.subtract(s,o,xSt),x=E.magnitude(h);if(a>=x+l)return e.clone(n),n;if(l>=x+a)return r.clone(n),n;var m=(a+x+l)*.5,v=E.multiplyByScalar(h,(-a+m)/x,hSt);return E.add(v,o,v),E.clone(v,n.center),n.radius=m,n};dSt=new E;Lo.expand=function(e,r,n){X.typeOf.object("sphere",e),X.typeOf.object("point",r),n=Lo.clone(e,n);var o=E.magnitude(E.subtract(r,n.center,dSt));return o>n.radius&&(n.radius=o),n};Lo.intersectPlane=function(e,r){X.typeOf.object("sphere",e),X.typeOf.object("plane",r);var n=e.center,o=e.radius,a=r.normal,s=E.dot(a,n)+r.distance;return s<-o?wi.OUTSIDE:s<o?wi.INTERSECTING:wi.INSIDE};Lo.transform=function(e,r,n){return X.typeOf.object("sphere",e),X.typeOf.object("transform",r),p(n)||(n=new Lo),n.center=Z.multiplyByPoint(r,e.center,n.center),n.radius=Z.getMaximumScale(r)*e.radius,n};mSt=new E;Lo.distanceSquaredTo=function(e,r){X.typeOf.object("sphere",e),X.typeOf.object("cartesian",r);var n=E.subtract(e.center,r,mSt);return E.magnitudeSquared(n)-e.radius*e.radius};Lo.transformWithoutScale=function(e,r,n){return X.typeOf.object("sphere",e),X.typeOf.object("transform",r),p(n)||(n=new Lo),n.center=Z.multiplyByPoint(r,e.center,n.center),n.radius=e.radius,n};pSt=new E;Lo.computePlaneDistances=function(e,r,n,o){X.typeOf.object("sphere",e),X.typeOf.object("position",r),X.typeOf.object("direction",n),p(o)||(o=new Ip);var a=E.subtract(e.center,r,pSt),s=E.dot(n,a);return o.start=s-e.radius,o.stop=s+e.radius,o};S3e=new E,vSt=new E,gSt=new E,_St=new E,ySt=new E,ASt=new qe,I3e=new Array(8);for(cY=0;cY<8;++cY)I3e[cY]=new E;CSt=new yo;Lo.projectTo2D=function(e,r,n){X.typeOf.object("sphere",e),r=B(r,CSt);var o=r.ellipsoid,a=e.center,s=e.radius,l;E.equals(a,E.ZERO)?l=E.clone(E.UNIT_X,S3e):l=o.geodeticSurfaceNormal(a,S3e);var h=E.cross(E.UNIT_Z,l,vSt);E.normalize(h,h);var x=E.cross(l,h,gSt);E.normalize(x,x),E.multiplyByScalar(l,s,l),E.multiplyByScalar(x,s,x),E.multiplyByScalar(h,s,h);var m=E.negate(x,ySt),v=E.negate(h,_St),_=I3e,A=_[0];E.add(l,x,A),E.add(A,h,A),A=_[1],E.add(l,x,A),E.add(A,v,A),A=_[2],E.add(l,m,A),E.add(A,v,A),A=_[3],E.add(l,m,A),E.add(A,h,A),E.negate(l,l),A=_[4],E.add(l,x,A),E.add(A,h,A),A=_[5],E.add(l,x,A),E.add(A,v,A),A=_[6],E.add(l,m,A),E.add(A,v,A),A=_[7],E.add(l,m,A),E.add(A,h,A);for(var T=_.length,w=0;w<T;++w){var S=_[w];E.add(a,S,S);var P=o.cartesianToCartographic(S,ASt);r.project(P,S)}n=Lo.fromPoints(_,n),a=n.center;var M=a.x,L=a.y,R=a.z;return a.x=R,a.y=M,a.z=L,n};Lo.isOccluded=function(e,r){return X.typeOf.object("sphere",e),X.typeOf.object("occluder",r),!r.isBoundingSphereVisible(e)};Lo.equals=function(e,r){return e===r||p(e)&&p(r)&&E.equals(e.center,r.center)&&e.radius===r.radius};Lo.prototype.intersectPlane=function(e){return Lo.intersectPlane(this,e)};Lo.prototype.distanceSquaredTo=function(e){return Lo.distanceSquaredTo(this,e)};Lo.prototype.computePlaneDistances=function(e,r,n){return Lo.computePlaneDistances(this,e,r,n)};Lo.prototype.isOccluded=function(e){return Lo.isOccluded(this,e)};Lo.prototype.equals=function(e){return Lo.equals(this,e)};Lo.prototype.clone=function(e){return Lo.clone(this,e)};Lo.prototype.volume=function(){var e=this.radius;return iSt*e*e*e};Ue=Lo});function TSt(e,r,n,o){if(X.defined("array",e),X.defined("value",r),p(n)&&X.typeOf.number("start",n),p(o)&&X.typeOf.number("end",o),typeof e.fill=="function")return e.fill(r,n,o);for(var a=e.length>>>0,s=B(n,0),l=s<0?Math.max(a+s,0):Math.min(s,a),h=B(o,a),x=h<0?Math.max(a+h,0):Math.min(h,a);l<x;)e[l]=r,l++;return e}var oo,Hf=Ee(()=>{cr();Ze();De();y(TSt,"arrayFill");oo=TSt});var wSt,Se,co=Ee(()=>{wSt={DEPTH_BUFFER_BIT:256,STENCIL_BUFFER_BIT:1024,COLOR_BUFFER_BIT:16384,POINTS:0,LINES:1,LINE_LOOP:2,LINE_STRIP:3,TRIANGLES:4,TRIANGLE_STRIP:5,TRIANGLE_FAN:6,ZERO:0,ONE:1,SRC_COLOR:768,ONE_MINUS_SRC_COLOR:769,SRC_ALPHA:770,ONE_MINUS_SRC_ALPHA:771,DST_ALPHA:772,ONE_MINUS_DST_ALPHA:773,DST_COLOR:774,ONE_MINUS_DST_COLOR:775,SRC_ALPHA_SATURATE:776,FUNC_ADD:32774,BLEND_EQUATION:32777,BLEND_EQUATION_RGB:32777,BLEND_EQUATION_ALPHA:34877,FUNC_SUBTRACT:32778,FUNC_REVERSE_SUBTRACT:32779,BLEND_DST_RGB:32968,BLEND_SRC_RGB:32969,BLEND_DST_ALPHA:32970,BLEND_SRC_ALPHA:32971,CONSTANT_COLOR:32769,ONE_MINUS_CONSTANT_COLOR:32770,CONSTANT_ALPHA:32771,ONE_MINUS_CONSTANT_ALPHA:32772,BLEND_COLOR:32773,ARRAY_BUFFER:34962,ELEMENT_ARRAY_BUFFER:34963,ARRAY_BUFFER_BINDING:34964,ELEMENT_ARRAY_BUFFER_BINDING:34965,STREAM_DRAW:35040,STATIC_DRAW:35044,DYNAMIC_DRAW:35048,BUFFER_SIZE:34660,BUFFER_USAGE:34661,CURRENT_VERTEX_ATTRIB:34342,FRONT:1028,BACK:1029,FRONT_AND_BACK:1032,CULL_FACE:2884,BLEND:3042,DITHER:3024,STENCIL_TEST:2960,DEPTH_TEST:2929,SCISSOR_TEST:3089,POLYGON_OFFSET_FILL:32823,SAMPLE_ALPHA_TO_COVERAGE:32926,SAMPLE_COVERAGE:32928,NO_ERROR:0,INVALID_ENUM:1280,INVALID_VALUE:1281,INVALID_OPERATION:1282,OUT_OF_MEMORY:1285,CW:2304,CCW:2305,LINE_WIDTH:2849,ALIASED_POINT_SIZE_RANGE:33901,ALIASED_LINE_WIDTH_RANGE:33902,CULL_FACE_MODE:2885,FRONT_FACE:2886,DEPTH_RANGE:2928,DEPTH_WRITEMASK:2930,DEPTH_CLEAR_VALUE:2931,DEPTH_FUNC:2932,STENCIL_CLEAR_VALUE:2961,STENCIL_FUNC:2962,STENCIL_FAIL:2964,STENCIL_PASS_DEPTH_FAIL:2965,STENCIL_PASS_DEPTH_PASS:2966,STENCIL_REF:2967,STENCIL_VALUE_MASK:2963,STENCIL_WRITEMASK:2968,STENCIL_BACK_FUNC:34816,STENCIL_BACK_FAIL:34817,STENCIL_BACK_PASS_DEPTH_FAIL:34818,STENCIL_BACK_PASS_DEPTH_PASS:34819,STENCIL_BACK_REF:36003,STENCIL_BACK_VALUE_MASK:36004,STENCIL_BACK_WRITEMASK:36005,VIEWPORT:2978,SCISSOR_BOX:3088,COLOR_CLEAR_VALUE:3106,COLOR_WRITEMASK:3107,UNPACK_ALIGNMENT:3317,PACK_ALIGNMENT:3333,MAX_TEXTURE_SIZE:3379,MAX_VIEWPORT_DIMS:3386,SUBPIXEL_BITS:3408,RED_BITS:3410,GREEN_BITS:3411,BLUE_BITS:3412,ALPHA_BITS:3413,DEPTH_BITS:3414,STENCIL_BITS:3415,POLYGON_OFFSET_UNITS:10752,POLYGON_OFFSET_FACTOR:32824,TEXTURE_BINDING_2D:32873,SAMPLE_BUFFERS:32936,SAMPLES:32937,SAMPLE_COVERAGE_VALUE:32938,SAMPLE_COVERAGE_INVERT:32939,COMPRESSED_TEXTURE_FORMATS:34467,DONT_CARE:4352,FASTEST:4353,NICEST:4354,GENERATE_MIPMAP_HINT:33170,BYTE:5120,UNSIGNED_BYTE:5121,SHORT:5122,UNSIGNED_SHORT:5123,INT:5124,UNSIGNED_INT:5125,FLOAT:5126,DEPTH_COMPONENT:6402,ALPHA:6406,RGB:6407,RGBA:6408,LUMINANCE:6409,LUMINANCE_ALPHA:6410,UNSIGNED_SHORT_4_4_4_4:32819,UNSIGNED_SHORT_5_5_5_1:32820,UNSIGNED_SHORT_5_6_5:33635,FRAGMENT_SHADER:35632,VERTEX_SHADER:35633,MAX_VERTEX_ATTRIBS:34921,MAX_VERTEX_UNIFORM_VECTORS:36347,MAX_VARYING_VECTORS:36348,MAX_COMBINED_TEXTURE_IMAGE_UNITS:35661,MAX_VERTEX_TEXTURE_IMAGE_UNITS:35660,MAX_TEXTURE_IMAGE_UNITS:34930,MAX_FRAGMENT_UNIFORM_VECTORS:36349,SHADER_TYPE:35663,DELETE_STATUS:35712,LINK_STATUS:35714,VALIDATE_STATUS:35715,ATTACHED_SHADERS:35717,ACTIVE_UNIFORMS:35718,ACTIVE_ATTRIBUTES:35721,SHADING_LANGUAGE_VERSION:35724,CURRENT_PROGRAM:35725,NEVER:512,LESS:513,EQUAL:514,LEQUAL:515,GREATER:516,NOTEQUAL:517,GEQUAL:518,ALWAYS:519,KEEP:7680,REPLACE:7681,INCR:7682,DECR:7683,INVERT:5386,INCR_WRAP:34055,DECR_WRAP:34056,VENDOR:7936,RENDERER:7937,VERSION:7938,NEAREST:9728,LINEAR:9729,NEAREST_MIPMAP_NEAREST:9984,LINEAR_MIPMAP_NEAREST:9985,NEAREST_MIPMAP_LINEAR:9986,LINEAR_MIPMAP_LINEAR:9987,TEXTURE_MAG_FILTER:10240,TEXTURE_MIN_FILTER:10241,TEXTURE_WRAP_S:10242,TEXTURE_WRAP_T:10243,TEXTURE_2D:3553,TEXTURE:5890,TEXTURE_CUBE_MAP:34067,TEXTURE_BINDING_CUBE_MAP:34068,TEXTURE_CUBE_MAP_POSITIVE_X:34069,TEXTURE_CUBE_MAP_NEGATIVE_X:34070,TEXTURE_CUBE_MAP_POSITIVE_Y:34071,TEXTURE_CUBE_MAP_NEGATIVE_Y:34072,TEXTURE_CUBE_MAP_POSITIVE_Z:34073,TEXTURE_CUBE_MAP_NEGATIVE_Z:34074,MAX_CUBE_MAP_TEXTURE_SIZE:34076,TEXTURE0:33984,TEXTURE1:33985,TEXTURE2:33986,TEXTURE3:33987,TEXTURE4:33988,TEXTURE5:33989,TEXTURE6:33990,TEXTURE7:33991,TEXTURE8:33992,TEXTURE9:33993,TEXTURE10:33994,TEXTURE11:33995,TEXTURE12:33996,TEXTURE13:33997,TEXTURE14:33998,TEXTURE15:33999,TEXTURE16:34e3,TEXTURE17:34001,TEXTURE18:34002,TEXTURE19:34003,TEXTURE20:34004,TEXTURE21:34005,TEXTURE22:34006,TEXTURE23:34007,TEXTURE24:34008,TEXTURE25:34009,TEXTURE26:34010,TEXTURE27:34011,TEXTURE28:34012,TEXTURE29:34013,TEXTURE30:34014,TEXTURE31:34015,ACTIVE_TEXTURE:34016,REPEAT:10497,CLAMP_TO_EDGE:33071,MIRRORED_REPEAT:33648,FLOAT_VEC2:35664,FLOAT_VEC3:35665,FLOAT_VEC4:35666,INT_VEC2:35667,INT_VEC3:35668,INT_VEC4:35669,BOOL:35670,BOOL_VEC2:35671,BOOL_VEC3:35672,BOOL_VEC4:35673,FLOAT_MAT2:35674,FLOAT_MAT3:35675,FLOAT_MAT4:35676,SAMPLER_2D:35678,SAMPLER_CUBE:35680,VERTEX_ATTRIB_ARRAY_ENABLED:34338,VERTEX_ATTRIB_ARRAY_SIZE:34339,VERTEX_ATTRIB_ARRAY_STRIDE:34340,VERTEX_ATTRIB_ARRAY_TYPE:34341,VERTEX_ATTRIB_ARRAY_NORMALIZED:34922,VERTEX_ATTRIB_ARRAY_POINTER:34373,VERTEX_ATTRIB_ARRAY_BUFFER_BINDING:34975,IMPLEMENTATION_COLOR_READ_TYPE:35738,IMPLEMENTATION_COLOR_READ_FORMAT:35739,COMPILE_STATUS:35713,LOW_FLOAT:36336,MEDIUM_FLOAT:36337,HIGH_FLOAT:36338,LOW_INT:36339,MEDIUM_INT:36340,HIGH_INT:36341,FRAMEBUFFER:36160,RENDERBUFFER:36161,RGBA4:32854,RGB5_A1:32855,RGB565:36194,DEPTH_COMPONENT16:33189,STENCIL_INDEX:6401,STENCIL_INDEX8:36168,DEPTH_STENCIL:34041,RENDERBUFFER_WIDTH:36162,RENDERBUFFER_HEIGHT:36163,RENDERBUFFER_INTERNAL_FORMAT:36164,RENDERBUFFER_RED_SIZE:36176,RENDERBUFFER_GREEN_SIZE:36177,RENDERBUFFER_BLUE_SIZE:36178,RENDERBUFFER_ALPHA_SIZE:36179,RENDERBUFFER_DEPTH_SIZE:36180,RENDERBUFFER_STENCIL_SIZE:36181,FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE:36048,FRAMEBUFFER_ATTACHMENT_OBJECT_NAME:36049,FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL:36050,FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE:36051,COLOR_ATTACHMENT0:36064,DEPTH_ATTACHMENT:36096,STENCIL_ATTACHMENT:36128,DEPTH_STENCIL_ATTACHMENT:33306,NONE:0,FRAMEBUFFER_COMPLETE:36053,FRAMEBUFFER_INCOMPLETE_ATTACHMENT:36054,FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:36055,FRAMEBUFFER_INCOMPLETE_DIMENSIONS:36057,FRAMEBUFFER_UNSUPPORTED:36061,FRAMEBUFFER_BINDING:36006,RENDERBUFFER_BINDING:36007,MAX_RENDERBUFFER_SIZE:34024,INVALID_FRAMEBUFFER_OPERATION:1286,UNPACK_FLIP_Y_WEBGL:37440,UNPACK_PREMULTIPLY_ALPHA_WEBGL:37441,CONTEXT_LOST_WEBGL:37442,UNPACK_COLORSPACE_CONVERSION_WEBGL:37443,BROWSER_DEFAULT_WEBGL:37444,COMPRESSED_RGB_S3TC_DXT1_EXT:33776,COMPRESSED_RGBA_S3TC_DXT1_EXT:33777,COMPRESSED_RGBA_S3TC_DXT3_EXT:33778,COMPRESSED_RGBA_S3TC_DXT5_EXT:33779,COMPRESSED_RGB_PVRTC_4BPPV1_IMG:35840,COMPRESSED_RGB_PVRTC_2BPPV1_IMG:35841,COMPRESSED_RGBA_PVRTC_4BPPV1_IMG:35842,COMPRESSED_RGBA_PVRTC_2BPPV1_IMG:35843,COMPRESSED_RGB_ETC1_WEBGL:36196,HALF_FLOAT_OES:36193,DOUBLE:5130,READ_BUFFER:3074,UNPACK_ROW_LENGTH:3314,UNPACK_SKIP_ROWS:3315,UNPACK_SKIP_PIXELS:3316,PACK_ROW_LENGTH:3330,PACK_SKIP_ROWS:3331,PACK_SKIP_PIXELS:3332,COLOR:6144,DEPTH:6145,STENCIL:6146,RED:6403,RGB8:32849,RGBA8:32856,RGB10_A2:32857,TEXTURE_BINDING_3D:32874,UNPACK_SKIP_IMAGES:32877,UNPACK_IMAGE_HEIGHT:32878,TEXTURE_3D:32879,TEXTURE_WRAP_R:32882,MAX_3D_TEXTURE_SIZE:32883,UNSIGNED_INT_2_10_10_10_REV:33640,MAX_ELEMENTS_VERTICES:33e3,MAX_ELEMENTS_INDICES:33001,TEXTURE_MIN_LOD:33082,TEXTURE_MAX_LOD:33083,TEXTURE_BASE_LEVEL:33084,TEXTURE_MAX_LEVEL:33085,MIN:32775,MAX:32776,DEPTH_COMPONENT24:33190,MAX_TEXTURE_LOD_BIAS:34045,TEXTURE_COMPARE_MODE:34892,TEXTURE_COMPARE_FUNC:34893,CURRENT_QUERY:34917,QUERY_RESULT:34918,QUERY_RESULT_AVAILABLE:34919,STREAM_READ:35041,STREAM_COPY:35042,STATIC_READ:35045,STATIC_COPY:35046,DYNAMIC_READ:35049,DYNAMIC_COPY:35050,MAX_DRAW_BUFFERS:34852,DRAW_BUFFER0:34853,DRAW_BUFFER1:34854,DRAW_BUFFER2:34855,DRAW_BUFFER3:34856,DRAW_BUFFER4:34857,DRAW_BUFFER5:34858,DRAW_BUFFER6:34859,DRAW_BUFFER7:34860,DRAW_BUFFER8:34861,DRAW_BUFFER9:34862,DRAW_BUFFER10:34863,DRAW_BUFFER11:34864,DRAW_BUFFER12:34865,DRAW_BUFFER13:34866,DRAW_BUFFER14:34867,DRAW_BUFFER15:34868,MAX_FRAGMENT_UNIFORM_COMPONENTS:35657,MAX_VERTEX_UNIFORM_COMPONENTS:35658,SAMPLER_3D:35679,SAMPLER_2D_SHADOW:35682,FRAGMENT_SHADER_DERIVATIVE_HINT:35723,PIXEL_PACK_BUFFER:35051,PIXEL_UNPACK_BUFFER:35052,PIXEL_PACK_BUFFER_BINDING:35053,PIXEL_UNPACK_BUFFER_BINDING:35055,FLOAT_MAT2x3:35685,FLOAT_MAT2x4:35686,FLOAT_MAT3x2:35687,FLOAT_MAT3x4:35688,FLOAT_MAT4x2:35689,FLOAT_MAT4x3:35690,SRGB:35904,SRGB8:35905,SRGB8_ALPHA8:35907,COMPARE_REF_TO_TEXTURE:34894,RGBA32F:34836,RGB32F:34837,RGBA16F:34842,RGB16F:34843,VERTEX_ATTRIB_ARRAY_INTEGER:35069,MAX_ARRAY_TEXTURE_LAYERS:35071,MIN_PROGRAM_TEXEL_OFFSET:35076,MAX_PROGRAM_TEXEL_OFFSET:35077,MAX_VARYING_COMPONENTS:35659,TEXTURE_2D_ARRAY:35866,TEXTURE_BINDING_2D_ARRAY:35869,R11F_G11F_B10F:35898,UNSIGNED_INT_10F_11F_11F_REV:35899,RGB9_E5:35901,UNSIGNED_INT_5_9_9_9_REV:35902,TRANSFORM_FEEDBACK_BUFFER_MODE:35967,MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS:35968,TRANSFORM_FEEDBACK_VARYINGS:35971,TRANSFORM_FEEDBACK_BUFFER_START:35972,TRANSFORM_FEEDBACK_BUFFER_SIZE:35973,TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN:35976,RASTERIZER_DISCARD:35977,MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS:35978,MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS:35979,INTERLEAVED_ATTRIBS:35980,SEPARATE_ATTRIBS:35981,TRANSFORM_FEEDBACK_BUFFER:35982,TRANSFORM_FEEDBACK_BUFFER_BINDING:35983,RGBA32UI:36208,RGB32UI:36209,RGBA16UI:36214,RGB16UI:36215,RGBA8UI:36220,RGB8UI:36221,RGBA32I:36226,RGB32I:36227,RGBA16I:36232,RGB16I:36233,RGBA8I:36238,RGB8I:36239,RED_INTEGER:36244,RGB_INTEGER:36248,RGBA_INTEGER:36249,SAMPLER_2D_ARRAY:36289,SAMPLER_2D_ARRAY_SHADOW:36292,SAMPLER_CUBE_SHADOW:36293,UNSIGNED_INT_VEC2:36294,UNSIGNED_INT_VEC3:36295,UNSIGNED_INT_VEC4:36296,INT_SAMPLER_2D:36298,INT_SAMPLER_3D:36299,INT_SAMPLER_CUBE:36300,INT_SAMPLER_2D_ARRAY:36303,UNSIGNED_INT_SAMPLER_2D:36306,UNSIGNED_INT_SAMPLER_3D:36307,UNSIGNED_INT_SAMPLER_CUBE:36308,UNSIGNED_INT_SAMPLER_2D_ARRAY:36311,DEPTH_COMPONENT32F:36012,DEPTH32F_STENCIL8:36013,FLOAT_32_UNSIGNED_INT_24_8_REV:36269,FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING:33296,FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE:33297,FRAMEBUFFER_ATTACHMENT_RED_SIZE:33298,FRAMEBUFFER_ATTACHMENT_GREEN_SIZE:33299,FRAMEBUFFER_ATTACHMENT_BLUE_SIZE:33300,FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE:33301,FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE:33302,FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE:33303,FRAMEBUFFER_DEFAULT:33304,UNSIGNED_INT_24_8:34042,DEPTH24_STENCIL8:35056,UNSIGNED_NORMALIZED:35863,DRAW_FRAMEBUFFER_BINDING:36006,READ_FRAMEBUFFER:36008,DRAW_FRAMEBUFFER:36009,READ_FRAMEBUFFER_BINDING:36010,RENDERBUFFER_SAMPLES:36011,FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER:36052,MAX_COLOR_ATTACHMENTS:36063,COLOR_ATTACHMENT1:36065,COLOR_ATTACHMENT2:36066,COLOR_ATTACHMENT3:36067,COLOR_ATTACHMENT4:36068,COLOR_ATTACHMENT5:36069,COLOR_ATTACHMENT6:36070,COLOR_ATTACHMENT7:36071,COLOR_ATTACHMENT8:36072,COLOR_ATTACHMENT9:36073,COLOR_ATTACHMENT10:36074,COLOR_ATTACHMENT11:36075,COLOR_ATTACHMENT12:36076,COLOR_ATTACHMENT13:36077,COLOR_ATTACHMENT14:36078,COLOR_ATTACHMENT15:36079,FRAMEBUFFER_INCOMPLETE_MULTISAMPLE:36182,MAX_SAMPLES:36183,HALF_FLOAT:5131,RG:33319,RG_INTEGER:33320,R8:33321,RG8:33323,R16F:33325,R32F:33326,RG16F:33327,RG32F:33328,R8I:33329,R8UI:33330,R16I:33331,R16UI:33332,R32I:33333,R32UI:33334,RG8I:33335,RG8UI:33336,RG16I:33337,RG16UI:33338,RG32I:33339,RG32UI:33340,VERTEX_ARRAY_BINDING:34229,R8_SNORM:36756,RG8_SNORM:36757,RGB8_SNORM:36758,RGBA8_SNORM:36759,SIGNED_NORMALIZED:36764,COPY_READ_BUFFER:36662,COPY_WRITE_BUFFER:36663,COPY_READ_BUFFER_BINDING:36662,COPY_WRITE_BUFFER_BINDING:36663,UNIFORM_BUFFER:35345,UNIFORM_BUFFER_BINDING:35368,UNIFORM_BUFFER_START:35369,UNIFORM_BUFFER_SIZE:35370,MAX_VERTEX_UNIFORM_BLOCKS:35371,MAX_FRAGMENT_UNIFORM_BLOCKS:35373,MAX_COMBINED_UNIFORM_BLOCKS:35374,MAX_UNIFORM_BUFFER_BINDINGS:35375,MAX_UNIFORM_BLOCK_SIZE:35376,MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS:35377,MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS:35379,UNIFORM_BUFFER_OFFSET_ALIGNMENT:35380,ACTIVE_UNIFORM_BLOCKS:35382,UNIFORM_TYPE:35383,UNIFORM_SIZE:35384,UNIFORM_BLOCK_INDEX:35386,UNIFORM_OFFSET:35387,UNIFORM_ARRAY_STRIDE:35388,UNIFORM_MATRIX_STRIDE:35389,UNIFORM_IS_ROW_MAJOR:35390,UNIFORM_BLOCK_BINDING:35391,UNIFORM_BLOCK_DATA_SIZE:35392,UNIFORM_BLOCK_ACTIVE_UNIFORMS:35394,UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES:35395,UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER:35396,UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER:35398,INVALID_INDEX:4294967295,MAX_VERTEX_OUTPUT_COMPONENTS:37154,MAX_FRAGMENT_INPUT_COMPONENTS:37157,MAX_SERVER_WAIT_TIMEOUT:37137,OBJECT_TYPE:37138,SYNC_CONDITION:37139,SYNC_STATUS:37140,SYNC_FLAGS:37141,SYNC_FENCE:37142,SYNC_GPU_COMMANDS_COMPLETE:37143,UNSIGNALED:37144,SIGNALED:37145,ALREADY_SIGNALED:37146,TIMEOUT_EXPIRED:37147,CONDITION_SATISFIED:37148,WAIT_FAILED:37149,SYNC_FLUSH_COMMANDS_BIT:1,VERTEX_ATTRIB_ARRAY_DIVISOR:35070,ANY_SAMPLES_PASSED:35887,ANY_SAMPLES_PASSED_CONSERVATIVE:36202,SAMPLER_BINDING:35097,RGB10_A2UI:36975,INT_2_10_10_10_REV:36255,TRANSFORM_FEEDBACK:36386,TRANSFORM_FEEDBACK_PAUSED:36387,TRANSFORM_FEEDBACK_ACTIVE:36388,TRANSFORM_FEEDBACK_BINDING:36389,COMPRESSED_R11_EAC:37488,COMPRESSED_SIGNED_R11_EAC:37489,COMPRESSED_RG11_EAC:37490,COMPRESSED_SIGNED_RG11_EAC:37491,COMPRESSED_RGB8_ETC2:37492,COMPRESSED_SRGB8_ETC2:37493,COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2:37494,COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2:37495,COMPRESSED_RGBA8_ETC2_EAC:37496,COMPRESSED_SRGB8_ALPHA8_ETC2_EAC:37497,TEXTURE_IMMUTABLE_FORMAT:37167,MAX_ELEMENT_INDEX:36203,TEXTURE_IMMUTABLE_LEVELS:33503,MAX_TEXTURE_MAX_ANISOTROPY_EXT:34047},Se=Object.freeze(wSt)});var qo,Ie,mi=Ee(()=>{Ze();De();st();co();qo={BYTE:Se.BYTE,UNSIGNED_BYTE:Se.UNSIGNED_BYTE,SHORT:Se.SHORT,UNSIGNED_SHORT:Se.UNSIGNED_SHORT,INT:Se.INT,UNSIGNED_INT:Se.UNSIGNED_INT,FLOAT:Se.FLOAT,DOUBLE:Se.DOUBLE};qo.getSizeInBytes=function(e){if(!p(e))throw new G("value is required.");switch(e){case qo.BYTE:return Int8Array.BYTES_PER_ELEMENT;case qo.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case qo.SHORT:return Int16Array.BYTES_PER_ELEMENT;case qo.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case qo.INT:return Int32Array.BYTES_PER_ELEMENT;case qo.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT;case qo.FLOAT:return Float32Array.BYTES_PER_ELEMENT;case qo.DOUBLE:return Float64Array.BYTES_PER_ELEMENT;default:throw new G("componentDatatype is not a valid value.")}};qo.fromTypedArray=function(e){if(e instanceof Int8Array)return qo.BYTE;if(e instanceof Uint8Array)return qo.UNSIGNED_BYTE;if(e instanceof Int16Array)return qo.SHORT;if(e instanceof Uint16Array)return qo.UNSIGNED_SHORT;if(e instanceof Int32Array)return qo.INT;if(e instanceof Uint32Array)return qo.UNSIGNED_INT;if(e instanceof Float32Array)return qo.FLOAT;if(e instanceof Float64Array)return qo.DOUBLE};qo.validate=function(e){return p(e)&&(e===qo.BYTE||e===qo.UNSIGNED_BYTE||e===qo.SHORT||e===qo.UNSIGNED_SHORT||e===qo.INT||e===qo.UNSIGNED_INT||e===qo.FLOAT||e===qo.DOUBLE)};qo.createTypedArray=function(e,r){if(!p(e))throw new G("componentDatatype is required.");if(!p(r))throw new G("valuesOrLength is required.");switch(e){case qo.BYTE:return new Int8Array(r);case qo.UNSIGNED_BYTE:return new Uint8Array(r);case qo.SHORT:return new Int16Array(r);case qo.UNSIGNED_SHORT:return new Uint16Array(r);case qo.INT:return new Int32Array(r);case qo.UNSIGNED_INT:return new Uint32Array(r);case qo.FLOAT:return new Float32Array(r);case qo.DOUBLE:return new Float64Array(r);default:throw new G("componentDatatype is not a valid value.")}};qo.createArrayBufferView=function(e,r,n,o){if(!p(e))throw new G("componentDatatype is required.");if(!p(r))throw new G("buffer is required.");switch(n=B(n,0),o=B(o,(r.byteLength-n)/qo.getSizeInBytes(e)),e){case qo.BYTE:return new Int8Array(r,n,o);case qo.UNSIGNED_BYTE:return new Uint8Array(r,n,o);case qo.SHORT:return new Int16Array(r,n,o);case qo.UNSIGNED_SHORT:return new Uint16Array(r,n,o);case qo.INT:return new Int32Array(r,n,o);case qo.UNSIGNED_INT:return new Uint32Array(r,n,o);case qo.FLOAT:return new Float32Array(r,n,o);case qo.DOUBLE:return new Float64Array(r,n,o);default:throw new G("componentDatatype is not a valid value.")}};qo.fromName=function(e){switch(e){case"BYTE":return qo.BYTE;case"UNSIGNED_BYTE":return qo.UNSIGNED_BYTE;case"SHORT":return qo.SHORT;case"UNSIGNED_SHORT":return qo.UNSIGNED_SHORT;case"INT":return qo.INT;case"UNSIGNED_INT":return qo.UNSIGNED_INT;case"FLOAT":return qo.FLOAT;case"DOUBLE":return qo.DOUBLE;default:throw new G("name is not a valid value.")}};Ie=Object.freeze(qo)});var ESt,_y,rH=Ee(()=>{ESt={NONE:0,TRIANGLES:1,LINES:2,POLYLINES:3},_y=Object.freeze(ESt)});function Oo(e,r,n,o){this[0]=B(e,0),this[1]=B(n,0),this[2]=B(r,0),this[3]=B(o,0)}var P3e,D3e,nu,CC=Ee(()=>{Fr();cr();Ze();De();y(Oo,"Matrix2");Oo.packedLength=4;Oo.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e[0],r[n++]=e[1],r[n++]=e[2],r[n++]=e[3],r};Oo.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Oo),n[0]=e[r++],n[1]=e[r++],n[2]=e[r++],n[3]=e[r++],n};Oo.clone=function(e,r){if(!!p(e))return p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):new Oo(e[0],e[2],e[1],e[3])};Oo.fromArray=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Oo),n[0]=e[r],n[1]=e[r+1],n[2]=e[r+2],n[3]=e[r+3],n};Oo.fromColumnMajorArray=function(e,r){return X.defined("values",e),Oo.clone(e,r)};Oo.fromRowMajorArray=function(e,r){return X.defined("values",e),p(r)?(r[0]=e[0],r[1]=e[2],r[2]=e[1],r[3]=e[3],r):new Oo(e[0],e[1],e[2],e[3])};Oo.fromScale=function(e,r){return X.typeOf.object("scale",e),p(r)?(r[0]=e.x,r[1]=0,r[2]=0,r[3]=e.y,r):new Oo(e.x,0,0,e.y)};Oo.fromUniformScale=function(e,r){return X.typeOf.number("scale",e),p(r)?(r[0]=e,r[1]=0,r[2]=0,r[3]=e,r):new Oo(e,0,0,e)};Oo.fromRotation=function(e,r){X.typeOf.number("angle",e);var n=Math.cos(e),o=Math.sin(e);return p(r)?(r[0]=n,r[1]=o,r[2]=-o,r[3]=n,r):new Oo(n,-o,o,n)};Oo.toArray=function(e,r){return X.typeOf.object("matrix",e),p(r)?(r[0]=e[0],r[1]=e[1],r[2]=e[2],r[3]=e[3],r):[e[0],e[1],e[2],e[3]]};Oo.getElementIndex=function(e,r){return X.typeOf.number.greaterThanOrEquals("row",r,0),X.typeOf.number.lessThanOrEquals("row",r,1),X.typeOf.number.greaterThanOrEquals("column",e,0),X.typeOf.number.lessThanOrEquals("column",e,1),e*2+r};Oo.getColumn=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,1),X.typeOf.object("result",n);var o=r*2,a=e[o],s=e[o+1];return n.x=a,n.y=s,n};Oo.setColumn=function(e,r,n,o){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,1),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=Oo.clone(e,o);var a=r*2;return o[a]=n.x,o[a+1]=n.y,o};Oo.getRow=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,1),X.typeOf.object("result",n);var o=e[r],a=e[r+2];return n.x=o,n.y=a,n};Oo.setRow=function(e,r,n,o){return X.typeOf.object("matrix",e),X.typeOf.number.greaterThanOrEquals("index",r,0),X.typeOf.number.lessThanOrEquals("index",r,1),X.typeOf.object("cartesian",n),X.typeOf.object("result",o),o=Oo.clone(e,o),o[r]=n.x,o[r+2]=n.y,o};P3e=new de;Oo.getScale=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r.x=de.magnitude(de.fromElements(e[0],e[1],P3e)),r.y=de.magnitude(de.fromElements(e[2],e[3],P3e)),r};D3e=new de;Oo.getMaximumScale=function(e){return Oo.getScale(e,D3e),de.maximumComponent(D3e)};Oo.multiply=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e[0]*r[0]+e[2]*r[1],a=e[0]*r[2]+e[2]*r[3],s=e[1]*r[0]+e[3]*r[1],l=e[1]*r[2]+e[3]*r[3];return n[0]=o,n[1]=s,n[2]=a,n[3]=l,n};Oo.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]+r[0],n[1]=e[1]+r[1],n[2]=e[2]+r[2],n[3]=e[3]+r[3],n};Oo.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n[0]=e[0]-r[0],n[1]=e[1]-r[1],n[2]=e[2]-r[2],n[3]=e[3]-r[3],n};Oo.multiplyByVector=function(e,r,n){X.typeOf.object("matrix",e),X.typeOf.object("cartesian",r),X.typeOf.object("result",n);var o=e[0]*r.x+e[2]*r.y,a=e[1]*r.x+e[3]*r.y;return n.x=o,n.y=a,n};Oo.multiplyByScalar=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n[0]=e[0]*r,n[1]=e[1]*r,n[2]=e[2]*r,n[3]=e[3]*r,n};Oo.multiplyByScale=function(e,r,n){return X.typeOf.object("matrix",e),X.typeOf.object("scale",r),X.typeOf.object("result",n),n[0]=e[0]*r.x,n[1]=e[1]*r.x,n[2]=e[2]*r.y,n[3]=e[3]*r.y,n};Oo.negate=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=-e[0],r[1]=-e[1],r[2]=-e[2],r[3]=-e[3],r};Oo.transpose=function(e,r){X.typeOf.object("matrix",e),X.typeOf.object("result",r);var n=e[0],o=e[2],a=e[1],s=e[3];return r[0]=n,r[1]=o,r[2]=a,r[3]=s,r};Oo.abs=function(e,r){return X.typeOf.object("matrix",e),X.typeOf.object("result",r),r[0]=Math.abs(e[0]),r[1]=Math.abs(e[1]),r[2]=Math.abs(e[2]),r[3]=Math.abs(e[3]),r};Oo.equals=function(e,r){return e===r||p(e)&&p(r)&&e[0]===r[0]&&e[1]===r[1]&&e[2]===r[2]&&e[3]===r[3]};Oo.equalsArray=function(e,r,n){return e[0]===r[n]&&e[1]===r[n+1]&&e[2]===r[n+2]&&e[3]===r[n+3]};Oo.equalsEpsilon=function(e,r,n){return X.typeOf.number("epsilon",n),e===r||p(e)&&p(r)&&Math.abs(e[0]-r[0])<=n&&Math.abs(e[1]-r[1])<=n&&Math.abs(e[2]-r[2])<=n&&Math.abs(e[3]-r[3])<=n};Oo.IDENTITY=Object.freeze(new Oo(1,0,0,1));Oo.ZERO=Object.freeze(new Oo(0,0,0,0));Oo.COLUMN0ROW0=0;Oo.COLUMN0ROW1=1;Oo.COLUMN1ROW0=2;Oo.COLUMN1ROW1=3;Object.defineProperties(Oo.prototype,{length:{get:function(){return Oo.packedLength}}});Oo.prototype.clone=function(e){return Oo.clone(this,e)};Oo.prototype.equals=function(e){return Oo.equals(this,e)};Oo.prototype.equalsEpsilon=function(e,r){return Oo.equalsEpsilon(this,e,r)};Oo.prototype.toString=function(){return"("+this[0]+", "+this[2]+`)
(`+this[1]+", "+this[3]+")"};nu=Oo});var AS,jt,un=Ee(()=>{co();AS={POINTS:Se.POINTS,LINES:Se.LINES,LINE_LOOP:Se.LINE_LOOP,LINE_STRIP:Se.LINE_STRIP,TRIANGLES:Se.TRIANGLES,TRIANGLE_STRIP:Se.TRIANGLE_STRIP,TRIANGLE_FAN:Se.TRIANGLE_FAN,validate:function(e){return e===AS.POINTS||e===AS.LINES||e===AS.LINE_LOOP||e===AS.LINE_STRIP||e===AS.TRIANGLES||e===AS.TRIANGLE_STRIP||e===AS.TRIANGLE_FAN}},jt=Object.freeze(AS)});var CS,Ac,Pp,Cc,iH=Ee(()=>{De();Ac={requestFullscreen:void 0,exitFullscreen:void 0,fullscreenEnabled:void 0,fullscreenElement:void 0,fullscreenchange:void 0,fullscreenerror:void 0},Pp={};Object.defineProperties(Pp,{element:{get:function(){if(!!Pp.supportsFullscreen())return document[Ac.fullscreenElement]}},changeEventName:{get:function(){if(!!Pp.supportsFullscreen())return Ac.fullscreenchange}},errorEventName:{get:function(){if(!!Pp.supportsFullscreen())return Ac.fullscreenerror}},enabled:{get:function(){if(!!Pp.supportsFullscreen())return document[Ac.fullscreenEnabled]}},fullscreen:{get:function(){if(!!Pp.supportsFullscreen())return Pp.element!==null}}});Pp.supportsFullscreen=function(){if(p(CS))return CS;CS=!1;var e=document.body;if(typeof e.requestFullscreen=="function")return Ac.requestFullscreen="requestFullscreen",Ac.exitFullscreen="exitFullscreen",Ac.fullscreenEnabled="fullscreenEnabled",Ac.fullscreenElement="fullscreenElement",Ac.fullscreenchange="fullscreenchange",Ac.fullscreenerror="fullscreenerror",CS=!0,CS;for(var r=["webkit","moz","o","ms","khtml"],n,o=0,a=r.length;o<a;++o){var s=r[o];n=s+"RequestFullscreen",typeof e[n]=="function"?(Ac.requestFullscreen=n,CS=!0):(n=s+"RequestFullScreen",typeof e[n]=="function"&&(Ac.requestFullscreen=n,CS=!0)),n=s+"ExitFullscreen",typeof document[n]=="function"?Ac.exitFullscreen=n:(n=s+"CancelFullScreen",typeof document[n]=="function"&&(Ac.exitFullscreen=n)),n=s+"FullscreenEnabled",document[n]!==void 0?Ac.fullscreenEnabled=n:(n=s+"FullScreenEnabled",document[n]!==void 0&&(Ac.fullscreenEnabled=n)),n=s+"FullscreenElement",document[n]!==void 0?Ac.fullscreenElement=n:(n=s+"FullScreenElement",document[n]!==void 0&&(Ac.fullscreenElement=n)),n=s+"fullscreenchange",document["on"+n]!==void 0&&(s==="ms"&&(n="MSFullscreenChange"),Ac.fullscreenchange=n),n=s+"fullscreenerror",document["on"+n]!==void 0&&(s==="ms"&&(n="MSFullscreenError"),Ac.fullscreenerror=n)}return CS};Pp.requestFullscreen=function(e,r){!Pp.supportsFullscreen()||e[Ac.requestFullscreen]({vrDisplay:r})};Pp.exitFullscreen=function(){!Pp.supportsFullscreen()||document[Ac.exitFullscreen]()};Pp._names=Ac;Cc=Pp});function mu(e,r,n,o){return pF(e).then(r,n,o)}function pF(e){var r,n;return e instanceof oH?r=e:L3e(e)?(n=gF(),e.then(function(o){n.resolve(o)},function(o){n.reject(o)},function(o){n.progress(o)}),r=n.promise):r=SSt(e),r}function bSt(e){return mu(e,vF)}function oH(e){this.then=e}function SSt(e){var r=new oH(function(n){try{return pF(n?n(e):e)}catch(o){return vF(o)}});return r}function vF(e){var r=new oH(function(n,o){try{return o?pF(o(e)):vF(e)}catch(a){return vF(a)}});return r}function gF(){var e,r,n,o,a,s,l;return r=new oH(h),e={then:h,resolve:x,reject:m,progress:v,promise:r,resolver:{resolve:x,reject:m,progress:v}},n=[],o=[],a=y(function(_,A,T){var w,S;return w=gF(),S=typeof T=="function"?function(P){try{w.progress(T(P))}catch(M){w.progress(M)}}:function(P){w.progress(P)},n.push(function(P){P.then(_,A).then(w.resolve,w.reject,S)}),o.push(S),w.promise},"_then"),s=y(function(_){return M3e(o,_),_},"_progress"),l=y(function(_){return _=pF(_),a=_.then,l=pF,s=nH,M3e(n,_),o=n=ihe,_},"_resolve"),e;function h(_,A,T){return a(_,A,T)}y(h,"then");function x(_){return l(_)}y(x,"promiseResolve");function m(_){return l(vF(_))}y(m,"promiseReject");function v(_){return s(_)}y(v,"promiseProgress")}function L3e(e){return e&&typeof e.then=="function"}function O3e(e,r,n,o,a){return ohe(2,arguments),mu(e,function(s){var l,h,x,m,v,_,A,T,w,S;if(w=s.length>>>0,l=Math.max(0,Math.min(r,w)),x=[],h=w-l+1,m=[],v=gF(),!l)v.resolve(x);else for(T=v.progress,A=y(function(L){m.push(L),--h||(_=A=nH,v.reject(m))},"rejectOne"),_=y(function(L){x.push(L),--l||(_=A=nH,v.resolve(x))},"fulfillOne"),S=0;S<w;++S)S in s&&mu(s[S],M,P,T);return v.then(n,o,a);function P(L){A(L)}function M(L){_(L)}})}function ISt(e,r,n,o){return ohe(1,arguments),mu(e,function(a){var s,l,h,x,m,v,_,A,T;for(_=a.length>>>0,A=a.length>>>0,s=[],l=[],h=gF(),v=h.progress,m=y(function(N){l.push(N),--A||(x=m=nH,h.resolve(s))},"rejectOne"),x=y(function(N,k){s[k]=N,--A||(x=m=nH,h.resolve(s))},"fulfillOne"),T=0;T<_;++T)switch(T){case 0:mu(a[T],P,w,v);break;case 1:mu(a[T],M,w,v);break;case 2:mu(a[T],L,w,v);break;case 3:mu(a[T],R,w,v);break;case 4:mu(a[T],O,w,v);break;default:mu(a[T],S,w,v);break}return h.then(r,n,o);function w(N){m(N)}function S(N){x(N,0)}function P(N){x(N,0)}function M(N){x(N,1)}function L(N){x(N,2)}function R(N){x(N,3)}function O(N){x(N,4)}})}function PSt(e,r,n,o){function a(s){return r?r(s[0]):s[0]}return y(a,"unwrapSingleResult"),O3e(e,1,a,n,o)}function F3e(e,r,n,o){return ohe(1,arguments),nhe(e,N3e).then(r,n,o)}function DSt(){return nhe(arguments,N3e)}function nhe(e,r){return mu(e,function(n){var o,a,s,l,h,x;if(s=a=n.length>>>0,o=[],x=gF(),!s)x.resolve(o);else for(l=y(function(v,_){mu(v,r).then(function(A){o[_]=A,--s||x.resolve(o)},x.reject)},"resolveOne"),h=0;h<a;h++)h in n?l(n[h],h):--s;return x.promise})}function MSt(e,r){var n=R3e.call(arguments,1);return mu(e,function(o){var a;return a=o.length,n[0]=function(s,l,h){return mu(s,function(x){return mu(l,function(m){return r(x,m,h,a)})})},B3e.apply(o,n)})}function BSt(e,r,n){var o=arguments.length>2;return mu(e,function(a){return a=o?n:a,r.resolve(a),a},function(a){return r.reject(a),vF(a)},r.progress)}function M3e(e,r){for(var n,o=0;n=e[o++];)n(r)}function ohe(e,r){for(var n,o=r.length;o>e;)if(n=r[--o],n!=null&&typeof n!="function")throw new Error("arg "+o+" must be a function")}function nH(){}function N3e(e){return e}var B3e,R3e,ihe,Je,li=Ee(()=>{/**
  @license

  MIT License (c) copyright B Cavalier & J Hann

 * A lightweight CommonJS Promises/A and when() implementation
 * when is part of the cujo.js family of libraries
 *
 * Licensed under the MIT License at:
 *
 * @version 1.7.1
 */mu.defer=gF;mu.resolve=pF;mu.reject=bSt;mu.join=DSt;mu.all=F3e;mu.map=nhe;mu.reduce=MSt;mu.any=PSt;mu.some=O3e;mu.allSettled=ISt;mu.chain=BSt;mu.isPromise=L3e;y(mu,"when");y(pF,"resolve");y(bSt,"reject");y(oH,"Promise");oH.prototype={always:function(e,r){return this.then(e,e,r)},otherwise:function(e){return this.then(ihe,e)},yield:function(e){return this.then(function(){return e})},spread:function(e){return this.then(function(r){return F3e(r,function(n){return e.apply(ihe,n)})})}};y(SSt,"fulfilled");y(vF,"rejected");y(gF,"defer");y(L3e,"isPromise");y(O3e,"some");y(ISt,"allSettled");y(PSt,"any");y(F3e,"all");y(DSt,"join");y(nhe,"map");y(MSt,"reduce");y(BSt,"chain");y(M3e,"processQueue");y(ohe,"checkCallbacks");y(nH,"noop");R3e=[].slice;B3e=[].reduce||function(e){var r,n,o,a,s;if(s=0,r=Object(this),a=r.length>>>0,n=arguments,n.length<=1)for(;;){if(s in r){o=r[s++];break}if(++s>=a)throw new TypeError}else o=n[1];for(;s<a;++s)s in r&&(o=e(o,r[s],s,r));return o};y(N3e,"identity");Je=mu});function UM(e){for(var r=e.split("."),n=0,o=r.length;n<o;++n)r[n]=parseInt(r[n],10);return r}function fhe(){if(!p(fY)&&(fY=!1,!sH())){var e=/ Chrome\/([\.0-9]+)/.exec(wd.userAgent);e!==null&&(fY=!0,z3e=UM(e[1]))}return fY}function RSt(){return fhe()&&z3e}function k3e(){if(!p(xY)&&(xY=!1,!fhe()&&!sH()&&/ Safari\/[\.0-9]+/.test(wd.userAgent))){var e=/ Version\/([\.0-9]+)/.exec(wd.userAgent);e!==null&&(xY=!0,V3e=UM(e[1]))}return xY}function LSt(){return k3e()&&V3e}function U3e(){if(!p(hY)){hY=!1;var e=/ AppleWebKit\/([\.0-9]+)(\+?)/.exec(wd.userAgent);e!==null&&(hY=!0,uhe=UM(e[1]),uhe.isNightly=!!e[2])}return hY}function OSt(){return U3e()&&uhe}function G3e(){if(!p(aH)){aH=!1;var e;wd.appName==="Microsoft Internet Explorer"?(e=/MSIE ([0-9]{1,}[\.0-9]{0,})/.exec(wd.userAgent),e!==null&&(aH=!0,che=UM(e[1]))):wd.appName==="Netscape"&&(e=/Trident\/.*rv:([0-9]{1,}[\.0-9]{0,})/.exec(wd.userAgent),e!==null&&(aH=!0,che=UM(e[1])))}return aH}function FSt(){return G3e()&&che}function sH(){if(!p(dY)){dY=!1;var e=/ Edge\/([\.0-9]+)/.exec(wd.userAgent);e!==null&&(dY=!0,H3e=UM(e[1]))}return dY}function NSt(){return sH()&&H3e}function gY(){if(!p(mY)){mY=!1;var e=/Firefox\/([\.0-9]+)/.exec(wd.userAgent);e!==null&&(mY=!0,xhe=UM(e[1]))}return mY}function zSt(){return p(ahe)||(ahe=/Windows/i.test(wd.appVersion)),ahe}function VSt(){return gY()&&xhe}function kSt(){return p(she)||(she=typeof process=="object"&&Object.prototype.toString.call(process)==="[object process]"),she}function USt(){return p(lhe)||(lhe=!gY()&&typeof PointerEvent<"u"&&(!p(wd.pointerEnabled)||wd.pointerEnabled)),lhe}function q3e(){if(!p(pY)){var e=document.createElement("canvas");e.setAttribute("style","image-rendering: -moz-crisp-edges;image-rendering: pixelated;");var r=e.style.imageRendering;pY=p(r)&&r!=="",pY&&(W3e=r)}return pY}function GSt(){return q3e()?W3e:void 0}function j3e(){if(p(TS))return TS.promise;TS=Je.defer(),sH()&&(kM=!1,TS.resolve(kM));var e=new Image;return e.onload=function(){kM=e.width>0&&e.height>0,TS.resolve(kM)},e.onerror=function(){kM=!1,TS.resolve(kM)},e.src="data:image/webp;base64,UklGRiIAAABXRUJQVlA4IBYAAAAwAQCdASoBAAEADsD+JaQAA3AAAAAA",TS.promise}function HSt(){return p(TS)||j3e(),kM}function WSt(){var e=window.navigator.userAgent.toLowerCase(),r=e.match(/ipad/i)=="ipad",n=e.match(/iphone os/i)=="iphone os",o=e.match(/midp/i)=="midp",a=e.match(/ucweb/i)=="ucweb",s=e.match(/android/i)=="android",l=e.match(/windows ce/i)=="windows ce",h=e.match(/windows mobile/i)=="windows mobile";return!(r||n||o||a||s||l||h)}var wd,fY,z3e,xY,V3e,hY,uhe,aH,che,dY,H3e,mY,xhe,ahe,she,lhe,W3e,pY,kM,TS,vY,Yw,Gn,ou=Ee(()=>{Ze();De();iH();li();typeof navigator<"u"?wd=navigator:wd={};y(UM,"extractVersion");y(fhe,"isChrome");y(RSt,"chromeVersion");y(k3e,"isSafari");y(LSt,"safariVersion");y(U3e,"isWebkit");y(OSt,"webkitVersion");y(G3e,"isInternetExplorer");y(FSt,"internetExplorerVersion");y(sH,"isEdge");y(NSt,"edgeVersion");y(gY,"isFirefox");y(zSt,"isWindows");y(VSt,"firefoxVersion");y(kSt,"isNodeJs");y(USt,"supportsPointerEvents");y(q3e,"supportsImageRenderingPixelated");y(GSt,"imageRenderingValue");y(j3e,"supportsWebP");y(HSt,"supportsWebPSync");vY=[];typeof ArrayBuffer<"u"&&(vY.push(Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array),typeof Uint8ClampedArray<"u"&&vY.push(Uint8ClampedArray),typeof CanvasPixelArray<"u"&&vY.push(CanvasPixelArray));Yw={isChrome:fhe,chromeVersion:RSt,isSafari:k3e,safariVersion:LSt,isWebkit:U3e,webkitVersion:OSt,isInternetExplorer:G3e,internetExplorerVersion:FSt,isEdge:sH,edgeVersion:NSt,isFirefox:gY,firefoxVersion:VSt,isWindows:zSt,isNodeJs:kSt,hardwareConcurrency:B(wd.hardwareConcurrency,3),supportsPointerEvents:USt,supportsImageRenderingPixelated:q3e,supportsWebP:j3e,supportsWebPSync:HSt,imageRenderingValue:GSt,typedArrayTypes:vY,isPCBroswer:WSt};Yw.supportsFullscreen=function(){return Cc.supportsFullscreen()};Yw.supportsTypedArrays=function(){return typeof ArrayBuffer<"u"};Yw.supportsWebWorkers=function(){return typeof Worker<"u"};Yw.supportsWebAssembly=function(){return typeof WebAssembly<"u"&&!Yw.isEdge()};Yw.supportsOffscreenCanvas=function(){return typeof OffscreenCanvas<"u"&&!Yw.isEdge()};Yw.supportsEsmWebWorkers=function(){return!gY()||parseInt(xhe)>=114};y(WSt,"isPCBroswer");Gn=Yw});function ci(e,r,n,o){this.x=B(e,0),this.y=B(r,0),this.z=B(n,0),this.w=B(o,0)}var lH,qSt,jSt,Y3e,Q3e,hhe,X3e,_Y,dhe,yy,K3e,yY,mhe,Z3e,phe,vhe,YSt,QSt,uH,yF,XSt,J3e,CY,TY,Qw,Xw,AY,ghe,_F,hr,Ja=Ee(()=>{bt();cr();Ze();De();ou();nr();to();y(ci,"Quaternion");lH=new E;ci.fromAxisAngle=function(e,r,n){X.typeOf.object("axis",e),X.typeOf.number("angle",r);var o=r/2,a=Math.sin(o);lH=E.normalize(e,lH);var s=lH.x*a,l=lH.y*a,h=lH.z*a,x=Math.cos(o);return p(n)?(n.x=s,n.y=l,n.z=h,n.w=x,n):new ci(s,l,h,x)};qSt=[1,2,0],jSt=new Array(3);ci.fromRotationMatrix=function(e,r){X.typeOf.object("matrix",e);var n,o,a,s,l,h=e[We.COLUMN0ROW0],x=e[We.COLUMN1ROW1],m=e[We.COLUMN2ROW2],v=h+x+m;if(v>0)n=Math.sqrt(v+1),l=.5*n,n=.5/n,o=(e[We.COLUMN1ROW2]-e[We.COLUMN2ROW1])*n,a=(e[We.COLUMN2ROW0]-e[We.COLUMN0ROW2])*n,s=(e[We.COLUMN0ROW1]-e[We.COLUMN1ROW0])*n;else{var _=qSt,A=0;x>h&&(A=1),m>h&&m>x&&(A=2);var T=_[A],w=_[T];n=Math.sqrt(e[We.getElementIndex(A,A)]-e[We.getElementIndex(T,T)]-e[We.getElementIndex(w,w)]+1);var S=jSt;S[A]=.5*n,n=.5/n,l=(e[We.getElementIndex(w,T)]-e[We.getElementIndex(T,w)])*n,S[T]=(e[We.getElementIndex(T,A)]+e[We.getElementIndex(A,T)])*n,S[w]=(e[We.getElementIndex(w,A)]+e[We.getElementIndex(A,w)])*n,o=-S[0],a=-S[1],s=-S[2]}return p(r)?(r.x=o,r.y=a,r.z=s,r.w=l,r):new ci(o,a,s,l)};Y3e=new ci,Q3e=new ci,hhe=new ci,X3e=new ci;ci.fromHeadingPitchRoll=function(e,r){return X.typeOf.object("headingPitchRoll",e),X3e=ci.fromAxisAngle(E.UNIT_X,e.roll,Y3e),hhe=ci.fromAxisAngle(E.UNIT_Y,-e.pitch,r),r=ci.multiply(hhe,X3e,hhe),Q3e=ci.fromAxisAngle(E.UNIT_Z,-e.heading,Y3e),ci.multiply(Q3e,r,r)};_Y=new E,dhe=new E,yy=new ci,K3e=new ci,yY=new ci;ci.packedLength=4;ci.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.x,r[n++]=e.y,r[n++]=e.z,r[n]=e.w,r};ci.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new ci),n.x=e[r],n.y=e[r+1],n.z=e[r+2],n.w=e[r+3],n};ci.packedInterpolationLength=3;ci.convertPackedArrayForInterpolation=function(e,r,n,o){ci.unpack(e,n*4,yY),ci.conjugate(yY,yY);for(var a=0,s=n-r+1;a<s;a++){var l=a*3;ci.unpack(e,(r+a)*4,yy),ci.multiply(yy,yY,yy),yy.w<0&&ci.negate(yy,yy),ci.computeAxis(yy,_Y);var h=ci.computeAngle(yy);o[l]=_Y.x*h,o[l+1]=_Y.y*h,o[l+2]=_Y.z*h}};ci.unpackInterpolationResult=function(e,r,n,o,a){p(a)||(a=new ci),E.fromArray(e,0,dhe);var s=E.magnitude(dhe);return ci.unpack(r,o*4,K3e),s===0?ci.clone(ci.IDENTITY,yy):ci.fromAxisAngle(dhe,s,yy),ci.multiply(yy,K3e,a)};ci.clone=function(e,r){if(!!p(e))return p(r)?(r.x=e.x,r.y=e.y,r.z=e.z,r.w=e.w,r):new ci(e.x,e.y,e.z,e.w)};ci.conjugate=function(e,r){return X.typeOf.object("quaternion",e),X.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=e.w,r};ci.magnitudeSquared=function(e){return X.typeOf.object("quaternion",e),e.x*e.x+e.y*e.y+e.z*e.z+e.w*e.w};ci.magnitude=function(e){return Math.sqrt(ci.magnitudeSquared(e))};ci.normalize=function(e,r){X.typeOf.object("result",r);var n=1/ci.magnitude(e),o=e.x*n,a=e.y*n,s=e.z*n,l=e.w*n;return r.x=o,r.y=a,r.z=s,r.w=l,r};ci.inverse=function(e,r){X.typeOf.object("result",r);var n=ci.magnitudeSquared(e);return r=ci.conjugate(e,r),ci.multiplyByScalar(r,1/n,r)};ci.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x+r.x,n.y=e.y+r.y,n.z=e.z+r.z,n.w=e.w+r.w,n};ci.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.x=e.x-r.x,n.y=e.y-r.y,n.z=e.z-r.z,n.w=e.w-r.w,n};ci.negate=function(e,r){return X.typeOf.object("quaternion",e),X.typeOf.object("result",r),r.x=-e.x,r.y=-e.y,r.z=-e.z,r.w=-e.w,r};ci.dot=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),e.x*r.x+e.y*r.y+e.z*r.z+e.w*r.w};ci.multiply=function(e,r,n){X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n);var o=e.x,a=e.y,s=e.z,l=e.w,h=r.x,x=r.y,m=r.z,v=r.w,_=l*h+o*v+a*m-s*x,A=l*x-o*m+a*v+s*h,T=l*m+o*x-a*h+s*v,w=l*v-o*h-a*x-s*m;return n.x=_,n.y=A,n.z=T,n.w=w,n};ci.multiplyByVec=function(e,r,n){var o=new E,a=new E,s=new E(e.x,e.y,e.z);o=E.cross(s,r,o),a=E.cross(s,o,a);var l=new E;l=E.multiplyByScalar(o,2*e.w,l);var h=new E;return h=E.multiplyByScalar(o,2,h),n=E.add(r,l,n),n=E.add(n,h,n),n};ci.multiplyByScalar=function(e,r,n){return X.typeOf.object("quaternion",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x*r,n.y=e.y*r,n.z=e.z*r,n.w=e.w*r,n};ci.divideByScalar=function(e,r,n){return X.typeOf.object("quaternion",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.x=e.x/r,n.y=e.y/r,n.z=e.z/r,n.w=e.w/r,n};ci.computeAxis=function(e,r){X.typeOf.object("quaternion",e),X.typeOf.object("result",r);var n=e.w;if(Math.abs(n-1)<K.EPSILON6)return r.x=r.y=r.z=0,r;var o=1/Math.sqrt(1-n*n);return r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r};ci.computeAngle=function(e){return X.typeOf.object("quaternion",e),Math.abs(e.w-1)<K.EPSILON6?0:2*Math.acos(e.w)};mhe=new ci;ci.lerp=function(e,r,n,o){return X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o),mhe=ci.multiplyByScalar(r,n,mhe),o=ci.multiplyByScalar(e,1-n,o),ci.add(mhe,o,o)};Z3e=new ci,phe=new ci,vhe=new ci;ci.slerp=function(e,r,n,o){X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o);var a=ci.dot(e,r),s=r;if(a<0&&(a=-a,s=Z3e=ci.negate(r,Z3e)),1-a<K.EPSILON6)return ci.lerp(e,s,n,o);var l=Math.acos(a);return phe=ci.multiplyByScalar(e,Math.sin((1-n)*l),phe),vhe=ci.multiplyByScalar(s,Math.sin(n*l),vhe),o=ci.add(phe,vhe,o),ci.multiplyByScalar(o,1/Math.sin(l),o)};ci.log=function(e,r){X.typeOf.object("quaternion",e),X.typeOf.object("result",r);var n=K.acosClamped(e.w),o=0;return n!==0&&(o=n/Math.sin(n)),E.multiplyByScalar(e,o,r)};ci.exp=function(e,r){X.typeOf.object("cartesian",e),X.typeOf.object("result",r);var n=E.magnitude(e),o=0;return n!==0&&(o=Math.sin(n)/n),r.x=e.x*o,r.y=e.y*o,r.z=e.z*o,r.w=Math.cos(n),r};YSt=new E,QSt=new E,uH=new ci,yF=new ci;ci.computeInnerQuadrangle=function(e,r,n,o){X.typeOf.object("q0",e),X.typeOf.object("q1",r),X.typeOf.object("q2",n),X.typeOf.object("result",o);var a=ci.conjugate(r,uH);ci.multiply(a,n,yF);var s=ci.log(yF,YSt);ci.multiply(a,e,yF);var l=ci.log(yF,QSt);return E.add(s,l,s),E.multiplyByScalar(s,.25,s),E.negate(s,s),ci.exp(s,uH),ci.multiply(r,uH,o)};ci.squad=function(e,r,n,o,a,s){X.typeOf.object("q0",e),X.typeOf.object("q1",r),X.typeOf.object("s0",n),X.typeOf.object("s1",o),X.typeOf.number("t",a),X.typeOf.object("result",s);var l=ci.slerp(e,r,a,uH),h=ci.slerp(n,o,a,yF);return ci.slerp(l,h,2*a*(1-a),s)};XSt=new ci,J3e=1.9011074535173003,CY=Gn.supportsTypedArrays()?new Float32Array(8):[],TY=Gn.supportsTypedArrays()?new Float32Array(8):[],Qw=Gn.supportsTypedArrays()?new Float32Array(8):[],Xw=Gn.supportsTypedArrays()?new Float32Array(8):[];for(_F=0;_F<7;++_F)AY=_F+1,ghe=2*AY+1,CY[_F]=1/(AY*ghe),TY[_F]=AY/ghe;CY[7]=J3e/(8*17);TY[7]=J3e*8/17;ci.fastSlerp=function(e,r,n,o){X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o);var a=ci.dot(e,r),s;a>=0?s=1:(s=-1,a=-a);for(var l=a-1,h=1-n,x=n*n,m=h*h,v=7;v>=0;--v)Qw[v]=(CY[v]*x-TY[v])*l,Xw[v]=(CY[v]*m-TY[v])*l;var _=s*n*(1+Qw[0]*(1+Qw[1]*(1+Qw[2]*(1+Qw[3]*(1+Qw[4]*(1+Qw[5]*(1+Qw[6]*(1+Qw[7])))))))),A=h*(1+Xw[0]*(1+Xw[1]*(1+Xw[2]*(1+Xw[3]*(1+Xw[4]*(1+Xw[5]*(1+Xw[6]*(1+Xw[7])))))))),T=ci.multiplyByScalar(e,A,XSt);return ci.multiplyByScalar(r,_,o),ci.add(T,o,o)};ci.fastSquad=function(e,r,n,o,a,s){X.typeOf.object("q0",e),X.typeOf.object("q1",r),X.typeOf.object("s0",n),X.typeOf.object("s1",o),X.typeOf.number("t",a),X.typeOf.object("result",s);var l=ci.fastSlerp(e,r,a,uH),h=ci.fastSlerp(n,o,a,yF);return ci.fastSlerp(l,h,2*a*(1-a),s)};ci.equals=function(e,r){return e===r||p(e)&&p(r)&&e.x===r.x&&e.y===r.y&&e.z===r.z&&e.w===r.w};ci.equalsEpsilon=function(e,r,n){return X.typeOf.number("epsilon",n),e===r||p(e)&&p(r)&&Math.abs(e.x-r.x)<=n&&Math.abs(e.y-r.y)<=n&&Math.abs(e.z-r.z)<=n&&Math.abs(e.w-r.w)<=n};ci.ZERO=Object.freeze(new ci(0,0,0,0));ci.IDENTITY=Object.freeze(new ci(0,0,0,1));ci.prototype.clone=function(e){return ci.clone(this,e)};ci.prototype.equals=function(e){return ci.equals(this,e)};ci.prototype.equalsEpsilon=function(e,r){return ci.equalsEpsilon(this,e,r)};ci.prototype.toString=function(){return"("+this.x+", "+this.y+", "+this.z+", "+this.w+")"};hr=ci});function KSt(e,r,n){X.defined("array",e),X.defined("itemToFind",r),X.defined("comparator",n);for(var o=0,a=e.length-1,s,l;o<=a;){if(s=~~((o+a)/2),l=n(e[s],r),l<0){o=s+1;continue}if(l>0){a=s-1;continue}return s}return~(a+1)}var T0,Kw=Ee(()=>{cr();y(KSt,"binarySearch");T0=KSt});function ZSt(e,r,n,o,a){this.xPoleWander=e,this.yPoleWander=r,this.xPoleOffset=n,this.yPoleOffset=o,this.ut1MinusUtc=a}var GM,wY=Ee(()=>{y(ZSt,"EarthOrientationParametersSample");GM=ZSt});function JSt(){var e=/%%|%(\d+\$)?([-+\'#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuideEfFgG])/g,r=arguments,n=0,o=r[n++],a=y(function(m,v,_,A){_||(_=" ");var T=m.length>=v?"":Array(1+v-m.length>>>0).join(_);return A?m+T:T+m},"pad"),s=y(function(m,v,_,A,T,w){var S=A-m.length;return S>0&&(_||!T?m=a(m,A,w,_):m=m.slice(0,v.length)+a("",S,"0",!0)+m.slice(v.length)),m},"justify"),l=y(function(m,v,_,A,T,w,S){var P=m>>>0;return _=_&&P&&{2:"0b",8:"0",16:"0x"}[v]||"",m=_+a(P.toString(v),w||0,"0",!1),s(m,_,A,T,S)},"formatBaseX"),h=y(function(m,v,_,A,T,w){return A!=null&&(m=m.slice(0,A)),s(m,"",v,_,T,w)},"formatString"),x=y(function(m,v,_,A,T,w,S){var P,M,L,R,O;if(m=="%%")return"%";for(var N=!1,k="",z=!1,W=!1,j=" ",q=_.length,I=0;_&&I<q;I++)switch(_.charAt(I)){case" ":k=" ";break;case"+":k="+";break;case"-":N=!0;break;case"'":j=_.charAt(I+1);break;case"0":z=!0;break;case"#":W=!0;break}if(A?A=="*"?A=+r[n++]:A.charAt(0)=="*"?A=+r[A.slice(1,-1)]:A=+A:A=0,A<0&&(A=-A,N=!0),!isFinite(A))throw new Error("sprintf: (minimum-)width must be finite");switch(w?w=="*"?w=+r[n++]:w.charAt(0)=="*"?w=+r[w.slice(1,-1)]:w=+w:w="fFeE".indexOf(S)>-1?6:S=="d"?0:void 0,O=v?r[v.slice(0,-1)]:r[n++],S){case"s":return h(String(O),N,A,w,z,j);case"c":return h(String.fromCharCode(+O),N,A,w,z);case"b":return l(O,2,W,N,A,w,z);case"o":return l(O,8,W,N,A,w,z);case"x":return l(O,16,W,N,A,w,z);case"X":return l(O,16,W,N,A,w,z).toUpperCase();case"u":return l(O,10,W,N,A,w,z);case"i":case"d":return P=+O||0,P=Math.round(P-P%1),M=P<0?"-":k,O=M+a(String(Math.abs(P)),w,"0",!1),s(O,M,N,A,z);case"e":case"E":case"f":case"F":case"g":case"G":return P=+O,M=P<0?"-":k,L=["toExponential","toFixed","toPrecision"]["efg".indexOf(S.toLowerCase())],R=["toString","toUpperCase"]["eEfFgG".indexOf(S)%2],O=M+Math.abs(P)[L](w),s(O,M,N,A,z)[R]();default:return m}},"doFormat");return o.replace(e,x)}var Zw,EY=Ee(()=>{y(JSt,"sprintf");Zw=JSt});function $St(e,r,n,o,a,s,l,h){this.year=e,this.month=r,this.day=n,this.hour=o,this.minute=a,this.second=s,this.millisecond=l,this.isLeapSecond=h}var Jw,bY=Ee(()=>{y($St,"GregorianDate");Jw=$St});function eIt(e){if(e===null||isNaN(e))throw new G("year is required and must be a number.");return e%4===0&&e%100!==0||e%400===0}var wS,SY=Ee(()=>{st();y(eIt,"isLeapYear");wS=eIt});function tIt(e,r){this.julianDate=e,this.offset=r}var sl,IY=Ee(()=>{y(tIt,"LeapSecond");sl=tIt});var rIt,ka,$w=Ee(()=>{rIt={SECONDS_PER_MILLISECOND:.001,SECONDS_PER_MINUTE:60,MINUTES_PER_HOUR:60,HOURS_PER_DAY:24,SECONDS_PER_HOUR:3600,MINUTES_PER_DAY:1440,SECONDS_PER_DAY:86400,DAYS_PER_JULIAN_CENTURY:36525,PICOSECOND:1e-9,MODIFIED_JULIAN_DATE_DIFFERENCE:24000005e-1},ka=Object.freeze(rIt)});var iIt,Oa,AF=Ee(()=>{iIt={UTC:0,TAI:1},Oa=Object.freeze(iIt)});function _he(e,r){return nn.compare(e.julianDate,r.julianDate)}function BY(e){CF.julianDate=e;var r=nn.leapSeconds,n=T0(r,CF,_he);n<0&&(n=~n),n>=r.length&&(n=r.length-1);var o=r[n].offset;if(n>0){var a=nn.secondsDifference(r[n].julianDate,e);a>o&&(n--,o=r[n].offset)}nn.addSeconds(e,o,e)}function $3e(e,r){CF.julianDate=e;var n=nn.leapSeconds,o=T0(n,CF,_he);if(o<0&&(o=~o),o===0)return nn.addSeconds(e,-n[0].offset,r);if(o>=n.length)return nn.addSeconds(e,-n[o-1].offset,r);var a=nn.secondsDifference(n[o].julianDate,e);if(a===0)return nn.addSeconds(e,-n[o].offset,r);if(!(a<=1))return nn.addSeconds(e,-n[--o].offset,r)}function ES(e,r,n){var o=r/ka.SECONDS_PER_DAY|0;return e+=o,r-=ka.SECONDS_PER_DAY*o,r<0&&(e--,r+=ka.SECONDS_PER_DAY),n.dayNumber=e,n.secondsOfDay=r,n}function yhe(e,r,n,o,a,s,l){var h=(r-14)/12|0,x=e+4800+h,m=(1461*x/4|0)+(367*(r-2-12*h)/12|0)-(3*((x+100)/100|0)/4|0)+n-32075;o=o-12,o<0&&(o+=24);var v=s+(o*ka.SECONDS_PER_HOUR+a*ka.SECONDS_PER_MINUTE+l*ka.SECONDS_PER_MILLISECOND);return v>=43200&&(m-=1),[m,v]}function nn(e,r,n){this.dayNumber=void 0,this.secondsOfDay=void 0,e=B(e,0),r=B(r,0),n=B(n,Oa.UTC);var o=e|0;r=r+(e-o)*ka.SECONDS_PER_DAY,ES(o,r,this),n===Oa.UTC&&BY(this)}var eze,PY,DY,CF,nIt,oIt,aIt,sIt,lIt,Ahe,uIt,cIt,fIt,Ay,MY,ot,$a=Ee(()=>{EY();Kw();Ze();De();st();bY();SY();IY();$w();AF();eze=new Jw,PY=[31,28,31,30,31,30,31,31,30,31,30,31],DY=29;y(_he,"compareLeapSecondDates");CF=new sl;y(BY,"convertUtcToTai");y($3e,"convertTaiToUtc");y(ES,"setComponents");y(yhe,"computeJulianDateComponents");nIt=/^(\d{4})$/,oIt=/^(\d{4})-(\d{2})$/,aIt=/^(\d{4})-?(\d{3})$/,sIt=/^(\d{4})-?W(\d{2})-?(\d{1})?$/,lIt=/^(\d{4})-?(\d{2})-?(\d{2})$/,Ahe=/([Z+\-])?(\d{2})?:?(\d{2})?$/,uIt=/^(\d{2})(\.\d+)?/.source+Ahe.source,cIt=/^(\d{2}):?(\d{2})(\.\d+)?/.source+Ahe.source,fIt=/^(\d{2}):?(\d{2}):?(\d{2})(\.\d+)?/.source+Ahe.source,Ay="Invalid ISO 8601 date.";y(nn,"JulianDate");nn.fromGregorianDate=function(e,r){if(!(e instanceof Jw))throw new G("date must be a valid GregorianDate.");var n=yhe(e.year,e.month,e.day,e.hour,e.minute,e.second,e.millisecond);return p(r)?(ES(n[0],n[1],r),BY(r),r):new nn(n[0],n[1],Oa.UTC)};nn.fromDate=function(e,r){if(!(e instanceof Date)||isNaN(e.getTime()))throw new G("date must be a valid JavaScript Date.");var n=yhe(e.getUTCFullYear(),e.getUTCMonth()+1,e.getUTCDate(),e.getUTCHours(),e.getUTCMinutes(),e.getUTCSeconds(),e.getUTCMilliseconds());return p(r)?(ES(n[0],n[1],r),BY(r),r):new nn(n[0],n[1],Oa.UTC)};nn.fromIso8601=function(e,r){if(typeof e!="string")throw new G(Ay);e=e.replace(",",".");var n=e.split("T"),o,a=1,s=1,l=0,h=0,x=0,m=0,v=n[0],_=n[1],A,T;if(!p(v))throw new G(Ay);var w;if(n=v.match(lIt),n!==null){if(w=v.split("-").length-1,w>0&&w!==2)throw new G(Ay);o=+n[1],a=+n[2],s=+n[3]}else if(n=v.match(oIt),n!==null)o=+n[1],a=+n[2];else if(n=v.match(nIt),n!==null)o=+n[1];else{var S;if(n=v.match(aIt),n!==null){if(o=+n[1],S=+n[2],T=wS(o),S<1||T&&S>366||!T&&S>365)throw new G(Ay)}else if(n=v.match(sIt),n!==null){o=+n[1];var P=+n[2],M=+n[3]||0;if(w=v.split("-").length-1,w>0&&(!p(n[3])&&w!==1||p(n[3])&&w!==2))throw new G(Ay);var L=new Date(Date.UTC(o,0,4));S=P*7+M-L.getUTCDay()-3}else throw new G(Ay);A=new Date(Date.UTC(o,0,1)),A.setUTCDate(S),a=A.getUTCMonth()+1,s=A.getUTCDate()}if(T=wS(o),a<1||a>12||s<1||(a!==2||!T)&&s>PY[a-1]||T&&a===2&&s>DY)throw new G(Ay);var R;if(p(_)){if(n=_.match(fIt),n!==null){if(w=_.split(":").length-1,w>0&&w!==2&&w!==3)throw new G(Ay);l=+n[1],h=+n[2],x=+n[3],m=+(n[4]||0)*1e3,R=5}else if(n=_.match(cIt),n!==null){if(w=_.split(":").length-1,w>2)throw new G(Ay);l=+n[1],h=+n[2],x=+(n[3]||0)*60,R=4}else if(n=_.match(uIt),n!==null)l=+n[1],h=+(n[2]||0)*60,R=3;else throw new G(Ay);if(h>=60||x>=61||l>24||l===24&&(h>0||x>0||m>0))throw new G(Ay);var O=n[R],N=+n[R+1],k=+(n[R+2]||0);switch(O){case"+":l=l-N,h=h-k;break;case"-":l=l+N,h=h+k;break;case"Z":break;default:h=h+new Date(Date.UTC(o,a-1,s,l,h)).getTimezoneOffset();break}}var z=x===60;for(z&&x--;h>=60;)h-=60,l++;for(;l>=24;)l-=24,s++;for(A=T&&a===2?DY:PY[a-1];s>A;)s-=A,a++,a>12&&(a-=12,o++),A=T&&a===2?DY:PY[a-1];for(;h<0;)h+=60,l--;for(;l<0;)l+=24,s--;for(;s<1;)a--,a<1&&(a+=12,o--),A=T&&a===2?DY:PY[a-1],s+=A;var W=yhe(o,a,s,l,h,x,m);return p(r)?(ES(W[0],W[1],r),BY(r)):r=new nn(W[0],W[1],Oa.UTC),z&&nn.addSeconds(r,1,r),r};nn.now=function(e){return nn.fromDate(new Date,e)};MY=new nn(0,0,Oa.TAI);nn.toGregorianDate=function(e,r){if(!p(e))throw new G("julianDate is required.");var n=!1,o=$3e(e,MY);p(o)||(nn.addSeconds(e,-1,MY),o=$3e(MY,MY),n=!0);var a=o.dayNumber,s=o.secondsOfDay;s>=43200&&(a+=1);var l=a+68569|0,h=4*l/146097|0;l=l-((146097*h+3)/4|0)|0;var x=4e3*(l+1)/1461001|0;l=l-(1461*x/4|0)+31|0;var m=80*l/2447|0,v=l-(2447*m/80|0)|0;l=m/11|0;var _=m+2-12*l|0,A=100*(h-49)+x+l|0,T=s/ka.SECONDS_PER_HOUR|0,w=s-T*ka.SECONDS_PER_HOUR,S=w/ka.SECONDS_PER_MINUTE|0;w=w-S*ka.SECONDS_PER_MINUTE;var P=w|0,M=(w-P)/ka.SECONDS_PER_MILLISECOND;return T+=12,T>23&&(T-=24),n&&(P+=1),p(r)?(r.year=A,r.month=_,r.day=v,r.hour=T,r.minute=S,r.second=P,r.millisecond=M,r.isLeapSecond=n,r):new Jw(A,_,v,T,S,P,M,n)};nn.toDate=function(e){if(!p(e))throw new G("julianDate is required.");var r=nn.toGregorianDate(e,eze),n=r.second;return r.isLeapSecond&&(n-=1),new Date(Date.UTC(r.year,r.month-1,r.day,r.hour,r.minute,n,r.millisecond))};nn.toIso8601=function(e,r){if(!p(e))throw new G("julianDate is required.");var n=nn.toGregorianDate(e,eze),o=n.year,a=n.month,s=n.day,l=n.hour,h=n.minute,x=n.second,m=n.millisecond;o===1e4&&a===1&&s===1&&l===0&&h===0&&x===0&&m===0&&(o=9999,a=12,s=31,l=24);var v;return!p(r)&&m!==0?(v=(m*.01).toString().replace(".",""),Zw("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,a,s,l,h,x,v)):!p(r)||r===0?Zw("%04d-%02d-%02dT%02d:%02d:%02dZ",o,a,s,l,h,x):(v=(m*.01).toFixed(r).replace(".","").slice(0,r),Zw("%04d-%02d-%02dT%02d:%02d:%02d.%sZ",o,a,s,l,h,x,v))};nn.clone=function(e,r){if(!!p(e))return p(r)?(r.dayNumber=e.dayNumber,r.secondsOfDay=e.secondsOfDay,r):new nn(e.dayNumber,e.secondsOfDay,Oa.TAI)};nn.compare=function(e,r){if(!p(e))throw new G("left is required.");if(!p(r))throw new G("right is required.");var n=e.dayNumber-r.dayNumber;return n!==0?n:e.secondsOfDay-r.secondsOfDay};nn.equals=function(e,r){return e===r||p(e)&&p(r)&&e.dayNumber===r.dayNumber&&e.secondsOfDay===r.secondsOfDay};nn.equalsEpsilon=function(e,r,n){if(!p(n))throw new G("epsilon is required.");return e===r||p(e)&&p(r)&&Math.abs(nn.secondsDifference(e,r))<=n};nn.totalDays=function(e){if(!p(e))throw new G("julianDate is required.");return e.dayNumber+e.secondsOfDay/ka.SECONDS_PER_DAY};nn.secondsDifference=function(e,r){if(!p(e))throw new G("left is required.");if(!p(r))throw new G("right is required.");var n=(e.dayNumber-r.dayNumber)*ka.SECONDS_PER_DAY;return n+(e.secondsOfDay-r.secondsOfDay)};nn.daysDifference=function(e,r){if(!p(e))throw new G("left is required.");if(!p(r))throw new G("right is required.");var n=e.dayNumber-r.dayNumber,o=(e.secondsOfDay-r.secondsOfDay)/ka.SECONDS_PER_DAY;return n+o};nn.computeTaiMinusUtc=function(e){CF.julianDate=e;var r=nn.leapSeconds,n=T0(r,CF,_he);return n<0&&(n=~n,--n,n<0&&(n=0)),r[n].offset};nn.addSeconds=function(e,r,n){if(!p(e))throw new G("julianDate is required.");if(!p(r))throw new G("seconds is required.");if(!p(n))throw new G("result is required.");return ES(e.dayNumber,e.secondsOfDay+r,n)};nn.addMinutes=function(e,r,n){if(!p(e))throw new G("julianDate is required.");if(!p(r))throw new G("minutes is required.");if(!p(n))throw new G("result is required.");var o=e.secondsOfDay+r*ka.SECONDS_PER_MINUTE;return ES(e.dayNumber,o,n)};nn.addHours=function(e,r,n){if(!p(e))throw new G("julianDate is required.");if(!p(r))throw new G("hours is required.");if(!p(n))throw new G("result is required.");var o=e.secondsOfDay+r*ka.SECONDS_PER_HOUR;return ES(e.dayNumber,o,n)};nn.addDays=function(e,r,n){if(!p(e))throw new G("julianDate is required.");if(!p(r))throw new G("days is required.");if(!p(n))throw new G("result is required.");var o=e.dayNumber+r;return ES(o,e.secondsOfDay,n)};nn.lessThan=function(e,r){return nn.compare(e,r)<0};nn.lessThanOrEquals=function(e,r){return nn.compare(e,r)<=0};nn.greaterThan=function(e,r){return nn.compare(e,r)>0};nn.greaterThanOrEquals=function(e,r){return nn.compare(e,r)>=0};nn.prototype.clone=function(e){return nn.clone(this,e)};nn.prototype.equals=function(e){return nn.equals(this,e)};nn.prototype.equalsEpsilon=function(e,r){return nn.equalsEpsilon(this,e,r)};nn.prototype.toString=function(){return nn.toIso8601(this)};nn.leapSeconds=[new sl(new nn(2441317,43210,Oa.TAI),10),new sl(new nn(2441499,43211,Oa.TAI),11),new sl(new nn(2441683,43212,Oa.TAI),12),new sl(new nn(2442048,43213,Oa.TAI),13),new sl(new nn(2442413,43214,Oa.TAI),14),new sl(new nn(2442778,43215,Oa.TAI),15),new sl(new nn(2443144,43216,Oa.TAI),16),new sl(new nn(2443509,43217,Oa.TAI),17),new sl(new nn(2443874,43218,Oa.TAI),18),new sl(new nn(2444239,43219,Oa.TAI),19),new sl(new nn(2444786,43220,Oa.TAI),20),new sl(new nn(2445151,43221,Oa.TAI),21),new sl(new nn(2445516,43222,Oa.TAI),22),new sl(new nn(2446247,43223,Oa.TAI),23),new sl(new nn(2447161,43224,Oa.TAI),24),new sl(new nn(2447892,43225,Oa.TAI),25),new sl(new nn(2448257,43226,Oa.TAI),26),new sl(new nn(2448804,43227,Oa.TAI),27),new sl(new nn(2449169,43228,Oa.TAI),28),new sl(new nn(2449534,43229,Oa.TAI),29),new sl(new nn(2450083,43230,Oa.TAI),30),new sl(new nn(2450630,43231,Oa.TAI),31),new sl(new nn(2451179,43232,Oa.TAI),32),new sl(new nn(2453736,43233,Oa.TAI),33),new sl(new nn(2454832,43234,Oa.TAI),34),new sl(new nn(2456109,43235,Oa.TAI),35),new sl(new nn(2457204,43236,Oa.TAI),36),new sl(new nn(2457754,43237,Oa.TAI),37)];ot=nn});function Wf(e){if(e instanceof Wf)this.scheme=e.scheme,this.authority=e.authority,this.path=e.path,this.query=e.query,this.fragment=e.fragment;else if(e){var r=xIt.exec(e);this.scheme=r[1],this.authority=r[2],this.path=r[3],this.query=r[4],this.fragment=r[5]}}function LY(e){var r=unescape(e);return hIt.test(r)?r:e.toUpperCase()}function mIt(e,r,n,o){return(r||"")+n.toLowerCase()+(o||"")}var xIt,RY,hIt,dIt,Hn,qf=Ee(()=>{y(Wf,"URI");Wf.prototype.scheme=null;Wf.prototype.authority=null;Wf.prototype.path="";Wf.prototype.query=null;Wf.prototype.fragment=null;xIt=new RegExp("^(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?$");Wf.prototype.getScheme=function(){return this.scheme};Wf.prototype.getAuthority=function(){return this.authority};Wf.prototype.getPath=function(){return this.path};Wf.prototype.getQuery=function(){return this.query};Wf.prototype.getFragment=function(){return this.fragment};Wf.prototype.isAbsolute=function(){return!!this.scheme&&!this.fragment};Wf.prototype.isSameDocumentAs=function(e){return e.scheme==this.scheme&&e.authority==this.authority&&e.path==this.path&&e.query==this.query};Wf.prototype.equals=function(e){return this.isSameDocumentAs(e)&&e.fragment==this.fragment};Wf.prototype.normalize=function(){this.removeDotSegments(),this.scheme&&(this.scheme=this.scheme.toLowerCase()),this.authority&&(this.authority=this.authority.replace(dIt,mIt).replace(RY,LY)),this.path&&(this.path=this.path.replace(RY,LY)),this.query&&(this.query=this.query.replace(RY,LY)),this.fragment&&(this.fragment=this.fragment.replace(RY,LY))};RY=/%[0-9a-z]{2}/gi,hIt=/[a-zA-Z0-9\-\._~]/,dIt=/(.*@)?([^@:]*)(:.*)?/;y(LY,"replaceCase");y(mIt,"replaceAuthority");Wf.prototype.resolve=function(e){var r=new Wf;return this.scheme?(r.scheme=this.scheme,r.authority=this.authority,r.path=this.path,r.query=this.query):(r.scheme=e.scheme,this.authority?(r.authority=this.authority,r.path=this.path,r.query=this.query):(r.authority=e.authority,this.path==""?(r.path=e.path,r.query=this.query||e.query):(this.path.charAt(0)=="/"?(r.path=this.path,r.removeDotSegments()):(e.authority&&e.path==""?r.path="/"+this.path:r.path=e.path.substring(0,e.path.lastIndexOf("/")+1)+this.path,r.removeDotSegments()),r.query=this.query))),r.fragment=this.fragment,r};Wf.prototype.removeDotSegments=function(){var e=this.path.split("/"),r=[],n,o=e[0]=="";o&&e.shift();for(var a=e[0]==""?e.shift():null;e.length;)n=e.shift(),n==".."?r.pop():n!="."&&r.push(n);(n=="."||n=="..")&&r.push(""),o&&r.unshift(""),this.path=r.join("/")};Wf.prototype.toString=function(){var e="";return this.scheme&&(e+=this.scheme+":"),this.authority&&(e+="//"+this.authority),e+=this.path,this.query&&(e+="?"+this.query),this.fragment&&(e+="#"+this.fragment),e};Hn=Wf});function pIt(e){return(e.length===0||e[e.length-1]!=="/")&&(e=e+"/"),e}var TC,TF=Ee(()=>{y(pIt,"appendForwardSlash");TC=pIt});function tze(e,r){if(e===null||typeof e!="object")return e;r=B(r,!1);var n=new e.constructor;for(var o in e)if(e.hasOwnProperty(o)){var a=e[o];r&&(a=tze(a,r)),n[o]=a}return n}var Tn,c0=Ee(()=>{Ze();y(tze,"clone");Tn=tze});function rze(e,r,n){n=B(n,!1);var o={},a=p(e),s=p(r),l,h,x;if(a)for(l in e)e.hasOwnProperty(l)&&(h=e[l],s&&n&&typeof h=="object"&&r.hasOwnProperty(l)?(x=r[l],typeof x=="object"?o[l]=rze(h,x,n):o[l]=h):o[l]=h);if(s)for(l in r)r.hasOwnProperty(l)&&!o.hasOwnProperty(l)&&(x=r[l],o[l]=x);return o}var ei,Ua=Ee(()=>{Ze();De();y(rze,"combine");ei=rze});function Che(e,r){var n;return typeof document<"u"&&(n=document),Che._implementation(e,r,n)}var e1,cH=Ee(()=>{qf();Ze();De();st();y(Che,"getAbsoluteUri");Che._implementation=function(e,r,n){if(!p(e))throw new G("relative uri is required.");if(!p(r)){if(typeof n>"u")return e;r=B(n.baseURI,n.location.href)}var o=new Hn(r),a=new Hn(e);return a.resolve(o).toString()};e1=Che});function vIt(e,r){if(!p(e))throw new G("uri is required.");var n="",o=e.lastIndexOf("/");return o!==-1&&(n=e.substring(0,o+1)),r&&(e=new Hn(e),p(e.query)&&(n+="?"+e.query),p(e.fragment)&&(n+="#"+e.fragment)),n}var gm,HM=Ee(()=>{qf();De();st();y(vIt,"getBaseUri");gm=vIt});function gIt(e){if(!p(e))throw new G("uri is required.");var r=new Hn(e);r.normalize();var n=r.path,o=n.lastIndexOf("/");return o!==-1&&(n=n.substr(o+1)),o=n.lastIndexOf("."),o===-1?n="":n=n.substr(o+1),n}var bS,fH=Ee(()=>{qf();De();st();y(gIt,"getExtensionFromUri");bS=gIt});function yIt(e){return X.typeOf.string("uri",e),_It.test(e)}var _It,wF,OY=Ee(()=>{cr();_It=/^blob:/i;y(yIt,"isBlobUri");wF=yIt});function AIt(e){p(wC)||(wC=document.createElement("a")),wC.href=window.location.href;var r=wC.host,n=wC.protocol;return wC.href=e,wC.href=wC.href,n!==wC.protocol||r!==wC.host}var wC,SS,xH=Ee(()=>{De();y(AIt,"isCrossOriginUrl");SS=AIt});function TIt(e){return X.typeOf.string("uri",e),CIt.test(e)}var CIt,EC,EF=Ee(()=>{cr();CIt=/^data:/i;y(TIt,"isDataUri");EC=TIt});function wIt(e){var r=Je.defer(),n=document.createElement("script");n.async=!0,n.src=e;var o=document.getElementsByTagName("head")[0];return n.onload=function(){n.onload=void 0,o.removeChild(n),r.resolve()},n.onerror=function(a){r.reject(a)},o.appendChild(n),r.promise}var bF,FY=Ee(()=>{li();y(wIt,"loadAndExecuteScript");bF=wIt});function EIt(e,r){if(!p(e))throw new G("obj is required.");var n="";for(var o in e)if(e.hasOwnProperty(o)){var a=e[o],s=encodeURIComponent(o)+"=";if(Array.isArray(a))for(var l=0,h=a.length;l<h;++l)r===!0?n+=s+encodeURI(a[l])+"&":n+=s+encodeURIComponent(a[l])+"&";else r===!0?n+=s+encodeURI(a)+"&":n+=s+encodeURIComponent(a)+"&"}return n=n.slice(0,-1),n}var pu,t1=Ee(()=>{De();st();y(EIt,"objectToQuery");pu=EIt});function bIt(e){if(!p(e))throw new G("queryString is required.");var r={};if(e==="")return r;for(var n=e.replace(/\+/g,"%20").split(/[&;]/),o=0,a=n.length;o<a;++o){var s=n[o].split("=");if(s.length>2){var l=n[o].indexOf("="),h=n[o].substring(0,l),x=n[o].substring(l+1,n[o].length);s=[h,x]}var m=decodeURIComponent(s[0]),v=s[1];p(v)?v=decodeURIComponent(v):v="";var _=r[m];typeof _=="string"?r[m]=[_,v]:Array.isArray(_)?_.push(v):r[m]=v}return r}var X0,WM=Ee(()=>{De();st();y(bIt,"queryToObject");X0=bIt});var SIt,Ga,hg=Ee(()=>{SIt={UNISSUED:0,ISSUED:1,ACTIVE:2,RECEIVED:3,CANCELLED:4,FAILED:5},Ga=Object.freeze(SIt)});var IIt,ro,Tc=Ee(()=>{IIt={TERRAIN:0,IMAGERY:1,TILES3D:2,OTHER:3,PACK:4,BLOCK:5,BLOCKPACK:6},ro=Object.freeze(IIt)});function NY(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.throttleByServer,!1),n=B(e.throttle,!1);this.url=e.url,this.requestFunction=e.requestFunction,this.cancelFunction=e.cancelFunction,this.priorityFunction=e.priorityFunction,this.priority=B(e.priority,0),this.throttle=n,this.throttleByServer=r,this.type=B(e.type,ro.OTHER),this.serverKey=void 0,this.state=Ga.UNISSUED,this.deferred=void 0,this.cancelled=!1}var ta,f0=Ee(()=>{Ze();De();hg();Tc();y(NY,"Request");NY.prototype.cancel=function(){this.cancelled=!0};NY.prototype.clone=function(e){return p(e)?(e.url=this.url,e.requestFunction=this.requestFunction,e.cancelFunction=this.cancelFunction,e.priorityFunction=this.priorityFunction,e.priority=this.priority,e.throttle=this.throttle,e.throttleByServer=this.throttleByServer,e.type=this.type,e.serverKey=this.serverKey,e.state=this.RequestState.UNISSUED,e.deferred=void 0,e.cancelled=!1,e):new NY(this)};ta=NY});function PIt(e){var r={};if(!e)return r;for(var n=e.split(`\r
`),o=0;o<n.length;++o){var a=n[o],s=a.indexOf(": ");if(s>0){var l=a.substring(0,s),h=a.substring(s+2);r[l]=h}}return r}var zY,The=Ee(()=>{y(PIt,"parseResponseHeaders");zY=PIt});function ize(e,r,n){this.statusCode=e,this.response=r,this.responseHeaders=n,typeof this.responseHeaders=="string"&&(this.responseHeaders=zY(this.responseHeaders))}var bC,VY=Ee(()=>{De();The();y(ize,"RequestErrorEvent");ize.prototype.toString=function(){var e="Request has failed.";return p(this.statusCode)&&(e+=" Status Code: "+this.statusCode),e};bC=ize});function hH(){this._listeners=[],this._scopes=[],this._toRemove=[],this._insideRaiseEvent=!1}function DIt(e,r){return r-e}var It,ti=Ee(()=>{cr();De();y(hH,"Event");Object.defineProperties(hH.prototype,{numberOfListeners:{get:function(){return this._listeners.length-this._toRemove.length}}});hH.prototype.addEventListener=function(e,r){X.typeOf.func("listener",e),this._listeners.push(e),this._scopes.push(r);var n=this;return function(){n.removeEventListener(e,r)}};hH.prototype.removeEventListener=function(e,r){X.typeOf.func("listener",e);for(var n=this._listeners,o=this._scopes,a=-1,s=0;s<n.length;s++)if(n[s]===e&&o[s]===r){a=s;break}return a!==-1?(this._insideRaiseEvent?(this._toRemove.push(a),n[a]=void 0,o[a]=void 0):(n.splice(a,1),o.splice(a,1)),!0):!1};y(DIt,"compareNumber");hH.prototype.raiseEvent=function(){this._insideRaiseEvent=!0;var e,r=this._listeners,n=this._scopes,o=r.length;for(e=0;e<o;e++){var a=r[e];p(a)&&r[e].apply(n[e],arguments)}var s=this._toRemove;if(o=s.length,o>0){for(s.sort(DIt),e=0;e<o;e++){var l=s[e];r.splice(l,1),n.splice(l,1)}s.length=0}this._insideRaiseEvent=!1};It=hH});function qM(e){X.typeOf.object("options",e),X.defined("options.comparator",e.comparator),this._comparator=e.comparator,this._array=[],this._length=0,this._maximumLength=void 0}function whe(e,r,n){var o=e[r];e[r]=e[n],e[n]=o}var r1,dH=Ee(()=>{cr();Ze();De();y(qM,"Heap");Object.defineProperties(qM.prototype,{length:{get:function(){return this._length}},internalArray:{get:function(){return this._array}},maximumLength:{get:function(){return this._maximumLength},set:function(e){this._maximumLength=e,this._length>e&&e>0&&(this._length=e,this._array.length=e)}},comparator:{get:function(){return this._comparator}}});y(whe,"swap");qM.prototype.reserve=function(e){e=B(e,this._length),this._array.length=e};qM.prototype.heapify=function(e){e=B(e,0);for(var r=this._length,n=this._comparator,o=this._array,a=-1,s=!0;s;){var l=2*(e+1),h=l-1;h<r&&n(o[h],o[e])<0?a=h:a=e,l<r&&n(o[l],o[a])<0&&(a=l),a!==e?(whe(o,a,e),e=a):s=!1}};qM.prototype.resort=function(){for(var e=this._length,r=Math.ceil(e/2);r>=0;--r)this.heapify(r)};qM.prototype.insert=function(e){X.defined("element",e);var r=this._array,n=this._comparator,o=this._maximumLength,a=this._length++;for(a<r.length?r[a]=e:r.push(e);a!==0;){var s=Math.floor((a-1)/2);if(n(r[a],r[s])<0)whe(r,a,s),a=s;else break}var l;return p(o)&&this._length>o&&(l=r[o],r.pop(),this._length=o),l};qM.prototype.pop=function(e){if(e=B(e,0),this._length!==0){X.typeOf.number.lessThan("index",e,this._length);var r=this._array,n=r[e];return whe(r,e,--this._length),r[this._length]=void 0,this.heapify(e),n}};r1=qM});var Ehe,jo,mf=Ee(()=>{typeof performance<"u"&&typeof performance.now=="function"&&isFinite(performance.now())?Ehe=y(function(){return performance.now()},"getTimestamp"):Ehe=y(function(){return Date.now()},"getTimestamp");jo=Ehe});function nze(e,r){return e.priority-r.priority}function Dn(){}function bhe(e){p(e.priorityFunction)&&(e.priority=e.priorityFunction())}function She(e){var r=B(Dn.requestsByServer[e],Dn.maximumRequestsPerServer);return i1[e]<r}function Ihe(e){return p(e.packKey)||(e.packKey=e.serverKey+"_"+e.providerName),e.packKey}function oze(e){return p(e.blockKey)||(e.blockKey=e.serverKey+"_"+e.providerName+"_"+e.quadKey+e.url.substring(e.url.indexOf("dataVersion"))),e.blockKey}function BIt(e){var r=Ihe(e);return p(Dn.packRequestGroup[r])||(Dn.packRequestGroup[r]=[]),p(Dn.packRequestQuadKey[r])||(Dn.packRequestQuadKey[r]=""),p(Dn.packRequestPromise[r])||(Dn.packRequestPromise[r]=Je.defer()),p(Dn.quadKeyIndex[r])||(Dn.quadKeyIndex[r]=0),e.quadKeyIndex=Dn.quadKeyIndex[r]++,e.deferred=Dn.packRequestPromise[r],e.state=Ga.ISSUED,Dn.packRequestGroup[r].push(e),e.deferred.promise}function RIt(e){var r=oze(e),n=Dn.blockDefer[r];return p(n)||(n=Dn.blockDefer[r]=Je.defer(),Dn.blockRequest[r]=e),e.deferred=n,e.state=Ga.ISSUED,e.deferred.promise}function LIt(){Dn.packRequestGroup={},Dn.packRequestPromise={},Dn.packRequestQuadKey={},Dn.quadKeyIndex={}}function OIt(){Dn.blockRequest={}}function FIt(e){for(var r=0,n=e.length;r<n;r++){var o=e[r];o.state=Ga.CANCELLED}}function NIt(e){for(var r=[],n={},o=0,a=e.length;o<a;o++){var s=e[o];if(!s.cancelled){var l=s.quadKey;n[l]||(n[l]=!0,r.push(l))}}return r}function zIt(){var e=Dn.packRequestGroup;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];if(n.length<1)continue;var o=n[0].clone(),a=o.url.indexOf("rest/maps")!==-1;o.serverKey=n[0].serverKey,o.state=n[0].state;var s=o.url,l=NIt(n);if(l.length<1)continue;a?Dn.packRequestQuadKey[r]=l.join(","):Dn.packRequestQuadKey[r]=l.join(";");var h=Dn.packRequestQuadKey[r];if(o.throttleByServer&&!She(o.serverKey)){FIt(n),Dn.packRequestPromise[r].reject();continue}o.deferred=Dn.packRequestPromise[r];var x=new Hn(s);a?x.query=p(x.query)?x.query+"&tiles="+h:"tiles="+h:x.query=p(x.query)?x.query+"&extratiles="+h:"extratiles="+h,o.url=x.toString(),UY(o,o.url)}LIt()}function VIt(){var e=Dn.blockRequest;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];UY(n)}OIt()}function aze(e){if(e.state===Ga.UNISSUED)if(e.state=Ga.ISSUED,e.type===ro.PACK||e.type===ro.BLOCKPACK){var r=Ihe(e);p(Dn.packRequestPromise[r])||(Dn.packRequestPromise[r]=Je.defer()),e.deferred=Dn.packRequestPromise[r]}else e.deferred=Je.defer();return e.deferred.promise}function kIt(e){return function(r){if(e.state!==Ga.CANCELLED&&(--Qs.numberOfActiveRequests,--i1[e.serverKey],kY.raiseEvent(),e.state=Ga.RECEIVED,e.deferred.resolve(r),e.endTime=jo(),(Dn.statisticRequestTime>0||e.type!==ro.OTHER)&&(Qs.totalRequestTime+=e.endTime-e.startTime),e.type===ro.BLOCK||e.type===ro.BLOCKPACK)){var n=oze(e);p(Dn.blockDefer[n])&&(Dn.blockDefer[n]=void 0,delete Dn.blockDefer[n])}}}function UIt(e){return function(r){e.state!==Ga.CANCELLED&&(++Qs.numberOfFailedRequests,--Qs.numberOfActiveRequests,--i1[e.serverKey],kY.raiseEvent(r),e.state=Ga.FAILED,e.deferred.reject(r))}}function UY(e,r){var n=aze(e);return e.state=Ga.ACTIVE,Cy.push(e),++Qs.numberOfActiveRequests,++Qs.numberOfActiveRequestsEver,++i1[e.serverKey],e.startTime=jo(),e.requestFunction(r).then(kIt(e)).otherwise(UIt(e)),n}function IS(e){var r=e.state===Ga.ACTIVE;e.state=Ga.CANCELLED,++Qs.numberOfCancelledRequests,e.deferred.reject(),r&&(--Qs.numberOfActiveRequests,--i1[e.serverKey],++Qs.numberOfCancelledActiveRequests),p(e.cancelFunction)&&e.cancelFunction()}function GIt(){for(var e in Dn.packRequestHeap)if(Dn.packRequestHeap.hasOwnProperty(e)){for(var r=Dn.packRequestHeap[e],n=r.internalArray,o=r.length,a=0;a<o;++a)bhe(n[a]);r.resort()}}function HIt(){for(var e in Dn.packRequestHeap)if(Dn.packRequestHeap.hasOwnProperty(e))for(var r=Dn.packRequestHeap[e];r.length>0;){var n=r.pop();if(n.cancelled){IS(n);continue}BIt(n)}zIt()}function WIt(e){var r=Ihe(e),n=Dn.packRequestHeap[r];return p(n)||(n=Dn.packRequestHeap[r]=new r1({comparator:nze}),n.maximumLength=Dn.perPacketCount,n.reserve(SF)),n}function qIt(){!Dn.debugShowStatistics||(Qs.numberOfActiveRequests===0&&Qs.lastNumberOfActiveRequests>0&&(Qs.numberOfAttemptedRequests>0&&(console.log("Number of attempted requests: "+Qs.numberOfAttemptedRequests),Qs.numberOfAttemptedRequests=0),Qs.numberOfCancelledRequests>0&&(console.log("Number of cancelled requests: "+Qs.numberOfCancelledRequests),Qs.numberOfCancelledRequests=0),Qs.numberOfCancelledActiveRequests>0&&(console.log("Number of cancelled active requests: "+Qs.numberOfCancelledActiveRequests),Qs.numberOfCancelledActiveRequests=0),Qs.numberOfFailedRequests>0&&(console.log("Number of failed requests: "+Qs.numberOfFailedRequests),Qs.numberOfFailedRequests=0)),Qs.lastNumberOfActiveRequests=Qs.numberOfActiveRequests)}var Qs,SF,_m,Cy,i1,MIt,kY,Il,W2=Ee(()=>{qf();li();cr();Ze();De();ti();dH();OY();EF();hg();Tc();mf();y(nze,"sortRequests");Qs={numberOfAttemptedRequests:0,numberOfActiveRequests:0,numberOfCancelledRequests:0,numberOfCancelledActiveRequests:0,numberOfFailedRequests:0,numberOfActiveRequestsEver:0,lastNumberOfActiveRequests:0,totalRequestTime:0},SF=20,_m=new r1({comparator:nze});_m.maximumLength=SF;_m.reserve(SF);Cy=[],i1={},MIt=typeof document<"u"?new Hn(document.location.href):new Hn,kY=new It;y(Dn,"RequestScheduler");Dn.TIMEOUT=5e3;Dn.CANCLE_COUNT=3;Dn.statisticRequestTime=-1;Dn.maximumRequests=50;Dn.maximumRequestsPerServer=6;Dn.perPacketCount=20;Dn.requestsByServer={};Dn.throttleRequests=!0;Dn.debugShowStatistics=!1;Dn.requestCompletedEvent=kY;Object.defineProperties(Dn,{activeRequestLength:{get:function(){return Cy.length}},statistics:{get:function(){return Qs}},priorityHeapLength:{get:function(){return SF},set:function(e){if(e<SF)for(;_m.length>e;){var r=_m.pop();IS(r)}SF=e,_m.maximumLength=e,_m.reserve(e)}}});y(bhe,"updatePriority");y(She,"serverHasOpenSlots");Dn.packRequestGroup={};Dn.packRequestPromise={};Dn.packRequestQuadKey={};Dn.quadKeyIndex={};Dn.packRequestHeap={};Dn.blockDefer={};Dn.blockRequest={};y(Ihe,"getRequestKey");y(oze,"getRequestBlockKey");y(BIt,"preparePackRequest");y(RIt,"prepareBlockRequest");y(LIt,"clearRequestPackets");y(OIt,"clearBlockRequest");y(FIt,"cancelAllRequests");y(NIt,"combineQuadkey");y(zIt,"startPackingRequest");y(VIt,"updateBlockRequest");y(aze,"issueRequest");y(kIt,"getRequestReceivedFunction");y(UIt,"getRequestFailedFunction");y(UY,"startRequest");y(IS,"cancelRequest");y(GIt,"updatePackRequestHeap");y(HIt,"packingRequest");Dn.update=function(){var e,r,n=0,o=Cy.length;for(e=0;e<o;++e){if(r=Cy[e],r.cancelled&&IS(r),r.state!==Ga.ACTIVE){++n;continue}n>0&&(Cy[e-n]=r)}Cy.length-=n;var a=_m.internalArray,s=_m.length;for(e=0;e<s;++e)bhe(a[e]);_m.resort(),GIt(),VIt(),HIt();for(var l=Math.max(Dn.maximumRequests-Cy.length,0),h=0;h<l&&_m.length>0;){if(r=_m.pop(),r.cancelled){IS(r);continue}if(r.throttleByServer&&!She(r.serverKey)){IS(r);continue}UY(r),++h}qIt()};Dn.getServerKey=function(e){X.typeOf.string("url",e);var r=new Hn(e).resolve(MIt);r.normalize();var n=r.authority;/:/.test(n)||(n=n+":"+(r.scheme==="https"?"443":"80"));var o=i1[n];return p(o)||(i1[n]=0),n};y(WIt,"getPackRequestHeap");Dn.request=function(e){if(X.typeOf.object("request",e),X.typeOf.string("request.url",e.url),X.typeOf.func("request.requestFunction",e.requestFunction),EC(e.url)||wF(e.url))return kY.raiseEvent(),e.state=Ga.RECEIVED,e.requestFunction();if(++Qs.numberOfAttemptedRequests,p(e.serverKey)||(e.serverKey=Dn.getServerKey(e.url)),e.type===ro.BLOCK)return RIt(e);if(!(e.throttleByServer&&!She(e.serverKey))){if(!Dn.throttleRequests||!e.throttle)return UY(e);if(!(Cy.length>=Dn.maximumRequests)){bhe(e);var r;if(e.type===ro.PACK||e.type===ro.BLOCKPACK){var n=WIt(e),o=!0;if(e.type===ro.BLOCKPACK){for(var a=0;a<n.length;a++)if(n._array[a].quadKey===e.quadKey){e.blockRequest=n._array[a],o=!1;break}}o&&(r=n.insert(e))}else r=_m.insert(e);if(p(r)){if(r===e)return;IS(r)}return aze(e)}}};y(qIt,"updateStatistics");Dn.clearForSpecs=function(){for(;_m.length>0;){var e=_m.pop();IS(e)}for(var r=Cy.length,n=0;n<r;++n)IS(Cy[n]);Cy.length=0,i1={},Qs.numberOfAttemptedRequests=0,Qs.numberOfActiveRequests=0,Qs.numberOfCancelledRequests=0,Qs.numberOfCancelledActiveRequests=0,Qs.numberOfFailedRequests=0,Qs.numberOfActiveRequestsEver=0,Qs.lastNumberOfActiveRequests=0,Qs.totalRequestTime=0};Dn.numberOfActiveRequestsByServer=function(e){return i1[e]};Dn.requestHeap=_m;Il=Dn});function jIt(e){var r=new Hn(e);r.normalize();var n=r.getAuthority();if(!!p(n)){if(n.indexOf("@")!==-1){var o=n.split("@");n=o[1]}if(n.indexOf(":")===-1){var a=r.getScheme();if(p(a)||(a=window.location.protocol,a=a.substring(0,a.length-1)),a==="http")n+=":80";else if(a==="https")n+=":443";else return}return n}}var mH,IF,n1,PF=Ee(()=>{qf();De();st();mH={},IF={};mH.add=function(e,r){if(!p(e))throw new G("host is required.");if(!p(r)||r<=0)throw new G("port is required to be greater than 0.");var n=e.toLowerCase()+":"+r;p(IF[n])||(IF[n]=!0)};mH.remove=function(e,r){if(!p(e))throw new G("host is required.");if(!p(r)||r<=0)throw new G("port is required to be greater than 0.");var n=e.toLowerCase()+":"+r;p(IF[n])&&delete IF[n]};y(jIt,"getAuthority");mH.contains=function(e){if(!p(e))throw new G("url is required.");var r=jIt(e);return!!(p(r)&&p(IF[r]))};mH.clear=function(){IF={}};n1=mH});function pH(e,r){if(!p(e))throw new G("identifier is required.");p(sze[e])||(sze[e]=!0,console.warn(B(r,e)))}var sze,Eo,SC=Ee(()=>{Ze();De();st();sze={};y(pH,"oneTimeWarning");pH.geometryOutlines="Entity geometry outlines are unsupported on terrain. Outlines will be disabled. To enable outlines, disable geometry terrain clamping by explicitly setting height to 0.";pH.geometryZIndex="Entity geometry with zIndex are unsupported when height or extrudedHeight are defined.  zIndex will be ignored";pH.geometryHeightReference="Entity corridor, ellipse, polygon or rectangle with heightReference must also have a defined height.  heightReference will be ignored";pH.geometryExtrudedHeightReference="Entity corridor, ellipse, polygon or rectangle with extrudedHeightReference must also have a defined extrudedHeight.  extrudedHeightReference will be ignored";Eo=pH});function YIt(e,r){if(!p(e)||!p(r))throw new G("identifier and message are required.");Eo(e,r)}var w0,Dp=Ee(()=>{De();st();SC();y(YIt,"deprecationWarning");w0=YIt});function Dhe(e,r,n,o){var a=e.query;if(!p(a)||a.length===0)return{};var s;if(a.indexOf("=")===-1){var l={};l[a]=void 0,s=l}else s=X0(a);n?r._queryParameters=HY(s,r._queryParameters,o):r._queryParameters=s,e.query=void 0}function QIt(e,r){var n=r._queryParameters,o=Object.keys(n);o.length===1&&!p(n[o[0]])?e.query=o[0]:e.query=pu(n)}function IC(e,r){return p(e)?p(e.clone)?e.clone():Tn(e):r}function Mhe(e){if(e.state===Ga.ISSUED||e.state===Ga.ACTIVE)throw new Ht("The Resource is already being fetched.");e.state=Ga.UNISSUED,e.deferred=void 0}function HY(e,r,n){if(!n)return ei(e,r);var o=Tn(e,!0);for(var a in r)if(r.hasOwnProperty(a)){var s=o[a],l=r[a];p(s)?(Array.isArray(s)||(s=o[a]=[s]),o[a]=s.concat(l)):o[a]=Array.isArray(l)?l.slice():l}return o}function sn(e){e=B(e,B.EMPTY_OBJECT),typeof e=="string"&&(e={url:e}),X.typeOf.string("options.url",e.url),this._url=void 0,this._templateValues=IC(e.templateValues,{}),this._queryParameters=IC(e.queryParameters,{}),this.headers=IC(e.headers,{}),this.request=B(e.request,new ta),this.proxy=e.proxy,this.retryCallback=e.retryCallback,this.retryAttempts=B(e.retryAttempts,0),this._retryCount=0;var r=new Hn(e.url);Dhe(r,this,!0,!0),r.fragment=void 0,this._url=r.toString()}function Phe(e){var r=e.resource,n=e.flipY,o=e.preferImageBitmap,a=r.request;a.url=r.url,a.requestFunction=function(){var l=!1;!r.isDataUri&&!r.isBlobUri&&(l=r.isCrossOriginUrl);var h=Je.defer();return sn._Implementations.createImage(a,l,h,n,o),h.promise};var s=Il.request(a);if(!!p(s))return s.otherwise(function(l){return a.state!==Ga.FAILED?Je.reject(l):r.retryOnError(l).then(function(h){return h?(a.state=Ga.UNISSUED,a.deferred=void 0,Phe({resource:r,flipY:n,preferImageBitmap:o})):Je.reject(l)})})}function cze(e,r,n){var o={};o[r]=n,e.setQueryParameters(o);var a=e.request;a.url=e.url,a.requestFunction=function(){var l=Je.defer();return window[n]=function(h){l.resolve(h);try{delete window[n]}catch{window[n]=void 0}},sn._Implementations.loadAndExecuteScript(e.url,n,l),l.promise};var s=Il.request(a);if(!!p(s))return s.otherwise(function(l){return a.state!==Ga.FAILED?Je.reject(l):e.retryOnError(l).then(function(h){return h?(a.state=Ga.UNISSUED,a.deferred=void 0,cze(e,r,n)):Je.reject(l)})})}function GY(e,r){var n=decodeURIComponent(r);return e?atob(n):n}function lze(e,r){for(var n=GY(e,r),o=new ArrayBuffer(n.length),a=new Uint8Array(o),s=0;s<n.length;s++)a[s]=n.charCodeAt(s);return o}function KIt(e,r){r=B(r,"");var n=e[1],o=!!e[2],a=e[3];switch(r){case"":case"text":return GY(o,a);case"arraybuffer":return lze(o,a);case"blob":var s=lze(o,a);return new Blob([s],{type:n});case"document":var l=new DOMParser;return l.parseFromString(GY(o,a),n);case"json":return JSON.parse(GY(o,a));default:throw new G("Unhandled responseType: "+r)}}function ZIt(e,r,n){var o=new Image;o.crossOrigin="",o.onload=function(){n.resolve(o)},o.onerror=function(a){n.reject(a)},r&&(n1.contains(e)?o.crossOrigin="use-credentials":o.crossOrigin=""),o.src=e}function JIt(e,r,n,o,a,s,l){fetch(e,{method:n,headers:a}).then(async h=>{if(!h.ok){let x={};h.headers.forEach((m,v)=>{x[v]=m}),s.reject(new bC(h.status,h,x));return}switch(r){case"text":s.resolve(h.text());break;case"json":s.resolve(h.json());break;default:s.resolve(new Uint8Array(await h.arrayBuffer()).buffer);break}}).catch(()=>{s.reject(new bC)})}var uze,DF,XIt,$It,ir,hn=Ee(()=>{qf();li();TF();cr();c0();Ua();Ze();De();st();cH();HM();fH();OY();xH();EF();FY();t1();WM();f0();VY();W2();hg();zo();PF();Dp();uze=function(){try{var e=new XMLHttpRequest;return e.open("GET","#",!0),e.responseType="blob",e.responseType==="blob"}catch{return!1}}();y(Dhe,"parseQuery");y(QIt,"stringifyQuery");y(IC,"defaultClone");y(Mhe,"checkAndResetRequest");y(HY,"combineQueryParameters");y(sn,"Resource");sn.createIfNeeded=function(e){return e instanceof sn?e.getDerivedResource({request:e.request}):typeof e!="string"?e:new sn({url:e})};sn.supportsImageBitmapOptions=function(){if(p(DF))return DF;if(typeof createImageBitmap!="function")return DF=Je.resolve(!1),DF;var e="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVQImWP4////fwAJ+wP9CNHoHgAAAABJRU5ErkJggg==";return DF=sn.fetchBlob({url:e}).then(function(r){return createImageBitmap(r,{imageOrientation:"flipY",premultiplyAlpha:"none"})}).then(function(r){return!0}).otherwise(function(){return!1}),DF};Object.defineProperties(sn,{isBlobSupported:{get:function(){return uze}}});Object.defineProperties(sn.prototype,{queryParameters:{get:function(){return this._queryParameters}},templateValues:{get:function(){return this._templateValues}},url:{get:function(){return this.getUrlComponent(!0,!0)},set:function(e){var r=new Hn(e);Dhe(r,this,!1),r.fragment=void 0,this._url=r.toString()}},extension:{get:function(){return bS(this._url)}},isDataUri:{get:function(){return EC(this._url)}},isBlobUri:{get:function(){return wF(this._url)}},isCrossOriginUrl:{get:function(){return SS(this._url)}},hasHeaders:{get:function(){return Object.keys(this.headers).length>0}}});sn.prototype.getUrlComponent=function(e,r){if(this.isDataUri)return this._url;var n=new Hn(this._url);e&&QIt(n,this);var o=n.toString().replace(/%7B/g,"{").replace(/%7D/g,"}"),a=this._templateValues;return o=o.replace(/{(.*?)}/g,function(s,l){var h=a[l];return p(h)&&l=="s"?encodeURI(h):p(h)?encodeURIComponent(h):s}),r&&p(this.proxy)&&(o=this.proxy.getURL(o)),o};sn.prototype.setQueryParameters=function(e,r){r?this._queryParameters=HY(this._queryParameters,e,!1):this._queryParameters=HY(e,this._queryParameters,!1)};sn.prototype.appendQueryParameters=function(e){this._queryParameters=HY(e,this._queryParameters,!0)};sn.prototype.setTemplateValues=function(e,r){r?this._templateValues=ei(this._templateValues,e):this._templateValues=ei(e,this._templateValues)};sn.prototype.getDerivedResource=function(e){var r=this.clone();if(r._retryCount=0,p(e.url)){var n=new Hn(e.url),o=B(e.preserveQueryParameters,!1);Dhe(n,r,!0,o),n.fragment=void 0,r._url=n.resolve(new Hn(e1(this._url))).toString()}return p(e.queryParameters)&&(r._queryParameters=ei(e.queryParameters,r._queryParameters)),p(e.templateValues)&&(r._templateValues=ei(e.templateValues,r.templateValues)),p(e.headers)&&(r.headers=ei(e.headers,r.headers)),p(e.proxy)&&(r.proxy=e.proxy),p(e.request)&&(r.request=e.request),p(e.retryCallback)&&(r.retryCallback=e.retryCallback),p(e.retryAttempts)&&(r.retryAttempts=e.retryAttempts),r};sn.prototype.retryOnError=function(e){var r=this.retryCallback;if(typeof r!="function"||this._retryCount>=this.retryAttempts)return Je(!1);var n=this;return Je(r(this,e)).then(function(o){return++n._retryCount,o})};sn.prototype.clone=function(e){return p(e)||(e=new sn({url:this._url})),e._url=this._url,e._queryParameters=Tn(this._queryParameters),e._templateValues=Tn(this._templateValues),e.headers=Tn(this.headers),e.proxy=this.proxy,e.retryCallback=this.retryCallback,e.retryAttempts=this.retryAttempts,e._retryCount=0,e.request=this.request.clone(),e};sn.prototype.getBaseUri=function(e){return gm(this.getUrlComponent(e),e)};sn.prototype.appendForwardSlash=function(){this._url=TC(this._url)};sn.prototype.fetchArrayBuffer=function(){return this.fetch({responseType:"arraybuffer"})};sn.fetchArrayBuffer=function(e){var r=new sn(e);return r.fetchArrayBuffer()};sn.prototype.fetchBlob=function(){return this.fetch({responseType:"blob"})};sn.fetchBlob=function(e){var r=new sn(e);return r.fetchBlob()};sn.prototype.fetchImage=function(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.preferImageBitmap,!1),n=B(e.preferBlob,!1),o=B(e.flipY,!1);if(Mhe(this.request),!uze||this.isDataUri||this.isBlobUri||!this.hasHeaders&&!n)return Phe({resource:this,flipY:o,preferImageBitmap:r});var a=this.fetchBlob();if(!!p(a)){var s,l,h,x;return sn.supportsImageBitmapOptions().then(function(m){return s=m,l=s&&r,a}).then(function(m){if(!!p(m)){if(x=m,l)return sn.createImageBitmapFromBlob(m,{flipY:o,premultiplyAlpha:!1});var v=window.URL.createObjectURL(m);return h=new sn({url:v}),Phe({resource:h,flipY:o,preferImageBitmap:!1})}}).then(function(m){if(!!p(m))return m.blob=x,l||window.URL.revokeObjectURL(h.url),m}).otherwise(function(m){return p(h)&&window.URL.revokeObjectURL(h.url),m.blob=x,Je.reject(m)})}};y(Phe,"fetchImage");sn.fetchImage=function(e){var r=new sn(e);return r.fetchImage({flipY:e.flipY,preferBlob:e.preferBlob,preferImageBitmap:e.preferImageBitmap})};sn.prototype.fetchText=function(){return this.fetch({responseType:"text"})};sn.fetchText=function(e){var r=new sn(e);return r.fetchText()};sn.prototype.fetchJson=function(){var e=this.fetch({responseType:"text",headers:{Accept:"application/json,*/*;q=0.01"}});if(!!p(e))return e.then(function(r){if(!!p(r))return JSON.parse(r)})};sn.fetchJson=function(e){var r=new sn(e);return r.fetchJson()};sn.prototype.fetchXML=function(){return this.fetch({responseType:"document",overrideMimeType:"text/xml"})};sn.fetchXML=function(e){var r=new sn(e);return r.fetchXML()};sn.prototype.fetchJsonp=function(e){e=B(e,"callback"),Mhe(this.request);var r;do r="loadJsonp"+Math.random().toString().substring(2,8);while(p(window[r]));return cze(this,e,r)};y(cze,"fetchJsonp");sn.fetchJsonp=function(e){var r=new sn(e);return r.fetchJsonp(e.callbackParameterName)};sn.prototype._makeRequest=function(e){var r=this;Mhe(r.request);var n=r.request;n.url=r.url,n.requestFunction=function(a){var s=e.responseType,l=ei(e.headers,r.headers),h=e.overrideMimeType,x=e.method,m=e.data,v=Je.defer(),_=p(a)?a:r.url,A=sn._Implementations.loadWithXhr(_,s,x,m,l,v,h);return p(A)&&p(A.abort)&&(n.cancelFunction=function(){A.abort()}),v.promise};var o=Il.request(n);if(!!p(o))return o.then(function(a){return a}).otherwise(function(a){return n.state!==Ga.FAILED?Je.reject(a):r.retryOnError(a).then(function(s){return s?(n.state=Ga.UNISSUED,n.deferred=void 0,r.fetch(e)):Je.reject(a)})})};XIt=/^data:(.*?)(;base64)?,(.*)$/;y(GY,"decodeDataUriText");y(lze,"decodeDataUriArrayBuffer");y(KIt,"decodeDataUri");sn.prototype.fetch=function(e){return e=IC(e,{}),e.method="GET",this._makeRequest(e)};sn.fetch=function(e){var r=new sn(e);return r.fetch({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn.prototype.delete=function(e){return e=IC(e,{}),e.method="DELETE",this._makeRequest(e)};sn.delete=function(e){var r=new sn(e);return r.delete({responseType:e.responseType,overrideMimeType:e.overrideMimeType,data:e.data})};sn.prototype.head=function(e){return e=IC(e,{}),e.method="HEAD",this._makeRequest(e)};sn.head=function(e){var r=new sn(e);return r.head({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn.prototype.options=function(e){return e=IC(e,{}),e.method="OPTIONS",this._makeRequest(e)};sn.options=function(e){var r=new sn(e);return r.options({responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn.prototype.post=function(e,r){return X.defined("data",e),r=IC(r,{}),r.method="POST",r.data=e,this._makeRequest(r)};sn.post=function(e){var r=new sn(e);return r.post(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn.prototype.put=function(e,r){return X.defined("data",e),r=IC(r,{}),r.method="PUT",r.data=e,this._makeRequest(r)};sn.put=function(e){var r=new sn(e);return r.put(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn.prototype.patch=function(e,r){return X.defined("data",e),r=IC(r,{}),r.method="PATCH",r.data=e,this._makeRequest(r)};sn.patch=function(e){var r=new sn(e);return r.patch(e.data,{responseType:e.responseType,overrideMimeType:e.overrideMimeType})};sn._Implementations={};y(ZIt,"loadImageElement");sn._Implementations.createImage=function(e,r,n,o,a){var s=e.url;sn.supportsImageBitmapOptions().then(function(l){if(!(l&&a)){ZIt(s,r,n);return}var h="blob",x="GET",m=Je.defer(),v=sn._Implementations.loadWithXhr(s,h,x,void 0,void 0,m,void 0,void 0,void 0);return p(v)&&p(v.abort)&&(e.cancelFunction=function(){v.abort()}),m.promise.then(function(_){if(!p(_)){n.reject(new Ht("Successfully retrieved "+s+" but it contained no content."));return}return sn.createImageBitmapFromBlob(_,{flipY:o,premultiplyAlpha:!1})}).then(n.resolve)}).otherwise(n.reject)};sn.createImageBitmapFromBlob=function(e,r){return X.defined("options",r),X.typeOf.bool("options.flipY",r.flipY),X.typeOf.bool("options.premultiplyAlpha",r.premultiplyAlpha),createImageBitmap(e,{imageOrientation:r.flipY?"flipY":"none",premultiplyAlpha:r.premultiplyAlpha?"premultiply":"none"})};y(JIt,"loadWithHttpRequest");$It=typeof XMLHttpRequest>"u";sn._Implementations.loadWithXhr=function(e,r,n,o,a,s,l){var h=XIt.exec(e);if(h!==null){s.resolve(KIt(h,r));return}if($It){JIt(e,r,n,o,a,s,l);return}var x=new XMLHttpRequest;if(n1.contains(e)&&(x.withCredentials=!0),e=e.replace(/{/g,"%7B").replace(/}/g,"%7D"),x.open(n,e,!0),p(l)&&p(x.overrideMimeType)&&x.overrideMimeType(l),p(a))for(var m in a)a.hasOwnProperty(m)&&x.setRequestHeader(m,a[m]);p(r)&&(x.responseType=r);var v=!1;return typeof e=="string"&&(v=e.indexOf("file://")===0||typeof window<"u"&&window.location.origin==="file://"),x.onload=function(){if((x.status<200||x.status>=300)&&!(v&&x.status===0)){s.reject(new bC(x.status,x.response,x.getAllResponseHeaders()));return}var _=x.response,A=x.responseType;if(n==="HEAD"||n==="OPTIONS"){var T=x.getAllResponseHeaders(),w=T.trim().split(/[\r\n]+/),S={};w.forEach(function(P){var M=P.split(": "),L=M.shift();S[L]=M.join(": ")}),s.resolve(S);return}if(x.status===204)s.resolve();else if(p(_)&&(!p(r)||A===r))s.resolve(_);else if(r==="json"&&typeof _=="string")try{s.resolve(JSON.parse(_))}catch(P){s.reject(P)}else(A===""||A==="document")&&p(x.responseXML)&&x.responseXML.hasChildNodes()?s.resolve(x.responseXML):(A===""||A==="text")&&p(x.responseText)?s.resolve(x.responseText):s.reject(new Ht("Invalid XMLHttpRequest response type."))},x.onerror=function(_){s.reject(new bC)},x.send(o),x};sn._Implementations.loadAndExecuteScript=function(e,r,n){return bF(e,r).otherwise(n.reject)};sn._DefaultImplementations={};sn._DefaultImplementations.createImage=sn._Implementations.createImage;sn._DefaultImplementations.loadWithXhr=sn._Implementations.loadWithXhr;sn._DefaultImplementations.loadAndExecuteScript=sn._Implementations.loadAndExecuteScript;sn.DEFAULT=Object.freeze(new sn({url:typeof document>"u"?"":document.location.href.split("?")[0]}));ir=sn});function WY(e){if(e=B(e,B.EMPTY_OBJECT),this._dates=void 0,this._samples=void 0,this._dateColumn=-1,this._xPoleWanderRadiansColumn=-1,this._yPoleWanderRadiansColumn=-1,this._ut1MinusUtcSecondsColumn=-1,this._xCelestialPoleOffsetRadiansColumn=-1,this._yCelestialPoleOffsetRadiansColumn=-1,this._taiMinusUtcSecondsColumn=-1,this._columnCount=0,this._lastIndex=-1,this._downloadPromise=void 0,this._dataError=void 0,this._addNewLeapSeconds=B(e.addNewLeapSeconds,!0),p(e.data))Bhe(this,e.data);else if(p(e.url)){var r=ir.createIfNeeded(e.url),n=this;this._downloadPromise=Je(r.fetchJson(),function(o){Bhe(n,o)},function(){n._dataError="An error occurred while retrieving the EOP data from the URL "+r.url+"."})}else Bhe(this,{columnNames:["dateIso8601","modifiedJulianDateUtc","xPoleWanderRadians","yPoleWanderRadians","ut1MinusUtcSeconds","lengthOfDayCorrectionSeconds","xCelestialPoleOffsetRadians","yCelestialPoleOffsetRadians","taiMinusUtcSeconds"],samples:[]})}function ePt(e,r){return ot.compare(e.julianDate,r)}function Bhe(e,r){if(!p(r.columnNames)){e._dataError="Error in loaded EOP data: The columnNames property is required.";return}if(!p(r.samples)){e._dataError="Error in loaded EOP data: The samples property is required.";return}var n=r.columnNames.indexOf("modifiedJulianDateUtc"),o=r.columnNames.indexOf("xPoleWanderRadians"),a=r.columnNames.indexOf("yPoleWanderRadians"),s=r.columnNames.indexOf("ut1MinusUtcSeconds"),l=r.columnNames.indexOf("xCelestialPoleOffsetRadians"),h=r.columnNames.indexOf("yCelestialPoleOffsetRadians"),x=r.columnNames.indexOf("taiMinusUtcSeconds");if(n<0||o<0||a<0||s<0||l<0||h<0||x<0){e._dataError="Error in loaded EOP data: The columnNames property must include modifiedJulianDateUtc, xPoleWanderRadians, yPoleWanderRadians, ut1MinusUtcSeconds, xCelestialPoleOffsetRadians, yCelestialPoleOffsetRadians, and taiMinusUtcSeconds columns";return}var m=e._samples=r.samples,v=e._dates=[];e._dateColumn=n,e._xPoleWanderRadiansColumn=o,e._yPoleWanderRadiansColumn=a,e._ut1MinusUtcSecondsColumn=s,e._xCelestialPoleOffsetRadiansColumn=l,e._yCelestialPoleOffsetRadiansColumn=h,e._taiMinusUtcSecondsColumn=x,e._columnCount=r.columnNames.length,e._lastIndex=void 0;for(var _,A=e._addNewLeapSeconds,T=0,w=m.length;T<w;T+=e._columnCount){var S=m[T+n],P=m[T+x],M=S+ka.MODIFIED_JULIAN_DATE_DIFFERENCE,L=new ot(M,P,Oa.TAI);if(v.push(L),A){if(P!==_&&p(_)){var R=ot.leapSeconds,O=T0(R,L,ePt);if(O<0){var N=new sl(L,P);R.splice(~O,0,N)}}_=P}}}function fze(e,r,n,o,a){var s=n*o;a.xPoleWander=r[s+e._xPoleWanderRadiansColumn],a.yPoleWander=r[s+e._yPoleWanderRadiansColumn],a.xPoleOffset=r[s+e._xCelestialPoleOffsetRadiansColumn],a.yPoleOffset=r[s+e._yCelestialPoleOffsetRadiansColumn],a.ut1MinusUtc=r[s+e._ut1MinusUtcSecondsColumn]}function vH(e,r,n){return r+e*(n-r)}function xze(e,r,n,o,a,s,l){var h=e._columnCount;if(s>r.length-1)return l.xPoleWander=0,l.yPoleWander=0,l.xPoleOffset=0,l.yPoleOffset=0,l.ut1MinusUtc=0,l;var x=r[a],m=r[s];if(x.equals(m)||o.equals(x))return fze(e,n,a,h,l),l;if(o.equals(m))return fze(e,n,s,h,l),l;var v=ot.secondsDifference(o,x)/ot.secondsDifference(m,x),_=a*h,A=s*h,T=n[_+e._ut1MinusUtcSecondsColumn],w=n[A+e._ut1MinusUtcSecondsColumn],S=w-T;if(S>.5||S<-.5){var P=n[_+e._taiMinusUtcSecondsColumn],M=n[A+e._taiMinusUtcSecondsColumn];P!==M&&(m.equals(o)?T=w:w-=M-P)}return l.xPoleWander=vH(v,n[_+e._xPoleWanderRadiansColumn],n[A+e._xPoleWanderRadiansColumn]),l.yPoleWander=vH(v,n[_+e._yPoleWanderRadiansColumn],n[A+e._yPoleWanderRadiansColumn]),l.xPoleOffset=vH(v,n[_+e._xCelestialPoleOffsetRadiansColumn],n[A+e._xCelestialPoleOffsetRadiansColumn]),l.yPoleOffset=vH(v,n[_+e._yCelestialPoleOffsetRadiansColumn],n[A+e._yCelestialPoleOffsetRadiansColumn]),l.ut1MinusUtc=vH(v,T,w),l}var qY,Rhe=Ee(()=>{li();Kw();Ze();De();wY();$a();IY();hn();zo();$w();AF();y(WY,"EarthOrientationParameters");WY.NONE=Object.freeze({getPromiseToLoad:function(){return Je()},compute:function(e,r){return p(r)?(r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0):r=new GM(0,0,0,0,0),r}});WY.prototype.getPromiseToLoad=function(){return Je(this._downloadPromise)};WY.prototype.compute=function(e,r){if(!p(this._samples)){if(p(this._dataError))throw new Ht(this._dataError);return}if(p(r)||(r=new GM(0,0,0,0,0)),this._samples.length===0)return r.xPoleWander=0,r.yPoleWander=0,r.xPoleOffset=0,r.yPoleOffset=0,r.ut1MinusUtc=0,r;var n=this._dates,o=this._lastIndex,a=0,s=0;if(p(o)){var l=n[o],h=n[o+1],x=ot.lessThanOrEquals(l,e),m=!p(h),v=m||ot.greaterThanOrEquals(h,e);if(x&&v)return a=o,!m&&h.equals(e)&&++a,s=a+1,xze(this,n,this._samples,e,a,s,r),r}var _=T0(n,e,ot.compare,this._dateColumn);return _>=0?(_<n.length-1&&n[_+1].equals(e)&&++_,a=_,s=_):(s=~_,a=s-1,a<0&&(a=0)),this._lastIndex=a,xze(this,n,this._samples,e,a,s,r),r};y(ePt,"compareLeapSecondDates");y(Bhe,"onDataReady");y(fze,"fillResultFromIndex");y(vH,"linearInterp");y(xze,"interpolate");qY=WY});function Ed(e,r,n){this.heading=B(e,0),this.pitch=B(r,0),this.roll=B(n,0)}var tn,E0=Ee(()=>{Ze();De();st();nr();y(Ed,"HeadingPitchRoll");Ed.fromQuaternion=function(e,r){if(!p(e))throw new G("quaternion is required");p(r)||(r=new Ed);var n=2*(e.w*e.y-e.z*e.x),o=1-2*(e.x*e.x+e.y*e.y),a=2*(e.w*e.x+e.y*e.z),s=1-2*(e.y*e.y+e.z*e.z),l=2*(e.w*e.z+e.x*e.y);return r.heading=-Math.atan2(l,s),r.roll=Math.atan2(a,o),r.pitch=-K.asinClamped(n),r};Ed.fromDegrees=function(e,r,n,o){if(!p(e))throw new G("heading is required");if(!p(r))throw new G("pitch is required");if(!p(n))throw new G("roll is required");return p(o)||(o=new Ed),o.heading=e*K.RADIANS_PER_DEGREE,o.pitch=r*K.RADIANS_PER_DEGREE,o.roll=n*K.RADIANS_PER_DEGREE,o};Ed.clone=function(e,r){if(!!p(e))return p(r)?(r.heading=e.heading,r.pitch=e.pitch,r.roll=e.roll,r):new Ed(e.heading,e.pitch,e.roll)};Ed.equals=function(e,r){return e===r||p(e)&&p(r)&&e.heading===r.heading&&e.pitch===r.pitch&&e.roll===r.roll};Ed.equalsEpsilon=function(e,r,n,o){return e===r||p(e)&&p(r)&&K.equalsEpsilon(e.heading,r.heading,n,o)&&K.equalsEpsilon(e.pitch,r.pitch,n,o)&&K.equalsEpsilon(e.roll,r.roll,n,o)};Ed.prototype.clone=function(e){return Ed.clone(this,e)};Ed.prototype.equals=function(e){return Ed.equals(this,e)};Ed.prototype.equalsEpsilon=function(e,r,n){return Ed.equalsEpsilon(this,e,r,n)};Ed.prototype.toString=function(){return"("+this.heading+", "+this.pitch+", "+this.roll+")"};tn=Ed});function tPt(){for(var e=document.getElementsByTagName("script"),r=0,n=e.length;r<n;++r){var o=e[r].getAttribute("src"),a=hze.exec(o);if(a!==null)return a[1]}}function dze(e){return typeof document>"u"?e:(p(MF)||(MF=document.createElement("a")),MF.href=e,MF.href=MF.href,MF.href)}function mze(){if(p(jM))return jM;var e;if(typeof CESIUM_BASE_URL<"u"?e=CESIUM_BASE_URL:typeof define=="object"&&p(define.amd)&&!define.amd.toUrlUndefined&&p(Bs.toUrl)?e=e1("..",YM("Core/buildModuleUrl.js")):e=tPt(),!p(e))throw new G("Unable to determine Cesium base URL automatically, try defining a global variable called CESIUM_BASE_URL.");return jM=new ir({url:dze(e)}),jM.appendForwardSlash(),jM}function rPt(e){return dze(Bs.toUrl("../"+e))}function pze(e){var r=mze().getDerivedResource({url:e});return r.url}function YM(e){p(jY)||(typeof define=="object"&&p(define.amd)&&!define.amd.toUrlUndefined&&p(Bs.toUrl)?jY=rPt:jY=pze);var r=jY(e);return r}var hze,MF,jM,jY,gi,Xs=Ee(()=>{De();st();cH();hn();hze=/((?:.*\/)|^)Cesium\.js$/;y(tPt,"getBaseUrlFromCesiumScript");y(dze,"tryMakeAbsolute");y(mze,"getCesiumBaseUrl");y(rPt,"buildModuleUrlFromRequireToUrl");y(pze,"buildModuleUrlFromBaseUrl");y(YM,"buildModuleUrl");YM._cesiumScriptRegex=hze;YM._buildModuleUrlFromBaseUrl=pze;YM._clearBaseResource=function(){jM=void 0};YM.setBaseUrl=function(e){jM=ir.DEFAULT.getDerivedResource({url:e})};YM.getCesiumBaseUrl=mze;gi=YM});function iPt(e,r,n){this.x=e,this.y=r,this.s=n}var BF,YY=Ee(()=>{y(iPt,"Iau2006XysSample");BF=iPt});function Fhe(e){e=B(e,B.EMPTY_OBJECT),this._xysFileUrlTemplate=ir.createIfNeeded(e.xysFileUrlTemplate),this._interpolationOrder=B(e.interpolationOrder,9),this._sampleZeroJulianEphemerisDate=B(e.sampleZeroJulianEphemerisDate,24423965e-1),this._sampleZeroDateTT=new ot(this._sampleZeroJulianEphemerisDate,0,Oa.TAI),this._stepSizeDays=B(e.stepSizeDays,1),this._samplesPerXysFile=B(e.samplesPerXysFile,1e3),this._totalSamples=B(e.totalSamples,27426),this._samples=new Array(this._totalSamples*3),this._chunkDownloadsInProgress=[];for(var r=this._interpolationOrder,n=this._denominators=new Array(r+1),o=this._xTable=new Array(r+1),a=Math.pow(this._stepSizeDays,r),s=0;s<=r;++s){n[s]=a,o[s]=s*this._stepSizeDays;for(var l=0;l<=r;++l)l!==s&&(n[s]*=s-l);n[s]=1/n[s]}this._work=new Array(r+1),this._coef=new Array(r+1)}function Lhe(e,r,n){var o=nPt;return o.dayNumber=r,o.secondsOfDay=n,ot.daysDifference(o,e._sampleZeroDateTT)}function Ohe(e,r){if(e._chunkDownloadsInProgress[r])return e._chunkDownloadsInProgress[r];var n=Je.defer();e._chunkDownloadsInProgress[r]=n;var o,a=e._xysFileUrlTemplate;return p(a)?o=a.getDerivedResource({templateValues:{0:r}}):o=new ir({url:gi("Assets/IAU2006_XYS/IAU2006_XYS_"+r+".json")}),Je(o.fetchJson(),function(s){e._chunkDownloadsInProgress[r]=!1;for(var l=e._samples,h=s.samples,x=r*e._samplesPerXysFile*3,m=0,v=h.length;m<v;++m)l[x+m]=h[m];n.resolve()}),n.promise}var nPt,QY,Nhe=Ee(()=>{li();Xs();Ze();De();YY();$a();hn();AF();y(Fhe,"Iau2006XysData");nPt=new ot(0,0,Oa.TAI);y(Lhe,"getDaysSinceEpoch");Fhe.prototype.preload=function(e,r,n,o){var a=Lhe(this,e,r),s=Lhe(this,n,o),l=a/this._stepSizeDays-this._interpolationOrder/2|0;l<0&&(l=0);var h=s/this._stepSizeDays-this._interpolationOrder/2|0+this._interpolationOrder;h>=this._totalSamples&&(h=this._totalSamples-1);for(var x=l/this._samplesPerXysFile|0,m=h/this._samplesPerXysFile|0,v=[],_=x;_<=m;++_)v.push(Ohe(this,_));return Je.all(v)};Fhe.prototype.computeXysRadians=function(e,r,n){var o=Lhe(this,e,r);if(!(o<0)){var a=o/this._stepSizeDays|0;if(!(a>=this._totalSamples)){var s=this._interpolationOrder,l=a-(s/2|0);l<0&&(l=0);var h=l+s;h>=this._totalSamples&&(h=this._totalSamples-1,l=h-s,l<0&&(l=0));var x=!1,m=this._samples;if(p(m[l*3])||(Ohe(this,l/this._samplesPerXysFile|0),x=!0),p(m[h*3])||(Ohe(this,h/this._samplesPerXysFile|0),x=!0),!x){p(n)?(n.x=0,n.y=0,n.s=0):n=new BF(0,0,0);var v=o-l*this._stepSizeDays,_=this._work,A=this._denominators,T=this._coef,w=this._xTable,S,P;for(S=0;S<=s;++S)_[S]=v-w[S];for(S=0;S<=s;++S){for(T[S]=1,P=0;P<=s;++P)P!==S&&(T[S]*=_[P]);T[S]*=A[S];var M=(l+S)*3;n.x+=T[S]*m[M++],n.y+=T[S]*m[M++],n.s+=T[S]*m[M]}return n}}}};y(Ohe,"requestXysChunk");QY=Fhe});var vs,zhe,RF,Vhe,Mp,PS,DS,MS,oPt,aPt,sPt,lPt,uPt,cPt,fPt,vze,xPt,hPt,dPt,mPt,pPt,vPt,gPt,_Pt,yPt,APt,XY,Ghe,CPt,TPt,wPt,khe,Uhe,EPt,bPt,SPt,IPt,gze,_ze,yze,PPt,DPt,Hhe,Aze,Qt,Wn=Ee(()=>{li();Fr();bt();Ci();Si();cr();Ze();De();st();Rhe();wY();Ii();E0();Nhe();YY();$a();nr();to();Rr();Ja();$w();iu();vs={},zhe={up:{south:"east",north:"west",west:"south",east:"north"},down:{south:"west",north:"east",west:"north",east:"south"},south:{up:"west",down:"east",west:"down",east:"up"},north:{up:"east",down:"west",west:"up",east:"down"},west:{up:"north",down:"south",north:"down",south:"up"},east:{up:"south",down:"north",north:"up",south:"down"}},RF={north:[-1,0,0],east:[0,1,0],up:[0,0,1],south:[1,0,0],west:[0,-1,0],down:[0,0,-1]},Vhe={},Mp={east:new E,north:new E,up:new E,west:new E,south:new E,down:new E},PS=new E,DS=new E,MS=new E;vs.localFrameToFixedFrameGenerator=function(e,r){if(!zhe.hasOwnProperty(e)||!zhe[e].hasOwnProperty(r))throw new G("firstAxis and secondAxis must be east, north, up, west, south or down.");var n=zhe[e][r],o,a=e+r;return p(Vhe[a])?o=Vhe[a]:(o=y(function(s,l,h){if(!p(s))throw new G("origin is required.");if(p(h)||(h=new Z),E.equalsEpsilon(s,E.ZERO,K.EPSILON14))E.unpack(RF[e],0,PS),E.unpack(RF[r],0,DS),E.unpack(RF[n],0,MS);else if(K.equalsEpsilon(s.x,0,K.EPSILON14)&&K.equalsEpsilon(s.y,0,K.EPSILON14)){var x=K.sign(s.z);E.unpack(RF[e],0,PS),e!=="east"&&e!=="west"&&E.multiplyByScalar(PS,x,PS),E.unpack(RF[r],0,DS),r!=="east"&&r!=="west"&&E.multiplyByScalar(DS,x,DS),E.unpack(RF[n],0,MS),n!=="east"&&n!=="west"&&E.multiplyByScalar(MS,x,MS)}else{l=B(l,nt.WGS84),l.geodeticSurfaceNormal(s,Mp.up);var m=Mp.up,v=Mp.east;v.x=-s.y,v.y=s.x,v.z=0,E.normalize(v,Mp.east),E.cross(m,v,Mp.north),E.multiplyByScalar(Mp.up,-1,Mp.down),E.multiplyByScalar(Mp.east,-1,Mp.west),E.multiplyByScalar(Mp.north,-1,Mp.south),PS=Mp[e],DS=Mp[r],MS=Mp[n]}return h[0]=PS.x,h[1]=PS.y,h[2]=PS.z,h[3]=0,h[4]=DS.x,h[5]=DS.y,h[6]=DS.z,h[7]=0,h[8]=MS.x,h[9]=MS.y,h[10]=MS.z,h[11]=0,h[12]=s.x,h[13]=s.y,h[14]=s.z,h[15]=1,h},"resultat"),Vhe[a]=o),o};vs.eastNorthUpToFixedFrame=vs.localFrameToFixedFrameGenerator("east","north");vs.northEastDownToFixedFrame=vs.localFrameToFixedFrameGenerator("north","east");vs.northUpEastToFixedFrame=vs.localFrameToFixedFrameGenerator("north","up");vs.northWestUpToFixedFrame=vs.localFrameToFixedFrameGenerator("north","west");oPt=new hr,aPt=new E(1,1,1),sPt=new Z;vs.headingPitchRollToFixedFrame=function(e,r,n,o,a){X.typeOf.object("HeadingPitchRoll",r),o=B(o,vs.eastNorthUpToFixedFrame);var s=hr.fromHeadingPitchRoll(r,oPt),l=Z.fromTranslationQuaternionRotationScale(E.ZERO,s,aPt,sPt);return a=o(e,n,a),Z.multiply(a,l,a)};lPt=new Z,uPt=new We;vs.headingPitchRollQuaternion=function(e,r,n,o,a){X.typeOf.object("HeadingPitchRoll",r);var s=vs.headingPitchRollToFixedFrame(e,r,n,o,lPt),l=Z.getMatrix3(s,uPt);return hr.fromRotationMatrix(l,a)};cPt=new E(1,1,1),fPt=new E,vze=new Z,xPt=new Z,hPt=new We,dPt=new hr;vs.fixedFrameToHeadingPitchRoll=function(e,r,n,o){X.defined("transform",e),r=B(r,nt.WGS84),n=B(n,vs.eastNorthUpToFixedFrame),p(o)||(o=new tn);var a=Z.getTranslation(e,fPt);if(E.equals(a,E.ZERO))return o.heading=0,o.pitch=0,o.roll=0,o;var s=Z.inverseTransformation(n(a,r,vze),vze),l=Z.setScale(e,cPt,xPt);l=Z.setTranslation(l,E.ZERO,l),s=Z.multiply(s,l,s);var h=hr.fromRotationMatrix(Z.getMatrix3(s,hPt),dPt);return h=hr.normalize(h,h),tn.fromQuaternion(h,o)};mPt=6*3600+41*60+50.54841,pPt=8640184812866e-6,vPt=.093104,gPt=-62e-7,_Pt=11772758384668e-32,yPt=72921158553e-15,APt=K.TWO_PI/86400,XY=new ot;vs.computeTemeToPseudoFixedMatrix=function(e,r){if(!p(e))throw new G("date is required.");XY=ot.addSeconds(e,-ot.computeTaiMinusUtc(e),XY);var n=XY.dayNumber,o=XY.secondsOfDay,a,s=n-2451545;o>=43200?a=(s+.5)/ka.DAYS_PER_JULIAN_CENTURY:a=(s-.5)/ka.DAYS_PER_JULIAN_CENTURY;var l=mPt+a*(pPt+a*(vPt+a*gPt)),h=l*APt%K.TWO_PI,x=yPt+_Pt*(n-24515455e-1),m=(o+ka.SECONDS_PER_DAY*.5)%ka.SECONDS_PER_DAY,v=h+x*m,_=Math.cos(v),A=Math.sin(v);return p(r)?(r[0]=_,r[1]=-A,r[2]=0,r[3]=A,r[4]=_,r[5]=0,r[6]=0,r[7]=0,r[8]=1,r):new We(_,A,0,-A,_,0,0,0,1)};vs.iau2006XysData=new QY;vs.earthOrientationParameters=qY.NONE;Ghe=32.184,CPt=2451545;vs.preloadIcrfFixed=function(e){var r=e.start.dayNumber,n=e.start.secondsOfDay+Ghe,o=e.stop.dayNumber,a=e.stop.secondsOfDay+Ghe,s=vs.iau2006XysData.preload(r,n,o,a),l=vs.earthOrientationParameters.getPromiseToLoad();return Je.all([s,l])};vs.computeIcrfToFixedMatrix=function(e,r){if(!p(e))throw new G("date is required.");p(r)||(r=new We);var n=vs.computeFixedToIcrfMatrix(e,r);if(!!p(n))return We.transpose(n,r)};TPt=new BF(0,0,0),wPt=new GM(0,0,0,0,0,0),khe=new We,Uhe=new We;vs.computeFixedToIcrfMatrix=function(e,r){if(!p(e))throw new G("date is required.");p(r)||(r=new We);var n=vs.earthOrientationParameters.compute(e,wPt);if(!!p(n)){var o=e.dayNumber,a=e.secondsOfDay+Ghe,s=vs.iau2006XysData.computeXysRadians(o,a,TPt);if(!!p(s)){var l=s.x+n.xPoleOffset,h=s.y+n.yPoleOffset,x=1/(1+Math.sqrt(1-l*l-h*h)),m=khe;m[0]=1-x*l*l,m[3]=-x*l*h,m[6]=l,m[1]=-x*l*h,m[4]=1-x*h*h,m[7]=h,m[2]=-l,m[5]=-h,m[8]=1-x*(l*l+h*h);var v=We.fromRotationZ(-s.s,Uhe),_=We.multiply(m,v,khe),A=e.dayNumber,T=e.secondsOfDay-ot.computeTaiMinusUtc(e)+n.ut1MinusUtc,w=A-2451545,S=T/ka.SECONDS_PER_DAY,P=.779057273264+S+.00273781191135448*(w+S);P=P%1*K.TWO_PI;var M=We.fromRotationZ(P,Uhe),L=We.multiply(_,M,khe),R=Math.cos(n.xPoleWander),O=Math.cos(n.yPoleWander),N=Math.sin(n.xPoleWander),k=Math.sin(n.yPoleWander),z=o-CPt+a/ka.SECONDS_PER_DAY;z/=36525;var W=-47e-6*z*K.RADIANS_PER_DEGREE/3600,j=Math.cos(W),q=Math.sin(W),I=Uhe;return I[0]=R*j,I[1]=R*q,I[2]=N,I[3]=-O*q+k*N*j,I[4]=O*j+k*N*q,I[5]=-k*R,I[6]=-k*q-O*N*j,I[7]=k*j-O*N*q,I[8]=O*R,We.multiply(L,I,r)}}};EPt=new Ce;vs.pointToWindowCoordinates=function(e,r,n,o){return o=vs.pointToGLWindowCoordinates(e,r,n,o),o.y=2*r[5]-o.y,o};vs.pointToGLWindowCoordinates=function(e,r,n,o){if(!p(e))throw new G("modelViewProjectionMatrix is required.");if(!p(r))throw new G("viewportTransformation is required.");if(!p(n))throw new G("point is required.");p(o)||(o=new de);var a=EPt;return Z.multiplyByVector(e,Ce.fromElements(n.x,n.y,n.z,1,a),a),Ce.multiplyByScalar(a,1/a.w,a),Z.multiplyByVector(r,a,a),de.fromCartesian4(a,o)};bPt=new E,SPt=new E,IPt=new E;vs.rotationMatrixFromPositionVelocity=function(e,r,n,o){if(!p(e))throw new G("position is required.");if(!p(r))throw new G("velocity is required.");var a=B(n,nt.WGS84).geodeticSurfaceNormal(e,bPt),s=E.cross(r,a,SPt);E.equalsEpsilon(s,E.ZERO,K.EPSILON6)&&(s=E.clone(E.UNIT_X,s));var l=E.cross(s,r,IPt);return E.normalize(l,l),E.cross(r,l,s),E.negate(s,s),E.normalize(s,s),p(o)||(o=new We),o[0]=r.x,o[1]=r.y,o[2]=r.z,o[3]=s.x,o[4]=s.y,o[5]=s.z,o[6]=l.x,o[7]=l.y,o[8]=l.z,o};gze=new Z(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1),_ze=new qe,yze=new E,PPt=new E,DPt=new We,Hhe=new Z,Aze=new Z;vs.basisTo2D=function(e,r,n){if(!p(e))throw new G("projection is required.");if(!p(r))throw new G("matrix is required.");if(!p(n))throw new G("result is required.");var o=Z.getTranslation(r,PPt),a=e.ellipsoid,s=a.cartesianToCartographic(o,_ze),l=e.project(s,yze);E.fromElements(l.z,l.x,l.y,l);var h=vs.eastNorthUpToFixedFrame(o,a,Hhe),x=Z.inverseTransformation(h,Aze),m=Z.getMatrix3(r,DPt),v=Z.multiplyByMatrix3(x,m,n);return Z.multiply(gze,v,n),Z.setTranslation(n,l,n),n};vs.wgs84To2DModelMatrix=function(e,r,n){if(!p(e))throw new G("projection is required.");if(!p(r))throw new G("center is required.");if(!p(n))throw new G("result is required.");var o=e.ellipsoid,a=vs.eastNorthUpToFixedFrame(r,o,Hhe),s=Z.inverseTransformation(a,Aze),l=o.cartesianToCartographic(r,_ze),h=e.project(l,yze);E.fromElements(h.z,h.x,h.y,h);var x=Z.fromTranslation(h,Hhe);return Z.multiply(gze,s,n),Z.multiply(x,n,n),n};vs.buildUp=function(e,r){var n=r.clone(),o=e.clone();o=E.normalize(o,o),Math.abs(E.dot(o,n))>=1&&(Math.abs(E.dot(n,E.UNIT_Y))<1?o=E.clone(E.UNIT_Y,o):o=E.clone(E.UNIT_Z,o));var a=new E;return E.cross(o,n,a),a=E.normalize(a,a),E.cross(n,a,o),o=E.normalize(o,o),o};vs.getHeading=function(e,r){var n;return K.equalsEpsilon(Math.abs(e.z),1,K.EPSILON3)?n=Math.atan2(r.y,r.x)-K.PI_OVER_TWO:n=Math.atan2(e.y,e.x)-K.PI_OVER_TWO,K.TWO_PI-K.zeroToTwoPi(n)};vs.convertToColumbusCartesian=function(e){var r=new yo,n=r.ellipsoid,o=new E,a=new qe;return n.cartesianToCartographic(e,a),r.project(a,o),E.fromElements(o.z,o.x,o.y)};vs.convertTo3DCartesian=function(e){var r=new yo,n=r.ellipsoid,o=new E,a=new qe;return o=E.fromElements(e.y,e.z,e.x),r.unproject(o,a),n.cartographicToCartesian(a,o)};Qt=vs});function Whe(e){e=B(e,B.EMPTY_OBJECT),X.typeOf.object("options.attributes",e.attributes),this.attributes=e.attributes,this.indices=e.indices,this.primitiveType=B(e.primitiveType,jt.TRIANGLES),this.boundingSphere=e.boundingSphere,this.geometryType=B(e.geometryType,_y.NONE),this.boundingSphereCV=e.boundingSphereCV,this.offsetAttribute=e.offsetAttribute}var MPt,BPt,Cze,RPt,LPt,OPt,FPt,NPt,zPt,VPt,Ei,gs=Ee(()=>{Fr();bt();Si();cr();Ze();De();st();rH();CC();to();Rr();un();Ja();Ni();Wn();y(Whe,"Geometry");Whe.computeNumberOfVertices=function(e){X.typeOf.object("geometry",e);var r=-1;for(var n in e.attributes)if(e.attributes.hasOwnProperty(n)&&p(e.attributes[n])&&p(e.attributes[n].values)){var o=e.attributes[n];if(o.isInstanceAttribute)continue;var a=o.values.length/o.componentsPerAttribute;if(r!==a&&r!==-1)throw new G("All attribute lists must have the same number of attributes.");r=a}return r};MPt=new qe,BPt=new E,Cze=new Z,RPt=[new qe,new qe,new qe],LPt=[new de,new de,new de],OPt=[new de,new de,new de],FPt=new E,NPt=new hr,zPt=new Z,VPt=new nu;Whe._textureCoordinateRotationPoints=function(e,r,n,o){var a,s=He.center(o,MPt),l=qe.toCartesian(s,n,BPt),h=Qt.eastNorthUpToFixedFrame(l,n,Cze),x=Z.inverse(h,Cze),m=LPt,v=RPt;v[0].longitude=o.west,v[0].latitude=o.south,v[1].longitude=o.west,v[1].latitude=o.north,v[2].longitude=o.east,v[2].latitude=o.south;var _=FPt;for(a=0;a<3;a++)qe.toCartesian(v[a],n,_),_=Z.multiplyByPointAsVector(x,_,_),m[a].x=_.x,m[a].y=_.y;var A=hr.fromAxisAngle(E.UNIT_Z,-r,NPt),T=We.fromQuaternion(A,zPt),w=e.length,S=Number.POSITIVE_INFINITY,P=Number.POSITIVE_INFINITY,M=Number.NEGATIVE_INFINITY,L=Number.NEGATIVE_INFINITY;for(a=0;a<w;a++)_=Z.multiplyByPointAsVector(x,e[a],_),_=We.multiplyByVector(T,_,_),S=Math.min(S,_.x),P=Math.min(P,_.y),M=Math.max(M,_.x),L=Math.max(L,_.y);var R=nu.fromRotation(r,VPt),O=OPt;O[0].x=S,O[0].y=P,O[1].x=S,O[1].y=L,O[2].x=M,O[2].y=P;var N=m[0],k=m[2].x-N.x,z=m[1].y-N.y;for(a=0;a<3;a++){var W=O[a];nu.multiplyByVector(R,W,W),W.x=(W.x-N.x)/k,W.y=(W.y-N.y)/z}var j=O[0],q=O[1],I=O[2],F=new Array(6);return de.pack(j,F),de.pack(q,F,2),de.pack(I,F,4),F};Ei=Whe});function kPt(e){if(e=B(e,B.EMPTY_OBJECT),!p(e.componentDatatype))throw new G("options.componentDatatype is required.");if(!p(e.componentsPerAttribute))throw new G("options.componentsPerAttribute is required.");if(e.componentsPerAttribute<1||e.componentsPerAttribute>4)throw new G("options.componentsPerAttribute must be between 1 and 4.");if(!p(e.values))throw new G("options.values is required.");this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=B(e.normalize,!1),this.values=e.values}var wr,_s=Ee(()=>{Ze();De();st();y(kPt,"GeometryAttribute");wr=kPt});function UPt(e){e=B(e,B.EMPTY_OBJECT),this.position=e.position,this.normal=e.normal,this.st=e.st,this.bitangent=e.bitangent,this.tangent=e.tangent,this.color=e.color}var bo,au=Ee(()=>{Ze();y(UPt,"GeometryAttributes");bo=UPt});var GPt,jn,pf=Ee(()=>{GPt={NONE:0,TOP:1,ALL:2},jn=Object.freeze(GPt)});function qhe(e,r,n){return n<0&&(n+=1),n>1&&(n-=1),n*6<1?e+(r-e)*6*n:n*2<1?r:n*3<2?e+(r-e)*(2/3-n)*6:e}function ut(e,r,n,o){this.red=B(e,1),this.green=B(r,1),this.blue=B(n,1),this.alpha=B(o,1)}var jhe,KY,q2,WPt,qPt,jPt,YPt,se,Ar=Ee(()=>{cr();Ze();De();ou();nr();y(qhe,"hue2rgb");y(ut,"Color");ut.fromCartesian4=function(e,r){return X.typeOf.object("cartesian",e),p(r)?(r.red=e.x,r.green=e.y,r.blue=e.z,r.alpha=e.w,r):new ut(e.x,e.y,e.z,e.w)};ut.fromBytes=function(e,r,n,o,a){return e=ut.byteToFloat(B(e,255)),r=ut.byteToFloat(B(r,255)),n=ut.byteToFloat(B(n,255)),o=ut.byteToFloat(B(o,255)),p(a)?(a.red=e,a.green=r,a.blue=n,a.alpha=o,a):new ut(e,r,n,o)};ut.fromAlpha=function(e,r,n){return X.typeOf.object("color",e),X.typeOf.number("alpha",r),p(n)?(n.red=e.red,n.green=e.green,n.blue=e.blue,n.alpha=r,n):new ut(e.red,e.green,e.blue,r)};Gn.supportsTypedArrays()&&(jhe=new ArrayBuffer(4),KY=new Uint32Array(jhe),q2=new Uint8Array(jhe));ut.fromRgba=function(e,r){return KY[0]=e,ut.fromBytes(q2[0],q2[1],q2[2],q2[3],r)};ut.byteToRgba=function(e,r,n,o){return q2[0]=e,q2[1]=r,q2[2]=n,q2[3]=o,KY[0]};ut.fromHsl=function(e,r,n,o,a){e=B(e,0)%1,r=B(r,0),n=B(n,0),o=B(o,1);var s=n,l=n,h=n;if(r!==0){var x;n<.5?x=n*(1+r):x=n+r-n*r;var m=2*n-x;s=qhe(m,x,e+1/3),l=qhe(m,x,e),h=qhe(m,x,e-1/3)}return p(a)?(a.red=s,a.green=l,a.blue=h,a.alpha=o,a):new ut(s,l,h,o)};ut.fromRandom=function(e,r){e=B(e,B.EMPTY_OBJECT);var n=e.red;if(!p(n)){var o=B(e.minimumRed,0),a=B(e.maximumRed,1);X.typeOf.number.lessThanOrEquals("minimumRed",o,a),n=o+K.nextRandomNumber()*(a-o)}var s=e.green;if(!p(s)){var l=B(e.minimumGreen,0),h=B(e.maximumGreen,1);X.typeOf.number.lessThanOrEquals("minimumGreen",l,h),s=l+K.nextRandomNumber()*(h-l)}var x=e.blue;if(!p(x)){var m=B(e.minimumBlue,0),v=B(e.maximumBlue,1);X.typeOf.number.lessThanOrEquals("minimumBlue",m,v),x=m+K.nextRandomNumber()*(v-m)}var _=e.alpha;if(!p(_)){var A=B(e.minimumAlpha,0),T=B(e.maximumAlpha,1);X.typeOf.number.lessThanOrEquals("minumumAlpha",A,T),_=A+K.nextRandomNumber()*(T-A)}return p(r)?(r.red=n,r.green=s,r.blue=x,r.alpha=_,r):new ut(n,s,x,_)};WPt=/^#([0-9a-f])([0-9a-f])([0-9a-f])$/i,qPt=/^#([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})$/i,jPt=/^rgba?\(\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)\s*,\s*([0-9.]+%?)(?:\s*,\s*([0-9.]+))?\s*\)$/i,YPt=/^hsla?\(\s*([0-9.]+)\s*,\s*([0-9.]+%)\s*,\s*([0-9.]+%)(?:\s*,\s*([0-9.]+))?\s*\)$/i;ut.fromCssColorString=function(e,r){X.typeOf.string("color",e),p(r)||(r=new ut);var n=ut[e.toUpperCase()];if(p(n))return ut.clone(n,r),r;var o=WPt.exec(e);return o!==null?(r.red=parseInt(o[1],16)/15,r.green=parseInt(o[2],16)/15,r.blue=parseInt(o[3],16)/15,r.alpha=1,r):(o=qPt.exec(e),o!==null?(r.red=parseInt(o[1],16)/255,r.green=parseInt(o[2],16)/255,r.blue=parseInt(o[3],16)/255,r.alpha=1,r):(o=jPt.exec(e),o!==null?(r.red=parseFloat(o[1])/(o[1].substr(-1)==="%"?100:255),r.green=parseFloat(o[2])/(o[2].substr(-1)==="%"?100:255),r.blue=parseFloat(o[3])/(o[3].substr(-1)==="%"?100:255),r.alpha=parseFloat(B(o[4],"1.0")),r):(o=YPt.exec(e),o!==null?ut.fromHsl(parseFloat(o[1])/360,parseFloat(o[2])/100,parseFloat(o[3])/100,parseFloat(B(o[4],"1.0")),r):(r=void 0,r))))};ut.packedLength=4;ut.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.red,r[n++]=e.green,r[n++]=e.blue,r[n]=e.alpha,r};ut.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new ut),n.red=e[r++],n.green=e[r++],n.blue=e[r++],n.alpha=e[r],n};ut.byteToFloat=function(e){return e/255};ut.floatToByte=function(e){return e===1?255:e*256|0};ut.clone=function(e,r){if(!!p(e))return p(r)?(r.red=e.red,r.green=e.green,r.blue=e.blue,r.alpha=e.alpha,r):new ut(e.red,e.green,e.blue,e.alpha)};ut.equals=function(e,r){return e===r||p(e)&&p(r)&&e.red===r.red&&e.green===r.green&&e.blue===r.blue&&e.alpha===r.alpha};ut.equalsArray=function(e,r,n){return e.red===r[n]&&e.green===r[n+1]&&e.blue===r[n+2]&&e.alpha===r[n+3]};ut.prototype.clone=function(e){return ut.clone(this,e)};ut.prototype.equals=function(e){return ut.equals(this,e)};ut.prototype.equalsEpsilon=function(e,r){return this===e||p(e)&&Math.abs(this.red-e.red)<=r&&Math.abs(this.green-e.green)<=r&&Math.abs(this.blue-e.blue)<=r&&Math.abs(this.alpha-e.alpha)<=r};ut.prototype.toString=function(){return"("+this.red+", "+this.green+", "+this.blue+", "+this.alpha+")"};ut.prototype.toCssColorString=function(){var e=ut.floatToByte(this.red),r=ut.floatToByte(this.green),n=ut.floatToByte(this.blue);return this.alpha===1?"rgb("+e+","+r+","+n+")":"rgba("+e+","+r+","+n+","+this.alpha+")"};ut.prototype.toCssHexString=function(){let e=ut.floatToByte(this.red).toString(16);e.length<2&&(e=`0${e}`);let r=ut.floatToByte(this.green).toString(16);r.length<2&&(r=`0${r}`);let n=ut.floatToByte(this.blue).toString(16);if(n.length<2&&(n=`0${n}`),this.alpha<1){let o=ut.floatToByte(this.alpha).toString(16);return o.length<2&&(o=`0${o}`),`#${e}${r}${n}${o}`}return`#${e}${r}${n}`};ut.prototype.toBytes=function(e){var r=ut.floatToByte(this.red),n=ut.floatToByte(this.green),o=ut.floatToByte(this.blue),a=ut.floatToByte(this.alpha);return p(e)?(e[0]=r,e[1]=n,e[2]=o,e[3]=a,e):[r,n,o,a]};ut.prototype.toRgba=function(){return q2[0]=ut.floatToByte(this.red),q2[1]=ut.floatToByte(this.green),q2[2]=ut.floatToByte(this.blue),q2[3]=ut.floatToByte(this.alpha),KY[0]};ut.prototype.brighten=function(e,r){return X.typeOf.number("magnitude",e),X.typeOf.number.greaterThanOrEquals("magnitude",e,0),X.typeOf.object("result",r),e=1-e,r.red=1-(1-this.red)*e,r.green=1-(1-this.green)*e,r.blue=1-(1-this.blue)*e,r.alpha=this.alpha,r};ut.prototype.darken=function(e,r){return X.typeOf.number("magnitude",e),X.typeOf.number.greaterThanOrEquals("magnitude",e,0),X.typeOf.object("result",r),e=1-e,r.red=this.red*e,r.green=this.green*e,r.blue=this.blue*e,r.alpha=this.alpha,r};ut.prototype.withAlpha=function(e,r){return ut.fromAlpha(this,e,r)};ut.add=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.red=e.red+r.red,n.green=e.green+r.green,n.blue=e.blue+r.blue,n.alpha=e.alpha+r.alpha,n};ut.subtract=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.red=e.red-r.red,n.green=e.green-r.green,n.blue=e.blue-r.blue,n.alpha=e.alpha-r.alpha,n};ut.multiply=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.red=e.red*r.red,n.green=e.green*r.green,n.blue=e.blue*r.blue,n.alpha=e.alpha*r.alpha,n};ut.divide=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.red=e.red/r.red,n.green=e.green/r.green,n.blue=e.blue/r.blue,n.alpha=e.alpha/r.alpha,n};ut.mod=function(e,r,n){return X.typeOf.object("left",e),X.typeOf.object("right",r),X.typeOf.object("result",n),n.red=e.red%r.red,n.green=e.green%r.green,n.blue=e.blue%r.blue,n.alpha=e.alpha%r.alpha,n};ut.lerp=function(e,r,n,o){return X.typeOf.object("start",e),X.typeOf.object("end",r),X.typeOf.number("t",n),X.typeOf.object("result",o),o.red=K.lerp(e.red,r.red,n),o.green=K.lerp(e.green,r.green,n),o.blue=K.lerp(e.blue,r.blue,n),o.alpha=K.lerp(e.alpha,r.alpha,n),o};ut.multiplyByScalar=function(e,r,n){return X.typeOf.object("color",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.red=e.red*r,n.green=e.green*r,n.blue=e.blue*r,n.alpha=e.alpha*r,n};ut.divideByScalar=function(e,r,n){return X.typeOf.object("color",e),X.typeOf.number("scalar",r),X.typeOf.object("result",n),n.red=e.red/r,n.green=e.green/r,n.blue=e.blue/r,n.alpha=e.alpha/r,n};ut.ALICEBLUE=Object.freeze(ut.fromCssColorString("#F0F8FF"));ut.ANTIQUEWHITE=Object.freeze(ut.fromCssColorString("#FAEBD7"));ut.AQUA=Object.freeze(ut.fromCssColorString("#00FFFF"));ut.AQUAMARINE=Object.freeze(ut.fromCssColorString("#7FFFD4"));ut.AZURE=Object.freeze(ut.fromCssColorString("#F0FFFF"));ut.BEIGE=Object.freeze(ut.fromCssColorString("#F5F5DC"));ut.BISQUE=Object.freeze(ut.fromCssColorString("#FFE4C4"));ut.BLACK=Object.freeze(ut.fromCssColorString("#000000"));ut.BLANCHEDALMOND=Object.freeze(ut.fromCssColorString("#FFEBCD"));ut.BLUE=Object.freeze(ut.fromCssColorString("#0000FF"));ut.BLUEVIOLET=Object.freeze(ut.fromCssColorString("#8A2BE2"));ut.BROWN=Object.freeze(ut.fromCssColorString("#A52A2A"));ut.BURLYWOOD=Object.freeze(ut.fromCssColorString("#DEB887"));ut.CADETBLUE=Object.freeze(ut.fromCssColorString("#5F9EA0"));ut.CHARTREUSE=Object.freeze(ut.fromCssColorString("#7FFF00"));ut.CHOCOLATE=Object.freeze(ut.fromCssColorString("#D2691E"));ut.CORAL=Object.freeze(ut.fromCssColorString("#FF7F50"));ut.CORNFLOWERBLUE=Object.freeze(ut.fromCssColorString("#6495ED"));ut.CORNSILK=Object.freeze(ut.fromCssColorString("#FFF8DC"));ut.CRIMSON=Object.freeze(ut.fromCssColorString("#DC143C"));ut.CYAN=Object.freeze(ut.fromCssColorString("#00FFFF"));ut.DARKBLUE=Object.freeze(ut.fromCssColorString("#00008B"));ut.DARKCYAN=Object.freeze(ut.fromCssColorString("#008B8B"));ut.DARKGOLDENROD=Object.freeze(ut.fromCssColorString("#B8860B"));ut.DARKGRAY=Object.freeze(ut.fromCssColorString("#A9A9A9"));ut.DARKGREEN=Object.freeze(ut.fromCssColorString("#006400"));ut.DARKGREY=ut.DARKGRAY;ut.DARKKHAKI=Object.freeze(ut.fromCssColorString("#BDB76B"));ut.DARKMAGENTA=Object.freeze(ut.fromCssColorString("#8B008B"));ut.DARKOLIVEGREEN=Object.freeze(ut.fromCssColorString("#556B2F"));ut.DARKORANGE=Object.freeze(ut.fromCssColorString("#FF8C00"));ut.DARKORCHID=Object.freeze(ut.fromCssColorString("#9932CC"));ut.DARKRED=Object.freeze(ut.fromCssColorString("#8B0000"));ut.DARKSALMON=Object.freeze(ut.fromCssColorString("#E9967A"));ut.DARKSEAGREEN=Object.freeze(ut.fromCssColorString("#8FBC8F"));ut.DARKSLATEBLUE=Object.freeze(ut.fromCssColorString("#483D8B"));ut.DARKSLATEGRAY=Object.freeze(ut.fromCssColorString("#2F4F4F"));ut.DARKSLATEGREY=ut.DARKSLATEGRAY;ut.DARKTURQUOISE=Object.freeze(ut.fromCssColorString("#00CED1"));ut.DARKVIOLET=Object.freeze(ut.fromCssColorString("#9400D3"));ut.DEEPPINK=Object.freeze(ut.fromCssColorString("#FF1493"));ut.DEEPSKYBLUE=Object.freeze(ut.fromCssColorString("#00BFFF"));ut.DIMGRAY=Object.freeze(ut.fromCssColorString("#696969"));ut.DIMGREY=ut.DIMGRAY;ut.DODGERBLUE=Object.freeze(ut.fromCssColorString("#1E90FF"));ut.FIREBRICK=Object.freeze(ut.fromCssColorString("#B22222"));ut.FLORALWHITE=Object.freeze(ut.fromCssColorString("#FFFAF0"));ut.FORESTGREEN=Object.freeze(ut.fromCssColorString("#228B22"));ut.FUCHSIA=Object.freeze(ut.fromCssColorString("#FF00FF"));ut.GAINSBORO=Object.freeze(ut.fromCssColorString("#DCDCDC"));ut.GHOSTWHITE=Object.freeze(ut.fromCssColorString("#F8F8FF"));ut.GOLD=Object.freeze(ut.fromCssColorString("#FFD700"));ut.GOLDENROD=Object.freeze(ut.fromCssColorString("#DAA520"));ut.GRAY=Object.freeze(ut.fromCssColorString("#808080"));ut.GREEN=Object.freeze(ut.fromCssColorString("#008000"));ut.GREENYELLOW=Object.freeze(ut.fromCssColorString("#ADFF2F"));ut.GREY=ut.GRAY;ut.HONEYDEW=Object.freeze(ut.fromCssColorString("#F0FFF0"));ut.HOTPINK=Object.freeze(ut.fromCssColorString("#FF69B4"));ut.INDIANRED=Object.freeze(ut.fromCssColorString("#CD5C5C"));ut.INDIGO=Object.freeze(ut.fromCssColorString("#4B0082"));ut.IVORY=Object.freeze(ut.fromCssColorString("#FFFFF0"));ut.KHAKI=Object.freeze(ut.fromCssColorString("#F0E68C"));ut.LAVENDER=Object.freeze(ut.fromCssColorString("#E6E6FA"));ut.LAVENDAR_BLUSH=Object.freeze(ut.fromCssColorString("#FFF0F5"));ut.LAWNGREEN=Object.freeze(ut.fromCssColorString("#7CFC00"));ut.LEMONCHIFFON=Object.freeze(ut.fromCssColorString("#FFFACD"));ut.LIGHTBLUE=Object.freeze(ut.fromCssColorString("#ADD8E6"));ut.LIGHTCORAL=Object.freeze(ut.fromCssColorString("#F08080"));ut.LIGHTCYAN=Object.freeze(ut.fromCssColorString("#E0FFFF"));ut.LIGHTGOLDENRODYELLOW=Object.freeze(ut.fromCssColorString("#FAFAD2"));ut.LIGHTGRAY=Object.freeze(ut.fromCssColorString("#D3D3D3"));ut.LIGHTGREEN=Object.freeze(ut.fromCssColorString("#90EE90"));ut.LIGHTGREY=ut.LIGHTGRAY;ut.LIGHTPINK=Object.freeze(ut.fromCssColorString("#FFB6C1"));ut.LIGHTSEAGREEN=Object.freeze(ut.fromCssColorString("#20B2AA"));ut.LIGHTSKYBLUE=Object.freeze(ut.fromCssColorString("#87CEFA"));ut.LIGHTSLATEGRAY=Object.freeze(ut.fromCssColorString("#778899"));ut.LIGHTSLATEGREY=ut.LIGHTSLATEGRAY;ut.LIGHTSTEELBLUE=Object.freeze(ut.fromCssColorString("#B0C4DE"));ut.LIGHTYELLOW=Object.freeze(ut.fromCssColorString("#FFFFE0"));ut.LIME=Object.freeze(ut.fromCssColorString("#00FF00"));ut.LIMEGREEN=Object.freeze(ut.fromCssColorString("#32CD32"));ut.LINEN=Object.freeze(ut.fromCssColorString("#FAF0E6"));ut.MAGENTA=Object.freeze(ut.fromCssColorString("#FF00FF"));ut.MAROON=Object.freeze(ut.fromCssColorString("#800000"));ut.MEDIUMAQUAMARINE=Object.freeze(ut.fromCssColorString("#66CDAA"));ut.MEDIUMBLUE=Object.freeze(ut.fromCssColorString("#0000CD"));ut.MEDIUMORCHID=Object.freeze(ut.fromCssColorString("#BA55D3"));ut.MEDIUMPURPLE=Object.freeze(ut.fromCssColorString("#9370DB"));ut.MEDIUMSEAGREEN=Object.freeze(ut.fromCssColorString("#3CB371"));ut.MEDIUMSLATEBLUE=Object.freeze(ut.fromCssColorString("#7B68EE"));ut.MEDIUMSPRINGGREEN=Object.freeze(ut.fromCssColorString("#00FA9A"));ut.MEDIUMTURQUOISE=Object.freeze(ut.fromCssColorString("#48D1CC"));ut.MEDIUMVIOLETRED=Object.freeze(ut.fromCssColorString("#C71585"));ut.MIDNIGHTBLUE=Object.freeze(ut.fromCssColorString("#191970"));ut.MINTCREAM=Object.freeze(ut.fromCssColorString("#F5FFFA"));ut.MISTYROSE=Object.freeze(ut.fromCssColorString("#FFE4E1"));ut.MOCCASIN=Object.freeze(ut.fromCssColorString("#FFE4B5"));ut.NAVAJOWHITE=Object.freeze(ut.fromCssColorString("#FFDEAD"));ut.NAVY=Object.freeze(ut.fromCssColorString("#000080"));ut.OLDLACE=Object.freeze(ut.fromCssColorString("#FDF5E6"));ut.OLIVE=Object.freeze(ut.fromCssColorString("#808000"));ut.OLIVEDRAB=Object.freeze(ut.fromCssColorString("#6B8E23"));ut.ORANGE=Object.freeze(ut.fromCssColorString("#FFA500"));ut.ORANGERED=Object.freeze(ut.fromCssColorString("#FF4500"));ut.ORCHID=Object.freeze(ut.fromCssColorString("#DA70D6"));ut.PALEGOLDENROD=Object.freeze(ut.fromCssColorString("#EEE8AA"));ut.PALEGREEN=Object.freeze(ut.fromCssColorString("#98FB98"));ut.PALETURQUOISE=Object.freeze(ut.fromCssColorString("#AFEEEE"));ut.PALEVIOLETRED=Object.freeze(ut.fromCssColorString("#DB7093"));ut.PAPAYAWHIP=Object.freeze(ut.fromCssColorString("#FFEFD5"));ut.PEACHPUFF=Object.freeze(ut.fromCssColorString("#FFDAB9"));ut.PERU=Object.freeze(ut.fromCssColorString("#CD853F"));ut.PINK=Object.freeze(ut.fromCssColorString("#FFC0CB"));ut.PLUM=Object.freeze(ut.fromCssColorString("#DDA0DD"));ut.POWDERBLUE=Object.freeze(ut.fromCssColorString("#B0E0E6"));ut.PURPLE=Object.freeze(ut.fromCssColorString("#800080"));ut.RED=Object.freeze(ut.fromCssColorString("#FF0000"));ut.ROSYBROWN=Object.freeze(ut.fromCssColorString("#BC8F8F"));ut.ROYALBLUE=Object.freeze(ut.fromCssColorString("#4169E1"));ut.SADDLEBROWN=Object.freeze(ut.fromCssColorString("#8B4513"));ut.SALMON=Object.freeze(ut.fromCssColorString("#FA8072"));ut.SANDYBROWN=Object.freeze(ut.fromCssColorString("#F4A460"));ut.SEAGREEN=Object.freeze(ut.fromCssColorString("#2E8B57"));ut.SEASHELL=Object.freeze(ut.fromCssColorString("#FFF5EE"));ut.SIENNA=Object.freeze(ut.fromCssColorString("#A0522D"));ut.SILVER=Object.freeze(ut.fromCssColorString("#C0C0C0"));ut.SKYBLUE=Object.freeze(ut.fromCssColorString("#87CEEB"));ut.SLATEBLUE=Object.freeze(ut.fromCssColorString("#6A5ACD"));ut.SLATEGRAY=Object.freeze(ut.fromCssColorString("#708090"));ut.SLATEGREY=ut.SLATEGRAY;ut.SNOW=Object.freeze(ut.fromCssColorString("#FFFAFA"));ut.SPRINGGREEN=Object.freeze(ut.fromCssColorString("#00FF7F"));ut.STEELBLUE=Object.freeze(ut.fromCssColorString("#4682B4"));ut.TAN=Object.freeze(ut.fromCssColorString("#D2B48C"));ut.TEAL=Object.freeze(ut.fromCssColorString("#008080"));ut.THISTLE=Object.freeze(ut.fromCssColorString("#D8BFD8"));ut.TOMATO=Object.freeze(ut.fromCssColorString("#FF6347"));ut.TURQUOISE=Object.freeze(ut.fromCssColorString("#40E0D0"));ut.VIOLET=Object.freeze(ut.fromCssColorString("#EE82EE"));ut.WHEAT=Object.freeze(ut.fromCssColorString("#F5DEB3"));ut.WHITE=Object.freeze(ut.fromCssColorString("#FFFFFF"));ut.WHITESMOKE=Object.freeze(ut.fromCssColorString("#F5F5F5"));ut.YELLOW=Object.freeze(ut.fromCssColorString("#FFFF00"));ut.YELLOWGREEN=Object.freeze(ut.fromCssColorString("#9ACD32"));ut.TRANSPARENT=Object.freeze(new ut(0,0,0,0));se=ut});function LF(e,r,n,o){e=B(e,1),r=B(r,1),n=B(n,1),o=B(o,1),this.value=new Uint8Array([se.floatToByte(e),se.floatToByte(r),se.floatToByte(n),se.floatToByte(o)])}var wn,su=Ee(()=>{Ar();mi();Ze();De();st();y(LF,"ColorGeometryInstanceAttribute");Object.defineProperties(LF.prototype,{componentDatatype:{get:function(){return Ie.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 4}},normalize:{get:function(){return!0}}});LF.fromColor=function(e){if(!p(e))throw new G("color is required.");return new LF(e.red,e.green,e.blue,e.alpha)};LF.toValue=function(e,r){if(!p(e))throw new G("color is required.");return p(r)?e.toBytes(r):new Uint8Array(e.toBytes())};LF.equals=function(e,r){return e===r||p(e)&&p(r)&&e.value[0]===r.value[0]&&e.value[1]===r.value[1]&&e.value[2]===r.value[2]&&e.value[3]===r.value[3]};wn=LF});function _x(e,r){if(X.typeOf.object("normal",e),!K.equalsEpsilon(E.magnitude(e),1,K.EPSILON6))throw new G("normal must be normalized.");X.typeOf.number("distance",r),this.normal=E.clone(e),this.distance=r}var gH,QPt,ZY,pn,K0=Ee(()=>{bt();cr();De();st();nr();Rr();y(_x,"Plane");_x.fromPointNormal=function(e,r,n){if(X.typeOf.object("point",e),X.typeOf.object("normal",r),!K.equalsEpsilon(E.magnitude(r),1,K.EPSILON6))throw new G("normal must be normalized.");var o=-E.dot(r,e);return p(n)?(E.clone(r,n.normal),n.distance=o,n):new _x(r,o)};gH=new E;_x.fromCartesian4=function(e,r){X.typeOf.object("coefficients",e);var n=E.fromCartesian4(e,gH),o=e.w;if(!K.equalsEpsilon(E.magnitude(n),1,K.EPSILON6))throw new G("normal must be normalized.");return p(r)?(E.clone(n,r.normal),r.distance=o,r):new _x(n,o)};_x.getPointDistance=function(e,r){return X.typeOf.object("plane",e),X.typeOf.object("point",r),E.dot(e.normal,r)+e.distance};QPt=new E;_x.projectPointOntoPlane=function(e,r,n){X.typeOf.object("plane",e),X.typeOf.object("point",r),p(n)||(n=new E);var o=_x.getPointDistance(e,r),a=E.multiplyByScalar(e.normal,o,QPt);return E.subtract(r,a,n)};ZY=new E;_x.transform=function(e,r,n){return X.typeOf.object("plane",e),X.typeOf.object("transform",r),Z.multiplyByPointAsVector(r,e.normal,gH),E.normalize(gH,gH),E.multiplyByScalar(e.normal,-e.distance,ZY),Z.multiplyByPoint(r,ZY,ZY),_x.fromPointNormal(ZY,gH,n)};_x.clone=function(e,r){return X.typeOf.object("plane",e),p(r)?(E.clone(e.normal,r.normal),r.distance=e.distance,r):new _x(e.normal,e.distance)};_x.equals=function(e,r){return X.typeOf.object("left",e),X.typeOf.object("right",r),e.distance===r.distance&&E.equals(e.normal,r.normal)};_x.ORIGIN_XY_PLANE=Object.freeze(new _x(E.UNIT_Z,0));_x.ORIGIN_YZ_PLANE=Object.freeze(new _x(E.UNIT_X,0));_x.ORIGIN_ZX_PLANE=Object.freeze(new _x(E.UNIT_Y,0));pn=_x});function dg(e){this.planes=B(e,[])}var _H,BS,XPt,bze,yx,o1=Ee(()=>{bt();Ci();Ze();De();st();Ql();K0();y(dg,"CullingVolume");_H=[new E,new E,new E];E.clone(E.UNIT_X,_H[0]);E.clone(E.UNIT_Y,_H[1]);E.clone(E.UNIT_Z,_H[2]);BS=new E,XPt=new E,bze=new pn(new E(1,0,0),0);dg.fromBoundingSphere=function(e,r){if(!p(e))throw new G("boundingSphere is required.");p(r)||(r=new dg);var n=_H.length,o=r.planes;o.length=2*n;for(var a=e.center,s=e.radius,l=0,h=0;h<n;++h){var x=_H[h],m=o[l],v=o[l+1];p(m)||(m=o[l]=new Ce),p(v)||(v=o[l+1]=new Ce),E.multiplyByScalar(x,-s,BS),E.add(a,BS,BS),m.x=x.x,m.y=x.y,m.z=x.z,m.w=-E.dot(x,BS),E.multiplyByScalar(x,s,BS),E.add(a,BS,BS),v.x=-x.x,v.y=-x.y,v.z=-x.z,v.w=-E.dot(E.negate(x,XPt),BS),l+=2}return r};dg.prototype.computeVisibility=function(e){if(!p(e))throw new G("boundingVolume is required.");for(var r=this.planes,n=!1,o=0,a=r.length;o<a;++o){var s=e.intersectPlane(pn.fromCartesian4(r[o],bze));if(s===wi.OUTSIDE)return wi.OUTSIDE;s===wi.INTERSECTING&&(n=!0)}return n?wi.INTERSECTING:wi.INSIDE};dg.prototype.computeVisibilityWithPlaneMask=function(e,r){if(!p(e))throw new G("boundingVolume is required.");if(!p(r))throw new G("parentPlaneMask is required.");if(r===dg.MASK_OUTSIDE||r===dg.MASK_INSIDE)return r;for(var n=dg.MASK_INSIDE,o=this.planes,a=0,s=o.length;a<s;++a){var l=a<31?1<<a:0;if(!(a<31&&(r&l)===0)){var h=e.intersectPlane(pn.fromCartesian4(o[a],bze));if(h===wi.OUTSIDE)return dg.MASK_OUTSIDE;h===wi.INTERSECTING&&(n|=l)}}return n};dg.MASK_OUTSIDE=4294967295;dg.MASK_INSIDE=0;dg.MASK_INDETERMINATE=2147483647;yx=dg});function KPt(){return!0}function ZPt(e,r){r=B(r,"This object was destroyed, i.e., destroy() was called.");function n(){throw new G(r)}y(n,"throwOnDestroyed");for(var o in e)typeof e[o]=="function"&&(e[o]=n);e.isDestroyed=KPt}var $e,ur=Ee(()=>{Ze();st();y(KPt,"returnTrue");y(ZPt,"destroyObject");$e=ZPt});function JPt(e){if(e=B(e,B.EMPTY_OBJECT),!p(e.geometry))throw new G("options.geometry is required.");this.geometry=e.geometry,this.modelMatrix=Z.clone(B(e.modelMatrix,Z.IDENTITY)),this.id=e.id,this.pickPrimitive=e.pickPrimitive,this.attributes=B(e.attributes,{}),this.westHemisphereGeometry=void 0,this.eastHemisphereGeometry=void 0}var Ui,Ks=Ee(()=>{Ze();De();st();Rr();y(JPt,"GeometryInstance");Ui=JPt});function MC(e){e=B(e,B.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=B(e.near,1),this._near=this.near,this.far=B(e.far,5e8),this._far=this.far,this._cullingVolume=new yx,this._orthographicMatrix=new Z}function Sze(e){if(!p(e.right)||!p(e.left)||!p(e.top)||!p(e.bottom)||!p(e.near)||!p(e.far))throw new G("right, left, top, bottom, near, or far parameters are not set.");if(e.top!==e._top||e.bottom!==e._bottom||e.left!==e._left||e.right!==e._right||e.near!==e._near||e.far!==e._far){if(e.left>e.right)throw new G("right must be greater than left.");if(e.bottom>e.top)throw new G("top must be greater than bottom.");if(e.near<=0||e.near>e.far)throw new G("near must be greater than zero and less than far.");e._left=e.left,e._right=e.right,e._top=e.top,e._bottom=e.bottom,e._near=e.near,e._far=e.far,e._orthographicMatrix=Z.computeOrthographicOffCenter(e.left,e.right,e.bottom,e.top,e.near,e.far,e._orthographicMatrix)}}var $Pt,eDt,tDt,Yhe,Pu,Ty=Ee(()=>{bt();Ci();o1();Ze();De();st();nr();Rr();y(MC,"OrthographicOffCenterFrustum");y(Sze,"update");Object.defineProperties(MC.prototype,{projectionMatrix:{get:function(){return Sze(this),this._orthographicMatrix}}});$Pt=new E,eDt=new E,tDt=new E,Yhe=new E;MC.prototype.computeCullingVolume=function(e,r,n){if(!p(e))throw new G("position is required.");if(!p(r))throw new G("direction is required.");if(!p(n))throw new G("up is required.");var o=this._cullingVolume.planes,a=this.top,s=this.bottom,l=this.right,h=this.left,x=this.near,m=this.far,v=E.cross(r,n,$Pt);E.normalize(v,v);var _=eDt;E.multiplyByScalar(r,x,_),E.add(e,_,_);var A=tDt;E.multiplyByScalar(v,h,A),E.add(_,A,A);var T=o[0];return p(T)||(T=o[0]=new Ce),T.x=v.x,T.y=v.y,T.z=v.z,T.w=-E.dot(v,A),E.multiplyByScalar(v,l,A),E.add(_,A,A),T=o[1],p(T)||(T=o[1]=new Ce),T.x=-v.x,T.y=-v.y,T.z=-v.z,T.w=-E.dot(E.negate(v,Yhe),A),E.multiplyByScalar(n,s,A),E.add(_,A,A),T=o[2],p(T)||(T=o[2]=new Ce),T.x=n.x,T.y=n.y,T.z=n.z,T.w=-E.dot(n,A),E.multiplyByScalar(n,a,A),E.add(_,A,A),T=o[3],p(T)||(T=o[3]=new Ce),T.x=-n.x,T.y=-n.y,T.z=-n.z,T.w=-E.dot(E.negate(n,Yhe),A),T=o[4],p(T)||(T=o[4]=new Ce),T.x=r.x,T.y=r.y,T.z=r.z,T.w=-E.dot(r,_),E.multiplyByScalar(r,m,A),E.add(e,A,A),T=o[5],p(T)||(T=o[5]=new Ce),T.x=-r.x,T.y=-r.y,T.z=-r.z,T.w=-E.dot(E.negate(r,Yhe),A),this._cullingVolume};MC.prototype.getPixelDimensions=function(e,r,n,o,a){if(Sze(this),!p(e)||!p(r))throw new G("Both drawingBufferWidth and drawingBufferHeight are required.");if(e<=0)throw new G("drawingBufferWidth must be greater than zero.");if(r<=0)throw new G("drawingBufferHeight must be greater than zero.");if(!p(n))throw new G("distance is required.");if(!p(o))throw new G("pixelRatio is required.");if(o<=0)throw new G("pixelRatio must be greater than zero.");if(!p(a))throw new G("A result object is required.");var s=this.right-this.left,l=this.top-this.bottom,h=o*s/e,x=o*l/r;return a.x=h,a.y=x,a};MC.prototype.clone=function(e){return p(e)||(e=new MC),e.left=this.left,e.right=this.right,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e};MC.prototype.equals=function(e){return p(e)&&e instanceof MC&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far};MC.prototype.equalsEpsilon=function(e,r,n){return e===this||p(e)&&e instanceof MC&&K.equalsEpsilon(this.right,e.right,r,n)&&K.equalsEpsilon(this.left,e.left,r,n)&&K.equalsEpsilon(this.top,e.top,r,n)&&K.equalsEpsilon(this.bottom,e.bottom,r,n)&&K.equalsEpsilon(this.near,e.near,r,n)&&K.equalsEpsilon(this.far,e.far,r,n)};Pu=MC});function wy(e){e=B(e,B.EMPTY_OBJECT),this.left=e.left,this._left=void 0,this.right=e.right,this._right=void 0,this.top=e.top,this._top=void 0,this.bottom=e.bottom,this._bottom=void 0,this.near=B(e.near,1),this._near=this.near,this.far=B(e.far,5e8),this._far=this.far,this._cullingVolume=new yx,this._perspectiveMatrix=new Z,this._infinitePerspective=new Z}function Qhe(e){if(!p(e.right)||!p(e.left)||!p(e.top)||!p(e.bottom)||!p(e.near)||!p(e.far))throw new G("right, left, top, bottom, near, or far parameters are not set.");var r=e.top,n=e.bottom,o=e.right,a=e.left,s=e.near,l=e.far;if(r!==e._top||n!==e._bottom||a!==e._left||o!==e._right||s!==e._near||l!==e._far){if(e.near<=0||e.near>e.far)throw new G("near must be greater than zero and less than far.");e._left=a,e._right=o,e._top=r,e._bottom=n,e._near=s,e._far=l,e._perspectiveMatrix=Z.computePerspectiveOffCenter(a,o,n,r,s,l,e._perspectiveMatrix),e._infinitePerspective=Z.computeInfinitePerspectiveOffCenter(a,o,n,r,s,e._infinitePerspective)}}var rDt,iDt,nDt,oDt,ym,QM=Ee(()=>{bt();Ci();o1();Ze();De();st();nr();Rr();y(wy,"PerspectiveOffCenterFrustum");y(Qhe,"update");Object.defineProperties(wy.prototype,{projectionMatrix:{get:function(){return Qhe(this),this._perspectiveMatrix}},infiniteProjectionMatrix:{get:function(){return Qhe(this),this._infinitePerspective}}});rDt=new E,iDt=new E,nDt=new E,oDt=new E;wy.prototype.resetProjectionMatrix=function(){if(!p(this.right)||!p(this.left)||!p(this.top)||!p(this.bottom)||!p(this.near)||!p(this.far))throw new G("right, left, top, bottom, near, or far parameters are not set.");var e=this.top,r=this.bottom,n=this.right,o=this.left,a=this.near,s=this.far;if(this.near<=0||this.near>this.far)throw new G("near must be greater than zero and less than far.");this._left=o,this._right=n,this._top=e,this._bottom=r,this._near=a,this._far=s,this._perspectiveMatrix=Z.computePerspectiveOffCenter(o,n,r,e,a,s,this._perspectiveMatrix),this._infinitePerspective=Z.computeInfinitePerspectiveOffCenter(o,n,r,e,a,this._infinitePerspective)};wy.prototype.computeCullingVolume=function(e,r,n,o){if(!p(e))throw new G("position is required.");if(!p(r))throw new G("direction is required.");if(!p(n))throw new G("up is required.");var a=this._cullingVolume.planes,s=B(o,0);s=Math.min(s,.5),s=Math.max(s,0);var l=this.top+this.top*s,h=this.bottom-this.top*s,x=this.right+this.right*s,m=this.left-this.right*s,v=this.near,_=this.far,A=E.cross(r,n,rDt),T=iDt;E.multiplyByScalar(r,v,T),E.add(e,T,T);var w=nDt;E.multiplyByScalar(r,_,w),E.add(e,w,w);var S=oDt;E.multiplyByScalar(A,m,S),E.add(T,S,S),E.subtract(S,e,S),E.normalize(S,S),E.cross(S,n,S),E.normalize(S,S);var P=a[0];return p(P)||(P=a[0]=new Ce),P.x=S.x,P.y=S.y,P.z=S.z,P.w=-E.dot(S,e),E.multiplyByScalar(A,x,S),E.add(T,S,S),E.subtract(S,e,S),E.cross(n,S,S),E.normalize(S,S),P=a[1],p(P)||(P=a[1]=new Ce),P.x=S.x,P.y=S.y,P.z=S.z,P.w=-E.dot(S,e),E.multiplyByScalar(n,h,S),E.add(T,S,S),E.subtract(S,e,S),E.cross(A,S,S),E.normalize(S,S),P=a[2],p(P)||(P=a[2]=new Ce),P.x=S.x,P.y=S.y,P.z=S.z,P.w=-E.dot(S,e),E.multiplyByScalar(n,l,S),E.add(T,S,S),E.subtract(S,e,S),E.cross(S,A,S),E.normalize(S,S),P=a[3],p(P)||(P=a[3]=new Ce),P.x=S.x,P.y=S.y,P.z=S.z,P.w=-E.dot(S,e),P=a[4],p(P)||(P=a[4]=new Ce),P.x=r.x,P.y=r.y,P.z=r.z,P.w=-E.dot(r,T),E.negate(r,S),P=a[5],p(P)||(P=a[5]=new Ce),P.x=S.x,P.y=S.y,P.z=S.z,P.w=-E.dot(S,w),this._cullingVolume};wy.prototype.getPixelDimensions=function(e,r,n,o,a){if(Qhe(this),!p(e)||!p(r))throw new G("Both drawingBufferWidth and drawingBufferHeight are required.");if(e<=0)throw new G("drawingBufferWidth must be greater than zero.");if(r<=0)throw new G("drawingBufferHeight must be greater than zero.");if(!p(n))throw new G("distance is required.");if(!p(o))throw new G("pixelRatio is required");if(o<=0)throw new G("pixelRatio must be greater than zero.");if(!p(a))throw new G("A result object is required.");var s=1/this.near,l=this.top*s,h=2*o*n*l/r;l=this.right*s;var x=2*o*n*l/e;return a.x=x,a.y=h,a};wy.prototype.clone=function(e){return p(e)||(e=new wy),e.right=this.right,e.left=this.left,e.top=this.top,e.bottom=this.bottom,e.near=this.near,e.far=this.far,e._left=void 0,e._right=void 0,e._top=void 0,e._bottom=void 0,e._near=void 0,e._far=void 0,e};wy.prototype.equals=function(e){return p(e)&&e instanceof wy&&this.right===e.right&&this.left===e.left&&this.top===e.top&&this.bottom===e.bottom&&this.near===e.near&&this.far===e.far};wy.prototype.equalsEpsilon=function(e,r,n){return e===this||p(e)&&e instanceof wy&&K.equalsEpsilon(this.right,e.right,r,n)&&K.equalsEpsilon(this.left,e.left,r,n)&&K.equalsEpsilon(this.top,e.top,r,n)&&K.equalsEpsilon(this.bottom,e.bottom,r,n)&&K.equalsEpsilon(this.near,e.near,r,n)&&K.equalsEpsilon(this.far,e.far,r,n)};ym=wy});function Am(e){e=B(e,B.EMPTY_OBJECT),this._offCenterFrustum=new ym,this.fov=e.fov,this._fov=void 0,this._fovy=void 0,this._sseDenominator=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=B(e.near,1),this._near=this.near,this.far=B(e.far,5e8),this._far=this.far,this.xOffset=B(e.xOffset,0),this._xOffset=this.xOffset,this.yOffset=B(e.yOffset,0),this._yOffset=this.yOffset,this.reflect=!1}function BC(e){if(!p(e.fov)||!p(e.aspectRatio)||!p(e.near)||!p(e.far))throw new G("fov, aspectRatio, near, or far parameters are not set.");var r=e._offCenterFrustum;if(e.fov!==e._fov||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far||e.xOffset!==e._xOffset||e.yOffset!==e._yOffset){if(e.fov<0||e.fov>=Math.PI)throw new G("fov must be in the range [0, PI).");if(e.aspectRatio<0)throw new G("aspectRatio must be positive.");if(e.near<0||e.near>e.far)throw new G("near must be greater than zero and less than far.");e._aspectRatio=e.aspectRatio,e._fov=e.fov,e._fovy=e.aspectRatio<=1?e.fov:Math.atan(Math.tan(e.fov*.5)/e.aspectRatio)*2,e._near=e.near,e._far=e.far,e._sseDenominator=2*Math.tan(.5*e._fovy),e._xOffset=e.xOffset,e._yOffset=e.yOffset,r.top=e.near*Math.tan(.5*e._fovy),r.bottom=-r.top,r.right=e.aspectRatio*r.top,r.left=-r.right,r.near=e.near,r.far=e.far,r.right+=e.xOffset,r.left+=e.xOffset,r.top+=e.yOffset,r.bottom+=e.yOffset}}function aDt(e){if(!(!p(e.clipPlane)||!p(e.currentViewMatrix))){var r=e.currentViewMatrix,n=e._offCenterFrustum.projectionMatrix;Z.multiplyByPlane(r,e.clipPlane,XM),yH.x=(K.sign(XM.normal.x)+n[8])/n[0],yH.y=(K.sign(XM.normal.y)+n[9])/n[5],yH.z=-1,yH.w=(1+n[10])/n[14],OF.x=XM.normal.x,OF.y=XM.normal.y,OF.z=XM.normal.z,OF.w=XM.distance,Ce.multiplyByScalar(OF,2/Ce.dot(OF,yH),AH),n[2]=AH.x,n[6]=AH.y,n[10]=AH.z+1,n[14]=AH.w}}var XM,yH,OF,AH,Ya,j2=Ee(()=>{cr();Ze();De();st();nr();bt();Ci();Rr();K0();QM();y(Am,"PerspectiveFrustum");Am.packedLength=6;Am.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.fov,r[n++]=e.aspectRatio,r[n++]=e.near,r[n++]=e.far,r[n++]=e.xOffset,r[n]=e.yOffset,r};Am.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Am),n.fov=e[r++],n.aspectRatio=e[r++],n.near=e[r++],n.far=e[r++],n.xOffset=e[r++],n.yOffset=e[r],n};y(BC,"update");Object.defineProperties(Am.prototype,{projectionMatrix:{get:function(){return BC(this),this.reflect&&aDt(this),this._offCenterFrustum.projectionMatrix}},infiniteProjectionMatrix:{get:function(){return BC(this),this._offCenterFrustum.infiniteProjectionMatrix}},fovy:{get:function(){return BC(this),this._fovy}},sseDenominator:{get:function(){return BC(this),this._sseDenominator}}});Am.prototype.resetProjectionMatrix=function(){return this._offCenterFrustum.resetProjectionMatrix()};Am.prototype.computeCullingVolume=function(e,r,n,o){return BC(this),this._offCenterFrustum.computeCullingVolume(e,r,n,o)};Am.prototype.getPixelDimensions=function(e,r,n,o,a){return BC(this),this._offCenterFrustum.getPixelDimensions(e,r,n,o,a)};Am.prototype.clone=function(e){return p(e)||(e=new Am),e.aspectRatio=this.aspectRatio,e.fov=this.fov,e.near=this.near,e.far=this.far,e.reflect=this.reflect,e.clipPlane=this.clipPlane,e.currentViewMatrix=this.currentViewMatrix,e._aspectRatio=void 0,e._fov=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e};Am.prototype.equals=function(e){return!p(e)||!(e instanceof Am)?!1:(BC(this),BC(e),this.fov===e.fov&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))};Am.prototype.equalsEpsilon=function(e,r,n){return!p(e)||!(e instanceof Am)?!1:(BC(this),BC(e),K.equalsEpsilon(this.fov,e.fov,r,n)&&K.equalsEpsilon(this.aspectRatio,e.aspectRatio,r,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,r,n))};XM=new pn(E.UNIT_Z,1),yH=new Ce,OF=new Ce,AH=new Ce;y(aDt,"modifyProjectionMatrix");Ya=Am});var Rs,Gt,go=Ee(()=>{co();Rs={UNSIGNED_BYTE:Se.UNSIGNED_BYTE,UNSIGNED_SHORT:Se.UNSIGNED_SHORT,UNSIGNED_INT:Se.UNSIGNED_INT,FLOAT:Se.FLOAT,HALF_FLOAT:Se.HALF_FLOAT_OES,UNSIGNED_INT_24_8:Se.UNSIGNED_INT_24_8,UNSIGNED_SHORT_4_4_4_4:Se.UNSIGNED_SHORT_4_4_4_4,UNSIGNED_SHORT_5_5_5_1:Se.UNSIGNED_SHORT_5_5_5_1,UNSIGNED_SHORT_5_6_5:Se.UNSIGNED_SHORT_5_6_5};Rs.toWebGLConstant=function(e,r){switch(e){case Rs.UNSIGNED_BYTE:return Se.UNSIGNED_BYTE;case Rs.UNSIGNED_SHORT:return Se.UNSIGNED_SHORT;case Rs.UNSIGNED_INT:return Se.UNSIGNED_INT;case Rs.FLOAT:return Se.FLOAT;case Rs.HALF_FLOAT:return r.webgl2?Se.HALF_FLOAT:Se.HALF_FLOAT_OES;case Rs.UNSIGNED_INT_24_8:return Se.UNSIGNED_INT_24_8;case Rs.UNSIGNED_SHORT_4_4_4_4:return Se.UNSIGNED_SHORT_4_4_4_4;case Rs.UNSIGNED_SHORT_5_5_5_1:return Se.UNSIGNED_SHORT_5_5_5_1;case Rs.UNSIGNED_SHORT_5_6_5:return Rs.UNSIGNED_SHORT_5_6_5}};Rs.isPacked=function(e){return e===Rs.UNSIGNED_INT_24_8||e===Rs.UNSIGNED_SHORT_4_4_4_4||e===Rs.UNSIGNED_SHORT_5_5_5_1||e===Rs.UNSIGNED_SHORT_5_6_5};Rs.sizeInBytes=function(e){switch(e){case Rs.UNSIGNED_BYTE:return 1;case Rs.UNSIGNED_SHORT:case Rs.UNSIGNED_SHORT_4_4_4_4:case Rs.UNSIGNED_SHORT_5_5_5_1:case Rs.UNSIGNED_SHORT_5_6_5:case Rs.HALF_FLOAT:return 2;case Rs.UNSIGNED_INT:case Rs.FLOAT:case Rs.UNSIGNED_INT_24_8:return 4}};Rs.validate=function(e){return e===Rs.UNSIGNED_BYTE||e===Rs.UNSIGNED_SHORT||e===Rs.UNSIGNED_INT||e===Rs.FLOAT||e===Rs.HALF_FLOAT||e===Rs.UNSIGNED_INT_24_8||e===Rs.UNSIGNED_SHORT_4_4_4_4||e===Rs.UNSIGNED_SHORT_5_5_5_1||e===Rs.UNSIGNED_SHORT_5_6_5};Gt=Object.freeze(Rs)});var ri,pt,Mn=Ee(()=>{go();co();ri={DEPTH_COMPONENT:Se.DEPTH_COMPONENT,DEPTH_COMPONENT16:Se.DEPTH_COMPONENT16,DEPTH_STENCIL:Se.DEPTH_STENCIL,ALPHA:Se.ALPHA,RGB:Se.RGB,RG:Se.RG,RGBA:Se.RGBA,LUMINANCE:Se.LUMINANCE,LUMINANCE_ALPHA:Se.LUMINANCE_ALPHA,RGB_DXT1:Se.COMPRESSED_RGB_S3TC_DXT1_EXT,RGBA_DXT1:Se.COMPRESSED_RGBA_S3TC_DXT1_EXT,RGBA_DXT3:Se.COMPRESSED_RGBA_S3TC_DXT3_EXT,RGBA_DXT5:Se.COMPRESSED_RGBA_S3TC_DXT5_EXT,RGB_PVRTC_4BPPV1:Se.COMPRESSED_RGB_PVRTC_4BPPV1_IMG,RGB_PVRTC_2BPPV1:Se.COMPRESSED_RGB_PVRTC_2BPPV1_IMG,RGBA_PVRTC_4BPPV1:Se.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG,RGBA_PVRTC_2BPPV1:Se.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG,RGBA_ASTC:Se.COMPRESSED_RGBA_ASTC_4x4_WEBGL,RGB_ETC1:Se.COMPRESSED_RGB_ETC1_WEBGL,RGB8_ETC2:Se.COMPRESSED_RGB8_ETC2,RGBA8_ETC2_EAC:Se.COMPRESSED_RGBA8_ETC2_EAC,RGBA_BC7:Se.COMPRESSED_RGBA_BPTC_UNORM,RED_INTEGER:Se.RED_INTEGER,RED:Se.RED};ri.componentsLength=function(e){switch(e){case ri.RGB:return 3;case ri.RGBA:return 4;case ri.LUMINANCE_ALPHA:case ri.RG:return 2;case ri.ALPHA:case ri.LUMINANCE:case ri.RED:case ri.RED_INTEGER:return 1;default:return 1}};ri.validate=function(e){return e===ri.DEPTH_COMPONENT||e===ri.DEPTH_COMPONENT16||e===ri.DEPTH_STENCIL||e===ri.ALPHA||e===ri.RED||e===ri.RED_INTEGER||e===ri.RG||e===ri.RGB||e===ri.RGBA||e===ri.LUMINANCE||e===ri.LUMINANCE_ALPHA||e===ri.RGB_DXT1||e===ri.RGBA_DXT1||e===ri.RGBA_DXT3||e===ri.RGBA_DXT5||e===ri.RGB_PVRTC_4BPPV1||e===ri.RGB_PVRTC_2BPPV1||e===ri.RGBA_PVRTC_4BPPV1||e===ri.RGBA_PVRTC_2BPPV1||e===ri.RGBA_ASTC||e===ri.RGB_ETC1||e===ri.RGB8_ETC2||e===ri.RGBA8_ETC2_EAC||e===ri.RGBA_BC7};ri.isColorFormat=function(e){return e===ri.ALPHA||e===ri.RED||e===ri.RED_INTEGER||e===ri.RGB||e===ri.RGBA||e===ri.LUMINANCE||e===ri.LUMINANCE_ALPHA};ri.isDepthFormat=function(e){return e===ri.DEPTH_COMPONENT||e===ri.DEPTH_COMPONENT16||e===ri.DEPTH_STENCIL};ri.isCompressedFormat=function(e){return e===ri.RGB_DXT1||e===ri.RGBA_DXT1||e===ri.RGBA_DXT3||e===ri.RGBA_DXT5||e===ri.RGB_PVRTC_4BPPV1||e===ri.RGB_PVRTC_2BPPV1||e===ri.RGBA_PVRTC_4BPPV1||e===ri.RGBA_PVRTC_2BPPV1||e===ri.RGBA_ASTC||e===ri.RGB_ETC1||e===ri.RGB8_ETC2||e===ri.RGBA8_ETC2_EAC||e===ri.RGBA_BC7};ri.isDXTFormat=function(e){return e===ri.RGB_DXT1||e===ri.RGBA_DXT1||e===ri.RGBA_DXT3||e===ri.RGBA_DXT5};ri.isPVRTCFormat=function(e){return e===ri.RGB_PVRTC_4BPPV1||e===ri.RGB_PVRTC_2BPPV1||e===ri.RGBA_PVRTC_4BPPV1||e===ri.RGBA_PVRTC_2BPPV1};ri.isASTCFormat=function(e){return e===ri.RGBA_ASTC};ri.isETC1Format=function(e){return e===ri.RGB_ETC1};ri.isETC2Format=function(e){return e===ri.RGB8_ETC2||e===ri.RGBA8_ETC2_EAC};ri.isBC7Format=function(e){return e===ri.RGBA_BC7};ri.compressedTextureSizeInBytes=function(e,r,n){switch(e){case ri.RGB_DXT1:case ri.RGBA_DXT1:case ri.RGB_ETC1:case ri.RGB8_ETC2:return Math.floor((r+3)/4)*Math.floor((n+3)/4)*8;case ri.RGBA_DXT3:case ri.RGBA_DXT5:case ri.RGBA_ASTC:case ri.RGBA8_ETC2_EAC:return Math.floor((r+3)/4)*Math.floor((n+3)/4)*16;case ri.RGB_PVRTC_4BPPV1:case ri.RGBA_PVRTC_4BPPV1:return Math.floor((Math.max(r,8)*Math.max(n,8)*4+7)/8);case ri.RGB_PVRTC_2BPPV1:case ri.RGBA_PVRTC_2BPPV1:return Math.floor((Math.max(r,16)*Math.max(n,8)*2+7)/8);case ri.RGBA_BC7:return Math.ceil(r/4)*Math.ceil(n/4)*16;default:return 0}};ri.textureSizeInBytes=function(e,r,n,o){let a=ri.componentsLength(e);return Gt.isPacked(r)&&(a=1),a*Gt.sizeInBytes(r)*n*o};ri.alignmentInBytes=function(e,r,n){let o=ri.textureSizeInBytes(e,r,n,1)%4;return o===0?4:o===2?2:1};ri.createTypedArray=function(e,r,n,o){let a,s=Gt.sizeInBytes(r);s===Uint8Array.BYTES_PER_ELEMENT?a=Uint8Array:s===Uint16Array.BYTES_PER_ELEMENT?a=Uint16Array:s===Float32Array.BYTES_PER_ELEMENT&&r===Gt.FLOAT?a=Float32Array:a=Uint32Array;let l=ri.componentsLength(e)*n*o;return new a(l)};ri.flipY=function(e,r,n,o,a){if(a===1)return e;let s=ri.createTypedArray(r,n,o,a),l=ri.componentsLength(r),h=o*l;for(let x=0;x<a;++x){let m=x*o*l,v=(a-x-1)*o*l;for(let _=0;_<h;++_)s[v+_]=e[m+_]}return s};ri.RGBToRGBA=function(e,r,n,o){for(var a=ri.createTypedArray(ri.RGBA,r,n,o),s=e.length/3,l=0;l<s;l++)a[l*4]=e[l*3],a[l*4+1]=e[l*3+1],a[l*4+2]=e[l*3+2];return a};ri.toInternalFormat=function(e,r,n){if(!n.webgl2)return e;if(e===ri.DEPTH_STENCIL)return Se.DEPTH24_STENCIL8;if(e===ri.DEPTH_COMPONENT){if(r===Gt.UNSIGNED_SHORT)return Se.DEPTH_COMPONENT16;if(r===Gt.UNSIGNED_INT)return Se.DEPTH_COMPONENT24;if(r===Gt.FLOAT)return Se.DEPTH_COMPONENT32F}if(e===ri.DEPTH_COMPONENT16)return Se.DEPTH_COMPONENT16;if(e===ri.DEPTH_COMPONENT32F)return Se.DEPTH_COMPONENT32F;if(r===Gt.UNSIGNED_BYTE)switch(e){case ri.RGBA:return Se.RGBA8;case ri.RGB:return Se.RGB8;case ri.RED:return Se.R8}if(r===Gt.FLOAT)switch(e){case ri.RGBA:return Se.RGBA32F;case ri.RGB:return Se.RGB32F;case ri.RG:return Se.RG32F;case ri.RED:return Se.R32F}if(r===Gt.HALF_FLOAT)switch(e){case ri.RGBA:return Se.RGBA16F;case ri.RGB:return Se.RGB16F;case ri.RG:return Se.RG16F;case ri.RED:return Se.R16F}return e};pt=Object.freeze(ri)});var Cm,tr,_n=Ee(()=>{De();st();nr();co();Cm={UNSIGNED_BYTE:Se.UNSIGNED_BYTE,UNSIGNED_SHORT:Se.UNSIGNED_SHORT,UNSIGNED_INT:Se.UNSIGNED_INT};Cm.getSizeInBytes=function(e){switch(e){case Cm.UNSIGNED_BYTE:return Uint8Array.BYTES_PER_ELEMENT;case Cm.UNSIGNED_SHORT:return Uint16Array.BYTES_PER_ELEMENT;case Cm.UNSIGNED_INT:return Uint32Array.BYTES_PER_ELEMENT}throw new G("indexDatatype is required and must be a valid IndexDatatype constant.")};Cm.fromSizeInBytes=function(e){switch(e){case 2:return Cm.UNSIGNED_SHORT;case 4:return Cm.UNSIGNED_INT;case 1:return Cm.UNSIGNED_BYTE;default:throw new G("Size in bytes cannot be mapped to an IndexDatatype")}};Cm.validate=function(e){return p(e)&&(e===Cm.UNSIGNED_BYTE||e===Cm.UNSIGNED_SHORT||e===Cm.UNSIGNED_INT)};Cm.createTypedArray=function(e,r){if(!p(e))throw new G("numberOfVertices is required.");return e>=K.SIXTY_FOUR_KILOBYTES?new Uint32Array(r):new Uint16Array(r)};Cm.createTypedArrayFromArrayBuffer=function(e,r,n,o){if(!p(e))throw new G("numberOfVertices is required.");if(!p(r))throw new G("sourceArray is required.");if(!p(n))throw new G("byteOffset is required.");return e>=K.SIXTY_FOUR_KILOBYTES?new Uint32Array(r,n,o):new Uint16Array(r,n,o)};tr=Object.freeze(Cm)});function eQ(e){e=B(e,B.EMPTY_OBJECT),this.color=e.color,this.depth=e.depth,this.stencil=e.stencil,this.renderState=e.renderState,this.framebuffer=e.framebuffer,this.owner=e.owner,this.pass=e.pass}var cn,ll=Ee(()=>{Ar();Ze();y(eQ,"ClearCommand");eQ.ALL=Object.freeze(new eQ({color:new se(0,0,0,0),depth:1,stencil:0}));eQ.prototype.execute=function(e,r){e.clear(this,r)};cn=eQ});var x0,fi,Pl=Ee(()=>{x0={_maximumCombinedTextureImageUnits:0,_maximumCubeMapSize:0,_maximumFragmentUniformVectors:0,_maximumTextureImageUnits:0,_maximumRenderbufferSize:0,_maximumTextureSize:0,_maximumVaryingVectors:0,_maximumVertexAttributes:0,_maximumVertexTextureImageUnits:0,_maximumVertexUniformVectors:0,_minimumAliasedLineWidth:0,_maximumAliasedLineWidth:0,_minimumAliasedPointSize:0,_maximumAliasedPointSize:0,_maximumViewportWidth:0,_maximumViewportHeight:0,_maximumTextureFilterAnisotropy:0,_maximumDrawBuffers:0,_maximumColorAttachments:0,_highpFloatSupported:!1,_highpIntSupported:!1,_uniformBufferOffsetAlignment:256,_maxUniformBufferBinding:36,_maxArrayTextureLayers:256};Object.defineProperties(x0,{maximumCombinedTextureImageUnits:{get:function(){return x0._maximumCombinedTextureImageUnits}},maximumCubeMapSize:{get:function(){return x0._maximumCubeMapSize}},maximumFragmentUniformVectors:{get:function(){return x0._maximumFragmentUniformVectors}},maximumTextureImageUnits:{get:function(){return x0._maximumTextureImageUnits}},maximumRenderbufferSize:{get:function(){return x0._maximumRenderbufferSize}},maximumTextureSize:{get:function(){return x0._maximumTextureSize}},maximumVaryingVectors:{get:function(){return x0._maximumVaryingVectors}},maximumVertexAttributes:{get:function(){return x0._maximumVertexAttributes}},maximumVertexTextureImageUnits:{get:function(){return x0._maximumVertexTextureImageUnits}},maximumVertexUniformVectors:{get:function(){return x0._maximumVertexUniformVectors}},minimumAliasedLineWidth:{get:function(){return x0._minimumAliasedLineWidth}},maximumAliasedLineWidth:{get:function(){return x0._maximumAliasedLineWidth}},minimumAliasedPointSize:{get:function(){return x0._minimumAliasedPointSize}},maximumAliasedPointSize:{get:function(){return x0._maximumAliasedPointSize}},maximumViewportWidth:{get:function(){return x0._maximumViewportWidth}},maximumViewportHeight:{get:function(){return x0._maximumViewportHeight}},maximumTextureFilterAnisotropy:{get:function(){return x0._maximumTextureFilterAnisotropy}},maximumDrawBuffers:{get:function(){return x0._maximumDrawBuffers}},maximumColorAttachments:{get:function(){return x0._maximumColorAttachments}},highpFloatSupported:{get:function(){return x0._highpFloatSupported}},highpIntSupported:{get:function(){return x0._highpIntSupported}},uniformBufferOffsetAlignment:{get:function(){return x0._uniformBufferOffsetAlignment}},maxUniformBufferBinding:{get:function(){return x0._maxUniformBufferBinding}},maxArrayTextureLayers:{get:function(){return x0._maxArrayTextureLayers}}});fi=x0});function tQ(e,r,n,o,a,s,l,h,x,m,v){this._context=e,this._texture=r,this._textureTarget=n,this._targetFace=o,this._pixelDatatype=l,this._internalFormat=a,this._pixelFormat=s,this._size=h,this._preMultiplyAlpha=x,this._flipY=m,this._initialized=v}var s1,Xhe=Ee(()=>{cr();Ze();De();st();Mn();go();y(tQ,"CubeMapFace");Object.defineProperties(tQ.prototype,{pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},_target:{get:function(){return this._targetFace}}});tQ.prototype.copyFrom=function(e){X.defined("options",e);let r=B(e.xOffset,0),n=B(e.yOffset,0);if(X.defined("options.source",e.source),X.typeOf.number.greaterThanOrEquals("xOffset",r,0),X.typeOf.number.greaterThanOrEquals("yOffset",n,0),r+e.source.width>this._size)throw new G("xOffset + options.source.width must be less than or equal to width.");if(n+e.source.height>this._size)throw new G("yOffset + options.source.height must be less than or equal to height.");let o=e.source,a=this._context._gl,s=this._textureTarget,l=this._targetFace;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture);let h=o.width,x=o.height,m=o.arrayBufferView,v=this._size,_=this._pixelFormat,A=this._internalFormat,T=this._pixelDatatype,w=this._preMultiplyAlpha,S=this._flipY,P=B(e.skipColorSpaceConversion,!1),M=4;p(m)&&(M=pt.alignmentInBytes(_,T,h)),a.pixelStorei(a.UNPACK_ALIGNMENT,M),P?a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.NONE):a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.BROWSER_DEFAULT_WEBGL);let L=!1;if(!this._initialized){if(r===0&&n===0&&h===v&&x===v)p(m)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),S&&(m=pt.flipY(m,_,T,v,v)),a.texImage2D(l,0,A,v,v,0,_,Gt.toWebGLConstant(T,this._context),m)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,w),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,S),a.texImage2D(l,0,A,_,Gt.toWebGLConstant(T,this._context),o)),L=!0;else{a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1);let R=pt.createTypedArray(_,T,v,v);a.texImage2D(l,0,A,v,v,0,_,Gt.toWebGLConstant(T,this._context),R)}this._initialized=!0}L||(p(m)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),S&&(m=pt.flipY(m,_,T,h,x)),a.texSubImage2D(l,0,r,n,h,x,_,Gt.toWebGLConstant(T,this._context),m)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,w),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,S),a.texSubImage2D(l,0,r,n,_,Gt.toWebGLConstant(T,this._context),o))),a.bindTexture(s,null)};tQ.prototype.copyFromFramebuffer=function(e,r,n,o,a,s){if(e=B(e,0),r=B(r,0),n=B(n,0),o=B(o,0),a=B(a,this._size),s=B(s,this._size),X.typeOf.number.greaterThanOrEquals("xOffset",e,0),X.typeOf.number.greaterThanOrEquals("yOffset",r,0),X.typeOf.number.greaterThanOrEquals("framebufferXOffset",n,0),X.typeOf.number.greaterThanOrEquals("framebufferYOffset",o,0),e+a>this._size)throw new G("xOffset + source.width must be less than or equal to width.");if(r+s>this._size)throw new G("yOffset + source.height must be less than or equal to height.");if(this._pixelDatatype===Gt.FLOAT)throw new G("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");if(this._pixelDatatype===Gt.HALF_FLOAT)throw new G("Cannot call copyFromFramebuffer when the texture pixel data type is HALF_FLOAT.");let l=this._context._gl,h=this._textureTarget;l.activeTexture(l.TEXTURE0),l.bindTexture(h,this._texture),l.copyTexSubImage2D(this._targetFace,0,e,r,n,o,a,s),l.bindTexture(h,null),this._initialized=!0};s1=tQ});var rQ,jc,RC=Ee(()=>{co();rQ={DONT_CARE:Se.DONT_CARE,FASTEST:Se.FASTEST,NICEST:Se.NICEST,validate:function(e){return e===rQ.DONT_CARE||e===rQ.FASTEST||e===rQ.NICEST}},jc=Object.freeze(rQ)});var Khe,xi,Ia=Ee(()=>{co();Khe={NEAREST:Se.NEAREST,LINEAR:Se.LINEAR,validate:function(e){return e===Khe.NEAREST||e===Khe.LINEAR}},xi=Object.freeze(Khe)});var ZM,Dr,pa=Ee(()=>{co();ZM={NEAREST:Se.NEAREST,LINEAR:Se.LINEAR,NEAREST_MIPMAP_NEAREST:Se.NEAREST_MIPMAP_NEAREST,LINEAR_MIPMAP_NEAREST:Se.LINEAR_MIPMAP_NEAREST,NEAREST_MIPMAP_LINEAR:Se.NEAREST_MIPMAP_LINEAR,LINEAR_MIPMAP_LINEAR:Se.LINEAR_MIPMAP_LINEAR,validate:function(e){return e===ZM.NEAREST||e===ZM.LINEAR||e===ZM.NEAREST_MIPMAP_NEAREST||e===ZM.LINEAR_MIPMAP_NEAREST||e===ZM.NEAREST_MIPMAP_LINEAR||e===ZM.LINEAR_MIPMAP_LINEAR}},Dr=Object.freeze(ZM)});var iQ,Jt,ya=Ee(()=>{co();iQ={CLAMP_TO_EDGE:Se.CLAMP_TO_EDGE,REPEAT:Se.REPEAT,MIRRORED_REPEAT:Se.MIRRORED_REPEAT,validate:function(e){return e===iQ.CLAMP_TO_EDGE||e===iQ.REPEAT||e===iQ.MIRRORED_REPEAT}},Jt=Object.freeze(iQ)});function CH(e){e=B(e,B.EMPTY_OBJECT);let r=B(e.wrapS,Jt.CLAMP_TO_EDGE),n=B(e.wrapT,Jt.CLAMP_TO_EDGE),o=B(e.minificationFilter,Dr.LINEAR),a=B(e.magnificationFilter,xi.LINEAR),s=p(e.maximumAnisotropy)?e.maximumAnisotropy:1;if(!Jt.validate(r))throw new G("Invalid sampler.wrapS.");if(!Jt.validate(n))throw new G("Invalid sampler.wrapT.");if(!Dr.validate(o))throw new G("Invalid sampler.minificationFilter.");if(!xi.validate(a))throw new G("Invalid sampler.magnificationFilter.");X.typeOf.number.greaterThanOrEquals("maximumAnisotropy",s,1),this._wrapS=r,this._wrapT=n,this._minificationFilter=o,this._magnificationFilter=a,this._maximumAnisotropy=s}var Yr,ra=Ee(()=>{cr();Ze();De();st();Ia();pa();ya();y(CH,"Sampler");Object.defineProperties(CH.prototype,{wrapS:{get:function(){return this._wrapS}},wrapT:{get:function(){return this._wrapT}},minificationFilter:{get:function(){return this._minificationFilter}},magnificationFilter:{get:function(){return this._magnificationFilter}},maximumAnisotropy:{get:function(){return this._maximumAnisotropy}}});CH.equals=function(e,r){return e===r||p(e)&&p(r)&&e._wrapS===r._wrapS&&e._wrapT===r._wrapT&&e._minificationFilter===r._minificationFilter&&e._magnificationFilter===r._magnificationFilter&&e._maximumAnisotropy===r._maximumAnisotropy};CH.NEAREST=Object.freeze(new CH({wrapS:Jt.CLAMP_TO_EDGE,wrapT:Jt.CLAMP_TO_EDGE,minificationFilter:Dr.NEAREST,magnificationFilter:xi.NEAREST}));Yr=CH});function TH(e){e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context);let r=e.context,n=e.source,o,a;if(p(n)){let L=[n.positiveX,n.negativeX,n.positiveY,n.negativeY,n.positiveZ,n.negativeZ];if(!L[0]||!L[1]||!L[2]||!L[3]||!L[4]||!L[5])throw new G("options.source requires positiveX, negativeX, positiveY, negativeY, positiveZ, and negativeZ faces.");o=L[0].width,a=L[0].height;for(let R=1;R<6;++R)if(Number(L[R].width)!==o||Number(L[R].height)!==a)throw new G("Each face in options.source must have the same width and height.")}else o=e.width,a=e.height;let s=o,l=B(e.pixelDatatype,Gt.UNSIGNED_BYTE),h=B(e.pixelFormat,pt.RGBA),x=pt.toInternalFormat(h,l,r);if(!p(o)||!p(a))throw new G("options requires a source field to create an initialized cube map or width and height fields to create a blank cube map.");if(o!==a)throw new G("Width must equal height.");if(s<=0)throw new G("Width and height must be greater than zero.");if(s>fi.maximumCubeMapSize)throw new G(`Width and height must be less than or equal to the maximum cube map size (${fi.maximumCubeMapSize}).  Check maximumCubeMapSize.`);if(!pt.validate(h))throw new G("Invalid options.pixelFormat.");if(pt.isDepthFormat(h))throw new G("options.pixelFormat cannot be DEPTH_COMPONENT or DEPTH_STENCIL.");if(!Gt.validate(l))throw new G("Invalid options.pixelDatatype.");if(l===Gt.FLOAT&&!r.floatingPointTexture)throw new G("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.");if(l===Gt.HALF_FLOAT&&!r.halfFloatingPointTexture)throw new G("When options.pixelDatatype is HALF_FLOAT, this WebGL implementation must support the OES_texture_half_float extension.");let m=pt.textureSizeInBytes(h,l,s,s)*6,v=e.preMultiplyAlpha||h===pt.RGB||h===pt.LUMINANCE,_=B(e.flipY,!0),A=B(e.skipColorSpaceConversion,!1),T=r._gl,w=T.TEXTURE_CUBE_MAP,S=T.createTexture();T.activeTexture(T.TEXTURE0),T.bindTexture(w,S);function P(L,R,O,N,k){let z=R.arrayBufferView;p(z)||(z=R.bufferView);let W=4;p(z)&&(W=pt.alignmentInBytes(h,l,o)),T.pixelStorei(T.UNPACK_ALIGNMENT,W),k?T.pixelStorei(T.UNPACK_COLORSPACE_CONVERSION_WEBGL,T.NONE):T.pixelStorei(T.UNPACK_COLORSPACE_CONVERSION_WEBGL,T.BROWSER_DEFAULT_WEBGL),p(z)?(T.pixelStorei(T.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),T.pixelStorei(T.UNPACK_FLIP_Y_WEBGL,!1),N&&(z=pt.flipY(z,h,l,s,s)),T.texImage2D(L,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),z)):(T.pixelStorei(T.UNPACK_PREMULTIPLY_ALPHA_WEBGL,O),T.pixelStorei(T.UNPACK_FLIP_Y_WEBGL,N),T.texImage2D(L,0,x,h,Gt.toWebGLConstant(l,r),R))}y(P,"createFace"),p(n)?(P(T.TEXTURE_CUBE_MAP_POSITIVE_X,n.positiveX,v,_,A),P(T.TEXTURE_CUBE_MAP_NEGATIVE_X,n.negativeX,v,_,A),P(T.TEXTURE_CUBE_MAP_POSITIVE_Y,n.positiveY,v,_,A),P(T.TEXTURE_CUBE_MAP_NEGATIVE_Y,n.negativeY,v,_,A),P(T.TEXTURE_CUBE_MAP_POSITIVE_Z,n.positiveZ,v,_,A),P(T.TEXTURE_CUBE_MAP_NEGATIVE_Z,n.negativeZ,v,_,A)):(T.texImage2D(T.TEXTURE_CUBE_MAP_POSITIVE_X,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null),T.texImage2D(T.TEXTURE_CUBE_MAP_NEGATIVE_X,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null),T.texImage2D(T.TEXTURE_CUBE_MAP_POSITIVE_Y,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null),T.texImage2D(T.TEXTURE_CUBE_MAP_NEGATIVE_Y,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null),T.texImage2D(T.TEXTURE_CUBE_MAP_POSITIVE_Z,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null),T.texImage2D(T.TEXTURE_CUBE_MAP_NEGATIVE_Z,0,x,s,s,0,h,Gt.toWebGLConstant(l,r),null)),T.bindTexture(w,null),this._context=r,this._textureFilterAnisotropic=r._textureFilterAnisotropic,this._textureTarget=w,this._texture=S,this._pixelFormat=h,this._pixelDatatype=l,this._size=s,this._hasMipmap=!1,this._sizeInBytes=m,this._preMultiplyAlpha=v,this._flipY=_,this._sampler=void 0;let M=p(n);this._positiveX=new s1(r,S,w,T.TEXTURE_CUBE_MAP_POSITIVE_X,x,h,l,s,v,_,M),this._negativeX=new s1(r,S,w,T.TEXTURE_CUBE_MAP_NEGATIVE_X,x,h,l,s,v,_,M),this._positiveY=new s1(r,S,w,T.TEXTURE_CUBE_MAP_POSITIVE_Y,x,h,l,s,v,_,M),this._negativeY=new s1(r,S,w,T.TEXTURE_CUBE_MAP_NEGATIVE_Y,x,h,l,s,v,_,M),this._positiveZ=new s1(r,S,w,T.TEXTURE_CUBE_MAP_POSITIVE_Z,x,h,l,s,v,_,M),this._negativeZ=new s1(r,S,w,T.TEXTURE_CUBE_MAP_NEGATIVE_Z,x,h,l,s,v,_,M),this.sampler=p(e.sampler)?e.sampler:new Yr}var Fh,l1=Ee(()=>{cr();Ze();De();ur();st();nr();Mn();Pl();Xhe();RC();go();ra();Ia();pa();y(TH,"CubeMap");Object.defineProperties(TH.prototype,{positiveX:{get:function(){return this._positiveX}},negativeX:{get:function(){return this._negativeX}},positiveY:{get:function(){return this._positiveY}},negativeY:{get:function(){return this._negativeY}},positiveZ:{get:function(){return this._positiveZ}},negativeZ:{get:function(){return this._negativeZ}},sampler:{get:function(){return this._sampler},set:function(e){let r=e.minificationFilter,n=e.magnificationFilter,o=r===Dr.NEAREST_MIPMAP_NEAREST||r===Dr.NEAREST_MIPMAP_LINEAR||r===Dr.LINEAR_MIPMAP_NEAREST||r===Dr.LINEAR_MIPMAP_LINEAR,a=this._context,s=this._pixelDatatype;(s===Gt.FLOAT&&!a.textureFloatLinear||s===Gt.HALF_FLOAT&&!a.textureHalfFloatLinear)&&(r=o?Dr.NEAREST_MIPMAP_NEAREST:Dr.NEAREST,n=xi.NEAREST);let l=a._gl,h=this._textureTarget;l.activeTexture(l.TEXTURE0),l.bindTexture(h,this._texture),l.texParameteri(h,l.TEXTURE_MIN_FILTER,r),l.texParameteri(h,l.TEXTURE_MAG_FILTER,n),l.texParameteri(h,l.TEXTURE_WRAP_S,e.wrapS),l.texParameteri(h,l.TEXTURE_WRAP_T,e.wrapT),p(this._textureFilterAnisotropic)&&l.texParameteri(h,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),l.bindTexture(h,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},width:{get:function(){return this._size}},height:{get:function(){return this._size}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(this._sizeInBytes*4/3):this._sizeInBytes}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},_target:{get:function(){return this._textureTarget}}});TH.prototype.generateMipmap=function(e){if(e=B(e,jc.DONT_CARE),this._size>1&&!K.isPowerOfTwo(this._size))throw new G("width and height must be a power of two to call generateMipmap().");if(!jc.validate(e))throw new G("hint is invalid.");this._hasMipmap=!0;let r=this._context._gl,n=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture),r.generateMipmap(n),r.bindTexture(n,null)};TH.prototype.isDestroyed=function(){return!1};TH.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._positiveX=$e(this._positiveX),this._negativeX=$e(this._negativeX),this._positiveY=$e(this._positiveY),this._negativeY=$e(this._negativeY),this._positiveZ=$e(this._positiveZ),this._negativeZ=$e(this._negativeZ),$e(this)};Fh=TH});function LS(e){e=B(e,B.EMPTY_OBJECT),this._boundingVolume=e.boundingVolume,this._orientedBoundingBox=e.orientedBoundingBox,this._cull=B(e.cull,!0),this._occlude=B(e.occlude,!0),this._modelMatrix=e.modelMatrix,this._primitiveType=B(e.primitiveType,jt.TRIANGLES),this._vertexArray=e.vertexArray,this._count=e.count,this._offset=B(e.offset,0),this._instanceCount=B(e.instanceCount,0),this._shaderProgram=e.shaderProgram,this._uniformMap=e.uniformMap,this._renderState=e.renderState,this._framebuffer=e.framebuffer,this._pass=e.pass,this._executeInClosestFrustum=B(e.executeInClosestFrustum,!1),this._owner=e.owner,this._debugShowBoundingVolume=B(e.debugShowBoundingVolume,!1),this._debugOverlappingFrustums=0,this._castShadows=B(e.castShadows,!1),this._receiveShadows=B(e.receiveShadows,!1),this._selectCastShadows=!1,this._pickId=e.pickId,this._pickOnly=B(e.pickOnly,!1),this.dirty=!0,this.lastDirtyTime=0,this.derivedCommands={},this._uniformBuffers=[]}var Yt,Kn=Ee(()=>{Ze();De();un();y(LS,"DrawCommand");Object.defineProperties(LS.prototype,{boundingVolume:{get:function(){return this._boundingVolume},set:function(e){this._boundingVolume!==e&&(this._boundingVolume=e,this.dirty=!0)}},orientedBoundingBox:{get:function(){return this._orientedBoundingBox},set:function(e){this._orientedBoundingBox!==e&&(this._orientedBoundingBox=e,this.dirty=!0)}},cull:{get:function(){return this._cull},set:function(e){this._cull!==e&&(this._cull=e,this.dirty=!0)}},occlude:{get:function(){return this._occlude},set:function(e){this._occlude!==e&&(this._occlude=e,this.dirty=!0)}},test:{get:function(){return this._test},set:function(e){this._test=e}},modelMatrix:{get:function(){return this._modelMatrix},set:function(e){this._modelMatrix!==e&&(this._modelMatrix=e,this.dirty=!0)}},primitiveType:{get:function(){return this._primitiveType},set:function(e){this._primitiveType!==e&&(this._primitiveType=e,this.dirty=!0)}},vertexArray:{get:function(){return this._vertexArray},set:function(e){this._vertexArray!==e&&(this._vertexArray=e,this.dirty=!0)}},count:{get:function(){return this._count},set:function(e){this._count!==e&&(this._count=e,this.dirty=!0)}},offset:{get:function(){return this._offset},set:function(e){this._offset!==e&&(this._offset=e,this.dirty=!0)}},instanceCount:{get:function(){return this._instanceCount},set:function(e){this._instanceCount!==e&&(this._instanceCount=e,this.dirty=!0)}},shaderProgram:{get:function(){return this._shaderProgram},set:function(e){this._shaderProgram!==e&&(this._shaderProgram=e,this.dirty=!0)}},castShadows:{get:function(){return this._castShadows},set:function(e){this._castShadows!==e&&(this._castShadows=e,this.dirty=!0)}},selectCastShadows:{get:function(){return this._selectCastShadows},set:function(e){this._selectCastShadows!==e&&(this._selectCastShadows=e,this.dirty=!0)}},receiveShadows:{get:function(){return this._receiveShadows},set:function(e){this._receiveShadows!==e&&(this._receiveShadows=e,this.dirty=!0)}},uniformMap:{get:function(){return this._uniformMap},set:function(e){this._uniformMap!==e&&(this._uniformMap=e,this.dirty=!0)}},renderState:{get:function(){return this._renderState},set:function(e){this._renderState!==e&&(this._renderState=e,this.dirty=!0)}},framebuffer:{get:function(){return this._framebuffer},set:function(e){this._framebuffer!==e&&(this._framebuffer=e,this.dirty=!0)}},pass:{get:function(){return this._pass},set:function(e){this._pass!==e&&(this._pass=e,this.dirty=!0)}},executeInClosestFrustum:{get:function(){return this._executeInClosestFrustum},set:function(e){this._executeInClosestFrustum!==e&&(this._executeInClosestFrustum=e,this.dirty=!0)}},owner:{get:function(){return this._owner},set:function(e){this._owner!==e&&(this._owner=e,this.dirty=!0)}},debugShowBoundingVolume:{get:function(){return this._debugShowBoundingVolume},set:function(e){this._debugShowBoundingVolume!==e&&(this._debugShowBoundingVolume=e,this.dirty=!0)}},debugOverlappingFrustums:{get:function(){return this._debugOverlappingFrustums},set:function(e){this._debugOverlappingFrustums!==e&&(this._debugOverlappingFrustums=e,this.dirty=!0)}},pickId:{get:function(){return this._pickId},set:function(e){this._pickId!==e&&(this._pickId=e,this.dirty=!0)}},pickOnly:{get:function(){return this._pickOnly},set:function(e){this._pickOnly!==e&&(this._pickOnly=e,this.dirty=!0)}}});LS.prototype.addUniformBuffer=function(e){e.increaseRef(),this._uniformBuffers.push(e)};LS.prototype.removeAllUniformBuffer=function(){if(!!p(this._uniformBuffers)){for(var e=0;e<this._uniformBuffers.length;e++)this._uniformBuffers[e].decreaseRef();this._uniformBuffers=[]}};LS.shallowClone=function(e,r){if(!!p(e))return p(r)||(r=new LS),r._boundingVolume=e._boundingVolume,r._orientedBoundingBox=e._orientedBoundingBox,r._cull=e._cull,r._occlude=e._occlude,r._modelMatrix=e._modelMatrix,r._primitiveType=e._primitiveType,r._vertexArray=e._vertexArray,r._count=e._count,r._offset=e._offset,r._instanceCount=e._instanceCount,r._shaderProgram=e._shaderProgram,r._uniformMap=e._uniformMap,r._uniformBuffers=e._uniformBuffers,r._renderState=e._renderState,r._framebuffer=e._framebuffer,r._pass=e._pass,r._executeInClosestFrustum=e._executeInClosestFrustum,r._owner=e._owner,r._debugShowBoundingVolume=e._debugShowBoundingVolume,r._debugOverlappingFrustums=e._debugOverlappingFrustums,r._castShadows=e._castShadows,r._receiveShadows=e._receiveShadows,r._selectCastShadows=e._selectCastShadows,r._pickId=e._pickId,r._pickOnly=e._pickOnly,r._pointCloudEyeDomeLighting=e._pointCloudEyeDomeLighting,r.dirty=!0,r.lastDirtyTime=0,r};LS.prototype.removeAllFastBundleAndBindGroups=function(){this.bindGroups=void 0,this._fastBundle={}};LS.prototype.execute=function(e,r){e.draw(this,r)};Yt=LS});function Zhe(e,r,n,o){var a=e._gl;if(n.is3D||n.is2DArray){let s=o||0,l=0;a.framebufferTextureLayer(a.FRAMEBUFFER,r,n._texture,l,s)}else a.framebufferTexture2D(a.FRAMEBUFFER,r,n._target,n._texture,0)}function nQ(e,r,n){var o=e._gl;o.framebufferRenderbuffer(o.FRAMEBUFFER,r,o.RENDERBUFFER,n._getRenderbuffer())}function LC(e){e=B(e,B.EMPTY_OBJECT);var r=e.context;X.defined("options.context",r);var n=r._gl,o=fi.maximumColorAttachments;if(this._gl=n,this._framebuffer=n.createFramebuffer(),this._colorTextures=[],this._colorRenderbuffers=[],this._activeColorAttachments=[],this._depthTexture=void 0,this._depthRenderbuffer=void 0,this._stencilRenderbuffer=void 0,this._depthStencilTexture=void 0,this._depthStencilRenderbuffer=void 0,this.destroyAttachments=B(e.destroyAttachments,!0),p(e.colorTextures)&&p(e.colorRenderbuffers))throw new G("Cannot have both color texture and color renderbuffer attachments.");if(p(e.depthTexture)&&p(e.depthRenderbuffer))throw new G("Cannot have both a depth texture and depth renderbuffer attachment.");if(p(e.depthStencilTexture)&&p(e.depthStencilRenderbuffer))throw new G("Cannot have both a depth-stencil texture and depth-stencil renderbuffer attachment.");var a=p(e.depthTexture)||p(e.depthRenderbuffer),s=p(e.depthStencilTexture)||p(e.depthStencilRenderbuffer);if(a&&s)throw new G("Cannot have both a depth and depth-stencil attachment.");if(p(e.stencilRenderbuffer)&&s)throw new G("Cannot have both a stencil and depth-stencil attachment.");if(a&&p(e.stencilRenderbuffer))throw new G("Cannot have both a depth and stencil attachment.");this._bind();var l,h,x,m,v;if(p(e.colorTextures)){var _=e.colorTextures;if(m=this._colorTextures.length=this._activeColorAttachments.length=_.length,m>o)throw new G("The number of color attachments exceeds the number supported.");for(x=0;x<m;++x){if(l=_[x],!pt.isColorFormat(l.pixelFormat))throw new G("The color-texture pixel-format must be a color format.");if(l.pixelDatatype===Gt.FLOAT&&!r.colorBufferFloat)throw new G("The color texture pixel datatype is FLOAT and the WebGL implementation does not support the EXT_color_buffer_float or WEBGL_color_buffer_float extensions. See Context.colorBufferFloat.");if(l.pixelDatatype===Gt.HALF_FLOAT&&!r.colorBufferHalfFloat)throw new G("The color texture pixel datatype is HALF_FLOAT and the WebGL implementation does not support the EXT_color_buffer_half_float extension. See Context.colorBufferHalfFloat.");var A=0;p(e.colorTextureActiveLayers)&&(A=e.colorTextureActiveLayers[x]),v=this._gl.COLOR_ATTACHMENT0+x,Zhe(this,v,l,A),this._activeColorAttachments[x]=v,this._colorTextures[x]=l}}if(p(e.colorRenderbuffers)){var T=e.colorRenderbuffers;if(m=this._colorRenderbuffers.length=this._activeColorAttachments.length=T.length,m>o)throw new G("The number of color attachments exceeds the number supported.");for(x=0;x<m;++x)h=T[x],v=this._gl.COLOR_ATTACHMENT0+x,nQ(this,v,h),this._activeColorAttachments[x]=v,this._colorRenderbuffers[x]=h}if(p(e.depthTexture)){if(l=e.depthTexture,l.pixelFormat!==pt.DEPTH_COMPONENT)throw new G("The depth-texture pixel-format must be DEPTH_COMPONENT.");Zhe(this,this._gl.DEPTH_ATTACHMENT,l),this._depthTexture=l}if(p(e.depthRenderbuffer)&&(h=e.depthRenderbuffer,nQ(this,this._gl.DEPTH_ATTACHMENT,h),this._depthRenderbuffer=h),p(e.stencilRenderbuffer)&&(h=e.stencilRenderbuffer,nQ(this,this._gl.STENCIL_ATTACHMENT,h),this._stencilRenderbuffer=h),p(e.depthStencilTexture)){if(l=e.depthStencilTexture,l.pixelFormat!==pt.DEPTH_STENCIL)throw new G("The depth-stencil pixel-format must be DEPTH_STENCIL.");Zhe(this,this._gl.DEPTH_STENCIL_ATTACHMENT,l),this._depthStencilTexture=l}p(e.depthStencilRenderbuffer)&&(h=e.depthStencilRenderbuffer,nQ(this,this._gl.DEPTH_STENCIL_ATTACHMENT,h),this._depthStencilRenderbuffer=h),this._unBind()}var Hr,Ea=Ee(()=>{cr();Ze();De();ur();st();Mn();Pl();go();y(Zhe,"attachTexture");y(nQ,"attachRenderbuffer");y(LC,"Framebuffer");Object.defineProperties(LC.prototype,{status:{get:function(){this._bind();var e=this._gl.checkFramebufferStatus(this._gl.FRAMEBUFFER);return this._unBind(),e}},numberOfColorAttachments:{get:function(){return this._activeColorAttachments.length}},depthTexture:{get:function(){return this._depthTexture}},depthRenderbuffer:{get:function(){return this._depthRenderbuffer}},stencilRenderbuffer:{get:function(){return this._stencilRenderbuffer}},depthStencilTexture:{get:function(){return this._depthStencilTexture}},depthStencilRenderbuffer:{get:function(){return this._depthStencilRenderbuffer}},hasDepthAttachment:{get:function(){return!!(this.depthTexture||this.depthRenderbuffer||this.depthStencilTexture||this.depthStencilRenderbuffer)}}});LC.prototype._bind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,this._framebuffer)};LC.prototype._unBind=function(){var e=this._gl;e.bindFramebuffer(e.FRAMEBUFFER,null)};LC.prototype._getActiveColorAttachments=function(){return this._activeColorAttachments};LC.prototype.getColorTexture=function(e){if(!p(e)||e<0||e>=this._colorTextures.length)throw new G("index is required, must be greater than or equal to zero and must be less than the number of color attachments.");return this._colorTextures[e]};LC.prototype.getColorRenderbuffer=function(e){if(!p(e)||e<0||e>=this._colorRenderbuffers.length)throw new G("index is required, must be greater than or equal to zero and must be less than the number of color attachments.");return this._colorRenderbuffers[e]};LC.prototype.isDestroyed=function(){return!1};LC.prototype.destroy=function(){if(this.destroyAttachments){for(var e=0,r=this._colorTextures,n=r.length;e<n;++e){var o=r[e];p(o)&&o.destroy()}var a=this._colorRenderbuffers;for(n=a.length,e=0;e<n;++e){var s=a[e];p(s)&&s.destroy()}this._depthTexture=this._depthTexture&&this._depthTexture.destroy(),this._depthRenderbuffer=this._depthRenderbuffer&&this._depthRenderbuffer.destroy(),this._stencilRenderbuffer=this._stencilRenderbuffer&&this._stencilRenderbuffer.destroy(),this._depthStencilTexture=this._depthStencilTexture&&this._depthStencilTexture.destroy(),this._depthStencilRenderbuffer=this._depthStencilRenderbuffer&&this._depthStencilRenderbuffer.destroy()}return this._gl.deleteFramebuffer(this._framebuffer),$e(this)};LC.copyFromFramebufferToFramebuffer=function(e,r,n,o,a,s){if(!!e.webgl2){var l=e._gl,h=0;if(o&&(h|=l.COLOR_BUFFER_BIT),a&&(h|=l.DEPTH_BUFFER_BIT),s&&(h|=l.STENCIL_BUFFER_BIT),h!=0){l.bindFramebuffer(l.READ_FRAMEBUFFER,r._framebuffer),l.bindFramebuffer(l.DRAW_FRAMEBUFFER,n._framebuffer);var x=n.getColorTexture(0),m=x.width,v=x.height;l.blitFramebuffer(0,0,m,v,0,0,m,v,h,l.NEAREST),l.bindFramebuffer(l.READ_FRAMEBUFFER,null),l.bindFramebuffer(l.DRAW_FRAMEBUFFER,null)}}};Hr=LC});var uDt,_t,Ao=Ee(()=>{uDt={ENVIRONMENT:0,COMPUTE:1,GLOBE:2,TERRAIN_CLASSIFICATION:3,CESIUM_3D_TILE:4,CESIUM_3D_TILE_CLASSIFICATION:5,CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW:6,S3MTiles:8,S3MTilesClampObjectStencil:9,S3MTilesClampObjectColor:10,ProjectionImage:11,OPAQUE:12,ClampObject:13,NonClampObject:14,Label_Billboard:15,Voxel_Billboard:16,Particle:17,TRANSLUCENT:18,ANALYSIS:19,LOG_DEPTH_OVERLAY:20,OVERLAY:21,OVERLAY_AGAINST_DEPTH:22,NUMBER_OF_PASSES:23},_t=Object.freeze(uDt)});function cDt(e){this.context=e,this.framebuffer=void 0,this.blendingEnabled=void 0,this.scissorTest=void 0,this.viewport=void 0}var Ha,vf=Ee(()=>{y(cDt,"PassState");Ha=cDt});var Jhe,ul,pg=Ee(()=>{co();Jhe={CLOCKWISE:Se.CW,COUNTER_CLOCKWISE:Se.CCW,NONE:Se.NONE,validate:function(e){return e===Jhe.CLOCKWISE||e===Jhe.COUNTER_CLOCKWISE}},ul=Object.freeze(Jhe)});function Dze(e){if(typeof e!="object"||e===null)return e;for(var r,n=Object.keys(e),o=0;o<n.length;o++)r=n[o],e.hasOwnProperty(r)&&r!=="_applyFunctions"&&(e[r]=Dze(e[r]));return Object.freeze(e)}var oQ,$he=Ee(()=>{y(Dze,"freezeRenderState");oQ=Dze});function Mze(e){return e===Se.FUNC_ADD||e===Se.FUNC_SUBTRACT||e===Se.FUNC_REVERSE_SUBTRACT||e===Se.MIN||e===Se.MAX}function aQ(e){return e===Se.ZERO||e===Se.ONE||e===Se.SRC_COLOR||e===Se.ONE_MINUS_SRC_COLOR||e===Se.DST_COLOR||e===Se.ONE_MINUS_DST_COLOR||e===Se.SRC_ALPHA||e===Se.ONE_MINUS_SRC_ALPHA||e===Se.DST_ALPHA||e===Se.ONE_MINUS_DST_ALPHA||e===Se.CONSTANT_COLOR||e===Se.ONE_MINUS_CONSTANT_COLOR||e===Se.CONSTANT_ALPHA||e===Se.ONE_MINUS_CONSTANT_ALPHA||e===Se.SRC_ALPHA_SATURATE}function xDt(e){return e===Se.FRONT||e===Se.BACK||e===Se.FRONT_AND_BACK}function hDt(e){return e===Se.NEVER||e===Se.LESS||e===Se.EQUAL||e===Se.LEQUAL||e===Se.GREATER||e===Se.NOTEQUAL||e===Se.GEQUAL||e===Se.ALWAYS}function Bze(e){return e===Se.NEVER||e===Se.LESS||e===Se.EQUAL||e===Se.LEQUAL||e===Se.GREATER||e===Se.NOTEQUAL||e===Se.GEQUAL||e===Se.ALWAYS}function zF(e){return e===Se.ZERO||e===Se.KEEP||e===Se.REPLACE||e===Se.INCR||e===Se.DECR||e===Se.INVERT||e===Se.INCR_WRAP||e===Se.DECR_WRAP}function FC(e){var r=B(e,{}),n=B(r.cull,{}),o=B(r.polygonOffset,{}),a=B(r.scissorTest,{}),s=B(a.rectangle,{}),l=B(r.depthRange,{}),h=B(r.depthTest,{}),x=B(r.colorMask,{}),m=B(r.blending,{}),v=B(m.color,{}),_=B(r.stencilTest,{}),A=B(_.frontOperation,{}),T=B(_.backOperation,{}),w=B(r.sampleCoverage,{}),S=r.viewport;if(this.frontFace=B(r.frontFace,ul.COUNTER_CLOCKWISE),this.cull={enabled:B(n.enabled,!1),face:B(n.face,Se.BACK)},this.lineWidth=B(r.lineWidth,1),this.polygonOffset={enabled:B(o.enabled,!1),factor:B(o.factor,0),units:B(o.units,0)},this.scissorTest={enabled:B(a.enabled,!1),rectangle:Ft.clone(s)},this.depthRange={near:B(l.near,0),far:B(l.far,1)},this.depthTest={enabled:B(h.enabled,!1),func:B(h.func,Se.LESS)},this.colorMask={red:B(x.red,!0),green:B(x.green,!0),blue:B(x.blue,!0),alpha:B(x.alpha,!0)},this.depthMask=B(r.depthMask,!0),this.stencilMask=B(r.stencilMask,-1),this.blending={enabled:B(m.enabled,!1),color:new se(B(v.red,0),B(v.green,0),B(v.blue,0),B(v.alpha,0)),equationRgb:B(m.equationRgb,Se.FUNC_ADD),equationAlpha:B(m.equationAlpha,Se.FUNC_ADD),functionSourceRgb:B(m.functionSourceRgb,Se.ONE),functionSourceAlpha:B(m.functionSourceAlpha,Se.ONE),functionDestinationRgb:B(m.functionDestinationRgb,Se.ZERO),functionDestinationAlpha:B(m.functionDestinationAlpha,Se.ZERO)},this.stencilTest={enabled:B(_.enabled,!1),frontFunction:B(_.frontFunction,Se.ALWAYS),backFunction:B(_.backFunction,Se.ALWAYS),reference:B(_.reference,0),mask:B(_.mask,-1),frontOperation:{fail:B(A.fail,Se.KEEP),zFail:B(A.zFail,Se.KEEP),zPass:B(A.zPass,Se.KEEP)},backOperation:{fail:B(T.fail,Se.KEEP),zFail:B(T.zFail,Se.KEEP),zPass:B(T.zPass,Se.KEEP)}},this.sampleCoverage={enabled:B(w.enabled,!1),value:B(w.value,1),invert:B(w.invert,!1)},this.viewport=p(S)?new Ft(S.x,S.y,S.width,S.height):void 0,this.lineWidth<fi.minimumAliasedLineWidth||this.lineWidth>fi.maximumAliasedLineWidth)throw new G("renderState.lineWidth is out of range.  Check minimumAliasedLineWidth and maximumAliasedLineWidth.");if(!ul.validate(this.frontFace))throw new G("Invalid renderState.frontFace.");if(!xDt(this.cull.face))throw new G("Invalid renderState.cull.face.");if(this.scissorTest.rectangle.width<0||this.scissorTest.rectangle.height<0)throw new G("renderState.scissorTest.rectangle.width and renderState.scissorTest.rectangle.height must be greater than or equal to zero.");if(this.depthRange.near>this.depthRange.far)throw new G("renderState.depthRange.near can not be greater than renderState.depthRange.far.");if(this.depthRange.near<0)throw new G("renderState.depthRange.near must be greater than or equal to zero.");if(this.depthRange.far>1)throw new G("renderState.depthRange.far must be less than or equal to one.");if(!hDt(this.depthTest.func))throw new G("Invalid renderState.depthTest.func.");if(this.blending.color.red<0||this.blending.color.red>1||this.blending.color.green<0||this.blending.color.green>1||this.blending.color.blue<0||this.blending.color.blue>1||this.blending.color.alpha<0||this.blending.color.alpha>1)throw new G("renderState.blending.color components must be greater than or equal to zero and less than or equal to one.");if(!Mze(this.blending.equationRgb))throw new G("Invalid renderState.blending.equationRgb.");if(!Mze(this.blending.equationAlpha))throw new G("Invalid renderState.blending.equationAlpha.");if(!aQ(this.blending.functionSourceRgb))throw new G("Invalid renderState.blending.functionSourceRgb.");if(!aQ(this.blending.functionSourceAlpha))throw new G("Invalid renderState.blending.functionSourceAlpha.");if(!aQ(this.blending.functionDestinationRgb))throw new G("Invalid renderState.blending.functionDestinationRgb.");if(!aQ(this.blending.functionDestinationAlpha))throw new G("Invalid renderState.blending.functionDestinationAlpha.");if(!Bze(this.stencilTest.frontFunction))throw new G("Invalid renderState.stencilTest.frontFunction.");if(!Bze(this.stencilTest.backFunction))throw new G("Invalid renderState.stencilTest.backFunction.");if(!zF(this.stencilTest.frontOperation.fail))throw new G("Invalid renderState.stencilTest.frontOperation.fail.");if(!zF(this.stencilTest.frontOperation.zFail))throw new G("Invalid renderState.stencilTest.frontOperation.zFail.");if(!zF(this.stencilTest.frontOperation.zPass))throw new G("Invalid renderState.stencilTest.frontOperation.zPass.");if(!zF(this.stencilTest.backOperation.fail))throw new G("Invalid renderState.stencilTest.backOperation.fail.");if(!zF(this.stencilTest.backOperation.zFail))throw new G("Invalid renderState.stencilTest.backOperation.zFail.");if(!zF(this.stencilTest.backOperation.zPass))throw new G("Invalid renderState.stencilTest.backOperation.zPass.");if(p(this.viewport)){if(this.viewport.width<0)throw new G("renderState.viewport.width must be greater than or equal to zero.");if(this.viewport.height<0)throw new G("renderState.viewport.height must be greater than or equal to zero.");if(this.viewport.width>fi.maximumViewportWidth)throw new G("renderState.viewport.width must be less than or equal to the maximum viewport width ("+fi.maximumViewportWidth.toString()+").  Check maximumViewportWidth.");if(this.viewport.height>fi.maximumViewportHeight)throw new G("renderState.viewport.height must be less than or equal to the maximum viewport height ("+fi.maximumViewportHeight.toString()+").  Check maximumViewportHeight.")}this.id=0,this._applyFunctions=[]}function JM(e,r,n){n?e.enable(r):e.disable(r)}function Rze(e,r){e.frontFace(r.frontFace)}function Lze(e,r){var n=r.cull,o=n.enabled;JM(e,e.CULL_FACE,o),o&&e.cullFace(n.face)}function Oze(e,r){e.lineWidth(r.lineWidth)}function Fze(e,r){var n=r.polygonOffset,o=n.enabled;JM(e,e.POLYGON_OFFSET_FILL,o),o&&e.polygonOffset(n.factor,n.units)}function Nze(e,r,n){var o=r.scissorTest,a=p(n.scissorTest)?n.scissorTest.enabled:o.enabled;if(JM(e,e.SCISSOR_TEST,a),a){var s=p(n.scissorTest)?n.scissorTest.rectangle:o.rectangle;e.scissor(s.x,s.y,s.width,s.height)}}function zze(e,r){var n=r.depthRange;e.depthRange(n.near,n.far)}function Vze(e,r){var n=r.depthTest,o=n.enabled;JM(e,e.DEPTH_TEST,o),o&&e.depthFunc(n.func)}function kze(e,r){var n=r.colorMask;e.colorMask(n.red,n.green,n.blue,n.alpha)}function Uze(e,r){e.depthMask(r.depthMask)}function Gze(e,r){e.stencilMask(r.stencilMask)}function mDt(e,r){e.blendColor(r.red,r.green,r.blue,r.alpha)}function Hze(e,r,n){var o=r.blending,a=p(n.blendingEnabled)?n.blendingEnabled:o.enabled;JM(e,e.BLEND,a),a&&(mDt(e,o.color),e.blendEquationSeparate(o.equationRgb,o.equationAlpha),e.blendFuncSeparate(o.functionSourceRgb,o.functionDestinationRgb,o.functionSourceAlpha,o.functionDestinationAlpha))}function Wze(e,r){var n=r.stencilTest,o=n.enabled;if(JM(e,e.STENCIL_TEST,o),o){var a=n.frontFunction,s=n.backFunction,l=n.reference,h=n.mask;e.stencilFunc(a,l,h),e.stencilFuncSeparate(e.BACK,s,l,h),e.stencilFuncSeparate(e.FRONT,a,l,h);var x=n.frontOperation,m=x.fail,v=x.zFail,_=x.zPass;e.stencilOpSeparate(e.FRONT,m,v,_);var A=n.backOperation,T=A.fail,w=A.zFail,S=A.zPass;e.stencilOpSeparate(e.BACK,T,w,S)}}function qze(e,r){var n=r.sampleCoverage,o=n.enabled;JM(e,e.SAMPLE_COVERAGE,o),o&&e.sampleCoverage(n.value,n.invert)}function jze(e,r,n){var o=B(r.viewport,n.viewport);p(o)||(o=pDt,o.width=n.context.drawingBufferWidth,o.height=n.context.drawingBufferHeight),n.context.uniformState.viewport=o,e.viewport(o.x,o.y,o.width,o.height)}function vDt(e,r){var n=[];return e.frontFace!==r.frontFace&&n.push(Rze),(e.cull.enabled!==r.cull.enabled||e.cull.face!==r.cull.face)&&n.push(Lze),e.lineWidth!==r.lineWidth&&n.push(Oze),(e.polygonOffset.enabled!==r.polygonOffset.enabled||e.polygonOffset.factor!==r.polygonOffset.factor||e.polygonOffset.units!==r.polygonOffset.units)&&n.push(Fze),(e.depthRange.near!==r.depthRange.near||e.depthRange.far!==r.depthRange.far)&&n.push(zze),(e.depthTest.enabled!==r.depthTest.enabled||e.depthTest.func!==r.depthTest.func)&&n.push(Vze),(e.colorMask.red!==r.colorMask.red||e.colorMask.green!==r.colorMask.green||e.colorMask.blue!==r.colorMask.blue||e.colorMask.alpha!==r.colorMask.alpha)&&n.push(kze),e.depthMask!==r.depthMask&&n.push(Uze),e.stencilMask!==r.stencilMask&&n.push(Gze),(e.stencilTest.enabled!==r.stencilTest.enabled||e.stencilTest.frontFunction!==r.stencilTest.frontFunction||e.stencilTest.backFunction!==r.stencilTest.backFunction||e.stencilTest.reference!==r.stencilTest.reference||e.stencilTest.mask!==r.stencilTest.mask||e.stencilTest.frontOperation.fail!==r.stencilTest.frontOperation.fail||e.stencilTest.frontOperation.zFail!==r.stencilTest.frontOperation.zFail||e.stencilTest.backOperation.fail!==r.stencilTest.backOperation.fail||e.stencilTest.backOperation.zFail!==r.stencilTest.backOperation.zFail||e.stencilTest.backOperation.zPass!==r.stencilTest.backOperation.zPass)&&n.push(Wze),(e.sampleCoverage.enabled!==r.sampleCoverage.enabled||e.sampleCoverage.value!==r.sampleCoverage.value||e.sampleCoverage.invert!==r.sampleCoverage.invert)&&n.push(qze),n}var dDt,OC,pDt,Et,Zi=Ee(()=>{vo();Ar();Ze();De();st();co();pg();Pl();$he();y(Mze,"validateBlendEquation");y(aQ,"validateBlendFunction");y(xDt,"validateCullFace");y(hDt,"validateDepthFunction");y(Bze,"validateStencilFunction");y(zF,"validateStencilOperation");y(FC,"RenderState");dDt=0,OC={};FC.fromCache=function(e){var r=JSON.stringify(e),n=OC[r];if(p(n))return++n.referenceCount,n.state;var o=new FC(e),a=JSON.stringify(o);return n=OC[a],p(n)||(o.id=dDt++,o=oQ(o),n={referenceCount:0,state:o},OC[a]=n),++n.referenceCount,OC[r]={referenceCount:1,state:n.state},n.state};FC.removeFromCache=function(e){var r=new FC(e),n=JSON.stringify(r),o=OC[n],a=JSON.stringify(e),s=OC[a];p(s)&&(--s.referenceCount,s.referenceCount===0&&(delete OC[a],p(o)&&--o.referenceCount)),p(o)&&o.referenceCount===0&&delete OC[n]};FC.getCache=function(){return OC};FC.clearCache=function(){OC={}};y(JM,"enableOrDisable");y(Rze,"applyFrontFace");y(Lze,"applyCull");y(Oze,"applyLineWidth");y(Fze,"applyPolygonOffset");y(Nze,"applyScissorTest");y(zze,"applyDepthRange");y(Vze,"applyDepthTest");y(kze,"applyColorMask");y(Uze,"applyDepthMask");y(Gze,"applyStencilMask");y(mDt,"applyBlendingColor");y(Hze,"applyBlending");y(Wze,"applyStencilTest");y(qze,"applySampleCoverage");pDt=new Ft;y(jze,"applyViewport");FC.apply=function(e,r,n){Rze(e,r),Lze(e,r),Oze(e,r),Fze(e,r),zze(e,r),Vze(e,r),kze(e,r),Uze(e,r),Gze(e,r),Wze(e,r),qze(e,r),Nze(e,r,n),Hze(e,r,n),jze(e,r,n)};y(vDt,"createFuncs");FC.partialApply=function(e,r,n,o,a,s,l,h){if(r!==n){var x=n._applyFunctions[r.id];p(x)||(x=vDt(r,n),n._applyFunctions[r.id]=x);for(var m=x.length,v=0;v<m;++v)x[v](e,n)}var _=p(o.scissorTest)?o.scissorTest:r.scissorTest,A=p(a.scissorTest)?a.scissorTest:n.scissorTest;(_!==A||h)&&Nze(e,n,a);var T=p(o.blendingEnabled)?o.blendingEnabled:r.blending.enabled,w=p(a.blendingEnabled)?a.blendingEnabled:n.blending.enabled;(T!==w||w&&r.blending!==n.blending)&&Hze(e,n,a),(r!==n||o!==a||o.context!==a.context||s!==l)&&jze(e,n,a)};FC.getState=function(e){if(!p(e))throw new G("renderState is required.");return{frontFace:e.frontFace,cull:{enabled:e.cull.enabled,face:e.cull.face},lineWidth:e.lineWidth,polygonOffset:{enabled:e.polygonOffset.enabled,factor:e.polygonOffset.factor,units:e.polygonOffset.units},scissorTest:{enabled:e.scissorTest.enabled,rectangle:Ft.clone(e.scissorTest.rectangle)},depthRange:{near:e.depthRange.near,far:e.depthRange.far},depthTest:{enabled:e.depthTest.enabled,func:e.depthTest.func},colorMask:{red:e.colorMask.red,green:e.colorMask.green,blue:e.colorMask.blue,alpha:e.colorMask.alpha},depthMask:e.depthMask,stencilMask:e.stencilMask,blending:{enabled:e.blending.enabled,color:se.clone(e.blending.color),equationRgb:e.blending.equationRgb,equationAlpha:e.blending.equationAlpha,functionSourceRgb:e.blending.functionSourceRgb,functionSourceAlpha:e.blending.functionSourceAlpha,functionDestinationRgb:e.blending.functionDestinationRgb,functionDestinationAlpha:e.blending.functionDestinationAlpha},stencilTest:{enabled:e.stencilTest.enabled,frontFunction:e.stencilTest.frontFunction,backFunction:e.stencilTest.backFunction,reference:e.stencilTest.reference,mask:e.stencilTest.mask,frontOperation:{fail:e.stencilTest.frontOperation.fail,zFail:e.stencilTest.frontOperation.zFail,zPass:e.stencilTest.frontOperation.zPass},backOperation:{fail:e.stencilTest.backOperation.fail,zFail:e.stencilTest.backOperation.zFail,zPass:e.stencilTest.backOperation.zPass}},sampleCoverage:{enabled:e.sampleCoverage.enabled,value:e.sampleCoverage.value,invert:e.sampleCoverage.invert},viewport:p(e.viewport)?Ft.clone(e.viewport):void 0}};Et=FC});function gDt(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,function(e){var r=Math.random()*16|0,n=e==="x"?r:r&3|8;return n.toString(16)})}var $n,Dl=Ee(()=>{y(gDt,"createGuid");$n=gDt});function vg(e){e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context);let r=e.context,n=e.width,o=e.height,a=e.source;p(a)&&(p(n)||(n=B(a.videoWidth,a.width)),p(o)||(o=B(a.videoHeight,a.height)));let s=B(e.pixelFormat,pt.RGBA),l=B(e.pixelDatatype,Gt.UNSIGNED_BYTE),h=pt.toInternalFormat(s,l,r),x=pt.isCompressedFormat(h);if(!p(n)||!p(o))throw new G("options requires a source field to create an initialized texture or width and height fields to create a blank texture.");if(X.typeOf.number.greaterThan("width",n,0),n>fi.maximumTextureSize)throw new G(`Width must be less than or equal to the maximum texture size (${fi.maximumTextureSize}).  Check maximumTextureSize.`);if(X.typeOf.number.greaterThan("height",o,0),o>fi.maximumTextureSize)throw new G(`Height must be less than or equal to the maximum texture size (${fi.maximumTextureSize}).  Check maximumTextureSize.`);if(!pt.validate(s))throw new G("Invalid options.pixelFormat.");if(!x&&!Gt.validate(l))throw new G("Invalid options.pixelDatatype.");if(s===pt.DEPTH_COMPONENT&&l!==Gt.UNSIGNED_SHORT&&l!==Gt.UNSIGNED_INT)throw new G("When options.pixelFormat is DEPTH_COMPONENT, options.pixelDatatype must be UNSIGNED_SHORT or UNSIGNED_INT.");if(s===pt.DEPTH_STENCIL&&l!==Gt.UNSIGNED_INT_24_8)throw new G("When options.pixelFormat is DEPTH_STENCIL, options.pixelDatatype must be UNSIGNED_INT_24_8.");if(l===Gt.FLOAT&&!r.floatingPointTexture)throw new G("When options.pixelDatatype is FLOAT, this WebGL implementation must support the OES_texture_float extension.  Check context.floatingPointTexture.");if(l===Gt.HALF_FLOAT&&!r.halfFloatingPointTexture)throw new G("When options.pixelDatatype is HALF_FLOAT, this WebGL implementation must support the OES_texture_half_float extension. Check context.halfFloatingPointTexture.");if(pt.isDepthFormat(s)){if(p(a))throw new G("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, source cannot be provided.");if(!r.depthTexture)throw new G("When options.pixelFormat is DEPTH_COMPONENT or DEPTH_STENCIL, this WebGL implementation must support WEBGL_depth_texture.  Check context.depthTexture.")}if(x){if(!p(a)||!p(a.arrayBufferView))throw new G("When options.pixelFormat is compressed, options.source.arrayBufferView must be defined.");if(pt.isDXTFormat(h)&&!r.s3tc)throw new G("When options.pixelFormat is S3TC compressed, this WebGL implementation must support the WEBGL_compressed_texture_s3tc extension. Check context.s3tc.");if(pt.isPVRTCFormat(h)&&!r.pvrtc)throw new G("When options.pixelFormat is PVRTC compressed, this WebGL implementation must support the WEBGL_compressed_texture_pvrtc extension. Check context.pvrtc.");if(pt.isASTCFormat(h)&&!r.astc)throw new G("When options.pixelFormat is ASTC compressed, this WebGL implementation must support the WEBGL_compressed_texture_astc extension. Check context.astc.");if(pt.isETC2Format(h)&&!r.etc)throw new G("When options.pixelFormat is ETC2 compressed, this WebGL implementation must support the WEBGL_compressed_texture_etc extension. Check context.etc.");if(pt.isETC1Format(h)&&!r.etc1)throw new G("When options.pixelFormat is ETC1 compressed, this WebGL implementation must support the WEBGL_compressed_texture_etc1 extension. Check context.etc1.");if(pt.isBC7Format(h)&&!r.bc7)throw new G("When options.pixelFormat is BC7 compressed, this WebGL implementation must support the EXT_texture_compression_bptc extension. Check context.bc7.");if(pt.compressedTextureSizeInBytes(h,n,o)!==a.arrayBufferView.byteLength)throw new G("The byte length of the array buffer is invalid for the compressed texture with the given width and height.")}let m=e.preMultiplyAlpha||s===pt.RGB||s===pt.LUMINANCE,v=B(e.flipY,!0),_=B(e.skipColorSpaceConversion,!1),A=!0,T=r._gl,w=T.TEXTURE_2D,S=T.createTexture();T.activeTexture(T.TEXTURE0),T.bindTexture(w,S);let P=4;if(p(a)&&p(a.arrayBufferView)&&!x&&(P=pt.alignmentInBytes(s,l,n)),T.pixelStorei(T.UNPACK_ALIGNMENT,P),_?T.pixelStorei(T.UNPACK_COLORSPACE_CONVERSION_WEBGL,T.NONE):T.pixelStorei(T.UNPACK_COLORSPACE_CONVERSION_WEBGL,T.BROWSER_DEFAULT_WEBGL),p(a))if(p(a.arrayBufferView)){T.pixelStorei(T.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),T.pixelStorei(T.UNPACK_FLIP_Y_WEBGL,!1);let O=a.arrayBufferView,N,k,z;if(x){if(T.compressedTexImage2D(w,0,h,n,o,0,O),p(a.mipLevels))for(k=n,z=o,N=0;N<a.mipLevels.length;++N)k=Math.floor(k/2)|0,k<1&&(k=1),z=Math.floor(z/2)|0,z<1&&(z=1),T.compressedTexImage2D(w,N+1,h,k,z,0,a.mipLevels[N])}else if(v&&(O=pt.flipY(O,s,l,n,o)),T.texImage2D(w,0,h,n,o,0,s,Gt.toWebGLConstant(l,r),O),p(a.mipLevels))for(k=n,z=o,N=0;N<a.mipLevels.length;++N)k=Math.floor(k/2)|0,k<1&&(k=1),z=Math.floor(z/2)|0,z<1&&(z=1),T.texImage2D(w,N+1,h,k,z,0,s,Gt.toWebGLConstant(l,r),a.mipLevels[N])}else if(p(a.framebuffer))T.pixelStorei(T.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),T.pixelStorei(T.UNPACK_FLIP_Y_WEBGL,!1),a.framebuffer!==r.defaultFramebuffer&&a.framebuffer._bind(),T.copyTexImage2D(w,0,h,a.xOffset,a.yOffset,n,o,0),a.framebuffer!==r.defaultFramebuffer&&a.framebuffer._unBind();else{T.pixelStorei(T.UNPACK_PREMULTIPLY_ALPHA_WEBGL,m),T.pixelStorei(T.UNPACK_FLIP_Y_WEBGL,v),T.texImage2D(w,0,h,s,Gt.toWebGLConstant(l,r),a);let O=e.mipLevels;if(p(O))for(var M=0,L=O.length;M<L;++M)T.texImage2D(w,M+1,h,s,Gt.toWebGLConstant(l,r),O[M])}else T.texImage2D(w,0,h,n,o,0,s,Gt.toWebGLConstant(l,r),null),A=!1;T.bindTexture(w,null);let R;x?R=pt.compressedTextureSizeInBytes(s,n,o):R=pt.textureSizeInBytes(s,l,n,o),this._id=$n(),this._context=r,this._textureFilterAnisotropic=r._textureFilterAnisotropic,this._textureTarget=w,this._texture=S,this._internalFormat=h,this._pixelFormat=s,this._pixelDatatype=l,this._width=n,this._height=o,this._dimensions=new de(n,o),this._hasMipmap=!1,this._sizeInBytes=R,this._preMultiplyAlpha=m,this._flipY=v,this._initialized=A,this._sampler=void 0,this._samples=B(e.samples,1),this.sampler=p(e.sampler)?e.sampler:new Yr,r.memorySize+=R}var Vt,yn=Ee(()=>{Fr();cr();Dl();Ze();De();ur();st();nr();Mn();Pl();RC();go();ra();Ia();pa();y(vg,"Texture");vg.create=function(e){return new vg(e)};vg.fromFramebuffer=function(e){e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context);let r=e.context,n=r._gl,o=B(e.pixelFormat,pt.RGB),a=B(e.framebufferXOffset,0),s=B(e.framebufferYOffset,0),l=B(e.width,n.drawingBufferWidth),h=B(e.height,n.drawingBufferHeight),x=e.framebuffer;if(!pt.validate(o))throw new G("Invalid pixelFormat.");if(pt.isDepthFormat(o)||pt.isCompressedFormat(o))throw new G("pixelFormat cannot be DEPTH_COMPONENT, DEPTH_STENCIL or a compressed format.");if(X.defined("options.context",e.context),X.typeOf.number.greaterThanOrEquals("framebufferXOffset",a,0),X.typeOf.number.greaterThanOrEquals("framebufferYOffset",s,0),a+l>n.drawingBufferWidth)throw new G("framebufferXOffset + width must be less than or equal to drawingBufferWidth");if(s+h>n.drawingBufferHeight)throw new G("framebufferYOffset + height must be less than or equal to drawingBufferHeight.");return new vg({context:r,width:l,height:h,pixelFormat:o,source:{framebuffer:p(x)?x:r.defaultFramebuffer,xOffset:a,yOffset:s,width:l,height:h}})};Object.defineProperties(vg.prototype,{id:{get:function(){return this._id},set:function(e){this._id=e}},is3D:{get:function(){return!1}},is2DArray:{get:function(){return!1}},sampler:{get:function(){return this._sampler},set:function(e){let r=e.minificationFilter,n=e.magnificationFilter,o=this._context,a=this._pixelFormat,s=this._pixelDatatype,l=r===Dr.NEAREST_MIPMAP_NEAREST||r===Dr.NEAREST_MIPMAP_LINEAR||r===Dr.LINEAR_MIPMAP_NEAREST||r===Dr.LINEAR_MIPMAP_LINEAR;(s===Gt.FLOAT&&!o.textureFloatLinear||s===Gt.HALF_FLOAT&&!o.textureHalfFloatLinear)&&(r=l?Dr.NEAREST_MIPMAP_NEAREST:Dr.NEAREST,n=xi.NEAREST),o.webgl2&&pt.isDepthFormat(a)&&(r=Dr.NEAREST,n=xi.NEAREST);let h=o._gl,x=this._textureTarget;h.activeTexture(h.TEXTURE0),h.bindTexture(x,this._texture),h.texParameteri(x,h.TEXTURE_MIN_FILTER,r),h.texParameteri(x,h.TEXTURE_MAG_FILTER,n),h.texParameteri(x,h.TEXTURE_WRAP_S,e.wrapS),h.texParameteri(x,h.TEXTURE_WRAP_T,e.wrapT),p(this._textureFilterAnisotropic)&&h.texParameteri(x,this._textureFilterAnisotropic.TEXTURE_MAX_ANISOTROPY_EXT,e.maximumAnisotropy),h.bindTexture(x,null),this._sampler=e}},pixelFormat:{get:function(){return this._pixelFormat}},pixelDatatype:{get:function(){return this._pixelDatatype}},dimensions:{get:function(){return this._dimensions}},preMultiplyAlpha:{get:function(){return this._preMultiplyAlpha}},flipY:{get:function(){return this._flipY}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},sizeInBytes:{get:function(){return this._hasMipmap?Math.floor(this._sizeInBytes*4/3):this._sizeInBytes}},_target:{get:function(){return this._textureTarget}},samples:{get:function(){return this._samples}}});vg.prototype.copyFrom=function(e,r,n){if(r=B(r,0),n=B(n,0),X.defined("source",e),pt.isDepthFormat(this._pixelFormat))throw new G("Cannot call copyFrom when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(pt.isCompressedFormat(this._pixelFormat))throw new G("Cannot call copyFrom with a compressed texture pixel format.");X.typeOf.number.greaterThanOrEquals("xOffset",r,0),X.typeOf.number.greaterThanOrEquals("yOffset",n,0),X.typeOf.number.lessThanOrEquals("xOffset + source.width",r+e.width,this._width),X.typeOf.number.lessThanOrEquals("yOffset + source.height",n+e.height,this._height);let o=this._context;var a=o._gl,s=this._textureTarget;a.activeTexture(a.TEXTURE0),a.bindTexture(s,this._texture);var l=e.width,h=e.height,x=e.arrayBufferView,m=this._width,v=this._height,_=this._pixelFormat,A=this._pixelDatatype;let T=this._internalFormat;var w=this._preMultiplyAlpha,S=this._flipY;let P=!1;var M=4;p(x)&&(M=pt.alignmentInBytes(_,A,l)),a.pixelStorei(a.UNPACK_ALIGNMENT,M),P?a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.NONE):a.pixelStorei(a.UNPACK_COLORSPACE_CONVERSION_WEBGL,a.BROWSER_DEFAULT_WEBGL);var L=!1;if(!this._initialized){if(r===0&&n===0&&l===m&&h===v)p(x)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),S&&(x=pt.flipY(x,_,A,m,v)),a.texImage2D(s,0,T,m,v,0,_,Gt.toWebGLConstant(A,o),x)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,w),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,S),a.texImage2D(s,0,T,_,Gt.toWebGLConstant(A,o),e)),L=!0;else{a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1);var R=pt.createTypedArray(_,A,m,v);a.texImage2D(s,0,T,m,v,0,_,Gt.toWebGLConstant(A,o),R)}this._initialized=!0}L||(p(x)?(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,!1),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,!1),S&&(x=pt.flipY(x,_,A,l,h)),a.texSubImage2D(s,0,r,n,l,h,_,Gt.toWebGLConstant(A,o),x)):(a.pixelStorei(a.UNPACK_PREMULTIPLY_ALPHA_WEBGL,w),a.pixelStorei(a.UNPACK_FLIP_Y_WEBGL,S),a.texSubImage2D(s,0,r,n,_,Gt.toWebGLConstant(A,o),e))),a.bindTexture(s,null)};vg.prototype.copyFromFramebuffer=function(e,r,n,o,a,s){if(e=B(e,0),r=B(r,0),n=B(n,0),o=B(o,0),a=B(a,this._width),s=B(s,this._height),pt.isDepthFormat(this._pixelFormat))throw new G("Cannot call copyFromFramebuffer when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(this._pixelDatatype===Gt.FLOAT)throw new G("Cannot call copyFromFramebuffer when the texture pixel data type is FLOAT.");if(this._pixelDatatype===Gt.HALF_FLOAT)throw new G("Cannot call copyFromFramebuffer when the texture pixel data type is HALF_FLOAT.");if(pt.isCompressedFormat(this._pixelFormat))throw new G("Cannot call copyFrom with a compressed texture pixel format.");X.typeOf.number.greaterThanOrEquals("xOffset",e,0),X.typeOf.number.greaterThanOrEquals("yOffset",r,0),X.typeOf.number.greaterThanOrEquals("framebufferXOffset",n,0),X.typeOf.number.greaterThanOrEquals("framebufferYOffset",o,0),X.typeOf.number.lessThanOrEquals("xOffset + width",e+a,this._width),X.typeOf.number.lessThanOrEquals("yOffset + height",r+s,this._height);let l=this._context._gl,h=this._textureTarget;l.activeTexture(l.TEXTURE0),l.bindTexture(h,this._texture),l.copyTexSubImage2D(h,0,e,r,n,o,a,s),l.bindTexture(h,null),this._initialized=!0};vg.prototype.copyFromTexture=function(e,r,n,o,a,s,l){var h=this._context,x=new Framebuffer({context:h,colorTextures:[e],destroyAttachments:!1});if(x!==h._currentFramebuffer&&(h._currentFramebuffer=x,p(x))){x._bind();var m=x._getActiveColorAttachments();h.drawBuffers&&h.glDrawBuffers(m)}this.copyFromFramebuffer(r,n,o,a,s,l),x.destroy()};vg.prototype.generateMipmap=function(e){if(e=B(e,jc.DONT_CARE),pt.isDepthFormat(this._pixelFormat))throw new G("Cannot call generateMipmap when the texture pixel format is DEPTH_COMPONENT or DEPTH_STENCIL.");if(pt.isCompressedFormat(this._pixelFormat))throw new G("Cannot call generateMipmap with a compressed pixel format.");if(!this._context.webgl2){if(this._width>1&&!K.isPowerOfTwo(this._width))throw new G("width must be a power of two to call generateMipmap() in a WebGL1 context.");if(this._height>1&&!K.isPowerOfTwo(this._height))throw new G("height must be a power of two to call generateMipmap() in a WebGL1 context.")}if(!jc.validate(e))throw new G("hint is invalid.");this._hasMipmap=!0;let r=this._context._gl,n=this._textureTarget;r.hint(r.GENERATE_MIPMAP_HINT,e),r.activeTexture(r.TEXTURE0),r.bindTexture(n,this._texture),r.generateMipmap(n),r.bindTexture(n,null)};vg.prototype.isDestroyed=function(){return!1};vg.prototype.destroy=function(){return this._context._gl.deleteTexture(this._texture),this._context.memorySize-=this._sizeInBytes,$e(this)};Vt=vg});var bd,Vs,sQ=Ee(()=>{/**
@license
tween.js 

Copyright (c) 2010-2012 Tween.js authors.

Easing equations Copyright (c) 2001 Robert Penner

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/Date.now===void 0&&(Date.now=function(){return new Date().valueOf()});bd=bd||function(){var e=[];return{REVISION:"13",getAll:function(){return e},removeAll:function(){e=[]},add:function(r){e.push(r)},remove:function(r){var n=e.indexOf(r);n!==-1&&e.splice(n,1)},update:function(r){if(e.length===0)return!1;var n=0;for(r=r!==void 0?r:typeof window<"u"&&window.performance!==void 0&&window.performance.now!==void 0?window.performance.now():Date.now();n<e.length;)e[n].update(r)?n++:e.splice(n,1);return!0}}}();bd.Tween=function(e){var r=e,n={},o={},a={},s=1e3,l=0,h=!1,x=!1,m=!1,v=0,_=null,A=bd.Easing.Linear.None,T=bd.Interpolation.Linear,w=[],S=null,P=!1,M=null,L=null,R=null,O=0,N=0;for(var k in e)n[k]=parseFloat(e[k],10);this.to=function(z,W){return W!==void 0&&(s=W),o=z,this},this.start=function(z){bd.add(this),x=!0,P=!1,_=z!==void 0?z:typeof window<"u"&&window.performance!==void 0&&window.performance.now!==void 0?window.performance.now():Date.now(),_+=v;for(var W in o){if(o[W]instanceof Array){if(o[W].length===0)continue;o[W]=[r[W]].concat(o[W])}n[W]=r[W],n[W]instanceof Array||(n[W]*=1),a[W]=n[W]||0}return this},this.stop=function(){return x?(bd.remove(this),x=!1,R!==null&&R.call(r),this.stopChainedTweens(),this):this},this.pause=function(){return x?(x=!1,O=typeof window<"u"&&window.performance!==void 0&&window.performance.now!==void 0?window.performance.now():Date.now(),this):this},this.endPause=function(){return x?this:(x=!0,O=(typeof window<"u"&&window.performance!==void 0&&window.performance.now!==void 0?window.performance.now():Date.now())-O,N+=O,this)},this.stopChainedTweens=function(){for(var z=0,W=w.length;z<W;z++)w[z].stop()},this.delay=function(z){return v=z,this},this.repeat=function(z){return l=z,this},this.yoyo=function(z){return h=z,this},this.easing=function(z){return A=z,this},this.interpolation=function(z){return T=z,this},this.chain=function(){return w=arguments,this},this.onStart=function(z){return S=z,this},this.onUpdate=function(z){return M=z,this},this.onComplete=function(z){return L=z,this},this.onStop=function(z){return R=z,this},this.update=function(z){var W;if(z<_||!x)return!0;P===!1&&(S!==null&&S.call(r),P=!0);var j=(z-_-N)/s;j=j>1?1:j;var q=A(j);for(W in o){var I=n[W]||0,F=o[W];F instanceof Array?r[W]=T(F,q):(typeof F=="string"&&(F=I+parseFloat(F,10)),typeof F=="number"&&(r[W]=I+(F-I)*q))}if(M!==null&&M.call(r,q),j==1)if(N=0,l>0){isFinite(l)&&l--;for(W in a){if(typeof o[W]=="string"&&(a[W]=a[W]+parseFloat(o[W],10)),h){var V=a[W];a[W]=o[W],o[W]=V}n[W]=a[W]}return h&&(m=!m),_=z+v,!0}else{L!==null&&L.call(r);for(var U=0,Q=w.length;U<Q;U++)w[U].start(z);return!1}return!0}};bd.Easing={Linear:{None:function(e){return e}},Quadratic:{In:function(e){return e*e},Out:function(e){return e*(2-e)},InOut:function(e){return(e*=2)<1?.5*e*e:-.5*(--e*(e-2)-1)}},Cubic:{In:function(e){return e*e*e},Out:function(e){return--e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e:.5*((e-=2)*e*e+2)}},Quartic:{In:function(e){return e*e*e*e},Out:function(e){return 1- --e*e*e*e},InOut:function(e){return(e*=2)<1?.5*e*e*e*e:-.5*((e-=2)*e*e*e-2)}},Quintic:{In:function(e){return e*e*e*e*e},Out:function(e){return--e*e*e*e*e+1},InOut:function(e){return(e*=2)<1?.5*e*e*e*e*e:.5*((e-=2)*e*e*e*e+2)}},Sinusoidal:{In:function(e){return 1-Math.cos(e*Math.PI/2)},Out:function(e){return Math.sin(e*Math.PI/2)},InOut:function(e){return .5*(1-Math.cos(Math.PI*e))}},Exponential:{In:function(e){return e===0?0:Math.pow(1024,e-1)},Out:function(e){return e===1?1:1-Math.pow(2,-10*e)},InOut:function(e){return e===0?0:e===1?1:(e*=2)<1?.5*Math.pow(1024,e-1):.5*(-Math.pow(2,-10*(e-1))+2)}},Circular:{In:function(e){return 1-Math.sqrt(1-e*e)},Out:function(e){return Math.sqrt(1- --e*e)},InOut:function(e){return(e*=2)<1?-.5*(Math.sqrt(1-e*e)-1):.5*(Math.sqrt(1-(e-=2)*e)+1)}},Elastic:{In:function(e){var r,n=.1,o=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,r=o/4):r=o*Math.asin(1/n)/(2*Math.PI),-(n*Math.pow(2,10*(e-=1))*Math.sin((e-r)*(2*Math.PI)/o)))},Out:function(e){var r,n=.1,o=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,r=o/4):r=o*Math.asin(1/n)/(2*Math.PI),n*Math.pow(2,-10*e)*Math.sin((e-r)*(2*Math.PI)/o)+1)},InOut:function(e){var r,n=.1,o=.4;return e===0?0:e===1?1:(!n||n<1?(n=1,r=o/4):r=o*Math.asin(1/n)/(2*Math.PI),(e*=2)<1?-.5*(n*Math.pow(2,10*(e-=1))*Math.sin((e-r)*(2*Math.PI)/o)):n*Math.pow(2,-10*(e-=1))*Math.sin((e-r)*(2*Math.PI)/o)*.5+1)}},Back:{In:function(e){var r=1.70158;return e*e*((r+1)*e-r)},Out:function(e){var r=1.70158;return--e*e*((r+1)*e+r)+1},InOut:function(e){var r=2.5949095;return(e*=2)<1?.5*(e*e*((r+1)*e-r)):.5*((e-=2)*e*((r+1)*e+r)+2)}},Bounce:{In:function(e){return 1-bd.Easing.Bounce.Out(1-e)},Out:function(e){return e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375},InOut:function(e){return e<.5?bd.Easing.Bounce.In(e*2)*.5:bd.Easing.Bounce.Out(e*2-1)*.5+.5}}};bd.Interpolation={Linear:function(e,r){var n=e.length-1,o=n*r,a=Math.floor(o),s=bd.Interpolation.Utils.Linear;return r<0?s(e[0],e[1],o):r>1?s(e[n],e[n-1],n-o):s(e[a],e[a+1>n?n:a+1],o-a)},Bezier:function(e,r){var n=0,o=e.length-1,a=Math.pow,s=bd.Interpolation.Utils.Bernstein,l;for(l=0;l<=o;l++)n+=a(1-r,o-l)*a(r,l)*e[l]*s(o,l);return n},CatmullRom:function(e,r){var n=e.length-1,o=n*r,a=Math.floor(o),s=bd.Interpolation.Utils.CatmullRom;return e[0]===e[n]?(r<0&&(a=Math.floor(o=n*(1+r))),s(e[(a-1+n)%n],e[a],e[(a+1)%n],e[(a+2)%n],o-a)):r<0?e[0]-(s(e[0],e[0],e[1],e[1],-o)-e[0]):r>1?e[n]-(s(e[n],e[n],e[n-1],e[n-1],o-n)-e[n]):s(e[a?a-1:0],e[a],e[n<a+1?n:a+1],e[n<a+2?n:a+2],o-a)},Utils:{Linear:function(e,r,n){return(r-e)*n+e},Bernstein:function(e,r){var n=bd.Interpolation.Utils.Factorial;return n(e)/n(r)/n(e-r)},Factorial:function(){var e=[1];return function(r){var n=1,o;if(e[r])return e[r];for(o=r;o>1;o--)n*=o;return e[r]=n}}(),CatmullRom:function(e,r,n,o,a){var s=(n-e)*.5,l=(o-r)*.5,h=a*a,x=a*h;return(2*r-2*n+s+l)*x+(-3*r+3*n-2*s-l)*h+s*a+r}}};Vs=bd});var _Dt,qu,NC=Ee(()=>{sQ();_Dt={LINEAR_NONE:Vs.Easing.Linear.None,QUADRACTIC_IN:Vs.Easing.Quadratic.In,QUADRACTIC_OUT:Vs.Easing.Quadratic.Out,QUADRACTIC_IN_OUT:Vs.Easing.Quadratic.InOut,CUBIC_IN:Vs.Easing.Cubic.In,CUBIC_OUT:Vs.Easing.Cubic.Out,CUBIC_IN_OUT:Vs.Easing.Cubic.InOut,QUARTIC_IN:Vs.Easing.Quartic.In,QUARTIC_OUT:Vs.Easing.Quartic.Out,QUARTIC_IN_OUT:Vs.Easing.Quartic.InOut,QUINTIC_IN:Vs.Easing.Quintic.In,QUINTIC_OUT:Vs.Easing.Quintic.Out,QUINTIC_IN_OUT:Vs.Easing.Quintic.InOut,SINUSOIDAL_IN:Vs.Easing.Sinusoidal.In,SINUSOIDAL_OUT:Vs.Easing.Sinusoidal.Out,SINUSOIDAL_IN_OUT:Vs.Easing.Sinusoidal.InOut,EXPONENTIAL_IN:Vs.Easing.Exponential.In,EXPONENTIAL_OUT:Vs.Easing.Exponential.Out,EXPONENTIAL_IN_OUT:Vs.Easing.Exponential.InOut,CIRCULAR_IN:Vs.Easing.Circular.In,CIRCULAR_OUT:Vs.Easing.Circular.Out,CIRCULAR_IN_OUT:Vs.Easing.Circular.InOut,ELASTIC_IN:Vs.Easing.Elastic.In,ELASTIC_OUT:Vs.Easing.Elastic.Out,ELASTIC_IN_OUT:Vs.Easing.Elastic.InOut,BACK_IN:Vs.Easing.Back.In,BACK_OUT:Vs.Easing.Back.Out,BACK_IN_OUT:Vs.Easing.Back.InOut,BOUNCE_IN:Vs.Easing.Bounce.In,BOUNCE_OUT:Vs.Easing.Bounce.Out,BOUNCE_IN_OUT:Vs.Easing.Bounce.InOut},qu=Object.freeze(_Dt)});function yDt(e){var r=e._uSquared,n=e._ellipsoid.maximumRadius,o=e._ellipsoid.minimumRadius,a=(n-o)/n,s=Math.cos(e._startHeading),l=Math.sin(e._startHeading),h=(1-a)*Math.tan(e._start.latitude),x=1/Math.sqrt(1+h*h),m=x*h,v=Math.atan2(h,s),_=x*l,A=_*_,T=1-A,w=Math.sqrt(T),S=r/4,P=S*S,M=P*S,L=P*P,R=1+S-3*P/4+5*M/4-175*L/64,O=1-S+15*P/8-35*M/8,N=1-3*S+35*P/4,k=1-5*S,z=R*v-O*Math.sin(2*v)*S/2-N*Math.sin(4*v)*P/16-k*Math.sin(6*v)*M/48-Math.sin(8*v)*5*L/512,W=e._constants;W.a=n,W.b=o,W.f=a,W.cosineHeading=s,W.sineHeading=l,W.tanU=h,W.cosineU=x,W.sineU=m,W.sigma=v,W.sineAlpha=_,W.sineSquaredAlpha=A,W.cosineSquaredAlpha=T,W.cosineAlpha=w,W.u2Over4=S,W.u4Over16=P,W.u6Over64=M,W.u8Over256=L,W.a0=R,W.a1=O,W.a2=N,W.a3=k,W.distanceRatio=z}function ADt(e,r){return e*r*(4+e*(4-3*r))/16}function Yze(e,r,n,o,a,s,l){var h=ADt(e,n);return(1-h)*e*r*(o+h*a*(l+h*s*(2*l*l-1)))}function CDt(e,r,n,o,a,s,l){var h=(r-n)/r,x=s-o,m=Math.atan((1-h)*Math.tan(a)),v=Math.atan((1-h)*Math.tan(l)),_=Math.cos(m),A=Math.sin(m),T=Math.cos(v),w=Math.sin(v),S=_*T,P=_*w,M=A*w,L=A*T,R=x,O=K.TWO_PI,N=Math.cos(R),k=Math.sin(R),z,W,j,q,I;do{N=Math.cos(R),k=Math.sin(R);var F=P-L*N;j=Math.sqrt(T*T*k*k+F*F),W=M+S*N,z=Math.atan2(j,W);var V;j===0?(V=0,q=1):(V=S*k/j,q=1-V*V),O=R,I=W-2*M/q,isNaN(I)&&(I=0),R=x+Yze(h,V,q,z,j,W,I)}while(Math.abs(R-O)>K.EPSILON12);var U=q*(r*r-n*n)/(n*n),Q=1+U*(4096+U*(U*(320-175*U)-768))/16384,J=U*(256+U*(U*(74-47*U)-128))/1024,oe=I*I,$=J*j*(I+J*(W*(2*oe-1)-J*I*(4*j*j-3)*(4*oe-3)/6)/4),re=n*Q*(z-$),ne=Math.atan2(T*k,P-L*N),le=Math.atan2(_*k,P*N-L);e._distance=re,e._startHeading=ne,e._endHeading=le,e._uSquared=U}function Qze(e,r,n,o){var a=E.normalize(o.cartographicToCartesian(r,ede),TDt),s=E.normalize(o.cartographicToCartesian(n,ede),ede);X.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(E.angleBetween(a,s))-Math.PI),.0125),CDt(e,o.maximumRadius,o.minimumRadius,r.longitude,r.latitude,n.longitude,n.latitude),e._start=qe.clone(r,e._start),e._end=qe.clone(n,e._end),e._start.height=0,e._end.height=0,yDt(e)}function EH(e,r,n){var o=B(n,nt.WGS84);this._ellipsoid=o,this._start=new qe,this._end=new qe,this._constants={},this._startHeading=void 0,this._endHeading=void 0,this._distance=void 0,this._uSquared=void 0,p(e)&&p(r)&&Qze(this,e,r,o)}var TDt,ede,Ey,VF=Ee(()=>{bt();Si();cr();Ze();De();Ii();nr();y(yDt,"setConstants");y(ADt,"computeC");y(Yze,"computeDeltaLambda");y(CDt,"vincentyInverseFormula");TDt=new E,ede=new E;y(Qze,"computeProperties");y(EH,"EllipsoidGeodesic");Object.defineProperties(EH.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return X.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},startHeading:{get:function(){return X.defined("distance",this._distance),this._startHeading}},endHeading:{get:function(){return X.defined("distance",this._distance),this._endHeading}}});EH.prototype.setEndPoints=function(e,r){X.defined("start",e),X.defined("end",r),Qze(this,e,r,this._ellipsoid)};EH.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(this._distance*e,r)};EH.prototype.interpolateUsingSurfaceDistance=function(e,r){X.defined("distance",this._distance);var n=this._constants,o=n.distanceRatio+e/n.b,a=Math.cos(2*o),s=Math.cos(4*o),l=Math.cos(6*o),h=Math.sin(2*o),x=Math.sin(4*o),m=Math.sin(6*o),v=Math.sin(8*o),_=o*o,A=o*_,T=n.u8Over256,w=n.u2Over4,S=n.u6Over64,P=n.u4Over16,M=2*A*T*a/3+o*(1-w+7*P/4-15*S/4+579*T/64-(P-15*S/4+187*T/16)*a-(5*S/4-115*T/16)*s-29*T*l/16)+(w/2-P+71*S/32-85*T/16)*h+(5*P/16-5*S/4+383*T/96)*x-_*((S-11*T/2)*h+5*T*x/2)+(29*S/96-29*T/16)*m+539*T*v/1536,L=Math.asin(Math.sin(M)*n.cosineAlpha),R=Math.atan(n.a/n.b*Math.tan(L));M=M-n.sigma;var O=Math.cos(2*n.sigma+M),N=Math.sin(M),k=Math.cos(M),z=n.cosineU*k,W=n.sineU*N,j=Math.atan2(N*n.sineHeading,z-W*n.cosineHeading),q=j-Yze(n.f,n.sineAlpha,n.cosineSquaredAlpha,M,N,k,O);return p(r)?(r.longitude=this._start.longitude+q,r.latitude=R,r.height=0,r):new qe(this._start.longitude+q,R,0)};Ey=EH});function tde(e,r,n){this.heading=B(e,0),this.pitch=B(r,0),this.range=B(n,0)}var gg,kF=Ee(()=>{Ze();De();y(tde,"HeadingPitchRange");tde.clone=function(e,r){if(!!p(e))return p(r)||(r=new tde),r.heading=e.heading,r.pitch=e.pitch,r.range=e.range,r};gg=tde});function Xze(e,r,n){var o=e+r;return K.sign(e)!==K.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}var rde,Rp,bH=Ee(()=>{st();nr();rde={};rde.computeDiscriminant=function(e,r,n){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");var o=r*r-4*e*n;return o};y(Xze,"addWithCancellationCheck");rde.computeRealRoots=function(e,r,n){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");var o;if(e===0)return r===0?[]:[-n/r];if(r===0){if(n===0)return[0,0];var a=Math.abs(n),s=Math.abs(e);if(a<s&&a/s<K.EPSILON14)return[0,0];if(a>s&&s/a<K.EPSILON14)return[];if(o=-n/e,o<0)return[];var l=Math.sqrt(o);return[-l,l]}else if(n===0)return o=-r/e,o<0?[o,0]:[0,o];var h=r*r,x=4*e*n,m=Xze(h,-x,K.EPSILON14);if(m<0)return[];var v=-.5*Xze(r,K.sign(r)*Math.sqrt(m),K.EPSILON14);return r>0?[v/e,n/v]:[n/v,v/e]};Rp=rde});function ide(e,r,n,o){var a=e,s=r/3,l=n/3,h=o,x=a*l,m=s*h,v=s*s,_=l*l,A=a*l-v,T=a*h-s*l,w=s*h-_,S=4*A*w-T*T,P,M;if(S<0){var L,R,O;v*m>=x*_?(L=a,R=A,O=-2*s*A+a*T):(L=h,R=w,O=-h*T+2*l*w);var N=O<0?-1:1,k=-N*Math.abs(L)*Math.sqrt(-S);M=-O+k;var z=M/2,W=z<0?-Math.pow(-z,1/3):Math.pow(z,1/3),j=M===k?-W:-R/W;return P=R<=0?W+j:-O/(W*W+j*j+R),v*m>=x*_?[(P-s)/a]:[-h/(P+l)]}var q=A,I=-2*s*A+a*T,F=w,V=-h*T+2*l*w,U=Math.sqrt(S),Q=Math.sqrt(3)/2,J=Math.abs(Math.atan2(a*U,-I)/3);P=2*Math.sqrt(-q);var oe=Math.cos(J);M=P*oe;var $=P*(-oe/2-Q*Math.sin(J)),re=M+$>2*s?M-s:$-s,ne=a,le=re/ne;J=Math.abs(Math.atan2(h*U,-V)/3),P=2*Math.sqrt(-F),oe=Math.cos(J),M=P*oe,$=P*(-oe/2-Q*Math.sin(J));var ue=-h,ie=M+$<2*l?M+l:$+l,ce=ue/ie,he=ne*ie,_e=-re*ie-ne*ue,Ae=re*ue,be=(l*_e-s*Ae)/(-s*_e+l*he);return le<=be?le<=ce?be<=ce?[le,be,ce]:[le,ce,be]:[ce,le,be]:le<=ce?[be,le,ce]:be<=ce?[be,ce,le]:[ce,be,le]}var nde,UF,ode=Ee(()=>{st();bH();nde={};nde.computeDiscriminant=function(e,r,n,o){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");if(typeof o!="number")throw new G("d is a required number.");var a=e*e,s=r*r,l=n*n,h=o*o,x=18*e*r*n*o+s*l-27*a*h-4*(e*l*n+s*r*o);return x};y(ide,"computeRealRoots");nde.computeRealRoots=function(e,r,n,o){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");if(typeof o!="number")throw new G("d is a required number.");var a,s;if(e===0)return Rp.computeRealRoots(r,n,o);if(r===0){if(n===0){if(o===0)return[0,0,0];s=-o/e;var l=s<0?-Math.pow(-s,1/3):Math.pow(s,1/3);return[l,l,l]}else if(o===0)return a=Rp.computeRealRoots(e,0,n),a.Length===0?[0]:[a[0],0,a[1]];return ide(e,0,n,o)}else{if(n===0)return o===0?(s=-r/e,s<0?[s,0,0]:[0,0,s]):ide(e,r,0,o);if(o===0)return a=Rp.computeRealRoots(e,r,n),a.length===0?[0]:a[1]<=0?[a[0],a[1],0]:a[0]>=0?[0,a[0],a[1]]:[a[0],0,a[1]]}return ide(e,r,n,o)};UF=nde});function by(e,r,n,o){var a=e*e,s=r-3*a/8,l=n-r*e/2+a*e/8,h=o-n*e/4+r*a/16-3*a*a/256,x=UF.computeRealRoots(1,2*s,s*s-4*h,-l*l);if(x.length>0){var m=-e/4,v=x[x.length-1];if(Math.abs(v)<K.EPSILON14){var _=Rp.computeRealRoots(1,s,h);if(_.length===2){var A=_[0],T=_[1],w;if(A>=0&&T>=0){var S=Math.sqrt(A),P=Math.sqrt(T);return[m-P,m-S,m+S,m+P]}else{if(A>=0&&T<0)return w=Math.sqrt(A),[m-w,m+w];if(A<0&&T>=0)return w=Math.sqrt(T),[m-w,m+w]}}return[]}else if(v>0){var M=Math.sqrt(v),L=(s+v-l/M)/2,R=(s+v+l/M)/2,O=Rp.computeRealRoots(1,M,L),N=Rp.computeRealRoots(1,-M,R);return O.length!==0?(O[0]+=m,O[1]+=m,N.length!==0?(N[0]+=m,N[1]+=m,O[1]<=N[0]?[O[0],O[1],N[0],N[1]]:N[1]<=O[0]?[N[0],N[1],O[0],O[1]]:O[0]>=N[0]&&O[1]<=N[1]?[N[0],O[0],O[1],N[1]]:N[0]>=O[0]&&N[1]<=O[1]?[O[0],N[0],N[1],O[1]]:O[0]>N[0]&&O[0]<N[1]?[N[0],O[0],N[1],O[1]]:[O[0],N[0],O[1],N[1]]):O):N.length!==0?(N[0]+=m,N[1]+=m,N):[]}}return[]}function SH(e,r,n,o){var a=n*n,s=r*r,l=e*e,h=-2*r,x=n*e+s-4*o,m=l*o-n*r*e+a,v=UF.computeRealRoots(1,h,x,m);if(v.length>0){var _=v[0],A=r-_,T=A*A,w=e/2,S=A/2,P=T-4*o,M=T+4*Math.abs(o),L=l-4*_,R=l+4*Math.abs(_),O,N;if(_<0||P*R<L*M){var k=Math.sqrt(L);O=k/2,N=k===0?0:(e*S-n)/k}else{var z=Math.sqrt(P);O=z===0?0:(e*S-n)/z,N=z/2}var W,j;w===0&&O===0?(W=0,j=0):K.sign(w)===K.sign(O)?(W=w+O,j=_/W):(j=w-O,W=_/j);var q,I;S===0&&N===0?(q=0,I=0):K.sign(S)===K.sign(N)?(q=S+N,I=o/q):(I=S-N,q=o/I);var F=Rp.computeRealRoots(1,W,q),V=Rp.computeRealRoots(1,j,I);if(F.length!==0)return V.length!==0?F[1]<=V[0]?[F[0],F[1],V[0],V[1]]:V[1]<=F[0]?[V[0],V[1],F[0],F[1]]:F[0]>=V[0]&&F[1]<=V[1]?[V[0],F[0],F[1],V[1]]:V[0]>=F[0]&&V[1]<=F[1]?[F[0],V[0],V[1],F[1]]:F[0]>V[0]&&F[0]<V[1]?[V[0],F[0],V[1],F[1]]:[F[0],V[0],F[1],V[1]]:F;if(V.length!==0)return V}return[]}var ade,lQ,sde=Ee(()=>{ode();st();nr();bH();ade={};ade.computeDiscriminant=function(e,r,n,o,a){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");if(typeof o!="number")throw new G("d is a required number.");if(typeof a!="number")throw new G("e is a required number.");var s=e*e,l=s*e,h=r*r,x=h*r,m=n*n,v=m*n,_=o*o,A=_*o,T=a*a,w=T*a,S=h*m*_-4*x*A-4*e*v*_+18*e*r*n*A-27*s*_*_+256*l*w+a*(18*x*n*o-4*h*v+16*e*m*m-80*e*r*m*o-6*e*h*_+144*s*n*_)+T*(144*e*h*n-27*h*h-128*s*m-192*s*r*o);return S};y(by,"original");y(SH,"neumark");ade.computeRealRoots=function(e,r,n,o,a){if(typeof e!="number")throw new G("a is a required number.");if(typeof r!="number")throw new G("b is a required number.");if(typeof n!="number")throw new G("c is a required number.");if(typeof o!="number")throw new G("d is a required number.");if(typeof a!="number")throw new G("e is a required number.");if(Math.abs(e)<K.EPSILON15)return UF.computeRealRoots(r,n,o,a);var s=r/e,l=n/e,h=o/e,x=a/e,m=s<0?1:0;switch(m+=l<0?m+1:m,m+=h<0?m+1:m,m+=x<0?m+1:m,m){case 0:return by(s,l,h,x);case 1:return SH(s,l,h,x);case 2:return SH(s,l,h,x);case 3:return by(s,l,h,x);case 4:return by(s,l,h,x);case 5:return SH(s,l,h,x);case 6:return by(s,l,h,x);case 7:return by(s,l,h,x);case 8:return SH(s,l,h,x);case 9:return by(s,l,h,x);case 10:return by(s,l,h,x);case 11:return SH(s,l,h,x);case 12:return by(s,l,h,x);case 13:return by(s,l,h,x);case 14:return by(s,l,h,x);case 15:return by(s,l,h,x);default:return}};lQ=ade});function uQ(e,r){r=E.clone(B(r,E.ZERO)),E.equals(r,E.ZERO)||E.normalize(r,r),this.origin=E.clone(B(e,E.ZERO)),this.direction=r}var Oi,Yc=Ee(()=>{bt();cr();Ze();De();y(uQ,"Ray");uQ.clone=function(e,r){if(!!p(e))return p(r)?(r.origin=E.clone(e.origin),r.direction=E.clone(e.direction),r):new uQ(e.origin,e.direction)};uQ.getPoint=function(e,r,n){return X.typeOf.object("ray",e),X.typeOf.number("t",r),p(n)||(n=new E),n=E.multiplyByScalar(e.direction,r,n),E.add(e.origin,n,n)};Oi=uQ});function SDt(e,r,n,o){var a=r*r-4*e*n;if(!(a<0)){if(a>0){var s=1/(2*e),l=Math.sqrt(a),h=(-r+l)*s,x=(-r-l)*s;return h<x?(o.root0=h,o.root1=x):(o.root0=x,o.root1=h),o}var m=-r/(2*e);if(m!==0)return o.root0=o.root1=m,o}}function nVe(e,r,n){p(n)||(n=new Ip);var o=e.origin,a=e.direction,s=r.center,l=r.radius*r.radius,h=E.subtract(o,s,iVe),x=E.dot(a,a),m=2*E.dot(a,h),v=E.magnitudeSquared(h)-l,_=SDt(x,m,v,IDt);if(!!p(_))return n.start=_.root0,n.stop=_.root1,n}function $M(e,r,n){var o=e+r;return K.sign(e)!==K.sign(r)&&Math.abs(o/Math.max(Math.abs(e),Math.abs(r)))<n?0:o}function BDt(e,r,n,o,a){var s=o*o,l=a*a,h=(e[We.COLUMN1ROW1]-e[We.COLUMN2ROW2])*l,x=a*(o*$M(e[We.COLUMN1ROW0],e[We.COLUMN0ROW1],K.EPSILON15)+r.y),m=e[We.COLUMN0ROW0]*s+e[We.COLUMN2ROW2]*l+o*r.x+n,v=l*$M(e[We.COLUMN2ROW1],e[We.COLUMN1ROW2],K.EPSILON15),_=a*(o*$M(e[We.COLUMN2ROW0],e[We.COLUMN0ROW2])+r.z),A,T=[];if(_===0&&v===0){if(A=Rp.computeRealRoots(h,x,m),A.length===0)return T;var w=A[0],S=Math.sqrt(Math.max(1-w*w,0));if(T.push(new E(o,a*w,a*-S)),T.push(new E(o,a*w,a*S)),A.length===2){var P=A[1],M=Math.sqrt(Math.max(1-P*P,0));T.push(new E(o,a*P,a*-M)),T.push(new E(o,a*P,a*M))}return T}var L=_*_,R=v*v,O=h*h,N=_*v,k=O+R,z=2*(x*h+N),W=2*m*h+x*x-R+L,j=2*(m*x-N),q=m*m-L;if(k===0&&z===0&&W===0&&j===0)return T;A=lQ.computeRealRoots(k,z,W,j,q);var I=A.length;if(I===0)return T;for(var F=0;F<I;++F){var V=A[F],U=V*V,Q=Math.max(1-U,0),J=Math.sqrt(Q),oe;K.sign(h)===K.sign(m)?oe=$M(h*U+m,x*V,K.EPSILON12):K.sign(m)===K.sign(x*V)?oe=$M(h*U,x*V+m,K.EPSILON12):oe=$M(h*U+x*V,m,K.EPSILON12);var $=$M(v*V,_,K.EPSILON15),re=oe*$;re<0?T.push(new E(o,a*V,a*J)):re>0?T.push(new E(o,a*V,a*-J)):J!==0?(T.push(new E(o,a*V,a*-J)),T.push(new E(o,a*V,a*J)),++F):T.push(new E(o,a*V,a*J))}return T}var b0,wDt,EDt,iVe,Kze,Zze,bDt,IDt,PDt,DDt,MDt,lde,Jze,$ze,cQ,RDt,LDt,ODt,FDt,NDt,zDt,eVe,tVe,rVe,VDt,kDt,UDt,Yn,jf=Ee(()=>{bt();Si();Ze();De();st();hF();nr();to();bH();sde();Yc();b0={};b0.rayPlane=function(e,r,n){if(!p(e))throw new G("ray is required.");if(!p(r))throw new G("plane is required.");p(n)||(n=new E);var o=e.origin,a=e.direction,s=r.normal,l=E.dot(s,a);if(!(Math.abs(l)<K.EPSILON15)){var h=(-r.distance-E.dot(s,o))/l;if(!(h<0))return n=E.multiplyByScalar(a,h,n),E.add(o,n,n)}};wDt=new E,EDt=new E,iVe=new E,Kze=new E,Zze=new E;b0.rayTriangleParametric=function(e,r,n,o,a){if(!p(e))throw new G("ray is required.");if(!p(r))throw new G("p0 is required.");if(!p(n))throw new G("p1 is required.");if(!p(o))throw new G("p2 is required.");a=B(a,!1);var s=e.origin,l=e.direction,h=E.subtract(n,r,wDt),x=E.subtract(o,r,EDt),m=E.cross(l,x,iVe),v=E.dot(h,m),_,A,T,w,S;if(a){if(v<K.EPSILON6||(_=E.subtract(s,r,Kze),T=E.dot(_,m),T<0||T>v)||(A=E.cross(_,h,Zze),w=E.dot(l,A),w<0||T+w>v))return;S=E.dot(x,A)/v}else{if(Math.abs(v)<K.EPSILON6)return;var P=1/v;if(_=E.subtract(s,r,Kze),T=E.dot(_,m)*P,T<0||T>1||(A=E.cross(_,h,Zze),w=E.dot(l,A)*P,w<0||T+w>1))return;S=E.dot(x,A)*P}return S};b0.rayTriangle=function(e,r,n,o,a,s){var l=b0.rayTriangleParametric(e,r,n,o,a);if(!(!p(l)||l<0))return p(s)||(s=new E),E.multiplyByScalar(e.direction,l,s),E.add(e.origin,s,s)};bDt=new Oi;b0.lineSegmentTriangle=function(e,r,n,o,a,s,l){if(!p(e))throw new G("v0 is required.");if(!p(r))throw new G("v1 is required.");if(!p(n))throw new G("p0 is required.");if(!p(o))throw new G("p1 is required.");if(!p(a))throw new G("p2 is required.");var h=bDt;E.clone(e,h.origin),E.subtract(r,e,h.direction),E.normalize(h.direction,h.direction);var x=b0.rayTriangleParametric(h,n,o,a,s);if(!(!p(x)||x<0||x>E.distance(e,r)))return p(l)||(l=new E),E.multiplyByScalar(h.direction,x,l),E.add(h.origin,l,l)};y(SDt,"solveQuadratic");IDt={root0:0,root1:0};y(nVe,"raySphere");b0.raySphere=function(e,r,n){if(!p(e))throw new G("ray is required.");if(!p(r))throw new G("sphere is required.");if(n=nVe(e,r,n),!(!p(n)||n.stop<0))return n.start=Math.max(n.start,0),n};PDt=new Oi;b0.lineSegmentSphere=function(e,r,n,o){if(!p(e))throw new G("p0 is required.");if(!p(r))throw new G("p1 is required.");if(!p(n))throw new G("sphere is required.");var a=PDt;E.clone(e,a.origin);var s=E.subtract(r,e,a.direction),l=E.magnitude(s);if(E.normalize(s,s),o=nVe(a,n,o),!(!p(o)||o.stop<0||o.start>l))return o.start=Math.max(o.start,0),o.stop=Math.min(o.stop,l),o};DDt=new E,MDt=new E;b0.rayEllipsoid=function(e,r){if(!p(e))throw new G("ray is required.");if(!p(r))throw new G("ellipsoid is required.");var n=r.oneOverRadii,o=E.multiplyComponents(n,e.origin,DDt),a=E.multiplyComponents(n,e.direction,MDt),s=E.magnitudeSquared(o),l=E.dot(o,a),h,x,m,v,_;if(s>1){if(l>=0)return;var A=l*l;if(h=s-1,x=E.magnitudeSquared(a),m=x*h,A<m)return;if(A>m){v=l*l-m,_=-l+Math.sqrt(v);var T=_/x,w=h/_;return T<w?new Ip(T,w):{start:w,stop:T}}var S=Math.sqrt(h/x);return new Ip(S,S)}else if(s<1)return h=s-1,x=E.magnitudeSquared(a),m=x*h,v=l*l-m,_=-l+Math.sqrt(v),new Ip(0,_/x);if(l<0)return x=E.magnitudeSquared(a),new Ip(0,-l/x)};y($M,"addWithCancellationCheck");y(BDt,"quadraticVectorExpression");lde=new E,Jze=new E,$ze=new E,cQ=new E,RDt=new E,LDt=new We,ODt=new We,FDt=new We,NDt=new We,zDt=new We,eVe=new We,tVe=new We,rVe=new E,VDt=new E,kDt=new qe;b0.grazingAltitudeLocation=function(e,r){if(!p(e))throw new G("ray is required.");if(!p(r))throw new G("ellipsoid is required.");var n=e.origin,o=e.direction;if(!E.equals(n,E.ZERO)){var a=r.geodeticSurfaceNormal(n,lde);if(E.dot(o,a)>=0)return n}var s=p(this.rayEllipsoid(e,r)),l=r.transformPositionToScaledSpace(o,lde),h=E.normalize(l,l),x=E.mostOrthogonalAxis(l,cQ),m=E.normalize(E.cross(x,h,Jze),Jze),v=E.normalize(E.cross(h,m,$ze),$ze),_=LDt;_[0]=h.x,_[1]=h.y,_[2]=h.z,_[3]=m.x,_[4]=m.y,_[5]=m.z,_[6]=v.x,_[7]=v.y,_[8]=v.z;var A=We.transpose(_,ODt),T=We.fromScale(r.radii,FDt),w=We.fromScale(r.oneOverRadii,NDt),S=zDt;S[0]=0,S[1]=-o.z,S[2]=o.y,S[3]=o.z,S[4]=0,S[5]=-o.x,S[6]=-o.y,S[7]=o.x,S[8]=0;var P=We.multiply(We.multiply(A,w,eVe),S,eVe),M=We.multiply(We.multiply(P,T,tVe),_,tVe),L=We.multiplyByVector(P,n,RDt),R=BDt(M,E.negate(L,lde),0,0,1),O,N,k=R.length;if(k>0){for(var z=E.clone(E.ZERO,VDt),W=Number.NEGATIVE_INFINITY,j=0;j<k;++j){O=We.multiplyByVector(T,We.multiplyByVector(_,R[j],rVe),rVe);var q=E.normalize(E.subtract(O,n,cQ),cQ),I=E.dot(q,o);I>W&&(W=I,z=E.clone(O,z))}var F=r.cartesianToCartographic(z,kDt);return W=K.clamp(W,0,1),N=E.magnitude(E.subtract(z,n,cQ))*Math.sqrt(1-W*W),N=s?-N:N,F.height=N,r.cartographicToCartesian(F,new E)}};UDt=new E;b0.lineSegmentPlane=function(e,r,n,o){if(!p(e))throw new G("endPoint0 is required.");if(!p(r))throw new G("endPoint1 is required.");if(!p(n))throw new G("plane is required.");p(o)||(o=new E);var a=E.subtract(r,e,UDt),s=n.normal,l=E.dot(s,a);if(!(Math.abs(l)<K.EPSILON6)){var h=E.dot(s,e),x=-(n.distance+h)/l;if(!(x<0||x>1))return E.multiplyByScalar(a,x,o),E.add(e,o,o),o}};b0.trianglePlaneIntersection=function(e,r,n,o){if(!p(e)||!p(r)||!p(n)||!p(o))throw new G("p0, p1, p2, and plane are required.");var a=o.normal,s=o.distance,l=E.dot(a,e)+s<0,h=E.dot(a,r)+s<0,x=E.dot(a,n)+s<0,m=0;m+=l?1:0,m+=h?1:0,m+=x?1:0;var v,_;if((m===1||m===2)&&(v=new E,_=new E),m===1){if(l)return b0.lineSegmentPlane(e,r,o,v),b0.lineSegmentPlane(e,n,o,_),{positions:[e,r,n,v,_],indices:[0,3,4,1,2,4,1,4,3]};if(h)return b0.lineSegmentPlane(r,n,o,v),b0.lineSegmentPlane(r,e,o,_),{positions:[e,r,n,v,_],indices:[1,3,4,2,0,4,2,4,3]};if(x)return b0.lineSegmentPlane(n,e,o,v),b0.lineSegmentPlane(n,r,o,_),{positions:[e,r,n,v,_],indices:[2,3,4,0,1,4,0,4,3]}}else if(m===2)if(l)if(h){if(!x)return b0.lineSegmentPlane(e,n,o,v),b0.lineSegmentPlane(r,n,o,_),{positions:[e,r,n,v,_],indices:[0,1,4,0,4,3,2,3,4]}}else return b0.lineSegmentPlane(n,r,o,v),b0.lineSegmentPlane(e,r,o,_),{positions:[e,r,n,v,_],indices:[2,0,4,2,4,3,1,3,4]};else return b0.lineSegmentPlane(r,e,o,v),b0.lineSegmentPlane(n,e,o,_),{positions:[e,r,n,v,_],indices:[1,2,4,1,4,3,0,3,4]}};Yn=b0});function Lp(e){e=B(e,B.EMPTY_OBJECT),this._offCenterFrustum=new Pu,this.width=e.width,this._width=void 0,this.aspectRatio=e.aspectRatio,this._aspectRatio=void 0,this.near=B(e.near,1),this._near=this.near,this.far=B(e.far,5e8),this._far=this.far}function eB(e){if(!p(e.width)||!p(e.aspectRatio)||!p(e.near)||!p(e.far))throw new G("width, aspectRatio, near, or far parameters are not set.");var r=e._offCenterFrustum;if(e.width!==e._width||e.aspectRatio!==e._aspectRatio||e.near!==e._near||e.far!==e._far){if(e.aspectRatio<0)throw new G("aspectRatio must be positive.");if(e.near<0||e.near>e.far)throw new G("near must be greater than zero and less than far.");e._aspectRatio=e.aspectRatio,e._width=e.width,e._near=e.near,e._far=e.far;var n=1/e.aspectRatio;r.right=e.width*.5,r.left=-r.right,r.top=n*r.right,r.bottom=-r.top,r.near=e.near,r.far=e.far}}var En,wc=Ee(()=>{cr();Ze();De();st();nr();Ty();y(Lp,"OrthographicFrustum");Lp.packedLength=4;Lp.pack=function(e,r,n){return X.typeOf.object("value",e),X.defined("array",r),n=B(n,0),r[n++]=e.width,r[n++]=e.aspectRatio,r[n++]=e.near,r[n]=e.far,r};Lp.unpack=function(e,r,n){return X.defined("array",e),r=B(r,0),p(n)||(n=new Lp),n.width=e[r++],n.aspectRatio=e[r++],n.near=e[r++],n.far=e[r],n};y(eB,"update");Object.defineProperties(Lp.prototype,{projectionMatrix:{get:function(){return eB(this),this._offCenterFrustum.projectionMatrix}}});Lp.prototype.computeCullingVolume=function(e,r,n){return eB(this),this._offCenterFrustum.computeCullingVolume(e,r,n)};Lp.prototype.getPixelDimensions=function(e,r,n,o,a){return eB(this),this._offCenterFrustum.getPixelDimensions(e,r,n,o,a)};Lp.prototype.clone=function(e){return p(e)||(e=new Lp),e.aspectRatio=this.aspectRatio,e.width=this.width,e.near=this.near,e.far=this.far,e._aspectRatio=void 0,e._width=void 0,e._near=void 0,e._far=void 0,this._offCenterFrustum.clone(e._offCenterFrustum),e};Lp.prototype.equals=function(e){return!p(e)||!(e instanceof Lp)?!1:(eB(this),eB(e),this.width===e.width&&this.aspectRatio===e.aspectRatio&&this._offCenterFrustum.equals(e._offCenterFrustum))};Lp.prototype.equalsEpsilon=function(e,r,n){return!p(e)||!(e instanceof Lp)?!1:(eB(this),eB(e),K.equalsEpsilon(this.width,e.width,r,n)&&K.equalsEpsilon(this.aspectRatio,e.aspectRatio,r,n)&&this._offCenterFrustum.equalsEpsilon(e._offCenterFrustum,r,n))};En=Lp});var fQ,ze,zi=Ee(()=>{fQ={MORPHING:0,COLUMBUS_VIEW:1,SCENE2D:2,SCENE3D:3};fQ.getMorphTime=function(e){return e===fQ.SCENE3D?1:e===fQ.MORPHING?void 0:0};ze=Object.freeze(fQ)});var GDt,u1,IH=Ee(()=>{GDt={NONE:0,CATMULL_ROM:1},u1=Object.freeze(GDt)});function HDt(e,r,n){var o,a,s;if(e instanceof Ya){var l=Math.tan(.5*e.fovy);return o=e.near,a=e.near*l,s=e.aspectRatio*a,Math.max(r*o/s,n*o/a)}else if(e instanceof ym)return o=e.near,a=e.top,s=e.right,Math.max(r*o/s,n*o/a);return Math.max(r,n)}function qDt(e,r,n,o){if(p(o)&&n(.5)>o){var a=n(0),s=n(1),l=n(.5),h=l-a,x=l-s;return function(m){var v=n(m);if(m<=.5){var _=(v-a)/h;return K.lerp(e,-K.PI_OVER_TWO,_)}var A=(v-s)/x;return K.lerp(-K.PI_OVER_TWO,r,1-A)}}return function(m){return K.lerp(e,r,m)}}function cde(e,r,n,o,a){var s=a,l=Math.max(n,o);if(!p(s)){var h=e.position,x=r,m=e.up,v=e.right,_=e.frustum,A=E.subtract(h,x,WDt),T=E.magnitude(E.multiplyByScalar(m,E.dot(A,m),oVe)),w=E.magnitude(E.multiplyByScalar(v,E.dot(A,v),oVe));s=Math.min(HDt(_,T,w)*.2,1e9)}if(l<s){var S=8,P=1e6,M=-Math.pow((s-n)*P,1/S),L=Math.pow((s-o)*P,1/S);return function(R){var O=R*(L-M)+M;return-Math.pow(O,S)/P+s}}return function(R){return K.lerp(n,o,R)}}function PH(e,r){return K.equalsEpsilon(e,K.TWO_PI,K.EPSILON11)&&(e=0),r>e+Math.PI?e+=K.TWO_PI:r<e-Math.PI&&(e-=K.TWO_PI),e}function jDt(e,r,n,o,a,s,l){var h=e.camera,x=E.clone(h.position,uVe),m=h.pitch,v=PH(h.heading,o),_=PH(h.roll,s),A=cde(h,n,x.z,n.z,l);function T(w){var S=w.time/r;h.setView({orientation:{heading:K.lerp(v,o,S),pitch:K.lerp(m,a,S),roll:K.lerp(_,s,S)}}),de.lerp(x,n,S,h.position),h.position.z=A(S)}return y(T,"update"),T}function YDt(e,r){e.longitude<r.longitude?e.longitude+=K.TWO_PI:r.longitude+=K.TWO_PI}function QDt(e,r){var n=e.longitude-r.longitude;n<-K.PI?e.longitude+=K.TWO_PI:n>K.PI&&(r.longitude+=K.TWO_PI)}function ZDt(e,r,n,o,a,s,l,h,x,m,v,_,A,T,w,S,P,M,L){var R=e.camera,O=e.mapProjection,N=O.ellipsoid,k=qe.clone(R.positionCartographic,XDt),z=R.pitch,W=PH(R.heading,o),j=PH(R.roll,s),q=N.cartesianToCartographic(n,KDt);k.longitude=K.zeroToTwoPi(k.longitude),q.longitude=K.zeroToTwoPi(q.longitude);var I=!1;if(p(h)){var F=K.zeroToTwoPi(h),V=Math.min(k.longitude,q.longitude),U=Math.max(k.longitude,q.longitude),Q=F>=V&&F<=U;if(p(x)){var J=Math.abs(k.longitude-q.longitude),oe=K.TWO_PI-J,$=Q?J:oe,re=Q?oe:J;$<re*x&&!Q&&(I=!0)}else Q||(I=!0)}I?YDt(k,q):QDt(k,q);var ne=cde(R,n,k.height,q.height,l),le=qDt(z,a,ne,m);function ue(){var ie=k.longitude,ce=q.longitude,he=k.latitude,_e=q.latitude;return y(function(be){var pe,ge=be.time/r,Te=A?R.positionCartographic.height:ne(ge),Pe;if(P===u1.NONE||!p(L))Pe=E.fromRadians(K.lerp(ie,ce,ge),K.lerp(he,_e,ge),Te);else{var ye=M._times[L];if(pe=ye+be.time,pe>M._times[M._times.length-1])return;var ve=M.evaluate(pe),we=qe.fromCartesian(ve);Pe=E.fromRadians(we.longitude,we.latitude,Te)}if(T){var Be=qe.fromCartesian(Pe),Fe=e.globe.getHeight(Be);if(p(Fe))(Te<Fe||Te-Fe>0&&Te-Fe<w)&&(Be.height=Fe+w,Pe=qe.toCartesian(Be));else return}var ke=v?R.heading:K.lerp(W,o,ge),Ge=_?R.pitch:le(ge),je=K.lerp(j,s,ge);if(S&&(ke=v?R.heading:o,je=s),P===u1.NONE||!p(L))R.setView({destination:Pe,orientation:{heading:ke,pitch:Ge,roll:je}});else{var lt=pe+.001;if(lt>M._times[M._times.length-1])R.setView({destination:Pe,orientation:{heading:ke,pitch:Ge,roll:je}});else{var ct=M.evaluate(lt),Bt=qe.fromCartesian(ct);ct=E.fromRadians(Bt.longitude,Bt.latitude,Te);var Dt=new E(ct.x-Pe.x,ct.y-Pe.y,ct.z-Pe.z);E.normalize(Dt,Dt);var Rt=Qt.buildUp(Pe,Dt);R.setView({destination:Pe,orientation:{direction:Dt,up:Rt}})}}},"update")}return y(ue,"isolateUpdateFunction"),ue()}function JDt(e,r,n,o,a,s,l){var h=e.camera,x=E.clone(h.position,uVe),m=PH(h.heading,o),v=h.frustum.right-h.frustum.left,_=cde(h,n,v,n.z,l);function A(T){var w=T.time/r;h.setView({orientation:{heading:K.lerp(m,o,w)}}),de.lerp(x,n,w,h.position);var S=_(w),P=h.frustum,M=P.top/P.right,L=(S-(P.right-P.left))*.5;P.right+=L,P.left-=L,P.top=M*P.right,P.bottom=-P.top}return y(A,"update"),A}function ude(e,r){return{startObject:{},stopObject:{},duration:0,complete:e,cancel:r}}function sVe(e,r){function n(){typeof r=="function"&&r(),e.enableInputs=!0}return y(n,"wrapped"),n}var lVe,WDt,oVe,uVe,XDt,KDt,aVe,$Dt,xQ,fde=Ee(()=>{Fr();bt();Si();Ze();De();st();NC();nr();j2();QM();Wn();zi();IH();lVe={};y(HDt,"getAltitude");WDt=new E,oVe=new E;y(qDt,"createPitchFunction");y(cde,"createHeightFunction");y(PH,"adjustAngleForLERP");uVe=new E;y(jDt,"createUpdateCV");y(YDt,"useLongestFlight");y(QDt,"useShortestFlight");XDt=new qe,KDt=new qe;y(ZDt,"createUpdate3D");y(JDt,"createUpdate2D");aVe=new qe,$Dt=new E;y(ude,"emptyFlight");y(sVe,"wrapCallback");lVe.createTween=function(e,r){r=B(r,B.EMPTY_OBJECT);var n=r.destination;if(!p(e))throw new G("scene is required.");if(!p(n))throw new G("destination is required.");var o=e.mode;if(o===ze.MORPHING)return ude();var a=B(r.convert,!0),s=e.mapProjection,l=s.ellipsoid,h=r.maximumHeight,x=r.flyOverLongitude,m=r.flyOverLongitudeWeight,v=r.pitchAdjustHeight,_=r.easingFunction,A=r.flyClampToGround,T=r.flyRelativeHeight,w=r.interpolationMode,S=r.catmullRomSpline,P=r.preStopIndex;a&&o!==ze.SCENE3D&&(l.cartesianToCartographic(n,aVe),n=s.project(aVe,$Dt));var M=e.camera,L=r.endTransform;p(L)&&M._setTransform(L);var R=r.duration;p(R)||(R=Math.ceil(E.distance(M.position,n)/1e6)+2,R=Math.min(R,3));var O=B(r.heading,0),N=B(r.pitch,-K.PI_OVER_TWO),k=B(r.roll,0),z=B(r.headingFree,!1),W=B(r.pitchFree,!1),j=B(r.altitudeFree,!1),q=B(r.directTurning,!1),I=e.screenSpaceCameraController;I.enableInputs=r.headingFree||r.pitchFree||r.altitudeFree;var F=sVe(I,r.complete),V=sVe(I,r.cancel),U=M.frustum,Q=e.mode===ze.SCENE2D;if(Q=Q&&de.equalsEpsilon(M.position,n,K.EPSILON6),Q=Q&&K.equalsEpsilon(Math.max(U.right-U.left,U.top-U.bottom),n.z,K.EPSILON6),Q=Q||e.mode!==ze.SCENE2D&&E.equalsEpsilon(n,M.position,K.EPSILON10),Q=Q&&K.equalsEpsilon(K.negativePiToPi(O),K.negativePiToPi(M.heading),K.EPSILON10)&&K.equalsEpsilon(K.negativePiToPi(N),K.negativePiToPi(M.pitch),K.EPSILON10)&&K.equalsEpsilon(K.negativePiToPi(k),K.negativePiToPi(M.roll),K.EPSILON10),Q)return ude(F,V);var J=new Array(4);if(J[ze.SCENE2D]=JDt,J[ze.SCENE3D]=ZDt,J[ze.COLUMBUS_VIEW]=jDt,R<=0){var oe=y(function(){var le=J[o](e,1,n,O,N,k,h,x,m,v);le({time:1}),typeof F=="function"&&F()},"newOnComplete");return ude(oe,V)}var $=J[o](e,R,n,O,N,k,h,x,m,v,z,W,j,A,T,q,w,S,P);if(!p(_)){var re=M.positionCartographic.height,ne=o===ze.SCENE3D?l.cartesianToCartographic(n).height:n.z;re>ne&&re>11500?_=qu.CUBIC_OUT:_=qu.QUINTIC_IN_OUT}return{duration:R,easingFunction:_,startObject:{time:0},stopObject:{time:R},update:$,complete:F,cancel:V}};xQ=lVe});var eMt,_g,DH=Ee(()=>{eMt={ROTATE:0,INFINITE_SCROLL:1},_g=Object.freeze(eMt)});function In(e){if(!p(e))throw new G("scene is required.");this._scene=e,this._transform=Z.clone(Z.IDENTITY),this._invTransform=Z.clone(Z.IDENTITY),this._actualTransform=Z.clone(Z.IDENTITY),this._actualInvTransform=Z.clone(Z.IDENTITY),this._transformChanged=!1,this.position=new E,this._position=new E,this._positionWC=new E,this._positionCartographic=new qe,this.positionWCDeltaMagnitude=0,this.positionWCDeltaMagnitudeLastFrame=0,this.direction=new E,this._direction=new E,this._directionWC=new E,this.up=new E,this._up=new E,this._upWC=new E,this.right=new E,this._right=new E,this._rightWC=new E,this.frustum=new Ya,this.frustum.aspectRatio=e.drawingBufferWidth/e.drawingBufferHeight,this.frustum.fov=K.toRadians(60),this.defaultMoveAmount=1e5,this.defaultLookAmount=Math.PI/60,this.defaultRotateAmount=Math.PI/3600,this.defaultZoomAmount=1e5,this.constrainedAxis=void 0,this.maximumZoomFactor=1.5,this._moveStart=new It,this._moveEnd=new It,this._changed=new It,this._changedPosition=void 0,this._changedDirection=void 0,this._changedFrustum=void 0,this.percentageChanged=.5,this._refinePercentageChanged=.001,this._viewMatrix=new Z,this._invViewMatrix=new Z,pVe(this),this._mode=ze.SCENE3D,this._modeChanged=!0;var r=e.mapProjection;this._projection=r,this._maxCoord=r.project(new qe(Math.PI,K.PI_OVER_TWO)),this._max2Dfrustum=void 0,this._suspendTerrainAdjustment=!1,SVe(this,In.DEFAULT_VIEW_RECTANGLE,this.position,!0);var n=E.magnitude(this.position);n+=n*In.DEFAULT_VIEW_FACTOR,E.normalize(this.position,this.position),E.multiplyByScalar(this.position,n,this.position),this.bReflect=!1,this._bReflect=!1,this._reflectMatrix=new Z,this._reflectPosition=new E,this._reflectUp=new E,this._reflectDirection=new E,this._reflectRight=new E,this._isFlyCircle=!1,this._flyCircleCenter=new E,this._flyCircleLoop=!1,this._isResetFlyCircleParm=!1,this._speedRatio=1,this._flyClampToGround=!1,this._flyRelativeHeight=10,this._sensitivePosition=void 0,this._sensitivePositionRatio=0,this._sensitiveRegionRatio=0,this._endLevel=22,this._stateChanged=!0,this._preciseSensitivePosition=!1,this._enableIndoorColliDetection=!1,this.zoomLevel=1}function pVe(e){Z.computeView(e._position,e._direction,e._up,e._right,e._viewMatrix),Z.multiply(e._viewMatrix,e._actualInvTransform,e._viewMatrix),e.bReflect&&Z.multiply(e._viewMatrix,e._reflectMatrix,e._viewMatrix),Z.inverseTransformation(e._viewMatrix,e._invViewMatrix)}function tMt(e){if(!p(e._oldPositionWC))e._oldPositionWC=E.clone(e.positionWC,e._oldPositionWC);else{e.positionWCDeltaMagnitudeLastFrame=e.positionWCDeltaMagnitude;var r=E.subtract(e.positionWC,e._oldPositionWC,e._oldPositionWC);e.positionWCDeltaMagnitude=E.magnitude(r),e._oldPositionWC=E.clone(e.positionWC,e._oldPositionWC),e.positionWCDeltaMagnitude>0?(e.timeSinceMoved=0,e._lastMovedTimestamp=jo()):e.timeSinceMoved=Math.max(jo()-e._lastMovedTimestamp,0)/1e3}}function nMt(e){Qt.basisTo2D(e._projection,e._transform,e._actualTransform)}function xMt(e){var r=e._projection,n=r.ellipsoid,o=Z.getColumn(e._transform,3,sMt),a=n.cartesianToCartographic(o,oMt),s=r.project(a,aMt),l=lMt;l.x=s.z,l.y=s.x,l.z=s.y,l.w=1;var h=Ce.clone(Ce.UNIT_X,fMt),x=Ce.add(Z.getColumn(e._transform,0,hQ),o,hQ);n.cartesianToCartographic(x,a),r.project(a,s);var m=uMt;m.x=s.z,m.y=s.x,m.z=s.y,m.w=0,E.subtract(m,l,m),m.x=0;var v=cMt;if(E.magnitudeSquared(m)>K.EPSILON10)E.cross(h,m,v);else{var _=Ce.add(Z.getColumn(e._transform,1,hQ),o,hQ);n.cartesianToCartographic(_,a),r.project(a,s),v.x=s.z,v.y=s.x,v.z=s.y,v.w=0,E.subtract(v,l,v),v.x=0,E.magnitudeSquared(v)<K.EPSILON10&&(Ce.clone(Ce.UNIT_Y,m),Ce.clone(Ce.UNIT_Z,v))}E.cross(v,h,m),E.normalize(m,m),E.cross(h,m,v),E.normalize(v,v),Z.setColumn(e._actualTransform,0,m,e._actualTransform),Z.setColumn(e._actualTransform,1,v,e._actualTransform),Z.setColumn(e._actualTransform,2,h,e._actualTransform),Z.setColumn(e._actualTransform,3,l,e._actualTransform)}function eh(e){var r=e._mode,n=!1,o=0;r===ze.SCENE2D&&(o=e.frustum.right-e.frustum.left,n=o!==e._positionCartographic.height);var a=e._position,s=!E.equals(a,e.position)||n;s&&(a=E.clone(e.position,e._position));var l=e._direction,h=!E.equals(l,e.direction);h&&(E.normalize(e.direction,e.direction),l=E.clone(e.direction,e._direction));var x=e._up,m=!E.equals(x,e.up);m&&(E.normalize(e.up,e.up),x=E.clone(e.up,e._up));var v=e._right,_=!E.equals(v,e.right);_&&(E.normalize(e.right,e.right),v=E.clone(e.right,e._right));var A=!1;e.bReflect!=e._bReflect&&(e._bReflect=e.bReflect,A=!0);var T=e._transformChanged||e._modeChanged;e._transformChanged=!1,T&&(Z.inverseTransformation(e._transform,e._invTransform),e._mode===ze.COLUMBUS_VIEW||e._mode===ze.SCENE2D?Z.equals(Z.IDENTITY,e._transform)?Z.clone(In.TRANSFORM_2D,e._actualTransform):e._mode===ze.COLUMBUS_VIEW?nMt(e):xMt(e):Z.clone(e._transform,e._actualTransform),Z.inverseTransformation(e._actualTransform,e._actualInvTransform),e._modeChanged=!1);var w=e._actualTransform;if(s||T)if(e._positionWC=Z.multiplyByPoint(w,a,e._positionWC),r===ze.SCENE3D||r===ze.MORPHING)e._positionCartographic=e._projection.ellipsoid.cartesianToCartographic(e._positionWC,e._positionCartographic);else{var S=xde;S.x=e._positionWC.y,S.y=e._positionWC.z,S.z=e._positionWC.x,r===ze.SCENE2D&&(S.z=o),e._projection.unproject(S,e._positionCartographic)}if(h||m||_){var P=E.dot(l,E.cross(x,v,xde));if(Math.abs(1-P)>K.EPSILON2){var M=1/E.magnitudeSquared(x),L=E.dot(x,l)*M,R=E.multiplyByScalar(l,L,xde);x=E.normalize(E.subtract(x,R,e._up),e._up),E.clone(x,e.up),v=E.cross(l,x,e._right),E.clone(v,e.right)}}(h||T)&&(e._directionWC=Z.multiplyByPointAsVector(w,l,e._directionWC),E.normalize(e._directionWC,e._directionWC)),(m||T)&&(e._upWC=Z.multiplyByPointAsVector(w,x,e._upWC),E.normalize(e._upWC,e._upWC)),(_||T)&&(e._rightWC=Z.multiplyByPointAsVector(w,v,e._rightWC),E.normalize(e._rightWC,e._rightWC)),(s||h||m||_||T||A)&&pVe(e)}function vVe(e,r){var n;return K.equalsEpsilon(Math.abs(e.z),1,K.EPSILON3)?n=Math.atan2(r.y,r.x)-K.PI_OVER_TWO:n=Math.atan2(e.y,e.x)-K.PI_OVER_TWO,K.TWO_PI-K.zeroToTwoPi(n)}function gVe(e){return K.PI_OVER_TWO-K.acosClamped(e.z)}function _Ve(e,r,n){var o=0;return K.equalsEpsilon(Math.abs(e.z),1,K.EPSILON3)||(o=Math.atan2(-n.z,r.z),o=K.zeroToTwoPi(o+K.TWO_PI)),o}function CMt(e,r,n){var o=Z.clone(e.transform,_de),a=Qt.eastNorthUpToFixedFrame(r,e._projection.ellipsoid,AMt);e._setTransform(a),E.clone(E.ZERO,e.position),n.heading=n.heading-K.PI_OVER_TWO;var s=hr.fromHeadingPitchRoll(n,yde),l=We.fromQuaternion(s,Ade);We.getColumn(l,0,e.direction),We.getColumn(l,2,e.up),E.cross(e.direction,e.up,e.right),e._setTransform(o),e._adjustOrthographicFrustum(!0)}function TMt(e,r,n,o){var a=Z.clone(e.transform,_de);if(e._setTransform(Z.IDENTITY),!E.equals(r,e.positionWC)){if(o){var s=e._projection,l=s.ellipsoid.cartesianToCartographic(r,yVe);r=s.project(l,AQ)}E.clone(r,e.position)}n.heading=n.heading-K.PI_OVER_TWO;var h=hr.fromHeadingPitchRoll(n,yde),x=We.fromQuaternion(h,Ade);We.getColumn(x,0,e.direction),We.getColumn(x,2,e.up),E.cross(e.direction,e.up,e.right),e._setTransform(a),e._adjustOrthographicFrustum(!0)}function wMt(e,r,n,o){var a=Z.clone(e.transform,_de);if(e._setTransform(Z.IDENTITY),!E.equals(r,e.positionWC)){if(o){var s=e._projection,l=s.ellipsoid.cartesianToCartographic(r,yVe);r=s.project(l,AQ)}de.clone(r,e.position);var h=-r.z*.5,x=-h,m=e.frustum;if(x>h){var v=m.top/m.right;m.right=x,m.left=h,m.top=m.right*v,m.bottom=-m.top}}if(e._scene.mapMode2D===_g.ROTATE){n.heading=n.heading-K.PI_OVER_TWO,n.pitch=-K.PI_OVER_TWO,n.roll=0;var _=hr.fromHeadingPitchRoll(n,yde),A=We.fromQuaternion(_,Ade);We.getColumn(A,2,e.up),E.cross(e.direction,e.up,e.right)}e._setTransform(a)}function AVe(e,r,n,o){var a=E.clone(n.direction,EMt),s=E.clone(n.up,bMt);if(e._scene.mode===ze.SCENE3D){var l=e._projection.ellipsoid,h=Qt.eastNorthUpToFixedFrame(r,l,gQ),x=Z.inverseTransformation(h,_Q);Z.multiplyByPointAsVector(x,a,a),Z.multiplyByPointAsVector(x,s,s)}var m=E.cross(a,s,SMt);return o.heading=vVe(a,s),o.pitch=gVe(a),o.roll=_Ve(a,s,m),o}function CVe(e,r){var n=e._scene.mapMode2D===_g.ROTATE,o=e._maxCoord.x,a=e._maxCoord.y,s,l;n?(l=o,s=-l):(l=r.x-o*2,s=r.x+o*2),r.x>o&&(r.x=l),r.x<-o&&(r.x=s),r.y>a&&(r.y=a),r.y<-a&&(r.y=-a)}function TVe(e,r){var n=e.position,o=E.normalize(n,RMt);if(p(e.constrainedAxis)){var a=E.equalsEpsilon(o,e.constrainedAxis,K.EPSILON2),s=E.equalsEpsilon(o,E.negate(e.constrainedAxis,cVe),K.EPSILON2);if(!a&&!s){var l=E.normalize(e.constrainedAxis,LMt),h=E.dot(o,l),x=K.acosClamped(h);r>0&&r>x&&(r=x-K.EPSILON4),h=E.dot(o,E.negate(l,cVe)),x=K.acosClamped(h),r<0&&-r>x&&(r=-x+K.EPSILON4);var m=E.cross(l,o,OMt),v=E.dot(m,e.right);if(v<0&&r>0)return;m=v<0?E.negate(m,m):m,e.rotate(m,r)}else(a&&r<0||s&&r>0)&&e.rotate(e.right,r)}else e.rotate(e.right,r)}function wVe(e,r){p(e.constrainedAxis)?e.rotate(e.constrainedAxis,r):e.rotate(e.up,r)}function CQ(e,r){var n=e.frustum;if(!(n instanceof Pu)||!p(n.left)||!p(n.right)||!p(n.bottom)||!p(n.top))throw new G("The camera frustum is expected to be orthographic for 2D camera control.");var o;if(r=r*.5,Math.abs(n.top)+Math.abs(n.bottom)>Math.abs(n.left)+Math.abs(n.right)){var a=n.top-r,s=n.bottom+r,l=e._maxCoord.y;e._scene.mapMode2D===_g.ROTATE&&(l*=e.maximumZoomFactor),s>l&&(s=l,a=-l),a<=s&&(a=1,s=-1),o=n.right/n.top,n.top=a,n.bottom=s,n.right=n.top*o,n.left=-n.right}else{var h=n.right-r,x=n.left+r,m=e._maxCoord.x;e._scene.mapMode2D===_g.ROTATE&&(m*=e.maximumZoomFactor),h>m&&(h=m,x=-m),h<=x&&(h=1,x=-1),o=n.top/n.right,n.right=h,n.left=x,n.top=n.right*o,n.bottom=-n.top}}function EVe(e,r){e.move(e.direction,r)}function bVe(e,r,n){r=K.clamp(r,-K.PI_OVER_TWO,K.PI_OVER_TWO),e=K.zeroToTwoPi(e)-K.PI_OVER_TWO;var o=hr.fromAxisAngle(E.UNIT_Y,-r,zMt),a=hr.fromAxisAngle(E.UNIT_Z,-e,VMt),s=hr.multiply(a,o,a),l=We.fromQuaternion(s,kMt),h=E.clone(E.UNIT_X,NMt);return We.multiplyByVector(l,h,h),E.negate(h,h),E.multiplyByScalar(h,n,h),h}function Sd(e,r,n,o){var a=Math.abs(E.dot(r,n));return a/o-E.dot(e,n)}function SVe(e,r,n,o){var a=e._projection.ellipsoid,s=o?e:XMt,l=r.north,h=r.south,x=r.east,m=r.west;m>x&&(x+=K.TWO_PI);var v=(m+x)*.5,_;if(h<-K.PI_OVER_TWO+K.RADIANS_PER_DEGREE&&l>K.PI_OVER_TWO-K.RADIANS_PER_DEGREE)_=0;else{var A=MH;A.longitude=v,A.latitude=l,A.height=0;var T=UMt;T.longitude=v,T.latitude=h,T.height=0;var w=fVe;(!p(w)||w.ellipsoid!==a)&&(fVe=w=new Ey(void 0,void 0,a)),w.setEndPoints(A,T),_=w.interpolateUsingFraction(.5,MH).latitude}var S=MH;S.longitude=v,S.latitude=_,S.height=0;var P=a.cartographicToCartesian(S,QMt),M=MH;M.longitude=x,M.latitude=l;var L=a.cartographicToCartesian(M,GMt);M.longitude=m;var R=a.cartographicToCartesian(M,WMt);M.longitude=v;var O=a.cartographicToCartesian(M,jMt);M.latitude=h;var N=a.cartographicToCartesian(M,YMt);M.longitude=x;var k=a.cartographicToCartesian(M,qMt);M.longitude=m;var z=a.cartographicToCartesian(M,HMt);E.subtract(R,P,R),E.subtract(k,P,k),E.subtract(L,P,L),E.subtract(z,P,z),E.subtract(O,P,O),E.subtract(N,P,N);var W=a.geodeticSurfaceNormal(P,s.direction);E.negate(W,W);var j=E.cross(W,E.UNIT_Z,s.right);E.normalize(j,j);var q=E.cross(j,W,s.up),I;if(e.frustum instanceof En){var F=Math.max(E.distance(L,R),E.distance(k,z)),V=Math.max(E.distance(L,k),E.distance(R,z)),U,Q,J=e.frustum._offCenterFrustum.right/e.frustum._offCenterFrustum.top,oe=V*J;F>oe?(U=F,Q=U/J):(Q=V,U=oe),I=Math.max(U,Q)}else{var $=Math.tan(e.frustum.fovy*.5),re=e.frustum.aspectRatio*$;if(I=Math.max(Sd(W,q,R,$),Sd(W,q,k,$),Sd(W,q,L,$),Sd(W,q,z,$),Sd(W,q,O,$),Sd(W,q,N,$),Sd(W,j,R,re),Sd(W,j,k,re),Sd(W,j,L,re),Sd(W,j,z,re),Sd(W,j,O,re),Sd(W,j,N,re)),h<0&&l>0){var ne=MH;ne.longitude=m,ne.latitude=0,ne.height=0;var le=a.cartographicToCartesian(ne,dde);E.subtract(le,P,le),I=Math.max(I,Sd(W,q,le,$),Sd(W,j,le,re)),ne.longitude=x,le=a.cartographicToCartesian(ne,dde),E.subtract(le,P,le),I=Math.max(I,Sd(W,q,le,$),Sd(W,j,le,re))}}return E.add(P,E.multiplyByScalar(W,-I,dde),n)}function $Mt(e,r,n){var o=e._projection;r.west>r.east&&(r=He.MAX_VALUE);var a=e._actualTransform,s=e._actualInvTransform,l=KMt;l.longitude=r.east,l.latitude=r.north;var h=o.project(l,ZMt);Z.multiplyByPoint(a,h,h),Z.multiplyByPoint(s,h,h),l.longitude=r.west,l.latitude=r.south;var x=o.project(l,JMt);if(Z.multiplyByPoint(a,x,x),Z.multiplyByPoint(s,x,x),n.x=(h.x-x.x)*.5+x.x,n.y=(h.y-x.y)*.5+x.y,p(e.frustum.fovy)){var m=Math.tan(e.frustum.fovy*.5),v=e.frustum.aspectRatio*m;n.z=Math.max((h.x-x.x)/v,(h.y-x.y)/m)*.5}else{var _=h.x-x.x,A=h.y-x.y;n.z=Math.max(_,A)}return n}function iBt(e,r,n){var o=e._projection;r.west>r.east&&(r=He.MAX_VALUE);var a=eBt;a.longitude=r.east,a.latitude=r.north;var s=o.project(a,tBt);a.longitude=r.west,a.latitude=r.south;var l=o.project(a,rBt),h=Math.abs(s.x-l.x)*.5,x=Math.abs(s.y-l.y)*.5,m,v,_=e.frustum.right/e.frustum.top,A=x*_;return h>A?(m=h,v=m/_):(v=x,m=A),x=Math.max(2*m,2*v),n.x=(s.x-l.x)*.5+l.x,n.y=(s.y-l.y)*.5+l.y,a=o.unproject(n,a),a.height=x,n=o.project(a,n),n}function oBt(e,r,n,o){n=B(n,nt.WGS84);var a=e.getPickRay(r,nBt),s=Yn.rayEllipsoid(a,n);if(!!s){var l=s.start>0?s.start:s.stop;return Oi.getPoint(a,l,o)}}function sBt(e,r,n,o){var a=e.getPickRay(r,aBt),s=a.origin;s=E.fromElements(s.y,s.z,0,s);var l=n.unproject(s);if(!(l.latitude<-K.PI_OVER_TWO||l.latitude>K.PI_OVER_TWO))return n.ellipsoid.cartographicToCartesian(l,o)}function uBt(e,r,n,o){var a=e.getPickRay(r,lBt),s=-a.origin.x/a.direction.x;Oi.getPoint(a,s,o);var l=n.unproject(new E(o.y,o.z,0));if(!(l.latitude<-K.PI_OVER_TWO||l.latitude>K.PI_OVER_TWO||l.longitude<-Math.PI||l.longitude>Math.PI))return n.ellipsoid.cartographicToCartesian(l,o)}function hBt(e,r,n){var o=e._scene.canvas,a=o.clientWidth,s=o.clientHeight,l=Math.tan(e.frustum.fovy*.5),h=e.frustum.aspectRatio*l,x=e.frustum.near,m=2/a*r.x-1,v=2/s*(s-r.y)-1,_=e.positionWC;E.clone(_,n.origin);var A=E.multiplyByScalar(e.directionWC,x,cBt);E.add(_,A,A);var T=E.multiplyByScalar(e.rightWC,m*x*h,fBt),w=E.multiplyByScalar(e.upWC,v*x*l,xBt),S=E.add(A,T,n.direction);return E.add(S,w,S),E.subtract(S,_,S),E.normalize(S,S),n}function dBt(e,r,n){var o=e._scene.canvas,a=o.clientWidth,s=o.clientHeight,l=e.frustum;p(l._offCenterFrustum)&&(l=l._offCenterFrustum);var h=2/a*r.x-1;h*=(l.right-l.left)*.5;var x=2/s*(s-r.y)-1;x*=(l.top-l.bottom)*.5;var m=n.origin;return E.clone(e.position,m),E.multiplyByScalar(e.right,h,pQ),E.add(pQ,m,m),E.multiplyByScalar(e.up,x,pQ),E.add(pQ,m,m),E.clone(e.directionWC,n.direction),(e._mode===ze.COLUMBUS_VIEW||e._mode===ze.SCENE2D)&&E.fromElements(n.origin.z,n.origin.x,n.origin.y,n.origin),n}function gBt(e,r,n,o,a,s){var l=E.clone(r);n.y>o?l.y-=n.y-o:n.y<-o&&(l.y+=-o-n.y),n.z>a?l.z-=n.z-a:n.z<-a&&(l.z+=-a-n.z);function h(x){var m=E.lerp(r,l,x.time,new E);e.worldToCameraCoordinatesPoint(m,e.position)}return y(h,"updateCV"),{easingFunction:qu.EXPONENTIAL_OUT,startObject:{time:0},stopObject:{time:1},duration:s,update:h}}function CBt(e,r){var n=e.position,o=e.direction,a=e.worldToCameraCoordinatesVector(E.UNIT_X,_Bt),s=-E.dot(a,n)/E.dot(a,o),l=E.add(n,E.multiplyByScalar(o,s,xVe),xVe);e.cameraToWorldCoordinatesPoint(l,l),n=e.cameraToWorldCoordinatesPoint(e.position,yBt);var h=Math.tan(e.frustum.fovy*.5),x=e.frustum.aspectRatio*h,m=E.magnitude(E.subtract(n,l,ABt)),v=x*m,_=h*m,A=e._maxCoord.x,T=e._maxCoord.y,w=Math.max(v-A,A),S=Math.max(_-T,T);if(n.z<-w||n.z>w||n.y<-S||n.y>S){var P=l.y<-w||l.y>w,M=l.z<-S||l.z>S;if(P||M)return gBt(e,n,l,w,S,r)}}function wBt(e,r){var n=e.frustum,o=Math.tan(n.fovy*.5),a=n.aspectRatio*o;return Math.max(r/a,r/o)}function EBt(e,r){var n=e.frustum;p(n._offCenterFrustum)&&(n=n._offCenterFrustum);var o,a,s=n.right/n.top,l=r*s;return r>l?(o=r,a=o/s):(a=r,o=l),Math.max(o,a)*1.5}function IVe(e,r,n){p(n)||(n=gg.clone(In.DEFAULT_OFFSET));var o=e._scene.screenSpaceCameraController.minimumZoomDistance,a=e._scene.screenSpaceCameraController.maximumZoomDistance,s=n.range;if(!p(s)||s===0){var l=r.radius;l===0?n.range=bBt:e.frustum instanceof En||e._mode===ze.SCENE2D?n.range=EBt(e,l):n.range=wBt(e,l),n.range=K.clamp(n.range,o,a)}return n}function OBt(e,r){var n=r.radii,o=e.positionWC,a=E.multiplyComponents(r.oneOverRadii,o,hVe),s=E.magnitude(a),l=E.normalize(a,dVe),h,x;E.equalsEpsilon(l,E.UNIT_Z,K.EPSILON10)?(h=new E(0,1,0),x=new E(0,0,1)):(h=E.normalize(E.cross(E.UNIT_Z,l,mde),mde),x=E.normalize(E.cross(l,h,mVe),mVe));var m=Math.sqrt(E.magnitudeSquared(a)-1),v=E.multiplyByScalar(l,1/s,hVe),_=m/s,A=E.multiplyByScalar(h,_,dVe),T=E.multiplyByScalar(x,_,mde),w=E.add(v,T,BH[0]);E.subtract(w,A,w),E.multiplyComponents(n,w,w);var S=E.subtract(v,T,BH[1]);E.subtract(S,A,S),E.multiplyComponents(n,S,S);var P=E.subtract(v,T,BH[2]);E.add(P,A,P),E.multiplyComponents(n,P,P);var M=E.add(v,T,BH[3]);return E.add(M,A,M),E.multiplyComponents(n,M,M),BH}function vQ(e,r,n,o,a,s){pde.x=e,pde.y=r;var l=o.pickEllipsoid(pde,a,FBt);return p(l)?(OS[n]=a.cartesianToCartographic(l,OS[n]),1):(OS[n]=a.cartesianToCartographic(s[n],OS[n]),0)}function NBt(e,r){var n=e.distance,o=e.normal;r[0]=-2*o.x*o.x+1,r[1]=-2*o.y*o.x,r[2]=-2*o.z*o.x,r[3]=0,r[4]=-2*o.x*o.y,r[5]=-2*o.y*o.y+1,r[6]=-2*o.z*o.y,r[7]=0,r[8]=-2*o.x*o.z,r[9]=-2*o.y*o.z,r[10]=-2*o.z*o.z+1,r[11]=0,r[12]=-2*o.x*n,r[13]=-2*o.y*n,r[14]=-2*o.z*n,r[15]=1}var rMt,iMt,oMt,aMt,hQ,sMt,lMt,uMt,cMt,fMt,xde,gQ,_Q,hde,dQ,hMt,dMt,mMt,pMt,vMt,gMt,_Mt,yMt,AQ,_de,AMt,yde,Ade,yVe,EMt,bMt,SMt,vde,GF,IMt,mQ,PMt,DMt,MMt,BMt,RMt,LMt,OMt,cVe,FMt,NMt,zMt,VMt,kMt,MH,UMt,GMt,HMt,WMt,qMt,jMt,YMt,QMt,dde,XMt,fVe,KMt,ZMt,JMt,eBt,tBt,rBt,nBt,aBt,lBt,cBt,fBt,xBt,pQ,mBt,pBt,vBt,_Bt,xVe,yBt,ABt,TBt,Z0,bBt,SBt,IBt,PBt,DBt,MBt,BBt,RBt,LBt,hVe,dVe,mde,mVe,BH,pde,FBt,OS,zBt,VBt,gde,tB,yQ,ia,zC=Ee(()=>{hi();Fr();bt();Ci();Si();Ze();De();st();NC();Ii();VF();ti();kF();E0();Ql();jf();nr();to();Rr();wc();Ty();j2();Ja();Yc();Ni();Wn();fde();DH();zi();IH();mf();y(In,"Camera");In.TRANSFORM_2D=new Z(0,0,1,0,1,0,0,0,0,1,0,0,0,0,0,1);In.TRANSFORM_2D_INVERSE=Z.inverseTransformation(In.TRANSFORM_2D,new Z);In.DEFAULT_VIEW_RECTANGLE=He.fromDegrees(70,0,140,60);In.DEFAULT_VIEW_FACTOR=.5;In.DEFAULT_OFFSET=new gg(0,-K.PI_OVER_FOUR,0);y(pVe,"updateViewMatrix");y(tMt,"updateCameraDeltas");In.prototype.canPreloadFlight=function(){return p(this._currentFlight)&&this._mode!==ze.SCENE2D};In.prototype._updateCameraChanged=function(){var e=this;if(tMt(e),this._stateChanged=!1,e._changed.numberOfListeners!==0){var r=e.percentageChanged,n=e._refinePercentageChanged;if(e._mode===ze.SCENE2D){if(!p(e._changedFrustum)){e._changedPosition=E.clone(e.position,e._changedPosition),e._changedFrustum=e.frustum.clone();return}var o=e.position,a=e._changedPosition,s=e.frustum,l=e._changedFrustum,h=o.x+s.left,x=o.x+s.right,m=a.x+l.left,v=a.x+l.right,_=o.y+s.bottom,A=o.y+s.top,T=a.y+l.bottom,w=a.y+l.top,S=Math.max(h,m),P=Math.min(x,v),M=Math.max(_,T),L=Math.min(A,w),R;if(S>=P||M>=A)R=1;else{var O=l;h<m&&x>v&&_<T&&A>w&&(O=s),R=1-(P-S)*(L-M)/((O.right-O.left)*(O.top-O.bottom))}R>r&&(e._changed.raiseEvent(R),e._changedPosition=E.clone(e.position,e._changedPosition),e._changedFrustum=e.frustum.clone(e._changedFrustum));return}if(!p(e._changedDirection)){e._changedPosition=E.clone(e.positionWC,e._changedPosition),e._changedDirection=E.clone(e.directionWC,e._changedDirection);return}var N=K.acosClamped(E.dot(e.directionWC,e._changedDirection)),k;p(e.frustum.fovy)?k=N/(e.frustum.fovy*.5):k=N;var z=E.distance(e.positionWC,e._changedPosition),W=z/e.positionCartographic.height;(k>r||W>r)&&(e._changed.raiseEvent(Math.max(k,W)),e._changedPosition=E.clone(e.positionWC,e._changedPosition),e._changedDirection=E.clone(e.directionWC,e._changedDirection)),(k>n||W>n)&&(e._changed.raiseEvent(Math.max(k,W)),this._stateChanged=!0,e._changedPosition=E.clone(e.positionWC,e._changedPosition),e._changedDirection=E.clone(e.directionWC,e._changedDirection))}};rMt=new Z,iMt=new qe;In.prototype._adjustHeightForTerrain=function(){var e=this._scene,r=e.screenSpaceCameraController,n=r.enableCollisionDetection,o=r.minimumCollisionTerrainHeight,a=r.minimumZoomDistance;if(!(this._suspendTerrainAdjustment||!n)){var s=this._mode,l=e.globe;if(!(!p(l)||s===ze.SCENE2D||s===ze.MORPHING)){var h=l.ellipsoid,x=e.mapProjection,m,v;Z.equals(this.transform,Z.IDENTITY)||(m=Z.clone(this.transform,rMt),v=E.magnitude(this.position),this._setTransform(Z.IDENTITY));var _=iMt;s===ze.SCENE3D?h.cartesianToCartographic(this.position,_):x.unproject(this.position,_);var A=!1;if(_.height<o){var T=l.getHeight(_);p(T)&&(T+=a,_.height<T&&(_.height=T,s===ze.SCENE3D?h.cartographicToCartesian(_,this.position):x.project(_,this.position),A=!0))}p(m)&&(this._setTransform(m),A&&(E.normalize(this.position,this.position),E.negate(this.position,this.direction),E.multiplyByScalar(this.position,Math.max(v,a),this.position),E.normalize(this.direction,this.direction),E.cross(this.direction,this.up,this.right),E.cross(this.right,this.direction,this.up)))}}};y(nMt,"convertTransformForColumbusView");oMt=new qe,aMt=new E,hQ=new E,sMt=new Ce,lMt=new Ce,uMt=new Ce,cMt=new Ce,fMt=new Ce;y(xMt,"convertTransformFor2D");xde=new E;y(eh,"updateMembers");y(vVe,"getHeading");y(gVe,"getPitch");y(_Ve,"getRoll");gQ=new Z,_Q=new Z;Object.defineProperties(In.prototype,{transform:{get:function(){return this._transform}},inverseTransform:{get:function(){return eh(this),this._invTransform}},viewMatrix:{get:function(){return eh(this),this._viewMatrix}},inverseViewMatrix:{get:function(){return eh(this),this._invViewMatrix}},positionCartographic:{get:function(){return eh(this),this._positionCartographic}},positionWC:{get:function(){return eh(this),this._positionWC}},directionWC:{get:function(){return eh(this),this._directionWC}},upWC:{get:function(){return eh(this),this._upWC}},rightWC:{get:function(){return eh(this),this._rightWC}},heading:{get:function(){if(this._mode!==ze.MORPHING){var e=this._projection.ellipsoid,r=Z.clone(this._transform,gQ),n=Qt.eastNorthUpToFixedFrame(this.positionWC,e,_Q);this._setTransform(n);var o=vVe(this.direction,this.up);return this._setTransform(r),o}}},pitch:{get:function(){if(this._mode!==ze.MORPHING){var e=this._projection.ellipsoid,r=Z.clone(this._transform,gQ),n=Qt.eastNorthUpToFixedFrame(this.positionWC,e,_Q);this._setTransform(n);var o=gVe(this.direction);return this._setTransform(r),o}}},roll:{get:function(){if(this._mode!==ze.MORPHING){var e=this._projection.ellipsoid,r=Z.clone(this._transform,gQ),n=Qt.eastNorthUpToFixedFrame(this.positionWC,e,_Q);this._setTransform(n);var o=_Ve(this.direction,this.up,this.right);return this._setTransform(r),o}}},moveStart:{get:function(){return this._moveStart}},moveEnd:{get:function(){return this._moveEnd}},changed:{get:function(){return this._changed}},flyCircleLoop:{set:function(e){this._flyCircleLoop!==e&&(this._isResetFlyCircleParm=!0),this._flyCircleLoop=e},get:function(){return this._flyCircleLoop}},speedRatio:{get:function(){return this._speedRatio},set:function(e){this._speedRatio=e}},flyClampToGround:{set:function(e){this._flyClampToGround=e},get:function(){return this._flyClampToGround}},flyRelativeHeight:{set:function(e){this._flyRelativeHeight=e},get:function(){return this._flyRelativeHeight}},sensitivePositionRatio:{set:function(e){this._sensitivePositionRatio=K.clamp(e,0,1)},get:function(){return this._sensitivePositionRatio}},preciseSensitivePosition:{set:function(e){p(e)&&typeof e=="boolean"&&(this._preciseSensitivePosition=e)},get:function(){return this._preciseSensitivePosition}},sensitiveRegionRatio:{set:function(e){this._sensitiveRegionRatio=e},get:function(){return this._sensitiveRegionRatio}}});In.prototype._computeSensitivePosition=function(){if(this._scene.mode===ze.SCENE3D){var e=this._scene.canvas,r=this._scene.frameState;dQ.x=e.clientWidth/2,dQ.y=e.clientHeight/2;var n=void 0;if(p(this._scene.globe)&&this._preciseSensitivePosition&&(n=this._scene.pickPositionWorldCoordinates(dQ,hMt,!0),p(n)&&(this._sensitivePosition=n)),!p(n)){var o=this.getPickRay(dQ),a=nt.WGS84;p(r.averageTerrainHeight)&&r.averageTerrainHeight!=0&&(a=new nt(K.Radius+r.averageTerrainHeight,K.Radius+r.averageTerrainHeight,K.Radius+r.averageTerrainHeight));var s=Yn.rayEllipsoid(o,a);if(p(s)){hde.x=e.clientWidth/2,hde.y=0;var l=this.getPickRay(hde),h=Yn.rayEllipsoid(l,a);if(p(h))this._sensitivePosition=Oi.getPoint(o,s.start);else{var x=E.magnitude(this.position),m;x<K.Radius?m=K.PI_OVER_TWO:m=Math.asin(K.Radius/x);var v=new Oi(this.position,new E(-this.position.x,-this.position.y,-this.position.z)),_=new E(v.origin.x+v.direction.x,v.origin.y+v.direction.y,v.origin.z+v.direction.z),A=new E(o.origin.x+o.direction.x,o.origin.y+o.direction.y,o.origin.z+o.direction.z),T=E.distance(_,A),w=Math.asin(T*.5)*2,S=(this.frustum.fov*.5-(m-w))/this.frustum.fov,P=e.clientHeight*(1+S)*.5;if(!Number.isNaN(P)){var M=new de(e.clientWidth*.5,P),L=this.getPickRay(M),R=Yn.rayEllipsoid(L,a);p(R)?this._sensitivePosition=Oi.getPoint(L,R.start):this._sensitivePosition=void 0}}}else this._sensitivePosition=void 0}var O=r._quadtree;if(p(O)){var P=r.context.drawingBufferHeight,N=this.frustum.sseDenominator;if(p(this._sensitivePosition)){var k=E.distance(this.positionWC,this._sensitivePosition),z=O._tileProvider.getLevelMaximumGeometricError(0);this.zoomLevel=K.log2(z*P/(2*O.maximumScreenSpaceError*k*N))}}}};hde=new de,dQ=new de,hMt=new E;In.prototype.update=function(e){if(!p(e))throw new G("mode is required.");if(e===ze.SCENE2D&&!(this.frustum instanceof Pu))throw new G("An OrthographicOffCenterFrustum is required in 2D.");if((e===ze.SCENE3D||e===ze.COLUMBUS_VIEW)&&!(this.frustum instanceof Ya)&&!(this.frustum instanceof En))throw new G("A PerspectiveFrustum or OrthographicFrustum is required in 3D and Columbus view");var r=!1;if(e!==this._mode&&(this._mode=e,this._modeChanged=e!==ze.MORPHING,r=this._mode===ze.SCENE2D),r){var n=this._max2Dfrustum=this.frustum.clone();if(!(n instanceof Pu))throw new G("The camera frustum is expected to be orthographic for 2D camera control.");var o=2,a=n.top/n.right;n.right=this._maxCoord.x*o,n.left=-n.right,n.top=a*n.right,n.bottom=-n.top}this._mode===ze.SCENE2D&&CVe(this,this.position);var s=this._scene.globe,l=!p(s)||s._surface.tileProvider.ready&&s._surface._tileLoadQueueHigh.length===0&&s._surface._tileLoadQueueMedium.length===0&&s._surface._tileLoadQueueLow.length===0&&s._surface._debug.tilesWaitingForChildren===0;this._suspendTerrainAdjustment&&(this._suspendTerrainAdjustment=!l),l&&this._adjustHeightForTerrain(),this._isFlyCircle&&this._flyCircle(this._flyCircleCenter)};dMt=new E,mMt=new E,pMt=new E;In.prototype._setTransform=function(e){var r=E.clone(this.positionWC,dMt),n=E.clone(this.upWC,mMt),o=E.clone(this.directionWC,pMt);Z.clone(e,this._transform),this._transformChanged=!0,eh(this);var a=this._actualInvTransform;Z.multiplyByPoint(a,r,this.position),Z.multiplyByPointAsVector(a,o,this.direction),Z.multiplyByPointAsVector(a,n,this.up),E.cross(this.direction,this.up,this.right),eh(this)};vMt=new de,gMt=new Oi,_Mt=new E,yMt=new E;In.prototype._adjustOrthographicFrustum=function(e){if(this.frustum instanceof En&&!(!e&&this._positionCartographic.height<15e4)){if(!Z.equals(Z.IDENTITY,this.transform)){this.frustum.width=E.magnitude(this.position);return}var r=this._scene,n=r.globe,o,a;if(p(n)){var s=vMt;s.x=r.drawingBufferWidth/2,s.y=r.drawingBufferHeight/2;var l=this.getPickRay(s,gMt);if(o=n.pickWorldCoordinates(l,r,_Mt),r.pickPositionSupported&&(a=r.pickPositionWorldCoordinates(s,yMt)),p(o)&&p(a)){var h=p(a)?E.distance(a,this.positionWC):Number.POSITIVE_INFINITY,x=p(o)?E.distance(o,this.positionWC):Number.POSITIVE_INFINITY;this.frustum.width=Math.min(h,x)}else p(a)?this.frustum.width=E.distance(a,this.positionWC):p(o)&&(this.frustum.width=E.distance(o,this.positionWC))}if(!p(n)||!p(o)&&!p(a)){var m=Math.max(this.positionCartographic.height,0);this.frustum.width=m}}};AQ=new E,_de=new Z,AMt=new Z,yde=new hr,Ade=new We,yVe=new qe;y(CMt,"setView3D");y(TMt,"setViewCV");y(wMt,"setView2D");EMt=new E,bMt=new E,SMt=new E;y(AVe,"directionUpToHeadingPitchRoll");vde={destination:void 0,orientation:{direction:void 0,up:void 0,heading:void 0,pitch:void 0,roll:void 0},convert:void 0,endTransform:void 0},GF=new tn;In.prototype.setView=function(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.orientation,B.EMPTY_OBJECT),n=this._mode;if(n!==ze.MORPHING){p(e.endTransform)&&this._setTransform(e.endTransform);var o=B(e.convert,!0),a=B(e.destination,E.clone(this.positionWC,AQ));p(a)&&p(a.west)&&(a=this.getRectangleCameraCoordinates(a,AQ),o=!1),p(r.direction)&&(r=AVe(this,a,r,vde.orientation)),GF.heading=B(r.heading,0),GF.pitch=B(r.pitch,-K.PI_OVER_TWO),GF.roll=B(r.roll,0),this._suspendTerrainAdjustment=!0,n===ze.SCENE3D?CMt(this,a,GF):n===ze.SCENE2D?wMt(this,a,GF,o):TMt(this,a,GF,o)}};IMt=new E;In.prototype.flyHome=function(e){var r=this._mode;if(r===ze.MORPHING&&this._scene.completeMorph(),r===ze.SCENE2D)this.flyTo({destination:In.DEFAULT_VIEW_RECTANGLE,duration:e,endTransform:Z.IDENTITY});else if(r===ze.SCENE3D){var n=this.getRectangleCameraCoordinates(In.DEFAULT_VIEW_RECTANGLE),o=E.magnitude(n);o+=o*In.DEFAULT_VIEW_FACTOR,E.normalize(n,n),E.multiplyByScalar(n,o,n),this.flyTo({destination:n,duration:e,endTransform:Z.IDENTITY})}else if(r===ze.COLUMBUS_VIEW){var a=this._projection.ellipsoid.maximumRadius,s=new E(0,-1,1);s=E.multiplyByScalar(E.normalize(s,s),5*a,s),this.flyTo({destination:s,duration:e,orientation:{heading:0,pitch:-Math.acos(E.normalize(s,IMt).z),roll:0},endTransform:Z.IDENTITY,convert:!1})}};In.prototype.worldToCameraCoordinates=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new Ce),eh(this),Z.multiplyByVector(this._actualInvTransform,e,r)};In.prototype.worldToCameraCoordinatesPoint=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new E),eh(this),Z.multiplyByPoint(this._actualInvTransform,e,r)};In.prototype.worldToCameraCoordinatesVector=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new E),eh(this),Z.multiplyByPointAsVector(this._actualInvTransform,e,r)};In.prototype.cameraToWorldCoordinates=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new Ce),eh(this),Z.multiplyByVector(this._actualTransform,e,r)};In.prototype.cameraToWorldCoordinatesPoint=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new E),eh(this),Z.multiplyByPoint(this._actualTransform,e,r)};In.prototype.cameraToWorldCoordinatesVector=function(e,r){if(!p(e))throw new G("cartesian is required.");return p(r)||(r=new E),eh(this),Z.multiplyByPointAsVector(this._actualTransform,e,r)};y(CVe,"clampMove2D");mQ=new E;In.prototype.move=function(e,r){if(!p(e))throw new G("direction is required.");var n=this._scene;if(this._enableIndoorColliDetection){E.multiplyByScalar(e,Math.sign(r),mQ);var o=n.collideDetection(mQ);if(p(o)){var a=E.distance(this.position,o);if(a<1)return}}var s=this.position;E.multiplyByScalar(e,r,mQ),E.add(s,mQ,s),this._mode===ze.SCENE2D&&CVe(this,s),this._adjustOrthographicFrustum(!0)};In.prototype.moveForward=function(e){e=B(e,this.defaultMoveAmount),this._mode===ze.SCENE2D?CQ(this,e):this.move(this.direction,e)};In.prototype.moveBackward=function(e){e=B(e,this.defaultMoveAmount),this._mode===ze.SCENE2D?CQ(this,-e):this.move(this.direction,-e)};In.prototype.moveUp=function(e){e=B(e,this.defaultMoveAmount),this.move(this.up,e)};In.prototype.moveDown=function(e){e=B(e,this.defaultMoveAmount),this.move(this.up,-e)};In.prototype.moveRight=function(e){e=B(e,this.defaultMoveAmount),this.move(this.right,e)};In.prototype.moveLeft=function(e){e=B(e,this.defaultMoveAmount),this.move(this.right,-e)};In.prototype.lookLeft=function(e){e=B(e,this.defaultLookAmount),this._mode!==ze.SCENE2D&&this.look(this.up,-e)};In.prototype.lookRight=function(e){e=B(e,this.defaultLookAmount),this._mode!==ze.SCENE2D&&this.look(this.up,e)};In.prototype.lookUp=function(e){e=B(e,this.defaultLookAmount),this._mode!==ze.SCENE2D&&this.look(this.right,-e)};In.prototype.lookDown=function(e){e=B(e,this.defaultLookAmount),this._mode!==ze.SCENE2D&&this.look(this.right,e)};PMt=new hr,DMt=new We;In.prototype.look=function(e,r){if(!p(e))throw new G("axis is required.");var n=B(r,this.defaultLookAmount),o=hr.fromAxisAngle(e,-n,PMt),a=We.fromQuaternion(o,DMt),s=this.direction,l=this.up,h=this.right;We.multiplyByVector(a,s,s),We.multiplyByVector(a,l,l),We.multiplyByVector(a,h,h)};In.prototype.twistLeft=function(e){e=B(e,this.defaultLookAmount),this.look(this.direction,e)};In.prototype.twistRight=function(e){e=B(e,this.defaultLookAmount),this.look(this.direction,-e)};MMt=new hr,BMt=new We;In.prototype.rotate=function(e,r){if(!p(e))throw new G("axis is required.");var n=B(r,this.defaultRotateAmount),o=hr.fromAxisAngle(e,-n,MMt),a=We.fromQuaternion(o,BMt);We.multiplyByVector(a,this.position,this.position),We.multiplyByVector(a,this.direction,this.direction),We.multiplyByVector(a,this.up,this.up),E.cross(this.direction,this.up,this.right),E.cross(this.right,this.direction,this.up),this._adjustOrthographicFrustum(!1)};In.prototype.rotateDown=function(e){e=B(e,this.defaultRotateAmount),TVe(this,e)};In.prototype.rotateUp=function(e){e=B(e,this.defaultRotateAmount),TVe(this,-e)};RMt=new E,LMt=new E,OMt=new E,cVe=new E;y(TVe,"rotateVertical");In.prototype.rotateRight=function(e){e=B(e,this.defaultRotateAmount),wVe(this,-e)};In.prototype.rotateLeft=function(e){e=B(e,this.defaultRotateAmount),wVe(this,e)};y(wVe,"rotateHorizontal");y(CQ,"zoom2D");y(EVe,"zoom3D");In.prototype.zoomIn=function(e){e=B(e,this.defaultZoomAmount),this._mode===ze.SCENE2D?CQ(this,e):EVe(this,e)};In.prototype.zoomOut=function(e){e=B(e,this.defaultZoomAmount),this._mode===ze.SCENE2D?CQ(this,-e):EVe(this,-e)};In.prototype.getMagnitude=function(){if(this._mode===ze.SCENE3D)return E.magnitude(this.position);if(this._mode===ze.COLUMBUS_VIEW)return Math.abs(this.position.z);if(this._mode===ze.SCENE2D)return Math.max(this.frustum.right-this.frustum.left,this.frustum.top-this.frustum.bottom)};FMt=new Z;In.prototype.lookAt=function(e,r){if(!p(e))throw new G("target is required");if(!p(r))throw new G("offset is required");if(this._mode===ze.MORPHING)throw new G("lookAt is not supported while morphing.");var n=Qt.eastNorthUpToFixedFrame(e,nt.WGS84,FMt);this.lookAtTransform(n,r)};NMt=new E,zMt=new hr,VMt=new hr,kMt=new We;y(bVe,"offsetFromHeadingPitchRange");In.prototype.lookAtTransform=function(e,r){if(!p(e))throw new G("transform is required");if(this._mode===ze.MORPHING)throw new G("lookAtTransform is not supported while morphing.");if(this._setTransform(e),!!p(r)){var n;if(p(r.heading)?n=bVe(r.heading,r.pitch,r.range):n=r,this._mode===ze.SCENE2D){de.clone(de.ZERO,this.position),E.negate(n,this.up),this.up.z=0,E.magnitudeSquared(this.up)<K.EPSILON10&&E.clone(E.UNIT_Y,this.up),E.normalize(this.up,this.up),this._setTransform(Z.IDENTITY),E.negate(E.UNIT_Z,this.direction),E.cross(this.direction,this.up,this.right),E.normalize(this.right,this.right);var o=this.frustum,a=o.top/o.right;o.right=E.magnitude(n)*.5,o.left=-o.right,o.top=a*o.right,o.bottom=-o.top,this._setTransform(e);return}E.clone(n,this.position),E.negate(this.position,this.direction),E.normalize(this.direction,this.direction),E.cross(this.direction,E.UNIT_Z,this.right),E.magnitudeSquared(this.right)<K.EPSILON10&&E.clone(E.UNIT_X,this.right),E.normalize(this.right,this.right),E.cross(this.right,this.direction,this.up),E.normalize(this.up,this.up),this._adjustOrthographicFrustum(!0)}};MH=new qe,UMt=new qe,GMt=new E,HMt=new E,WMt=new E,qMt=new E,jMt=new E,YMt=new E,QMt=new E,dde=new E,XMt={direction:new E,right:new E,up:new E};y(Sd,"computeD");y(SVe,"rectangleCameraPosition3D");KMt=new qe,ZMt=new E,JMt=new E;y($Mt,"rectangleCameraPositionColumbusView");eBt=new qe,tBt=new E,rBt=new E;y(iBt,"rectangleCameraPosition2D");In.prototype.getRectangleCameraCoordinates=function(e,r){if(!p(e))throw new G("rectangle is required");var n=this._mode;if(p(r)||(r=new E),n===ze.SCENE3D)return SVe(this,e,r);if(n===ze.COLUMBUS_VIEW)return $Mt(this,e,r);if(n===ze.SCENE2D)return iBt(this,e,r)};nBt=new Oi;y(oBt,"pickEllipsoid3D");aBt=new Oi;y(sBt,"pickMap2D");lBt=new Oi;y(uBt,"pickMapColumbusView");In.prototype.pickEllipsoid=function(e,r,n){if(!p(e))throw new G("windowPosition is required.");var o=this._scene.canvas;if(!(o.clientWidth===0||o.clientHeight===0)){if(p(n)||(n=new E),r=B(r,nt.WGS84),this._mode===ze.SCENE3D)n=oBt(this,e,r,n);else if(this._mode===ze.SCENE2D)n=sBt(this,e,this._projection,n);else if(this._mode===ze.COLUMBUS_VIEW)n=uBt(this,e,this._projection,n);else return;return n}};cBt=new E,fBt=new E,xBt=new E;y(hBt,"getPickRayPerspective");pQ=new E;y(dBt,"getPickRayOrthographic");In.prototype.getPickRay=function(e,r){if(!p(e))throw new G("windowPosition is required.");p(r)||(r=new Oi);let n=this._scene.canvas;if(!(n.clientWidth<=0||n.clientHeight<=0)){var o=this.frustum;return p(o.aspectRatio)&&p(o.fov)&&p(o.near)?hBt(this,e,r):dBt(this,e,r)}};mBt=new E,pBt=new E;In.prototype.distanceToBoundingSphere=function(e){if(!p(e))throw new G("boundingSphere is required.");var r=E.subtract(this.positionWC,e.center,mBt),n=E.multiplyByScalar(this.directionWC,E.dot(r,this.directionWC),pBt);return Math.max(0,E.magnitude(n)-e.radius)};vBt=new de;In.prototype.getPixelSize=function(e,r,n){if(!p(e))throw new G("boundingSphere is required.");if(!p(r))throw new G("drawingBufferWidth is required.");if(!p(n))throw new G("drawingBufferHeight is required.");var o=this.distanceToBoundingSphere(e),a=this.frustum.getPixelDimensions(r,n,o,this._scene.pixelRatio,vBt);return Math.max(a.x,a.y)};y(gBt,"createAnimationTemplateCV");_Bt=new E,xVe=new E,yBt=new E,ABt=new E;y(CBt,"createAnimationCV");In.prototype.createCorrectPositionTween=function(e){if(!p(e))throw new G("duration is required.");if(this._mode===ze.COLUMBUS_VIEW)return CBt(this,e)};TBt=new E,Z0={destination:void 0,heading:void 0,pitch:void 0,roll:void 0,duration:void 0,complete:void 0,cancel:void 0,endTransform:void 0,maximumHeight:void 0,easingFunction:void 0};In.prototype.cancelFlight=function(){p(this._currentFlight)&&(this._currentFlight.cancelTween(),this._currentFlight=void 0)};In.prototype.flyTo=function(e){e=B(e,B.EMPTY_OBJECT);var r=e.destination;if(!p(r))throw new G("destination is required.");var n=this._mode;if(n!==ze.MORPHING){this.cancelFlight();var o=B(e.orientation,B.EMPTY_OBJECT);if(p(o.direction)&&(o=AVe(this,r,o,vde.orientation)),p(e.duration)&&e.duration<=0){var a=vde;a.destination=e.destination,a.orientation.heading=o.heading,a.orientation.pitch=o.pitch,a.orientation.roll=o.roll,a.convert=e.convert,a.endTransform=e.endTransform,this.setView(a),typeof e.complete=="function"&&e.complete();return}var s=p(r.west);s&&(r=this.getRectangleCameraCoordinates(r,TBt));var l=this,h;Z0.destination=r,Z0.heading=o.heading,Z0.pitch=o.pitch,Z0.roll=o.roll,Z0.duration=e.duration,Z0.complete=function(){h===l._currentFlight&&(l._currentFlight=void 0),p(e.complete)&&e.complete()},Z0.cancel=e.cancel,Z0.endTransform=e.endTransform,Z0.convert=s?!1:e.convert,Z0.maximumHeight=e.maximumHeight,Z0.pitchAdjustHeight=e.pitchAdjustHeight,Z0.flyOverLongitude=e.flyOverLongitude,Z0.flyOverLongitudeWeight=e.flyOverLongitudeWeight,Z0.easingFunction=e.easingFunction,Z0.headingFree=B(e.headingFree,!1),Z0.pitchFree=B(e.pitchFree,!1),Z0.altitudeFree=B(e.altitudeFree,!1),Z0.directTurning=B(e.directTurning,!1),Z0.interpolationMode=B(e.interpolationMode,u1.NONE),Z0.catmullRomSpline=e.catmullRomSpline,Z0.preStopIndex=e.preStopIndex,Z0.flyClampToGround=this._flyClampToGround,Z0.flyRelativeHeight=this._flyRelativeHeight;var x=this._scene,m=xQ.createTween(x,Z0);if(m.duration===0){typeof m.complete=="function"&&m.complete();return}h=x.tweens.add(m),this._currentFlight=h;var v=this._scene.preloadFlightCamera;this._mode!==ze.SCENE2D&&(p(v)||(v=In.clone(this)),v.setView({destination:r,orientation:o}),this._scene.preloadFlightCullingVolume=v.frustum.computeCullingVolume(v.positionWC,v.directionWC,v.upWC))}};y(wBt,"distanceToBoundingSphere3D");y(EBt,"distanceToBoundingSphere2D");bBt=100;y(IVe,"adjustBoundingSphereOffset");In.prototype.viewBoundingSphere=function(e,r){if(!p(e))throw new G("boundingSphere is required.");if(this._mode===ze.MORPHING)throw new G("viewBoundingSphere is not supported while morphing.");r=IVe(this,e,r),this.lookAt(e.center,r)};SBt=new Z,IBt=new E,PBt=new E,DBt=new E,MBt=new E,BBt=new Ce,RBt=new hr,LBt=new We;In.prototype.flyToBoundingSphere=function(e,r){if(!p(e))throw new G("boundingSphere is required.");r=B(r,B.EMPTY_OBJECT);var n=this._mode===ze.SCENE2D||this._mode===ze.COLUMBUS_VIEW;this._setTransform(Z.IDENTITY);var o=IVe(this,e,r.offset),a;n?a=E.multiplyByScalar(E.UNIT_Z,o.range,IBt):a=bVe(o.heading,o.pitch,o.range);var s=Qt.eastNorthUpToFixedFrame(e.center,nt.WGS84,SBt);Z.multiplyByPoint(s,a,a);var l,h;if(!n){if(l=E.subtract(e.center,a,PBt),E.normalize(l,l),h=Z.multiplyByPointAsVector(s,E.UNIT_Z,DBt),1-Math.abs(E.dot(l,h))<K.EPSILON6){var x=hr.fromAxisAngle(l,o.heading,RBt),m=We.fromQuaternion(x,LBt);E.fromCartesian4(Z.getColumn(s,1,BBt),h),We.multiplyByVector(m,h,h)}var v=E.cross(l,h,MBt);E.cross(v,l,h),E.normalize(h,h)}this.flyTo({destination:a,orientation:{direction:l,up:h},duration:r.duration,complete:r.complete,cancel:r.cancel,endTransform:r.endTransform,maximumHeight:r.maximumHeight,easingFunction:r.easingFunction,flyOverLongitude:r.flyOverLongitude,flyOverLongitudeWeight:r.flyOverLongitudeWeight,pitchAdjustHeight:r.pitchAdjustHeight})};hVe=new E,dVe=new E,mde=new E,mVe=new E,BH=[new E,new E,new E,new E];y(OBt,"computeHorizonQuad");pde=new de,FBt=new E,OS=[new qe,new qe,new qe,new qe];y(vQ,"addToResult");In.prototype.computeViewRectangle=function(e,r){e=B(e,nt.WGS84);var n=this.frustum.computeCullingVolume(this.positionWC,this.directionWC,this.upWC),o=new Ue(E.ZERO,e.maximumRadius),a=n.computeVisibility(o);if(a!==wi.OUTSIDE){var s=this._scene.canvas,l=s.clientWidth,h=s.clientHeight,x=0,m=OBt(this,e);if(x+=vQ(0,0,0,this,e,m),x+=vQ(0,h,1,this,e,m),x+=vQ(l,h,2,this,e,m),x+=vQ(l,0,3,this,e,m),x<2)return He.MAX_VALUE;r=He.fromCartographicArray(OS,r);for(var v=0,_=OS[3].longitude,A=0;A<4;++A){var T=OS[A].longitude,w=Math.abs(T-_);w>K.PI?v+=K.TWO_PI-w:v+=w,_=T}return K.equalsEpsilon(Math.abs(v),K.TWO_PI,K.EPSILON9)&&(r.west=-K.PI,r.east=K.PI,OS[0].latitude>=0?r.north=K.PI_OVER_TWO:r.south=-K.PI_OVER_TWO),r}};In.prototype.switchToPerspectiveFrustum=function(){if(!(this._mode===ze.SCENE2D||this.frustum instanceof Ya)){var e=this._scene;this.frustum=new Ya,this.frustum.aspectRatio=e.drawingBufferWidth/e.drawingBufferHeight,this.frustum.fov=K.toRadians(60)}};In.prototype.switchToOrthographicFrustum=function(){if(!(this._mode===ze.SCENE2D||this.frustum instanceof En)){var e=this._scene;this.frustum=new En,this.frustum.aspectRatio=e.drawingBufferWidth/e.drawingBufferHeight,this.frustum.width=E.magnitude(this.position);var r=this.frustum.projectionMatrix;p(r)&&this._adjustOrthographicFrustum(!0)}};In.clone=function(e,r){return p(r)||(r=new In(e._scene)),E.clone(e.position,r.position),E.clone(e.direction,r.direction),E.clone(e.up,r.up),E.clone(e.right,r.right),Z.clone(e._transform,r.transform),r._mode=e._mode,r._transformChanged=!0,r.frustum=e.frustum.clone(),r};y(NBt,"updateReflectMatrix");In.prototype.enableReflection=function(e){this.bReflect=!0,NBt(e,this._reflectMatrix),eh(this),this.frustum.reflect=!0,this.frustum.clipPlane=e,this.frustum.currentViewMatrix=this._viewMatrix};In.prototype.disableReflection=function(){this.bReflect=!1,this.frustum.reflect=!1,this.frustum instanceof Ya&&this.frustum.resetProjectionMatrix(),eh(this)};zBt=new Z,VBt=new Z,gde=0,tB=0,yQ=!1;In.prototype.flyCircle=function(e){gde=0,tB=0,yQ=!1,this._isFlyCircle=!1,this._flyCircle(e)};In.prototype._flyCircle=function(e){if(!this._flyCircleLoop&&yQ){tB=0;return}(!this._isFlyCircle||this._isResetFlyCircleParm)&&(gde=jo(),tB=0,yQ=!1,this._flyCircleCenter=E.clone(e),this._isFlyCircle=!0,this._isResetFlyCircleParm=!1);var r=this.constrainedAxis,n=Z.clone(this.transform,VBt),o=Qt.eastNorthUpToFixedFrame(e,nt.WGS84,zBt);this._setTransform(o),this.constrainedAxis=E.UNIT_Z;var a=jo(),s=.01;s*=this._speedRatio;var l=Math.PI*2-Math.abs(tB);tB<0&&(l*=-1),!this._flyCircleLoop&&Math.abs(tB)>=Math.PI*2&&(s=l,yQ=!0),tB+=s,this.rotateRight(-s),gde=a,this.constrainedAxis=r,this._setTransform(n)};In.prototype.stopFlyCircle=function(){this._isFlyCircle=!1};ia=In});var kBt,Du,Y2=Ee(()=>{co();kBt={FRONT:Se.FRONT,BACK:Se.BACK,FRONT_AND_BACK:Se.FRONT_AND_BACK},Du=Object.freeze(kBt)});function gf(e){e=B(e,B.EMPTY_OBJECT),this.position=B(e.position,!1),this.normal=B(e.normal,!1),this.st=B(e.st,!1),this.bitangent=B(e.bitangent,!1),this.tangent=B(e.tangent,!1),this.color=B(e.color,!1)}var Er,pl=Ee(()=>{Ze();De();st();y(gf,"VertexFormat");gf.POSITION_ONLY=Object.freeze(new gf({position:!0}));gf.POSITION_AND_NORMAL=Object.freeze(new gf({position:!0,normal:!0}));gf.POSITION_NORMAL_AND_ST=Object.freeze(new gf({position:!0,normal:!0,st:!0}));gf.POSITION_AND_ST=Object.freeze(new gf({position:!0,st:!0}));gf.POSITION_AND_COLOR=Object.freeze(new gf({position:!0,color:!0}));gf.ALL=Object.freeze(new gf({position:!0,normal:!0,st:!0,tangent:!0,bitangent:!0}));gf.DEFAULT=gf.POSITION_NORMAL_AND_ST;gf.packedLength=6;gf.pack=function(e,r,n){if(!p(e))throw new G("value is required");if(!p(r))throw new G("array is required");return n=B(n,0),r[n++]=e.position?1:0,r[n++]=e.normal?1:0,r[n++]=e.st?1:0,r[n++]=e.tangent?1:0,r[n++]=e.bitangent?1:0,r[n]=e.color?1:0,r};gf.unpack=function(e,r,n){if(!p(e))throw new G("array is required");return r=B(r,0),p(n)||(n=new gf),n.position=e[r++]===1,n.normal=e[r++]===1,n.st=e[r++]===1,n.tangent=e[r++]===1,n.bitangent=e[r++]===1,n.color=e[r]===1,n};gf.clone=function(e,r){if(!!p(e))return p(r)||(r=new gf),r.position=e.position,r.normal=e.normal,r.st=e.st,r.tangent=e.tangent,r.bitangent=e.bitangent,r.color=e.color,r};Er=gf});var wde,RVe=Ee(()=>{wde=`#ifdef GL_OES_standard_derivatives
#extension GL_OES_standard_derivatives : enable
#endif
varying vec3 v_positionEC;
varying vec3 v_normalEC;
varying vec4 v_color;

void main()
{
    vec3 positionToEyeEC = -v_positionEC;

    vec3 normalEC = normalize(v_normalEC);
#ifdef FACE_FORWARD
    normalEC = faceforward(normalEC, vec3(0.0, 0.0, 1.0), -normalEC);
#endif

    vec4 color = czm_gammaCorrect(v_color);

    czm_materialInput materialInput;
    materialInput.normalEC = normalEC;
    materialInput.positionToEyeEC = positionToEyeEC;
    czm_material material = czm_getDefaultMaterial(materialInput);
    material.diffuse = color.rgb;
    material.alpha = color.a;

    gl_FragColor = czm_phong(normalize(positionToEyeEC), material, czm_lightDirectionEC);
}
`});var LVe,OVe=Ee(()=>{LVe=`attribute vec3 position;
attribute vec3 normal;
attribute float batchId;
attribute vec4 color;

varying vec3 v_positionEC;
varying vec3 v_normalEC;
varying vec4 v_color;

void main()
{
    vec4 p = vec4(position, 1.0);

    v_positionEC = (czm_modelView * p).xyz;      // position in eye coordinates
    v_normalEC = czm_normal * normal;            // normal in eye coordinates
    v_color = color;

    gl_Position = czm_modelViewProjection * p;
}
`});var FVe,NVe=Ee(()=>{FVe=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec3 normal;
attribute vec4 color;
attribute float batchId;

varying vec3 v_positionEC;
varying vec3 v_normalEC;
varying vec4 v_color;

void main()
{
    vec4 p = czm_computePosition();

    v_positionEC = (czm_modelViewRelativeToEye * p).xyz;      // position in eye coordinates
    v_normalEC = czm_normal * normal;                         // normal in eye coordinates
    v_color = color;

    gl_Position = czm_modelViewProjectionRelativeToEye * p;
}
`});var OH,Ede=Ee(()=>{OH=`varying vec4 v_color;

void main()
{
    gl_FragColor = czm_gammaCorrect(v_color);
}
`});var bde,zVe=Ee(()=>{bde=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec4 color;
attribute float batchId;

varying vec4 v_color;

void main()
{
    vec4 p = czm_computePosition();

    v_color = color;

    gl_Position = czm_modelViewProjectionRelativeToEye * p;
}
`});var iRt,Ts,VC=Ee(()=>{co();iRt={ADD:Se.FUNC_ADD,SUBTRACT:Se.FUNC_SUBTRACT,REVERSE_SUBTRACT:Se.FUNC_REVERSE_SUBTRACT,MIN:Se.MIN,MAX:Se.MAX},Ts=Object.freeze(iRt)});var nRt,ao,kC=Ee(()=>{co();nRt={ZERO:Se.ZERO,ONE:Se.ONE,SOURCE_COLOR:Se.SRC_COLOR,ONE_MINUS_SOURCE_COLOR:Se.ONE_MINUS_SRC_COLOR,DESTINATION_COLOR:Se.DST_COLOR,ONE_MINUS_DESTINATION_COLOR:Se.ONE_MINUS_DST_COLOR,SOURCE_ALPHA:Se.SRC_ALPHA,ONE_MINUS_SOURCE_ALPHA:Se.ONE_MINUS_SRC_ALPHA,DESTINATION_ALPHA:Se.DST_ALPHA,ONE_MINUS_DESTINATION_ALPHA:Se.ONE_MINUS_DST_ALPHA,CONSTANT_COLOR:Se.CONSTANT_COLOR,ONE_MINUS_CONSTANT_COLOR:Se.ONE_MINUS_CONSTANT_COLOR,CONSTANT_ALPHA:Se.CONSTANT_ALPHA,ONE_MINUS_CONSTANT_ALPHA:Se.ONE_MINUS_CONSTANT_ALPHA,SOURCE_ALPHA_SATURATE:Se.SRC_ALPHA_SATURATE},ao=Object.freeze(nRt)});var oRt,pi,va=Ee(()=>{VC();kC();oRt={DISABLED:Object.freeze({enabled:!1}),ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:Ts.ADD,equationAlpha:Ts.ADD,functionSourceRgb:ao.SOURCE_ALPHA,functionSourceAlpha:ao.ONE,functionDestinationRgb:ao.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:ao.ONE_MINUS_SOURCE_ALPHA}),PRE_MULTIPLIED_ALPHA_BLEND:Object.freeze({enabled:!0,equationRgb:Ts.ADD,equationAlpha:Ts.ADD,functionSourceRgb:ao.ONE,functionSourceAlpha:ao.ONE,functionDestinationRgb:ao.ONE_MINUS_SOURCE_ALPHA,functionDestinationAlpha:ao.ONE_MINUS_SOURCE_ALPHA}),ADDITIVE_BLEND:Object.freeze({enabled:!0,equationRgb:Ts.ADD,equationAlpha:Ts.ADD,functionSourceRgb:ao.SOURCE_ALPHA,functionSourceAlpha:ao.ONE,functionDestinationRgb:ao.ONE,functionDestinationAlpha:ao.ONE})},pi=Object.freeze(oRt)});function qF(e){e=B(e,B.EMPTY_OBJECT),this.material=e.material,this.translucent=B(e.translucent,!0),this._vertexShaderSource=e.vertexShaderSource,this._fragmentShaderSource=e.fragmentShaderSource,this._renderState=e.renderState,this._closed=B(e.closed,!1)}var Ml,zS=Ee(()=>{c0();Ua();Ze();De();va();Y2();y(qF,"Appearance");Object.defineProperties(qF.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}}});qF.prototype.getFragmentShaderSource=function(){var e=[];return this.flat&&e.push("#define FLAT"),this.faceForward&&e.push("#define FACE_FORWARD"),p(this.material)&&e.push(this.material.shaderSource),e.push(this.fragmentShaderSource),e.join(`
`)};qF.prototype.isTranslucent=function(){return p(this.material)&&this.material.isTranslucent()||!p(this.material)&&this.translucent};qF.prototype.getRenderState=function(){var e=this.isTranslucent(),r=Tn(this.renderState,!1);return e?(r.depthMask=!1,r.blending=pi.ALPHA_BLEND):r.depthMask=!0,r};qF.getDefaultRenderState=function(e,r,n){var o={depthTest:{enabled:!0}};return e&&(o.depthMask=!1,o.blending=pi.ALPHA_BLEND),r&&(o.cull={enabled:!0,face:Du.BACK}),p(n)&&(o=ei(n,o,!0)),o};Ml=qF});var VVe,kVe=Ee(()=>{VVe=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec3 position03DHigh;
attribute vec3 position03DLow;
attribute vec3 position13DHigh;
attribute vec3 position13DLow;
attribute vec2 sideness;
#ifdef APPLY_SIDENESS
uniform float uLineWidth;
attribute float batchId1;
#endif

attribute vec4 color;
attribute float batchId;

varying vec4 v_color;

#ifdef APPLY_SIDENESS
    vec4 resolvePosition(vec4 viewPosV0, vec4 viewPosV1, vec2 sidenessNorm) {
        vec2 sideness = sidenessNorm * 2.0 - 1.0;
        vec4 viewPos = mix(viewPosV0, viewPosV1, sidenessNorm.y);
        viewPos.z = viewPos.z * 0.995;
        vec4 projPosV0 = czm_projection * viewPosV0;
        vec4 projPosV1 = czm_projection * viewPosV1;
        vec4 projPos = czm_projection * viewPos;
        vec3 screenSpaceLineNDC = (projPosV1.xyz / projPosV1.w - projPosV0.xyz / projPosV0.w);
        vec2 uNDCToPixel = vec2(czm_viewport.z / 2.0, czm_viewport.w / 2.0);
        vec2 screenSpaceLinePixels = screenSpaceLineNDC.xy * uNDCToPixel;
        float lineLengthPixels = length(screenSpaceLinePixels);
        float dzPerPixel = screenSpaceLineNDC.z / lineLengthPixels;
        vec2 screenSpaceDirection = screenSpaceLinePixels / lineLengthPixels;
        vec2 perpendicularScreenSpaceDirection = vec2(screenSpaceDirection.y, -screenSpaceDirection.x) * sideness.x;
        vec2 uPixelToNDC = vec2(2.0 / czm_viewport.z, 2.0 / czm_viewport.w);
        float halfLineWidth = max(uLineWidth, 1.0) * 0.5;
        vec2 halfLineWidthNDC = halfLineWidth * uPixelToNDC;
        vec2 ndcOffset = screenSpaceDirection * halfLineWidthNDC + perpendicularScreenSpaceDirection * halfLineWidthNDC;
        projPos.xy += ndcOffset * projPos.w;
        projPos.z += (dzPerPixel * halfLineWidth) * sideness.y * projPos.w;
        return projPos;
    }
#endif
void main()
{
    #ifdef APPLY_SIDENESS
        vec4 p0 = czm_computePosition0();
        vec4 p1 = czm_computePosition1();
        vec4 viewPosV0 = czm_inverseProjection * czm_modelViewProjectionRelativeToEye * p0;
        vec4 viewPosV1 = czm_inverseProjection * czm_modelViewProjectionRelativeToEye * p1;
        gl_Position = resolvePosition(viewPosV0, viewPosV1, sideness) * float(batchId1 == batchId);
    #else
        vec4 p = czm_computePosition();
        gl_Position = czm_modelViewProjectionRelativeToEye * p;
    #endif
    v_color = color;
}
`});function UC(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.translucent,!0),n=B(e.closed,!1),o=B(e.flat,!1),a=B(e.materialSupport,UC.MaterialSupport.BASIC),s=a.vertexShaderSource,l=a.fragmentShaderSource,h=a.vertexFormat;o&&(s=bde,e.hasSideness&&(s=VVe),l=OH,h=UC.FLAT_VERTEX_FORMAT),this.material=void 0,this.translucent=r,this._vertexShaderSource=B(e.vertexShaderSource,s),this._fragmentShaderSource=B(e.fragmentShaderSource,l),this._renderState=Ml.getDefaultRenderState(r,n,e.renderState),this._closed=n,this._vertexFormat=h,this._flat=o,this._faceForward=B(e.faceForward,!n)}var Zn,Mu=Ee(()=>{Ze();pl();RVe();OVe();NVe();Ede();zVe();zS();kVe();y(UC,"PerInstanceColorAppearance");Object.defineProperties(UC.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}},flat:{get:function(){return this._flat}},faceForward:{get:function(){return this._faceForward}}});UC.VERTEX_FORMAT=Er.POSITION_AND_NORMAL;UC.FLAT_VERTEX_FORMAT=Er.POSITION_ONLY;UC.prototype.getFragmentShaderSource=Ml.prototype.getFragmentShaderSource;UC.prototype.isTranslucent=Ml.prototype.isTranslucent;UC.prototype.getRenderState=Ml.prototype.getRenderState;UC.MaterialSupport={BASIC:Object.freeze({vertexFormat:Er.POSITION_AND_NORMAL,vertexShaderSource:FVe,fragmentShaderSource:wde}),FLAT:Object.freeze({vertexFormat:Er.POSITION_ONLY,vertexShaderSource:bde,fragmentShaderSource:OH}),FLOAT_POSITION:Object.freeze({vertexFormat:Er.POSITION_AND_NORMAL,vertexShaderSource:LVe,fragmentShaderSource:wde})};Zn=UC});function GC(){this.high=E.clone(E.ZERO),this.low=E.clone(E.ZERO)}var c1,Sde,Pn,Ax=Ee(()=>{bt();cr();De();y(GC,"EncodedCartesian3");GC.encode=function(e,r){X.typeOf.number("value",e),p(r)||(r={high:0,low:0});var n;return e>=0?(n=Math.floor(e/65536)*65536,r.high=n,r.low=e-n):(n=Math.floor(-e/65536)*65536,r.high=-n,r.low=e+n),r};c1={high:0,low:0};GC.fromCartesian=function(e,r){X.typeOf.object("cartesian",e),p(r)||(r=new GC);var n=r.high,o=r.low;return GC.encode(e.x,c1),n.x=c1.high,o.x=c1.low,GC.encode(e.y,c1),n.y=c1.high,o.y=c1.low,GC.encode(e.z,c1),n.z=c1.high,o.z=c1.low,r};Sde=new GC;GC.writeElements=function(e,r,n){X.defined("cartesianArray",r),X.typeOf.number("index",n),X.typeOf.number.greaterThanOrEquals("index",n,0),GC.fromCartesian(e,Sde);var o=Sde.high,a=Sde.low;r[n]=o.x,r[n+1]=o.y,r[n+2]=o.z,r[n+3]=a.x,r[n+4]=a.y,r[n+5]=a.z};Pn=GC});function aRt(e,r){if(!p(e))throw new G("array is required.");if(!p(r)||r<1)throw new G("numberOfArrays must be greater than 0.");for(var n=[],o=e.length,a=0;a<o;){var s=Math.ceil((o-a)/r--);n.push(e.slice(a,a+s)),a+=s}return n}var bQ,Ide=Ee(()=>{De();st();y(aRt,"subdivideArray");bQ=aRt});var UVe=X7((jF,YF)=>{/*! https://mths.be/punycode v1.4.0 by @mathias */(function(e){var r=typeof jF=="object"&&jF&&!jF.nodeType&&jF,n=typeof YF=="object"&&YF&&!YF.nodeType&&YF,o=typeof global=="object"&&global;(o.global===o||o.window===o||o.self===o)&&(e=o);var a,s=2147483647,l=36,h=1,x=26,m=38,v=700,_=72,A=128,T="-",w=/^xn--/,S=/[^\x20-\x7E]/,P=/[\x2E\u3002\uFF0E\uFF61]/g,M={overflow:"Overflow: input needs wider integers to process","not-basic":"Illegal input >= 0x80 (not a basic code point)","invalid-input":"Invalid input"},L=l-h,R=Math.floor,O=String.fromCharCode,N;function k($){throw new RangeError(M[$])}y(k,"error");function z($,re){for(var ne=$.length,le=[];ne--;)le[ne]=re($[ne]);return le}y(z,"map");function W($,re){var ne=$.split("@"),le="";ne.length>1&&(le=ne[0]+"@",$=ne[1]),$=$.replace(P,".");var ue=$.split("."),ie=z(ue,re).join(".");return le+ie}y(W,"mapDomain");function j($){for(var re=[],ne=0,le=$.length,ue,ie;ne<le;)ue=$.charCodeAt(ne++),ue>=55296&&ue<=56319&&ne<le?(ie=$.charCodeAt(ne++),(ie&64512)==56320?re.push(((ue&1023)<<10)+(ie&1023)+65536):(re.push(ue),ne--)):re.push(ue);return re}y(j,"ucs2decode");function q($){return z($,function(re){var ne="";return re>65535&&(re-=65536,ne+=O(re>>>10&1023|55296),re=56320|re&1023),ne+=O(re),ne}).join("")}y(q,"ucs2encode");function I($){return $-48<10?$-22:$-65<26?$-65:$-97<26?$-97:l}y(I,"basicToDigit");function F($,re){return $+22+75*($<26)-((re!=0)<<5)}y(F,"digitToBasic");function V($,re,ne){var le=0;for($=ne?R($/v):$>>1,$+=R($/re);$>L*x>>1;le+=l)$=R($/L);return R(le+(L+1)*$/($+m))}y(V,"adapt");function U($){var re=[],ne=$.length,le,ue=0,ie=A,ce=_,he,_e,Ae,be,pe,ge,Te,Pe,ye;for(he=$.lastIndexOf(T),he<0&&(he=0),_e=0;_e<he;++_e)$.charCodeAt(_e)>=128&&k("not-basic"),re.push($.charCodeAt(_e));for(Ae=he>0?he+1:0;Ae<ne;){for(be=ue,pe=1,ge=l;Ae>=ne&&k("invalid-input"),Te=I($.charCodeAt(Ae++)),(Te>=l||Te>R((s-ue)/pe))&&k("overflow"),ue+=Te*pe,Pe=ge<=ce?h:ge>=ce+x?x:ge-ce,!(Te<Pe);ge+=l)ye=l-Pe,pe>R(s/ye)&&k("overflow"),pe*=ye;le=re.length+1,ce=V(ue-be,le,be==0),R(ue/le)>s-ie&&k("overflow"),ie+=R(ue/le),ue%=le,re.splice(ue++,0,ie)}return q(re)}y(U,"decode");function Q($){var re,ne,le,ue,ie,ce,he,_e,Ae,be,pe,ge=[],Te,Pe,ye,ve;for($=j($),Te=$.length,re=A,ne=0,ie=_,ce=0;ce<Te;++ce)pe=$[ce],pe<128&&ge.push(O(pe));for(le=ue=ge.length,ue&&ge.push(T);le<Te;){for(he=s,ce=0;ce<Te;++ce)pe=$[ce],pe>=re&&pe<he&&(he=pe);for(Pe=le+1,he-re>R((s-ne)/Pe)&&k("overflow"),ne+=(he-re)*Pe,re=he,ce=0;ce<Te;++ce)if(pe=$[ce],pe<re&&++ne>s&&k("overflow"),pe==re){for(_e=ne,Ae=l;be=Ae<=ie?h:Ae>=ie+x?x:Ae-ie,!(_e<be);Ae+=l)ve=_e-be,ye=l-be,ge.push(O(F(be+ve%ye,0))),_e=R(ve/ye);ge.push(O(F(_e,0))),ie=V(ne,Pe,le==ue),ne=0,++le}++ne,++re}return ge.join("")}y(Q,"encode");function J($){return W($,function(re){return w.test(re)?U(re.slice(4).toLowerCase()):re})}y(J,"toUnicode");function oe($){return W($,function(re){return S.test(re)?"xn--"+Q(re):re})}if(y(oe,"toASCII"),a={version:"1.3.2",ucs2:{decode:j,encode:q},decode:U,encode:Q,toASCII:oe,toUnicode:J},typeof define=="function"&&typeof define.amd=="object"&&define.amd)define("punycode",function(){return a});else if(r&&n)if(YF.exports==r)n.exports=a;else for(N in a)a.hasOwnProperty(N)&&(r[N]=a[N]);else e.punycode=a})(jF)});var HVe=X7((GVe,SQ)=>{/*!
 * URI.js - Mutating URLs
 * IPv6 Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,r){"use strict";typeof SQ=="object"&&SQ.exports?SQ.exports=r():typeof define=="function"&&define.amd?define(r):e.IPv6=r(e)})(GVe,function(e){"use strict";var r=e&&e.IPv6;function n(a){var s=a.toLowerCase(),l=s.split(":"),h=l.length,x=8;l[0]===""&&l[1]===""&&l[2]===""?(l.shift(),l.shift()):l[0]===""&&l[1]===""?l.shift():l[h-1]===""&&l[h-2]===""&&l.pop(),h=l.length,l[h-1].indexOf(".")!==-1&&(x=7);var m;for(m=0;m<h&&l[m]!=="";m++);if(m<x)for(l.splice(m,1,"0000");l.length<x;)l.splice(m,0,"0000");for(var v,_=0;_<x;_++){v=l[_].split("");for(var A=0;A<3&&(v[0]==="0"&&v.length>1);A++)v.splice(0,1);l[_]=v.join("")}var T=-1,w=0,S=0,P=-1,M=!1;for(_=0;_<x;_++)M?l[_]==="0"?S+=1:(M=!1,S>w&&(T=P,w=S)):l[_]==="0"&&(M=!0,P=_,S=1);S>w&&(T=P,w=S),w>1&&l.splice(T,w,""),h=l.length;var L="";for(l[0]===""&&(L=":"),_=0;_<h&&(L+=l[_],_!==h-1);_++)L+=":";return l[h-1]===""&&(L+=":"),L}y(n,"bestPresentation");function o(){return e.IPv6===this&&(e.IPv6=r),this}return y(o,"noConflict"),{best:n,noConflict:o}})});var qVe=X7((WVe,IQ)=>{/*!
 * URI.js - Mutating URLs
 * Second Level Domain (SLD) Support
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,r){"use strict";typeof IQ=="object"&&IQ.exports?IQ.exports=r():typeof define=="function"&&define.amd?define(r):e.SecondLevelDomains=r(e)})(WVe,function(e){"use strict";var r=e&&e.SecondLevelDomains,n={list:{ac:" com gov mil net org ",ae:" ac co gov mil name net org pro sch ",af:" com edu gov net org ",al:" com edu gov mil net org ",ao:" co ed gv it og pb ",ar:" com edu gob gov int mil net org tur ",at:" ac co gv or ",au:" asn com csiro edu gov id net org ",ba:" co com edu gov mil net org rs unbi unmo unsa untz unze ",bb:" biz co com edu gov info net org store tv ",bh:" biz cc com edu gov info net org ",bn:" com edu gov net org ",bo:" com edu gob gov int mil net org tv ",br:" adm adv agr am arq art ato b bio blog bmd cim cng cnt com coop ecn edu eng esp etc eti far flog fm fnd fot fst g12 ggf gov imb ind inf jor jus lel mat med mil mus net nom not ntr odo org ppg pro psc psi qsl rec slg srv tmp trd tur tv vet vlog wiki zlg ",bs:" com edu gov net org ",bz:" du et om ov rg ",ca:" ab bc mb nb nf nl ns nt nu on pe qc sk yk ",ck:" biz co edu gen gov info net org ",cn:" ac ah bj com cq edu fj gd gov gs gx gz ha hb he hi hl hn jl js jx ln mil net nm nx org qh sc sd sh sn sx tj tw xj xz yn zj ",co:" com edu gov mil net nom org ",cr:" ac c co ed fi go or sa ",cy:" ac biz com ekloges gov ltd name net org parliament press pro tm ",do:" art com edu gob gov mil net org sld web ",dz:" art asso com edu gov net org pol ",ec:" com edu fin gov info med mil net org pro ",eg:" com edu eun gov mil name net org sci ",er:" com edu gov ind mil net org rochest w ",es:" com edu gob nom org ",et:" biz com edu gov info name net org ",fj:" ac biz com info mil name net org pro ",fk:" ac co gov net nom org ",fr:" asso com f gouv nom prd presse tm ",gg:" co net org ",gh:" com edu gov mil org ",gn:" ac com gov net org ",gr:" com edu gov mil net org ",gt:" com edu gob ind mil net org ",gu:" com edu gov net org ",hk:" com edu gov idv net org ",hu:" 2000 agrar bolt casino city co erotica erotika film forum games hotel info ingatlan jogasz konyvelo lakas media news org priv reklam sex shop sport suli szex tm tozsde utazas video ",id:" ac co go mil net or sch web ",il:" ac co gov idf k12 muni net org ",in:" ac co edu ernet firm gen gov i ind mil net nic org res ",iq:" com edu gov i mil net org ",ir:" ac co dnssec gov i id net org sch ",it:" edu gov ",je:" co net org ",jo:" com edu gov mil name net org sch ",jp:" ac ad co ed go gr lg ne or ",ke:" ac co go info me mobi ne or sc ",kh:" com edu gov mil net org per ",ki:" biz com de edu gov info mob net org tel ",km:" asso com coop edu gouv k medecin mil nom notaires pharmaciens presse tm veterinaire ",kn:" edu gov net org ",kr:" ac busan chungbuk chungnam co daegu daejeon es gangwon go gwangju gyeongbuk gyeonggi gyeongnam hs incheon jeju jeonbuk jeonnam k kg mil ms ne or pe re sc seoul ulsan ",kw:" com edu gov net org ",ky:" com edu gov net org ",kz:" com edu gov mil net org ",lb:" com edu gov net org ",lk:" assn com edu gov grp hotel int ltd net ngo org sch soc web ",lr:" com edu gov net org ",lv:" asn com conf edu gov id mil net org ",ly:" com edu gov id med net org plc sch ",ma:" ac co gov m net org press ",mc:" asso tm ",me:" ac co edu gov its net org priv ",mg:" com edu gov mil nom org prd tm ",mk:" com edu gov inf name net org pro ",ml:" com edu gov net org presse ",mn:" edu gov org ",mo:" com edu gov net org ",mt:" com edu gov net org ",mv:" aero biz com coop edu gov info int mil museum name net org pro ",mw:" ac co com coop edu gov int museum net org ",mx:" com edu gob net org ",my:" com edu gov mil name net org sch ",nf:" arts com firm info net other per rec store web ",ng:" biz com edu gov mil mobi name net org sch ",ni:" ac co com edu gob mil net nom org ",np:" com edu gov mil net org ",nr:" biz com edu gov info net org ",om:" ac biz co com edu gov med mil museum net org pro sch ",pe:" com edu gob mil net nom org sld ",ph:" com edu gov i mil net ngo org ",pk:" biz com edu fam gob gok gon gop gos gov net org web ",pl:" art bialystok biz com edu gda gdansk gorzow gov info katowice krakow lodz lublin mil net ngo olsztyn org poznan pwr radom slupsk szczecin torun warszawa waw wroc wroclaw zgora ",pr:" ac biz com edu est gov info isla name net org pro prof ",ps:" com edu gov net org plo sec ",pw:" belau co ed go ne or ",ro:" arts com firm info nom nt org rec store tm www ",rs:" ac co edu gov in org ",sb:" com edu gov net org ",sc:" com edu gov net org ",sh:" co com edu gov net nom org ",sl:" com edu gov net org ",st:" co com consulado edu embaixada gov mil net org principe saotome store ",sv:" com edu gob org red ",sz:" ac co org ",tr:" av bbs bel biz com dr edu gen gov info k12 name net org pol tel tsk tv web ",tt:" aero biz cat co com coop edu gov info int jobs mil mobi museum name net org pro tel travel ",tw:" club com ebiz edu game gov idv mil net org ",mu:" ac co com gov net or org ",mz:" ac co edu gov org ",na:" co com ",nz:" ac co cri geek gen govt health iwi maori mil net org parliament school ",pa:" abo ac com edu gob ing med net nom org sld ",pt:" com edu gov int net nome org publ ",py:" com edu gov mil net org ",qa:" com edu gov mil net org ",re:" asso com nom ",ru:" ac adygeya altai amur arkhangelsk astrakhan bashkiria belgorod bir bryansk buryatia cbg chel chelyabinsk chita chukotka chuvashia com dagestan e-burg edu gov grozny int irkutsk ivanovo izhevsk jar joshkar-ola kalmykia kaluga kamchatka karelia kazan kchr kemerovo khabarovsk khakassia khv kirov koenig komi kostroma kranoyarsk kuban kurgan kursk lipetsk magadan mari mari-el marine mil mordovia mosreg msk murmansk nalchik net nnov nov novosibirsk nsk omsk orenburg org oryol penza perm pp pskov ptz rnd ryazan sakhalin samara saratov simbirsk smolensk spb stavropol stv surgut tambov tatarstan tom tomsk tsaritsyn tsk tula tuva tver tyumen udm udmurtia ulan-ude vladikavkaz vladimir vladivostok volgograd vologda voronezh vrn vyatka yakutia yamal yekaterinburg yuzhno-sakhalinsk ",rw:" ac co com edu gouv gov int mil net ",sa:" com edu gov med net org pub sch ",sd:" com edu gov info med net org tv ",se:" a ac b bd c d e f g h i k l m n o org p parti pp press r s t tm u w x y z ",sg:" com edu gov idn net org per ",sn:" art com edu gouv org perso univ ",sy:" com edu gov mil net news org ",th:" ac co go in mi net or ",tj:" ac biz co com edu go gov info int mil name net nic org test web ",tn:" agrinet com defense edunet ens fin gov ind info intl mincom nat net org perso rnrt rns rnu tourism ",tz:" ac co go ne or ",ua:" biz cherkassy chernigov chernovtsy ck cn co com crimea cv dn dnepropetrovsk donetsk dp edu gov if in ivano-frankivsk kh kharkov kherson khmelnitskiy kiev kirovograd km kr ks kv lg lugansk lutsk lviv me mk net nikolaev od odessa org pl poltava pp rovno rv sebastopol sumy te ternopil uzhgorod vinnica vn zaporizhzhe zhitomir zp zt ",ug:" ac co go ne or org sc ",uk:" ac bl british-library co cym gov govt icnet jet lea ltd me mil mod national-library-scotland nel net nhs nic nls org orgn parliament plc police sch scot soc ",us:" dni fed isa kids nsn ",uy:" com edu gub mil net org ",ve:" co com edu gob info mil net org web ",vi:" co com k12 net org ",vn:" ac biz com edu gov health info int name net org pro ",ye:" co com gov ltd me net org plc ",yu:" ac co edu gov org ",za:" ac agric alt bourse city co cybernet db edu gov grondar iaccess imt inca landesign law mil net ngo nis nom olivetti org pix school tm web ",zm:" ac co com edu gov net org sch ",com:"ar br cn de eu gb gr hu jpn kr no qc ru sa se uk us uy za ",net:"gb jp se uk ",org:"ae",de:"com "},has:function(o){var a=o.lastIndexOf(".");if(a<=0||a>=o.length-1)return!1;var s=o.lastIndexOf(".",a-1);if(s<=0||s>=a-1)return!1;var l=n.list[o.slice(a+1)];return l?l.indexOf(" "+o.slice(s+1,a)+" ")>=0:!1},is:function(o){var a=o.lastIndexOf(".");if(a<=0||a>=o.length-1)return!1;var s=o.lastIndexOf(".",a-1);if(s>=0)return!1;var l=n.list[o.slice(a+1)];return l?l.indexOf(" "+o.slice(0,a)+" ")>=0:!1},get:function(o){var a=o.lastIndexOf(".");if(a<=0||a>=o.length-1)return null;var s=o.lastIndexOf(".",a-1);if(s<=0||s>=a-1)return null;var l=n.list[o.slice(a+1)];return!l||l.indexOf(" "+o.slice(s+1,a)+" ")<0?null:o.slice(s+1)},noConflict:function(){return e.SecondLevelDomains===this&&(e.SecondLevelDomains=r),this}};return n})});var YVe=X7((jVe,PQ)=>{/*!
 * URI.js - Mutating URLs
 *
 * Version: 1.19.11
 *
 * Author: Rodney Rehm
 * Web: http://medialize.github.io/URI.js/
 *
 * Licensed under
 *   MIT License http://www.opensource.org/licenses/mit-license
 *
 */(function(e,r){"use strict";typeof PQ=="object"&&PQ.exports?PQ.exports=r(UVe(),HVe(),qVe()):typeof define=="function"&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],r):e.URI=r(e.punycode,e.IPv6,e.SecondLevelDomains,e)})(jVe,function(e,r,n,o){"use strict";var a=o&&o.URI;function s(F,V){var U=arguments.length>=1,Q=arguments.length>=2;if(!(this instanceof s))return U?Q?new s(F,V):new s(F):new s;if(F===void 0){if(U)throw new TypeError("undefined is not a valid argument for URI");typeof location<"u"?F=location.href+"":F=""}if(F===null&&U)throw new TypeError("null is not a valid argument for URI");return this.href(F),V!==void 0?this.absoluteTo(V):this}y(s,"URI");function l(F){return/^[0-9]+$/.test(F)}y(l,"isInteger"),s.version="1.19.11";var h=s.prototype,x=Object.prototype.hasOwnProperty;function m(F){return F.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}y(m,"escapeRegEx");function v(F){return F===void 0?"Undefined":String(Object.prototype.toString.call(F)).slice(8,-1)}y(v,"getType");function _(F){return v(F)==="Array"}y(_,"isArray");function A(F,V){var U={},Q,J;if(v(V)==="RegExp")U=null;else if(_(V))for(Q=0,J=V.length;Q<J;Q++)U[V[Q]]=!0;else U[V]=!0;for(Q=0,J=F.length;Q<J;Q++){var oe=U&&U[F[Q]]!==void 0||!U&&V.test(F[Q]);oe&&(F.splice(Q,1),J--,Q--)}return F}y(A,"filterArrayValues");function T(F,V){var U,Q;if(_(V)){for(U=0,Q=V.length;U<Q;U++)if(!T(F,V[U]))return!1;return!0}var J=v(V);for(U=0,Q=F.length;U<Q;U++)if(J==="RegExp"){if(typeof F[U]=="string"&&F[U].match(V))return!0}else if(F[U]===V)return!0;return!1}y(T,"arrayContains");function w(F,V){if(!_(F)||!_(V)||F.length!==V.length)return!1;F.sort(),V.sort();for(var U=0,Q=F.length;U<Q;U++)if(F[U]!==V[U])return!1;return!0}y(w,"arraysEqual");function S(F){var V=/^\/+|\/+$/g;return F.replace(V,"")}y(S,"trimSlashes"),s._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,preventInvalidHostname:s.preventInvalidHostname,duplicateQueryParameters:s.duplicateQueryParameters,escapeQuerySpace:s.escapeQuerySpace}},s.preventInvalidHostname=!1,s.duplicateQueryParameters=!1,s.escapeQuerySpace=!0,s.protocol_expression=/^[a-z][a-z0-9.+-]*$/i,s.idn_expression=/[^a-z0-9\._-]/i,s.punycode_expression=/(xn--)/i,s.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/,s.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/,s.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?«»“”‘’]))/ig,s.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?«»“”„‘’]+$/,parens:/(\([^\)]*\)|\[[^\]]*\]|\{[^}]*\}|<[^>]*>)/g},s.leading_whitespace_expression=/^[\x00-\x20\u00a0\u1680\u2000-\u200a\u2028\u2029\u202f\u205f\u3000\ufeff]+/,s.ascii_tab_whitespace=/[\u0009\u000A\u000D]+/g,s.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"},s.hostProtocols=["http","https"],s.invalid_hostname_characters=/[^a-zA-Z0-9\.\-:_]/,s.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"},s.getDomAttribute=function(F){if(!(!F||!F.nodeName)){var V=F.nodeName.toLowerCase();if(!(V==="input"&&F.type!=="image"))return s.domAttributes[V]}};function P(F){return escape(F)}y(P,"escapeForDumbFirefox36");function M(F){return encodeURIComponent(F).replace(/[!'()*]/g,P).replace(/\*/g,"%2A")}y(M,"strictEncodeURIComponent"),s.encode=M,s.decode=decodeURIComponent,s.iso8859=function(){s.encode=escape,s.decode=unescape},s.unicode=function(){s.encode=M,s.decode=decodeURIComponent},s.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}},urnpath:{encode:{expression:/%(21|24|27|28|29|2A|2B|2C|3B|3D|40)/ig,map:{"%21":"!","%24":"$","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"=","%40":"@"}},decode:{expression:/[\/\?#:]/g,map:{"/":"%2F","?":"%3F","#":"%23",":":"%3A"}}}},s.encodeQuery=function(F,V){var U=s.encode(F+"");return V===void 0&&(V=s.escapeQuerySpace),V?U.replace(/%20/g,"+"):U},s.decodeQuery=function(F,V){F+="",V===void 0&&(V=s.escapeQuerySpace);try{return s.decode(V?F.replace(/\+/g,"%20"):F)}catch{return F}};var L={encode:"encode",decode:"decode"},R,O=y(function(F,V){return function(U){try{return s[V](U+"").replace(s.characters[F][V].expression,function(Q){return s.characters[F][V].map[Q]})}catch{return U}}},"generateAccessor");for(R in L)s[R+"PathSegment"]=O("pathname",L[R]),s[R+"UrnPathSegment"]=O("urnpath",L[R]);var N=y(function(F,V,U){return function(Q){var J;U?J=y(function(ne){return s[V](s[U](ne))},"actualCodingFunc"):J=s[V];for(var oe=(Q+"").split(F),$=0,re=oe.length;$<re;$++)oe[$]=J(oe[$]);return oe.join(F)}},"generateSegmentedPathFunction");s.decodePath=N("/","decodePathSegment"),s.decodeUrnPath=N(":","decodeUrnPathSegment"),s.recodePath=N("/","encodePathSegment","decode"),s.recodeUrnPath=N(":","encodeUrnPathSegment","decode"),s.encodeReserved=O("reserved","encode"),s.parse=function(F,V){var U;return V||(V={preventInvalidHostname:s.preventInvalidHostname}),F=F.replace(s.leading_whitespace_expression,""),F=F.replace(s.ascii_tab_whitespace,""),U=F.indexOf("#"),U>-1&&(V.fragment=F.substring(U+1)||null,F=F.substring(0,U)),U=F.indexOf("?"),U>-1&&(V.query=F.substring(U+1)||null,F=F.substring(0,U)),F=F.replace(/^(https?|ftp|wss?)?:+[/\\]*/i,"$1://"),F=F.replace(/^[/\\]{2,}/i,"//"),F.substring(0,2)==="//"?(V.protocol=null,F=F.substring(2),F=s.parseAuthority(F,V)):(U=F.indexOf(":"),U>-1&&(V.protocol=F.substring(0,U)||null,V.protocol&&!V.protocol.match(s.protocol_expression)?V.protocol=void 0:F.substring(U+1,U+3).replace(/\\/g,"/")==="//"?(F=F.substring(U+3),F=s.parseAuthority(F,V)):(F=F.substring(U+1),V.urn=!0))),V.path=F,V},s.parseHost=function(F,V){F||(F=""),F=F.replace(/\\/g,"/");var U=F.indexOf("/"),Q,J;if(U===-1&&(U=F.length),F.charAt(0)==="[")Q=F.indexOf("]"),V.hostname=F.substring(1,Q)||null,V.port=F.substring(Q+2,U)||null,V.port==="/"&&(V.port=null);else{var oe=F.indexOf(":"),$=F.indexOf("/"),re=F.indexOf(":",oe+1);re!==-1&&($===-1||re<$)?(V.hostname=F.substring(0,U)||null,V.port=null):(J=F.substring(0,U).split(":"),V.hostname=J[0]||null,V.port=J[1]||null)}return V.hostname&&F.substring(U).charAt(0)!=="/"&&(U++,F="/"+F),V.preventInvalidHostname&&s.ensureValidHostname(V.hostname,V.protocol),V.port&&s.ensureValidPort(V.port),F.substring(U)||"/"},s.parseAuthority=function(F,V){return F=s.parseUserinfo(F,V),s.parseHost(F,V)},s.parseUserinfo=function(F,V){var U=F,Q=F.indexOf("\\");Q!==-1&&(F=F.replace(/\\/g,"/"));var J=F.indexOf("/"),oe=F.lastIndexOf("@",J>-1?J:F.length-1),$;return oe>-1&&(J===-1||oe<J)?($=F.substring(0,oe).split(":"),V.username=$[0]?s.decode($[0]):null,$.shift(),V.password=$[0]?s.decode($.join(":")):null,F=U.substring(oe+1)):(V.username=null,V.password=null),F},s.parseQuery=function(F,V){if(!F)return{};if(F=F.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,""),!F)return{};for(var U={},Q=F.split("&"),J=Q.length,oe,$,re,ne=0;ne<J;ne++)oe=Q[ne].split("="),$=s.decodeQuery(oe.shift(),V),re=oe.length?s.decodeQuery(oe.join("="),V):null,$!=="__proto__"&&(x.call(U,$)?((typeof U[$]=="string"||U[$]===null)&&(U[$]=[U[$]]),U[$].push(re)):U[$]=re);return U},s.build=function(F){var V="",U=!1;return F.protocol&&(V+=F.protocol+":"),!F.urn&&(V||F.hostname)&&(V+="//",U=!0),V+=s.buildAuthority(F)||"",typeof F.path=="string"&&(F.path.charAt(0)!=="/"&&U&&(V+="/"),V+=F.path),typeof F.query=="string"&&F.query&&(V+="?"+F.query),typeof F.fragment=="string"&&F.fragment&&(V+="#"+F.fragment),V},s.buildHost=function(F){var V="";if(F.hostname)s.ip6_expression.test(F.hostname)?V+="["+F.hostname+"]":V+=F.hostname;else return"";return F.port&&(V+=":"+F.port),V},s.buildAuthority=function(F){return s.buildUserinfo(F)+s.buildHost(F)},s.buildUserinfo=function(F){var V="";return F.username&&(V+=s.encode(F.username)),F.password&&(V+=":"+s.encode(F.password)),V&&(V+="@"),V},s.buildQuery=function(F,V,U){var Q="",J,oe,$,re;for(oe in F)if(oe!=="__proto__"&&x.call(F,oe))if(_(F[oe]))for(J={},$=0,re=F[oe].length;$<re;$++)F[oe][$]!==void 0&&J[F[oe][$]+""]===void 0&&(Q+="&"+s.buildQueryParameter(oe,F[oe][$],U),V!==!0&&(J[F[oe][$]+""]=!0));else F[oe]!==void 0&&(Q+="&"+s.buildQueryParameter(oe,F[oe],U));return Q.substring(1)},s.buildQueryParameter=function(F,V,U){return s.encodeQuery(F,U)+(V!==null?"="+s.encodeQuery(V,U):"")},s.addQuery=function(F,V,U){if(typeof V=="object")for(var Q in V)x.call(V,Q)&&s.addQuery(F,Q,V[Q]);else if(typeof V=="string"){if(F[V]===void 0){F[V]=U;return}else typeof F[V]=="string"&&(F[V]=[F[V]]);_(U)||(U=[U]),F[V]=(F[V]||[]).concat(U)}else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")},s.setQuery=function(F,V,U){if(typeof V=="object")for(var Q in V)x.call(V,Q)&&s.setQuery(F,Q,V[Q]);else if(typeof V=="string")F[V]=U===void 0?null:U;else throw new TypeError("URI.setQuery() accepts an object, string as the name parameter")},s.removeQuery=function(F,V,U){var Q,J,oe;if(_(V))for(Q=0,J=V.length;Q<J;Q++)F[V[Q]]=void 0;else if(v(V)==="RegExp")for(oe in F)V.test(oe)&&(F[oe]=void 0);else if(typeof V=="object")for(oe in V)x.call(V,oe)&&s.removeQuery(F,oe,V[oe]);else if(typeof V=="string")U!==void 0?v(U)==="RegExp"?!_(F[V])&&U.test(F[V])?F[V]=void 0:F[V]=A(F[V],U):F[V]===String(U)&&(!_(U)||U.length===1)?F[V]=void 0:_(F[V])&&(F[V]=A(F[V],U)):F[V]=void 0;else throw new TypeError("URI.removeQuery() accepts an object, string, RegExp as the first parameter")},s.hasQuery=function(F,V,U,Q){switch(v(V)){case"String":break;case"RegExp":for(var J in F)if(x.call(F,J)&&V.test(J)&&(U===void 0||s.hasQuery(F,J,U)))return!0;return!1;case"Object":for(var oe in V)if(x.call(V,oe)&&!s.hasQuery(F,oe,V[oe]))return!1;return!0;default:throw new TypeError("URI.hasQuery() accepts a string, regular expression or object as the name parameter")}switch(v(U)){case"Undefined":return V in F;case"Boolean":var $=Boolean(_(F[V])?F[V].length:F[V]);return U===$;case"Function":return!!U(F[V],V,F);case"Array":if(!_(F[V]))return!1;var re=Q?T:w;return re(F[V],U);case"RegExp":return _(F[V])?Q?T(F[V],U):!1:Boolean(F[V]&&F[V].match(U));case"Number":U=String(U);case"String":return _(F[V])?Q?T(F[V],U):!1:F[V]===U;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}},s.joinPaths=function(){for(var F=[],V=[],U=0,Q=0;Q<arguments.length;Q++){var J=new s(arguments[Q]);F.push(J);for(var oe=J.segment(),$=0;$<oe.length;$++)typeof oe[$]=="string"&&V.push(oe[$]),oe[$]&&U++}if(!V.length||!U)return new s("");var re=new s("").segment(V);return(F[0].path()===""||F[0].path().slice(0,1)==="/")&&re.path("/"+re.path()),re.normalize()},s.commonPath=function(F,V){var U=Math.min(F.length,V.length),Q;for(Q=0;Q<U;Q++)if(F.charAt(Q)!==V.charAt(Q)){Q--;break}return Q<1?F.charAt(0)===V.charAt(0)&&F.charAt(0)==="/"?"/":"":((F.charAt(Q)!=="/"||V.charAt(Q)!=="/")&&(Q=F.substring(0,Q).lastIndexOf("/")),F.substring(0,Q+1))},s.withinString=function(F,V,U){U||(U={});var Q=U.start||s.findUri.start,J=U.end||s.findUri.end,oe=U.trim||s.findUri.trim,$=U.parens||s.findUri.parens,re=/[a-z0-9-]=["']?$/i;for(Q.lastIndex=0;;){var ne=Q.exec(F);if(!ne)break;var le=ne.index;if(U.ignoreHtml){var ue=F.slice(Math.max(le-3,0),le);if(ue&&re.test(ue))continue}for(var ie=le+F.slice(le).search(J),ce=F.slice(le,ie),he=-1;;){var _e=$.exec(ce);if(!_e)break;var Ae=_e.index+_e[0].length;he=Math.max(he,Ae)}if(he>-1?ce=ce.slice(0,he)+ce.slice(he).replace(oe,""):ce=ce.replace(oe,""),!(ce.length<=ne[0].length)&&!(U.ignore&&U.ignore.test(ce))){ie=le+ce.length;var be=V(ce,le,ie,F);if(be===void 0){Q.lastIndex=ie;continue}be=String(be),F=F.slice(0,le)+be+F.slice(ie),Q.lastIndex=le+be.length}}return Q.lastIndex=0,F},s.ensureValidHostname=function(F,V){var U=!!F,Q=!!V,J=!1;if(Q&&(J=T(s.hostProtocols,V)),J&&!U)throw new TypeError("Hostname cannot be empty, if protocol is "+V);if(F&&F.match(s.invalid_hostname_characters)){if(!e)throw new TypeError('Hostname "'+F+'" contains characters other than [A-Z0-9.-:_] and Punycode.js is not available');if(e.toASCII(F).match(s.invalid_hostname_characters))throw new TypeError('Hostname "'+F+'" contains characters other than [A-Z0-9.-:_]')}},s.ensureValidPort=function(F){if(!!F){var V=Number(F);if(!(l(V)&&V>0&&V<65536))throw new TypeError('Port "'+F+'" is not a valid port')}},s.noConflict=function(F){if(F){var V={URI:this.noConflict()};return o.URITemplate&&typeof o.URITemplate.noConflict=="function"&&(V.URITemplate=o.URITemplate.noConflict()),o.IPv6&&typeof o.IPv6.noConflict=="function"&&(V.IPv6=o.IPv6.noConflict()),o.SecondLevelDomains&&typeof o.SecondLevelDomains.noConflict=="function"&&(V.SecondLevelDomains=o.SecondLevelDomains.noConflict()),V}else o.URI===this&&(o.URI=a);return this},h.build=function(F){return F===!0?this._deferred_build=!0:(F===void 0||this._deferred_build)&&(this._string=s.build(this._parts),this._deferred_build=!1),this},h.clone=function(){return new s(this)},h.valueOf=h.toString=function(){return this.build(!1)._string};function k(F){return function(V,U){return V===void 0?this._parts[F]||"":(this._parts[F]=V||null,this.build(!U),this)}}y(k,"generateSimpleAccessor");function z(F,V){return function(U,Q){return U===void 0?this._parts[F]||"":(U!==null&&(U=U+"",U.charAt(0)===V&&(U=U.substring(1))),this._parts[F]=U,this.build(!Q),this)}}y(z,"generatePrefixAccessor"),h.protocol=k("protocol"),h.username=k("username"),h.password=k("password"),h.hostname=k("hostname"),h.port=k("port"),h.query=z("query","?"),h.fragment=z("fragment","#"),h.search=function(F,V){var U=this.query(F,V);return typeof U=="string"&&U.length?"?"+U:U},h.hash=function(F,V){var U=this.fragment(F,V);return typeof U=="string"&&U.length?"#"+U:U},h.pathname=function(F,V){if(F===void 0||F===!0){var U=this._parts.path||(this._parts.hostname?"/":"");return F?(this._parts.urn?s.decodeUrnPath:s.decodePath)(U):U}else return this._parts.urn?this._parts.path=F?s.recodeUrnPath(F):"":this._parts.path=F?s.recodePath(F):"/",this.build(!V),this},h.path=h.pathname,h.href=function(F,V){var U;if(F===void 0)return this.toString();this._string="",this._parts=s._parts();var Q=F instanceof s,J=typeof F=="object"&&(F.hostname||F.path||F.pathname);if(F.nodeName){var oe=s.getDomAttribute(F);F=F[oe]||"",J=!1}if(!Q&&J&&F.pathname!==void 0&&(F=F.toString()),typeof F=="string"||F instanceof String)this._parts=s.parse(String(F),this._parts);else if(Q||J){var $=Q?F._parts:F;for(U in $)U!=="query"&&x.call(this._parts,U)&&(this._parts[U]=$[U]);$.query&&this.query($.query,!1)}else throw new TypeError("invalid input");return this.build(!V),this},h.is=function(F){var V=!1,U=!1,Q=!1,J=!1,oe=!1,$=!1,re=!1,ne=!this._parts.urn;switch(this._parts.hostname&&(ne=!1,U=s.ip4_expression.test(this._parts.hostname),Q=s.ip6_expression.test(this._parts.hostname),V=U||Q,J=!V,oe=J&&n&&n.has(this._parts.hostname),$=J&&s.idn_expression.test(this._parts.hostname),re=J&&s.punycode_expression.test(this._parts.hostname)),F.toLowerCase()){case"relative":return ne;case"absolute":return!ne;case"domain":case"name":return J;case"sld":return oe;case"ip":return V;case"ip4":case"ipv4":case"inet4":return U;case"ip6":case"ipv6":case"inet6":return Q;case"idn":return $;case"url":return!this._parts.urn;case"urn":return!!this._parts.urn;case"punycode":return re}return null};var W=h.protocol,j=h.port,q=h.hostname;h.protocol=function(F,V){if(F&&(F=F.replace(/:(\/\/)?$/,""),!F.match(s.protocol_expression)))throw new TypeError('Protocol "'+F+`" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]`);return W.call(this,F,V)},h.scheme=h.protocol,h.port=function(F,V){return this._parts.urn?F===void 0?"":this:(F!==void 0&&(F===0&&(F=null),F&&(F+="",F.charAt(0)===":"&&(F=F.substring(1)),s.ensureValidPort(F))),j.call(this,F,V))},h.hostname=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F!==void 0){var U={preventInvalidHostname:this._parts.preventInvalidHostname},Q=s.parseHost(F,U);if(Q!=="/")throw new TypeError('Hostname "'+F+'" contains characters other than [A-Z0-9.-]');F=U.hostname,this._parts.preventInvalidHostname&&s.ensureValidHostname(F,this._parts.protocol)}return q.call(this,F,V)},h.origin=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0){var U=this.protocol(),Q=this.authority();return Q?(U?U+"://":"")+this.authority():""}else{var J=s(F);return this.protocol(J.protocol()).authority(J.authority()).build(!V),this}},h.host=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0)return this._parts.hostname?s.buildHost(this._parts):"";var U=s.parseHost(F,this._parts);if(U!=="/")throw new TypeError('Hostname "'+F+'" contains characters other than [A-Z0-9.-]');return this.build(!V),this},h.authority=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0)return this._parts.hostname?s.buildAuthority(this._parts):"";var U=s.parseAuthority(F,this._parts);if(U!=="/")throw new TypeError('Hostname "'+F+'" contains characters other than [A-Z0-9.-]');return this.build(!V),this},h.userinfo=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0){var U=s.buildUserinfo(this._parts);return U&&U.substring(0,U.length-1)}else return F[F.length-1]!=="@"&&(F+="@"),s.parseUserinfo(F,this._parts),this.build(!V),this},h.resource=function(F,V){var U;return F===void 0?this.path()+this.search()+this.hash():(U=s.parse(F),this._parts.path=U.path,this._parts.query=U.query,this._parts.fragment=U.fragment,this.build(!V),this)},h.subdomain=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0){if(!this._parts.hostname||this.is("IP"))return"";var U=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,U)||""}else{var Q=this._parts.hostname.length-this.domain().length,J=this._parts.hostname.substring(0,Q),oe=new RegExp("^"+m(J));if(F&&F.charAt(F.length-1)!=="."&&(F+="."),F.indexOf(":")!==-1)throw new TypeError("Domains cannot contain colons");return F&&s.ensureValidHostname(F,this._parts.protocol),this._parts.hostname=this._parts.hostname.replace(oe,F),this.build(!V),this}},h.domain=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(typeof F=="boolean"&&(V=F,F=void 0),F===void 0){if(!this._parts.hostname||this.is("IP"))return"";var U=this._parts.hostname.match(/\./g);if(U&&U.length<2)return this._parts.hostname;var Q=this._parts.hostname.length-this.tld(V).length-1;return Q=this._parts.hostname.lastIndexOf(".",Q-1)+1,this._parts.hostname.substring(Q)||""}else{if(!F)throw new TypeError("cannot set domain empty");if(F.indexOf(":")!==-1)throw new TypeError("Domains cannot contain colons");if(s.ensureValidHostname(F,this._parts.protocol),!this._parts.hostname||this.is("IP"))this._parts.hostname=F;else{var J=new RegExp(m(this.domain())+"$");this._parts.hostname=this._parts.hostname.replace(J,F)}return this.build(!V),this}},h.tld=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(typeof F=="boolean"&&(V=F,F=void 0),F===void 0){if(!this._parts.hostname||this.is("IP"))return"";var U=this._parts.hostname.lastIndexOf("."),Q=this._parts.hostname.substring(U+1);return V!==!0&&n&&n.list[Q.toLowerCase()]&&n.get(this._parts.hostname)||Q}else{var J;if(F)if(F.match(/[^a-zA-Z0-9-]/))if(n&&n.is(F))J=new RegExp(m(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(J,F);else throw new TypeError('TLD "'+F+'" contains characters other than [A-Z0-9]');else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");J=new RegExp(m(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(J,F)}else throw new TypeError("cannot set TLD empty");return this.build(!V),this}},h.directory=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0||F===!0){if(!this._parts.path&&!this._parts.hostname)return"";if(this._parts.path==="/")return"/";var U=this._parts.path.length-this.filename().length-1,Q=this._parts.path.substring(0,U)||(this._parts.hostname?"/":"");return F?s.decodePath(Q):Q}else{var J=this._parts.path.length-this.filename().length,oe=this._parts.path.substring(0,J),$=new RegExp("^"+m(oe));return this.is("relative")||(F||(F="/"),F.charAt(0)!=="/"&&(F="/"+F)),F&&F.charAt(F.length-1)!=="/"&&(F+="/"),F=s.recodePath(F),this._parts.path=this._parts.path.replace($,F),this.build(!V),this}},h.filename=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(typeof F!="string"){if(!this._parts.path||this._parts.path==="/")return"";var U=this._parts.path.lastIndexOf("/"),Q=this._parts.path.substring(U+1);return F?s.decodePathSegment(Q):Q}else{var J=!1;F.charAt(0)==="/"&&(F=F.substring(1)),F.match(/\.?\//)&&(J=!0);var oe=new RegExp(m(this.filename())+"$");return F=s.recodePath(F),this._parts.path=this._parts.path.replace(oe,F),J?this.normalizePath(V):this.build(!V),this}},h.suffix=function(F,V){if(this._parts.urn)return F===void 0?"":this;if(F===void 0||F===!0){if(!this._parts.path||this._parts.path==="/")return"";var U=this.filename(),Q=U.lastIndexOf("."),J,oe;return Q===-1?"":(J=U.substring(Q+1),oe=/^[a-z0-9%]+$/i.test(J)?J:"",F?s.decodePathSegment(oe):oe)}else{F.charAt(0)==="."&&(F=F.substring(1));var $=this.suffix(),re;if($)F?re=new RegExp(m($)+"$"):re=new RegExp(m("."+$)+"$");else{if(!F)return this;this._parts.path+="."+s.recodePath(F)}return re&&(F=s.recodePath(F),this._parts.path=this._parts.path.replace(re,F)),this.build(!V),this}},h.segment=function(F,V,U){var Q=this._parts.urn?":":"/",J=this.path(),oe=J.substring(0,1)==="/",$=J.split(Q);if(F!==void 0&&typeof F!="number"&&(U=V,V=F,F=void 0),F!==void 0&&typeof F!="number")throw new Error('Bad segment "'+F+'", must be 0-based integer');if(oe&&$.shift(),F<0&&(F=Math.max($.length+F,0)),V===void 0)return F===void 0?$:$[F];if(F===null||$[F]===void 0)if(_(V)){$=[];for(var re=0,ne=V.length;re<ne;re++)!V[re].length&&(!$.length||!$[$.length-1].length)||($.length&&!$[$.length-1].length&&$.pop(),$.push(S(V[re])))}else(V||typeof V=="string")&&(V=S(V),$[$.length-1]===""?$[$.length-1]=V:$.push(V));else V?$[F]=S(V):$.splice(F,1);return oe&&$.unshift(""),this.path($.join(Q),U)},h.segmentCoded=function(F,V,U){var Q,J,oe;if(typeof F!="number"&&(U=V,V=F,F=void 0),V===void 0){if(Q=this.segment(F,V,U),!_(Q))Q=Q!==void 0?s.decode(Q):void 0;else for(J=0,oe=Q.length;J<oe;J++)Q[J]=s.decode(Q[J]);return Q}if(!_(V))V=typeof V=="string"||V instanceof String?s.encode(V):V;else for(J=0,oe=V.length;J<oe;J++)V[J]=s.encode(V[J]);return this.segment(F,V,U)};var I=h.query;return h.query=function(F,V){if(F===!0)return s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof F=="function"){var U=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace),Q=F.call(this,U);return this._parts.query=s.buildQuery(Q||U,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!V),this}else return F!==void 0&&typeof F!="string"?(this._parts.query=s.buildQuery(F,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!V),this):I.call(this,F,V)},h.setQuery=function(F,V,U){var Q=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if(typeof F=="string"||F instanceof String)Q[F]=V!==void 0?V:null;else if(typeof F=="object")for(var J in F)x.call(F,J)&&(Q[J]=F[J]);else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");return this._parts.query=s.buildQuery(Q,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof F!="string"&&(U=V),this.build(!U),this},h.addQuery=function(F,V,U){var Q=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.addQuery(Q,F,V===void 0?null:V),this._parts.query=s.buildQuery(Q,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof F!="string"&&(U=V),this.build(!U),this},h.removeQuery=function(F,V,U){var Q=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.removeQuery(Q,F,V),this._parts.query=s.buildQuery(Q,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),typeof F!="string"&&(U=V),this.build(!U),this},h.hasQuery=function(F,V,U){var Q=s.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return s.hasQuery(Q,F,V,U)},h.setSearch=h.setQuery,h.addSearch=h.addQuery,h.removeSearch=h.removeQuery,h.hasSearch=h.hasQuery,h.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()},h.normalizeProtocol=function(F){return typeof this._parts.protocol=="string"&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!F)),this},h.normalizeHostname=function(F){return this._parts.hostname&&(this.is("IDN")&&e?this._parts.hostname=e.toASCII(this._parts.hostname):this.is("IPv6")&&r&&(this._parts.hostname=r.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!F)),this},h.normalizePort=function(F){return typeof this._parts.protocol=="string"&&this._parts.port===s.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!F)),this},h.normalizePath=function(F){var V=this._parts.path;if(!V)return this;if(this._parts.urn)return this._parts.path=s.recodeUrnPath(this._parts.path),this.build(!F),this;if(this._parts.path==="/")return this;V=s.recodePath(V);var U,Q="",J,oe;for(V.charAt(0)!=="/"&&(U=!0,V="/"+V),(V.slice(-3)==="/.."||V.slice(-2)==="/.")&&(V+="/"),V=V.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/"),U&&(Q=V.substring(1).match(/^(\.\.\/)+/)||"",Q&&(Q=Q[0]));J=V.search(/\/\.\.(\/|$)/),J!==-1;){if(J===0){V=V.substring(3);continue}oe=V.substring(0,J).lastIndexOf("/"),oe===-1&&(oe=J),V=V.substring(0,oe)+V.substring(J+3)}return U&&this.is("relative")&&(V=Q+V.substring(1)),this._parts.path=V,this.build(!F),this},h.normalizePathname=h.normalizePath,h.normalizeQuery=function(F){return typeof this._parts.query=="string"&&(this._parts.query.length?this.query(s.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!F)),this},h.normalizeFragment=function(F){return this._parts.fragment||(this._parts.fragment=null,this.build(!F)),this},h.normalizeSearch=h.normalizeQuery,h.normalizeHash=h.normalizeFragment,h.iso8859=function(){var F=s.encode,V=s.decode;s.encode=escape,s.decode=decodeURIComponent;try{this.normalize()}finally{s.encode=F,s.decode=V}return this},h.unicode=function(){var F=s.encode,V=s.decode;s.encode=M,s.decode=unescape;try{this.normalize()}finally{s.encode=F,s.decode=V}return this},h.readable=function(){var F=this.clone();F.username("").password("").normalize();var V="";if(F._parts.protocol&&(V+=F._parts.protocol+"://"),F._parts.hostname&&(F.is("punycode")&&e?(V+=e.toUnicode(F._parts.hostname),F._parts.port&&(V+=":"+F._parts.port)):V+=F.host()),F._parts.hostname&&F._parts.path&&F._parts.path.charAt(0)!=="/"&&(V+="/"),V+=F.path(!0),F._parts.query){for(var U="",Q=0,J=F._parts.query.split("&"),oe=J.length;Q<oe;Q++){var $=(J[Q]||"").split("=");U+="&"+s.decodeQuery($[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"),$[1]!==void 0&&(U+="="+s.decodeQuery($[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}V+="?"+U.substring(1)}return V+=s.decodeQuery(F.hash(),!0),V},h.absoluteTo=function(F){var V=this.clone(),U=["protocol","username","password","hostname","port"],Q,J,oe;if(this._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(F instanceof s||(F=new s(F)),V._parts.protocol||(V._parts.protocol=F._parts.protocol,this._parts.hostname))return V;for(J=0;oe=U[J];J++)V._parts[oe]=F._parts[oe];return V._parts.path?(V._parts.path.substring(-2)===".."&&(V._parts.path+="/"),V.path().charAt(0)!=="/"&&(Q=F.directory(),Q=Q||(F.path().indexOf("/")===0?"/":""),V._parts.path=(Q?Q+"/":"")+V._parts.path,V.normalizePath())):(V._parts.path=F._parts.path,V._parts.query||(V._parts.query=F._parts.query)),V.build(),V},h.relativeTo=function(F){var V=this.clone().normalize(),U,Q,J,oe,$;if(V._parts.urn)throw new Error("URNs do not have any generally defined hierarchical components");if(F=new s(F).normalize(),U=V._parts,Q=F._parts,oe=V.path(),$=F.path(),oe.charAt(0)!=="/")throw new Error("URI is already relative");if($.charAt(0)!=="/")throw new Error("Cannot calculate a URI relative to another relative URI");if(U.protocol===Q.protocol&&(U.protocol=null),U.username!==Q.username||U.password!==Q.password||U.protocol!==null||U.username!==null||U.password!==null)return V.build();if(U.hostname===Q.hostname&&U.port===Q.port)U.hostname=null,U.port=null;else return V.build();if(oe===$)return U.path="",V.build();if(J=s.commonPath(oe,$),!J)return V.build();var re=Q.path.substring(J.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");return U.path=re+U.path.substring(J.length)||"./",V.build()},h.equals=function(F){var V=this.clone(),U=new s(F),Q={},J={},oe={},$,re,ne;if(V.normalize(),U.normalize(),V.toString()===U.toString())return!0;if($=V.query(),re=U.query(),V.query(""),U.query(""),V.toString()!==U.toString()||$.length!==re.length)return!1;Q=s.parseQuery($,this._parts.escapeQuerySpace),J=s.parseQuery(re,this._parts.escapeQuerySpace);for(ne in Q)if(x.call(Q,ne)){if(_(Q[ne])){if(!w(Q[ne],J[ne]))return!1}else if(Q[ne]!==J[ne])return!1;oe[ne]=!0}for(ne in J)if(x.call(J,ne)&&!oe[ne])return!1;return!0},h.preventInvalidHostname=function(F){return this._parts.preventInvalidHostname=!!F,this},h.duplicateQueryParameters=function(F){return this._parts.duplicateQueryParameters=!!F,this},h.escapeQuerySpace=function(F){return this._parts.escapeQuerySpace=!!F,this},s})});function XVe(){if(!p(Nh._canTransferArrayBuffer)){let e=Mde("transferTypedArrayTest");e.postMessage=B(e.webkitPostMessage,e.postMessage);let r=99,n=new Int8Array([r]);try{e.postMessage({array:n},[n.buffer])}catch{return Nh._canTransferArrayBuffer=!1,Nh._canTransferArrayBuffer}Nh._canTransferArrayBuffer=new Promise(o=>{e.onmessage=function(a){let s=a.data.array,l=p(s)&&s[0]===r;o(l),e.terminate(),Nh._canTransferArrayBuffer=l}})}return Nh._canTransferArrayBuffer}function Pde(e){let r;try{r=new Blob([e],{type:"application/javascript"})}catch{let a=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,s=new a;s.append(e),r=s.getBlob("application/javascript")}return(window.URL||window.webkitURL).createObjectURL(r)}function Mde(e){let r=new QVe.default(e),n=r.scheme().length!==0&&r.fragment().length===0,o={},a;if(SS(e)){let l=`importScripts("${e}");`;return a=Pde(l),new Worker(a,o)}let s=e.replace(/\.js$/,"");if(!n&&typeof CESIUM_WORKERS<"u"){let l=`
      importScripts("${Pde(SuperMap3D_WORKERS)}");
      SuperMap3DWorkers["${s}"]();
    `;return a=Pde(l),new Worker(a,o)}if(a=e,n||(a=gi(`${Nh._workerModulePrefix+s}.js`)),!Gn.supportsEsmWebWorkers())throw new Ht("This browser is not supported. Please update your browser to continue.");return o.type="module",new Worker(a,o)}async function sRt(e,r){let n={modulePath:void 0,wasmBinaryFile:void 0,wasmBinary:void 0};if(!Gn.supportsWebAssembly()){if(!p(r.fallbackModulePath))throw new Ht(`This browser does not support Web Assembly, and no backup module was provided for ${e._workerPath}`);return n.modulePath=gi(r.fallbackModulePath),n}n.wasmBinaryFile=gi(r.wasmBinaryFile);let o=await ir.fetchArrayBuffer({url:n.wasmBinaryFile});return n.wasmBinary=o,n}function Nh(e,r){this._workerPath=e,this._maximumActiveTasks=B(r,Number.POSITIVE_INFINITY),this._activeTasks=0,this._nextID=0,this._webAssemblyPromise=void 0,this._wasmLoading=!1}async function cRt(e,r,n){let o=await Promise.resolve(XVe());p(n)?o||(n.length=0):n=uRt;let a=e._nextID++;var s=Je.defer();return e._worker.addEventListener("message",lRt(e._worker,a,s.resolve,s.reject)),e._worker.postMessage({id:a,baseUrl:gi.getCesiumBaseUrl().url,parameters:r,canTransferArrayBuffer:o},n),s.promise}async function fRt(e,r,n){e._workerPath!=="websocketTaskProcessor"&&e._workerPath!=="ruleModeling"&&++e._activeTasks;try{let o=await cRt(e,r,n);return e._workerPath!=="websocketTaskProcessor"&&e._workerPath!=="ruleModeling"&&--e._activeTasks,o}catch(o){throw e._workerPath!=="websocketTaskProcessor"&&e._workerPath!=="ruleModeling"&&--e._activeTasks,o}}var QVe,Dde,lRt,uRt,On,vl=Ee(()=>{QVe=hbt(YVe());li();Xs();Ze();De();ur();st();ti();ou();xH();hn();zo();y(XVe,"canTransferArrayBuffer");Dde=new It;y(Pde,"urlFromScript");y(Mde,"createWorker");y(sRt,"getWebAssemblyLoaderConfig");y(Nh,"TaskProcessor");lRt=y((e,r,n,o)=>{let a=y(({data:s})=>{if(s.id===r){if(p(s.error)){let l=s.error;l.name==="RuntimeError"?(l=new Ht(s.error.message),l.stack=s.error.stack):l.name==="DeveloperError"?(l=new G(s.error.message),l.stack=s.error.stack):l.name==="Error"&&(l=new Error(s.error.message),l.stack=s.error.stack),Dde.raiseEvent(l),o(l)}else Dde.raiseEvent(),n(s.result);e.removeEventListener("message",a)}},"listener");return a},"createOnmessageHandler"),uRt=[];y(cRt,"runTask");y(fRt,"scheduleTask");Nh.prototype.scheduleTask=function(e,r){if(p(this._worker)||(this._worker=Mde(this._workerPath)),!(this._activeTasks>=this._maximumActiveTasks||this._wasmLoading))return fRt(this,e,r)};Nh.prototype.initWebAssemblyModule=async function(e){if(p(this._webAssemblyPromise))return this._webAssemblyPromise;let r=y(async()=>{let n=this._worker=Mde(this._workerPath);this._wasmLoading=!0;let o=await sRt(this,e),a=await Promise.resolve(XVe()),s,l=o.wasmBinary;p(l)&&a&&(s=[l]);var h=Je.defer();let x=this;return n.onmessage=function({data:m}){x._wasmLoading=!1,p(m)?h.resolve(m.result):h.reject(new Ht("Could not configure wasm module"))},n.postMessage({canTransferArrayBuffer:a,parameters:{webAssemblyConfig:o}},s),h.promise},"init");return this._webAssemblyPromise=r(),this._webAssemblyPromise};Nh.prototype.isDestroyed=function(){return!1};Nh.prototype.destroy=function(){return p(this._worker)&&this._worker.terminate(),$e(this)};Nh.taskCompletedEvent=Dde;Nh._defaultWorkerModulePrefix="Workers/";Nh._workerModulePrefix=Nh._defaultWorkerModulePrefix;Nh._canTransferArrayBuffer=void 0;On=Nh});var DQ,Nt,io=Ee(()=>{co();DQ={STREAM_DRAW:Se.STREAM_DRAW,STATIC_DRAW:Se.STATIC_DRAW,DYNAMIC_DRAW:Se.DYNAMIC_DRAW,validate:function(e){return e===DQ.STREAM_DRAW||e===DQ.STATIC_DRAW||e===DQ.DYNAMIC_DRAW}},Nt=DQ});function fn(e){this._size=e.size,this._datatype=e.datatype,this.getValue=e.getValue}var xRt,th,hRt,VS,MQ=Ee(()=>{bt();Rr();co();xRt=new E;y(fn,"AutomaticUniform");th={};th[Se.FLOAT]="float";th[Se.FLOAT_VEC2]="vec2";th[Se.FLOAT_VEC3]="vec3";th[Se.FLOAT_VEC4]="vec4";th[Se.INT]="int";th[Se.INT_VEC2]="ivec2";th[Se.INT_VEC3]="ivec3";th[Se.INT_VEC4]="ivec4";th[Se.BOOL]="bool";th[Se.BOOL_VEC2]="bvec2";th[Se.BOOL_VEC3]="bvec3";th[Se.BOOL_VEC4]="bvec4";th[Se.FLOAT_MAT2]="mat2";th[Se.FLOAT_MAT3]="mat3";th[Se.FLOAT_MAT4]="mat4";th[Se.SAMPLER_2D]="sampler2D";th[Se.SAMPLER_CUBE]="samplerCube";fn.prototype.getDeclaration=function(e){var r="uniform "+th[this._datatype]+" "+e,n=this._size;return n===1?r+=";":r+="["+n.toString()+"];",r};hRt={czm_viewport:new fn({size:1,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.viewportCartesian4}}),czm_currentViewportOffset:new fn({size:1,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.viewportOffset}}),czm_viewportOrthographic:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.viewportOrthographic}}),czm_viewportTransformation:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.viewportTransformation}}),czm_globeDepthTexture:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.globeDepthTexture}}),czm_model:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.model}}),czm_inverseModel:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseModel}}),czm_view:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.view}}),czm_view3D:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.view3D}}),czm_viewRotation:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.viewRotation}}),czm_viewRotation3D:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.viewRotation3D}}),czm_inverseView:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseView}}),czm_inverseView3D:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseView3D}}),czm_inverseViewRotation:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation}}),czm_inverseViewRotation3D:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.inverseViewRotation3D}}),czm_projection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.projection}}),czm_inverseProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseProjection}}),czm_infiniteProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.infiniteProjection}}),czm_modelView:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelView}}),czm_modelView3D:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelView3D}}),czm_modelViewRelativeToEye:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelViewRelativeToEye}}),czm_inverseModelView:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseModelView}}),czm_inverseModelView3D:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseModelView3D}}),czm_viewProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.viewProjection}}),czm_inverseViewProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseViewProjection}}),czm_modelViewProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelViewProjection}}),czm_inverseModelViewProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.inverseModelViewProjection}}),czm_modelViewProjectionRelativeToEye:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelViewProjectionRelativeToEye}}),czm_modelViewInfiniteProjection:new fn({size:1,datatype:Se.FLOAT_MAT4,getValue:function(e){return e.modelViewInfiniteProjection}}),czm_orthographicIn3D:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.orthographicIn3D?1:0}}),czm_normal:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.normal}}),czm_normal3D:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.normal3D}}),czm_inverseNormal:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.inverseNormal}}),czm_inverseNormal3D:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.inverseNormal3D}}),czm_eyeHeight2D:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.eyeHeight2D}}),czm_entireFrustum:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.entireFrustum}}),czm_currentFrustum:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.currentFrustum}}),czm_frustumPlanes:new fn({size:1,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.frustumPlanes}}),czm_farDepthFromNearPlusOne:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.farDepthFromNearPlusOne}}),czm_log2FarDepthFromNearPlusOne:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.log2FarDepthFromNearPlusOne}}),czm_oneOverLog2FarDepthFromNearPlusOne:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.oneOverLog2FarDepthFromNearPlusOne}}),czm_sunPositionWC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sunPositionWC}}),czm_sunPositionColumbusView:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sunPositionColumbusView}}),czm_sunDirectionEC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sunDirectionEC}}),czm_sunDirectionWC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sunDirectionWC}}),czm_moonDirectionEC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.moonDirectionEC}}),czm_lightDirectionEC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.lightDirectionEC}}),czm_lightDirectionWC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.lightDirectionWC}}),czm_lightColor:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.lightColor}}),czm_lightColorHdr:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.lightColorHdr}}),czm_encodedCameraPositionMCHigh:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCHigh}}),czm_encodedCameraPositionMCLow:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.encodedCameraPositionMCLow}}),czm_cameraPositionWC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e._cameraPosition}}),czm_viewerPositionWC:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return Z.getTranslation(e.inverseView,xRt)}}),czm_frameNumber:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.frameState.frameNumber}}),czm_morphTime:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.frameState.morphTime}}),czm_sceneMode:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.frameState.mode}}),czm_pass:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.pass}}),czm_backgroundColor:new fn({size:1,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.backgroundColor}}),czm_brdfLut:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.brdfLut}}),czm_environmentMap:new fn({size:1,datatype:Se.SAMPLER_CUBE,getValue:function(e){return e.environmentMap}}),czm_specularEnvironmentMaps:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.specularEnvironmentMaps}}),czm_specularEnvironmentMapSize:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.specularEnvironmentMapsDimensions}}),czm_specularEnvironmentMapsMaximumLOD:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.specularEnvironmentMapsMaximumLOD}}),czm_sphericalHarmonicCoefficients:new fn({size:9,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sphericalHarmonicCoefficients}}),czm_SH:new fn({size:7,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.sphericalHarmonics.shArr}}),czm_temeToPseudoFixed:new fn({size:1,datatype:Se.FLOAT_MAT3,getValue:function(e){return e.temeToPseudoFixedMatrix}}),czm_pixelRatio:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.pixelRatio}}),czm_resolutionScale:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.resolutionScale}}),czm_fogDensity:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.fogDensity}}),czm_imagerySplitPosition:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.imagerySplitPosition}}),czm_globeSplitPosition:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.globeSplitPosition}}),czm_geometricToleranceOverMeter:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.geometricToleranceOverMeter}}),czm_minimumDisableDepthTestDistance:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.minimumDisableDepthTestDistance}}),czm_invertClassificationColor:new fn({size:1,datatype:Se.FLOAT_VEC4,getValue:function(e){return e.invertClassificationColor}}),czm_gamma:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.gamma}}),czm_sunColor:new fn({size:1,datatype:Se.FLOAT_VEC3,getValue:function(e){return e.sunColor}}),czm_globeDepthTextureDim:new fn({size:1,datatype:Se.FLOAT_VEC2,getValue:function(e){return e.globeDepthTextureDim}}),czm_nonSelDepthTexture:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.nonSelDepthTexture}}),czm_maskTexture:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.maskTexture}}),czm_hdrEnvMap:new fn({size:1,datatype:Se.SAMPLER_2D,getValue:function(e){return e.hdrEnvMap}}),czm_toneMappingExposure:new fn({size:1,datatype:Se.FLOAT,getValue:function(e){return e.toneMappingExposure}})},VS=hRt});function dRt(e,r,n,o){switch(r.type){case e.FLOAT:return new KVe(e,r,n,o);case e.FLOAT_VEC2:return new ZVe(e,r,n,o);case e.FLOAT_VEC3:return new JVe(e,r,n,o);case e.FLOAT_VEC4:return new $Ve(e,r,n,o);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new Bde(e,r,n,o);case e.SAMPLER_2D_ARRAY:case e.SAMPLER_3D:return new Rde(e,r,n,o);case e.INT:case e.BOOL:return new eke(e,r,n,o);case e.INT_VEC2:case e.BOOL_VEC2:return new tke(e,r,n,o);case e.INT_VEC3:case e.BOOL_VEC3:return new rke(e,r,n,o);case e.INT_VEC4:case e.BOOL_VEC4:return new ike(e,r,n,o);case e.FLOAT_MAT2:return new nke(e,r,n,o);case e.FLOAT_MAT3:return new oke(e,r,n,o);case e.FLOAT_MAT4:return new ake(e,r,n,o);default:throw new Ht("Unrecognized uniform type: "+r.type+' for uniform "'+n+'".')}}function KVe(e,r,n,o){this.name=n,this.value=void 0,this._value=0,this._gl=e,this._location=o}function ZVe(e,r,n,o){this.name=n,this.value=void 0,this._value=new de,this._gl=e,this._location=o}function JVe(e,r,n,o){this.name=n,this.value=void 0,this._value=void 0,this._gl=e,this._location=o}function $Ve(e,r,n,o){this.name=n,this.value=void 0,this._value=void 0,this._gl=e,this._location=o}function Bde(e,r,n,o){this.name=n,this.value=void 0,this._gl=e,this._location=o,this.textureUnitIndex=void 0}function Rde(e,r,n,o){this.name=n,this.value=void 0,this._gl=e,this._location=o,this.textureUnitIndex=void 0}function eke(e,r,n,o){this.name=n,this.value=void 0,this._value=0,this._gl=e,this._location=o}function tke(e,r,n,o){this.name=n,this.value=void 0,this._value=new de,this._gl=e,this._location=o}function rke(e,r,n,o){this.name=n,this.value=void 0,this._value=new E,this._gl=e,this._location=o}function ike(e,r,n,o){this.name=n,this.value=void 0,this._value=new Ce,this._gl=e,this._location=o}function nke(e,r,n,o){this.name=n,this.value=void 0,this._value=new nu,this._gl=e,this._location=o}function oke(e,r,n,o){this.name=n,this.value=void 0,this._value=new We,this._gl=e,this._location=o}function ake(e,r,n,o){this.name=n,this.value=void 0,this._value=new Z,this._gl=e,this._location=o}var mRt,pRt,vRt,BQ,Lde=Ee(()=>{Fr();bt();Ci();Ar();De();st();CC();to();Rr();zo();y(dRt,"createUniform");y(KVe,"UniformFloat");KVe.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1f(this._location,this.value))};y(ZVe,"UniformFloatVec2");ZVe.prototype.set=function(){var e=this.value;de.equals(e,this._value)||(de.clone(e,this._value),this._gl.uniform2f(this._location,e.x,e.y))};y(JVe,"UniformFloatVec3");JVe.prototype.set=function(){var e=this.value;if(p(e.red))se.equals(e,this._value)||(this._value=se.clone(e,this._value),this._gl.uniform3f(this._location,e.red,e.green,e.blue));else if(p(e.x))E.equals(e,this._value)||(this._value=E.clone(e,this._value),this._gl.uniform3f(this._location,e.x,e.y,e.z));else throw new G('Invalid vec3 value for uniform "'+this.name+'".')};y($Ve,"UniformFloatVec4");$Ve.prototype.set=function(){var e=this.value;if(p(e.red))se.equals(e,this._value)||(this._value=se.clone(e,this._value),this._gl.uniform4f(this._location,e.red,e.green,e.blue,e.alpha));else if(p(e.x))Ce.equals(e,this._value)||(this._value=Ce.clone(e,this._value),this._gl.uniform4f(this._location,e.x,e.y,e.z,e.w));else throw new G('Invalid vec4 value for uniform "'+this.name+'".')};y(Bde,"UniformSampler");Bde.prototype.set=function(){var e=this._gl;e.activeTexture(e.TEXTURE0+this.textureUnitIndex);var r=this.value;e.bindTexture(r._target,r._texture)};Bde.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1};y(Rde,"UniformTextureArraySampler");Rde.prototype.set=function(){var e=this.value,r=this._gl;r.activeTexture(r.TEXTURE0+this.textureUnitIndex),r.bindTexture(e._target,e._texture)};Rde.prototype._setSampler=function(e){return this.textureUnitIndex=e,this._gl.uniform1i(this._location,e),e+1};y(eke,"UniformInt");eke.prototype.set=function(){this.value!==this._value&&(this._value=this.value,this._gl.uniform1i(this._location,this.value))};y(tke,"UniformIntVec2");tke.prototype.set=function(){var e=this.value;de.equals(e,this._value)||(de.clone(e,this._value),this._gl.uniform2i(this._location,e.x,e.y))};y(rke,"UniformIntVec3");rke.prototype.set=function(){var e=this.value;E.equals(e,this._value)||(E.clone(e,this._value),this._gl.uniform3i(this._location,e.x,e.y,e.z))};y(ike,"UniformIntVec4");ike.prototype.set=function(){var e=this.value;Ce.equals(e,this._value)||(Ce.clone(e,this._value),this._gl.uniform4i(this._location,e.x,e.y,e.z,e.w))};mRt=new Float32Array(4);y(nke,"UniformMat2");nke.prototype.set=function(){if(!nu.equalsArray(this.value,this._value,0)){nu.clone(this.value,this._value);var e=nu.toArray(this.value,mRt);this._gl.uniformMatrix2fv(this._location,!1,e)}};pRt=new Float32Array(9);y(oke,"UniformMat3");oke.prototype.set=function(){if(!We.equalsArray(this.value,this._value,0)){We.clone(this.value,this._value);var e=We.toArray(this.value,pRt);this._gl.uniformMatrix3fv(this._location,!1,e)}};vRt=new Float32Array(16);y(ake,"UniformMat4");ake.prototype.set=function(){if(!Z.equalsArray(this.value,this._value,0)){Z.clone(this.value,this._value);var e=Z.toArray(this.value,vRt);this._gl.uniformMatrix4fv(this._location,!1,e)}};BQ=dRt});function gRt(e,r,n,o){switch(r.type){case e.FLOAT:return new ske(e,r,n,o);case e.FLOAT_VEC2:return new lke(e,r,n,o);case e.FLOAT_VEC3:return new uke(e,r,n,o);case e.FLOAT_VEC4:return new cke(e,r,n,o);case e.SAMPLER_2D:case e.SAMPLER_CUBE:return new Ode(e,r,n,o);case e.INT:case e.BOOL:return new fke(e,r,n,o);case e.INT_VEC2:case e.BOOL_VEC2:return new xke(e,r,n,o);case e.INT_VEC3:case e.BOOL_VEC3:return new hke(e,r,n,o);case e.INT_VEC4:case e.BOOL_VEC4:return new dke(e,r,n,o);case e.FLOAT_MAT2:return new mke(e,r,n,o);case e.FLOAT_MAT3:return new pke(e,r,n,o);case e.FLOAT_MAT4:return new vke(e,r,n,o);default:throw new Ht("Unrecognized uniform type: "+r.type+' for uniform "'+n+'".')}}function ske(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a),this._gl=e,this._location=o[0]}function lke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*2),this._gl=e,this._location=o[0]}function uke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*3),this._gl=e,this._location=o[0]}function cke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*4),this._gl=e,this._location=o[0]}function Ode(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a),this._gl=e,this._locations=o,this.textureUnitIndex=void 0}function fke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Int32Array(a),this._gl=e,this._location=o[0]}function xke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Int32Array(a*2),this._gl=e,this._location=o[0]}function hke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Int32Array(a*3),this._gl=e,this._location=o[0]}function dke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Int32Array(a*4),this._gl=e,this._location=o[0]}function mke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*4),this._gl=e,this._location=o[0]}function pke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*9),this._gl=e,this._location=o[0]}function vke(e,r,n,o){var a=o.length;this.name=n,this.value=new Array(a),this._value=new Float32Array(a*16),this._gl=e,this._location=o[0]}var RQ,Fde=Ee(()=>{Fr();bt();Ci();Ar();De();st();CC();to();Rr();zo();y(gRt,"createUniformArray");y(ske,"UniformArrayFloat");ske.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0;a<r;++a){var s=e[a];s!==n[a]&&(n[a]=s,o=!0)}o&&this._gl.uniform1fv(this._location,n)};y(lke,"UniformArrayFloatVec2");lke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];de.equalsArray(l,n,a)||(de.pack(l,n,a),o=!0),a+=2}o&&this._gl.uniform2fv(this._location,n)};y(uke,"UniformArrayFloatVec3");uke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];if(p(l.red))(l.red!==n[a]||l.green!==n[a+1]||l.blue!==n[a+2])&&(n[a]=l.red,n[a+1]=l.green,n[a+2]=l.blue,o=!0);else if(p(l.x))E.equalsArray(l,n,a)||(E.pack(l,n,a),o=!0);else throw new G("Invalid vec3 value.");a+=3}o&&this._gl.uniform3fv(this._location,n)};y(cke,"UniformArrayFloatVec4");cke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];if(p(l.red))se.equalsArray(l,n,a)||(se.pack(l,n,a),o=!0);else if(p(l.x))Ce.equalsArray(l,n,a)||(Ce.pack(l,n,a),o=!0);else throw new G("Invalid vec4 value.");a+=4}o&&this._gl.uniform4fv(this._location,n)};y(Ode,"UniformArraySampler");Ode.prototype.set=function(){for(var e=this._gl,r=e.TEXTURE0+this.textureUnitIndex,n=this.value,o=n.length,a=0;a<o;++a){var s=n[a];e.activeTexture(r+a),e.bindTexture(s._target,s._texture)}};Ode.prototype._setSampler=function(e){this.textureUnitIndex=e;for(var r=this._locations,n=r.length,o=0;o<n;++o){var a=e+o;this._gl.uniform1i(r[o],a)}return e+n};y(fke,"UniformArrayInt");fke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0;a<r;++a){var s=e[a];s!==n[a]&&(n[a]=s,o=!0)}o&&this._gl.uniform1iv(this._location,n)};y(xke,"UniformArrayIntVec2");xke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];de.equalsArray(l,n,a)||(de.pack(l,n,a),o=!0),a+=2}o&&this._gl.uniform2iv(this._location,n)};y(hke,"UniformArrayIntVec3");hke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];E.equalsArray(l,n,a)||(E.pack(l,n,a),o=!0),a+=3}o&&this._gl.uniform3iv(this._location,n)};y(dke,"UniformArrayIntVec4");dke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];Ce.equalsArray(l,n,a)||(Ce.pack(l,n,a),o=!0),a+=4}o&&this._gl.uniform4iv(this._location,n)};y(mke,"UniformArrayMat2");mke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];nu.equalsArray(l,n,a)||(nu.pack(l,n,a),o=!0),a+=4}o&&this._gl.uniformMatrix2fv(this._location,!1,n)};y(pke,"UniformArrayMat3");pke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];We.equalsArray(l,n,a)||(We.pack(l,n,a),o=!0),a+=9}o&&this._gl.uniformMatrix3fv(this._location,!1,n)};y(vke,"UniformArrayMat4");vke.prototype.set=function(){for(var e=this.value,r=e.length,n=this._value,o=!1,a=0,s=0;s<r;++s){var l=e[s];Z.equalsArray(l,n,a)||(Z.pack(l,n,a),o=!0),a+=16}o&&this._gl.uniformMatrix4fv(this._location,!1,n)};RQ=gRt});function f1(e){var r=yRt(e.vertexShaderText,e.fragmentShaderText);this._gl=e.gl,this._logShaderCompilation=e.logShaderCompilation,this._debugShaders=e.debugShaders,this._attributeLocations=e.attributeLocations,this._varyings=e.varyings,this._bufferMode=e.bufferMode,this._program=void 0,this._numberOfVertexAttributes=void 0,this._vertexAttributes=void 0,this._uniformsByName=void 0,this._uniforms=void 0,this._automaticUniforms=void 0,this._manualUniforms=void 0,this._duplicateUniformNames=r.duplicateUniformNames,this._cachedShader=void 0,this._uniformBlockLocation={},this.maximumTextureUnitIndex=void 0,this._vertexShaderSource=e.vertexShaderSource,this._vertexShaderText=e.vertexShaderText,this._fragmentShaderSource=e.fragmentShaderSource,this._fragmentShaderText=r.fragmentShaderText,this.id=_Rt++}function gke(e){var r=[],n=e.match(/uniform.*?(?![^{]*})(?=[=\[;])/g);if(p(n))for(var o=n.length,a=0;a<o;a++){var s=n[a].trim(),l=s.slice(s.lastIndexOf(" ")+1);r.push(l)}return r}function yRt(e,r){var n={};if(!fi.highpFloatSupported||!fi.highpIntSupported){var o,a,s,l,h=gke(e),x=gke(r),m=h.length,v=x.length;for(o=0;o<m;o++)for(a=0;a<v;a++)if(h[o]===x[a]){s=h[o],l="czm_mediump_"+s;var _=new RegExp(s+"\\b","g");r=r.replace(_,l),n[l]=s}}return{fragmentShaderText:r,duplicateUniformNames:n}}function ARt(e,r){var n=r._vertexShaderText,o=r._fragmentShaderText,a=e.createShader(e.VERTEX_SHADER);e.shaderSource(a,n),e.compileShader(a);var s=e.createShader(e.FRAGMENT_SHADER);e.shaderSource(s,o),e.compileShader(s);var l=e.createProgram();e.attachShader(l,a),e.attachShader(l,s),e.deleteShader(a),e.deleteShader(s);var h=r._attributeLocations;if(p(h))for(var x in h)h.hasOwnProperty(x)&&e.bindAttribLocation(l,h[x],x);var m=r._varyings,v=r._bufferMode;p(m)&&p(v)&&e.transformFeedbackVaryings(l,m,v),e.linkProgram(l);var _;if(!e.getProgramParameter(l,e.LINK_STATUS)){var A=r._debugShaders;if(!e.getShaderParameter(s,e.COMPILE_STATUS)){if(_=e.getShaderInfoLog(s),console.error(yg+"Fragment shader compile log: "+_),p(A)){var T=A.getTranslatedShaderSource(s);console.error(T!==""?yg+`Translated fragment shader source:
`+T:yg+"Fragment shader translation failed.")}throw e.deleteProgram(l),new Ht("Fragment shader failed to compile.  Compile log: "+_)}if(!e.getShaderParameter(a,e.COMPILE_STATUS)){if(_=e.getShaderInfoLog(a),console.error(yg+"Vertex shader compile log: "+_),p(A)){var w=A.getTranslatedShaderSource(a);console.error(w!==""?yg+`Translated vertex shader source:
`+w:yg+"Vertex shader translation failed.")}throw e.deleteProgram(l),new Ht("Vertex shader failed to compile.  Compile log: "+_)}throw _=e.getProgramInfoLog(l),console.error(yg+"Shader program link log: "+_),p(A)&&(console.error(yg+`Translated vertex shader source:
`+A.getTranslatedShaderSource(a)),console.error(yg+`Translated fragment shader source:
`+A.getTranslatedShaderSource(s))),e.deleteProgram(l),new Ht("Program failed to link.  Link log: "+_)}var S=r._logShaderCompilation;return S&&(_=e.getShaderInfoLog(a),p(_)&&_.length>0&&console.log(yg+"Vertex shader compile log: "+_)),S&&(_=e.getShaderInfoLog(s),p(_)&&_.length>0&&console.log(yg+"Fragment shader compile log: "+_)),S&&(_=e.getProgramInfoLog(l),p(_)&&_.length>0&&console.log(yg+"Shader program link log: "+_)),l}function CRt(e,r,n){for(var o={},a=0;a<n;++a){var s=e.getActiveAttrib(r,a),l=e.getAttribLocation(r,s.name);o[s.name]={name:s.name,type:s.type,index:l}}return o}function TRt(e,r){for(var n={},o=[],a=[],s=e.getProgramParameter(r,e.ACTIVE_UNIFORMS),l=0;l<s;++l){var h=e.getActiveUniform(r,l),x="[0]",m=h.name.indexOf(x,h.name.length-x.length)!==-1?h.name.slice(0,h.name.length-3):h.name;if(m.indexOf("gl_")!==0)if(h.name.indexOf("[")<0){var v=e.getUniformLocation(r,m);if(v!==null){var _=BQ(e,h,m,v);n[m]=_,o.push(_),_._setSampler&&a.push(_)}}else{var A,T,w,S,P=m.indexOf("[");if(P>=0){if(A=n[m.slice(0,P)],!p(A))continue;T=A._locations,T.length<=1&&(w=A.value,S=e.getUniformLocation(r,m),S!==null&&(T.push(S),w.push(e.getUniform(r,S))))}else{T=[];for(var M=0;M<h.size;++M)S=e.getUniformLocation(r,m+"["+M+"]"),S!==null&&T.push(S);A=RQ(e,h,m,T),n[m]=A,o.push(A),A._setSampler&&a.push(A)}}}return{uniformsByName:n,uniforms:o,samplerUniforms:a}}function wRt(e,r){var n=[],o=[];for(var a in r)if(r.hasOwnProperty(a)){var s=r[a],l=a,h=e._duplicateUniformNames[l];p(h)&&(s.name=h,l=h);var x=VS[l];p(x)?n.push({uniform:s,automaticUniform:x}):o.push(s)}return{automaticUniforms:n,manualUniforms:o}}function ERt(e,r,n){e.useProgram(r);for(var o=0,a=n.length,s=0;s<a;++s)o=n[s]._setSampler(o);return e.useProgram(null),o}function LQ(e){if(!p(e._program)){var r=e._gl,n=ARt(r,e,e._debugShaders),o=r.getProgramParameter(n,r.ACTIVE_ATTRIBUTES),a=TRt(r,n),s=wRt(e,a.uniformsByName);e._program=n,e._numberOfVertexAttributes=o,e._vertexAttributes=CRt(r,n,o),e._uniformsByName=a.uniformsByName,e._uniforms=a.uniforms,e._automaticUniforms=s.automaticUniforms,e._manualUniforms=s.manualUniforms,e.maximumTextureUnitIndex=ERt(r,n,a.samplerUniforms)}}var _Rt,yg,fr,so=Ee(()=>{cr();Ze();De();ur();st();zo();MQ();Pl();Lde();Fde();_Rt=0;y(f1,"ShaderProgram");f1.fromCache=function(e){return e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context),e.context.shaderCache.getShaderProgram(e)};f1.replaceCache=function(e){return e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context),e.context.shaderCache.replaceShaderProgram(e)};Object.defineProperties(f1.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},vertexAttributes:{get:function(){return LQ(this),this._vertexAttributes}},numberOfVertexAttributes:{get:function(){return LQ(this),this._numberOfVertexAttributes}},allUniforms:{get:function(){return LQ(this),this._uniformsByName}}});y(gke,"extractUniforms");y(yRt,"handleUniformPrecisionMismatches");yg="[Cesium WebGL] ";y(ARt,"createAndLinkProgram");y(CRt,"findVertexAttributes");y(TRt,"findUniforms");y(wRt,"partitionUniforms");y(ERt,"setSamplerUniforms");y(LQ,"initialize");f1.prototype._bind=function(){LQ(this),this._gl.useProgram(this._program)};f1.prototype._setUniforms=function(e,r,n){var o,a;if(p(e)){var s=this._manualUniforms;for(o=s.length,a=0;a<o;++a){var l=s[a];l.value=e[l.name]()}}var h=this._automaticUniforms;for(o=h.length,a=0;a<o;++a){var x=h[a];x.uniform.value=x.automaticUniform.getValue(r)}var m=this._uniforms;for(o=m.length,a=0;a<o;++a)m[a].set();if(n){var v=this._gl,_=this._program;if(v.validateProgram(_),!v.getProgramParameter(_,v.VALIDATE_STATUS))throw new G("Program validation failed.  Program info log: "+v.getProgramInfoLog(_))}};f1.prototype.isDestroyed=function(){return!1};f1.prototype.destroy=function(){this._cachedShader.cache.releaseShaderProgram(this)};f1.prototype.finalDestroy=function(){return this._gl.deleteProgram(this._program),$e(this)};fr=f1});function bRt(e,r){var n=/#define OUTPUT_DECLARATION/,o=e.split(`
`);if(/#version 300 es/g.test(e))return e;var a=-1,s,l;for(s=0;s<o.length;++s)if(l=o[s],n.test(l)){a=s;break}if(a===-1)throw new G("Could not find a #define OUTPUT_DECLARATION!");var h=[];for(s=0;s<10;s++){var x="gl_FragData\\["+s+"\\]",m="czm_out"+s,v=new RegExp(x,"g");v.test(e)&&(_ke(m,h),x1(x,m,o),o.splice(a,0,"layout(location = "+s+") out vec4 "+m+";"),a+=1)}var _="czm_fragColor";IRt("gl_FragColor",o)&&(_ke(_,h),x1("gl_FragColor",_,o),o.splice(a,0,"layout(location = 0) out vec4 czm_fragColor;"),a+=1);var A=DRt(h,o),T={};for(s=0;s<o.length;s++){l=o[s];for(var w in A)if(A.hasOwnProperty(w)){var S=new RegExp("(layout)[^]+(out)[^]+("+w+")[^]+","g");S.test(l)&&(T[l]=w)}}for(var P in T)if(T.hasOwnProperty(P)){var M=T[P],L=o.indexOf(P),R=A[M],O=R.length,N;for(N=0;N<O;N++)o.splice(L,0,R[N]);for(L+=O+1,N=O-1;N>=0;N--)o.splice(L,0,"#endif //"+R[N])}var k="#version 300 es",z=!1;for(s=0;s<o.length;s++)/#version/.test(o[s])&&(o[s]=k,z=!0);return z||o.splice(0,0,k),yke("EXT_draw_buffers",o),yke("EXT_frag_depth",o),x1("texture2D","texture",o),x1("texture3D","texture",o),x1("textureCube","texture",o),x1("gl_FragDepthEXT","gl_FragDepth",o),r?x1("varying","in",o):(x1("attribute","in",o),x1("varying","out",o)),PRt(o)}function x1(e,r,n){for(var o="(^|[^\\w])("+e+")($|[^\\w])",a=new RegExp(o,"g"),s=n.length,l=0;l<s;++l){var h=n[l];n[l]=h.replace(a,"$1"+r+"$3")}}function SRt(e,r,n){for(var o=n.length,a=0;a<o;++a){var s=n[a];n[a]=s.replace(e,r)}}function IRt(e,r){for(var n="(^|[^\\w])("+e+")($|[^\\w])",o=new RegExp(n,"g"),a=r.length,s=0;s<a;++s){var l=r[s];if(o.test(l))return!0}return!1}function PRt(e){for(var r="",n=e.length,o=0;o<n;++o)r+=e[o]+`
`;return r}function _ke(e,r){r.indexOf(e)===-1&&r.push(e)}function DRt(e,r){for(var n={},o=e.length,a=[],s=0;s<r.length;++s){var l=r[s],h=/(#ifdef|#if)/g.test(l),x=/#else/g.test(l),m=/#endif/g.test(l);if(h)a.push(l);else if(x){var v=a[a.length-1],_=v.replace("ifdef","ifndef");/if/g.test(_)&&(_=_.replace(/(#if\s+)(\S*)([^]*)/,"$1!($2)$3")),a.pop(),a.push(_)}else if(m)a.pop();else if(!/layout/g.test(l))for(var A=0;A<o;++A){var T=e[A];l.indexOf(T)!==-1&&(p(n[T])?n[T]=n[T].filter(function(w){return a.indexOf(w)>=0}):n[T]=a.slice())}}return n}function yke(e,r){var n="#extension\\s+GL_"+e+"\\s+:\\s+[a-zA-Z0-9]+\\s*$";SRt(new RegExp(n,"g"),"",r)}var OQ,Nde=Ee(()=>{De();st();y(bRt,"modernizeShader");y(x1,"replaceInSourceString");y(SRt,"replaceInSourceRegex");y(IRt,"findInSource");y(PRt,"compileSource");y(_ke,"setAdd");y(DRt,"getVariablePreprocessorBranch");y(yke,"removeExtension");OQ=bRt});function Ake(e){}function MRt(e){return!(e.indexOf("defined",0)>=0||e.indexOf("#if ",0)>=0||e.indexOf("#elif ",0)>=0)}function BRt(e,r,n){var o=e.indexOf(`
`,n+r+1),a=n+r+1;return e.substring(a,o)}function Cke(e){this.ifIndex=p(e.ifIndex)?e.ifIndex:void 0,this.elseIndex=p(e.elseIndex)?e.elseIndex:void 0,this.endIndex=p(e.endIndex)?e.endIndex:void 0,this.ifChildTokens=[],this.elseChildTokens=[],this.parentToken=p(e.parentToken)?e.parentToken:void 0,this.type=p(e.type)?e.type:void 0}function iB(e,r){this.Key=e,this.String=r,this.StringLength=r.length}function RRt(e,r){var n=-1,o=Sy.TK_IFDEF;for(var a in Sy){var s=Sy[a],l=e.indexOf(s.String,r);(n===-1||l>=0&&l<n)&&(n=l,o=s)}return{type:o,findIndex:n}}function LRt(e){for(var r=[],n=0,o=0,a=void 0;n!==-1;){var s=RRt(e,o);if(n=s.findIndex,o=n+s.type.StringLength,n===-1)break;switch(s.type.Key){case Sy.TK_IFDEF.Key:case Sy.TK_IFNEF.Key:{var l=new Cke({type:s.type,ifIndex:n});p(a)?p(a.endIndex)?(p(a.parentToken)||r.push(l),a=l):(a.addChildToken(l),l.parentToken=a,a=l):(a=l,r.push(l));break}case Sy.TK_ELSE.Key:{if(!p(a))continue;a.elseIndex=n;break}case Sy.TK_END.Key:{if(!p(a))continue;a.endIndex=n,p(a.parentToken)&&(a=a.parentToken);break}default:break}}return r}function ORt(e,r,n){return iB.isEqual(n,Sy.TK_IFDEF)&&p(e[r.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")])?!0:!!(iB.isEqual(n,Sy.TK_IFNEF)&&!p(e[r.replace(/^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g,"")]))}function zde(e,r,n,o){var a=0,s=0,l=e.type.StringLength,h=BRt(n,l,e.ifIndex),x=ORt(r,h,e.type);if(x){p(e.elseIndex)&&(a=e.elseIndex+Sy.TK_ELSE.StringLength+1,o.push({startIndex:a,endIndex:e.endIndex}));for(var m=0;m<e.ifChildTokens.length;m++)zde(e.ifChildTokens[m],r,n,o)}else{p(e.elseIndex)?o.push({startIndex:e.ifIndex+e.type.StringLength+FRt(n,e.ifIndex,e.type.String)+h.length,endIndex:e.elseIndex}):o.push({startIndex:e.ifIndex,endIndex:e.endIndex+Sy.TK_END.StringLength});for(var m=0;m<e.elseChildTokens.length;m++)zde(e.elseChildTokens[m],r,n,o)}}function FRt(e,r,n){for(var o=n.length,a=r+o;a<e.length;a++){var s=e.charAt(a);if(s!==" ")break}return a-(r+o)}function NRt(e,r,n){var o=r.defines,a={};if(p(o))for(var s=0;s<o.length;++s){var l=o[s];a[l]=1}if(p(e._sysShaderDefines))for(var s=0;s<e._sysShaderDefines.length;++s){var h=e._sysShaderDefines[s];a[h]=1}for(var x=0,m=0;x!==-1&&(x=n.indexOf("#define ",m),x!==-1);){var v=x+8,_=n.indexOf(`
`,x),A=n.substring(v,_).trim();a[A]=1,m=_}return a}function zRt(e,r,n,o,a){if(n.length!==0)for(var s=NRt(e,r,o),l=0;l<n.length;l++){var h=n[l];zde(h,s,o,a)}}function VRt(e,r){for(var n=e,o=0;o<r.length;o++){var a=r[o];if(a.endIndex-a.startIndex>1){var s=e.substring(a.startIndex,a.endIndex);n=n.replace(s,"")}}return n=n.replace(/(#ifdef|#ifndef|#else|#endif).*/gm,""),n}var Sy,FH,Vde=Ee(()=>{De();y(Ake,"GLSLPreprocessor");Ake.removeUnuseMacroCode=function(e,r,n){if(!MRt(n))return n;var o=LRt(n),a=[];return zRt(e,r,o,n,a),VRt(n,a)};y(MRt,"isCodeValid");y(BRt,"findDefineNameFromDefineIndex");y(Cke,"DefineToken");Cke.prototype.addChildToken=function(e){p(this.elseIndex)?this.elseChildTokens.push(e):this.ifChildTokens.push(e)};y(iB,"TokenType");iB.isEqual=function(e,r){return e.Key===r.Key};Sy={TK_IFDEF:new iB(0,"#ifdef"),TK_IFNEF:new iB(1,"#ifndef"),TK_ELSE:new iB(2,"#else"),TK_END:new iB(3,"#endif")};y(RRt,"findNextKeyWords");y(LRt,"constructMacroTree");y(ORt,"isIfDefineExist");y(zde,"traverseTokenMarkUnuse");y(FRt,"calcSpaceCountBetweenDirectiveAndMacro");y(NRt,"constructDefineMap");y(zRt,"markUnuseCode");y(VRt,"removeUnuseCode");FH=Ake});var Tke,wke=Ee(()=>{Tke=`/**
 * A built-in GLSL floating-point constant for converting radians to degrees.
 *
 * @alias czm_degreesPerRadian
 * @glslConstant
 *
 * @see CesiumMath.DEGREES_PER_RADIAN
 *
 * @example
 * // GLSL declaration
 * const float czm_degreesPerRadian = ...;
 *
 * // Example
 * float deg = czm_degreesPerRadian * rad;
 */
const float czm_degreesPerRadian = 57.29577951308232;
`});var Eke,bke=Ee(()=>{Eke=`/**
 * A built-in GLSL vec2 constant for defining the depth range.
 * This is a workaround to a bug where IE11 does not implement gl_DepthRange.
 *
 * @alias czm_depthRange
 * @glslConstant
 *
 * @example
 * // GLSL declaration
 * float depthRangeNear = czm_depthRange.near;
 * float depthRangeFar = czm_depthRange.far;
 *
 */
const czm_depthRangeStruct czm_depthRange = czm_depthRangeStruct(0.0, 1.0);
`});var Ske,Ike=Ee(()=>{Ske=`/**
 * The reciprocal of the radius of the WGS84 ellipsoid.
 *
 * @name czm_ellipsoidInverseRadii
 * @glslConstant
 */
const vec3 czm_ellipsoidInverseRadii = vec3(1.0 / 6378137.0, 1.0 / 6378137.0, 1.0 / 6356752.314245);
`});var Pke,Dke=Ee(()=>{Pke=`/**
 * The radius of the WGS84 ellipsoid.
 *
 * @name czm_ellipsoidRadii
 * @glslConstant
 */
const vec3 czm_ellipsoidRadii = vec3(6378137.0, 6378137.0, 6356752.314245);
`});var Mke,Bke=Ee(()=>{Mke=`/**
 * 0.1
 *
 * @name czm_epsilon1
 * @glslConstant
 */
const float czm_epsilon1 = 0.1;
`});var Rke,Lke=Ee(()=>{Rke=`/**
 * 0.01
 *
 * @name czm_epsilon2
 * @glslConstant
 */
const float czm_epsilon2 = 0.01;
`});var Oke,Fke=Ee(()=>{Oke=`/**
 * 0.001
 *
 * @name czm_epsilon3
 * @glslConstant
 */
const float czm_epsilon3 = 0.001;
`});var Nke,zke=Ee(()=>{Nke=`/**
 * 0.0001
 *
 * @name czm_epsilon4
 * @glslConstant
 */
const float czm_epsilon4 = 0.0001;
`});var Vke,kke=Ee(()=>{Vke=`/**
 * 0.00001
 *
 * @name czm_epsilon5
 * @glslConstant
 */
const float czm_epsilon5 = 0.00001;
`});var Uke,Gke=Ee(()=>{Uke=`/**
 * 0.000001
 *
 * @name czm_epsilon6
 * @glslConstant
 */
const float czm_epsilon6 = 0.000001;
`});var Hke,Wke=Ee(()=>{Hke=`/**
 * 0.0000001
 *
 * @name czm_epsilon7
 * @glslConstant
 */
const float czm_epsilon7 = 0.0000001;
`});var qke,jke=Ee(()=>{qke=`/**
 * DOC_TBA
 *
 * @name czm_infinity
 * @glslConstant
 */
const float czm_infinity = 5906376272000.0;  // Distance from the Sun to Pluto in meters.  TODO: What is best given lowp, mediump, and highp?
`});var Yke,Qke=Ee(()=>{Yke=`/**
 * A built-in GLSL floating-point constant for <code>1/pi</code>.
 *
 * @alias czm_oneOverPi
 * @glslConstant
 *
 * @see CesiumMath.ONE_OVER_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_oneOverPi = ...;
 *
 * // Example
 * float pi = 1.0 / czm_oneOverPi;
 */
const float czm_oneOverPi = 0.3183098861837907;
`});var Xke,Kke=Ee(()=>{Xke=`/**
 * A built-in GLSL floating-point constant for <code>1/2pi</code>.
 *
 * @alias czm_oneOverTwoPi
 * @glslConstant
 *
 * @see CesiumMath.ONE_OVER_TWO_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_oneOverTwoPi = ...;
 *
 * // Example
 * float pi = 2.0 * czm_oneOverTwoPi;
 */
const float czm_oneOverTwoPi = 0.15915494309189535;
`});var Zke,Jke=Ee(()=>{Zke=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE}
 *
 * @name czm_passCesium3DTile
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTile = 4.0;
`});var $ke,e4e=Ee(()=>{$ke=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE_CLASSIFICATION}
 *
 * @name czm_passCesium3DTileClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTileClassification = 5.0;
`});var t4e,r4e=Ee(()=>{t4e=`/**
 * The automatic GLSL constant for {@link Pass#CESIUM_3D_TILE_CLASSIFICATION_IGNORE_SHOW}
 *
 * @name czm_passCesium3DTileClassificationIgnoreShow
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCesium3DTileClassificationIgnoreShow = 6.0;
`});var i4e,n4e=Ee(()=>{i4e=`/**
 * The automatic GLSL constant for {@link Pass#CLASSIFICATION}
 *
 * @name czm_passClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passClassification = 7.0;
`});var o4e,a4e=Ee(()=>{o4e=`/**
 * The automatic GLSL constant for {@link Pass#COMPUTE}
 *
 * @name czm_passCompute
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passCompute = 1.0;
`});var s4e,l4e=Ee(()=>{s4e=`/**
 * The automatic GLSL constant for {@link Pass#ENVIRONMENT}
 *
 * @name czm_passEnvironment
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passEnvironment = 0.0;
`});var u4e,c4e=Ee(()=>{u4e=`/**
 * The automatic GLSL constant for {@link Pass#GLOBE}
 *
 * @name czm_passGlobe
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passGlobe = 2.0;
`});var f4e,x4e=Ee(()=>{f4e=`/**
 * The automatic GLSL constant for {@link Pass#GROUND}
 *
 * @name czm_passGround
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passGround = 4.0;
`});var h4e,d4e=Ee(()=>{h4e=`/**
 * The automatic GLSL constant for {@link Pass#OPAQUE}
 *
 * @name czm_passOpaque
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passOpaque = 12.0;
`});var m4e,p4e=Ee(()=>{m4e=`/**
 * The automatic GLSL constant for {@link Pass#OVERLAY}
 *
 * @name czm_passOverlay
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passOverlay = 20.0;`});var v4e,g4e=Ee(()=>{v4e=`/**
 * The automatic GLSL constant for {@link Pass#TERRAIN_CLASSIFICATION}
 *
 * @name czm_passTerrainClassification
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passTerrainClassification = 3.0;
`});var _4e,y4e=Ee(()=>{_4e=`/**
 * The automatic GLSL constant for {@link Pass#TRANSLUCENT}
 *
 * @name czm_passTranslucent
 * @glslConstant
 *
 * @see czm_pass
 */
const float czm_passTranslucent = 18.0;`});var A4e,C4e=Ee(()=>{A4e=`/**
 * A built-in GLSL floating-point constant for <code>Math.PI</code>.
 *
 * @alias czm_pi
 * @glslConstant
 *
 * @see CesiumMath.PI
 *
 * @example
 * // GLSL declaration
 * const float czm_pi = ...;
 *
 * // Example
 * float twoPi = 2.0 * czm_pi;
 */
const float czm_pi = 3.141592653589793;
`});var T4e,w4e=Ee(()=>{T4e=`/**
 * A built-in GLSL floating-point constant for <code>pi/4</code>.
 *
 * @alias czm_piOverFour
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_FOUR
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverFour = ...;
 *
 * // Example
 * float pi = 4.0 * czm_piOverFour;
 */
const float czm_piOverFour = 0.7853981633974483;
`});var E4e,b4e=Ee(()=>{E4e=`/**
 * A built-in GLSL floating-point constant for <code>pi/6</code>.
 *
 * @alias czm_piOverSix
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_SIX
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverSix = ...;
 *
 * // Example
 * float pi = 6.0 * czm_piOverSix;
 */
const float czm_piOverSix = 0.5235987755982988;
`});var S4e,I4e=Ee(()=>{S4e=`/**
 * A built-in GLSL floating-point constant for <code>pi/3</code>.
 *
 * @alias czm_piOverThree
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_THREE
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverThree = ...;
 *
 * // Example
 * float pi = 3.0 * czm_piOverThree;
 */
const float czm_piOverThree = 1.0471975511965976;
`});var P4e,D4e=Ee(()=>{P4e=`/**
 * A built-in GLSL floating-point constant for <code>pi/2</code>.
 *
 * @alias czm_piOverTwo
 * @glslConstant
 *
 * @see CesiumMath.PI_OVER_TWO
 *
 * @example
 * // GLSL declaration
 * const float czm_piOverTwo = ...;
 *
 * // Example
 * float pi = 2.0 * czm_piOverTwo;
 */
const float czm_piOverTwo = 1.5707963267948966;
`});var M4e,B4e=Ee(()=>{M4e=`/**
 * A built-in GLSL floating-point constant for converting degrees to radians.
 *
 * @alias czm_radiansPerDegree
 * @glslConstant
 *
 * @see CesiumMath.RADIANS_PER_DEGREE
 *
 * @example
 * // GLSL declaration
 * const float czm_radiansPerDegree = ...;
 *
 * // Example
 * float rad = czm_radiansPerDegree * deg;
 */
const float czm_radiansPerDegree = 0.017453292519943295;
`});var R4e,L4e=Ee(()=>{R4e=`/**
 * The constant identifier for the 2D {@link SceneMode}
 *
 * @name czm_sceneMode2D
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneModeColumbusView
 * @see czm_sceneMode3D
 * @see czm_sceneModeMorphing
 */
const float czm_sceneMode2D = 2.0;
`});var O4e,F4e=Ee(()=>{O4e=`/**
 * The constant identifier for the 3D {@link SceneMode}
 *
 * @name czm_sceneMode3D
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneModeColumbusView
 * @see czm_sceneModeMorphing
 */
const float czm_sceneMode3D = 3.0;
`});var N4e,z4e=Ee(()=>{N4e=`/**
 * The constant identifier for the Columbus View {@link SceneMode}
 *
 * @name czm_sceneModeColumbusView
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneMode3D
 * @see czm_sceneModeMorphing
 */
const float czm_sceneModeColumbusView = 1.0;
`});var V4e,k4e=Ee(()=>{V4e=`/**
 * The constant identifier for the Morphing {@link SceneMode}
 *
 * @name czm_sceneModeMorphing
 * @glslConstant
 * @see czm_sceneMode
 * @see czm_sceneMode2D
 * @see czm_sceneModeColumbusView
 * @see czm_sceneMode3D
 */
const float czm_sceneModeMorphing = 0.0;
`});var U4e,G4e=Ee(()=>{U4e=`/**
 * A built-in GLSL floating-point constant for one solar radius.
 *
 * @alias czm_solarRadius
 * @glslConstant
 *
 * @see CesiumMath.SOLAR_RADIUS
 *
 * @example
 * // GLSL declaration
 * const float czm_solarRadius = ...;
 */
const float czm_solarRadius = 695500000.0;
`});var H4e,W4e=Ee(()=>{H4e=`/**
 * A built-in GLSL floating-point constant for <code>3pi/2</code>.
 *
 * @alias czm_threePiOver2
 * @glslConstant
 *
 * @see CesiumMath.THREE_PI_OVER_TWO
 *
 * @example
 * // GLSL declaration
 * const float czm_threePiOver2 = ...;
 *
 * // Example
 * float pi = (2.0 / 3.0) * czm_threePiOver2;
 */
const float czm_threePiOver2 = 4.71238898038469;
`});var q4e,j4e=Ee(()=>{q4e=`/**
 * A built-in GLSL floating-point constant for <code>2pi</code>.
 *
 * @alias czm_twoPi
 * @glslConstant
 *
 * @see CesiumMath.TWO_PI
 *
 * @example
 * // GLSL declaration
 * const float czm_twoPi = ...;
 *
 * // Example
 * float pi = czm_twoPi / 2.0;
 */
const float czm_twoPi = 6.283185307179586;
`});var Y4e,Q4e=Ee(()=>{Y4e=`/**
 * The maximum latitude, in radians, both North and South, supported by a Web Mercator
 * (EPSG:3857) projection.  Technically, the Mercator projection is defined
 * for any latitude up to (but not including) 90 degrees, but it makes sense
 * to cut it off sooner because it grows exponentially with increasing latitude.
 * The logic behind this particular cutoff value, which is the one used by
 * Google Maps, Bing Maps, and Esri, is that it makes the projection
 * square.  That is, the rectangle is equal in the X and Y directions.
 *
 * The constant value is computed as follows:
 *   czm_pi * 0.5 - (2.0 * atan(exp(-czm_pi)))
 *
 * @name czm_webMercatorMaxLatitude
 * @glslConstant
 */
const float czm_webMercatorMaxLatitude = 1.4844222297453324;
`});var X4e,K4e=Ee(()=>{X4e=`/**
 * @name czm_depthRangeStruct
 * @glslStruct
 */
struct czm_depthRangeStruct
{
    float near;
    float far;
};
`});var Z4e,J4e=Ee(()=>{Z4e=`/** DOC_TBA
 *
 * @name czm_ellipsoid
 * @glslStruct
 */
struct czm_ellipsoid
{
    vec3 center;
    vec3 radii;
    vec3 inverseRadii;
    vec3 inverseRadiiSquared;
};
`});var $4e,eUe=Ee(()=>{$4e=`/**
 * Holds material information that can be used for lighting. Returned by all czm_getMaterial functions.
 *
 * @name czm_material
 * @glslStruct
 *
 * @property {vec3} diffuse Incoming light that scatters evenly in all directions.
 * @property {float} specular Intensity of incoming light reflecting in a single direction.
 * @property {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.
 * @property {vec3} normal Surface's normal in eye coordinates. It is used for effects such as normal mapping. The default is the surface's unmodified normal.
 * @property {vec3} emission Light emitted by the material equally in all directions. The default is vec3(0.0), which emits no light.
 * @property {float} alpha Opacity of this material. 0.0 is completely transparent; 1.0 is completely opaque.
 */
struct czm_material
{
    vec3 diffuse;
    float specular;
    float shininess;
    vec3 normal;
    vec3 emission;
    float alpha;
};
`});var tUe,rUe=Ee(()=>{tUe=`/**
 * Used as input to every material's czm_getMaterial function.
 *
 * @name czm_materialInput
 * @glslStruct
 *
 * @property {float} s 1D texture coordinates.
 * @property {vec2} st 2D texture coordinates.
 * @property {vec3} str 3D texture coordinates.
 * @property {vec3} normalEC Unperturbed surface normal in eye coordinates.
 * @property {mat3} tangentToEyeMatrix Matrix for converting a tangent space normal to eye space.
 * @property {vec3} positionToEyeEC Vector from the fragment to the eye in eye coordinates.  The magnitude is the distance in meters from the fragment to the eye.
 * @property {float} height The height of the terrain in meters above or below the WGS84 ellipsoid.  Only available for globe materials.
 * @property {float} slope The slope of the terrain normalized from 0 to 1.  0 is completely vertical, 1 is completely flat.  Only available for globe materials.
 */
struct czm_materialInput
{
    float s;
    vec2 st;
    vec3 str;
    vec3 normalEC;
    mat3 tangentToEyeMatrix;
    vec3 positionToEyeEC;
    float height;
    float slope;
};
`});var iUe,nUe=Ee(()=>{iUe=`/**
 * DOC_TBA
 *
 * @name czm_ray
 * @glslStruct
 */
struct czm_ray
{
    vec3 origin;
    vec3 direction;
};
`});var oUe,aUe=Ee(()=>{oUe=`/**
 * DOC_TBA
 *
 * @name czm_raySegment
 * @glslStruct
 */
struct czm_raySegment
{
    float start;
    float stop;
};

/**
 * DOC_TBA
 *
 * @name czm_emptyRaySegment
 * @glslConstant 
 */
const czm_raySegment czm_emptyRaySegment = czm_raySegment(-czm_infinity, -czm_infinity);

/**
 * DOC_TBA
 *
 * @name czm_fullRaySegment
 * @glslConstant 
 */
const czm_raySegment czm_fullRaySegment = czm_raySegment(0.0, czm_infinity);
`});var sUe,lUe=Ee(()=>{sUe=`struct czm_s3mMaterialInput
{
    vec4 ambientColor;
    vec4 diffuseColor;
    vec4 ambientLightColor;
    vec4 sunLightColor;
    mat4 texMatrix;
    float texture0Width;
    float texture1Width;
    vec3 sunDirectionEC;
    float sunLightON;
    vec3 normalWorld;
    vec3 normalGround;
    vec3 positionWorld;
    vec3 sunDirectionWC;
    vec4 surfaceAlbedo;
};
`});var uUe,cUe=Ee(()=>{uUe=`struct czm_shadowParameters
{
#ifdef USE_CUBE_MAP_SHADOW
    vec3 texCoords;
#else
    vec2 texCoords;
#endif

    float depthBias;
    float depth;
    float nDotL;
    vec2 texelStepSize;
    float normalShadingSmooth;
    float darkness;
};
`});var fUe,xUe=Ee(()=>{fUe=`// See:

vec3 czm_acesTonemapping(vec3 color) {
    float g = 0.985;
    float a = 0.065;
    float b = 0.0001;
    float c = 0.433;
    float d = 0.238;

    color = (color * (color + a) - b) / (color * (g * color + c) + d);

    color = clamp(color, 0.0, 1.0);

    return color;
}
`});var hUe,dUe=Ee(()=>{hUe=`uniform float uBrightness;
uniform float uContrast;
uniform float uHue;
uniform float uSaturation;
uniform float uOneOverGamma;
vec3 czm_adjustColor(vec3 inputColor)
{
    vec3 outputColor = inputColor;
    outputColor.rgb = mix(vec3(0.0), outputColor.rgb, uBrightness);
    outputColor.rgb = mix(vec3(0.5), outputColor.rgb, uContrast);
    outputColor.rgb = czm_hue(outputColor.rgb, uHue);
    outputColor.rgb = clamp(outputColor.rgb, 0.0, 1.0);
    outputColor.rgb = czm_saturation(outputColor.rgb, uSaturation);
    outputColor.rgb = pow(outputColor.rgb, vec3(uOneOverGamma));
    return outputColor;
}`});var mUe,pUe=Ee(()=>{mUe=`/**
 * @private
 */
float czm_alphaWeight(float a)
{
    float z = (gl_FragCoord.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];

    // See Weighted Blended Order-Independent Transparency for examples of different weighting functions:
    return pow(a + 0.01, 4.0) + max(1e-2, min(3.0 * 1e3, 0.003 / (1e-5 + pow(abs(z) / 200.0, 4.0))));
}
`});var vUe,gUe=Ee(()=>{vUe=`/**
 * Procedural anti-aliasing by blurring two colors that meet at a sharp edge.
 *
 * @name czm_antialias
 * @glslFunction
 *
 * @param {vec4} color1 The color on one side of the edge.
 * @param {vec4} color2 The color on the other side of the edge.
 * @param {vec4} currentcolor The current color, either <code>color1</code> or <code>color2</code>.
 * @param {float} dist The distance to the edge in texture coordinates.
 * @param {float} [fuzzFactor=0.1] Controls the blurriness between the two colors.
 * @returns {vec4} The anti-aliased color.
 *
 * @example
 * // GLSL declarations
 * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor);
 * vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist);
 *
 * // get the color for a material that has a sharp edge at the line y = 0.5 in texture space
 * float dist = abs(textureCoordinates.t - 0.5);
 * vec4 currentColor = mix(bottomColor, topColor, step(0.5, textureCoordinates.t));
 * vec4 color = czm_antialias(bottomColor, topColor, currentColor, dist, 0.1);
 */
vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist, float fuzzFactor)
{
    float val1 = clamp(dist / fuzzFactor, 0.0, 1.0);
    float val2 = clamp((dist - 0.5) / fuzzFactor, 0.0, 1.0);
    val1 = val1 * (1.0 - val2);
    val1 = val1 * val1 * (3.0 - (2.0 * val1));
    val1 = pow(val1, 0.5); //makes the transition nicer
    
    vec4 midColor = (color1 + color2) * 0.5;
    return mix(midColor, currentColor, val1);
}

vec4 czm_antialias(vec4 color1, vec4 color2, vec4 currentColor, float dist)
{
    return czm_antialias(color1, color2, currentColor, dist, 0.1);
}
`});var _Ue,yUe=Ee(()=>{_Ue=`/**
 * Approximately computes spherical coordinates given a normal.
 * Uses approximate inverse trigonometry for speed and consistency,
 * since inverse trigonometry can differ from vendor-to-vendor and when compared with the CPU.
 *
 * @name czm_approximateSphericalCoordinates
 * @glslFunction
 *
 * @param {vec3} normal arbitrary-length normal.
 *
 * @returns {vec2} Approximate latitude and longitude spherical coordinates.
 */
vec2 czm_approximateSphericalCoordinates(vec3 normal) {
    // Project into plane with vertical for latitude
    float latitudeApproximation = czm_fastApproximateAtan(sqrt(normal.x * normal.x + normal.y * normal.y), normal.z);
    float longitudeApproximation = czm_fastApproximateAtan(normal.x, normal.y);
    return vec2(latitudeApproximation, longitudeApproximation);
}
`});var AUe,CUe=Ee(()=>{AUe=`/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a float expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {float} a Value to return if the comparison is true.
 * @param {float} b Value to return if the comparison is false.
 *
 * @returns {float} equivalent of comparison ? a : b
 */
float czm_branchFreeTernary(bool comparison, float a, float b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec2 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec2} a Value to return if the comparison is true.
 * @param {vec2} b Value to return if the comparison is false.
 *
 * @returns {vec2} equivalent of comparison ? a : b
 */
vec2 czm_branchFreeTernary(bool comparison, vec2 a, vec2 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec3 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec3} a Value to return if the comparison is true.
 * @param {vec3} b Value to return if the comparison is false.
 *
 * @returns {vec3} equivalent of comparison ? a : b
 */
vec3 czm_branchFreeTernary(bool comparison, vec3 a, vec3 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}

/**
 * Branchless ternary operator to be used when it's inexpensive to explicitly
 * evaluate both possibilities for a vec4 expression.
 *
 * @name czm_branchFreeTernary
 * @glslFunction
 *
 * @param {bool} comparison A comparison statement
 * @param {vec3} a Value to return if the comparison is true.
 * @param {vec3} b Value to return if the comparison is false.
 *
 * @returns {vec3} equivalent of comparison ? a : b
 */
vec4 czm_branchFreeTernary(bool comparison, vec4 a, vec4 b) {
    float useA = float(comparison);
    return a * useA + b * (1.0 - useA);
}
`});var TUe,wUe=Ee(()=>{TUe=`
vec4 czm_cascadeColor(vec4 weights)
{
    return vec4(1.0, 0.0, 0.0, 1.0) * weights.x +
           vec4(0.0, 1.0, 0.0, 1.0) * weights.y +
           vec4(0.0, 0.0, 1.0, 1.0) * weights.z +
           vec4(1.0, 0.0, 1.0, 1.0) * weights.w;
}
`});var EUe,bUe=Ee(()=>{EUe=`
uniform vec4 shadowMap_cascadeDistances;

float czm_cascadeDistance(vec4 weights)
{
    return dot(shadowMap_cascadeDistances, weights);
}
`});var SUe,IUe=Ee(()=>{SUe=`
uniform mat4 shadowMap_cascadeMatrices[4];

mat4 czm_cascadeMatrix(vec4 weights)
{
    return shadowMap_cascadeMatrices[0] * weights.x +
           shadowMap_cascadeMatrices[1] * weights.y +
           shadowMap_cascadeMatrices[2] * weights.z +
           shadowMap_cascadeMatrices[3] * weights.w;
}
`});var PUe,DUe=Ee(()=>{PUe=`
uniform vec4 shadowMap_cascadeSplits[2];

vec4 czm_cascadeWeights(float depthEye)
{
    // One component is set to 1.0 and all others set to 0.0.
    vec4 near = step(shadowMap_cascadeSplits[0], vec4(depthEye));
    vec4 far = step(depthEye, shadowMap_cascadeSplits[1]);
    return near * far;
}
`});var MUe,BUe=Ee(()=>{MUe=`#ifdef GL_OES_standard_derivatives
#extension GL_OES_standard_derivatives : enable
#endif
uniform float clip_mode;
uniform vec4 clip_planes[6];
uniform vec4 clip_line_color;
const float clip_lineWidth = 3.0;

float GetClipDistance(vec3 pos, vec3 planeNormal, float disToOrigin)
{
	return dot(planeNormal, pos) + disToOrigin;
}

float ClipBehindAllPlane(float fBorderWidth, vec4 clip_vertex)
{
float distance = 0.0;
float result = -1.0;
#ifdef CLIPPLANE
distance = GetClipDistance(clip_vertex.xyz, clip_planes[0].xyz, clip_planes[0].w);
if (distance < 0.0)
{
return 1.0;
}
else if (distance < fBorderWidth)
{
result = 0.0;
}
#else
for(int i = 0; i < 6; i++)
{
distance = GetClipDistance(clip_vertex.xyz, clip_planes[i].xyz, clip_planes[i].w);
if(distance < 0.0)
{
return 1.0;
}
else if(distance < fBorderWidth)
{
result = 0.0;
}
}
#endif
return result;
}

float ClipBehindAnyPlane(float fBorderWidth, vec4 clip_vertex)
{
	float result = 1.0;
	for(int i = 0; i < 6; i++)
	{
		float distance = GetClipDistance(clip_vertex.xyz, clip_planes[i].xyz, clip_planes[i].w);
		if((distance + fBorderWidth) < 0.0)
		{
			return -1.0;
		}
		else if(distance < 0.0)
		{
			result = 0.0;
		}
	}
	return result;
}

float ClipAnythingButLine(float fBorderWidth, vec4 clip_vertex)
{
	float result = -1.0;
	for(int i = 0; i < 6; i++)
	{
		float distance = GetClipDistance(clip_vertex.xyz, clip_planes[i].xyz, clip_planes[i].w);
		if(distance < 0.0)
		{
			return -1.0;
		}
		else if(distance < fBorderWidth)
		{
			result = 0.0;
		}
	}
	return result;
}

vec4 czm_clip(vec4 clip_vertex, float fIsFiltByID)
{
    if(fIsFiltByID < 0.1)
    {
        return vec4(1.0);
    }
	if(clip_mode < 0.5)
	{
		return vec4(1.0);
	}
#ifdef GL_OES_standard_derivatives
	float dxc = abs(dFdx(clip_vertex.x));
	float dyc = abs(dFdy(clip_vertex.y));
	float fBorderWidth = max(dxc, dyc) * clip_lineWidth;
#else
	float fBorderWidth = clip_lineWidth;
#endif
	float clipResult = 1.0;
	if(clip_line_color.a < 0.01)
	{
		fBorderWidth = 0.0;
	}
	if(clip_mode < 1.5)
	{
		clipResult = ClipBehindAnyPlane(fBorderWidth, clip_vertex);
	}
	else if(clip_mode < 2.5)
	{
		clipResult = ClipBehindAllPlane(fBorderWidth, clip_vertex);
	}
	else if(clip_mode < 3.5)
	{
		clipResult = ClipAnythingButLine(fBorderWidth, clip_vertex);
	}
	if(clipResult < -0.5)
	{
		discard;
	}
	else if(clipResult < 0.5)
	{
		return clip_line_color;
	}
	else
	{
        return vec4(1.0);
	}
}`});var RUe,LUe=Ee(()=>{RUe=`/**
 * DOC_TBA
 *
 * @name czm_columbusViewMorph
 * @glslFunction
 */
vec4 czm_columbusViewMorph(vec4 position2D, vec4 position3D, float time)
{
    // Just linear for now.
    vec3 p = mix(position2D.xyz, position3D.xyz, time);
    return vec4(p, 1.0);
}
`});var OUe,FUe=Ee(()=>{OUe=`vec4 czm_computeLightColorInFP(czm_s3mMaterialInput material, vec3 positionMC, float hasNormal, vec3 normal)
{
    vec3 normalEC;
    #ifdef HAS_NORMAL
    float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;
    normalEC = normalize(normal) * faceDirection;
    #else
    normalEC = normalize(czm_normal*czm_computeNormal(positionMC));
    #endif
    vec3 positionEC = vec3(czm_modelView * vec4(positionMC,1.0)).xyz;
    return czm_directionLight(material, normalEC, -positionEC, positionMC);
}`});var NUe,zUe=Ee(()=>{NUe=`vec4 czm_computeLightColorInstanceInFP(czm_s3mMaterialInput material, vec3 positionRotateMC, vec3 positionMC, float hasNormal, vec3 normal)
{
    vec3 normalEC;
    #ifdef HAS_NORMAL
        float faceDirection = gl_FrontFacing ? 1.0 : - 1.0;
        normalEC = normalize(normal) * faceDirection;
    #else
        normalEC = normalize(czm_normal*czm_computeNormal(positionRotateMC));
    #endif
    vec3 positionEC = vec3(czm_modelView * vec4(positionMC,1.0)).xyz;
    return czm_directionLight(material, normalEC, -positionEC, positionMC);
}`});var VUe,kUe=Ee(()=>{VUe=`#ifdef GL_OES_standard_derivatives
#extension GL_OES_standard_derivatives : enable
#endif
vec3 czm_computeNormal(in vec3 oriVertex)
{
	vec3 normal = cross(vec3(dFdx(oriVertex.x), dFdx(oriVertex.y), dFdx(oriVertex.z)), vec3(dFdy(oriVertex.x), dFdy(oriVertex.y), dFdy(oriVertex.z)));
	normal = normalize(normal);
	return normal;
}`});var UUe,GUe=Ee(()=>{UUe=`/**
 * Returns a position in model coordinates relative to eye taking into
 * account the current scene mode: 3D, 2D, or Columbus view.
 * <p>
 * This uses standard position attributes, <code>position3DHigh</code>, 
 * <code>position3DLow</code>, <code>position2DHigh</code>, and <code>position2DLow</code>, 
 * and should be used when writing a vertex shader for an {@link Appearance}.
 * </p>
 *
 * @name czm_computePosition
 * @glslFunction
 *
 * @returns {vec4} The position relative to eye.
 *
 * @example
 * vec4 p = czm_computePosition();
 * v_positionEC = (czm_modelViewRelativeToEye * p).xyz;
 * gl_Position = czm_modelViewProjectionRelativeToEye * p;
 *
 * @see czm_translateRelativeToEye
 */
vec4 czm_computePosition();
`});var HUe,WUe=Ee(()=>{HUe=`/**
 * @private
 */
vec2 cordic(float angle)
{
// Scale the vector by the appropriate factor for the 24 iterations to follow.
    vec2 vector = vec2(6.0725293500888267e-1, 0.0);
// Iteration 1
    float sense = (angle < 0.0) ? -1.0 : 1.0;
 //   float factor = sense * 1.0;  // 2^-0
    mat2 rotation = mat2(1.0, sense, -sense, 1.0);
    vector = rotation * vector;
    angle -= sense * 7.8539816339744828e-1;  // atan(2^-0)
// Iteration 2
    sense = (angle < 0.0) ? -1.0 : 1.0;
    float factor = sense * 5.0e-1;  // 2^-1
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.6364760900080609e-1;  // atan(2^-1)
// Iteration 3
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.5e-1;  // 2^-2
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.4497866312686414e-1;  // atan(2^-2)
// Iteration 4
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.25e-1;  // 2^-3
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.2435499454676144e-1;  // atan(2^-3)
// Iteration 5
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 6.25e-2;  // 2^-4
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 6.2418809995957350e-2;  // atan(2^-4)
// Iteration 6
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.125e-2;  // 2^-5
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.1239833430268277e-2;  // atan(2^-5)
// Iteration 7
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.5625e-2;  // 2^-6
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.5623728620476831e-2;  // atan(2^-6)
// Iteration 8
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 7.8125e-3;  // 2^-7
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 7.8123410601011111e-3;  // atan(2^-7)
// Iteration 9
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.90625e-3;  // 2^-8
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.9062301319669718e-3;  // atan(2^-8)
// Iteration 10
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.953125e-3;  // 2^-9
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.9531225164788188e-3;  // atan(2^-9)
// Iteration 11
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 9.765625e-4;  // 2^-10
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 9.7656218955931946e-4;  // atan(2^-10)
// Iteration 12
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 4.8828125e-4;  // 2^-11
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.8828121119489829e-4;  // atan(2^-11)
// Iteration 13
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.44140625e-4;  // 2^-12
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.4414062014936177e-4;  // atan(2^-12)
// Iteration 14
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.220703125e-4;  // 2^-13
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.2207031189367021e-4;  // atan(2^-13)
// Iteration 15
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 6.103515625e-5;  // 2^-14
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 6.1035156174208773e-5;  // atan(2^-14)
// Iteration 16
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.0517578125e-5;  // 2^-15
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.0517578115526096e-5;  // atan(2^-15)
// Iteration 17
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.52587890625e-5;  // 2^-16
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.5258789061315762e-5;  // atan(2^-16)
// Iteration 18
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 7.62939453125e-6;  // 2^-17
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 7.6293945311019700e-6;  // atan(2^-17)
// Iteration 19
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 3.814697265625e-6;  // 2^-18
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 3.8146972656064961e-6;  // atan(2^-18)
// Iteration 20
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.9073486328125e-6;  // 2^-19
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 1.9073486328101870e-6;  // atan(2^-19)
// Iteration 21
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 9.5367431640625e-7;  // 2^-20
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 9.5367431640596084e-7;  // atan(2^-20)
// Iteration 22
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 4.76837158203125e-7;  // 2^-21
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 4.7683715820308884e-7;  // atan(2^-21)
// Iteration 23
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 2.384185791015625e-7;  // 2^-22
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
    angle -= sense * 2.3841857910155797e-7;  // atan(2^-22)
// Iteration 24
    sense = (angle < 0.0) ? -1.0 : 1.0;
    factor = sense * 1.1920928955078125e-7;  // 2^-23
    rotation[0][1] = factor;
    rotation[1][0] = -factor;
    vector = rotation * vector;
//    angle -= sense * 1.1920928955078068e-7;  // atan(2^-23)

    return vector;
}

/**
 * Computes the cosine and sine of the provided angle using the CORDIC algorithm.
 *
 * @name czm_cosineAndSine
 * @glslFunction
 *
 * @param {float} angle The angle in radians.
 *
 * @returns {vec2} The resulting cosine of the angle (as the x coordinate) and sine of the angle (as the y coordinate).
 *
 * @example
 * vec2 v = czm_cosineAndSine(czm_piOverSix);
 * float cosine = v.x;
 * float sine = v.y;
 */
vec2 czm_cosineAndSine(float angle)
{
    if (angle < -czm_piOverTwo || angle > czm_piOverTwo)
    {
        if (angle < 0.0)
        {
            return -cordic(angle + czm_pi);
        }
        else
        {
            return -cordic(angle - czm_pi);
        }
    }
    else
    {
        return cordic(angle);
    }
}
`});var qUe,jUe=Ee(()=>{qUe=`/**
 * Decompresses texture coordinates that were packed into a single float.
 *
 * @name czm_decompressTextureCoordinates
 * @glslFunction
 *
 * @param {float} encoded The compressed texture coordinates.
 * @returns {vec2} The decompressed texture coordinates.
 */
 vec2 czm_decompressTextureCoordinates(float encoded)
 {
    float temp = encoded / 4096.0;
    float xZeroTo4095 = floor(temp);
    float stx = xZeroTo4095 / 4095.0;
    float sty = (encoded - xZeroTo4095 * 4096.0) / 4095.0;
    return vec2(stx, sty);
 }
`});var YUe,QUe=Ee(()=>{YUe=`// emulated noperspective
#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)
varying float v_WindowZ;
#endif

/**
 * Emulates GL_DEPTH_CLAMP, which is not available in WebGL 1 or 2.
 * GL_DEPTH_CLAMP clamps geometry that is outside the near and far planes, 
 * capping the shadow volume. More information here: 
 * https://www.khronos.org/registry/OpenGL/extensions/ARB/ARB_depth_clamp.txt.
 *
 * When GL_EXT_frag_depth is available we emulate GL_DEPTH_CLAMP by ensuring 
 * no geometry gets clipped by setting the clip space z value to 0.0 and then
 * sending the unaltered screen space z value (using emulated noperspective
 * interpolation) to the frag shader where it is clamped to [0,1] and then
 * written with gl_FragDepth (see czm_writeDepthClamp). This technique is based on:
 * https://stackoverflow.com/questions/5960757/how-to-emulate-gl-depth-clamp-nv.
 *
 * When GL_EXT_frag_depth is not available, which is the case on some mobile 
 * devices, we must attempt to fix this only in the vertex shader. 
 * The approach is to clamp the z value to the far plane, which closes the 
 * shadow volume but also distorts the geometry, so there can still be artifacts
 * on frustum seams.
 *
 * @name czm_depthClamp
 * @glslFunction
 *
 * @param {vec4} coords The vertex in clip coordinates.
 * @returns {vec4} The modified vertex.
 *
 * @example
 * gl_Position = czm_depthClamp(czm_modelViewProjection * vec4(position, 1.0));
 *
 * @see czm_writeDepthClamp
 */
vec4 czm_depthClamp(vec4 coords)
{
#ifndef LOG_DEPTH
#ifdef GL_EXT_frag_depth
    v_WindowZ = (0.5 * (coords.z / coords.w) + 0.5) * coords.w;
    coords.z = 0.0;
#else
    coords.z = min(coords.z, coords.w);
#endif
#endif
    return coords;
}
`});var XUe,KUe=Ee(()=>{XUe=`// emulated noperspective
#ifndef LOG_DEPTH
varying float v_WindowZ;
#endif

/**
 * Clamps a vertex to the far plane.
 *
 * @name czm_depthClampFarPlane
 * @glslFunction
 *
 * @param {vec4} coords The vertex in clip coordinates.
 * @returns {vec4} The vertex clipped to the far plane.
 *
 * @example
 * gl_Position = czm_depthClampFarPlane(czm_modelViewProjection * vec4(position, 1.0));
 *
 * @see czm_writeDepthClampedToFarPlane
 */
vec4 czm_depthClampFarPlane(vec4 coords)
{
#ifndef LOG_DEPTH
    v_WindowZ = (0.5 * (coords.z / coords.w) + 0.5) * coords.w;
    coords.z = min(coords.z, coords.w);
#endif
    return coords;
}
`});var ZUe,JUe=Ee(()=>{ZUe=`const vec3 SideLightColor = vec3(0.0);
uniform vec4 uSpecularColor;
uniform float uShininess;
const vec3 specular = vec3(0.066666);
const float shininess2 = 30.0;
float saturate( in float a ) { return clamp( a, 0.0, 1.0 ); }
float calcLightAttenuation( float lightDistance, float cutoffDistance, float decayExponent ) {
    if ( decayExponent > 0.0 ) {
        return pow( saturate( 1.0 - lightDistance / cutoffDistance ), decayExponent );
    }
    return 1.0;
}
#if POINT_LIGHTS > 0
    uniform vec3 uPointLightPositionEC[POINT_LIGHTS];
    uniform vec3 uPointLightColor[POINT_LIGHTS];
    uniform vec2 uPointLightDistanceAndDecay[POINT_LIGHTS];
#endif
#if SPOT_LIGHTS > 0
    uniform vec3 uSpotLightPosition[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightColor[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightPositionEC[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightDirection[ SPOT_LIGHTS ];
    uniform float uSpotLightExponent[ SPOT_LIGHTS ];
    uniform vec4 uSpotLightDistanceDecayCosPenumbra[ SPOT_LIGHTS ];
#endif
#if DIR_LIGHTS > 0
    uniform vec3 uDirectionalLightDirection[ DIR_LIGHTS ];
    uniform vec3 uDirectionalLightColor[ DIR_LIGHTS];
#endif
#if HEMISPHERE_LIGHTS > 0
    uniform vec3 uSkyColor[ HEMISPHERE_LIGHTS ];
    uniform vec3 uGroundColor[ HEMISPHERE_LIGHTS];
#endif
    vec3 calcAmbientIrradiance(vec3 normal) {
        vec3 SH0 = czm_SH[0].xyz;
        vec4 SH_R1 = czm_SH[1];
        vec4 SH_G1 = czm_SH[2];
        vec4 SH_B1 = czm_SH[3];
        vec4 SH_R2 = czm_SH[4];
        vec4 SH_G2 = czm_SH[5];
        vec4 SH_B2 = czm_SH[6];
        vec3 ambientLight = 0.282095 * SH0;
        vec4 sh1 = vec4(
            0.488603 * normal.x,
            0.488603 * normal.z,
            0.488603 * normal.y,
            1.092548 * normal.x * normal.y
        );
        vec4 sh2 = vec4(
            1.092548 * normal.y * normal.z,
            0.315392 * (3.0 * normal.z * normal.z - 1.0),
            1.092548 * normal.x * normal.z,
            0.546274 * (normal.x * normal.x - normal.y * normal.y)
        );
        ambientLight += vec3(
            dot(SH_R1, sh1),
            dot(SH_G1, sh1),
            dot(SH_B1, sh1)
        );
        ambientLight += vec3(
            dot(SH_R2, sh2),
            dot(SH_G2, sh2),
            dot(SH_B2, sh2)
        );
        return ambientLight;
    }

    const float ambientBoostFactor = 0.4;
    const float lightingGlobalFactor = 0.0000342739;
    const float fillLightIntensity = 0.25;
    const vec3 GROUND_REFLECTANCE = vec3(0.2);

    vec3 evaluateAdditionalLighting(vec3 posWorld, vec3 mainLightDirection, vec3 mainLightIntensity) {
        float vndl = dot(normalize(posWorld), mainLightDirection);
        float additionalAmbientScale = smoothstep(0.0, 1.0, clamp(vndl * 2.0, 0.0, 1.0));
        return additionalAmbientScale * ambientBoostFactor * lightingGlobalFactor * mainLightIntensity;
    }

    vec3 evaluateDiffuseIlluminationHemisphere(vec3 ambientGround, vec3 ambientSky, float NdotNG) {
        return ((1.0 - NdotNG) * ambientGround + (1.0 + NdotNG) * ambientSky) * 0.5;
    }

    vec3 calcFinalIrradiance(float NdotL, vec3 normalWorld, vec3 normalGround, vec3 positionWC, vec3 lightDirWC, vec3 mainLightIntensity, vec3 ambientLightIrradiance, vec3 surfaceAlbedo, float shadow) {
        float NdotNG = clamp(dot(normalWorld, normalGround), -1.0, 1.0);
        vec3 ng = normalGround;
        vec3 ambientDir = vec3(5.0 * ng[1] - ng[0] * ng[2], -5.0 * ng[0] - ng[2] * ng[1], ng[1] * ng[1] + ng[0] * ng[0]);
        ambientDir = ambientDir != vec3(0.0) ? normalize(ambientDir) : normalize(vec3(5.0, -1.0, 0.0));
        float NdotAmbDir = abs(dot(normalWorld, ambientDir));
        vec3 additionalLight = evaluateAdditionalLighting(positionWC, lightDirWC, mainLightIntensity);
        vec3 mainLightIrradiance = NdotL * mainLightIntensity * shadow;
        vec3 fillLightIrradiance = NdotAmbDir * mainLightIntensity * fillLightIntensity;
        vec3 ambientLightIrradianceComponent = ambientLightIrradiance + additionalLight;
        vec3 skyIrradianceToSurface = ambientLightIrradianceComponent + mainLightIrradiance + fillLightIrradiance;
        vec3 groundIrradianceToSurface = GROUND_REFLECTANCE * ambientLightIrradianceComponent + mainLightIrradiance + fillLightIrradiance;
        vec3 diffuseContribution = evaluateDiffuseIlluminationHemisphere(groundIrradianceToSurface, skyIrradianceToSurface, NdotNG);
        vec3 finalIrradiance = surfaceAlbedo.rgb * diffuseContribution * 0.31830988618;
        return finalIrradiance;
    }

    vec3 diffuseBRDF_Lambertian(vec3 diffuseColor) {
        return diffuseColor * 0.31830988618;
    }

    vec4 czm_directionLight(czm_s3mMaterialInput material, vec3 normalEC, vec3 positionToEyeEC, vec3 positionMC)
    {
        vec3 totalDiffuseLight = vec3(0.0);
        vec3 totalSpecularLight = vec3(0.0);
        float dotNL = saturate(dot(normalEC, material.sunDirectionEC));
        vec3 normalWorld = material.normalWorld;
        vec3 normalGround = material.normalGround;
        vec3 positionWorld = material.positionWorld;
        vec3 lightDirWC = material.sunDirectionWC;
        vec3 sunLightColor = material.sunLightColor.rgb;
        vec4 surfaceAlbedo = material.surfaceAlbedo;
        float shadow = 1.0;
        vec3 ambientLightIrradiance = calcAmbientIrradiance(normalWorld);
        vec3 finalIrradiance = calcFinalIrradiance(dotNL, normalWorld, normalGround, positionWorld, lightDirWC, sunLightColor, ambientLightIrradiance, surfaceAlbedo.rgb, shadow);
        vec3 positionToEyeECDir = normalize(positionToEyeEC);
	#if HEMISPHERE_LIGHTS > 0
        for ( int i = 0; i < HEMISPHERE_LIGHTS; i ++ )
        {
            vec3 dirVectorEC = normalize(czm_normal * vec3(0.0, 0.0, 1.0));
            float dotProduct = dot( normalEC, dirVectorEC );
			vec3 skyColor = uSkyColor[i];
            vec3 groundColor = uGroundColor[i];
			float hemiDiffuseWeight = 0.5 * dotProduct + 0.5;
			vec3 irradiance = mix( groundColor, skyColor, hemiDiffuseWeight );
			irradiance *= 3.141592653589793;
            totalDiffuseLight += irradiance;
        }
    #endif
    #if DIR_LIGHTS > 0
        for ( int i = 0; i < DIR_LIGHTS; i ++ )
        {
            vec3 dirVectorEC = normalize((czm_view * vec4(uDirectionalLightDirection[ i ], 0.0)).xyz);
            float dotProduct = dot( normalEC, dirVectorEC );
            float dirDiffuseWeight = max( dotProduct, 0.0 );
            totalDiffuseLight += uDirectionalLightColor[ i ] * dirDiffuseWeight * diffuseBRDF_Lambertian(surfaceAlbedo.rgb);
        }
    #endif
    #if POINT_LIGHTS > 0
        for ( int i = 0; i < POINT_LIGHTS; i ++ )
        {
            vec3 lVector = uPointLightPositionEC[i] + positionToEyeEC;
            float lengthToLight = length( lVector );
            float cutoffDis = uPointLightDistanceAndDecay[i].x;
            if(lengthToLight > cutoffDis)
            {
                continue;
            }
            float attenuation = calcLightAttenuation( lengthToLight, cutoffDis, uPointLightDistanceAndDecay[i].y);
            lVector = normalize( lVector );
            float dotProduct = dot( normalEC, lVector );
            float pointLightDiffuse = max( dotProduct, 0.0 );
            totalDiffuseLight += uPointLightColor[i] * pointLightDiffuse * attenuation * diffuseBRDF_Lambertian(surfaceAlbedo.rgb);
        }
    #endif
    #if SPOT_LIGHTS > 0
        vec3 positionWC = (czm_model * vec4(positionMC, 1.0)).xyz;
        for ( int i = 0; i < SPOT_LIGHTS; i ++ )
        {
            vec3 lVector = uSpotLightPositionEC[i] + positionToEyeEC;
            float attenuation = calcLightAttenuation( length( lVector ), uSpotLightDistanceDecayCosPenumbra[i].x, uSpotLightDistanceDecayCosPenumbra[i].y);
            lVector = normalize( lVector );
            float spotEffect = dot( uSpotLightDirection[ i ], normalize( uSpotLightPosition[ i ] - positionWC ) );
            if ( spotEffect > uSpotLightDistanceDecayCosPenumbra[i].z ) {
                spotEffect = max( pow( max( spotEffect, 0.0 ), uSpotLightExponent[ i ] ), 0.0 );
                float dotProduct = dot( normalEC, lVector );
                float spotDiffuseWeight = max( dotProduct, 0.0 );
                totalDiffuseLight += uSpotLightColor[ i ] * spotDiffuseWeight * attenuation * spotEffect * diffuseBRDF_Lambertian(surfaceAlbedo.rgb);
                vec3 spotHalfVector = normalize( lVector + positionToEyeECDir );
                float spotDotNormalHalf = max( dot( normalEC, spotHalfVector ), 0.0 );
                float spotSpecularWeight = max( pow( spotDotNormalHalf, shininess2 ), 0.0 );
                float specularNormalization = ( shininess2 + 2.0 ) / 8.0;
                vec3 schlick = specular + vec3( 1.0 - specular ) * pow( max( 1.0 - dot( lVector, spotHalfVector ), 0.0 ), 5.0 );
                totalSpecularLight += schlick * uSpotLightColor[ i ] * spotSpecularWeight * spotDiffuseWeight * attenuation * specularNormalization * spotEffect;
            }
        }
    #endif
		vec4 color = vec4(finalIrradiance + totalDiffuseLight + totalSpecularLight, surfaceAlbedo.a);
        return color;
    }

`});var $Ue,eGe=Ee(()=>{$Ue=`/**
 * Computes a 3x3 rotation matrix that transforms vectors from an ellipsoid's east-north-up coordinate system 
 * to eye coordinates.  In east-north-up coordinates, x points east, y points north, and z points along the 
 * surface normal.  East-north-up can be used as an ellipsoid's tangent space for operations such as bump mapping.
 * <br /><br />
 * The ellipsoid is assumed to be centered at the model coordinate's origin.
 *
 * @name czm_eastNorthUpToEyeCoordinates
 * @glslFunction
 *
 * @param {vec3} positionMC The position on the ellipsoid in model coordinates.
 * @param {vec3} normalEC The normalized ellipsoid surface normal, at <code>positionMC</code>, in eye coordinates.
 *
 * @returns {mat3} A 3x3 rotation matrix that transforms vectors from the east-north-up coordinate system to eye coordinates.
 *
 * @example
 * // Transform a vector defined in the east-north-up coordinate 
 * // system, (0, 0, 1) which is the surface normal, to eye 
 * // coordinates.
 * mat3 m = czm_eastNorthUpToEyeCoordinates(positionMC, normalEC);
 * vec3 normalEC = m * vec3(0.0, 0.0, 1.0);
 */
mat3 czm_eastNorthUpToEyeCoordinates(vec3 positionMC, vec3 normalEC)
{
    vec3 tangentMC = normalize(vec3(-positionMC.y, positionMC.x, 0.0));  // normalized surface tangent in model coordinates
    vec3 tangentEC = normalize(czm_normal3D * tangentMC);                // normalized surface tangent in eye coordiantes
    vec3 bitangentEC = normalize(cross(normalEC, tangentEC));            // normalized surface bitangent in eye coordinates

    return mat3(
        tangentEC.x,   tangentEC.y,   tangentEC.z,
        bitangentEC.x, bitangentEC.y, bitangentEC.z,
        normalEC.x,    normalEC.y,    normalEC.z);
}
`});var tGe,rGe=Ee(()=>{tGe=`/**
 * DOC_TBA
 *
 * @name czm_ellipsoidContainsPoint
 * @glslFunction
 *
 */
bool czm_ellipsoidContainsPoint(vec3 ellipsoid_inverseRadii, vec3 point)
{
    vec3 scaled = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(point, 1.0)).xyz;
    return (dot(scaled, scaled) <= 1.0);
}
`});var iGe,nGe=Ee(()=>{iGe=`/**
 * DOC_TBA
 *
 * @name czm_ellipsoidNew
 * @glslFunction
 *
 */
czm_ellipsoid czm_ellipsoidNew(vec3 center, vec3 radii)
{
    vec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);
    vec3 inverseRadiiSquared = inverseRadii * inverseRadii;
    czm_ellipsoid temp = czm_ellipsoid(center, radii, inverseRadii, inverseRadiiSquared);
    return temp;
}
`});var oGe,aGe=Ee(()=>{oGe=`/**
 * DOC_TBA
 *
 * @name czm_ellipsoidWgs84TextureCoordinates
 * @glslFunction
 */
vec2 czm_ellipsoidWgs84TextureCoordinates(vec3 normal)
{
    return vec2(atan(normal.y, normal.x) * czm_oneOverTwoPi + 0.5, asin(normal.z) * czm_oneOverPi + 0.5);
}
`});var sGe,lGe=Ee(()=>{sGe=`/**
 * Compares <code>left</code> and <code>right</code> componentwise. Returns <code>true</code>
 * if they are within <code>epsilon</code> and <code>false</code> otherwise. The inputs
 * <code>left</code> and <code>right</code> can be <code>float</code>s, <code>vec2</code>s,
 * <code>vec3</code>s, or <code>vec4</code>s.
 *
 * @name czm_equalsEpsilon
 * @glslFunction
 *
 * @param {} left The first vector.
 * @param {} right The second vector.
 * @param {float} epsilon The epsilon to use for equality testing.
 * @returns {bool} <code>true</code> if the components are within <code>epsilon</code> and <code>false</code> otherwise.
 *
 * @example
 * // GLSL declarations
 * bool czm_equalsEpsilon(float left, float right, float epsilon);
 * bool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon);
 * bool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon);
 * bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon);
 */
bool czm_equalsEpsilon(vec4 left, vec4 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec4(epsilon)));
}

bool czm_equalsEpsilon(vec3 left, vec3 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec3(epsilon)));
}

bool czm_equalsEpsilon(vec2 left, vec2 right, float epsilon) {
    return all(lessThanEqual(abs(left - right), vec2(epsilon)));
}

bool czm_equalsEpsilon(float left, float right, float epsilon) {
    return (abs(left - right) <= epsilon);
}
`});var uGe,cGe=Ee(()=>{uGe=`#ifdef EXCAVATION
uniform sampler2D uExcavationTexture;
uniform float uExcavationMode;
uniform vec4 uExcavationRect;
varying vec4 vExcavationVertexPos;
vec2 CalculateExcavationPolyTexCoord(vec4 vertexPos, vec4 rectPos, out float ptInRect)
{
    vec2 vecRatio = vec2(rectPos.z - rectPos.x, rectPos.w - rectPos.y);
    vec2 texCoord = vec2(vertexPos.x - rectPos.x, vertexPos.y - rectPos.y);
    texCoord.x = texCoord.x / vecRatio.x;
    texCoord.y = texCoord.y / vecRatio.y;
    ptInRect = step(0.0, texCoord.x) * step(0.0, texCoord.y) * step(0.0, 1.0 - texCoord.x) * step(0.0, 1.0 - texCoord.y);
    texCoord = clamp(texCoord, vec2(0.0), vec2(1.0));
    return texCoord;
}
bool czm_executeExcavation()
{
    float hasExcavation = 1.0;
    vec2 vecExcavationTexCoord = CalculateExcavationPolyTexCoord(vExcavationVertexPos, uExcavationRect, hasExcavation);
    bool excavationInside = (uExcavationMode < 0.5);
    if(hasExcavation < 0.1)
    {
        return !excavationInside;
    }
    if(excavationInside)
    {
        return texture2D(uExcavationTexture, vecExcavationTexCoord.xy).r > 0.5;
    }
    else
    {
        return texture2D(uExcavationTexture, vecExcavationTexCoord.xy).r < 0.5;
    }
}
#endif`});var fGe,xGe=Ee(()=>{fGe=`/**
 * DOC_TBA
 *
 * @name czm_eyeOffset
 * @glslFunction
 *
 * @param {vec4} positionEC DOC_TBA.
 * @param {vec3} eyeOffset DOC_TBA.
 *
 * @returns {vec4} DOC_TBA.
 */
vec4 czm_eyeOffset(vec4 positionEC, vec3 eyeOffset)
{
    // This equation is approximate in x and y.
    vec4 p = positionEC;
    vec4 zEyeOffset = normalize(p) * eyeOffset.z;
    p.xy += eyeOffset.xy + zEyeOffset.xy;
    p.z += zEyeOffset.z;
    return p;
}
`});var hGe,dGe=Ee(()=>{hGe=`/**
 * Transforms a position from eye to window coordinates.  The transformation
 * from eye to clip coordinates is done using {@link czm_projection}.
 * The transform from normalized device coordinates to window coordinates is
 * done using {@link czm_viewportTransformation}, which assumes a depth range
 * of <code>near = 0</code> and <code>far = 1</code>.
 * <br /><br />
 * This transform is useful when there is a need to manipulate window coordinates
 * in a vertex shader as done by {@link BillboardCollection}.
 *
 * @name czm_eyeToWindowCoordinates
 * @glslFunction
 *
 * @param {vec4} position The position in eye coordinates to transform.
 *
 * @returns {vec4} The transformed position in window coordinates.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_projection
 * @see czm_viewportTransformation
 * @see BillboardCollection
 *
 * @example
 * vec4 positionWC = czm_eyeToWindowCoordinates(positionEC);
 */
vec4 czm_eyeToWindowCoordinates(vec4 positionEC)
{
    vec4 q = czm_projection * positionEC;                        // clip coordinates
    q.xyz /= q.w;                                                // normalized device coordinates
    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates
    return q;
}
`});var mGe,pGe=Ee(()=>{mGe=`/**
 * Approxiamtes atan over the range [0, 1]. Safe to flip output for negative input.
 *
 * Based on Michal Drobot's approximation from ShaderFastLibs, which in turn is based on
 * "Efficient approximations for the arctangent function," Rajan, S. Sichun Wang Inkol, R. Joyal, A., May 2006.
 * Adapted from ShaderFastLibs under MIT License.
 *
 * Chosen for the following characteristics over range [0, 1]:
 * - basically no error at 0 and 1, important for getting around range limit (naive atan2 via atan requires infinite range atan)
 * - no visible artifacts from first-derivative discontinuities, unlike latitude via range-reduced sqrt asin approximations (at equator)
 *
 * The original code is x * (-0.1784 * abs(x) - 0.0663 * x * x + 1.0301);
 * Removed the abs() in here because it isn't needed, the input range is guaranteed as [0, 1] by how we're approximating atan2.
 *
 * @name czm_fastApproximateAtan
 * @glslFunction
 *
 * @param {float} x Value between 0 and 1 inclusive.
 *
 * @returns {float} Approximation of atan(x)
 */
float czm_fastApproximateAtan(float x) {
    return x * (-0.1784 * x - 0.0663 * x * x + 1.0301);
}

/**
 * Approximation of atan2.
 *
 * Range reduction math based on nvidia's cg reference implementation for atan2:
 * However, we replaced their atan curve with Michael Drobot's (see above).
 *
 * @name czm_fastApproximateAtan
 * @glslFunction
 *
 * @param {float} x Value between -1 and 1 inclusive.
 * @param {float} y Value between -1 and 1 inclusive.
 *
 * @returns {float} Approximation of atan2(x, y)
 */
float czm_fastApproximateAtan(float x, float y) {
    // atan approximations are usually only reliable over [-1, 1], or, in our case, [0, 1] due to modifications.
    // So range-reduce using abs and by flipping whether x or y is on top.
    float t = abs(x); // t used as swap and atan result.
    float opposite = abs(y);
    float adjacent = max(t, opposite);
    opposite = min(t, opposite);

    t = czm_fastApproximateAtan(opposite / adjacent);

    // Undo range reduction
    t = czm_branchFreeTernary(abs(y) > abs(x), czm_piOverTwo - t, t);
    t = czm_branchFreeTernary(x < 0.0, czm_pi - t, t);
    t = czm_branchFreeTernary(y < 0.0, -t, t);
    return t;
}
`});var vGe,gGe=Ee(()=>{vGe=`/**
 * Gets the color with fog at a distance from the camera.
 *
 * @name czm_fog
 * @glslFunction
 *
 * @param {float} distanceToCamera The distance to the camera in meters.
 * @param {vec3} color The original color.
 * @param {vec3} fogColor The color of the fog.
 *
 * @returns {vec3} The color adjusted for fog at the distance from the camera.
 */
vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor)
{
    float scalar = distanceToCamera * czm_fogDensity;
    float fog = 1.0 - exp(-(scalar * scalar));
    return mix(color, fogColor, fog);
}

/**
 * Gets the color with fog at a distance from the camera.
 *
 * @name czm_fog
 * @glslFunction
 *
 * @param {float} distanceToCamera The distance to the camera in meters.
 * @param {vec3} color The original color.
 * @param {vec3} fogColor The color of the fog.
 * @param {float} fogModifierConstant A constant to modify the appearance of fog.
 *
 * @returns {vec3} The color adjusted for fog at the distance from the camera.
 */
vec3 czm_fog(float distanceToCamera, vec3 color, vec3 fogColor, float fogModifierConstant)
{
    float scalar = distanceToCamera * czm_fogDensity;
    float fog = 1.0 - exp(-((fogModifierConstant * scalar + fogModifierConstant) * (scalar * (1.0 + fogModifierConstant))));
    return mix(color, fogColor, fog);
}
`});var _Ge,yGe=Ee(()=>{_Ge=`/**
 * Converts a color from RGB space to linear space.
 *
 * @name czm_gammaCorrect
 * @glslFunction
 *
 * @param {vec3} color The color in RGB space.
 * @returns {vec3} The color in linear space.
 */
vec3 czm_gammaCorrect(vec3 color) {
#ifdef HDR
    color = pow(color, vec3(czm_gamma));
#endif
    return color;
}

vec4 czm_gammaCorrect(vec4 color) {
#ifdef HDR
    color.rgb = pow(color.rgb, vec3(czm_gamma));
#endif
    return color;
}
`});var AGe,CGe=Ee(()=>{AGe=`/**
 * DOC_TBA
 *
 * @name czm_geodeticSurfaceNormal
 * @glslFunction
 *
 * @param {vec3} positionOnEllipsoid DOC_TBA
 * @param {vec3} ellipsoidCenter DOC_TBA
 * @param {vec3} oneOverEllipsoidRadiiSquared DOC_TBA
 * 
 * @returns {vec3} DOC_TBA.
 */
vec3 czm_geodeticSurfaceNormal(vec3 positionOnEllipsoid, vec3 ellipsoidCenter, vec3 oneOverEllipsoidRadiiSquared)
{
    return normalize((positionOnEllipsoid - ellipsoidCenter) * oneOverEllipsoidRadiiSquared);
}
`});var TGe,wGe=Ee(()=>{TGe=`/**
 * An czm_material with default values. Every material's czm_getMaterial
 * should use this default material as a base for the material it returns.
 * The default normal value is given by materialInput.normalEC.
 *
 * @name czm_getDefaultMaterial
 * @glslFunction
 *
 * @param {czm_materialInput} input The input used to construct the default material.
 *
 * @returns {czm_material} The default material.
 *
 * @see czm_materialInput
 * @see czm_material
 * @see czm_getMaterial
 */
czm_material czm_getDefaultMaterial(czm_materialInput materialInput)
{
    czm_material material;
    material.diffuse = vec3(0.0);
    material.specular = 0.0;
    material.shininess = 1.0;
    material.normal = materialInput.normalEC;
    material.emission = vec3(0.0);
    material.alpha = 1.0;
    return material;
}
`});var EGe,bGe=Ee(()=>{EGe=`uniform float uMaxCategoryOrHypCeil;
uniform float uMinCategoryOrHypFloor;
uniform sampler2D uEmissionTexAtlas;
uniform vec4 uEmissionTexAtlasTilingAndOffset[EMISSION_TEXTURE_COUNT];
uniform vec4 uEmissionTexAtlasRects[EMISSION_TEXTURE_COUNT];
uniform float uLayerCornerLength;
varying vec2 vLayerTexCoord;
varying vec2 vModIndexAndTexIndex;
vec3 czm_getEmissiveTextureColor(float w)
{
    vec3 texColor = vec3(0.0);
    vec2 emissionTexCoord;
    int nEmissionTexTexIdx = int(floor(vModIndexAndTexIndex.y + 0.5));
    vec2 atlasTexCoord;
    for(int i = 0; i < EMISSION_TEXTURE_COUNT; i++){
        if(nEmissionTexTexIdx == i){
            emissionTexCoord.x = mod(length(vLayerTexCoord) * uLayerCornerLength / uEmissionTexAtlasTilingAndOffset[i].x, 1.0);
            emissionTexCoord.y = mod((w - uMinCategoryOrHypFloor) / uEmissionTexAtlasTilingAndOffset[i].y, 1.0) ;
            emissionTexCoord.x += uEmissionTexAtlasTilingAndOffset[i].z;
            emissionTexCoord.y += vModIndexAndTexIndex.x + uEmissionTexAtlasTilingAndOffset[i].w;
            emissionTexCoord.xy = fract(emissionTexCoord.xy);
            atlasTexCoord = mix(uEmissionTexAtlasRects[i].xy, uEmissionTexAtlasRects[i].zw, emissionTexCoord);
            break;
        }
    }
    texColor = texture2D(uEmissionTexAtlas, atlasTexCoord).rgb;
    return texColor;
}
vec3 czm_getEmissiveTextureColor(float w, vec2 texCoord)
{
    vec3 texColor = vec3(0.0);
    vec2 emissionTexCoord;
    int nEmissionTexTexIdx = int(floor(vModIndexAndTexIndex.y + 0.5));
    vec2 atlasTexCoord;
    for(int i = 0; i < EMISSION_TEXTURE_COUNT; i++){
        if(nEmissionTexTexIdx == i){
            emissionTexCoord.x = mod(texCoord.x / uEmissionTexAtlasTilingAndOffset[i].x, 1.0);
            emissionTexCoord.y = mod(texCoord.y / uEmissionTexAtlasTilingAndOffset[i].y, 1.0);
            emissionTexCoord.x += uEmissionTexAtlasTilingAndOffset[i].z;
            emissionTexCoord.y += vModIndexAndTexIndex.x + uEmissionTexAtlasTilingAndOffset[i].w;
            emissionTexCoord.xy = fract(emissionTexCoord.xy);
            atlasTexCoord = mix(uEmissionTexAtlasRects[i].xy, uEmissionTexAtlasRects[i].zw, emissionTexCoord);
            break;
        }
    }
    texColor = texture2D(uEmissionTexAtlas, atlasTexCoord).rgb;
    return texColor;
}`});var SGe,IGe=Ee(()=>{SGe=`uniform float uHorizontalLine;
uniform vec4 uHorizontalColor;
float computeContourline(float fValue)
{
	float distanceToContour = uHorizontalLine;
	float dxc = abs(dFdx(fValue));
	float dyc = abs(dFdy(fValue));
	float dF = max(dxc, dyc);
	return (abs(distanceToContour-fValue) < dF) ? 1.0 : 0.0;
}

vec4 czm_getHorizontalColor(vec4 oriColor, float fValue)
{
    float finalOpacity = computeContourline(fValue);
    return mix(oriColor,uHorizontalColor, finalOpacity);
}`});var PGe,DGe=Ee(()=>{PGe=`uniform sampler2D uHypsometricTexture;
uniform sampler2D uHypsometricRenderTexture;
uniform float uHypsometricVisible;
uniform float uHypOpacity;
uniform float uHypContourInterval;
uniform vec4 uHypLineColor;
uniform float uHypContourFillMode;
uniform float uHypFloor;
uniform float uHypCeil;
uniform float uHypMaxVisibleValue;
uniform float uHypMinVisibleValue;
uniform float uHypHasAnalysisRegion;
varying vec2 vecHypTexCoord;
uniform float uMixColorType;
uniform vec4 uNoValueColor;
#ifdef Volume
varying vec3 vecRotioCoord;
uniform float uDataFloor;
uniform float uDataCeil;
uniform float uVolumeType;
#endif

#ifdef Volume2
uniform float uDataFloor;
uniform float uDataCeil;
uniform float uFilterMode;
#endif

float computeMixCon(float fValue)
{
    float distanceToContour;
    if(abs(uHypMaxVisibleValue - uHypMinVisibleValue) > 0.1)
    {
	    if(fValue < 0.5)
        {
            distanceToContour = mod(fValue - 0.0002, uHypContourInterval);
        }
        else
        {
            float t = floor(fValue / uHypContourInterval);
            distanceToContour = abs(fValue - (t * uHypContourInterval) - 0.1);
        }
	}
	else
	{
	    distanceToContour = abs(fValue - uHypMaxVisibleValue);
	}
	float dxc = abs(dFdx(fValue));
	float dyc = abs(dFdy(fValue));
	float dF = max(dxc, dyc);
	return (distanceToContour < dF) ? 1.0 : 0.0;
}

vec4 computeContourMapColor(float fValue)
{
	//float threshold = clamp(abs(uHypCeil - uHypFloor), 0.000001, 20000.0);
	float threshold = abs(uHypCeil - uHypFloor);
	float contourRate = (fValue - uHypFloor) / threshold;
	float finalCoord = clamp(contourRate, 0.0, 1.0);
	float count = floor(finalCoord * 16.0);
	float y = (count*2.0 + 1.0)/32.0;
	float x = fract(finalCoord*16.0);
	if(y > 1.0)
	{
	    x = 1.0;
	}
	vec2 contourCoord = vec2(x, y);
	vec4 color = texture2D(uHypsometricTexture, contourCoord);
	return color;
}
#ifdef Volume2

vec4 czm_getContourMapColor(vec4 oriColor, vec4 volColor)
{
    if(uFilterMode > 0.5)
    {
        vec4 finalColor = volColor * oriColor;

        if(uMixColorType > 0.5)
        {
            finalColor = volColor;
        }
        return finalColor;
    }

    vec4 contourMapColor = vec4(0.0);
    float finalOpacity = uHypOpacity;

	float noValue = volColor.a;
	float texTest = clamp(czm_unpackVolume(volColor.zyx),0.0,1.0);

	float fValue;
	if(noValue > 0.5)
	{
        fValue = uDataFloor + texTest * (uDataCeil - uDataFloor);
    }
    else
    {
        fValue = uHypMaxVisibleValue + abs(uHypMaxVisibleValue * 0.1);
    }

    float extendHeight = czm_branchFreeTernary(uHypContourFillMode > 2.9, 0.0, czm_branchFreeTernary(uHypContourFillMode > 1.9, 5.0, 0.0));
    if(fValue > uHypMaxVisibleValue + extendHeight || fValue < uHypMinVisibleValue - extendHeight)
    {
        return uNoValueColor * oriColor;
    }
#ifdef GL_OES_standard_derivatives
    if(uHypContourFillMode > 2.9)
    {
        float mix_con = computeMixCon(fValue);
        contourMapColor = mix(computeContourMapColor(fValue), uHypLineColor, mix_con);
    }
    else if(uHypContourFillMode > 1.9)
    {
        finalOpacity = computeMixCon(fValue);
        contourMapColor = uHypLineColor;
    }
    else if(uHypContourFillMode > 0.9)
#else
    if(uHypContourFillMode > 0.9)
#endif
    {
        contourMapColor = computeContourMapColor(fValue);
    }
    else
    {
        finalOpacity = 0.0;
    }
    vec4 mixColor = mix(vec4(1.0,1.0,1.0,1.0), contourMapColor, finalOpacity);
    vec4 finalColor = mixColor * oriColor;
#ifdef PT_CLOUD
	finalColor = mixColor;
#endif
    if(uMixColorType > 0.5)
    {
        finalColor = mixColor;
    }
    return finalColor;
}

#else

vec4 czm_getContourMapColor(vec4 oriColor, float fValue)
{
    vec4 contourMapColor = vec4(0.0);
    float finalOpacity = uHypOpacity;
#ifdef Volume
	vec3 aRatioT = vecRotioCoord;
	if((aRatioT.x < 1.0 && aRatioT.x >0.0) && (aRatioT.y < 1.0 && aRatioT.y >0.0) && (aRatioT.z < 1.0 && aRatioT.z >0.0))
	{
	    if(uVolumeType > 0.5)
	    {
			vec4 volumeColor = czm_getVolumeValue(aRatioT);
			if(uMixColorType > 0.5)
			{
				volumeColor = volumeColor * oriColor;
			}
			return volumeColor;
	    }
	    float noValue;
	    float texTest = czm_getVolumeValue(aRatioT, noValue);
	    if(noValue > 0.5)
	    {
	        fValue = uDataFloor + texTest * (uDataCeil - uDataFloor);
	    }
	    else
	    {
	        fValue = uHypMaxVisibleValue + abs(uHypMaxVisibleValue * 0.1);
	    }
	}
	else
	{
	    fValue = uHypMaxVisibleValue + abs(uHypMaxVisibleValue * 0.1);
	}
#endif
    float extendHeight = czm_branchFreeTernary(uHypContourFillMode > 2.9, 0.0, czm_branchFreeTernary(uHypContourFillMode > 1.9, 5.0, 0.0));
    if(fValue > uHypMaxVisibleValue + extendHeight || fValue < uHypMinVisibleValue - extendHeight)
    {
        return uNoValueColor * oriColor;
    }
#ifdef GL_OES_standard_derivatives
    if(uHypContourFillMode > 2.9)
    {
        float mix_con = computeMixCon(fValue);
        contourMapColor = mix(computeContourMapColor(fValue), uHypLineColor, mix_con);
    }
    else if(uHypContourFillMode > 1.9)
    {
        finalOpacity = computeMixCon(fValue);
        contourMapColor = uHypLineColor;
    }
    else if(uHypContourFillMode > 0.9)
#else
    if(uHypContourFillMode > 0.9)
#endif
    {
        contourMapColor = computeContourMapColor(fValue);
    }
    else
    {
        finalOpacity = 0.0;
    }
    vec4 mixColor = mix(vec4(1.0,1.0,1.0,1.0), contourMapColor, finalOpacity);
    vec4 finalColor = mix(oriColor, contourMapColor, finalOpacity);
#ifdef PT_CLOUD
	finalColor = mixColor;
#endif
#ifdef Volume
    if(uMixColorType > 0.5)
    {
        finalColor = mixColor;
    }
#endif
    return finalColor;
}

#endif

#ifdef Volume2
vec4 czm_getHypsometricColor(vec4 oriColor, vec4 volColor)
{
	if(uHypHasAnalysisRegion > 0.1)
    {
		vec4 hypColor = texture2D(uHypsometricRenderTexture, vecHypTexCoord);
		if(hypColor.r < 0.1)
		{
			return oriColor;
		}
	}
    return czm_getContourMapColor(oriColor, volColor);
}
#else
vec4 czm_getHypsometricColor(vec4 oriColor, float wValue)
{
    float fValue = wValue;
	if(uHypHasAnalysisRegion > 0.1)
    {
		vec4 hypColor = texture2D(uHypsometricRenderTexture, vecHypTexCoord);
		if(hypColor.r < 0.1)
		{
			return oriColor;
		}
	}
    return czm_getContourMapColor(oriColor, fValue);
}

vec4 czm_getHypsometricColorByGeoBounds(vec4 oriColor, float wValue, vec4 hypRect, vec2 vTexCoord, vec4 geoBounds)
{
   if(uHypHasAnalysisRegion > 0.1)
    {
        vec2 polyTexCoord = vTexCoord.xy;
        polyTexCoord.x = polyTexCoord.x * (geoBounds.z - geoBounds.x) + geoBounds.x;
        polyTexCoord.y = polyTexCoord.y * (geoBounds.w - geoBounds.y) + geoBounds.y;
        if(polyTexCoord.x < hypRect.x || polyTexCoord.x>hypRect.z || polyTexCoord.y< hypRect.y || polyTexCoord.y > hypRect.w)
        {
            return oriColor;
        }
        vec4 hypColor = texture2D(uHypsometricRenderTexture, polyTexCoord);
        if(hypColor.r < 0.1)
        {
            return oriColor;
        }
    }
    return czm_getContourMapColor(oriColor, wValue);
}

#endif`});var MGe,BGe=Ee(()=>{MGe=`/**
 * Calculates the intensity of diffusely reflected light.
 *
 * @name czm_getLambertDiffuse
 * @glslFunction
 *
 * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.
 * @param {vec3} normalEC The surface normal in eye coordinates.
 *
 * @returns {float} The intensity of the diffuse reflection.
 *
 * @see czm_phong
 *
 * @example
 * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);
 * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);
 * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);
 */
float czm_getLambertDiffuse(vec3 lightDirectionEC, vec3 normalEC)
{
    return max(dot(lightDirectionEC, normalEC), 0.0);
}
`});var RGe,LGe=Ee(()=>{RGe=`/**
 * Calculates the specular intensity of reflected light.
 *
 * @name czm_getSpecular
 * @glslFunction
 *
 * @param {vec3} lightDirectionEC Unit vector pointing to the light source in eye coordinates.
 * @param {vec3} toEyeEC Unit vector pointing to the eye position in eye coordinates.
 * @param {vec3} normalEC The surface normal in eye coordinates.
 * @param {float} shininess The sharpness of the specular reflection.  Higher values create a smaller, more focused specular highlight.
 *
 * @returns {float} The intensity of the specular highlight.
 *
 * @see czm_phong
 *
 * @example
 * float diffuseIntensity = czm_getLambertDiffuse(lightDirectionEC, normalEC);
 * float specularIntensity = czm_getSpecular(lightDirectionEC, toEyeEC, normalEC, 200);
 * vec3 color = (diffuseColor * diffuseIntensity) + (specularColor * specularIntensity);
 */
float czm_getSpecular(vec3 lightDirectionEC, vec3 toEyeEC, vec3 normalEC, float shininess)
{
    vec3 toReflectedLight = reflect(-lightDirectionEC, normalEC);
    float specular = max(dot(toReflectedLight, toEyeEC), 0.0);

    // pow has undefined behavior if both parameters <= 0.
    // Prevent this by making sure shininess is at least czm_epsilon2.
    return pow(specular, max(shininess, czm_epsilon2));
}
`});var OGe,FGe=Ee(()=>{OGe=`void CalculateMipLevel(in vec2 inTexCoord, in float vecTile, in float fMaxMip, inout float mipLevel)
{
	vec2 dx = dFdx(inTexCoord * vecTile);
	vec2 dy = dFdy(inTexCoord * vecTile);
	float dotX = dot(dx, dx);
	float dotY = dot(dy, dy);
	float dMax = max(dotX, dotY);
	float dMin = min(dotX, dotY);
	float offset = (dMax - dMin) / (dMax + dMin);
	offset = clamp(offset, 0.0, 1.0);
	float d = dMax * (1.0 - offset) + dMin * offset;
	mipLevel = 0.5 * log2(d);
	mipLevel = clamp(mipLevel, 0.0, fMaxMip - 1.62);
}

void CalculateMipLevel(in vec2 inTexCoord, in vec2 vecTile, in float fMaxMip, inout float mipLevel)
{
	vec2 dx = dFdx(inTexCoord * vecTile.x);
	vec2 dy = dFdy(inTexCoord * vecTile.y);
	float dotX = dot(dx, dx);
	float dotY = dot(dy, dy);
	float dMax = max(dotX, dotY);
	float dMin = min(dotX, dotY);
	float offset = (dMax - dMin) / (dMax + dMin);
	offset = clamp(offset, 0.0, 1.0);
	float d = dMax * (1.0 - offset) + dMin * offset;
	mipLevel = 0.5 * log2(d);
	mipLevel = clamp(mipLevel, 0.0, fMaxMip - 1.62);
}

void CalculateTexCoord(in vec3 inTexCoord, in float scale, in float XTran, in float YTran, in float fTile, in float mipLevel, inout vec2 outTexCoord)
{
    if(inTexCoord.z < -9000.0)
    {
        outTexCoord = inTexCoord.xy;
    }
    else
    {
	    vec2 fTexCoord = fract(inTexCoord.xy);
	    float offset = 1.0 * pow(2.0, mipLevel) / fTile;
	    fTexCoord = clamp(fTexCoord, offset, 1.0 - offset);
	    outTexCoord.x = (fTexCoord.x + XTran) * scale;
	    outTexCoord.y = (fTexCoord.y + YTran) * scale;
	}
}

#ifdef USE_UVRegion
    varying vec4 uvAtlasRegion;
    vec4 textureAtlasLookup(sampler2D tex, vec2 textureCoordinates) {
        vec4 uvRegion = uvAtlasRegion;
        uvRegion = mod(uvRegion + 65536.0, 65536.0);
        uvRegion /= 65535.0;
        vec2 atlasScale = uvRegion.zw - uvRegion.xy;
        vec2 uvAtlas = fract(textureCoordinates) * atlasScale + uvRegion.xy;
        float maxdUV = 0.125;
        vec2 dUVdx = clamp(dFdx(textureCoordinates), -maxdUV, maxdUV) * atlasScale;
        vec2 dUVdy = clamp(dFdy(textureCoordinates), -maxdUV, maxdUV) * atlasScale;
        return textureGrad(tex, uvAtlas, dUVdx, dUVdy);
    }
#endif

vec4 czm_getTexColorForS3M(sampler2D curTexture, vec3 oriTexCoord, float texTileWidth, float fMaxMipLev, float fTexCoordScale, vec2 vecTexCoordTranslate,float isRGBA, vec4 texUVoffset, out vec2 outTexCoord)
{
	vec4 color = vec4(1.0);
	if(oriTexCoord.z <= -99900.0){
		return color;
	}
    float mipLevel = 0.0;
#ifdef GL_OES_standard_derivatives
    CalculateMipLevel(oriTexCoord.xy, texTileWidth, fMaxMipLev, mipLevel);
#endif
    vec2 realTexCoord;
    CalculateTexCoord(oriTexCoord, fTexCoordScale, vecTexCoordTranslate.x, vecTexCoordTranslate.y, texTileWidth, mipLevel, realTexCoord);
	if(isRGBA > 0.5)
	{
	    vec2 rgbTexCoord;
		rgbTexCoord.x = (realTexCoord.x + vecTexCoordTranslate.x * fTexCoordScale) * 0.5;
		rgbTexCoord.y = (realTexCoord.y + vecTexCoordTranslate.y * fTexCoordScale) * 0.5;
		rgbTexCoord.xy += texUVoffset.xy;
        color = texture2D(curTexture, rgbTexCoord.xy, -10.0);
		vec2 vecAlphaTexCoord;
		vecAlphaTexCoord.x = rgbTexCoord.x;
		vecAlphaTexCoord.y = rgbTexCoord.y + fTexCoordScale * 0.5;
		vecAlphaTexCoord.xy += texUVoffset.xy;
	    color.a = texture2D(curTexture, vecAlphaTexCoord.xy, -10.0).r;
	}
	else
	{
	    realTexCoord = realTexCoord * texUVoffset.zw + texUVoffset.xy;
	    if(oriTexCoord.z < -9000.0)
        {
            color = texture2D(curTexture, realTexCoord.xy);
        }
        else
        {
			#ifndef USE_UVRegion
				#ifdef GL_EXT_shader_texture_lod
					color = texture2DLodEXT(curTexture, realTexCoord.xy, mipLevel);
				#else
					#ifdef WEBEL2
						color = textureLod(curTexture, realTexCoord.xy, mipLevel);
					#else
						color = texture2D(curTexture, realTexCoord.xy, mipLevel);
					#endif
				#endif
			#else    
				color = textureAtlasLookup(curTexture, realTexCoord);
			#endif
        }
    #ifdef RGBTOBGR
        color = color.bgra;
    #endif
	}
	outTexCoord = realTexCoord;
	return color;
}

vec4 czm_getTexColorForS3M(sampler2D texture, vec2 uv, vec2 texDim, vec2 texTran, vec2 texScale, float maxMipLevel, out vec2 outTexCoord)
{
    if(maxMipLevel < 0.0)
    {
        return vec4(1.0);
    }
	vec4 colorCeil = vec4(1.0);
    float mipLevel = 0.0;
#ifdef GL_OES_standard_derivatives
    CalculateMipLevel(uv, texDim, maxMipLevel, mipLevel);
#endif
	float ceilMipLevel = ceil(mipLevel);
	vec2 translate = vec2(texTran.x, texTran.y);
	float temp;
	if(ceilMipLevel > 0.0)
	{
		translate.x = texTran.x + texScale.x;
		temp = pow(2.0, ceilMipLevel - 1.0);
		translate.y = texTran.y + texScale.y * (temp - 1.0) / temp;
	}
    float scale = 1.0 / pow(2.0, ceilMipLevel);
	vec2 texcoord = fract(uv);
	float offsetX = pow(2.0, ceilMipLevel) / texDim.x;
	float offsetY = pow(2.0, ceilMipLevel) / texDim.y;
	texcoord.x = clamp(texcoord.x, 0.0 + offsetX, 1.0 - offsetX);
	texcoord.y = clamp(texcoord.y, 0.0 + offsetY, 1.0 - offsetY);
	texcoord.x = texcoord.x * texScale.x * scale + translate.x;
	texcoord.y = texcoord.y * texScale.y * scale + translate.y;
	#ifdef GL_EXT_shader_texture_lod
        colorCeil = texture2DLodEXT(texture, texcoord.xy, 0.0);
    #else
        #ifdef WEBEL2
            colorCeil = textureLod(texture, texcoord.xy, 0.0);
        #else
            colorCeil = texture2D(texture, texcoord.xy, -10.0);
        #endif
    #endif
	vec4 colorFloor = vec4(1.0);
	float floorMipLevel = floor(mipLevel);
	translate = vec2(texTran.x, texTran.y);
	if(floorMipLevel > 0.0)
	{
	    translate.x = texTran.x + texScale.x;
	    temp = pow(2.0, floorMipLevel - 1.0);
	    translate.y = texTran.y + texScale.y * (temp - 1.0) / temp;
	}
	scale = 1.0 / pow(2.0, floorMipLevel);
	texcoord = fract(uv);
	offsetX = pow(2.0, floorMipLevel) / texDim.x;
	offsetY = pow(2.0, floorMipLevel) / texDim.y;
	texcoord.x = clamp(texcoord.x, 0.0 + offsetX, 1.0 - offsetX);
	texcoord.y = clamp(texcoord.y, 0.0 + offsetY, 1.0 - offsetY);
	texcoord.x = texcoord.x * texScale.x * scale + translate.x;
	texcoord.y = texcoord.y * texScale.y * scale + translate.y;
	#ifdef GL_EXT_shader_texture_lod
        colorFloor = texture2DLodEXT(texture, texcoord.xy, 0.0);
    #else
        #ifdef WEBEL2
            colorFloor = textureLod(texture, texcoord.xy, 0.0);
        #else
            colorFloor = texture2D(texture, texcoord.xy, -10.0);
        #endif
    #endif
	vec4 color = colorCeil * 0.5 + colorFloor * 0.5;
	return color;
}`});var NGe,zGe=Ee(()=>{NGe=`const int SHIFT_LEFT8 = 256;

void czm_getTextureMatrixFromZValue(in int nZ, inout float XTran, inout float YTran, inout float scale, inout float isRGBA)
{
    if(nZ < 0){
        return ;
    }
    int nDel8 = nZ / SHIFT_LEFT8;
    int nDel16 = nDel8 / SHIFT_LEFT8;
    YTran = float(nZ - nDel8 * SHIFT_LEFT8);
    XTran = float(nDel8 - nDel16 * SHIFT_LEFT8);
    int nLevel = nDel16;
    scale = 1.0 / pow(2.0, float(nLevel));
}`});var VGe,kGe=Ee(()=>{VGe=`uniform sampler2D uVolumeTexture;
#ifdef TIME_ORDER
uniform sampler2D uNextVolumeTexture;
uniform float uTimeRatio;
#endif

#ifdef Volume
uniform float width;
uniform float height;
uniform float depth;
uniform float sideBlockCount;
uniform float blockLength;
uniform float texLength;
uniform float uFilterMode;
#endif

float czm_unpackVolume(vec3 packedDepth)
{
   return dot(packedDepth, vec3(1.0, 1.0 / 255.0, 1.0 / 65025.0));
}

#ifdef Volume
vec2 computeVolumeTextureCoord(vec3 texCoord, float fLevel)
{
    float yOffset = floor((fLevel+0.25/sideBlockCount) / sideBlockCount);
    float xOffset = fLevel - yOffset * sideBlockCount;
    float texCoordV = (texCoord.y * height + yOffset * blockLength) / texLength;
    float texCoordU = (texCoord.x * width + xOffset * blockLength) / texLength;
    return vec2(texCoordU, texCoordV);
}

float computeVolumeValue(sampler2D volumeTexture, vec2 topTexCoord, vec2 bottomTexCoord, float ratio, out float noValue)
{
    vec4 volumeValue1 = texture2D(volumeTexture, topTexCoord);
    vec4 volumeValue2 = texture2D(volumeTexture, bottomTexCoord);
    float fValue1 = clamp(czm_unpackVolume(volumeValue1.xyz),0.0,1.0);
    float fValue2 = clamp(czm_unpackVolume(volumeValue2.xyz),0.0,1.0);
    if(uFilterMode >0.5)
    {
        if(ratio<0.5)
        {
            ratio = 0.0;
        }
        else
        {
            ratio = 1.0;
        }
    }
    noValue = mix(volumeValue1.a, volumeValue2.a, ratio);
    if(volumeValue1.a < 0.5)
    {
        fValue1 = fValue2;
    }
    if(volumeValue2.a < 0.5)
    {
        fValue2 = fValue1;
    }
    return mix(fValue1, fValue2, ratio);
}

float czm_getVolumeValue(vec3 texCoord, out float noValue)
{
    float fLevel = (depth - 1.0) * texCoord.z;
    float bottomLevel= floor(fLevel);
    float topLevel = bottomLevel + 1.0;
    float ratio = topLevel - fLevel;
    vec2 topTexCoord = computeVolumeTextureCoord(texCoord, topLevel);
    vec2 bottomTexCoord = computeVolumeTextureCoord(texCoord, bottomLevel);
    float fResult = computeVolumeValue(uVolumeTexture, topTexCoord, bottomTexCoord, ratio, noValue);
#ifdef TIME_ORDER
    float fNextResult = computeVolumeValue(uNextVolumeTexture, topTexCoord, bottomTexCoord, ratio, noValue);
    fResult = mix(fResult, fNextResult, uTimeRatio);
#endif
    return fResult;
}

vec4 czm_getVolumeValue(vec3 texCoord)
{
	float fLevel = (depth - 1.0) * texCoord.z;
	float bottomLevel= floor(fLevel);
	float topLevel = bottomLevel + 1.0;
	float ratio = topLevel - fLevel;
	float yOffset1 = floor((topLevel+0.25/sideBlockCount) / sideBlockCount);
	float xOffset1 = topLevel - yOffset1 * sideBlockCount;
	float texCoordV1 = (texCoord.y * height + yOffset1 * blockLength)/texLength;
	float texCoordU1 = (texCoord.x * width + xOffset1 * blockLength)/texLength;
	vec4 volumeColor1 = texture2D(uVolumeTexture, vec2(texCoordU1,texCoordV1));
	float yOffset2 = floor((bottomLevel+0.25/sideBlockCount) / sideBlockCount);
	float xOffset2 = bottomLevel - yOffset2 * sideBlockCount;
	float texCoordV2 = (texCoord.y * height + yOffset2 * blockLength)/texLength;
	float texCoordU2 = (texCoord.x * width + xOffset2 * blockLength)/texLength;
	vec4 volumeColor2 = texture2D(uVolumeTexture, vec2(texCoordU2, texCoordV2));

	if(uFilterMode >0.5)
	{
		if(ratio<0.5)
		{
			ratio = 0.0;
		}
		else
		{
			ratio = 1.0;
		}
	}

	vec4 volumeColor = mix(volumeColor1, volumeColor2, ratio);

	return volumeColor;
}
#endif`});var UGe,GGe=Ee(()=>{UGe=`uniform sampler2D uVolumeTexture1;
uniform sampler2D uVolumeTexture2;
uniform sampler2D uVolumeTexture3;


uniform mat4 uMultiResolutionPara1;
/*
{uMultiResolutionTranslation1
0.0, 0.0, 0.0, 0.0,
width1,height1,sideBlockCount1,blockLength1
texLength1, 0.0, 0.0, 0.0};
*/
uniform mat4 uMultiResolutionPara2;
uniform mat4 uMultiResolutionPara3;

#ifdef TIME_ORDER
uniform sampler2D uNextVolumeTexture1;
uniform sampler2D uNextVolumeTexture2;
uniform sampler2D uNextVolumeTexture3;
#endif

#ifdef Volume

vec2 computeVolumeTextureCoord(vec2 texCoord, float fLevel, float texWidth, float texHeight, float texSideBlockCount, float texBlockLength, float texTotalLength)
{
    float yOffset = floor((fLevel+0.25/texSideBlockCount) / texSideBlockCount);
    float xOffset = fLevel - yOffset * texSideBlockCount;
    float texCoordV = (texCoord.y * texHeight + yOffset * texBlockLength) / texTotalLength;
    float texCoordU = (texCoord.x * texWidth + xOffset * texBlockLength) / texTotalLength;
    return vec2(texCoordU, texCoordV);
}

float czm_getVolumeValueMultiResolution(vec3 texCoord, out float noValue)
{
    float fLevel = (depth - 1.0) * texCoord.z;
    float bottomLevel= floor(fLevel);
    float topLevel = bottomLevel + 1.0;
    float ratio = topLevel - fLevel;


    vec2 topTexCoord = computeVolumeTextureCoord(texCoord, topLevel);
    vec2 bottomTexCoord = computeVolumeTextureCoord(texCoord, bottomLevel);

    float fResult = computeVolumeValue(uVolumeTexture, topTexCoord, bottomTexCoord, ratio, noValue);
#ifdef TIME_ORDER
    float fNextResult = computeVolumeValue(uNextVolumeTexture, topTexCoord, bottomTexCoord, ratio, noValue);
    fResult = mix(fResult, fNextResult, uTimeRatio);
#endif


    float width = uMultiResolutionPara1[2].x;
    float height = uMultiResolutionPara1[2].y;
    float sideBlockCount = uMultiResolutionPara1[2].z;
    float blockLength = uMultiResolutionPara1[2].w;
    float texLength = uMultiResolutionPara1[3].x;
    vec4 uMultiResolutionTranslation = uMultiResolutionPara1[0];

    vec2 texCoord1 = (texCoord.xy - uMultiResolutionTranslation.xy) * uMultiResolutionTranslation.zw;
    vec2 topTexCoord1 = computeVolumeTextureCoord(texCoord1, topLevel, width, height, sideBlockCount, blockLength, texLength);
    vec2 bottomTexCoord1 = computeVolumeTextureCoord(texCoord1, bottomLevel, width, height, sideBlockCount, blockLength, texLength);
    float alpha1 = 5.0 * clamp( max(abs(texCoord1.x - 0.5), abs(texCoord1.y - 0.5)) - 0.3,0.0,0.2);

    float fResult1 = computeVolumeValue(uVolumeTexture1, topTexCoord1, bottomTexCoord1, ratio, noValue);
#ifdef TIME_ORDER
    float fNextResult1 = computeVolumeValue(uNextVolumeTexture1, topTexCoord1, bottomTexCoord1, ratio, noValue);
    fResult1 = mix(fResult1, fNextResult1, uTimeRatio);
#endif


    width = uMultiResolutionPara2[2].x;
    height = uMultiResolutionPara2[2].y;
    sideBlockCount = uMultiResolutionPara2[2].z;
    blockLength = uMultiResolutionPara2[2].w;
    texLength = uMultiResolutionPara2[3].x;
    uMultiResolutionTranslation = uMultiResolutionPara2[0];

    vec2 texCoord2 = (texCoord.xy - uMultiResolutionTranslation.xy) * uMultiResolutionTranslation.zw;
    vec2 topTexCoord2 = computeVolumeTextureCoord(texCoord2, topLevel, width, height, sideBlockCount, blockLength, texLength);
    vec2 bottomTexCoord2 = computeVolumeTextureCoord(texCoord2, bottomLevel, width, height, sideBlockCount, blockLength, texLength);
    float alpha2 = 5.0 * clamp( max(abs(texCoord2.x - 0.5), abs(texCoord2.y - 0.5)) - 0.3,0.0,0.2);

    float fResult2 = computeVolumeValue(uVolumeTexture2, topTexCoord2, bottomTexCoord2, ratio, noValue);
#ifdef TIME_ORDER
    float fNextResult2 = computeVolumeValue(uNextVolumeTexture2, topTexCoord2, bottomTexCoord2, ratio, noValue);
    fResult2 = mix(fResult2, fNextResult2, uTimeRatio);
#endif


    width = uMultiResolutionPara3[2].x;
    height = uMultiResolutionPara3[2].y;
    sideBlockCount = uMultiResolutionPara3[2].z;
    blockLength = uMultiResolutionPara3[2].w;
    texLength = uMultiResolutionPara3[3].x;
    uMultiResolutionTranslation = uMultiResolutionPara3[0];

    vec2 texCoord3 = (texCoord.xy - uMultiResolutionTranslation.xy) * uMultiResolutionTranslation.zw;
    vec2 topTexCoord3 = computeVolumeTextureCoord(texCoord3, topLevel, width, height, sideBlockCount, blockLength, texLength);
    vec2 bottomTexCoord3 = computeVolumeTextureCoord(texCoord3, bottomLevel, width, height, sideBlockCount, blockLength, texLength);
    float alpha3 = 5.0 * clamp( max(abs(texCoord3.x - 0.5), abs(texCoord3.y - 0.5)) - 0.3,0.0,0.2);

    float fResult3 = computeVolumeValue(uVolumeTexture3, topTexCoord3, bottomTexCoord3, ratio, noValue);

#ifdef TIME_ORDER
    float fNextResult3 = computeVolumeValue(uNextVolumeTexture3, topTexCoord3, bottomTexCoord3, ratio, noValue);
    fResult3 = mix(fResult3, fNextResult3, uTimeRatio);
#endif


    //return mix(fResult2, mix(fResult1, fResult, alpha1), alpha2);
    return mix(fResult3, mix(fResult2, mix(fResult1, fResult, alpha1), alpha2), alpha3);
}

#endif`});var HGe,WGe=Ee(()=>{HGe=`/**
 * @private
 */
vec4 czm_getWaterNoise(sampler2D normalMap, vec2 uv, float time, float angleInRadians)
{
    float cosAngle = cos(angleInRadians);
    float sinAngle = sin(angleInRadians);

    // time dependent sampling directions
    vec2 s0 = vec2(1.0/17.0, 0.0);
    vec2 s1 = vec2(-1.0/29.0, 0.0);
    vec2 s2 = vec2(1.0/101.0, 1.0/59.0);
    vec2 s3 = vec2(-1.0/109.0, -1.0/57.0);

    // rotate sampling direction by specified angle
    s0 = vec2((cosAngle * s0.x) - (sinAngle * s0.y), (sinAngle * s0.x) + (cosAngle * s0.y));
    s1 = vec2((cosAngle * s1.x) - (sinAngle * s1.y), (sinAngle * s1.x) + (cosAngle * s1.y));
    s2 = vec2((cosAngle * s2.x) - (sinAngle * s2.y), (sinAngle * s2.x) + (cosAngle * s2.y));
    s3 = vec2((cosAngle * s3.x) - (sinAngle * s3.y), (sinAngle * s3.x) + (cosAngle * s3.y));

    vec2 uv0 = (uv/103.0) + (time * s0);
    vec2 uv1 = uv/107.0 + (time * s1) + vec2(0.23);
    vec2 uv2 = uv/vec2(897.0, 983.0) + (time * s2) + vec2(0.51);
    vec2 uv3 = uv/vec2(991.0, 877.0) + (time * s3) + vec2(0.71);

    uv0 = fract(uv0);
    uv1 = fract(uv1);
    uv2 = fract(uv2);
    uv3 = fract(uv3);
    vec4 noise = (texture2D(normalMap, uv0)) +
                 (texture2D(normalMap, uv1)) +
                 (texture2D(normalMap, uv2)) +
                 (texture2D(normalMap, uv3));

    // average and scale to between -1 and 1
    return ((noise / 4.0) - 0.5) * 2.0;
}
`});var qGe,jGe=Ee(()=>{qGe=`/**
 * Returns the WGS84 ellipsoid, with its center at the origin of world coordinates, in eye coordinates.
 *
 * @name czm_getWgs84EllipsoidEC
 * @glslFunction
 *
 * @returns {czm_ellipsoid} The WGS84 ellipsoid, with its center at the origin of world coordinates, in eye coordinates.
 *
 * @see Ellipsoid.WGS84
 *
 * @example
 * czm_ellipsoid ellipsoid = czm_getWgs84EllipsoidEC();
 */
czm_ellipsoid czm_getWgs84EllipsoidEC()
{
    vec3 radii = vec3(6378137.0, 6378137.0, 6378137.0);
    vec3 inverseRadii = vec3(1.0 / radii.x, 1.0 / radii.y, 1.0 / radii.z);
    vec3 inverseRadiiSquared = inverseRadii * inverseRadii;
    czm_ellipsoid temp = czm_ellipsoid(czm_view[3].xyz, radii, inverseRadii, inverseRadiiSquared);
    return temp;
}
`});var YGe,QGe=Ee(()=>{YGe=`/**
 * Converts an HSB color (hue, saturation, brightness) to RGB
 * HSB <-> RGB conversion with minimal branching:
 *
 * @name czm_HSBToRGB
 * @glslFunction
 * 
 * @param {vec3} hsb The color in HSB.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 hsb = czm_RGBToHSB(rgb);
 * hsb.z *= 0.1;
 * rgb = czm_HSBToRGB(hsb);
 */

const vec4 K_HSB2RGB = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);

vec3 czm_HSBToRGB(vec3 hsb)
{
    vec3 p = abs(fract(hsb.xxx + K_HSB2RGB.xyz) * 6.0 - K_HSB2RGB.www);
    return hsb.z * mix(K_HSB2RGB.xxx, clamp(p - K_HSB2RGB.xxx, 0.0, 1.0), hsb.y);
}
`});var XGe,KGe=Ee(()=>{XGe=`/**
 * Converts an HSL color (hue, saturation, lightness) to RGB
 * HSL <-> RGB conversion: 
 *
 * @name czm_HSLToRGB
 * @glslFunction
 * 
 * @param {vec3} rgb The color in HSL.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 hsl = czm_RGBToHSL(rgb);
 * hsl.z *= 0.1;
 * rgb = czm_HSLToRGB(hsl);
 */

vec3 hueToRGB(float hue)
{
    float r = abs(hue * 6.0 - 3.0) - 1.0;
    float g = 2.0 - abs(hue * 6.0 - 2.0);
    float b = 2.0 - abs(hue * 6.0 - 4.0);
    return clamp(vec3(r, g, b), 0.0, 1.0);
}

vec3 czm_HSLToRGB(vec3 hsl)
{
    vec3 rgb = hueToRGB(hsl.x);
    float c = (1.0 - abs(2.0 * hsl.z - 1.0)) * hsl.y;
    return (rgb - 0.5) * c + hsl.z;
}
`});var ZGe,JGe=Ee(()=>{ZGe=`/**
 * Adjusts the hue of a color.
 * 
 * @name czm_hue
 * @glslFunction
 * 
 * @param {vec3} rgb The color.
 * @param {float} adjustment The amount to adjust the hue of the color in radians.
 *
 * @returns {float} The color with the hue adjusted.
 *
 * @example
 * vec3 adjustHue = czm_hue(color, czm_pi); // The same as czm_hue(color, -czm_pi)
 */
vec3 czm_hue(vec3 rgb, float adjustment)
{
    const mat3 toYIQ = mat3(0.299,     0.587,     0.114,
                            0.595716, -0.274453, -0.321263,
                            0.211456, -0.522591,  0.311135);
    const mat3 toRGB = mat3(1.0,  0.9563,  0.6210,
                            1.0, -0.2721, -0.6474,
                            1.0, -1.107,   1.7046);
    
    vec3 yiq = toYIQ * rgb;
    float hue = atan(yiq.z, yiq.y) + adjustment;
    float chroma = sqrt(yiq.z * yiq.z + yiq.y * yiq.y);
    
    vec3 color = vec3(yiq.x, chroma * cos(hue), chroma * sin(hue));
    return toRGB * color;
}
`});var $Ge,eHe=Ee(()=>{$Ge=`/**
 * Converts a color in linear space to RGB space.
 *
 * @name czm_inverseGamma
 * @glslFunction
 *
 * @param {vec3} color The color in linear space.
 * @returns {vec3} The color in RGB space.
 */
vec3 czm_inverseGamma(vec3 color) {
    return pow(color, vec3(1.0 / czm_gamma));
}
`});var tHe,rHe=Ee(()=>{tHe=`mat3 czm_inverseMatrix(mat3 m)
{
    float Determinant =
           m[0][0] * (m[1][1] * m[2][2] - m[2][1] * m[1][2])
         - m[1][0] * (m[0][1] * m[2][2] - m[2][1] * m[0][2])
         + m[2][0] * (m[0][1] * m[1][2] - m[1][1] * m[0][2]);

     mat3 Inverse;
     Inverse[0][0] = + (m[1][1] * m[2][2] - m[2][1] * m[1][2]);
     Inverse[1][0] = - (m[1][0] * m[2][2] - m[2][0] * m[1][2]);
     Inverse[2][0] = + (m[1][0] * m[2][1] - m[2][0] * m[1][1]);
     Inverse[0][1] = - (m[0][1] * m[2][2] - m[2][1] * m[0][2]);
     Inverse[1][1] = + (m[0][0] * m[2][2] - m[2][0] * m[0][2]);
     Inverse[2][1] = - (m[0][0] * m[2][1] - m[2][0] * m[0][1]);
     Inverse[0][2] = + (m[0][1] * m[1][2] - m[1][1] * m[0][2]);
     Inverse[1][2] = - (m[0][0] * m[1][2] - m[1][0] * m[0][2]);
     Inverse[2][2] = + (m[0][0] * m[1][1] - m[1][0] * m[0][1]);
     Inverse /= Determinant;

     return Inverse;
}

mat4 czm_inverseMatrix(mat4 m)
{
    float Coef00 = m[2][2] * m[3][3] - m[3][2] * m[2][3];
     float Coef02 = m[1][2] * m[3][3] - m[3][2] * m[1][3];
     float Coef03 = m[1][2] * m[2][3] - m[2][2] * m[1][3];

     float Coef04 = m[2][1] * m[3][3] - m[3][1] * m[2][3];
     float Coef06 = m[1][1] * m[3][3] - m[3][1] * m[1][3];
     float Coef07 = m[1][1] * m[2][3] - m[2][1] * m[1][3];

     float Coef08 = m[2][1] * m[3][2] - m[3][1] * m[2][2];
     float Coef10 = m[1][1] * m[3][2] - m[3][1] * m[1][2];
     float Coef11 = m[1][1] * m[2][2] - m[2][1] * m[1][2];

     float Coef12 = m[2][0] * m[3][3] - m[3][0] * m[2][3];
     float Coef14 = m[1][0] * m[3][3] - m[3][0] * m[1][3];
     float Coef15 = m[1][0] * m[2][3] - m[2][0] * m[1][3];

     float Coef16 = m[2][0] * m[3][2] - m[3][0] * m[2][2];
     float Coef18 = m[1][0] * m[3][2] - m[3][0] * m[1][2];
     float Coef19 = m[1][0] * m[2][2] - m[2][0] * m[1][2];

     float Coef20 = m[2][0] * m[3][1] - m[3][0] * m[2][1];
     float Coef22 = m[1][0] * m[3][1] - m[3][0] * m[1][1];
     float Coef23 = m[1][0] * m[2][1] - m[2][0] * m[1][1];

     const vec4 SignA = vec4( 1.0, -1.0,  1.0, -1.0);
     const vec4 SignB = vec4(-1.0,  1.0, -1.0,  1.0);

     vec4 Fac0 = vec4(Coef00, Coef00, Coef02, Coef03);
     vec4 Fac1 = vec4(Coef04, Coef04, Coef06, Coef07);
     vec4 Fac2 = vec4(Coef08, Coef08, Coef10, Coef11);
     vec4 Fac3 = vec4(Coef12, Coef12, Coef14, Coef15);
     vec4 Fac4 = vec4(Coef16, Coef16, Coef18, Coef19);
     vec4 Fac5 = vec4(Coef20, Coef20, Coef22, Coef23);

     vec4 Vec0 = vec4(m[1][0], m[0][0], m[0][0], m[0][0]);
     vec4 Vec1 = vec4(m[1][1], m[0][1], m[0][1], m[0][1]);
     vec4 Vec2 = vec4(m[1][2], m[0][2], m[0][2], m[0][2]);
     vec4 Vec3 = vec4(m[1][3], m[0][3], m[0][3], m[0][3]);

     vec4 Inv0 = SignA * (Vec1 * Fac0 - Vec2 * Fac1 + Vec3 * Fac2);
     vec4 Inv1 = SignB * (Vec0 * Fac0 - Vec2 * Fac3 + Vec3 * Fac4);
     vec4 Inv2 = SignA * (Vec0 * Fac1 - Vec1 * Fac3 + Vec3 * Fac5);
     vec4 Inv3 = SignB * (Vec0 * Fac2 - Vec1 * Fac4 + Vec2 * Fac5);

     mat4 Inverse = mat4(Inv0, Inv1, Inv2, Inv3);

     vec4 Row0 = vec4(Inverse[0][0], Inverse[1][0], Inverse[2][0], Inverse[3][0]);

     float Determinant = dot(m[0], Row0);

     Inverse /= Determinant;

     return Inverse;
}
`});var iHe,nHe=Ee(()=>{iHe=`/**
 * Determines if a time interval is empty.
 *
 * @name czm_isEmpty
 * @glslFunction 
 * 
 * @param {czm_raySegment} interval The interval to test.
 * 
 * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.
 *
 * @example
 * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true
 * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false
 * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.
 */
bool czm_isEmpty(czm_raySegment interval)
{
    return (interval.stop < 0.0);
}
`});var oHe,aHe=Ee(()=>{oHe=`/**
 * Determines if a time interval is empty.
 *
 * @name czm_isFull
 * @glslFunction 
 * 
 * @param {czm_raySegment} interval The interval to test.
 * 
 * @returns {bool} <code>true</code> if the time interval is empty; otherwise, <code>false</code>.
 *
 * @example
 * bool b0 = czm_isEmpty(czm_emptyRaySegment);      // true
 * bool b1 = czm_isEmpty(czm_raySegment(0.0, 1.0)); // false
 * bool b2 = czm_isEmpty(czm_raySegment(1.0, 1.0)); // false, contains 1.0.
 */
bool czm_isFull(czm_raySegment interval)
{
    return (interval.start == 0.0 && interval.stop == czm_infinity);
}
`});var sHe,lHe=Ee(()=>{sHe=`/**
 * Computes the fraction of a Web Wercator rectangle at which a given geodetic latitude is located.
 *
 * @name czm_latitudeToWebMercatorFraction
 * @glslFunction
 *
 * @param {float} latitude The geodetic latitude, in radians.
 * @param {float} southMercatorY The Web Mercator coordinate of the southern boundary of the rectangle.
 * @param {float} oneOverMercatorHeight The total height of the rectangle in Web Mercator coordinates.
 *
 * @returns {float} The fraction of the rectangle at which the latitude occurs.  If the latitude is the southern
 *          boundary of the rectangle, the return value will be zero.  If it is the northern boundary, the return
 *          value will be 1.0.  Latitudes in between are mapped according to the Web Mercator projection.
 */ 
float czm_latitudeToWebMercatorFraction(float latitude, float southMercatorY, float oneOverMercatorHeight)
{
    float sinLatitude = sin(latitude);
    float mercatorY = 0.5 * log((1.0 + sinLatitude) / (1.0 - sinLatitude));
    
    return (mercatorY - southMercatorY) * oneOverMercatorHeight;
}
`});var uHe,cHe=Ee(()=>{uHe=`/**
 * Computes distance from an point in 2D to a line in 2D.
 *
 * @name czm_lineDistance
 * @glslFunction
 *
 * param {vec2} point1 A point along the line.
 * param {vec2} point2 A point along the line.
 * param {vec2} point A point that may or may not be on the line.
 * returns {float} The distance from the point to the line.
 */
float czm_lineDistance(vec2 point1, vec2 point2, vec2 point) {
    return abs((point2.y - point1.y) * point.x - (point2.x - point1.x) * point.y + point2.x * point1.y - point2.y * point1.x) / distance(point2, point1);
}
`});var fHe,xHe=Ee(()=>{fHe=`/**
 * Computes the luminance of a color. 
 *
 * @name czm_luminance
 * @glslFunction
 *
 * @param {vec3} rgb The color.
 * 
 * @returns {float} The luminance.
 *
 * @example
 * float light = czm_luminance(vec3(0.0)); // 0.0
 * float dark = czm_luminance(vec3(1.0));  // ~1.0 
 */
float czm_luminance(vec3 rgb)
{
    // Algorithm from Chapter 10 of Graphics Shaders.
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    return dot(rgb, W);
}
`});var hHe,dHe=Ee(()=>{hHe=`/**
 * Computes the size of a pixel in meters at a distance from the eye.
 * <p>
 * Use this version when passing in a custom pixel ratio. For example, passing in 1.0 will return meters per native device pixel.
 * </p>
 * @name czm_metersPerPixel
 * @glslFunction
 *
 * @param {vec3} positionEC The position to get the meters per pixel in eye coordinates.
 * @param {float} pixelRatio The scaling factor from pixel space to coordinate space
 *
 * @returns {float} The meters per pixel at positionEC.
 */
float czm_metersPerPixel(vec4 positionEC, float pixelRatio)
{
    float width = czm_viewport.z;
    float height = czm_viewport.w;
    float pixelWidth;
    float pixelHeight;

    float top = czm_frustumPlanes.x;
    float bottom = czm_frustumPlanes.y;
    float left = czm_frustumPlanes.z;
    float right = czm_frustumPlanes.w;

    if (czm_sceneMode == czm_sceneMode2D || czm_orthographicIn3D == 1.0)
    {
        float frustumWidth = right - left;
        float frustumHeight = top - bottom;
        pixelWidth = frustumWidth / width;
        pixelHeight = frustumHeight / height;
    }
    else
    {
        float distanceToPixel = -positionEC.z;
        float inverseNear = 1.0 / czm_currentFrustum.x;
        float tanTheta = top * inverseNear;
        pixelHeight = 2.0 * distanceToPixel * tanTheta / height;
        tanTheta = right * inverseNear;
        pixelWidth = 2.0 * distanceToPixel * tanTheta / width;
    }

    return max(pixelWidth, pixelHeight) * pixelRatio;
}

/**
 * Computes the size of a pixel in meters at a distance from the eye.
 * <p>
 * Use this version when scaling by pixel ratio.
 * </p>
 * @name czm_metersPerPixel
 * @glslFunction
 *
 * @param {vec3} positionEC The position to get the meters per pixel in eye coordinates.
 *
 * @returns {float} The meters per pixel at positionEC.
 */
float czm_metersPerPixel(vec4 positionEC)
{
    return czm_metersPerPixel(positionEC, czm_pixelRatio);
}
`});var mHe,pHe=Ee(()=>{mHe=`/**
 * Transforms a position from model to window coordinates.  The transformation
 * from model to clip coordinates is done using {@link czm_modelViewProjection}.
 * The transform from normalized device coordinates to window coordinates is
 * done using {@link czm_viewportTransformation}, which assumes a depth range
 * of <code>near = 0</code> and <code>far = 1</code>.
 * <br /><br />
 * This transform is useful when there is a need to manipulate window coordinates
 * in a vertex shader as done by {@link BillboardCollection}.
 * <br /><br />
 * This function should not be confused with {@link czm_viewportOrthographic},
 * which is an orthographic projection matrix that transforms from window 
 * coordinates to clip coordinates.
 *
 * @name czm_modelToWindowCoordinates
 * @glslFunction
 *
 * @param {vec4} position The position in model coordinates to transform.
 *
 * @returns {vec4} The transformed position in window coordinates.
 *
 * @see czm_eyeToWindowCoordinates
 * @see czm_modelViewProjection
 * @see czm_viewportTransformation
 * @see czm_viewportOrthographic
 * @see BillboardCollection
 *
 * @example
 * vec4 positionWC = czm_modelToWindowCoordinates(positionMC);
 */
vec4 czm_modelToWindowCoordinates(vec4 position)
{
    vec4 q = czm_modelViewProjection * position;                // clip coordinates
    q.xyz /= q.w;                                                // normalized device coordinates
    q.xyz = (czm_viewportTransformation * vec4(q.xyz, 1.0)).xyz; // window coordinates
    return q;
}
`});var vHe,gHe=Ee(()=>{vHe=`/**
 * DOC_TBA
 *
 * @name czm_multiplyWithColorBalance
 * @glslFunction
 */
vec3 czm_multiplyWithColorBalance(vec3 left, vec3 right)
{
    // Algorithm from Chapter 10 of Graphics Shaders.
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    
    vec3 target = left * right;
    float leftLuminance = dot(left, W);
    float rightLuminance = dot(right, W);
    float targetLuminance = dot(target, W);
    
    return ((leftLuminance + rightLuminance) / (2.0 * targetLuminance)) * target;
}
`});var _He,yHe=Ee(()=>{_He=`/**
 * Computes a value that scales with distance.  The scaling is clamped at the near and
 * far distances, and does not extrapolate.  This function works with the
 * {@link NearFarScalar} JavaScript class.
 *
 * @name czm_nearFarScalar
 * @glslFunction
 *
 * @param {vec4} nearFarScalar A vector with 4 components: Near distance (x), Near value (y), Far distance (z), Far value (w).
 * @param {float} cameraDistSq The square of the current distance from the camera.
 *
 * @returns {float} The value at this distance.
 */
float czm_nearFarScalar(vec4 nearFarScalar, float cameraDistSq)
{
    float valueAtMin = nearFarScalar.y;
    float valueAtMax = nearFarScalar.w;
    float nearDistanceSq = nearFarScalar.x * nearFarScalar.x;
    float farDistanceSq = nearFarScalar.z * nearFarScalar.z;

    float t = (cameraDistSq - nearDistanceSq) / (farDistanceSq - nearDistanceSq);

    t = pow(clamp(t, 0.0, 1.0), 0.2);

    return mix(valueAtMin, valueAtMax, t);
}
`});var AHe,CHe=Ee(()=>{AHe=` /**
  * Decodes a unit-length vector in 'oct' encoding to a normalized 3-component Cartesian vector.
  * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
  * Cigolle et al 2014:
  *
  * @name czm_octDecode
  * @param {vec2} encoded The oct-encoded, unit-length vector
  * @param {float} range The maximum value of the SNORM range. The encoded vector is stored in log2(rangeMax+1) bits.
  * @returns {vec3} The decoded and normalized vector
  */
  vec3 czm_octDecode(vec2 encoded, float range)
  {
      if (encoded.x == 0.0 && encoded.y == 0.0) {
          return vec3(0.0, 0.0, 0.0);
      }

     encoded = encoded / range * 2.0 - 1.0;
     vec3 v = vec3(encoded.x, encoded.y, 1.0 - abs(encoded.x) - abs(encoded.y));
     if (v.z < 0.0)
     {
         v.xy = (1.0 - abs(v.yx)) * czm_signNotZero(v.xy);
     }

     return normalize(v);
  }

/**
 * Decodes a unit-length vector in 'oct' encoding to a normalized 3-component Cartesian vector.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014:
 *
 * @name czm_octDecode
 * @param {vec2} encoded The oct-encoded, unit-length vector
 * @returns {vec3} The decoded and normalized vector
 */
 vec3 czm_octDecode(vec2 encoded)
 {
    return czm_octDecode(encoded, 255.0);
 }

 /**
 * Decodes a unit-length vector in 'oct' encoding packed into a floating-point number to a normalized 3-component Cartesian vector.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014:
 *
 * @name czm_octDecode
 * @param {float} encoded The oct-encoded, unit-length vector
 * @returns {vec3} The decoded and normalized vector
 */
 vec3 czm_octDecode(float encoded)
 {
    float temp = encoded / 256.0;
    float x = floor(temp);
    float y = (temp - x) * 256.0;
    return czm_octDecode(vec2(x, y));
 }

/**
 * Decodes three unit-length vectors in 'oct' encoding packed into two floating-point numbers to normalized 3-component Cartesian vectors.
 * The 'oct' encoding is described in "A Survey of Efficient Representations of Independent Unit Vectors",
 * Cigolle et al 2014:
 *
 * @name czm_octDecode
 * @param {vec2} encoded The packed oct-encoded, unit-length vectors.
 * @param {vec3} vector1 One decoded and normalized vector.
 * @param {vec3} vector2 One decoded and normalized vector.
 * @param {vec3} vector3 One decoded and normalized vector.
 */
  void czm_octDecode(vec2 encoded, out vec3 vector1, out vec3 vector2, out vec3 vector3)
 {
    float temp = encoded.x / 65536.0;
    float x = floor(temp);
    float encodedFloat1 = (temp - x) * 65536.0;

    temp = encoded.y / 65536.0;
    float y = floor(temp);
    float encodedFloat2 = (temp - y) * 65536.0;

    vector1 = czm_octDecode(encodedFloat1);
    vector2 = czm_octDecode(encodedFloat2);
    vector3 = czm_octDecode(vec2(x, y));
 }

`});var THe,wHe=Ee(()=>{THe=`/**
 * Packs a depth value into a vec3 that can be represented by unsigned bytes.
 *
 * @name czm_packDepth
 * @glslFunction
 *
 * @param {float} depth The floating-point depth.
 * @returns {vec3} The packed depth.
 */
vec4 czm_packDepth(float depth)
{
    // See Aras Pranckevi\u010Dius' post Encoding Floats to RGBA
    vec4 enc = vec4(1.0, 255.0, 65025.0, 16581375.0) * depth;
    enc = fract(enc);
    enc -= enc.yzww * vec4(1.0 / 255.0, 1.0 / 255.0, 1.0 / 255.0, 0.0);
    return enc;
}
`});var EHe,bHe=Ee(()=>{EHe=`/**
 * Packs a float value into a vec3 that can be represented by unsigned bytes.
 *
 * @name czm_packValue
 * @glslFunction
 *
 * @param {float} value The floating-point value.
 * @returns {vec3} The packed value.
 */
vec4 czm_packValue(float value)
{
    float SHIFT_LEFT8 = 256.0;
	float SHIFT_RIGHT8 = 1.0 / 256.0;
	vec4 result;
	result.a = 255.0;
	float fPos = abs(value + 9000.0) * SHIFT_RIGHT8;
	result.b = (fPos - floor(fPos)) * SHIFT_LEFT8;
	fPos = floor(fPos) * SHIFT_RIGHT8;
	result.g = (fPos - floor(fPos)) * SHIFT_LEFT8;
	result.r = floor(fPos);
	result /= 255.0;
	return result;
}
`});var SHe,IHe=Ee(()=>{SHe=`float czm_private_getLambertDiffuseOfMaterial(vec3 lightDirectionEC, czm_material material)
{
    return czm_getLambertDiffuse(lightDirectionEC, material.normal);
}

float czm_private_getSpecularOfMaterial(vec3 lightDirectionEC, vec3 toEyeEC, czm_material material)
{
    return czm_getSpecular(lightDirectionEC, toEyeEC, material.normal, material.shininess);
}

/**
 * Computes a color using the Phong lighting model.
 *
 * @name czm_phong
 * @glslFunction
 *
 * @param {vec3} toEye A normalized vector from the fragment to the eye in eye coordinates.
 * @param {czm_material} material The fragment's material.
 *
 * @returns {vec4} The computed color.
 *
 * @example
 * vec3 positionToEyeEC = // ...
 * czm_material material = // ...
 * vec3 lightDirectionEC = // ...
 * gl_FragColor = czm_phong(normalize(positionToEyeEC), material, lightDirectionEC);
 *
 * @see czm_getMaterial
 */
vec4 czm_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    // Diffuse from directional light sources at eye (for top-down)
    float diffuse = czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 0.0, 1.0), material);
    if (czm_sceneMode == czm_sceneMode3D) {
        // (and horizon views in 3D)
        diffuse += czm_private_getLambertDiffuseOfMaterial(vec3(0.0, 1.0, 0.0), material);
    }

    float specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);

    // Temporary workaround for adding ambient.
    vec3 materialDiffuse = material.diffuse * 0.5;

    vec3 ambient = materialDiffuse;
    vec3 color = ambient + material.emission;
    color += materialDiffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}

vec4 czm_private_phong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    float diffuse = czm_private_getLambertDiffuseOfMaterial(lightDirectionEC, material);
    float specular = czm_private_getSpecularOfMaterial(lightDirectionEC, toEye, material);

    vec3 ambient = vec3(0.0);
    vec3 color = ambient + material.emission;
    color += material.diffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}
`});var PHe,DHe=Ee(()=>{PHe=`/**
 * Computes distance from a point to a plane.
 *
 * @name czm_planeDistance
 * @glslFunction
 *
 * param {vec4} plane A Plane in Hessian Normal Form. See Plane.js
 * param {vec3} point A point in the same space as the plane.
 * returns {float} The distance from the point to the plane.
 */
float czm_planeDistance(vec4 plane, vec3 point) {
    return (dot(plane.xyz, point) + plane.w);
}

/**
 * Computes distance from a point to a plane.
 *
 * @name czm_planeDistance
 * @glslFunction
 *
 * param {vec3} planeNormal Normal for a plane in Hessian Normal Form. See Plane.js
 * param {float} planeDistance Distance for a plane in Hessian Normal form. See Plane.js
 * param {vec3} point A point in the same space as the plane.
 * returns {float} The distance from the point to the plane.
 */
float czm_planeDistance(vec3 planeNormal, float planeDistance, vec3 point) {
    return (dot(planeNormal, point) + planeDistance);
}
`});var MHe,BHe=Ee(()=>{MHe=`/**
 * Computes the point along a ray at the given time.  <code>time</code> can be positive, negative, or zero.
 *
 * @name czm_pointAlongRay
 * @glslFunction
 *
 * @param {czm_ray} ray The ray to compute the point along.
 * @param {float} time The time along the ray.
 * 
 * @returns {vec3} The point along the ray at the given time.
 * 
 * @example
 * czm_ray ray = czm_ray(vec3(0.0), vec3(1.0, 0.0, 0.0)); // origin, direction
 * vec3 v = czm_pointAlongRay(ray, 2.0); // (2.0, 0.0, 0.0)
 */
vec3 czm_pointAlongRay(czm_ray ray, float time)
{
    return ray.origin + (time * ray.direction);
}
`});var RHe,LHe=Ee(()=>{RHe=`/**
 * DOC_TBA
 *
 * @name czm_rayEllipsoidIntersectionInterval
 * @glslFunction
 */
czm_raySegment czm_rayEllipsoidIntersectionInterval(czm_ray ray, vec3 ellipsoid_center, vec3 ellipsoid_inverseRadii)
{
   // ray and ellipsoid center in eye coordinates.  radii in model coordinates.
    vec3 q = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.origin, 1.0)).xyz;
    vec3 w = ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ray.direction, 0.0)).xyz;

    q = q - ellipsoid_inverseRadii * (czm_inverseModelView * vec4(ellipsoid_center, 1.0)).xyz;

    float q2 = dot(q, q);
    float qw = dot(q, w);

    if (q2 > 1.0) // Outside ellipsoid.
    {
        if (qw >= 0.0) // Looking outward or tangent (0 intersections).
        {
            return czm_emptyRaySegment;
        }
        else // qw < 0.0.
        {
            float qw2 = qw * qw;
            float difference = q2 - 1.0; // Positively valued.
            float w2 = dot(w, w);
            float product = w2 * difference;

            if (qw2 < product) // Imaginary roots (0 intersections).
            {
                return czm_emptyRaySegment;
            }
            else if (qw2 > product) // Distinct roots (2 intersections).
            {
                float discriminant = qw * qw - product;
                float temp = -qw + sqrt(discriminant); // Avoid cancellation.
                float root0 = temp / w2;
                float root1 = difference / temp;
                if (root0 < root1)
                {
                    czm_raySegment i = czm_raySegment(root0, root1);
                    return i;
                }
                else
                {
                    czm_raySegment i = czm_raySegment(root1, root0);
                    return i;
                }
            }
            else // qw2 == product.  Repeated roots (2 intersections).
            {
                float root = sqrt(difference / w2);
                czm_raySegment i = czm_raySegment(root, root);
                return i;
            }
        }
    }
    else if (q2 < 1.0) // Inside ellipsoid (2 intersections).
    {
        float difference = q2 - 1.0; // Negatively valued.
        float w2 = dot(w, w);
        float product = w2 * difference; // Negatively valued.
        float discriminant = qw * qw - product;
        float temp = -qw + sqrt(discriminant); // Positively valued.
        czm_raySegment i = czm_raySegment(0.0, temp / w2);
        return i;
    }
    else // q2 == 1.0. On ellipsoid.
    {
        if (qw < 0.0) // Looking inward.
        {
            float w2 = dot(w, w);
            czm_raySegment i = czm_raySegment(0.0, -qw / w2);
            return i;
        }
        else // qw >= 0.0.  Looking outward or tangent.
        {
            return czm_emptyRaySegment;
        }
    }
}
`});var OHe,FHe=Ee(()=>{OHe=`float czm_readDepth(sampler2D depthTexture, vec2 texCoords)
{
    return czm_reverseLogDepth(texture2D(depthTexture, texCoords).r);
}
`});var NHe,zHe=Ee(()=>{NHe=`/**
 * Reads a value previously transformed with {@link czm_writeNonPerspective}
 * by dividing it by \`w\`, the value used in the perspective divide.
 * This function is intended to be called in a fragment shader to access a
 * \`varying\` that should not be subject to perspective interpolation.
 * For example, screen-space texture coordinates. The value should have been
 * previously written in the vertex shader with a call to
 * {@link czm_writeNonPerspective}.
 *
 * @name czm_readNonPerspective
 * @glslFunction
 *
 * @param {float|vec2|vec3|vec4} value The non-perspective value to be read.
 * @param {float} oneOverW One over the perspective divide value, \`w\`. Usually this is simply \`gl_FragCoord.w\`.
 * @returns {float|vec2|vec3|vec4} The usable value.
 */
float czm_readNonPerspective(float value, float oneOverW) {
    return value * oneOverW;
}

vec2 czm_readNonPerspective(vec2 value, float oneOverW) {
    return value * oneOverW;
}

vec3 czm_readNonPerspective(vec3 value, float oneOverW) {
    return value * oneOverW;
}

vec4 czm_readNonPerspective(vec4 value, float oneOverW) {
    return value * oneOverW;
}
`});var VHe,kHe=Ee(()=>{VHe=`float czm_reverseLogDepth(float logZ)
{
#ifdef LOG_DEPTH
    float near = czm_currentFrustum.x;
    float far = czm_currentFrustum.y;
    float log2Depth = logZ * czm_log2FarDepthFromNearPlusOne;
    float depthFromNear = pow(2.0, log2Depth) - 1.0;
    return far * (1.0 - near / (depthFromNear + near)) / (far - near);
#endif
    return logZ;
}
`});var UHe,GHe=Ee(()=>{UHe=`/**
 * Converts an RGB color to HSB (hue, saturation, brightness)
 * HSB <-> RGB conversion with minimal branching:
 *
 * @name czm_RGBToHSB
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in HSB.
 *
 * @example
 * vec3 hsb = czm_RGBToHSB(rgb);
 * hsb.z *= 0.1;
 * rgb = czm_HSBToRGB(hsb);
 */

const vec4 K_RGB2HSB = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);

vec3 czm_RGBToHSB(vec3 rgb)
{
    vec4 p = mix(vec4(rgb.bg, K_RGB2HSB.wz), vec4(rgb.gb, K_RGB2HSB.xy), step(rgb.b, rgb.g));
    vec4 q = mix(vec4(p.xyw, rgb.r), vec4(rgb.r, p.yzx), step(p.x, rgb.r));

    float d = q.x - min(q.w, q.y);
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + czm_epsilon7)), d / (q.x + czm_epsilon7), q.x);
}
`});var HHe,WHe=Ee(()=>{HHe=`/**
 * Converts an RGB color to HSL (hue, saturation, lightness)
 * HSL <-> RGB conversion: 
 *
 * @name czm_RGBToHSL
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in HSL.
 *
 * @example
 * vec3 hsl = czm_RGBToHSL(rgb);
 * hsl.z *= 0.1;
 * rgb = czm_HSLToRGB(hsl);
 */
 
vec3 RGBtoHCV(vec3 rgb)
{
    // Based on work by Sam Hocevar and Emil Persson
    vec4 p = (rgb.g < rgb.b) ? vec4(rgb.bg, -1.0, 2.0 / 3.0) : vec4(rgb.gb, 0.0, -1.0 / 3.0);
    vec4 q = (rgb.r < p.x) ? vec4(p.xyw, rgb.r) : vec4(rgb.r, p.yzx);
    float c = q.x - min(q.w, q.y);
    float h = abs((q.w - q.y) / (6.0 * c + czm_epsilon7) + q.z);
    return vec3(h, c, q.x);
}

vec3 czm_RGBToHSL(vec3 rgb)
{
    vec3 hcv = RGBtoHCV(rgb);
    float l = hcv.z - hcv.y * 0.5;
    float s = hcv.y / (1.0 - abs(l * 2.0 - 1.0) + czm_epsilon7);
    return vec3(hcv.x, s, l);
}
`});var qHe,jHe=Ee(()=>{qHe=`/**
 * Converts an RGB color to CIE Yxy.
 * <p>The conversion is described in
 * </p>
 * 
 * @name czm_RGBToXYZ
 * @glslFunction
 * 
 * @param {vec3} rgb The color in RGB.
 *
 * @returns {vec3} The color in CIE Yxy.
 *
 * @example
 * vec3 xyz = czm_RGBToXYZ(rgb);
 * xyz.x = max(xyz.x - luminanceThreshold, 0.0);
 * rgb = czm_XYZToRGB(xyz);
 */
vec3 czm_RGBToXYZ(vec3 rgb)
{
    const mat3 RGB2XYZ = mat3(0.4124, 0.2126, 0.0193,
                              0.3576, 0.7152, 0.1192,
                              0.1805, 0.0722, 0.9505);
    vec3 xyz = RGB2XYZ * rgb;
    vec3 Yxy;
    Yxy.r = xyz.g;
    float temp = dot(vec3(1.0), xyz);
    Yxy.gb = xyz.rg / temp;
    return Yxy;
}
`});var YHe,QHe=Ee(()=>{YHe=`void czm_RollerShutter(vec2 coord, vec4 region)
{
    vec2 f = step(region.xw, coord);
    vec2 s = step(coord, region.zy);
    if (f.x * f.y * s.x * s.y < 1.0)
    {
        discard;
    };
}
`});var XHe,KHe=Ee(()=>{XHe=`void czm_s3mBatchOperation(vec4 operationType, vec4 color, vec4 selectedColor, inout vec4 vertexColor, inout vec4 vertexPos, inout vec4 vIsFiltByID, vec3 translation)
{
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        vertexColor *= color;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        vertexColor *= selectedColor;
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
    float isOffset = fract(floor(right_8)* 0.5);
    if(isOffset > 0.1)
    {
        vertexPos.xyz += translation;
    }
    float isClip = fract(floor(right_16) * 0.5);
    if(isClip > 0.1)
    {
        vIsFiltByID.x = 1.0;
    }
}

void czm_s3mBatchOperation(vec4 operationType, vec4 color, inout vec4 vertexColor, inout vec4 vertexPos, inout vec4 vIsFiltByID, vec3 translation, inout float fSelected)
{
    operationType.x += 0.001;
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        vertexColor *= color;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        fSelected = 1.0;
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
    float isOffset = fract(floor(right_8)* 0.5);
    if(isOffset > 0.1)
    {
        vertexPos.xyz += translation;
    }
    float isClip = fract(floor(right_16) * 0.5);
    if(isClip > 0.1)
    {
        vIsFiltByID.x = 1.0;
    }
}

void czm_s3mBatchOperation(vec4 operationType, vec4 color, vec4 selectedColor, inout vec4 vertexColor, inout vec4 vertexPos, inout vec4 vIsFiltByID, vec3 translation, inout float fSelected)
{
    operationType.x += 0.001;
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        #ifdef REPLACE_COLOR_TYPE
            vertexColor.rgb = color.rgb;
        #else
            vertexColor.rgb *= color.rgb;
        #endif
        vertexColor.a *= color.a;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        fSelected = 1.0;
        #ifdef REPLACE_SELECT_TYPE
            vertexColor = selectedColor;
        #else
            vertexColor *= selectedColor;
        #endif
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
    float isOffset = fract(floor(right_8)* 0.5);
    if(isOffset > 0.1)
    {
        vertexPos.xyz += translation;
    }
    float isClip = fract(floor(right_16) * 0.5);
    if(isClip > 0.1)
    {
        vIsFiltByID.x = 1.0;
    }
}

void czm_s3mBatchOperation(vec4 operationType, vec4 color, vec4 selectedColor, inout vec4 vertexColor)
{
    operationType.x += 0.001;
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        #ifdef REPLACE_COLOR_TYPE
            vertexColor.rgb = color.rgb;
        #else
            vertexColor.rgb *= color.rgb;
        #endif
        vertexColor.a *= color.a;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        vertexColor *= selectedColor;
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
}

void czm_s3mBatchOperation(vec4 operationType, vec4 color, vec4 selectedColor, inout vec4 vertexColor, inout float fSelected)
{
    operationType.x += 0.001;
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        fSelected = 1.0;
        vertexColor = color;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        fSelected = 1.0;
        vertexColor = selectedColor;
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
}

void czm_s3mBatchOperation(vec4 operationType, vec4 color, vec4 selectedColor, inout vec4 vertexColor, inout vec4 vertexPos, inout vec4 vIsFiltByID, vec3 translation, inout vec2 fSelected)
{
    operationType.x += 0.001;
    float right_2 = operationType.x * 0.5;
    float right_4 = right_2 * 0.5;
    float right_8 = right_4 * 0.5;
    float right_16 = right_8 * 0.5;
    float isSetColor = fract(right_2);
    if(isSetColor > 0.1)
    {
        fSelected.y = 1.0;
        color.a *= vertexColor.a;
        vertexColor = color;
    }
    float isPicked = fract(floor(right_2)* 0.5);
    if(isPicked > 0.1)
    {
        fSelected.x = 1.0;
        #ifdef REPLACE_SELECT_TYPE
            vertexColor = selectedColor;
        #else
            vertexColor *= selectedColor;
        #endif
    }
    float isHide = fract(floor(right_4)* 0.5);
    if(isHide > 0.1)
    {
        vertexColor.a = 0.0;
    }
    float isOffset = fract(floor(right_8)* 0.5);
    if(isOffset > 0.1)
    {
        vertexPos.xyz += translation;
    }
    float isClip = fract(floor(right_16) * 0.5);
    if(isClip > 0.1)
    {
        vIsFiltByID.x = 1.0;
    }
}`});var ZHe,JHe=Ee(()=>{ZHe=`    uniform float u_metallicFactor;
    uniform float u_roughnessFactor;
    uniform vec4 u_emissiveFactor;
    uniform vec4 u_baseColorFactor;
    uniform float u_alphaCutoff;
    uniform sampler2D u_baseColorTexture;
    uniform sampler2D u_metallicRoughnessTexture;
    uniform sampler2D u_normalTexture;
    uniform sampler2D u_occlusionTexture;
    uniform sampler2D u_emissiveTexture;
    uniform vec4 u_baseColorUVOffsetAndTiling;
    uniform vec4 u_emissiveUVOffsetAndTiling;

    uniform float uSunLightON;
    #if DIR_LIGHTS > 0
    uniform vec3 uDirectionalLightDirectionEC[ DIR_LIGHTS ];
    uniform vec3 uDirectionalLightColor[ DIR_LIGHTS ];
    #endif
    #if POINT_LIGHTS > 0
    uniform vec3 uPointLightPositionEC[ POINT_LIGHTS ];
    uniform vec3 uPointLightColor[ POINT_LIGHTS ];
    uniform vec2 uPointLightDistanceAndDecay[ POINT_LIGHTS ];
    #endif
    #if SPOT_LIGHTS > 0
    uniform vec3 uSpotLightColor[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightPositionEC[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightDirectionEC[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightDistanceDecayCos[ SPOT_LIGHTS ];
    uniform vec3 uSpotLightExponent[ SPOT_LIGHTS ];
    #endif

    const float M_PI = 3.141592653589793;

    vec3 lambertianDiffuse(vec3 diffuseColor)
    {
        return diffuseColor / M_PI;
    }

    vec3 fresnelSchlick2(vec3 f0, vec3 f90, float VdotH)
    {
        return f0 + (f90 - f0) * pow(clamp(1.0 - VdotH, 0.0, 1.0), 5.0);
    }

    vec3 fresnelSchlick(float metalness, float VdotH)
    {
        return metalness + (vec3(1.0) - metalness) * pow(1.0 - VdotH, 5.0);
    }

    vec3 F_Schlick(float ndv, vec3 spec)
    {
        return spec + (vec3(1.0) - spec) * pow(1.0 - ndv, 5.0);
    }

    float D_Phong(float g, float ndh)
    {
        float a = pow(8192.0, g);
        return (a + 2.0) / 8.0 * pow(ndh, a);
    }

    float smithVisibilityG1(float NdotV, float roughness)
    {
        float k = (roughness + 1.0) * (roughness + 1.0) / 8.0;
        return NdotV / (NdotV * (1.0 - k) + k);
    }

    float smithVisibilityGGX(float roughness, float NdotL, float NdotV)
    {
        return smithVisibilityG1(NdotL, roughness) * smithVisibilityG1(NdotV, roughness);
    }

    float GGX(float roughness, float NdotH)
    {
        float roughnessSquared = roughness * roughness;
        float f = (NdotH * roughnessSquared - NdotH) * NdotH + 1.0;
        return roughnessSquared / (M_PI * f * f);
    }

    void getLightColor(vec3 lightDir, vec3 viewDir, vec3 normal, vec3 lightColor, vec3 fresnelTerm, float roughness, out vec3 diffuseTerm, out vec3 specularTerm)
    {
        vec3 h = normalize(viewDir + lightDir);
        float NdotL = clamp(dot(normal, lightDir), 0.001, 1.0);
        float NdotH = clamp(dot(normal, h), 0.0, 1.0);
        vec3 li = lightColor * NdotL;
        diffuseTerm = li;
        specularTerm = li * fresnelTerm * D_Phong(1.0 - roughness, NdotH);
    }

    vec3 SRGBtoLINEAR3(vec3 srgbIn)
    {
        return pow(srgbIn, vec3(2.2));
    }

    vec4 SRGBtoLINEAR4(vec4 srgbIn)
    {
        vec3 linearOut = pow(srgbIn.rgb, vec3(2.2));
        return vec4(linearOut, srgbIn.a);
    }

    vec3 LINEARtoSRGB(vec3 linearIn)
    {
#ifndef HDR
        return pow(linearIn, vec3(1.0/2.2));
#else
        return linearIn;
#endif
    }

    float calcLightAttenuation(float lightDistance, float cutoffDistance, float decayExponent)
    {
        return pow(clamp(1.0 - lightDistance / cutoffDistance, 0.0, 1.0), decayExponent);
    }

    vec4 czm_S3MPBR(vec3 normalEC, vec3 positionEC, vec2 texCoord, vec4 vertexColor)
    {
        vec3 ng = normalize(normalEC);
        vec3 positionWC = (czm_inverseView * vec4(positionEC, 1.0)).xyz;
#ifdef HAS_NORMAL_TEXTURE
        vec3 pos_dx = dFdx(positionEC);
        vec3 pos_dy = dFdy(positionEC);
        vec3 tex_dx = dFdx(vec3(texCoord, 0.0));
        vec3 tex_dy = dFdy(vec3(texCoord, 0.0));
        vec3 t = (tex_dy.t * pos_dx - tex_dx.t * pos_dy) / (tex_dx.s * tex_dy.t - tex_dy.s * tex_dx.t);
        t = normalize(t - ng * dot(ng, t));
        vec3 b = normalize(cross(ng, t));
        mat3 tbn = mat3(t, b, ng);
        vec3 n = texture2D(u_normalTexture, texCoord).rgb;
        n = normalize(tbn * (2.0 * n - 1.0));
#else
        vec3 n = ng;
#endif

        vec3 v = -normalize(positionEC);
#ifdef DOUBLE_SIDED
        if (dot(n, v) < 0.0) {
            n = -n;
        }
#endif

        // Add base color to fragment shader
#ifdef HAS_BASECOLOR_TEXTURE
        vec2 baseColorTexCoord = texCoord;
        baseColorTexCoord = baseColorTexCoord * u_baseColorUVOffsetAndTiling.zw + u_baseColorUVOffsetAndTiling.xy;
        vec4 baseColorWithAlpha = SRGBtoLINEAR4(texture2D(u_baseColorTexture, baseColorTexCoord));
        baseColorWithAlpha *= u_baseColorFactor;
#else
        vec4 baseColorWithAlpha = u_baseColorFactor;
#endif
        baseColorWithAlpha *= vertexColor;
        vec3 baseColor = baseColorWithAlpha.rgb;
#ifdef HAS_METALLICROUGHNESS_TEXTURE
        vec3 metallicRoughness = texture2D(u_metallicRoughnessTexture, texCoord).rgb;
        float metalness = clamp(metallicRoughness.b, 0.0, 1.0);
        float roughness = clamp(metallicRoughness.g, 0.04, 1.0);
        metalness *= u_metallicFactor;
        roughness *= u_roughnessFactor;
#else
        float metalness = clamp(u_metallicFactor, 0.0, 1.0);
        float roughness = clamp(u_roughnessFactor, 0.04, 1.0);
#endif
        vec3 f0 = vec3(0.04);
        vec3 diffuseColor = baseColor * (1.0 - metalness) * (1.0 - f0);
        vec3 specularColor = mix(f0, baseColor, metalness);
        float NdotV = abs(dot(n, v)) + 0.001;
        vec3 diffuseTerm = vec3(0.0);
        vec3 specularTerm = vec3(0.0);
        vec3 fresnelTerm = F_Schlick(NdotV, specularColor);
        vec3 color = vec3(0.0);
        // \u9ED8\u8BA4\u52A0\u4E00\u4E2A\u5E73\u884C\u5149\u4F5C\u4E3A\u592A\u9633\u5149
        vec3 lightDiffuseTerm = vec3(0.0);
        vec3 lightSpecularTerm = vec3(0.0);
        getLightColor(czm_sunDirectionEC, v, n, vec3(0.8), fresnelTerm, roughness, lightDiffuseTerm, lightSpecularTerm);
        diffuseTerm +=lightDiffuseTerm * uSunLightON;
        specularTerm += lightSpecularTerm * uSunLightON;
#if DIR_LIGHTS > 0 
        for (int i = 0; i < DIR_LIGHTS; i++) { 
            getLightColor(uDirectionalLightDirectionEC[i], v, n, uDirectionalLightColor[i], fresnelTerm, roughness, lightDiffuseTerm, lightSpecularTerm);
            diffuseTerm +=lightDiffuseTerm;
            specularTerm += lightSpecularTerm;
        } 
#endif 
#if POINT_LIGHTS > 0 
        for (int i = 0; i < POINT_LIGHTS; i++) {
            vec3 lVector = uPointLightPositionEC[i] - v_positionEC;
            float lightDistance = length(lVector);
            float lightAttenuation = calcLightAttenuation(lightDistance, uPointLightDistanceAndDecay[i].x, uPointLightDistanceAndDecay[i].y);
            if(lightAttenuation < 0.001) {
                continue;
            }
            vec3 pointLightColor = uPointLightColor[i] * lightAttenuation;
            vec3 lightDiffuseTerm = vec3(0.0);
            vec3 lightSpecularTerm = vec3(0.0);
            getLightColor(normalize(lVector), v, n, pointLightColor, fresnelTerm, roughness, lightDiffuseTerm, lightSpecularTerm);
            diffuseTerm +=lightDiffuseTerm;
            specularTerm += lightSpecularTerm;
        }
#endif 
#if SPOT_LIGHTS > 0 
        for (int i = 0; i < SPOT_LIGHTS; i++) {
            vec3 lVector = uSpotLightPositionEC[i] - v_positionEC;
            float lightDistance = length(lVector);
            float lightAttenuation = calcLightAttenuation(lightDistance, uSpotLightDistanceDecayCos[i].x, uSpotLightDistanceDecayCos[i].y);
            if(lightAttenuation < 0.001) {
                continue;
            }
            float spotEffect = dot(uSpotLightDirectionEC[i], normalize(lVector));
            if(spotEffect > uSpotLightDistanceDecayCos[i].z) {
                vec3 spotLightColor = uSpotLightColor[i] * lightAttenuation * spotEffect;
                vec3 lightDiffuseTerm = vec3(0.0);
                vec3 lightSpecularTerm = vec3(0.0);
                getLightColor(normalize(lVector), v, n, spotLightColor, fresnelTerm, roughness, lightDiffuseTerm, lightSpecularTerm);
                diffuseTerm +=lightDiffuseTerm;
                specularTerm += lightSpecularTerm;
            }
        }
#endif 
    color = baseColor; 
    color *= max(diffuseTerm, vec3(0.0)); 
    color += max(specularTerm, vec3(0.0)); 
        // \u8BA1\u7B97\u73AF\u5883\u5149
    #ifdef USE_IBL_LIGHTING
        vec3 r = normalize(czm_inverseViewRotation * normalize(reflect(v, n)));
        // Figure out if the reflection vector hits the ellipsoid
        float vertexRadius = length(positionWC);
        float horizonDotNadir = 1.0 - min(1.0, 6378137.0 / vertexRadius);
        float reflectionDotNadir = dot(r, normalize(positionWC));
        // Flipping the X vector is a cheap way to get the inverse of czm_temeToPseudoFixed, since that's a rotation about Z.
        r.x = -r.x;
        r = -normalize(czm_temeToPseudoFixed * r);
        r.x = -r.x;
        float inverseRoughness = 1.04 - roughness;
        inverseRoughness *= inverseRoughness;
        vec3 sceneSkyBox = textureCube(czm_environmentMap, r).rgb * inverseRoughness;
        float atmosphereHeight = 0.05;
        float blendRegionSize = 0.1 * ((1.0 - inverseRoughness) * 8.0 + 1.1 - horizonDotNadir);
        float blendRegionOffset = roughness * -1.0;
        float farAboveHorizon = clamp(horizonDotNadir - blendRegionSize * 0.5 + blendRegionOffset, 1.0e-10 - blendRegionSize, 0.99999);
        float aroundHorizon = clamp(horizonDotNadir + blendRegionSize * 0.5, 1.0e-10 - blendRegionSize, 0.99999);
        float farBelowHorizon = clamp(horizonDotNadir + blendRegionSize * 1.5, 1.0e-10 - blendRegionSize, 0.99999);
        float smoothstepHeight = smoothstep(0.0, atmosphereHeight, horizonDotNadir);
        vec3 belowHorizonColor = mix(vec3(0.1, 0.15, 0.25), vec3(0.4, 0.7, 0.9), smoothstepHeight);
        vec3 nadirColor = belowHorizonColor * 0.5;
        vec3 aboveHorizonColor = mix(vec3(0.9, 1.0, 1.2), belowHorizonColor, roughness * 0.5);
        vec3 blueSkyColor = mix(vec3(0.18, 0.26, 0.48), aboveHorizonColor, reflectionDotNadir * inverseRoughness * 0.5 + 0.75);
        vec3 zenithColor = mix(blueSkyColor, sceneSkyBox, smoothstepHeight);

        vec3 blueSkyDiffuseColor = vec3(0.7, 0.85, 0.9);
        float diffuseIrradianceFromEarth = (1.0 - horizonDotNadir) * (reflectionDotNadir * 0.25 + 0.75) * smoothstepHeight;
        float diffuseIrradianceFromSky = (1.0 - smoothstepHeight) * (1.0 - (reflectionDotNadir * 0.25 + 0.25));
        vec3 diffuseIrradiance = blueSkyDiffuseColor * clamp(diffuseIrradianceFromEarth + diffuseIrradianceFromSky, 0.0, 1.0);

        float notDistantRough = (1.0 - horizonDotNadir * roughness * 0.8);
        vec3 specularIrradiance = mix(zenithColor, aboveHorizonColor, smoothstep(farAboveHorizon, aroundHorizon, reflectionDotNadir) * notDistantRough);
        specularIrradiance = mix(specularIrradiance, belowHorizonColor, smoothstep(aroundHorizon, farBelowHorizon, reflectionDotNadir) * inverseRoughness);
        specularIrradiance = mix(specularIrradiance, nadirColor, smoothstep(farBelowHorizon, 1.0, reflectionDotNadir) * inverseRoughness);

        vec2 iblFactor = vec2(1.0);
        float luminanceAtZenith = 0.5;
    #ifdef USE_SUN_LUMINANCE
        // Angle between sun and zenith
        float LdotZenith = clamp(dot(normalize(czm_inverseViewRotation * czm_sunDirectionEC), normalize(positionWC * -1.0)), 0.001, 1.0);
        float S = acos(LdotZenith);
        // Angle between zenith and current pixel
        float NdotZenith = clamp(dot(normalize(czm_inverseViewRotation * n), normalize(positionWC * -1.0)), 0.001, 1.0);
        // Angle between sun and current pixel
        float sunNdotL = clamp(dot(n, czm_sunDirectionEC), 0.001, 1.0);
        float gamma = acos(sunNdotL);
        float numerator = ((0.91 + 10.0 * exp(-3.0 * gamma) + 0.45 * pow(sunNdotL, 2.0)) * (1.0 - exp(-0.32 / NdotZenith)));
        float denominator = (0.91 + 10.0 * exp(-3.0 * S) + 0.45 * pow(LdotZenith,2.0)) * (1.0 - exp(-0.32));
        float luminance = luminanceAtZenith * (numerator / denominator);
#endif

        vec2 brdfLut = texture2D(czm_brdfLut, vec2(NdotV, 1.0 - roughness)).rg;
        vec3 IBLColor = (diffuseIrradiance * diffuseColor * iblFactor.x) + (specularIrradiance * SRGBtoLINEAR3(specularColor * brdfLut.x + brdfLut.y) * iblFactor.y);
#ifdef USE_SUN_LUMINANCE
        color += IBLColor * luminance;
#else
        color += IBLColor;
#endif // end of USE_SUN_LUMINANCE
#endif // end of USE_IBL_LIGHTING

#ifdef HAS_OCCLUSION_TEXTURE
        color *= texture2D(u_occlusionTexture, texCoord).r;
#endif

#ifdef HAS_EMISSIVE_TEXTURE
        vec2 emissiveTexCoord = texCoord;
        emissiveTexCoord = emissiveTexCoord * u_emissiveUVOffsetAndTiling.zw + u_emissiveUVOffsetAndTiling.xy;
        vec3 emissive = SRGBtoLINEAR3(texture2D(u_emissiveTexture, emissiveTexCoord).rgb);
        emissive *= u_emissiveFactor.rgb;
        color += emissive;
#else
        color += u_emissiveFactor.rgb;
#endif
        color = LINEARtoSRGB(color);
        vec4 resultColor = vec4(color, 1.0);
#ifdef MASK
        if (baseColorWithAlpha.a < u_alphaCutoff)
        {
            discard;
        }
        resultColor = vec4(color, 1.0);
#endif
#ifdef BLEND
        resultColor = vec4(color, baseColorWithAlpha.a);
#endif
        return resultColor;
    }`});var $He,e8e=Ee(()=>{$He=`uniform float uParentMixDirection;
uniform vec4 u_pickIDColor;
vec4 czm_sampleAndBlend(
    vec4 previousColor,
    sampler2D textureToSample,
    vec2 tileTextureCoordinates,
    vec4 textureCoordinateRectangle,
    vec4 textureCoordinateTranslationAndScale,
    vec4 transparentBackColor,
    bool imageryClipEnable,
    int rasterValue,
    bool flipY,
    float textureAlpha,
    float textureBrightness,
    float textureContrast,
    float textureHue,
    float textureSaturation,
    float textureOneOverGamma,
    vec2 split,
    vec4 swipe,
    float textureMinAlpha)
{
    // This crazy step stuff sets the alpha to 0.0 if this following condition is true:
    //    tileTextureCoordinates.s < textureCoordinateRectangle.s ||
    //    tileTextureCoordinates.s > textureCoordinateRectangle.p ||
    //    tileTextureCoordinates.t < textureCoordinateRectangle.t ||
    //    tileTextureCoordinates.t > textureCoordinateRectangle.q
    // In other words, the alpha is zero if the fragment is outside the rectangle
    // covered by this texture.  Would an actual 'if' yield better performance?
    vec2 alphaMultiplier = step(textureCoordinateRectangle.st, tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    alphaMultiplier = step(vec2(0.0), textureCoordinateRectangle.pq - tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    vec2 translation = textureCoordinateTranslationAndScale.xy;
    vec2 scale = textureCoordinateTranslationAndScale.zw;
    vec2 textureCoordinates = tileTextureCoordinates * scale + translation;
    if(flipY)
    {
        textureCoordinates.y = 1.0 - textureCoordinates.y;
    }
    vec4 value = texture2D(textureToSample, textureCoordinates);
    vec3 color = value.rgb;
    float alpha = value.a;
    if(transparentBackColor.a > 0.01)
    {
        float rDiff = abs(transparentBackColor.r - color.r);
        float gDiff = abs(transparentBackColor.g - color.g);
        float bDiff = abs(transparentBackColor.b - color.b);
        if(rDiff < transparentBackColor.a && gDiff < transparentBackColor.a && bDiff < transparentBackColor.a)
        {
            alpha = 0.0;
        }
    }

    if(imageryClipEnable)
    {
    #ifdef Apply_ImageryClip
        if((rasterValue & RASTER_CLIP_IMAGERY) < 1)
        {
            alpha = 0.0;
        }
    #else
        alpha = 0.0;
    #endif
    }


#if !defined(APPLY_GAMMA)
    vec4 tempColor = czm_gammaCorrect(vec4(color, alpha));
    color = tempColor.rgb;
    alpha = tempColor.a;
#else
    color = pow(color, vec3(textureOneOverGamma));
#endif

#ifdef APPLY_SPLIT
    vec2 splitPosition = czm_imagerySplitPosition;
    // Split to the left
    if (split.x < 0.0 && gl_FragCoord.x > splitPosition.x) {
       alpha = 0.0;
    }
    // Split to the right
    else if (split.x > 0.0 && gl_FragCoord.x < splitPosition.x) {
       alpha = 0.0;
    }
    if(split.y < 0.0 && gl_FragCoord.y > splitPosition.y) {
        alpha = 0.0;
    }
    else if(split.y > 0.0 && gl_FragCoord.y < splitPosition.y) {
        alpha = 0.0;
    }
#if TEXTURE_UNITS < 2
    if(alpha == 0.0)
    {
        discard;
    }
#endif
#endif

#ifdef APPLY_SWIPE
    if (gl_FragCoord.x < swipe.x || gl_FragCoord.y > swipe.y) {
       alpha = 0.0;
    }
    else if (gl_FragCoord.x > swipe.z || gl_FragCoord.y < swipe.w) {
       alpha = 0.0;
    }
#if TEXTURE_UNITS < 2
    if(alpha == 0.0)
    {
        discard;
    }
#endif

#endif

#ifdef APPLY_BRIGHTNESS
    color = mix(vec3(0.0), color, textureBrightness);
#endif

#ifdef APPLY_CONTRAST
    color = mix(vec3(0.5), color, textureContrast);
#endif

#ifdef APPLY_HUE
    color = czm_hue(color, textureHue);
#endif

#ifdef APPLY_SATURATION
    color = czm_saturation(color, textureSaturation);
#endif

#ifdef ALPHAFILTER
    if(alpha <= textureMinAlpha)
    {
        return previousColor.rgba;
    }
#endif

    float sourceAlpha = alpha * textureAlpha;
    float outAlpha = mix(previousColor.a, 1.0, sourceAlpha);
    if(outAlpha < 0.1){
        return vec4(0.0);
    }
    vec3 outColor = mix(previousColor.rgb * previousColor.a, color, sourceAlpha) / outAlpha;
    return vec4(outColor, outAlpha);
}

vec4 sampleAndBlendParent(
    vec4 previousColor,
    sampler2D textureToSample,
    vec2 tileTextureCoordinates,
    vec4 textureCoordinateRectangle,
    vec4 textureCoordinateTranslationAndScale,
    vec4 transparentBackColor,
    bool flipY,
    float textureAlpha,
    float textureBrightness,
    float textureContrast,
    float textureHue,
    float textureSaturation,
    float textureOneOverGamma,
    vec2 split,
    vec4 swipe,
    float textureMinAlpha)
{
    // This crazy step stuff sets the alpha to 0.0 if this following condition is true:
    //    tileTextureCoordinates.s < textureCoordinateRectangle.s ||
    //    tileTextureCoordinates.s > textureCoordinateRectangle.p ||
    //    tileTextureCoordinates.t < textureCoordinateRectangle.t ||
    //    tileTextureCoordinates.t > textureCoordinateRectangle.q
    // In other words, the alpha is zero if the fragment is outside the rectangle
    // covered by this texture.  Would an actual 'if' yield better performance?
    vec2 alphaMultiplier = step(textureCoordinateRectangle.st, tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    alphaMultiplier = step(vec2(0.0), textureCoordinateRectangle.pq - tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    vec2 translation = textureCoordinateTranslationAndScale.xy;
    vec2 scale = textureCoordinateTranslationAndScale.zw;
    vec2 textureCoordinates = tileTextureCoordinates * scale + translation;
    if(flipY)
    {
        textureCoordinates.y = 1.0 - textureCoordinates.y;
    }
    vec4 value = texture2D(textureToSample, textureCoordinates);
	if(uParentMixDirection > 0.0 && value.a > 0.01)
	{
		value.a = 0.0;
		bool blend = false;
		float mixDirection = uParentMixDirection;
		if( mixDirection > 7.0 )
		{
		    //\u5357
			if(tileTextureCoordinates.y <0.3)
			{
				blend = true;
			}
			mixDirection-=8.0;
		}
		else if( mixDirection > 3.0)
		{
		    //\u5317
			if(tileTextureCoordinates.y >0.7)
			{
				blend = true;
			}
			mixDirection-=4.0;
		}
		if(blend)
		{
			//\u7EB9\u7406\u5750\u68070-0.5\uFF0C\u4E2D\u5FC3\u662F0\u8FB9\u7F18\u662F0.5
			float mixY = abs(tileTextureCoordinates.y-0.5);
			//mixValue0-5\uFF0C\u4E2D\u5FC3\u662F0\u8FB9\u7F18\u662F5
			float mixValue = 10.0*mixY;
			//mixValue0-1\uFF0C\u4E2D\u5FC3\u662F0\u8FB9\u7F183/5\u5904\u5F00\u59CB0-1\u6E10\u53D8
			//mixValue = clamp(0.5*(mixValue - 3.0), 0.0, 1.0);
			mixValue = clamp((mixValue - 4.0), 0.0, 1.0);
			value.a = mixValue;
		}
		blend = false;
		if( mixDirection > 1.5)
		{
		    //\u4E1C
			if(tileTextureCoordinates.x >0.7)
			{
				blend = true;
			}
			mixDirection-=2.0;
		}
		else if( mixDirection > 0.5)
		{
		    //\u897F
			if(tileTextureCoordinates.x <0.3)
			{
				blend = true;
			}
		}
		if(blend)
		{
			float mixValue = 10.0*abs(tileTextureCoordinates.x-0.5);
			mixValue = clamp((mixValue - 4.0), 0.0, 1.0);
			value.a = max(mixValue, value.a);
		}
	}
    vec3 color = value.rgb;
    float alpha = value.a;
    if(transparentBackColor.a > 0.01)
    {
        float rDiff = abs(transparentBackColor.r - color.r);
        float gDiff = abs(transparentBackColor.g - color.g);
        float bDiff = abs(transparentBackColor.b - color.b);
        if(rDiff < transparentBackColor.a && gDiff < transparentBackColor.a && bDiff < transparentBackColor.a)
        {
            alpha = 0.0;
        }
    }
#if !defined(APPLY_GAMMA)
    vec4 tempColor = czm_gammaCorrect(vec4(color, alpha));
    color = tempColor.rgb;
    alpha = tempColor.a;
#else
    color = pow(color, vec3(textureOneOverGamma));
#endif
#ifdef APPLY_SPLIT
    vec2 splitPosition = czm_imagerySplitPosition;
    // Split to the left
    if (split.x < 0.0 && gl_FragCoord.x > splitPosition.x) {
       alpha = 0.0;
    }
    // Split to the right
    else if (split.x > 0.0 && gl_FragCoord.x < splitPosition.x) {
       alpha = 0.0;
    }
    if(split.y < 0.0 && gl_FragCoord.y > splitPosition.y) {
        alpha = 0.0;
    }
    else if(split.y > 0.0 && gl_FragCoord.y < splitPosition.y) {
        alpha = 0.0;
    }
#if TEXTURE_UNITS < 2
    if(alpha == 0.0)
    {
        discard;
    }
#endif
#endif
#ifdef APPLY_SWIPE
    if (gl_FragCoord.x < swipe.x || gl_FragCoord.y > swipe.y) {
       alpha = 0.0;
    }
    else if (gl_FragCoord.x > swipe.z || gl_FragCoord.y < swipe.w) {
       alpha = 0.0;
    }
#if TEXTURE_UNITS < 2
    if(alpha == 0.0)
    {
        discard;
    }
#endif
#endif
#ifdef APPLY_BRIGHTNESS
    color = mix(vec3(0.0), color, textureBrightness);
#endif
#ifdef APPLY_CONTRAST
    color = mix(vec3(0.5), color, textureContrast);
#endif
#ifdef APPLY_HUE
    color = czm_hue(color, textureHue);
#endif
#ifdef APPLY_SATURATION
    color = czm_saturation(color, textureSaturation);
#endif
#ifdef ALPHAFILTER
    if(alpha <= textureMinAlpha)
    {
        return previousColor.rgba;
    }
#endif
    float sourceAlpha = alpha * textureAlpha;
    float outAlpha = mix(previousColor.a, 1.0, sourceAlpha);
    vec3 outColor = mix(previousColor.rgb * previousColor.a, color, sourceAlpha) / outAlpha;
    return vec4(outColor, outAlpha);
}

vec4 mvtTextureSampleAndBlend(
    vec4 previousColor,
    sampler2D textureToSample,
    sampler2D idTextureToSample,
    vec2 tileTextureCoordinates,
    vec4 textureCoordinateRectangle,
    vec4 textureCoordinateTranslationAndScale,
    vec4 selectColor,
    float textureAlpha,
    float textureOneOverGamma,
    vec4 swipe)
{
#ifdef APPLY_SWIPE
    vec2 f = step(swipe.xw, vec2(gl_FragCoord.xy));
    vec2 s = step(vec2(gl_FragCoord.xy), swipe.zy);
    if (f.x * f.y * s.x * s.y < 1.0) {
        return previousColor;
    };
#endif
    vec2 alphaMultiplier = step(textureCoordinateRectangle.st, tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    alphaMultiplier = step(vec2(0.0), textureCoordinateRectangle.pq - tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;

    vec2 translation = textureCoordinateTranslationAndScale.xy;
    vec2 scale = textureCoordinateTranslationAndScale.zw;
    vec2 textureCoordinates = tileTextureCoordinates * scale + translation;
    vec4 value = texture2D(textureToSample, textureCoordinates);
    vec4 idColor = texture2D(idTextureToSample, textureCoordinates);
    if(idColor.r == u_pickIDColor.r && idColor.g == u_pickIDColor.g && idColor.b == u_pickIDColor.b){
        value.rgb = selectColor.rgb;
    }
    vec3 color = value.rgb;
    float alpha = value.a;
#if !defined(APPLY_GAMMA)
    vec4 tempColor = czm_gammaCorrect(vec4(color, alpha));
    color = tempColor.rgb;
    alpha = tempColor.a;
#else
    color = pow(color, vec3(textureOneOverGamma));
#endif
    float sourceAlpha = alpha * textureAlpha;
    float outAlpha = mix(previousColor.a, 1.0, sourceAlpha);
    vec3 outColor = mix(previousColor.rgb * previousColor.a, color, sourceAlpha) / outAlpha;
    return vec4(outColor, outAlpha);
}

vec4 gridTextureSampleAndBlend(
    vec4 previousColor,
    sampler2D textureToSample,
    vec2 tileTextureCoordinates,
    vec4 textureCoordinateRectangle,
    vec4 textureCoordinateTranslationAndScale)
{
    float textureAlpha = 1.0;
    vec2 alphaMultiplier = step(textureCoordinateRectangle.st, tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;
    alphaMultiplier = step(vec2(0.0), textureCoordinateRectangle.pq - tileTextureCoordinates);
    textureAlpha = textureAlpha * alphaMultiplier.x * alphaMultiplier.y;
    vec2 translation = textureCoordinateTranslationAndScale.xy;
    vec2 scale = textureCoordinateTranslationAndScale.zw;
    vec2 textureCoordinates = tileTextureCoordinates * scale + translation;
    vec4 value = texture2D(textureToSample, textureCoordinates);
    vec3 color = value.rgb;
    float alpha = value.a;
    float sourceAlpha = alpha * textureAlpha;
    float outAlpha = mix(previousColor.a, 1.0, sourceAlpha);
    vec3 outColor = mix(previousColor.rgb * previousColor.a, color, sourceAlpha) / outAlpha;
    return vec4(outColor, outAlpha);
}`});var t8e,r8e=Ee(()=>{t8e=`/**
 * Samples the 4 neighboring pixels and return the weighted average.
 *
 * @private
 */
vec3 czm_sampleOctahedralProjectionWithFiltering(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod)
{
    direction /= dot(vec3(1.0), abs(direction));
    vec2 rev = abs(direction.zx) - vec2(1.0);
    vec2 neg = vec2(direction.x < 0.0 ? rev.x : -rev.x,
                    direction.z < 0.0 ? rev.y : -rev.y);
    vec2 uv = direction.y < 0.0 ? neg : direction.xz;
    vec2 coord = 0.5 * uv + vec2(0.5);
    vec2 pixel = 1.0 / textureSize;

    if (lod > 0.0)
    {
        // Each subseqeuent mip level is half the size
        float scale = 1.0 / pow(2.0, lod);
        float offset = ((textureSize.y + 1.0) / textureSize.x);

        coord.x *= offset;
        coord *= scale;

        coord.x += offset + pixel.x;
        coord.y += (1.0 - (1.0 / pow(2.0, lod - 1.0))) + pixel.y * (lod - 1.0) * 2.0;
    }
    else
    {
        coord.x *= (textureSize.y / textureSize.x);
    }

    // Do bilinear filtering
    #ifndef OES_texture_float_linear
        vec3 color1 = texture2D(projectedMap, coord + vec2(0.0, pixel.y)).rgb;
        vec3 color2 = texture2D(projectedMap, coord + vec2(pixel.x, 0.0)).rgb;
        vec3 color3 = texture2D(projectedMap, coord + pixel).rgb;
        vec3 color4 = texture2D(projectedMap, coord).rgb;

        vec2 texturePosition = coord * textureSize;

        float fu = fract(texturePosition.x);
        float fv = fract(texturePosition.y);

        vec3 average1 = mix(color4, color2, fu);
        vec3 average2 = mix(color1, color3, fu);

        vec3 color = mix(average1, average2, fv);
    #else
        vec3 color = texture2D(projectedMap, coord).rgb;
    #endif

    return color;
}


/**
 * Samples from a cube map that has been projected using an octahedral projection from the given direction.
 *
 * @name czm_sampleOctahedralProjection
 * @glslFunction
 *
 * @param {sampler2D} projectedMap The texture with the octahedral projected cube map.
 * @param {vec2} textureSize The width and height dimensions in pixels of the projected map.
 * @param {vec3} direction The normalized direction used to sample the cube map.
 * @param {float} lod The level of detail to sample.
 * @param {float} maxLod The maximum level of detail.
 * @returns {vec3} The color of the cube map at the direction.
 */
vec3 czm_sampleOctahedralProjection(sampler2D projectedMap, vec2 textureSize, vec3 direction, float lod, float maxLod) {
    float currentLod = floor(lod + 0.5);
    float nextLod = min(currentLod + 1.0, maxLod);

    vec3 colorCurrentLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, currentLod);
    vec3 colorNextLod = czm_sampleOctahedralProjectionWithFiltering(projectedMap, textureSize, direction, nextLod);

    return mix(colorNextLod, colorCurrentLod, nextLod - lod);
}
`});var i8e,n8e=Ee(()=>{i8e=`/**
 * Adjusts the saturation of a color.
 * 
 * @name czm_saturation
 * @glslFunction
 * 
 * @param {vec3} rgb The color.
 * @param {float} adjustment The amount to adjust the saturation of the color.
 *
 * @returns {float} The color with the saturation adjusted.
 *
 * @example
 * vec3 greyScale = czm_saturation(color, 0.0);
 * vec3 doubleSaturation = czm_saturation(color, 2.0);
 */
vec3 czm_saturation(vec3 rgb, float adjustment)
{
    // Algorithm from Chapter 16 of OpenGL Shading Language
    const vec3 W = vec3(0.2125, 0.7154, 0.0721);
    vec3 intensity = vec3(dot(rgb, W));
    return mix(intensity, rgb, adjustment);
}
`});var o8e,a8e=Ee(()=>{o8e=`
float czm_sampleShadowMap(samplerCube shadowMap, vec3 d)
{
    return czm_unpackDepth(textureCube(shadowMap, d));
}

float czm_sampleShadowMap(sampler2D shadowMap, vec2 uv)
{
#ifdef USE_SHADOW_DEPTH_TEXTURE
    return texture2D(shadowMap, uv).r;
#else
    return czm_unpackDepth(texture2D(shadowMap, uv));
#endif
}

float czm_shadowDepthCompare(samplerCube shadowMap, vec3 uv, float depth)
{
    return step(depth, czm_sampleShadowMap(shadowMap, uv));
}

float czm_shadowDepthCompare(sampler2D shadowMap, vec2 uv, float depth)
{
    return step(depth, czm_sampleShadowMap(shadowMap, uv));
}
`});var s8e,l8e=Ee(()=>{s8e=`
float czm_private_shadowVisibility(float visibility, float nDotL, float normalShadingSmooth, float darkness)
{
#ifdef USE_NORMAL_SHADING
#ifdef USE_NORMAL_SHADING_SMOOTH
    float strength = clamp(nDotL / normalShadingSmooth, 0.0, 1.0);
#else
    float strength = step(0.0, nDotL);
#endif
    visibility *= strength;
#endif

    visibility = max(visibility, darkness);
    return visibility;
}

#ifdef USE_CUBE_MAP_SHADOW
float czm_shadowVisibility(samplerCube shadowMap, czm_shadowParameters shadowParameters)
{
    float depthBias = shadowParameters.depthBias;
    float depth = shadowParameters.depth;
    float nDotL = shadowParameters.nDotL;
    float normalShadingSmooth = shadowParameters.normalShadingSmooth;
    float darkness = shadowParameters.darkness;
    vec3 uvw = shadowParameters.texCoords;

    depth -= depthBias;
    float visibility = czm_shadowDepthCompare(shadowMap, uvw, depth);
    return czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);
}
#else
float czm_shadowVisibility(sampler2D shadowMap, czm_shadowParameters shadowParameters)
{
    float depthBias = shadowParameters.depthBias;
    float depth = shadowParameters.depth;
    float nDotL = shadowParameters.nDotL;
    float normalShadingSmooth = shadowParameters.normalShadingSmooth;
    float darkness = shadowParameters.darkness;
    vec2 uv = shadowParameters.texCoords;

    depth -= depthBias;
#ifdef USE_SOFT_SHADOWS
    vec2 texelStepSize = shadowParameters.texelStepSize;
    float radius = 1.0;
    float dx0 = -texelStepSize.x * radius;
    float dy0 = -texelStepSize.y * radius;
    float dx1 = texelStepSize.x * radius;
    float dy1 = texelStepSize.y * radius;
    float visibility = (
        czm_shadowDepthCompare(shadowMap, uv, depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, 0.0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, 0.0), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx0, dy1), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(0.0, dy1), depth) +
        czm_shadowDepthCompare(shadowMap, uv + vec2(dx1, dy1), depth)
    ) * (1.0 / 9.0);
#else
    float visibility = czm_shadowDepthCompare(shadowMap, uv, depth);
#endif

    return czm_private_shadowVisibility(visibility, nDotL, normalShadingSmooth, darkness);
}
#endif
`});var u8e,c8e=Ee(()=>{u8e=`/**
 * Returns 1.0 if the given value is positive or zero, and -1.0 if it is negative.  This is similar to the GLSL
 * built-in function <code>sign</code> except that returns 1.0 instead of 0.0 when the input value is 0.0.
 * 
 * @name czm_signNotZero
 * @glslFunction
 *
 * @param {} value The value for which to determine the sign.
 * @returns {} 1.0 if the value is positive or zero, -1.0 if the value is negative.
 */
float czm_signNotZero(float value)
{
    return value >= 0.0 ? 1.0 : -1.0;
}

vec2 czm_signNotZero(vec2 value)
{
    return vec2(czm_signNotZero(value.x), czm_signNotZero(value.y));
}

vec3 czm_signNotZero(vec3 value)
{
    return vec3(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z));
}

vec4 czm_signNotZero(vec4 value)
{
    return vec4(czm_signNotZero(value.x), czm_signNotZero(value.y), czm_signNotZero(value.z), czm_signNotZero(value.w));
}
`});var f8e,x8e=Ee(()=>{f8e=`uniform sampler2D uNormalDepthTexture;
uniform int uFillStyle;
float edgeDetection(float lineWidth)
{
    vec2 center = gl_FragCoord.xy / czm_globeDepthTextureDim.xy;
    vec2 off = lineWidth / czm_globeDepthTextureDim.xy;
    vec4 tex_nw = vec4(center.x+off.x, center.y+off.y, 1.0, 1.0);
    vec4 val_nw = texture2D(uNormalDepthTexture, tex_nw.xy);
    val_nw.xyz = (val_nw.xyz * 2.0) - 1.0;
    vec4 tex_ne = vec4(center.x-off.x, center.y+off.y, 1.0, 1.0);
    vec4 val_ne =  texture2D(uNormalDepthTexture, tex_ne.xy);
    val_ne.xyz = (val_ne.xyz * 2.0) - 1.0;
    vec4 tex_sw = vec4(center.x+off.x, center.y-off.y, 1.0, 1.0);
    vec4 val_sw = texture2D(uNormalDepthTexture, tex_sw.xy);
    val_sw.xyz = (val_sw.xyz * 2.0 ) - 1.0;
    vec4 tex_se = vec4(center.x-off.x, center.y-off.y, 1.0, 1.0);
    vec4 val_se = texture2D(uNormalDepthTexture, tex_se.xy);
    val_se.xyz = (val_se.xyz * 2.0) - 1.0;
    float discontinuity = 0.0;
    float dot0 = dot(val_nw.xyz, val_se.xyz);
    float dot1 = dot(val_ne.xyz, val_sw.xyz);
    discontinuity = 0.5*(dot0+dot1);
    return discontinuity;
}
vec4 czm_sketchMode(vec4 inputColor, vec4 lineColor, float lineWidth)
{
    vec4 outputColor = inputColor;
    float discontinuity = edgeDetection(lineWidth);
    discontinuity = clamp(discontinuity, 0.0, 1.0);
    if(uFillStyle == 1)
    {
        outputColor = lineColor;
        outputColor.a = (1.0 - sign(discontinuity - 0.5)) * 0.5;
        outputColor.a *= lineColor.a;
    }
    else
    {
        vec3 mixLineColor = mix(inputColor.rgb, vec3(lineColor.rgb), lineColor.a);
        outputColor.rgb = mix(mixLineColor, inputColor.rgb, discontinuity);
    }
    return outputColor;
}`});var h8e,d8e=Ee(()=>{h8e=`/**
 * Computes a color from the third order spherical harmonic coefficients and a normalized direction vector.
 * <p>
 * The order of the coefficients is [L00, L1_1, L10, L11, L2_2, L2_1, L20, L21, L22].
 * </p>
 *
 * @name czm_sphericalHarmonics
 * @glslFunction
 *
 * @param {vec3} normal The normalized direction.
 * @param {vec3[9]} coefficients The third order spherical harmonic coefficients.
 * @returns {vec3} The color at the direction.
 *
 */
vec3 czm_sphericalHarmonics(vec3 normal, vec3 coefficients[9])
{
    const float c1 = 0.429043;
    const float c2 = 0.511664;
    const float c3 = 0.743125;
    const float c4 = 0.886227;
    const float c5 = 0.247708;

    vec3 L00 = coefficients[0];
    vec3 L1_1 = coefficients[1];
    vec3 L10 = coefficients[2];
    vec3 L11 = coefficients[3];
    vec3 L2_2 = coefficients[4];
    vec3 L2_1 = coefficients[5];
    vec3 L20 = coefficients[6];
    vec3 L21 = coefficients[7];
    vec3 L22 = coefficients[8];

    float x = normal.x;
    float y = normal.y;
    float z = normal.z;

    return c1 * L22 * (x * x - y * y) + c3 * L20 * z * z + c4 * L00 - c5 * L20 +
           2.0 * c1 * (L2_2 * x * y + L21 * x * z + L2_1 * y * z) +
           2.0 * c2 * (L11 * x + L1_1 * y + L10 * z);
}
`});var m8e,p8e=Ee(()=>{m8e=`/**
 * Creates a matrix that transforms vectors from tangent space to eye space.
 *
 * @name czm_tangentToEyeSpaceMatrix
 * @glslFunction
 *
 * @param {vec3} normalEC The normal vector in eye coordinates.
 * @param {vec3} tangentEC The tangent vector in eye coordinates.
 * @param {vec3} bitangentEC The bitangent vector in eye coordinates.
 *
 * @returns {mat3} The matrix that transforms from tangent space to eye space.
 *
 * @example
 * mat3 tangentToEye = czm_tangentToEyeSpaceMatrix(normalEC, tangentEC, bitangentEC);
 * vec3 normal = tangentToEye * texture2D(normalMap, st).xyz;
 */
mat3 czm_tangentToEyeSpaceMatrix(vec3 normalEC, vec3 tangentEC, vec3 bitangentEC)
{
    vec3 normal = normalize(normalEC);
    vec3 tangent = normalize(tangentEC);
    vec3 bitangent = normalize(bitangentEC);
    return mat3(tangent.x  , tangent.y  , tangent.z,
                bitangent.x, bitangent.y, bitangent.z,
                normal.x   , normal.y   , normal.z);
}
`});var v8e,g8e=Ee(()=>{v8e=`vec4 czm_transformPlane(vec4 clippingPlane, mat4 transform) {
    vec3 transformedDirection = normalize((transform * vec4(clippingPlane.xyz, 0.0)).xyz);
    vec3 transformedPosition = (transform * vec4(clippingPlane.xyz * -clippingPlane.w, 1.0)).xyz;
    vec4 transformedPlane;
    transformedPlane.xyz = transformedDirection;
    transformedPlane.w = -dot(transformedDirection, transformedPosition);
    return transformedPlane;
}
`});var _8e,y8e=Ee(()=>{_8e=`/**
 * Translates a position (or any <code>vec3</code>) that was encoded with {@link EncodedCartesian3},
 * and then provided to the shader as separate <code>high</code> and <code>low</code> bits to
 * be relative to the eye.  As shown in the example, the position can then be transformed in eye
 * or clip coordinates using {@link czm_modelViewRelativeToEye} or {@link czm_modelViewProjectionRelativeToEye},
 * respectively.
 * <p>
 * This technique, called GPU RTE, eliminates jittering artifacts when using large coordinates as
 * described in .
 * </p>
 *
 * @name czm_translateRelativeToEye
 * @glslFunction
 *
 * @param {vec3} high The position's high bits.
 * @param {vec3} low The position's low bits.
 * @returns {vec3} The position translated to be relative to the camera's position.
 *
 * @example
 * attribute vec3 positionHigh;
 * attribute vec3 positionLow;
 *
 * void main()
 * {
 *   vec4 p = czm_translateRelativeToEye(positionHigh, positionLow);
 *   gl_Position = czm_modelViewProjectionRelativeToEye * p;
 * }
 *
 * @see czm_modelViewRelativeToEye
 * @see czm_modelViewProjectionRelativeToEye
 * @see czm_computePosition
 * @see EncodedCartesian3
 */
vec4 czm_translateRelativeToEye(vec3 high, vec3 low)
{
    vec3 highDifference = high - czm_encodedCameraPositionMCHigh;
    // This check handles the case when NaN values have gotten into \`highDifference\`
    // Such a thing could happen on devices running iOS
    if(length(highDifference) == 0.0) {
        highDifference = vec3(0);
    }
    vec3 lowDifference = low - czm_encodedCameraPositionMCLow;

    return vec4(highDifference + lowDifference, 1.0);
}
`});var A8e,C8e=Ee(()=>{A8e=`/**
 * @private
 */
vec4 czm_translucentPhong(vec3 toEye, czm_material material, vec3 lightDirectionEC)
{
    // Diffuse from directional light sources at eye (for top-down and horizon views)
    float diffuse = czm_getLambertDiffuse(vec3(0.0, 0.0, 1.0), material.normal);

    if (czm_sceneMode == czm_sceneMode3D) {
        // (and horizon views in 3D)
        diffuse += czm_getLambertDiffuse(vec3(0.0, 1.0, 0.0), material.normal);
    }

    diffuse = clamp(diffuse, 0.0, 1.0);

    float specular = czm_getSpecular(lightDirectionEC, toEye, material.normal, material.shininess);

    // Temporary workaround for adding ambient.
    vec3 materialDiffuse = material.diffuse * 0.5;

    vec3 ambient = materialDiffuse;
    vec3 color = ambient + material.emission;
    color += materialDiffuse * diffuse * czm_lightColor;
    color += material.specular * specular * czm_lightColor;

    return vec4(color, material.alpha);
}
`});var T8e,w8e=Ee(()=>{T8e=`/**
 * Returns the transpose of the matrix.  The input <code>matrix</code> can be
 * a <code>mat2</code>, <code>mat3</code>, or <code>mat4</code>.
 *
 * @name czm_transpose
 * @glslFunction
 *
 * @param {} matrix The matrix to transpose.
 *
 * @returns {} The transposed matrix.
 *
 * @example
 * // GLSL declarations
 * mat2 czm_transpose(mat2 matrix);
 * mat3 czm_transpose(mat3 matrix);
 * mat4 czm_transpose(mat4 matrix);
 *
 * // Transpose a 3x3 rotation matrix to find its inverse.
 * mat3 eastNorthUpToEye = czm_eastNorthUpToEyeCoordinates(
 *     positionMC, normalEC);
 * mat3 eyeToEastNorthUp = czm_transpose(eastNorthUpToEye);
 */
mat2 czm_transpose(mat2 matrix)
{
    return mat2(
        matrix[0][0], matrix[1][0],
        matrix[0][1], matrix[1][1]);
}

mat3 czm_transpose(mat3 matrix)
{
    return mat3(
        matrix[0][0], matrix[1][0], matrix[2][0],
        matrix[0][1], matrix[1][1], matrix[2][1],
        matrix[0][2], matrix[1][2], matrix[2][2]);
}

mat4 czm_transpose(mat4 matrix)
{
    return mat4(
        matrix[0][0], matrix[1][0], matrix[2][0], matrix[3][0],
        matrix[0][1], matrix[1][1], matrix[2][1], matrix[3][1],
        matrix[0][2], matrix[1][2], matrix[2][2], matrix[3][2],
        matrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]);
}
`});var E8e,b8e=Ee(()=>{E8e=`/**
 * Unpacks a vec4 depth value to a float in [0, 1) range.
 *
 * @name czm_unpackDepth
 * @glslFunction
 *
 * @param {vec4} packedDepth The packed depth.
 *
 * @returns {float} The floating-point depth in [0, 1) range.
 */
 float czm_unpackDepth(vec4 packedDepth)
 {
    // See Aras Pranckevi\u010Dius' post Encoding Floats to RGBA
    return dot(packedDepth, vec4(1.0, 1.0 / 255.0, 1.0 / 65025.0, 1.0 / 16581375.0));
 }
`});var S8e,I8e=Ee(()=>{S8e=`#define SHIFT_RIGHT_8 0.00390625 //1.0 / 256.0
#define SHIFT_RIGHT_16 0.00001525878 //1.0 / 65536.0
#define SHIFT_RIGHT_24 5.960464477539063e-8//1.0 / 16777216.0

#define BIAS 38.0

/**
 * Unpacks a vec4 value containing values expressable as uint8 to an arbitrary float.
 *
 * @name czm_unpackFloat
 * @glslFunction
 *
 * @param {vec4} packedFloat The packed float.
 *
 * @returns {float} The floating-point depth in arbitrary range.
 */
 float czm_unpackFloat(vec4 packedFloat)
{
    packedFloat *= 255.0;
    float temp = packedFloat.w / 2.0;
    float exponent = floor(temp);
    float sign = (temp - exponent) * 2.0;
    exponent = exponent - float(BIAS);
    sign = sign * 2.0 - 1.0;
    sign = -sign;
    float unpacked = sign * packedFloat.x * float(SHIFT_RIGHT_8);
    unpacked += sign * packedFloat.y * float(SHIFT_RIGHT_16);
    unpacked += sign * packedFloat.z * float(SHIFT_RIGHT_24);
    return unpacked * pow(10.0, exponent);
}
`});var P8e,D8e=Ee(()=>{P8e=`/**
 * Unpacks a vec4 value to a float.
 *
 * @name czm_unpackValue
 * @glslFunction
 *
 * @param {vec3} packedValue The packed value.
 *
 * @returns {float} The floating-point value.
 */
 float czm_unpackValue(vec4 packedValue)
 {
    float SHIFT_LEFT16 = 65536.0;
	float SHIFT_LEFT8 = 256.0;
	vec4 value = packedValue * 255.0;
	return value.r * SHIFT_LEFT16 + value.g * SHIFT_LEFT8 + value.b - 9000.0;
 }
`});var M8e,B8e=Ee(()=>{M8e=`#ifdef LOG_DEPTH
// 1.0 at the near plane, increasing linearly from there.
varying float v_depthFromNearPlusOne;
#ifdef SHADOW_MAP
varying vec3 v_logPositionEC;
#endif
#endif

vec4 czm_updatePositionDepth(vec4 coords) {
#if defined(LOG_DEPTH)

#ifdef SHADOW_MAP
    vec3 logPositionEC = (czm_inverseProjection * coords).xyz;
    v_logPositionEC = logPositionEC;
#endif

    // With the very high far/near ratios used with the logarithmic depth
    // buffer, floating point rounding errors can cause linear depth values
    // to end up on the wrong side of the far plane, even for vertices that
    // are really nowhere near it. Since we always write a correct logarithmic
    // depth value in the fragment shader anyway, we just need to make sure
    // such errors don't cause the primitive to be clipped entirely before
    // we even get to the fragment shader.
    coords.z = clamp(coords.z / coords.w, -1.0, 1.0) * coords.w;
#endif

    return coords;
}

/**
 * Writes the logarithmic depth to gl_Position using the already computed gl_Position.
 *
 * @name czm_vertexLogDepth
 * @glslFunction
 */
void czm_vertexLogDepth()
{
#ifdef LOG_DEPTH
    v_depthFromNearPlusOne = 1.0 - czm_currentFrustum.x + gl_Position.w;
    gl_Position = czm_updatePositionDepth(gl_Position);
#endif
}

/**
 * Writes the logarithmic depth to gl_Position using the provided clip coordinates.
 * <p>
 * An example use case for this function would be moving the vertex in window coordinates
 * before converting back to clip coordinates. Use the original vertex clip coordinates.
 * </p>
 * @name czm_vertexLogDepth
 * @glslFunction
 *
 * @param {vec4} clipCoords The vertex in clip coordinates.
 *
 * @example
 * czm_vertexLogDepth(czm_projection * vec4(positionEyeCoordinates, 1.0));
 */
void czm_vertexLogDepth(vec4 clipCoords)
{
#ifdef LOG_DEPTH
    v_depthFromNearPlusOne = 1.0 - czm_currentFrustum.x + clipCoords.w;
    czm_updatePositionDepth(clipCoords);
#endif
}
`});var R8e,L8e=Ee(()=>{R8e=`/**
 * Transforms a position from window to eye coordinates.
 * The transform from window to normalized device coordinates is done using components
 * of (@link czm_viewport} and {@link czm_viewportTransformation} instead of calculating
 * the inverse of <code>czm_viewportTransformation</code>. The transformation from
 * normalized device coordinates to clip coordinates is done using <code>fragmentCoordinate.w</code>,
 * which is expected to be the scalar used in the perspective divide. The transformation
 * from clip to eye coordinates is done using {@link czm_inverseProjection}.
 *
 * @name czm_windowToEyeCoordinates
 * @glslFunction
 *
 * @param {vec4} fragmentCoordinate The position in window coordinates to transform.
 *
 * @returns {vec4} The transformed position in eye coordinates.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_eyeToWindowCoordinates
 * @see czm_inverseProjection
 * @see czm_viewport
 * @see czm_viewportTransformation
 *
 * @example
 * vec4 positionEC = czm_windowToEyeCoordinates(gl_FragCoord);
 */
vec4 czm_windowToEyeCoordinates(vec4 fragmentCoordinate)
{
    // Reconstruct NDC coordinates
    float x = 2.0 * (fragmentCoordinate.x - czm_viewport.x) / czm_viewport.z - 1.0;
    float y = 2.0 * (fragmentCoordinate.y - czm_viewport.y) / czm_viewport.w - 1.0;
    float z = (fragmentCoordinate.z - czm_viewportTransformation[3][2]) / czm_viewportTransformation[2][2];
    vec4 q = vec4(x, y, z, 1.0);

    // Reverse the perspective division to obtain clip coordinates.
    q /= fragmentCoordinate.w;

    // Reverse the projection transformation to obtain eye coordinates.
    if (!(czm_inverseProjection == mat4(0.0))) // IE and Edge sometimes do something weird with != between mat4s
    {
        q = czm_inverseProjection * q;
    }
    else
    {
        float top = czm_frustumPlanes.x;
        float bottom = czm_frustumPlanes.y;
        float left = czm_frustumPlanes.z;
        float right = czm_frustumPlanes.w;

        float near = czm_currentFrustum.x;
        float far = czm_currentFrustum.y;

        q.x = (q.x * (right - left) + left + right) * 0.5;
        q.y = (q.y * (top - bottom) + bottom + top) * 0.5;
        q.z = (q.z * (near - far) - near - far) * 0.5;
        q.w = 1.0;
    }

    return q;
}

/**
 * Transforms a position given as window x/y and a depth or a log depth from window to eye coordinates.
 * This function produces more accurate results for window positions with log depth than
 * conventionally unpacking the log depth using czm_reverseLogDepth and using the standard version
 * of czm_windowToEyeCoordinates.
 *
 * @name czm_windowToEyeCoordinates
 * @glslFunction
 *
 * @param {vec2} fragmentCoordinateXY The XY position in window coordinates to transform.
 * @param {float} depthOrLogDepth A depth or log depth for the fragment.
 *
 * @see czm_modelToWindowCoordinates
 * @see czm_eyeToWindowCoordinates
 * @see czm_inverseProjection
 * @see czm_viewport
 * @see czm_viewportTransformation
 *
 * @returns {vec4} The transformed position in eye coordinates.
 */
vec4 czm_windowToEyeCoordinates(vec2 fragmentCoordinateXY, float depthOrLogDepth)
{
    // See reverseLogDepth.glsl. This is separate to re-use the pow.
#ifdef LOG_DEPTH
    float near = czm_currentFrustum.x;
    float far = czm_currentFrustum.y;
    float log2Depth = depthOrLogDepth * czm_log2FarDepthFromNearPlusOne;
    float depthFromNear = pow(2.0, log2Depth) - 1.0;
    float depthFromCamera = depthFromNear + near;
    vec4 windowCoord = vec4(fragmentCoordinateXY, far * (1.0 - near / depthFromCamera) / (far - near), 1.0);
    vec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);
    eyeCoordinate.w = 1.0 / depthFromCamera; // Better precision
    return eyeCoordinate;
#else
    vec4 windowCoord = vec4(fragmentCoordinateXY, depthOrLogDepth, 1.0);
    vec4 eyeCoordinate = czm_windowToEyeCoordinates(windowCoord);
#endif
    return eyeCoordinate;
}
`});var O8e,F8e=Ee(()=>{O8e=`// emulated noperspective
#if !defined(LOG_DEPTH)
in float v_WindowZ;
#endif

/**
 * Emulates GL_DEPTH_CLAMP. Clamps a fragment to the near and far plane
 * by writing the fragment's depth. See czm_depthClamp for more details.
 *
 * @name czm_writeDepthClamp
 * @glslFunction
 *
 * @example
 * gl_FragColor = color;
 * czm_writeDepthClamp();
 *
 * @see czm_depthClamp
 */
void czm_writeDepthClamp()
{
#if (!defined(LOG_DEPTH) && (__VERSION__ == 300 || defined(GL_EXT_frag_depth)))
    gl_FragDepth = clamp(v_WindowZ * gl_FragCoord.w, 0.0, 1.0);
#endif
}
`});var N8e,z8e=Ee(()=>{N8e=`// emulated noperspective
#ifndef LOG_DEPTH
varying float v_WindowZ;
#endif
/**
 * Clamps a vertex to the far plane by writing the fragments depth.
 * <p>
 * The shader must enable the GL_EXT_frag_depth extension.
 * </p>
 *
 * @name czm_writeDepthClampedToFarPlane
 * @glslFunction
 *
 * @example
 * gl_FragColor = color;
 * czm_writeDepthClampedToFarPlane();
 *
 * @see czm_depthClampFarPlane
 */
void czm_writeDepthClampedToFarPlane()
{
#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)
    gl_FragDepthEXT = min(v_WindowZ * gl_FragCoord.w, 1.0);
#endif
}
`});var V8e,k8e=Ee(()=>{V8e=`#ifdef LOG_DEPTH
varying float v_depthFromNearPlusOne;

#ifdef POLYGON_OFFSET
uniform vec2 u_polygonOffset;
#endif

#endif

/**
 * Writes the fragment depth to the logarithmic depth buffer.
 * <p>
 * Use this when the vertex shader does not call {@link czm_vertexlogDepth}, for example, when
 * ray-casting geometry using a full screen quad.
 * </p>
 * @name czm_writeLogDepth
 * @glslFunction
 *
 * @param {float} depth The depth coordinate, where 1.0 is on the near plane and
 *                      depth increases in eye-space units from there
 *
 * @example
 * czm_writeLogDepth((czm_projection * v_positionEyeCoordinates).w + 1.0);
 */
void czm_writeLogDepth(float depth)
{
#if (defined(GL_EXT_frag_depth) || defined(WEBGL2)) && defined(LOG_DEPTH)
    // Discard the vertex if it's not between the near and far planes.
    // We allow a bit of epsilon on the near plane comparison because a 1.0
    // from the vertex shader (indicating the vertex should be _on_ the near
    // plane) will not necessarily come here as exactly 1.0.
    if (depth <= 0.9999999 || depth > czm_farDepthFromNearPlusOne) {
        discard;
    }

#ifdef POLYGON_OFFSET
    // Polygon offset: m * factor + r * units
    float factor = u_polygonOffset[0];
    float units = u_polygonOffset[1];

    // If we can't compute derivatives, just leave out the factor I guess?
#ifdef GL_OES_standard_derivatives
    // m = sqrt(dZdX^2 + dZdY^2);
    float x = dFdx(depth);
    float y = dFdy(depth);
    float m = sqrt(x * x + y * y);

    // Apply the factor before computing the log depth.
    depth += m * factor;
#endif

#endif

    gl_FragDepthEXT = log2(depth) * czm_oneOverLog2FarDepthFromNearPlusOne;

#ifdef POLYGON_OFFSET
    // Apply the units after the log depth.
    gl_FragDepthEXT += czm_epsilon7 * units;
#endif

#endif
}

/**
 * Writes the fragment depth to the logarithmic depth buffer.
 * <p>
 * Use this when the vertex shader calls {@link czm_vertexlogDepth}.
 * </p>
 *
 * @name czm_writeLogDepth
 * @glslFunction
 */
void czm_writeLogDepth() {
#ifdef LOG_DEPTH
    czm_writeLogDepth(v_depthFromNearPlusOne);
#endif
}
`});var U8e,G8e=Ee(()=>{U8e=`/**
 * Transforms a value for non-perspective interpolation by multiplying
 * it by w, the value used in the perspective divide. This function is
 * intended to be called in a vertex shader to compute the value of a
 * \`varying\` that should not be subject to perspective interpolation.
 * For example, screen-space texture coordinates. The fragment shader
 * must call {@link czm_readNonPerspective} to retrieve the final
 * non-perspective value.
 *
 * @name czm_writeNonPerspective
 * @glslFunction
 *
 * @param {float|vec2|vec3|vec4} value The value to be interpolated without accounting for perspective.
 * @param {float} w The perspective divide value. Usually this is the computed \`gl_Position.w\`.
 * @returns {float|vec2|vec3|vec4} The transformed value, intended to be stored in a \`varying\` and read in the
 *          fragment shader with {@link czm_readNonPerspective}.
 */
float czm_writeNonPerspective(float value, float w) {
    return value * w;
}

vec2 czm_writeNonPerspective(vec2 value, float w) {
    return value * w;
}

vec3 czm_writeNonPerspective(vec3 value, float w) {
    return value * w;
}

vec4 czm_writeNonPerspective(vec4 value, float w) {
    return value * w;
}
`});var H8e,W8e=Ee(()=>{H8e=`/**
 * Converts a CIE Yxy color to RGB.
 * <p>The conversion is described in
 * </p>
 * 
 * @name czm_XYZToRGB
 * @glslFunction
 * 
 * @param {vec3} Yxy The color in CIE Yxy.
 *
 * @returns {vec3} The color in RGB.
 *
 * @example
 * vec3 xyz = czm_RGBToXYZ(rgb);
 * xyz.x = max(xyz.x - luminanceThreshold, 0.0);
 * rgb = czm_XYZToRGB(xyz);
 */
vec3 czm_XYZToRGB(vec3 Yxy)
{
    const mat3 XYZ2RGB = mat3( 3.2405, -0.9693,  0.0556,
                              -1.5371,  1.8760, -0.2040,
                              -0.4985,  0.0416,  1.0572);
    vec3 xyz;
    xyz.r = Yxy.r * Yxy.g / Yxy.b;
    xyz.g = Yxy.r;
    xyz.b = Yxy.r * (1.0 - Yxy.g - Yxy.b) / Yxy.b;
    
    return XYZ2RGB * xyz;
}
`});var FQ,q8e=Ee(()=>{wke();bke();Ike();Dke();Bke();Lke();Fke();zke();kke();Gke();Wke();jke();Qke();Kke();Jke();e4e();r4e();n4e();a4e();l4e();c4e();x4e();d4e();p4e();g4e();y4e();C4e();w4e();b4e();I4e();D4e();B4e();L4e();F4e();z4e();k4e();G4e();W4e();j4e();Q4e();K4e();J4e();eUe();rUe();nUe();aUe();lUe();cUe();xUe();dUe();pUe();gUe();yUe();CUe();wUe();bUe();IUe();DUe();BUe();LUe();FUe();zUe();kUe();GUe();WUe();jUe();QUe();KUe();JUe();eGe();rGe();nGe();aGe();lGe();cGe();xGe();dGe();pGe();gGe();yGe();CGe();wGe();bGe();IGe();DGe();BGe();LGe();FGe();zGe();kGe();GGe();WGe();jGe();QGe();KGe();JGe();eHe();rHe();nHe();aHe();lHe();cHe();xHe();dHe();pHe();gHe();yHe();CHe();wHe();bHe();IHe();DHe();BHe();LHe();FHe();zHe();kHe();GHe();WHe();jHe();QHe();KHe();JHe();e8e();r8e();n8e();a8e();l8e();c8e();x8e();d8e();p8e();g8e();y8e();C8e();w8e();b8e();I8e();D8e();B8e();L8e();F8e();z8e();k8e();G8e();W8e();FQ={czm_degreesPerRadian:Tke,czm_depthRange:Eke,czm_ellipsoidInverseRadii:Ske,czm_ellipsoidRadii:Pke,czm_epsilon1:Mke,czm_epsilon2:Rke,czm_epsilon3:Oke,czm_epsilon4:Nke,czm_epsilon5:Vke,czm_epsilon6:Uke,czm_epsilon7:Hke,czm_infinity:qke,czm_oneOverPi:Yke,czm_oneOverTwoPi:Xke,czm_passCesium3DTile:Zke,czm_passCesium3DTileClassification:$ke,czm_passCesium3DTileClassificationIgnoreShow:t4e,czm_passClassification:i4e,czm_passCompute:o4e,czm_passEnvironment:s4e,czm_passGlobe:u4e,czm_passGround:f4e,czm_passOpaque:h4e,czm_passOverlay:m4e,czm_passTerrainClassification:v4e,czm_passTranslucent:_4e,czm_pi:A4e,czm_piOverFour:T4e,czm_piOverSix:E4e,czm_piOverThree:S4e,czm_piOverTwo:P4e,czm_radiansPerDegree:M4e,czm_sceneMode2D:R4e,czm_sceneMode3D:O4e,czm_sceneModeColumbusView:N4e,czm_sceneModeMorphing:V4e,czm_solarRadius:U4e,czm_threePiOver2:H4e,czm_twoPi:q4e,czm_webMercatorMaxLatitude:Y4e,czm_depthRangeStruct:X4e,czm_ellipsoid:Z4e,czm_material:$4e,czm_materialInput:tUe,czm_ray:iUe,czm_raySegment:oUe,czm_s3mMaterialInput:sUe,czm_shadowParameters:uUe,czm_acesTonemapping:fUe,czm_adjustColor:hUe,czm_alphaWeight:mUe,czm_antialias:vUe,czm_approximateSphericalCoordinates:_Ue,czm_branchFreeTernary:AUe,czm_cascadeColor:TUe,czm_cascadeDistance:EUe,czm_cascadeMatrix:SUe,czm_cascadeWeights:PUe,czm_clip:MUe,czm_columbusViewMorph:RUe,czm_computeLightColorInFP:OUe,czm_computeLightColorInstanceInFP:NUe,czm_computeNormal:VUe,czm_computePosition:UUe,czm_cosineAndSine:HUe,czm_decompressTextureCoordinates:qUe,czm_depthClamp:YUe,czm_depthClampFarPlane:XUe,czm_directionLight:ZUe,czm_eastNorthUpToEyeCoordinates:$Ue,czm_ellipsoidContainsPoint:tGe,czm_ellipsoidNew:iGe,czm_ellipsoidWgs84TextureCoordinates:oGe,czm_equalsEpsilon:sGe,czm_executeExcavation:uGe,czm_eyeOffset:fGe,czm_eyeToWindowCoordinates:hGe,czm_fastApproximateAtan:mGe,czm_fog:vGe,czm_gammaCorrect:_Ge,czm_geodeticSurfaceNormal:AGe,czm_getDefaultMaterial:TGe,czm_getEmissiveTextureColor:EGe,czm_getHorizontalColor:SGe,czm_getHypsometricColor:PGe,czm_getLambertDiffuse:MGe,czm_getSpecular:RGe,czm_getTexColorForS3M:OGe,czm_getTextureMatrixFromZValue:NGe,czm_getVolumeValue:VGe,czm_getVolumeValueMultiResolution:UGe,czm_getWaterNoise:HGe,czm_getWgs84EllipsoidEC:qGe,czm_HSBToRGB:YGe,czm_HSLToRGB:XGe,czm_hue:ZGe,czm_inverseGamma:$Ge,czm_inverseMatrix:tHe,czm_isEmpty:iHe,czm_isFull:oHe,czm_latitudeToWebMercatorFraction:sHe,czm_lineDistance:uHe,czm_luminance:fHe,czm_metersPerPixel:hHe,czm_modelToWindowCoordinates:mHe,czm_multiplyWithColorBalance:vHe,czm_nearFarScalar:_He,czm_octDecode:AHe,czm_packDepth:THe,czm_packValue:EHe,czm_phong:SHe,czm_planeDistance:PHe,czm_pointAlongRay:MHe,czm_rayEllipsoidIntersectionInterval:RHe,czm_readDepth:OHe,czm_readNonPerspective:NHe,czm_reverseLogDepth:VHe,czm_RGBToHSB:UHe,czm_RGBToHSL:HHe,czm_RGBToXYZ:qHe,czm_RollerShutter:YHe,czm_s3mBatchOperation:XHe,czm_S3MPBR:ZHe,czm_sampleAndBlend:$He,czm_sampleOctahedralProjection:t8e,czm_saturation:i8e,czm_shadowDepthCompare:o8e,czm_shadowVisibility:s8e,czm_signNotZero:u8e,czm_sketchMode:f8e,czm_sphericalHarmonics:h8e,czm_tangentToEyeSpaceMatrix:m8e,czm_transformPlane:v8e,czm_translateRelativeToEye:_8e,czm_translucentPhong:A8e,czm_transpose:T8e,czm_unpackDepth:E8e,czm_unpackFloat:S8e,czm_unpackValue:P8e,czm_vertexLogDepth:M8e,czm_windowToEyeCoordinates:R8e,czm_writeDepthClamp:O8e,czm_writeDepthClampedToFarPlane:N8e,czm_writeLogDepth:V8e,czm_writeNonPerspective:U8e,czm_XYZToRGB:H8e}});var NQ,kde=Ee(()=>{NQ=`
#ifdef HAS_RAIN
uniform float uAnimationSpeed;
uniform sampler2D uRippleTexture;
uniform float uRippleScale;
uniform float uWindIntensity;
uniform float uRain;
uniform float uCameraDepth;
    
void getTimeInfo(float animationSpeed, out vec2 timeVec)
{
	float time = czm_frameNumber * animationSpeed;
	time = floor(30.0 * time);
	float time_diff = floor(time*0.25);
	time = mod(time, 4.0);
	time_diff = mod(time_diff, 4.0);
	timeVec = vec2(time, time_diff);
}

void getPosInfo(vec4 posMC, out vec2 posMC_frac1, out vec2 posMC_frac2)
{
	float ripple_scale = 1.0 / uRippleScale;
	vec2 posXY = posMC.xy * ripple_scale;
	posMC_frac1 = fract(posXY);
	vec2 posStep = vec2(0.5);
	posMC_frac2 = fract(posXY + posStep);
}

float getAlpha(vec2 posMC_frac1)
{
	vec2 dist = (posMC_frac1 - vec2(0.5)) * 2.0;
	dist = vec2(abs(dist.x), abs(dist.y));
	vec2 result = pow(dist, vec2(5.0));
	return result.x + result.y;
}

vec4 getRippleValue(sampler2D uRippleTexture, vec2 timeVec, vec2 posMC_frac1, vec2 posMC_frac2, float alpha)
{
	vec2 rippleUV_1 = (timeVec + posMC_frac1)*0.25;
	vec2 rippleUV_2 = (timeVec + posMC_frac2)*0.25;
	vec4 rippleValue_1 = texture2D(uRippleTexture, rippleUV_1.xy);
	vec4 rippleValue_2 = texture2D(uRippleTexture, rippleUV_2.xy);
	return mix(rippleValue_1, rippleValue_2, alpha);
}

vec3 getRippleNormal(vec4 rippleValue, float wind_intensity, float rain, float depthFade)
{
	vec2 rippleValueXY = rippleValue.xy;
	vec2 rippleValueZW = rippleValue.zw;
	const vec2 _value = vec2(0.5);
	vec2 part_1 = (rippleValueZW - _value) * wind_intensity * 0.13;
	vec2 part_2 = (rippleValueXY - _value) * 0.6;
	vec2 mergedValue = mix(part_1, part_2, rain) * depthFade;
	return vec3(mergedValue, 1.0);
}

float getNormalAlpha(vec3 normalWS,float wetness)
{
	float valueZ = normalWS.z - 0.5;
	float wet_correction = wetness * clamp(valueZ * 2.5, 0.0, 1.0);
	return pow(wet_correction, 15.0);
}

vec3 rippleNormalCorrection(vec3 rippleNormal,float normalAlpha)
{
	const vec3 blueNormal = vec3(0.0, 0.0, 1.0);
	return mix(blueNormal, rippleNormal, normalAlpha);
}

vec3 rippleGenerator(sampler2D uRippleTexture, float animationSpeed,vec3 normalWS,float wetness)
{
	vec2 timeVec = vec2(1.0);
	getTimeInfo(animationSpeed, timeVec);
	vec2 posMC_frac1 = vec2(1.0);
	vec2 posMC_frac2 = vec2(1.0);
	getPosInfo(vPositionMC, posMC_frac1, posMC_frac2);
	float alpha = getAlpha(posMC_frac1);
	vec4 rippleValue = getRippleValue(uRippleTexture, timeVec, posMC_frac1, posMC_frac2, alpha);
	vec3 rippleNormal = getRippleNormal(rippleValue, uWindIntensity, uRain, uCameraDepth);
	float normalAlpha = getNormalAlpha(normalWS, wetness);
	return normalize(rippleNormalCorrection(rippleNormal, normalAlpha));
}
#endif
`});var zQ,Ude=Ee(()=>{zQ=`
#ifdef HAS_SNOW
uniform float uSnowCoverageFactor;
uniform sampler2D uSnowMaskTexture;
uniform sampler2D uSnowNormalTexture;

vec3 getSnowMaskValue(sampler2D uSnowMaskTexture, vec2 snowUV)
{
	return texture2D(uSnowMaskTexture, snowUV).rgb;
}

float getSnowCoverage(float snow_coverage, float max_snow_coverage, vec3 normalWS, float z_mask)
{
	float normal_z = normalWS.z;
	normal_z += 1.1 + z_mask;
	normal_z = clamp(normal_z * 0.5, 0.0, 1.0);
	float final_snow_coverage = clamp(snow_coverage, 0.0, max_snow_coverage);
	final_snow_coverage = clamp(final_snow_coverage*normal_z, 0.0, 1.0);
	return final_snow_coverage;
}

float getSnowCoverageWithMaskTexture(float finalSnowCoverage, float heightValue, float snow_scatter_value, float snow_scatter_alpha, float tighten_value)
{
	float scatter_value = mix(heightValue, snow_scatter_value, snow_scatter_alpha);
	return clamp((tighten_value + 1.0) * finalSnowCoverage - tighten_value * scatter_value, 0.0, 1.0);
}

float getSnowAlpha(vec3 normalWS, float snow_coverage, float z_mask)
{
	return clamp((normalWS.z + z_mask) * 5.0, 0.0, 1.0) * snow_coverage;
}

vec3 getFinalBaseColor(vec3 baseColor, vec3 snow_baseColor, float snowAlpha)
{
	return mix(baseColor, snow_baseColor, snowAlpha);
}

float getFinalRoughness(float roughness, float snow_roughness, float snowAlpha)
{
	return mix(roughness, snow_roughness, snowAlpha);
}

vec3 getFinalNormal(vec3 normalWS, vec3 snowNormal, float blendNormalValue, float snow_coverage)
{
	vec3 snowNormal_part2 = vec3(snowNormal.xy - vec2(0.5), 1.0);
	float normal_alpha = (1.0 - blendNormalValue)* snow_coverage;
	return mix(normalWS, snowNormal_part2, normal_alpha);
}

void snowGenerator(sampler2D uSnowMaskTexture, sampler2D uSnowNormalTexture, vec2 snowUV, float snow_coverage, inout vec3 normalWS, inout vec3 baseColor, inout float roughness)
{
	vec3 snowMaskValue = texture2D(uSnowMaskTexture, snowUV).rgb;
	const float max_snow_coverage = 1.0;
	const float z_mask = 0.0;
	float snowCoverage = getSnowCoverage(snow_coverage, max_snow_coverage, normalWS, z_mask);
	const float heightValue = 0.5;
	float snow_scatter_value = snowMaskValue.g;
	const float snow_scatter_alpha = 0.5;
	const float tighten_value = 4.0;
    snowCoverage = getSnowCoverageWithMaskTexture(snowCoverage, heightValue, snow_scatter_value, snow_scatter_alpha, tighten_value);
	float snow_alpha = getSnowAlpha(normalWS, snowCoverage, z_mask);
	baseColor = getFinalBaseColor(baseColor, vec3(snowMaskValue.r), snow_alpha);
	roughness = getFinalRoughness(roughness, snowMaskValue.b, snow_alpha);
	vec3 snowNormalValue = texture2D(uSnowNormalTexture, snowUV).rgb;
	const float blendNormalValue = 0.3;
	normalWS = getFinalNormal(normalWS, snowNormalValue, blendNormalValue, snowCoverage);
}

#endif
`});var VQ,Gde=Ee(()=>{VQ=`
#ifdef HAS_HEMISPHERE_LIGHTS

uniform vec3 uSkyColor[ HEMISPHERE_LIGHTS ];
uniform vec3 uGroundColor[ HEMISPHERE_LIGHTS ];
uniform vec3 uHemisphereLightDirectionEC[ HEMISPHERE_LIGHTS ];
    
struct HemisphereLight {
    vec3 direction;
    vec3 skyColor;
    vec3 groundColor;
};

vec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {
    float dotNL = dot( geometry.normal, hemiLight.direction );
    float hemiDiffuseWeight = 0.5 * dotNL + 0.5;
    vec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );
    return irradiance;
}

#endif
`});var kQ,Hde=Ee(()=>{kQ=`
#ifdef HAS_POINT_LIGHTS

uniform vec3 uPointLightPositionEC[ POINT_LIGHTS ];
uniform vec3 uPointLightColor[ POINT_LIGHTS ];
uniform vec2 uPointLightDistanceAndDecay[ POINT_LIGHTS ];

struct PointLight {
    vec3 position;
    vec3 color;
    float distance;
    float decay;
};

void getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {
    vec3 lVector = pointLight.position - geometry.position;
    directLight.direction = normalize( lVector );
    float lightDistance = length( lVector );
    directLight.color = pointLight.color;
    directLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );
    directLight.visible = ( directLight.color != vec3( 0.0 ) );
}

#endif
`});var UQ,Wde=Ee(()=>{UQ=`
#ifdef HAS_SPOT_LIGHTS

uniform vec3 uSpotLightColor[ SPOT_LIGHTS ];
uniform vec3 uSpotLightPositionEC[ SPOT_LIGHTS ];
uniform vec3 uSpotLightDirectionEC[ SPOT_LIGHTS ];
uniform vec4 uSpotLightDistanceDecayCosPenumbra[ SPOT_LIGHTS ];
uniform vec3 uSpotLightExponent[ SPOT_LIGHTS ];
    
struct SpotLight {
    vec3 position;
    vec3 direction;
    vec3 color;
    float distance;
    float decay;
    float coneCos;
    float penumbraCos;
};

void getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {
    vec3 lVector = spotLight.position - geometry.position;
    directLight.direction = normalize( lVector );
    float lightDistance = length( lVector );
    float angleCos = dot( directLight.direction, spotLight.direction );
    if ( angleCos > spotLight.coneCos ) {
        float spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );
        directLight.color = spotLight.color;
        directLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );
        directLight.visible = true;
    } else {
        directLight.color = vec3( 0.0 );
        directLight.visible = false;
    }
}

#endif
`});var GQ,qde=Ee(()=>{GQ=`
#ifdef HAS_DIR_LIGHTS

uniform vec3 uDirectionalLightDirectionEC[ DIR_LIGHTS ];
uniform vec3 uDirectionalLightColor[ DIR_LIGHTS ];
    
#endif
`});var HQ,jde=Ee(()=>{HQ=`

#ifdef HAS_DIR_LIGHTS
for (int i = 0; i < DIR_LIGHTS; i++) {
    directLight.color = uDirectionalLightColor[i];
    directLight.direction = uDirectionalLightDirectionEC[i];
    directLight.visible = true;
    directPhysical( directLight, geometry, material, reflectedLight );
}
#endif

#ifdef HAS_POINT_LIGHTS
PointLight pointLight;
for (int i = 0; i < POINT_LIGHTS; i++) {
    pointLight.position = uPointLightPositionEC[i];
    pointLight.color = uPointLightColor[i];
    pointLight.distance = uPointLightDistanceAndDecay[i].x;
    pointLight.decay = uPointLightDistanceAndDecay[i].y;
    getPointDirectLightIrradiance( pointLight, geometry, directLight );
    if(!directLight.visible) continue;
    directPhysical( directLight, geometry, material, reflectedLight );
}
#endif

#ifdef HAS_SPOT_LIGHTS
SpotLight spotLight;
for (int i = 0; i < SPOT_LIGHTS; i++) {
    spotLight.position = uSpotLightPositionEC[i];
    spotLight.color = uSpotLightColor[i];
    spotLight.direction = uSpotLightDirectionEC[i];
    spotLight.coneCos = uSpotLightDistanceDecayCosPenumbra[i].z;
    spotLight.penumbraCos = uSpotLightDistanceDecayCosPenumbra[i].w;
    getSpotDirectLightIrradiance( spotLight, geometry, directLight );
    if(!directLight.visible) continue;
    directPhysical( directLight, geometry, material, reflectedLight );
}
#endif
`});var WQ,Yde=Ee(()=>{WQ=`
#ifdef BRDF
#define RECIPROCAL_PI 0.31830988618
#define M_PI 3.141592653589793
#define EPSILON 1e-6
#define CUBEUV_MAX_MIP 8.0
#define CUBEUV_TEXEL_WIDTH 0.0013020833333333333
#define CUBEUV_TEXEL_HEIGHT 0.0009765625
#define saturate(a) clamp( a, 0.0, 1.0 )
float pow2( const in float x ) { return x * x; }

uniform vec4 uBaseColorFactor;
uniform vec4 uEmissiveFactor;
uniform float uMetallicFactor;
uniform float uRoughnessFactor;
uniform float uAlphaCutoff;
uniform float uEnvMapIntensity;
uniform float uCameraReflect;
struct IncidentLight {
    vec3 direction;
    vec3 color;
    bool visible;
};

struct GeometricContext {
    vec3 position;
    vec3 normal;
    vec3 viewDir;
};

struct PhysicalMaterial {
    vec3	diffuseColor;
    float	roughness;
    vec3	specularColor;
    float specularF90;
};

struct ReflectedLight {
    vec3 directDiffuse;
    vec3 directSpecular;
    vec3 indirectDiffuse;
    vec3 indirectSpecular;
};

#ifdef HAS_BASE_TEXTURE
    uniform sampler2D uBaseTexture;
#endif

#ifdef HAS_NORMAL_TEXTURE
    uniform sampler2D uNormalTexture;
    uniform float uNormalTextureScale;
#ifdef HAS_ANISOTROPY
    uniform vec4 uAnisotropy;
#endif
#endif

#ifdef HAS_EMISSIVE_TEXTURE
    uniform sampler2D uEmissionTexture;
    uniform vec4 uEmissiveUVOffsetAndTiling;
#endif

#ifdef HAS_MetallicRoughness_TEXTURE
    uniform sampler2D uMetallicRoughnessTexture;
#endif

#ifdef HAS_OCCLUSION_TEXTURE
    uniform sampler2D uOcclusionTexture;
#endif

#ifdef REFRACTION
    uniform float uIndexOfRefraction;
#endif

#ifdef HAS_TRANSMISSION
    uniform float uTransmissionFactor;
#endif

#ifdef HAS_WETNESS
    uniform float uWetnessFactor;
#endif

#ifdef HAS_VOLUME
    uniform vec4 uTintColor;
    uniform vec4 uDiffusionDistance;
    uniform float uThickness;
#endif

#ifdef HAS_CLEARCOAT
    uniform float uClearcoatFactor;
    uniform float uClearcoatRoughnessFactor;
#endif

//\u53C2\u8003UE4.24\u5B9E\u73B0\u8BA1\u7B97\u7CBE\u786E\u5149\u6E90\u7684\u8870\u51CF
float punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {
    // float d = lightDistance;
    // float r = cutoffDistance;
    // float d2 = d * d;
    // float attenuation = 1.0 / (d2 + 1.0); 
    // float m = saturate(1.0 - pow(d / r, 4.0));
    // float m2 = m * m;
    // return attenuation * m2;
    if ( decayExponent > 0.0 ) {
        return pow( saturate( 1.0 - lightDistance / cutoffDistance ), decayExponent );
    }
    return 1.0;
}

#include <hemisphereLightDecl>
#include <directionLightDecl>
#include <pointLightDecl>
#include <spotLightDecl>
#include <snowDecl>
#include <rainDecl>

#ifdef HAS_ANISOTROPY
vec3 getAnisotropicBentNormals(const vec3 T, const vec3 B, const vec3 N, const vec3 V, float anisotropy) {
    vec3 anisotropicFrameDirection = anisotropy >= 0.0 ? B : T;
    vec3 anisotropicFrameTangent = cross(normalize(anisotropicFrameDirection), V);
    vec3 anisotropicFrameNormal = cross(anisotropicFrameTangent, anisotropicFrameDirection);
    vec3 anisotropicNormal = normalize(mix(N, anisotropicFrameNormal, abs(anisotropy)));
    return anisotropicNormal;
}
#endif

#ifdef HAS_VOLUME
vec3 computeColorAtDistanceInMedia(vec3 color, float distance) {
    return -log(color) / distance;
}
vec3 cocaLambert(vec3 alpha, float distance) {
    return exp(-alpha * distance);
}
#endif


vec3 sRGBToLinear(vec3 srgbIn) 
{
    return pow(srgbIn, vec3(2.2));
}

vec4 sRGBToLinear(vec4 srgbIn)
{
    srgbIn = srgbIn ;
    vec3 linearOut = pow(srgbIn.rgb, vec3(2.2));
    return vec4(linearOut, srgbIn.a);
}

vec3 LinearTosRGB(vec3 linearIn) 
{
#ifndef HDR 
    return pow(linearIn, vec3(1.0/2.2));
#else 
    return linearIn;
#endif 
}

vec3 lambertianDiffuse(vec3 diffuseColor) 
{
    return diffuseColor * RECIPROCAL_PI;
}

vec3 applyTonemapping(vec3 linearIn) 
{
    vec3 color = linearIn * czm_toneMappingExposure;
    return czm_acesTonemapping(color);
}

vec3 F_Schlick( const in vec3 f0, const in float f90, const in float dotVH ) {
    float fresnel = exp2( ( - 5.55473 * dotVH - 6.98316 ) * dotVH );
    return f0 * ( 1.0 - fresnel ) + ( f90 * fresnel );
}

float GeometrySchlickGGX(float roughness, float NoV)
{
    float k = pow(roughness + 1.0, 2.0) / 8.0;
    return NoV / (NoV * (1.0 - k) + k);
}

float D_GGX( const in float alpha, const in float dotNH ) {
    float a2 = pow2( alpha );
    float denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;
    return RECIPROCAL_PI * a2 / pow2( denom );
}

vec3 BRDF_GGX( const in vec3 lightDir, const in vec3 viewDir, const in vec3 normal, const in vec3 f0, const in float f90, const in float roughness ) {
    float alpha = roughness * roughness;
    vec3 halfDir = normalize( lightDir + viewDir );
    float dotNL = clamp( dot( normal, lightDir ), 0.001, 1.0 );
    float dotNV = abs( dot( normal, viewDir ) ) + 0.001;
    float dotNH = saturate( dot( normal, halfDir ) );
    float dotLH = saturate( dot( lightDir, halfDir ) );
    float dotVH = saturate( dot( viewDir, halfDir ) );
    vec3 F = F_Schlick( f0, f90, dotVH );
    float G = GeometrySchlickGGX(alpha, dotNV) * GeometrySchlickGGX(alpha, dotNL);
    float D = D_GGX( alpha, dotNH );
    return F * ( G * D ) / (4.0 * dotNL * dotNV);
}

void directPhysical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {
    float dotNL = saturate( dot( geometry.normal, directLight.direction ) );
    vec3 irradiance = dotNL * directLight.color;
    reflectedLight.directSpecular += irradiance * BRDF_GGX( directLight.direction, geometry.viewDir, geometry.normal, material.specularColor, material.specularF90, material.roughness );
    reflectedLight.directDiffuse += irradiance * lambertianDiffuse( material.diffuseColor );
}

#ifdef HAS_NORMAL_TEXTURE
vec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm, vec2 uv, vec3 mapN) {
    float fNormalLength = length(mapN);
    if(fNormalLength < 0.5) {
        return surf_norm;
    }
    mapN = mapN * 2.0 - 1.0;
    vec3 q0 = vec3( dFdx( eye_pos.x ), dFdx( eye_pos.y ), dFdx( eye_pos.z ) );
    vec3 q1 = vec3( dFdy( eye_pos.x ), dFdy( eye_pos.y ), dFdy( eye_pos.z ) );
    vec2 st0 = dFdx( uv.st );
    vec2 st1 = dFdy( uv.st );
    float scale = sign( st1.t * st0.s - st0.t * st1.s );
    vec3 S = normalize( ( q0 * st1.t - q1 * st0.t ) * scale );
    vec3 T = normalize( ( - q0 * st1.s + q1 * st0.s ) * scale );
    vec3 N = normalize( surf_norm );
    mat3 tsn = mat3( S, T, N );
    mapN.xy *= uNormalTextureScale;
    mapN.xy *= ( float( gl_FrontFacing ) * 2.0 - 1.0 );
    return normalize( tsn * mapN );
}
#endif

#include <cubeUV_reflection>

vec3 inverseTransformDirection( in vec3 dir ) {
    mat3 fixedToENU = mat3(czm_modelView[0][0], czm_modelView[1][0], czm_modelView[2][0], czm_modelView[0][1], czm_modelView[1][1], czm_modelView[2][1], czm_modelView[0][2], czm_modelView[1][2], czm_modelView[2][2]);
    const mat3 yUpToZUp = mat3(1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0);
    return normalize( yUpToZUp * fixedToENU * dir );
}

void indirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {
    reflectedLight.indirectDiffuse += irradiance * lambertianDiffuse( material.diffuseColor );
}

vec2 DFGApprox( const in vec3 normal, const in vec3 viewDir, const in float roughness ) {
    float dotNV = saturate( dot( normal, viewDir ) );
    const vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );
    const vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );
    vec4 r = roughness * c0 + c1;
    float a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;
    vec2 fab = vec2( - 1.04, 1.04 ) * a004 + r.zw;
    return fab;
}

void computeMultiscattering( const in vec3 normal, const in vec3 viewDir, const in vec3 specularColor, const in float specularF90, const in float roughness, inout vec3 singleScatter, inout vec3 multiScatter ) {
    vec2 fab = DFGApprox( normal, viewDir, roughness );
    vec3 Fr = specularColor;
    vec3 FssEss = Fr * fab.x + specularF90 * fab.y;
    float Ess = fab.x + fab.y;
    float Ems = 1.0 - Ess;
    vec3 Favg = Fr + ( 1.0 - Fr ) * 0.047619;
    vec3 Fms = FssEss * Favg / ( 1.0 - Ems * Favg );
    singleScatter += FssEss;
    multiScatter += Fms * Ems;
}

void indirectSpecular_Physical( const in vec3 radiance, const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {
    vec3 singleScattering = vec3( 0.0 );
    vec3 multiScattering = vec3( 0.0 );
    vec3 cosineWeightedIrradiance = irradiance;
    computeMultiscattering( geometry.normal, geometry.viewDir, material.specularColor, material.specularF90, material.roughness, singleScattering, multiScattering );
    vec3 totalScattering = singleScattering + multiScattering;
    vec3 diffuse = material.diffuseColor * ( 1.0 - max( max( totalScattering.r, totalScattering.g ), totalScattering.b ) );
    reflectedLight.indirectSpecular += radiance * singleScattering;
    reflectedLight.indirectSpecular += multiScattering * cosineWeightedIrradiance;
    reflectedLight.indirectSpecular = (uCameraReflect * 0.5 + 0.5) * reflectedLight.indirectSpecular;   // \u7C97\u7CD9\u5EA6\u503C\u504F\u5C0F\u4F7F\u8BA1\u7B97\u51FA\u7684\u73AF\u5883\u56FE\u9AD8\u5149\u503C\u504F\u5927\u5BFC\u81F4\u6C34\u9762\u53CD\u5C04\u7684\u6A21\u578B\u6CDB\u767D,\u6545\u6C34\u9762\u53CD\u5C04\u65F6\u4E0D\u8BA1\u7B97\u73AF\u5883\u56FE\u7684\u9AD8\u5149
    reflectedLight.indirectDiffuse += diffuse * cosineWeightedIrradiance;
}

vec3 getIBLIrradiance( const in vec3 normal ) {
    vec3 worldNormal = inverseTransformDirection( normal );
    vec4 envMapColor = textureCubeUV( czm_hdrEnvMap, worldNormal, 1.0 );
    return envMapColor.rgb;
}

vec3 getIBLRadiance( const in vec3 viewDir, const in vec3 normal, const in float roughness ) {
    vec3 reflectVec = reflect( - viewDir, normal );
    reflectVec = normalize( mix( reflectVec, normal, roughness * roughness) );
    reflectVec = inverseTransformDirection( reflectVec );
    vec4 envMapColor = textureCubeUV( czm_hdrEnvMap, reflectVec, roughness );
    return envMapColor.rgb;
}

float computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {
    return saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );
}

uniform float uPbrParTextureWidth;
void calculateMipLevel(in vec2 inTexCoord, in vec2 vecTile, in float fMaxMip, inout float mipLevel)
{
	vec2 dx = dFdx(inTexCoord * vecTile.x);
	vec2 dy = dFdy(inTexCoord * vecTile.y);
	float dotX = dot(dx, dx);
	float dotY = dot(dy, dy);
	float dMax = max(dotX, dotY);
	float dMin = min(dotX, dotY);
	float offset = (dMax - dMin) / (dMax + dMin);
	offset = clamp(offset, 0.0, 1.0);
	float d = dMax * (1.0 - offset) + dMin * offset;
	mipLevel = 0.5 * log2(d);
	mipLevel = clamp(mipLevel, 0.0, fMaxMip - 1.62);
}

vec3 getTexcoordAndMipmapLevel(vec2 uv, vec4 texMatrix, float texCoordZ) {
    vec2 translate = texMatrix.xy;
    float textureWidth = texMatrix.z * uPbrParTextureWidth;
    float scale = texMatrix.z;
    float maxMipmapLevel = texMatrix.w;
    float mipLevel = 0.0;
        calculateMipLevel(uv, vec2(textureWidth), maxMipmapLevel, mipLevel);
    vec2 texCoord;
    if(texCoordZ < -9000.0)
    {
        texCoord = vec2(uv.x, uv.y);
    }
    else
    {
        texCoord = fract(uv);
        float offset = pow(2.0, mipLevel) / textureWidth;
        texCoord = clamp(texCoord, offset, 1.0 - offset);
        texCoord.x = (texCoord.x + translate.x) * scale;
        texCoord.y = (texCoord.y + translate.y) * scale;
    }
    
    return vec3(texCoord.xy, mipLevel);
}

vec4 brdf(in vec4 baseColorWithAlpha, vec2 texCoord, vec2 oriTexCoord, vec3 posEC, vec3 posMC, vec3 vertexNormalEC, vec4 sunLightColor, float sunLightON) {
    vec2 uv = oriTexCoord;
    float mipmapLevel = 0.0;
#ifdef USE_BatchPBR
    vec3 uvAndMiplevel = getTexcoordAndMipmapLevel(oriTexCoord, vTexMatrix, vTexCoordZ.x);
    uv = uvAndMiplevel.xy;
    mipmapLevel = uvAndMiplevel.z;
#endif
    baseColorWithAlpha = baseColorWithAlpha * uBaseColorFactor;
#ifdef BaseColorReplace
    baseColorWithAlpha = uBaseColorFactor;
#endif
    //float faceDirection = (gl_FrontFacing ? 1.0 : - 1.0) * uCameraReflect;
    vec3 ng = normalize(vertexNormalEC);
    #ifndef HAS_NORMAL
        ng = normalize(czm_normal * czm_computeNormal(posMC.xyz));
    #else
        float faceDirection = (dot(ng, -normalize(posEC)) < 0.0 ? -1.0 : 1.0) * uCameraReflect;
        ng = ng * faceDirection;
    #endif
    
#ifdef HAS_BASE_TEXTURE
    #ifdef USE_BatchPBR
        baseColorWithAlpha *= sRGBToLinear(texture2DLodEXT(uBaseTexture, uv * uTexUVOffset.zw + uTexUVOffset.xy, mipmapLevel));
    #else
        baseColorWithAlpha = sRGBToLinear(texture2D(uBaseTexture, oriTexCoord * uTexUVOffset.zw + uTexUVOffset.xy)) * uBaseColorFactor * vColor;
    #endif
#endif
#ifdef HAS_NORMAL_TEXTURE
    #ifdef USE_BatchPBR
        vec3 mapN = texture2DLodEXT( uNormalTexture, uv, mipmapLevel).xyz;
    #else
        vec3 mapN = texture2D( uNormalTexture, uv).xyz;
    #endif
    vec3 n = perturbNormal2Arb(posEC, ng, oriTexCoord, mapN);
#ifdef HAS_ANISOTROPY
    float anisotropy = uAnisotropy.b;
    vec3 anisotropyDirection = vec3(uAnisotropy.xy, 0.0);
    vec3 anisotropicTangent = normalize(tbn * anisotropyDirection);
    vec3 anisotropicBitangent = normalize(cross(tbn[2], anisotropicTangent));
    n = getAnisotropicBentNormals(anisotropicTangent, anisotropicBitangent, n, v, anisotropy);
#endif
#else
    vec3 n = ng;
#endif
#ifdef HAS_WETNESS
    mat3 fixedToENU_wetness = mat3(czm_modelView[0][0], czm_modelView[1][0], czm_modelView[2][0], czm_modelView[0][1], czm_modelView[1][1], czm_modelView[2][1], czm_modelView[0][2], czm_modelView[1][2], czm_modelView[2][2]);
    vec3 normalWS_wetness = normalize(fixedToENU_wetness * n);
#endif
#ifdef HAS_RAIN
    n = rippleGenerator(uRippleTexture,uAnimationSpeed,normalWS_wetness,uWetnessFactor);
#endif
    vec3 baseColor = baseColorWithAlpha.rgb;
    float roughness = uRoughnessFactor;
    float metalness = uMetallicFactor;
    vec4 emissiveFactor = uEmissiveFactor;
    vec2 emissiveTexCoord = texCoord.xy;
#ifdef PBR_THEME
    int pbrIndex = int(vPBRIndex);
    if(vPBRIndex < 0.0)
    {
        return baseColorWithAlpha;
    }
    mat4 pbrPar = mat4(0.0);
    for(int i = 0;i < NUM_PBR_MATERIALS;i++)
    {
        if(i == pbrIndex)
        {
            pbrPar = uPBRMaterials[i];
            break;
        }
    }
    roughness = clamp(pbrPar[0][0], 0.04, 1.0);
    metalness = clamp(pbrPar[0][1], 0.0, 1.0);
    baseColor = (baseColorWithAlpha / uBaseColorFactor * vec4(pbrPar[0][2], pbrPar[0][3], pbrPar[1][0], pbrPar[1][1])).rgb;
#endif
#ifdef USE_BatchPBR
    metalness = vMetallicRoughness.x;
    roughness = vMetallicRoughness.y;
    emissiveFactor = vEmissiveFactor;
    emissiveTexCoord = texCoord.xy;
#endif
    metalness = clamp(metalness, 0.0, 1.0);
    roughness = clamp(roughness, 0.0, 1.0);
    
#ifdef HAS_MetallicRoughness_TEXTURE
    #ifdef USE_BatchPBR
        vec3 metallicRoughness = texture2DLodEXT(uMetallicRoughnessTexture, uv, mipmapLevel).rgb;
    #else
        vec3 metallicRoughness = texture2D(uMetallicRoughnessTexture, oriTexCoord).rgb;
    #endif
    metalness = clamp(metalness * metallicRoughness.r, 0.0, 1.0);
    roughness = clamp(roughness * metallicRoughness.g, 0.04, 1.0);
#ifdef HAS_WETNESS
    float fWetness = clamp(uWetnessFactor,0.0,1.0);
    float fWetness_correction = pow(4.0*fWetness,2.0);
    fWetness_correction = clamp(fWetness_correction,clamp(fWetness,0.0,0.9),1.0);
    float fWerness_normalized = fWetness_correction * clamp(normalWS_wetness.z + 0.85,0.0,1.0);
    baseColor = mix(baseColor,baseColor*0.7,fWerness_normalized);
    roughness = mix(roughness,0.05,fWerness_normalized);
#endif
#ifdef HAS_SNOW
    mat3 fixedToENU_snow = mat3(czm_modelView[0][0], czm_modelView[1][0], czm_modelView[2][0], czm_modelView[0][1], czm_modelView[1][1], czm_modelView[2][1], czm_modelView[0][2], czm_modelView[1][2], czm_modelView[2][2]);
    vec3 normalWS_snow = normalize(fixedToENU_snow * n);
    snowGenerator(uSnowMaskTexture,uSnowNormalTexture, oriTexCoord,uSnowCoverageFactor,normalWS_snow,baseColor,roughness);
#endif
#endif

    vec3 lightColorHdr = vec3(2.0) * uSunLightON;   // \u592A\u9633\u5149
    vec3 l = normalize(czm_lightDirectionEC);
    vec3 v = -normalize(posEC);
    vec3 h = normalize(v + l);
    vec3 f0 = vec3(0.04);
    vec3 diffuseColor = baseColor * (1.0 - metalness) * (1.0 - f0);
    vec3 specularColor = mix(f0, baseColor, metalness);
    
    float alpha = roughness * roughness;
    float dotNL = clamp( dot( n, l ), 0.001, 1.0 );
    float dotNV = abs( dot( n, v ) ) + 0.001;
    float dotNH = saturate( dot( n, h ) );
    float dotLH = saturate( dot( l, h ) );
    float dotVH = saturate( dot( v, h ) );
    float reflectance = max(max(specularColor.r, specularColor.g), specularColor.b);
    float f90 = clamp(reflectance * 25.0, 0.0, 1.0);
    vec3 F = F_Schlick( specularColor, f90, dotVH );
    float G = GeometrySchlickGGX(alpha, dotNV) * GeometrySchlickGGX(alpha, dotNL);
    float D = D_GGX( alpha, dotNH );
    vec3 diffuseContribution = (1.0 - F) * lambertianDiffuse(diffuseColor);
    vec3 specularContribution = F * G * D / (4.0 * dotNL * dotNV);
    
    vec3 geometryNormal = ng;
    PhysicalMaterial material;
    material.diffuseColor = diffuseColor;
    vec3 dxy = max( abs( dFdx( geometryNormal ) ), abs( dFdy( geometryNormal ) ) );
    float geometryRoughness = max( max( dxy.x, dxy.y ), dxy.z );
    material.roughness = max( roughness, 0.0525 );
    material.roughness += geometryRoughness;
    material.roughness = min( material.roughness, 1.0 );
    material.specularColor = specularColor;
    material.specularF90 = 1.0;
    
    GeometricContext geometry;
    geometry.position = posEC;
    geometry.normal = n;
    geometry.viewDir = v;
    ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );
    reflectedLight.directDiffuse += dotNL * lightColorHdr * diffuseContribution;
    reflectedLight.directSpecular += dotNL * lightColorHdr * specularContribution;
    
    IncidentLight directLight; 
    #include <lightSourceImpl>
    
    vec3 irradiance = vec3(0.0);
    vec3 radiance = vec3(0.0);
  
#ifdef HAS_HEMISPHERE_LIGHTS
    HemisphereLight hemiLight;
    hemiLight.skyColor = uSkyColor[0];
    hemiLight.groundColor = uGroundColor[0];
    hemiLight.direction = normalize(czm_normal * vec3(0.0, 0.0, 1.0));
    irradiance += getHemisphereLightIrradiance( hemiLight, geometry );
#endif

#ifdef IBL

#ifdef KtxEnvMap
    mat3 fixedToENU = mat3(czm_modelView[0][0], czm_modelView[1][0], czm_modelView[2][0], czm_modelView[0][1], czm_modelView[1][1], czm_modelView[2][1], czm_modelView[0][2], czm_modelView[1][2], czm_modelView[2][2]);
    const mat3 yUpToZUp = mat3(-1.0, 0.0, 0.0, 0.0, 0.0, -1.0, 0.0, 1.0, 0.0);
    vec3 cubeDir = normalize( yUpToZUp * fixedToENU * reflect(-v, n) );
    vec3 worldNormal = normalize( yUpToZUp * fixedToENU * n );
    irradiance += czm_sphericalHarmonics(worldNormal, czm_sphericalHarmonicCoefficients);
    radiance += czm_sampleOctahedralProjection(czm_specularEnvironmentMaps, czm_specularEnvironmentMapSize, cubeDir,  roughness * czm_specularEnvironmentMapsMaximumLOD, czm_specularEnvironmentMapsMaximumLOD);
#else
    irradiance += getIBLIrradiance( geometry.normal );
    radiance += getIBLRadiance( geometry.viewDir, geometry.normal, material.roughness );
#endif
    
#else
    vec3 positionWC = vec3(czm_inverseView * vec4(posEC, 1.0));
    vec3 r = normalize(czm_inverseViewRotation * normalize(reflect(v, n)));
    float vertexRadius = length(positionWC);
    float horizonDotNadir = 1.0 - min(1.0, czm_ellipsoidRadii.x / vertexRadius);
    float reflectionDotNadir = dot(r, normalize(positionWC));
    r.x = -r.x;
    r = -normalize(czm_temeToPseudoFixed * r);
    r.x = -r.x;
    float inverseRoughness = 1.04 - roughness;
    inverseRoughness *= inverseRoughness;
    vec3 sceneSkyBox = textureCube(czm_environmentMap, r).rgb * inverseRoughness;
    float atmosphereHeight = 0.05;
    float blendRegionSize = 0.1 * ((1.0 - inverseRoughness) * 8.0 + 1.1 - horizonDotNadir);
    float blendRegionOffset = roughness * -1.0;
    float farAboveHorizon = clamp(horizonDotNadir - blendRegionSize * 0.5 + blendRegionOffset, 1.0e-10 - blendRegionSize, 0.99999);
    float aroundHorizon = clamp(horizonDotNadir + blendRegionSize * 0.5, 1.0e-10 - blendRegionSize, 0.99999);
    float farBelowHorizon = clamp(horizonDotNadir + blendRegionSize * 1.5, 1.0e-10 - blendRegionSize, 0.99999);
    float smoothstepHeight = smoothstep(0.0, atmosphereHeight, horizonDotNadir);
    vec3 belowHorizonColor = mix(vec3(0.1, 0.15, 0.25), vec3(0.4, 0.7, 0.9), smoothstepHeight);
    vec3 nadirColor = belowHorizonColor * 0.5;
    vec3 aboveHorizonColor = mix(vec3(0.9, 1.0, 1.2), belowHorizonColor, roughness * 0.5);
    vec3 blueSkyColor = mix(vec3(0.18, 0.26, 0.48), aboveHorizonColor, reflectionDotNadir * inverseRoughness * 0.5 + 0.75);
    vec3 zenithColor = mix(blueSkyColor, sceneSkyBox, smoothstepHeight);
    vec3 blueSkyDiffuseColor = vec3(0.7, 0.85, 0.9);
    float diffuseIrradianceFromEarth = (1.0 - horizonDotNadir) * (reflectionDotNadir * 0.25 + 0.75) * smoothstepHeight;
    float diffuseIrradianceFromSky = (1.0 - smoothstepHeight) * (1.0 - (reflectionDotNadir * 0.25 + 0.25));
    vec3 diffuseIrradiance = blueSkyDiffuseColor * clamp(diffuseIrradianceFromEarth + diffuseIrradianceFromSky, 0.0, 1.0);
    float notDistantRough = (1.0 - horizonDotNadir * roughness * 0.8);
    vec3 specularIrradiance = mix(zenithColor, aboveHorizonColor, smoothstep(farAboveHorizon, aroundHorizon, reflectionDotNadir) * notDistantRough);
    specularIrradiance = mix(specularIrradiance, belowHorizonColor, smoothstep(aroundHorizon, farBelowHorizon, reflectionDotNadir) * inverseRoughness);
    specularIrradiance = mix(specularIrradiance, nadirColor, smoothstep(farBelowHorizon, 1.0, reflectionDotNadir) * inverseRoughness);
    
    float LdotZenith = clamp(dot(normalize(czm_inverseViewRotation * czm_sunDirectionEC), normalize(positionWC * -1.0)), 0.001, 1.0);
    float S = acos(LdotZenith);
    float NdotZenith = clamp(dot(normalize(czm_inverseViewRotation * n), normalize(positionWC * -1.0)), 0.001, 1.0);
    float sunNdotL = clamp(dot(n, czm_sunDirectionEC), 0.001, 1.0);
    float gamma = acos(sunNdotL);
    float numerator = ((0.91 + 10.0 * exp(-3.0 * gamma) + 0.45 * pow(sunNdotL, 2.0)) * (1.0 - exp(-0.32 / NdotZenith)));
    float denominator = (0.91 + 10.0 * exp(-3.0 * S) + 0.45 * pow(LdotZenith,2.0)) * (1.0 - exp(-0.32));
    float luminance = 0.2 * (numerator / denominator);
    irradiance += diffuseIrradiance * luminance;
    radiance += specularIrradiance * luminance;
#endif
    irradiance *= uEnvMapIntensity;
    radiance *= uEnvMapIntensity;

    indirectSpecular_Physical(radiance, irradiance, geometry, material, reflectedLight);

#ifdef HAS_OCCLUSION_TEXTURE
    #ifdef USE_BatchPBR
        float ambientOcclusion = texture2DLodEXT(uOcclusionTexture, uv, mipmapLevel).r;
    #else
        float ambientOcclusion = texture2D(uOcclusionTexture, oriTexCoord.xy).r;
    #endif
    reflectedLight.indirectDiffuse *= ambientOcclusion;
#ifdef IBL
    reflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.roughness );
#endif
#endif

vec3 color = reflectedLight.directDiffuse + reflectedLight.directSpecular + reflectedLight.indirectDiffuse + reflectedLight.indirectSpecular;

#ifdef HAS_EMISSIVE_TEXTURE
    emissiveTexCoord = emissiveTexCoord * uEmissiveUVOffsetAndTiling.zw + uEmissiveUVOffsetAndTiling.xy;
    vec3 emissive = texture2D(uEmissionTexture, emissiveTexCoord).rgb;
    emissive *= emissiveFactor.rgb;
    color += emissive;
#else
    color += emissiveFactor.rgb;
#endif

    color = applyTonemapping(color);
    color = LinearTosRGB(color);
    
#ifdef MASK
    if (baseColorWithAlpha.a < uAlphaCutoff)
    {
        discard;
    }
    return vec4(color.rgb, 1.0);
#endif
    return vec4(color.rgb, baseColorWithAlpha.a);
}
#endif
`});var qQ,Qde=Ee(()=>{qQ=`
    #define cubeUV_minMipLevel 4.0
	#define cubeUV_minTileSize 16.0
	#ifdef WEBGL2
		#define texture2DGradEXT textureGrad 
	#endif

	// These shader functions convert between the UV coordinates of a single face of
	// a cubemap, the 0-5 integer index of a cube face, and the direction vector for
	// sampling a textureCube (not generally normalized ).

	float getFace( vec3 direction ) {

		vec3 absDirection = abs( direction );

		float face = - 1.0;

		if ( absDirection.x > absDirection.z ) {

			if ( absDirection.x > absDirection.y )

				face = direction.x > 0.0 ? 0.0 : 3.0;

			else

				face = direction.y > 0.0 ? 1.0 : 4.0;

		} else {

			if ( absDirection.z > absDirection.y )

				face = direction.z > 0.0 ? 2.0 : 5.0;

			else

				face = direction.y > 0.0 ? 1.0 : 4.0;

		}

		return face;

	}

	// RH coordinate system; PMREM face-indexing convention
	vec2 getUV( vec3 direction, float face ) {

		vec2 uv;

		if ( face == 0.0 ) {

			uv = vec2( direction.z, direction.y ) / abs( direction.x ); // pos x

		} else if ( face == 1.0 ) {

			uv = vec2( - direction.x, - direction.z ) / abs( direction.y ); // pos y

		} else if ( face == 2.0 ) {

			uv = vec2( - direction.x, direction.y ) / abs( direction.z ); // pos z

		} else if ( face == 3.0 ) {

			uv = vec2( - direction.z, direction.y ) / abs( direction.x ); // neg x

		} else if ( face == 4.0 ) {

			uv = vec2( - direction.x, direction.z ) / abs( direction.y ); // neg y

		} else {

			uv = vec2( direction.x, direction.y ) / abs( direction.z ); // neg z

		}

		return 0.5 * ( uv + 1.0 );

	}

	vec3 bilinearCubeUV( sampler2D envMap, vec3 direction, float mipInt ) {

		float face = getFace( direction );

		float filterInt = max( cubeUV_minMipLevel - mipInt, 0.0 );

		mipInt = max( mipInt, cubeUV_minMipLevel );

		float faceSize = exp2( mipInt );

		vec2 uv = getUV( direction, face ) * ( faceSize - 2.0 ) + 1.0;

		if ( face > 2.0 ) {

			uv.y += faceSize;

			face -= 3.0;

		}

		uv.x += face * faceSize;

		uv.x += filterInt * 3.0 * cubeUV_minTileSize;

		uv.y += 4.0 * ( exp2( CUBEUV_MAX_MIP ) - faceSize );

		uv.x *= CUBEUV_TEXEL_WIDTH;
		uv.y *= CUBEUV_TEXEL_HEIGHT;

		return texture2DGradEXT( envMap, uv, vec2( 0.0 ), vec2( 0.0 ) ).rgb; // disable anisotropic filtering

	}

	// These defines must match with PMREMGenerator

	#define cubeUV_r0 1.0
	#define cubeUV_v0 0.339
	#define cubeUV_m0 - 2.0
	#define cubeUV_r1 0.8
	#define cubeUV_v1 0.276
	#define cubeUV_m1 - 1.0
	#define cubeUV_r4 0.4
	#define cubeUV_v4 0.046
	#define cubeUV_m4 2.0
	#define cubeUV_r5 0.305
	#define cubeUV_v5 0.016
	#define cubeUV_m5 3.0
	#define cubeUV_r6 0.21
	#define cubeUV_v6 0.0038
	#define cubeUV_m6 4.0

	float roughnessToMip( float roughness ) {

		float mip = 0.0;

		if ( roughness >= cubeUV_r1 ) {

			mip = ( cubeUV_r0 - roughness ) * ( cubeUV_m1 - cubeUV_m0 ) / ( cubeUV_r0 - cubeUV_r1 ) + cubeUV_m0;

		} else if ( roughness >= cubeUV_r4 ) {

			mip = ( cubeUV_r1 - roughness ) * ( cubeUV_m4 - cubeUV_m1 ) / ( cubeUV_r1 - cubeUV_r4 ) + cubeUV_m1;

		} else if ( roughness >= cubeUV_r5 ) {

			mip = ( cubeUV_r4 - roughness ) * ( cubeUV_m5 - cubeUV_m4 ) / ( cubeUV_r4 - cubeUV_r5 ) + cubeUV_m4;

		} else if ( roughness >= cubeUV_r6 ) {

			mip = ( cubeUV_r5 - roughness ) * ( cubeUV_m6 - cubeUV_m5 ) / ( cubeUV_r5 - cubeUV_r6 ) + cubeUV_m5;

		} else {

			mip = - 2.0 * log2( 1.16 * roughness ); // 1.16 = 1.79^0.25
		}

		return mip;

	}

	vec4 textureCubeUV( sampler2D envMap, vec3 sampleDir, float roughness ) {

		float mip = clamp( roughnessToMip( roughness ), cubeUV_m0, CUBEUV_MAX_MIP );

		float mipF = fract( mip );

		float mipInt = floor( mip );

		vec3 color0 = bilinearCubeUV( envMap, sampleDir, mipInt );

		if ( mipF == 0.0 ) {

			return vec4( color0, 1.0 );

		} else {

			vec3 color1 = bilinearCubeUV( envMap, sampleDir, mipInt + 1.0 );

			return vec4( mix( color0, color1, mipF ), 1.0 );

		}

	}
`});var jQ,Xde=Ee(()=>{jQ=`
#ifdef HAS_MAPBOX_MAP

precision mediump sampler2DArray;

uniform sampler2D u_mapboxIndexTexture;
uniform sampler2D u_innerMapboxIndexTexture;//\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406
uniform sampler2D u_relativeBoundsTexture;
uniform sampler2DArray u_mapboxTileTextureArray;

vec2 calUVFromGeoBounds(vec2 geoCoord, vec4 geoBounds) {
    if(geoBounds.z > czm_pi && geoCoord.x < 0.0 ){
        geoCoord.x += czm_twoPi;
    }
    vec2 uv = geoCoord.xy - vec2(geoBounds.x, geoBounds.w);
    uv.x = uv.x / (geoBounds.z - geoBounds.x);
    uv.y = 1.0 - uv.y / (geoBounds.y - geoBounds.w);
    return uv;
}

bool isValidTexCoord(vec2 inUV){
    if(inUV.x < 0.0 || inUV.x > 1.0 || inUV.y < 0.0 || inUV.y > 1.0){
        return false;
    }
    return true;
}

//geoBounds's lng should be [-PI, 2PI]
bool isGeoPosInGeoBounds(vec2 geoTexCoord, vec4 mapboxGeoBounds){
    if(mapboxGeoBounds.z > czm_pi && geoTexCoord.x < 0.0){
        geoTexCoord.x += czm_twoPi;
    } 
   
    return geoTexCoord.x > mapboxGeoBounds.x &&
            geoTexCoord.x < mapboxGeoBounds.z &&
            geoTexCoord.y > mapboxGeoBounds.y &&
            geoTexCoord.y < mapboxGeoBounds.w;
    
}

bool isInInnerIndexTextureGeoBounds(vec2 geoTexCoord, vec4 innerIndexTextureGeoBounds){
    if(innerIndexTextureGeoBounds.x > innerIndexTextureGeoBounds.z || innerIndexTextureGeoBounds.y > innerIndexTextureGeoBounds.w){
        return false;
    }

    return isGeoPosInGeoBounds(geoTexCoord, innerIndexTextureGeoBounds);
}

vec4 calIndexByPointInsideGeoBounds(vec2 geoTexCoord, vec4 mapboxGeoBounds, vec4 innerIndexTextureGeoBounds){
    vec2 indexTextureCoord;
    vec4 indexTextureColor;
    //\u5224\u65AD\u8BE5\u70B9\u662F\u5426\u5728\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u7684\u8303\u56F4\u5185
    if(isInInnerIndexTextureGeoBounds(geoTexCoord, innerIndexTextureGeoBounds)){
        //\u8BE5\u70B9\u5728\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u7684\u8303\u56F4\u5185\uFF0C\u4ECE\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u53D6\u7D22\u5F15
        indexTextureCoord = calUVFromGeoBounds(geoTexCoord, innerIndexTextureGeoBounds);
        indexTextureColor = textureLod(u_innerMapboxIndexTexture, indexTextureCoord, 0.0);
       
        if(indexTextureColor.r == 0.0){
            //\u4ECE\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u91CC\u53D6\u4E0D\u5230\u7D22\u5F15\uFF0C\u5C31\u4ECE\u4E3B\u7EB9\u7406\u53D6
            indexTextureCoord = calUVFromGeoBounds(geoTexCoord, mapboxGeoBounds);
            indexTextureColor = textureLod(u_mapboxIndexTexture, indexTextureCoord, 0.0);
        }
    }else{
        //\u8BE5\u70B9\u4E0D\u5728\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u7684\u8303\u56F4\u5185\uFF0C\u4ECE\u4E3B\u7D22\u5F15\u7EB9\u7406\u53D6\u7D22\u5F15
        indexTextureCoord = calUVFromGeoBounds(geoTexCoord, mapboxGeoBounds);
        indexTextureColor = textureLod(u_mapboxIndexTexture, indexTextureCoord, 0.0);
    }
    return indexTextureColor;
}



struct MapboxMapParam {
    vec2 relativeTileBoundsCoord;
    vec4 tileBounds;
    vec4 mapboxGeoBounds;
    vec4 innerMapboxGeoBounds; //\u7CBE\u7EC6\u7D22\u5F15\u7EB9\u7406\u7684\u5730\u7406\u8303\u56F4
    float mapboxAlpha;
};

vec4 getMapboxMapColor(vec4 inColor, MapboxMapParam param){
    // \u8BA1\u7B97\u5F53\u524D\u70B9\u7684\u5730\u7406\u5750\u6807
    vec2 geoTexCoord = param.relativeTileBoundsCoord.xy;
    geoTexCoord.x = geoTexCoord.x * (param.tileBounds.z - param.tileBounds.x) + param.tileBounds.x;
    geoTexCoord.y = geoTexCoord.y * (param.tileBounds.w - param.tileBounds.y) + param.tileBounds.y;
    // \u5224\u65AD\u662F\u5426\u5728mapbox\u5730\u56FE\u8986\u76D6\u7684\u5730\u7406\u8303\u56F4\u5185
    if(isGeoPosInGeoBounds(geoTexCoord, param.mapboxGeoBounds))
        {
            // \u8BA1\u7B97\u5728mapbox\u7D22\u5F15\u7EB9\u7406\u4E0A\u7684\u5750\u6807\u5E76\u83B7\u5F97\u5F53\u524D\u70B9\u5728mapbox\u7684tile\u7684\u7EB9\u7406\u6570\u7EC4\u4E2D\u7684\u7D22\u5F15\u53F7
            vec4 indexTextureColor = calIndexByPointInsideGeoBounds(geoTexCoord, param.mapboxGeoBounds, param.innerMapboxGeoBounds);
            if(indexTextureColor.r > 0.0)
            {
                float textureIndex = floor(indexTextureColor.r);
                // \u8BA1\u7B97\u5F53\u524D\u70B9\u5728mapbox\u7684tile\u7EB9\u7406\u4E2D\u7684\u5750\u6807\u5E76\u83B7\u53D6\u6700\u7EC8\u989C\u8272
                vec4 mapboxTileRelativeBounds = texelFetch(u_relativeBoundsTexture, ivec2(textureIndex , 0), 0);
                vec2 mapboxTileTextureCoord = (param.relativeTileBoundsCoord.xy - mapboxTileRelativeBounds.rg) / mapboxTileRelativeBounds.ba;

                if(!isValidTexCoord(mapboxTileTextureCoord)){
                    for(int i = 0; i < MAXBOX_TILE_TEXTURE_SIZE; i++){
                        mapboxTileRelativeBounds = texelFetch(u_relativeBoundsTexture, ivec2(i , 0), 0);
                        mapboxTileTextureCoord = (param.relativeTileBoundsCoord.xy - mapboxTileRelativeBounds.rg) / mapboxTileRelativeBounds.ba;
                        if(isValidTexCoord(mapboxTileTextureCoord)){
                            textureIndex = float(i);
                            break;
                        }
                    }
                }
                // return vec4(1.0, .0, 0., 0.5);
#ifdef WEBGPU
                vec4 mapboxColor = textureLod(u_mapboxTileTextureArray, vec3(mapboxTileTextureCoord, textureIndex), 0.0);
#else

                vec4 mapboxColor = texture(u_mapboxTileTextureArray, vec3(mapboxTileTextureCoord, textureIndex));
#endif
                if(mapboxColor.a < 0.001){
                    return inColor;
                }
                vec4 blendColor = inColor;
                float finalApha = param.mapboxAlpha * mapboxColor.a;
                blendColor.rgb = mapboxColor.rgb * param.mapboxAlpha + inColor.rgb * (1.0 -finalApha);
                return blendColor;
            }
    }
    return inColor;
}
#endif


`});var YQ,Kde=Ee(()=>{YQ=`
    varying vec2 v_clippingPosition;
    flat varying int v_regionIndex;
    uniform highp sampler2D u_clippingExtentsTexture;
    uniform highp int uClippingPolygonRegionsLength;
    vec2 getLookupUv(vec2 dimensions, int i) {
        int pixY = i / int(dimensions.x);
        int pixX = i - (pixY * int(dimensions.x));
        float pixelWidth = 1.0 / dimensions.x;
        float pixelHeight = 1.0 / dimensions.y;
        float u = (float(pixX) + 0.5) * pixelWidth; // sample from center of pixel
        float v = (float(pixY) + 0.5) * pixelHeight;
        return vec2(u, v);
    }

    vec4 unpackClippingExtents(highp sampler2D extentsTexture, int index) {
        vec2 textureDimensions = vec2(textureSize(extentsTexture, 0));
        return texture(extentsTexture, getLookupUv(textureDimensions, index));
    }

    void calcClipRegionIndexAndUV(vec3 positionWC) {
        #ifdef SCENE3D
            vec2 sphericalLatLong = czm_approximateSphericalCoordinates(positionWC);
        #else
            vec2 sphericalLatLong = vec2(positionWC.z / 6378137.0, positionWC.y / 6378137.0);
        #endif
        sphericalLatLong.y = czm_branchFreeTernary(sphericalLatLong.y < czm_pi, sphericalLatLong.y, sphericalLatLong.y - czm_twoPi);
    
        vec2 minDistance = vec2(czm_infinity);
        v_regionIndex = -1;
        v_clippingPosition = vec2(czm_infinity);
    
        for (int regionIndex = 0; regionIndex < uClippingPolygonRegionsLength; regionIndex++) {
            vec4 extents = unpackClippingExtents(u_clippingExtentsTexture, regionIndex);
            vec2 rectUv = (sphericalLatLong.yx - extents.yx) * extents.wz;
    
            vec2 clamped = clamp(rectUv, vec2(0.0), vec2(1.0));
            vec2 distance = abs(rectUv - clamped) * extents.wz;
            
            if (minDistance.x > distance.x || minDistance.y > distance.y) {
                minDistance = distance;
                v_clippingPosition = rectUv;
            }
    
            float threshold = 0.01;
            if (rectUv.x > threshold && rectUv.y > threshold && rectUv.x < 1.0 - threshold && rectUv.y < 1.0 - threshold) {
                v_regionIndex = regionIndex;
            }
        }
    }
`});var QQ,Zde=Ee(()=>{QQ=`
uniform highp sampler2D u_SignedDistanceTexture;
uniform highp sampler2D u_clippingExtentsTexture;
uniform vec2 u_SignedDistanceTextureSize;
uniform highp int uClippingPolygonRegionsLength;
uniform float uExtentsDimension;
varying vec3 v_positionMC;

float getSignedDistance(vec2 uv) {
    float signedDistance = czm_unpackDepth(textureLod(u_SignedDistanceTexture, uv, 0.0));
    return (signedDistance - 0.5) * 2.0;
}

vec2 getLookupUv(vec2 dimensions, int i) {
    int pixY = i / int(dimensions.x);
    int pixX = i - (pixY * int(dimensions.x));
    float pixelWidth = 1.0 / dimensions.x;
    float pixelHeight = 1.0 / dimensions.y;
    float u = (float(pixX) + 0.5) * pixelWidth; // sample from center of pixel
    float v = (float(pixY) + 0.5) * pixelHeight;
    return vec2(u, v);
}

vec4 unpackClippingExtents(int index) {
    vec2 textureDim = vec2(textureSize(u_clippingExtentsTexture, 0));
    return texture(u_clippingExtentsTexture, getLookupUv(textureDim, index));
}

void calcClipRegionIndexAndUV(vec3 positionMC, out vec2 clippingPosition, out int outRegionIndex) {
    vec2 minDistance = vec2(czm_infinity);
    outRegionIndex = -1;
    clippingPosition = vec2(czm_infinity);

    for (int regionIndex = 0; regionIndex < uClippingPolygonRegionsLength; regionIndex++) {
        vec4 extents = unpackClippingExtents(regionIndex);
        vec2 rectUv = (positionMC.xy - extents.xy) * extents.zw;

        vec2 clamped = clamp(rectUv, vec2(0.0), vec2(1.0));
        vec2 distance = abs(rectUv - clamped) * extents.zw;
        
        float threshold = 0.01;
        if (minDistance.x > distance.x || minDistance.y > distance.y) {
            minDistance = distance;
            if (rectUv.x > threshold && rectUv.y > threshold && rectUv.x < 1.0 - threshold && rectUv.y < 1.0 - threshold) {
                outRegionIndex = regionIndex;
                clippingPosition = rectUv;
            }
        }
        
    }
}
    
void clipPolygons() {
    // Position is completely outside of polygons bounds
    vec2 rectUv;
    int regionIndex;
    calcClipRegionIndexAndUV(v_positionMC, rectUv, regionIndex);
    if (regionIndex < 0 || rectUv.x <= 0.0 || rectUv.y <= 0.0 || rectUv.x >= 1.0 || rectUv.y >= 1.0) {
        #ifdef CLIPPING_INVERSE 
            discard;
        #endif
        return;
    }

    vec2 sampleOffset = max(1.0 / u_SignedDistanceTextureSize, vec2(0.005));
    float dimension = uExtentsDimension;

    vec2 textureOffset = vec2(mod(float(regionIndex), dimension), floor(float(regionIndex) / dimension)) / dimension;
    vec2 uv = textureOffset + rectUv / dimension;

    float signedDistance = getSignedDistance(uv);

    #ifdef CLIPPING_INVERSE
    if (signedDistance > 0.0)  {
        discard;
    }
    #else
    if (signedDistance < 0.0)  {
        discard;
    }
    #endif
}
`});var XQ,Jde=Ee(()=>{XQ=`
#ifdef LOG_DEPTH
varying float v_depthFromNearPlusOne;
#endif
#ifdef POLYGON_OFFSET
uniform vec4 uPolygonOffset;
#endif

void writeLogDepth(float depth)
{
#ifdef LOG_DEPTH
#if defined(GL_EXT_frag_depth) || defined(WEBGL2)
    if (depth <= 0.9999999 || depth > czm_farDepthFromNearPlusOne) {
        discard;
    }
#ifdef POLYGON_OFFSET
    float factor = uPolygonOffset.z;
    float units = uPolygonOffset.w;

#if defined(GL_OES_standard_derivatives) || defined(WEBGL2)
    float x = dFdx(depth);
    float y = dFdy(depth);
    float m = sqrt(x * x + y * y);
    depth += m * factor;
#endif

#endif

    gl_FragDepthEXT = log2(depth) * czm_oneOverLog2FarDepthFromNearPlusOne;
#ifdef POLYGON_OFFSET
    gl_FragDepthEXT += czm_epsilon7 * units;
#endif

#endif
#endif
}

`});var kRt,KQ,$de=Ee(()=>{kde();Ude();Gde();Hde();Wde();qde();jde();Yde();Qde();Xde();Kde();Zde();Jde();kRt={rainDecl:NQ,snowDecl:zQ,hemisphereLightDecl:VQ,pointLightDecl:kQ,spotLightDecl:UQ,directionLightDecl:GQ,lightSourceImpl:HQ,brdf:WQ,cubeUV_reflection:qQ,getMapboxColor:jQ,clipPolygonsVS:YQ,clipPolygonsFS:QQ,writeLogDepthDecl:XQ},KQ=kRt});function j8e(e){return e=e.replace(/\/\/.*/g,""),e.replace(/\/\*\*[\s\S]*?\*\//gm,function(r){for(var n=r.match(/\n/gm).length,o="",a=0;a<n;++a)o+=`
`;return o})}function Y8e(e,r,n){for(var o,a=0;a<n.length;++a)n[a].name===e&&(o=n[a]);return p(o)||(r=j8e(r),o={name:e,glslSource:r,dependsOn:[],requiredBy:[],evaluated:!1},n.push(o)),o}function Q8e(e,r){if(!e.evaluated){e.evaluated=!0;var n=e.glslSource.match(/\bczm_[a-zA-Z0-9_]*/g);p(n)&&n!==null&&(n=n.filter(function(o,a){return n.indexOf(o)===a}),n.forEach(function(o){if(o!==e.name&&Qc._czmBuiltinsAndUniforms.hasOwnProperty(o)){var a=Y8e(o,Qc._czmBuiltinsAndUniforms[o],r);e.dependsOn.push(a),a.requiredBy.push(e),Q8e(a,r)}}))}}function URt(e){for(var r=[],n=[];e.length>0;){var o=e.pop();n.push(o),o.requiredBy.length===0&&r.push(o)}for(;r.length>0;){var a=r.shift();e.push(a);for(var s=0;s<a.dependsOn.length;++s){var l=a.dependsOn[s],h=l.requiredBy.indexOf(a);l.requiredBy.splice(h,1),l.requiredBy.length===0&&r.push(l)}}for(var x=[],m=0;m<n.length;++m)n[m].requiredBy.length!==0&&x.push(n[m]);if(x.length!==0){for(var v=`A circular dependency was found in the following built-in functions/structs/constants: 
`,_=0;_<x.length;++_)v=v+x[_].name+`
`;throw new G(v)}}function GRt(e,r,n){var o=[],a=Y8e("main",r,o);Q8e(a,o),URt(o);for(var s="",l=o.length-1;l>=0;--l)X8e(n,e)&&(o[l].glslSource=FH.removeUnuseMacroCode(n,e,o[l].glslSource)),s=s+o[l].glslSource+`
`;return s.replace(a.glslSource,"")}function X8e(e,r){return!(!p(e)||!p(r)||!e.shaderPreprocess)}function K8e(e){var r=/^[ \t]*#include +<([\w\d./]+)>/gm;function n(o,a){var s=KQ[a];if(s===void 0)throw new Error("Can not resolve #include <"+a+">");return K8e(s)}return y(n,"replace"),e.replace(r,n)}function Z8e(e,r,n){var o,a,s="",l=e.sources;if(p(l))for(o=0,a=l.length;o<a;++o)s+=`
#line 0
`+l[o];s=j8e(s);var h;s=s.replace(/#version\s+(.*?)\n/gm,function(S,P){if(p(h)&&h!==P)throw new G("inconsistent versions found: "+h+" and "+P);return h=P,`
`});var x=[];s=s.replace(/#extension.*\n/gm,function(S){return x.push(S),`
`}),s=s.replace(/precision\s(lowp|mediump|highp)\s(float|int);/,"");var m=e.pickColorQualifier;p(m)&&(s=Qc.createPickFragmentShaderSource(s,m));var v="";p(h)&&(v="#version "+h+`
`);var _=x.length;for(o=0;o<_;o++)v+=x[o];r&&(v+=`#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif

`);var A=e.defines;if(p(A))for(o=0,a=A.length;o<a;++o){var T=A[o];T.length!==0&&(v+="#define "+T+`
`)}if(n.webgl2&&(v+=`#define OUTPUT_DECLARATION

`,v+=`#define WEBGL2

`,v+=`#define texture2DLodEXT textureLod

`,v+=`#define texture2DGradEXT textureGrad

`),s=K8e(s),n.textureFloatLinear&&(v+=`#define OES_texture_float_linear

`),X8e(n,e)&&(s=FH.removeUnuseMacroCode(n,e,s)),e.includeBuiltIns){var w=GRt(e,s,n);for(x.length=0,w=w.replace(/#extension.*\n/gm,function(S){return x.push(S),`
`}),_=x.length,o=0;o<_;o++)v=x[o]+v;v+=w}return v+=`
#line 0
`,v+=s,n.webgl2&&(v=OQ(v,r,!0)),v}function Qc(e){e=B(e,B.EMPTY_OBJECT);var r=e.pickColorQualifier;if(p(r)&&r!=="uniform"&&r!=="varying")throw new G("options.pickColorQualifier must be 'uniform' or 'varying'.");this.defines=p(e.defines)?e.defines.slice(0):[],this.sources=p(e.sources)?e.sources.slice(0):[],this.pickColorQualifier=r,this.includeBuiltIns=B(e.includeBuiltIns,!0),this.name=p(e.name)?e.name:void 0}var ZQ,eme,NH,HRt,WRt,yt,bn=Ee(()=>{Ze();De();st();Nde();MQ();Vde();q8e();ou();$de();y(j8e,"removeComments");y(Y8e,"getDependencyNode");y(Q8e,"generateDependencies");y(URt,"sortDependencies");y(GRt,"getBuiltinsAndAutomaticUniforms");y(X8e,"isNeedPreprocess");y(K8e,"parseIncludes");y(Z8e,"combineShader");y(Qc,"ShaderSource");Qc.prototype.clone=function(){return new Qc({sources:this.sources,defines:this.defines,name:this.name,pickColorQualifier:this.pickColorQualifier,includeBuiltIns:this.includeBuiltIns})};Qc.replaceMain=function(e,r){return r="void "+r+"()",e.replace(/void\s+main\s*\(\s*(?:void)?\s*\)/g,r)};Qc.prototype.getCacheKey=function(e){let n=this.defines.slice().sort().join(","),o=this.pickColorQualifier||"",a=this.includeBuiltIns,s=this.sources.join(`
`);return`${n}:${o}:${s}`};Qc.prototype.createCombinedVertexShader=function(e){return Z8e(this,!1,e)};Qc.prototype.createCombinedFragmentShader=function(e){return Z8e(this,!0,e)};Qc._czmBuiltinsAndUniforms={};for(ZQ in FQ)FQ.hasOwnProperty(ZQ)&&(Qc._czmBuiltinsAndUniforms[ZQ]=FQ[ZQ]);for(NH in VS)VS.hasOwnProperty(NH)&&(eme=VS[NH],typeof eme.getDeclaration=="function"&&(Qc._czmBuiltinsAndUniforms[NH]=eme.getDeclaration(NH)));Qc.createPickVertexShaderSource=function(e){var r=Qc.replaceMain(e,"czm_old_main"),n=`attribute vec4 pickColor; 
varying vec4 czm_pickColor; 
void main() 
{ 
    czm_old_main(); 
    czm_pickColor = pickColor; 
}`;return r+`
`+n};Qc.createPickFragmentShaderSource=function(e,r){var n=Qc.replaceMain(e,"czm_old_main"),o=r+` vec4 czm_pickColor; 
void main() 
{ 
    czm_old_main(); 
    if (gl_FragColor.a == 0.0) { 
       discard; 
    } 
    gl_FragColor = czm_pickColor; 
}`;return n+`
`+o};Qc.findVarying=function(e,r){for(var n=e.sources,o=r.length,a=0;a<o;++a)for(var s=r[a],l=n.length,h=0;h<l;++h)if(n[h].indexOf(s)!==-1)return s};HRt=["v_normalEC","v_normal","aNormal"];Qc.findNormalVarying=function(e){return Qc.findVarying(e,HRt)};WRt=["v_positionEC"];Qc.findPositionVarying=function(e){return Qc.findVarying(e,WRt)};yt=Qc});function Ag(e){if(e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context),!p(e.typedArray)&&!p(e.sizeInBytes))throw new G("Either options.sizeInBytes or options.typedArray is required.");if(p(e.typedArray)&&p(e.sizeInBytes))throw new G("Cannot pass in both options.sizeInBytes and options.typedArray.");if(p(e.typedArray)&&(X.typeOf.object("options.typedArray",e.typedArray),X.typeOf.number("options.typedArray.byteLength",e.typedArray.byteLength)),!Nt.validate(e.usage))throw new G("usage is invalid.");var r=e.context._gl,n=e.bufferTarget,o=e.typedArray,a=e.sizeInBytes,s=e.usage,l=p(o);l&&(a=o.byteLength),X.typeOf.number.greaterThan("sizeInBytes",a,0);var h=r.createBuffer();r.bindBuffer(n,h),r.bufferData(n,l?o:a,s),r.bindBuffer(n,null),this._gl=r,this._webgl2=e.context._webgl2,this._bufferTarget=n,this._sizeInBytes=a,this._usage=s,this._buffer=h,this.vertexArrayDestroyable=!0,this.context=e.context,e.context.memorySize+=a}var or,Vo=Ee(()=>{cr();Ze();De();ur();st();_n();co();io();y(Ag,"Buffer");Ag.createVertexBuffer=function(e){return X.defined("options.context",e.context),new Ag({context:e.context,bufferTarget:Se.ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage})};Ag.createIndexBuffer=function(e){if(X.defined("options.context",e.context),!tr.validate(e.indexDatatype))throw new G("Invalid indexDatatype.");if(e.indexDatatype===tr.UNSIGNED_INT&&!e.context.elementIndexUint)throw new G("IndexDatatype.UNSIGNED_INT requires OES_element_index_uint, which is not supported on this system.  Check context.elementIndexUint.");var r=e.context,n=e.indexDatatype,o=tr.getSizeInBytes(n),a=new Ag({context:r,bufferTarget:Se.ELEMENT_ARRAY_BUFFER,typedArray:e.typedArray,sizeInBytes:e.sizeInBytes,usage:e.usage}),s=a.sizeInBytes/o;return Object.defineProperties(a,{indexDatatype:{get:function(){return n}},bytesPerIndex:{get:function(){return o}},numberOfIndices:{get:function(){return s}}}),a};Object.defineProperties(Ag.prototype,{sizeInBytes:{get:function(){return this._sizeInBytes}},usage:{get:function(){return this._usage}}});Ag.prototype._getBuffer=function(){return this._buffer};Ag.prototype.copyFromArrayView=function(e,r){r=B(r,0),X.defined("arrayView",e),X.typeOf.number.lessThanOrEquals("offsetInBytes + arrayView.byteLength",r+e.byteLength,this._sizeInBytes);var n=this._gl,o=this._bufferTarget;n.bindBuffer(o,this._buffer),n.bufferSubData(o,r,e),n.bindBuffer(o,null)};Ag.prototype.copyFromBuffer=function(e,r,n,o){if(!this._webgl2)throw new G("A WebGL 2 context is required.");if(!p(e))throw new G("readBuffer must be defined.");if(!p(o)||o<=0)throw new G("sizeInBytes must be defined and be greater than zero.");if(!p(r)||r<0||r+o>e._sizeInBytes)throw new G("readOffset must be greater than or equal to zero and readOffset + sizeInBytes must be less than of equal to readBuffer.sizeInBytes.");if(!p(n)||n<0||n+o>this._sizeInBytes)throw new G("writeOffset must be greater than or equal to zero and writeOffset + sizeInBytes must be less than of equal to this.sizeInBytes.");if(this._buffer===e._buffer&&(n>=r&&n<r+o||r>n&&r<n+o))throw new G("When readBuffer is equal to this, the ranges [readOffset + sizeInBytes) and [writeOffset, writeOffset + sizeInBytes) must not overlap.");if(this._bufferTarget===Se.ELEMENT_ARRAY_BUFFER&&e._bufferTarget!==Se.ELEMENT_ARRAY_BUFFER||this._bufferTarget!==Se.ELEMENT_ARRAY_BUFFER&&e._bufferTarget===Se.ELEMENT_ARRAY_BUFFER)throw new G("Can not copy an index buffer into another buffer type.");var a=Se.COPY_READ_BUFFER,s=Se.COPY_WRITE_BUFFER,l=this._gl;l.bindBuffer(s,this._buffer),l.bindBuffer(a,e._buffer),l.copyBufferSubData(a,s,r,n,o),l.bindBuffer(s,null),l.bindBuffer(a,null)};Ag.prototype.getBufferData=function(e,r,n,o){if(r=B(r,0),n=B(n,0),!this._webgl2)throw new G("A WebGL 2 context is required.");if(!p(e))throw new G("arrayView is required.");var a,s,l=e.byteLength;if(p(o)?(a=o,p(l)?s=1:(l=e.length,s=e.BYTES_PER_ELEMENT)):p(l)?(a=l-n,s=1):(l=e.length,a=l-n,s=e.BYTES_PER_ELEMENT),n<0||n>l)throw new G("destinationOffset must be greater than zero and less than the arrayView length.");if(n+a>l)throw new G("destinationOffset + length must be less than or equal to the arrayViewLength.");if(r<0||r>this._sizeInBytes)throw new G("sourceOffset must be greater than zero and less than the buffers size.");if(r+a*s>this._sizeInBytes)throw new G("sourceOffset + length must be less than the buffers size.");var h=this._gl,x=Se.COPY_READ_BUFFER;h.bindBuffer(x,this._buffer),h.getBufferSubData(x,r,e,n,o),h.bindBuffer(x,null)};Ag.prototype.isDestroyed=function(){return!1};Ag.prototype.destroy=function(){return this._gl.deleteBuffer(this._buffer),this.context.memorySize-=this.sizeInBytes,$e(this)};or=Ag});function qRt(e,r,n,o){var a=p(r.vertexBuffer),s=p(r.value),l=r.value?r.value.length:r.componentsPerAttribute;if(!a&&!s)throw new G("attribute must have a vertexBuffer or a value.");if(a&&s)throw new G("attribute cannot have both a vertexBuffer and a value.  It must have either a vertexBuffer property defining per-vertex data or a value property defining data for all vertices.");if(l!==1&&l!==2&&l!==3&&l!==4)throw s?new G("attribute.value.length must be in the range [1, 4]."):new G("attribute.componentsPerAttribute must be in the range [1, 4].");if(p(r.componentDatatype)&&!Ie.validate(r.componentDatatype))throw new G("attribute must have a valid componentDatatype or not specify it.");if(p(r.strideInBytes)&&r.strideInBytes>255)throw new G("attribute must have a strideInBytes less than or equal to 255 or not specify it.");if(p(r.instanceDivisor)&&r.instanceDivisor>0&&!o.instancedArrays)throw new G("instanced arrays is not supported");if(p(r.instanceDivisor)&&r.instanceDivisor<0)throw new G("attribute must have an instanceDivisor greater than or equal to zero");if(p(r.instanceDivisor)&&s)throw new G("attribute cannot have have an instanceDivisor if it is not backed by a buffer");if(p(r.instanceDivisor)&&r.instanceDivisor>0&&r.index===0)throw new G("attribute zero cannot have an instanceDivisor greater than 0");var h={index:B(r.index,n),enabled:B(r.enabled,!0),vertexBuffer:r.vertexBuffer,value:s?r.value.slice(0):void 0,componentsPerAttribute:l,componentDatatype:B(r.componentDatatype,Ie.FLOAT),normalize:B(r.normalize,!1),offsetInBytes:B(r.offsetInBytes,0),strideInBytes:B(r.strideInBytes,0),instanceDivisor:B(r.instanceDivisor,0)};if(a)h.vertexAttrib=function(x){var m=this.index;x.bindBuffer(x.ARRAY_BUFFER,this.vertexBuffer._getBuffer()),x.vertexAttribPointer(m,this.componentsPerAttribute,this.componentDatatype,this.normalize,this.strideInBytes,this.offsetInBytes),x.enableVertexAttribArray(m),this.instanceDivisor>0&&(o.glVertexAttribDivisor(m,this.instanceDivisor),o._vertexAttribDivisors[m]=this.instanceDivisor,o._previousDrawInstanced=!0)},h.disableVertexAttribArray=function(x){x.disableVertexAttribArray(this.index),this.instanceDivisor>0&&o.glVertexAttribDivisor(n,0)};else{switch(h.componentsPerAttribute){case 1:h.vertexAttrib=function(x){x.vertexAttrib1fv(this.index,this.value)};break;case 2:h.vertexAttrib=function(x){x.vertexAttrib2fv(this.index,this.value)};break;case 3:h.vertexAttrib=function(x){x.vertexAttrib3fv(this.index,this.value)};break;case 4:h.vertexAttrib=function(x){x.vertexAttrib4fv(this.index,this.value)};break}h.disableVertexAttribArray=function(x){}}e.push(h)}function $8e(e,r,n){for(var o=0;o<r.length;++o){var a=r[o];a.enabled&&a.vertexAttrib(e)}p(n)&&e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n._getBuffer())}function h1(e){e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context),X.defined("options.attributes",e.attributes);var r=e.context,n=r._gl,o=e.attributes,a=e.indexBuffer,s,l=[],h=1,x=!1,m=!1,v=o.length;for(s=0;s<v;++s)qRt(l,o[s],s,r);for(v=l.length,s=0;s<v;++s){var _=l[s];if(p(_.vertexBuffer)&&_.instanceDivisor===0){var A=_.strideInBytes||_.componentsPerAttribute*Ie.getSizeInBytes(_.componentDatatype);h=_.vertexBuffer.sizeInBytes/A;break}}for(s=0;s<v;++s)l[s].instanceDivisor>0&&(x=!0),p(l[s].value)&&(m=!0);var T={};for(s=0;s<v;++s){var w=l[s].index;if(T[w])throw new G("Index "+w+" is used by more than one attribute.");T[w]=!0}var S;r.vertexArrayObject&&(S=r.glCreateVertexArray(),r.glBindVertexArray(S),$8e(n,l,a),r.glBindVertexArray(null)),this._numberOfVertices=h,this._hasInstancedAttributes=x,this._hasConstantAttributes=m,this._context=r,this._gl=n,this._vao=S,this._attributes=l,this._indexBuffer=a}function J8e(e){return e.values.length/e.componentsPerAttribute}function jRt(e){return Ie.getSizeInBytes(e.componentDatatype)*e.componentsPerAttribute}function YRt(e){var r,n,o,a=[];for(n in e)e.hasOwnProperty(n)&&p(e[n])&&p(e[n].values)&&(a.push(n),e[n].componentDatatype===Ie.DOUBLE&&(e[n].componentDatatype=Ie.FLOAT,e[n].values=Ie.createTypedArray(Ie.FLOAT,e[n].values)));var s,l=a.length;if(l>0)for(s=J8e(e[a[0]]),r=1;r<l;++r){var h=J8e(e[a[r]]);if(h!==s)throw new Ht("Each attribute list must have the same number of vertices.  Attribute "+a[r]+" has a different number of vertices ("+h.toString()+") than attribute "+a[0]+" ("+s.toString()+").")}a.sort(function(k,z){return Ie.getSizeInBytes(e[z].componentDatatype)-Ie.getSizeInBytes(e[k].componentDatatype)});var x=0,m={};for(r=0;r<l;++r)n=a[r],o=e[n],m[n]=x,x+=jRt(o);if(x>0){var v=Ie.getSizeInBytes(e[a[0]].componentDatatype),_=x%v;_!==0&&(x+=v-_);var A=s*x,T=new ArrayBuffer(A),w={};for(r=0;r<l;++r){n=a[r];var S=Ie.getSizeInBytes(e[n].componentDatatype);w[n]={pointer:Ie.createTypedArray(e[n].componentDatatype,T),index:m[n]/S,strideInComponentType:x/S}}for(r=0;r<s;++r)for(var P=0;P<l;++P){n=a[P],o=e[n];for(var M=o.values,L=w[n],R=L.pointer,O=o.componentsPerAttribute,N=0;N<O;++N)R[L.index+N]=M[r*O+N];L.index+=L.strideInComponentType}return{buffer:T,offsetsInBytes:m,vertexSizeInBytes:x}}}function QRt(e){var r=e._context,n=e._hasInstancedAttributes;if(!(!n&&!r._previousDrawInstanced)){r._previousDrawInstanced=n;var o=r._vertexAttribDivisors,a=e._attributes,s=fi.maximumVertexAttributes,l;if(n){var h=a.length;for(l=0;l<h;++l){var x=a[l];if(x.enabled){var m=x.instanceDivisor,v=x.index;m!==o[v]&&(r.glVertexAttribDivisor(v,m),o[v]=m)}}}else for(l=0;l<s;++l)o[l]>0&&(r.glVertexAttribDivisor(l,0),o[l]=0)}}function XRt(e,r){for(var n=e._attributes,o=n.length,a=0;a<o;++a){var s=n[a];s.enabled&&p(s.value)&&s.vertexAttrib(r)}}var zr,Co=Ee(()=>{cr();mi();Ze();De();ur();st();gs();_n();nr();zo();Vo();io();Pl();y(qRt,"addAttribute");y($8e,"bind");y(h1,"VertexArray");y(J8e,"computeNumberOfVertices");y(jRt,"computeAttributeSizeInBytes");y(YRt,"interleaveAttributes");h1.fromGeometry=function(e){e=B(e,B.EMPTY_OBJECT),X.defined("options.context",e.context);var r=e.context,n=B(e.geometry,B.EMPTY_OBJECT),o=B(e.bufferUsage,Nt.DYNAMIC_DRAW),a=B(e.attributeLocations,B.EMPTY_OBJECT),s=B(e.interleave,!1),l=e.vertexArrayAttributes,h,x,m,v=p(l)?l:[],_=n.attributes;if(s){var A=YRt(_);if(p(A)){m=or.createVertexBuffer({context:r,typedArray:A.buffer,usage:o});var T=A.offsetsInBytes,w=A.vertexSizeInBytes;for(h in _)_.hasOwnProperty(h)&&p(_[h])&&(x=_[h],p(x.values)?v.push({index:a[h],vertexBuffer:m,componentDatatype:x.componentDatatype,componentsPerAttribute:x.componentsPerAttribute,normalize:x.normalize,offsetInBytes:T[h],strideInBytes:w}):v.push({index:a[h],value:x.value,componentDatatype:x.componentDatatype,normalize:x.normalize}))}}else for(h in _)if(_.hasOwnProperty(h)&&p(_[h])){x=_[h];var S=x.componentDatatype;S===Ie.DOUBLE&&(S=Ie.FLOAT),m=void 0,p(x.values)&&(m=or.createVertexBuffer({context:r,typedArray:Ie.createTypedArray(S,x.values),usage:o})),v.push({index:a[h],vertexBuffer:m,value:x.value,componentDatatype:S,componentsPerAttribute:x.componentsPerAttribute,normalize:x.normalize})}var P,M=n.indices;return p(M)&&(Ei.computeNumberOfVertices(n)>=K.SIXTY_FOUR_KILOBYTES&&r.elementIndexUint?P=or.createIndexBuffer({context:r,typedArray:new Uint32Array(M),usage:o,indexDatatype:tr.UNSIGNED_INT}):P=or.createIndexBuffer({context:r,typedArray:new Uint16Array(M),usage:o,indexDatatype:tr.UNSIGNED_SHORT})),new h1({context:r,attributes:v,indexBuffer:P})};Object.defineProperties(h1.prototype,{numberOfAttributes:{get:function(){return this._attributes.length}},numberOfVertices:{get:function(){return this._numberOfVertices}},indexBuffer:{get:function(){return this._indexBuffer}}});h1.prototype.getAttribute=function(e){return X.defined("index",e),this._attributes[e]};y(QRt,"setVertexAttribDivisor");y(XRt,"setConstantAttributes");h1.prototype._bind=function(){p(this._vao)?(this._context.glBindVertexArray(this._vao),this._context.instancedArrays&&QRt(this),this._hasConstantAttributes&&XRt(this,this._gl)):$8e(this._gl,this._attributes,this._indexBuffer)};h1.prototype._unBind=function(){if(p(this._vao))this._context.glBindVertexArray(null);else{for(var e=this._attributes,r=this._gl,n=0;n<e.length;++n){var o=e[n];o.enabled&&o.disableVertexAttribArray(r)}this._indexBuffer&&r.bindBuffer(r.ELEMENT_ARRAY_BUFFER,null)}};h1.prototype.isDestroyed=function(){return!1};h1.prototype.destroy=function(){for(var e=this._attributes,r=0;r<e.length;++r){var n=e[r].vertexBuffer;p(n)&&!n.isDestroyed()&&n.vertexArrayDestroyable&&n.destroy()}var o=this._indexBuffer;return p(o)&&!o.isDestroyed()&&o.vertexArrayDestroyable&&o.destroy(),p(this._vao)&&this._context.glDeleteVertexArray(this._vao),$e(this)};zr=h1});function HC(e,r,n){if(!p(e))throw new G("context is required");if(!p(r))throw new G("attributes is required");if(!p(n))throw new G("numberOfInstances is required");if(this._attributes=r,this._numberOfInstances=n,r.length!==0){var o=KRt(r),a=e.floatingPointTexture,s=o===Gt.FLOAT&&!a,l=ZRt(r,s),h=JRt(l,r,s),x=Math.floor(fi.maximumTextureSize/h),m=Math.min(n,x),v=h*m,_=Math.ceil(n/m),A=1/v,T=A*.5,w=1/_,S=w*.5;this._textureDimensions=new de(v,_),this._textureStep=new Ce(A,T,w,S),this._pixelDatatype=s?Gt.UNSIGNED_BYTE:o,this._packFloats=s,this._offsets=l,this._stride=h,this._texture=void 0;var P=4*v*_;this._batchValues=o===Gt.FLOAT&&!s?new Float32Array(P):new Uint8Array(P),this._batchValuesDirty=!1,this._suffix=""}}function KRt(e){for(var r=!1,n=e.length,o=0;o<n;++o)if(e[o].componentDatatype!==Ie.UNSIGNED_BYTE){r=!0;break}return r?Gt.FLOAT:Gt.UNSIGNED_BYTE}function t6e(e,r){var n=e[r].componentsPerAttribute;return n===2?de:n===3?E:n===4?Ce:Number}function ZRt(e,r){for(var n=new Array(e.length),o=0,a=e.length,s=0;s<a;++s){var l=e[s],h=l.componentDatatype;n[s]=o,h!==Ie.UNSIGNED_BYTE&&r?o+=4:++o}return n}function JRt(e,r,n){var o=e.length,a=e[o-1],s=r[o-1],l=s.componentDatatype;return l!==Ie.UNSIGNED_BYTE&&n?a+4:a+1}function $Rt(e,r,n){var o=Ce.unpack(e,r,zH),a=Ce.unpackFloat(o);o=Ce.unpack(e,r+4,zH);var s=Ce.unpackFloat(o);o=Ce.unpack(e,r+8,zH);var l=Ce.unpackFloat(o);o=Ce.unpack(e,r+12,zH);var h=Ce.unpackFloat(o);return Ce.fromElements(a,s,l,h,n)}function eLt(e,r,n){var o=Ce.packFloat(e.x,zH);Ce.pack(o,r,n),o=Ce.packFloat(e.y,o),Ce.pack(o,r,n+4),o=Ce.packFloat(e.z,o),Ce.pack(o,r,n+8),o=Ce.packFloat(e.w,o),Ce.pack(o,r,n+12)}function iLt(e,r){var n=e._textureDimensions;e._texture=new Vt({context:r,pixelFormat:pt.RGBA,pixelDatatype:e._pixelDatatype,width:n.x,height:n.y,sampler:new Yr({minificationFilter:Dr.NEAREST,magnificationFilter:xi.NEAREST}),flipY:!1})}function nLt(e){var r=e._textureDimensions;e._texture.copyFrom({width:r.x,height:r.y,arrayBufferView:e._batchValues})}function oLt(e){var r=e._stride;return e._textureDimensions.y===1?`uniform vec4 batchTextureStep{suffix}; 
vec2 computeSt{suffix}(float batchId) 
{ 
    float stepX = batchTextureStep{suffix}.x; 
    float centerX = batchTextureStep{suffix}.y; 
    float numberOfAttributes = float(`+r+`); 
    return vec2(centerX + (batchId * numberOfAttributes * stepX), 0.5); 
} 
`:`uniform vec4 batchTextureStep{suffix}; 
uniform vec2 batchTextureDimensions{suffix}; 
vec2 computeSt{suffix}(float batchId) 
{ 
    float stepX = batchTextureStep{suffix}.x; 
    float centerX = batchTextureStep{suffix}.y; 
    float stepY = batchTextureStep{suffix}.z; 
    float centerY = batchTextureStep{suffix}.w; 
    float numberOfAttributes = float(`+r+`); 
    float xId = mod(batchId * numberOfAttributes, batchTextureDimensions{suffix}.x); 
    float yId = floor(batchId * numberOfAttributes / batchTextureDimensions{suffix}.x); 
    return vec2(centerX + (xId * stepX), centerY + (yId * stepY)); 
} 
`}function aLt(e){return e===1?"float":"vec"+e}function sLt(e){return e===1?".x":e===2?".xy":e===3?".xyz":""}function lLt(e,r){var n=e._attributes,o=n[r],a=o.componentsPerAttribute,s=o.functionName,l=aLt(a),h=sLt(a),x=e._offsets[r],m=l+" "+s+`(float batchId) 
{ 
    vec2 st = computeSt{suffix}(batchId); 
    st.x += batchTextureStep{suffix}.x * float(`+x+`); 
`;return e._packFloats&&o.componentDatatype!==Gt.UNSIGNED_BYTE?m+=`vec4 textureValue; 
textureValue.x = czm_unpackFloat(texture2D(batchTexture{suffix}, st)); 
textureValue.y = czm_unpackFloat(texture2D(batchTexture{suffix}, st + vec2(batchTextureStep{suffix}.x, 0.0))); 
textureValue.z = czm_unpackFloat(texture2D(batchTexture{suffix}, st + vec2(batchTextureStep{suffix}.x * 2.0, 0.0))); 
textureValue.w = czm_unpackFloat(texture2D(batchTexture{suffix}, st + vec2(batchTextureStep{suffix}.x * 3.0, 0.0))); 
`:m+=`    vec4 textureValue = texture2D(batchTexture{suffix}, st); 
`,m+="    "+l+" value = textureValue"+h+`; 
`,e._pixelDatatype===Gt.UNSIGNED_BYTE&&o.componentDatatype===Ie.UNSIGNED_BYTE&&!o.normalize?m+=`value *= 255.0; 
`:e._pixelDatatype===Gt.FLOAT&&o.componentDatatype===Ie.UNSIGNED_BYTE&&o.normalize&&(m+=`value /= 255.0; 
`),m+=`    return value; 
} 
`,m}var zH,e6e,tLt,rLt,Iy,QF=Ee(()=>{Fr();bt();Ci();Ua();mi();De();ur();st();Mn();Pl();go();ra();yn();Ia();pa();ou();y(HC,"BatchTable");Object.defineProperties(HC.prototype,{attributes:{get:function(){return this._attributes}},numberOfInstances:{get:function(){return this._numberOfInstances}},suffix:{get:function(){return this._suffix},set:function(e){this._suffix=e}}});y(KRt,"getDatatype");y(t6e,"getAttributeType");y(ZRt,"createOffsets");y(JRt,"getStride");zH=new Ce;y($Rt,"getPackedFloat");y(eLt,"setPackedAttribute");e6e=new Ce;HC.prototype.getBatchedAttribute=function(e,r,n){if(e<0||e>=this._numberOfInstances)throw new G("instanceIndex is out of range.");if(r<0||r>=this._attributes.length)throw new G("attributeIndex is out of range");var o=this._attributes,a=this._offsets[r],s=this._stride,l=4*s*e+4*a,h;this._packFloats&&o[r].componentDatatype!==Gt.UNSIGNED_BYTE?h=$Rt(this._batchValues,l,e6e):h=Ce.unpack(this._batchValues,l,e6e);var x=t6e(o,r);return p(x.fromCartesian4)?x.fromCartesian4(h,n):p(x.clone)?x.clone(h,n):h.x};tLt=[void 0,void 0,new de,new E,new Ce],rLt=new Ce;HC.prototype.setBatchedAttribute=function(e,r,n){if(e<0||e>=this._numberOfInstances)throw new G("instanceIndex is out of range.");if(r<0||r>=this._attributes.length)throw new G("attributeIndex is out of range");if(!p(n))throw new G("value is required.");var o=this._attributes,a=tLt[o[r].componentsPerAttribute],s=this.getBatchedAttribute(e,r,a),l=t6e(this._attributes,r),h=p(l.equals)?l.equals(s,n):s===n;if(!h){var x=rLt;x.x=p(n.x)?n.x:n,x.y=p(n.y)?n.y:0,x.z=p(n.z)?n.z:0,x.w=p(n.w)?n.w:0;var m=this._offsets[r],v=this._stride,_=4*v*e+4*m;this._packFloats&&o[r].componentDatatype!==Gt.UNSIGNED_BYTE?eLt(x,this._batchValues,_):Ce.pack(x,this._batchValues,_),this._batchValuesDirty=!0}};y(iLt,"createTexture");y(nLt,"updateTexture");HC.prototype.update=function(e){p(this._texture)&&!this._batchValuesDirty||this._attributes.length===0||(this._batchValuesDirty=!1,p(this._texture)||iLt(this,e.context),nLt(this))};HC.prototype.getUniformMapCallback=function(){var e=this;return function(r){if(e._attributes.length===0)return r;var n={};return e._suffix===""?(n={batchTexture:function(){return e._texture},batchTextureDimensions:function(){return e._textureDimensions},batchTextureStep:function(){return e._textureStep}},ei(r,n)):(n["batchTexture"+e._suffix]=function(){return e._texture},n["batchTextureDimensions"+e._suffix]=function(){return e._textureDimensions},n["batchTextureStep"+e._suffix]=function(){return e._textureStep},ei(r,n))}};y(oLt,"getGlslComputeSt");y(aLt,"getComponentType");y(sLt,"getComponentSwizzle");y(lLt,"getGlslAttributeFunction");HC.prototype.getVertexShaderCallback=function(){var e=this._attributes;if(e.length===0)return function(a){return a};var r=`uniform highp sampler2D batchTexture{suffix}; 
`;Gn.isPCBroswer()&&(r=`uniform sampler2D batchTexture{suffix}; 
`),r+=oLt(this)+`
`;for(var n=e.length,o=0;o<n;++o)r+=lLt(this,o);return r=r.replace(/\{suffix\}/g,this._suffix),function(a){var s=a.indexOf("void main"),l=a.substring(0,s),h=a.substring(s);return l+`
`+r+`
`+h}};HC.prototype.hasMultiRow=function(){return this._textureDimensions.y>1};HC.prototype.isDestroyed=function(){return!1};HC.prototype.destroy=function(){return this._texture=this._texture&&this._texture.destroy(),$e(this)};Iy=HC});var uLt,S0,Py=Ee(()=>{co();uLt={NEVER:Se.NEVER,LESS:Se.LESS,EQUAL:Se.EQUAL,LESS_OR_EQUAL:Se.LEQUAL,GREATER:Se.GREATER,NOT_EQUAL:Se.NOTEQUAL,GREATER_OR_EQUAL:Se.GEQUAL,ALWAYS:Se.ALWAYS},S0=Object.freeze(uLt)});function JQ(e){return n6e[0]=e,n6e[0]}function tme(e){return e>>1^-(e&1)}var r6e,i6e,Bl,VH,n6e,rme,Xo,WC=Ee(()=>{Fr();bt();cr();De();st();nr();r6e=1/256,i6e=256,Bl={};Bl.octEncodeInRange=function(e,r,n){X.defined("vector",e),X.defined("result",n);var o=E.magnitudeSquared(e);if(Math.abs(o-1)>K.EPSILON6)throw new G("vector must be normalized.");if(n.x=e.x/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),n.y=e.y/(Math.abs(e.x)+Math.abs(e.y)+Math.abs(e.z)),e.z<0){var a=n.x,s=n.y;n.x=(1-Math.abs(s))*K.signNotZero(a),n.y=(1-Math.abs(a))*K.signNotZero(s)}return n.x=K.toSNorm(n.x,r),n.y=K.toSNorm(n.y,r),n};Bl.octEncode=function(e,r){return Bl.octEncodeInRange(e,255,r)};VH=new de,n6e=new Uint8Array(1);y(JQ,"forceUint8");Bl.octEncodeToCartesian4=function(e,r){return Bl.octEncodeInRange(e,65535,VH),r.x=JQ(VH.x*r6e),r.y=JQ(VH.x),r.z=JQ(VH.y*r6e),r.w=JQ(VH.y),r};Bl.octDecodeInRange=function(e,r,n,o){if(X.defined("result",o),e<0||e>n||r<0||r>n)throw new G("x and y must be unsigned normalized integers between 0 and "+n);if(o.x=K.fromSNorm(e,n),o.y=K.fromSNorm(r,n),o.z=1-(Math.abs(o.x)+Math.abs(o.y)),o.z<0){var a=o.x;o.x=(1-Math.abs(o.y))*K.signNotZero(a),o.y=(1-Math.abs(a))*K.signNotZero(o.y)}return E.normalize(o,o)};Bl.octDecode=function(e,r,n){return Bl.octDecodeInRange(e,r,255,n)};Bl.octDecodeFromCartesian4=function(e,r){X.typeOf.object("encoded",e),X.typeOf.object("result",r);var n=e.x,o=e.y,a=e.z,s=e.w;if(n<0||n>255||o<0||o>255||a<0||a>255||s<0||s>255)throw new G("x, y, z, and w must be unsigned normalized integers between 0 and 255");var l=n*i6e+o,h=a*i6e+s;return Bl.octDecodeInRange(l,h,65535,r)};Bl.octPackFloat=function(e){return X.defined("encoded",e),256*e.x+e.y};rme=new de;Bl.octEncodeFloat=function(e){return Bl.octEncode(e,rme),Bl.octPackFloat(rme)};Bl.octDecodeFloat=function(e,r){X.defined("value",e);var n=e/256,o=Math.floor(n),a=(n-o)*256;return Bl.octDecode(o,a,r)};Bl.octPack=function(e,r,n,o){X.defined("v1",e),X.defined("v2",r),X.defined("v3",n),X.defined("result",o);var a=Bl.octEncodeFloat(e),s=Bl.octEncodeFloat(r),l=Bl.octEncode(n,rme);return o.x=65536*l.x+a,o.y=65536*l.y+s,o};Bl.octUnpack=function(e,r,n,o){X.defined("packed",e),X.defined("v1",r),X.defined("v2",n),X.defined("v3",o);var a=e.x/65536,s=Math.floor(a),l=(a-s)*65536;a=e.y/65536;var h=Math.floor(a),x=(a-h)*65536;Bl.octDecodeFloat(l,r),Bl.octDecodeFloat(x,n),Bl.octDecode(s,h,o)};Bl.compressTextureCoordinates=function(e){X.defined("textureCoordinates",e);var r=e.x*4095|0,n=e.y*4095|0;return 4096*r+n};Bl.decompressTextureCoordinates=function(e,r){X.defined("compressed",e),X.defined("result",r);var n=e/4096,o=Math.floor(n);return r.x=o/4095,r.y=(e-o*4096)/4095,r};y(tme,"zigZagDecode");Bl.zigZagDeltaDecode=function(e,r,n){X.defined("uBuffer",e),X.defined("vBuffer",r),X.typeOf.number.equals("uBuffer.length","vBuffer.length",e.length,r.length),p(n)&&X.typeOf.number.equals("uBuffer.length","heightBuffer.length",e.length,n.length);for(var o=e.length,a=0,s=0,l=0,h=0;h<o;++h)a+=tme(e[h]),s+=tme(r[h]),e[h]=a,r[h]=s,p(n)&&(l+=tme(n[h]),n[h]=l)};Bl.octShortToFloat=function(e){return K.clamp(e*3051850947599719e-20,-1,1)};Bl.octShortDecode=function(e,r,n){if(X.defined("result",n),n.x=Bl.octShortToFloat(e),n.y=Bl.octShortToFloat(r),n.z=1-(Math.abs(n.x)+Math.abs(n.y)),n.z<0){var o=n.x;n.x=(1-Math.abs(n.y))*K.signNotZero(o),n.y=(1-Math.abs(o))*K.signNotZero(n.y)}return E.normalize(n,n)};Xo=Bl});function cLt(e,r,n,o,a){X.defined("point",e),X.defined("p0",r),X.defined("p1",n),X.defined("p2",o),p(a)||(a=new E);var s,l,h,x,m,v,_,A;if(p(r.z)){if(E.equalsEpsilon(e,r,K.EPSILON14))return E.clone(E.UNIT_X,a);if(E.equalsEpsilon(e,n,K.EPSILON14))return E.clone(E.UNIT_Y,a);if(E.equalsEpsilon(e,o,K.EPSILON14))return E.clone(E.UNIT_Z,a);s=E.subtract(n,r,o6e),l=E.subtract(o,r,a6e),h=E.subtract(e,r,s6e),x=E.dot(s,s),m=E.dot(s,l),v=E.dot(s,h),_=E.dot(l,l),A=E.dot(l,h)}else{if(de.equalsEpsilon(e,r,K.EPSILON14))return E.clone(E.UNIT_X,a);if(de.equalsEpsilon(e,n,K.EPSILON14))return E.clone(E.UNIT_Y,a);if(de.equalsEpsilon(e,o,K.EPSILON14))return E.clone(E.UNIT_Z,a);s=de.subtract(n,r,o6e),l=de.subtract(o,r,a6e),h=de.subtract(e,r,s6e),x=de.dot(s,s),m=de.dot(s,l),v=de.dot(s,h),_=de.dot(l,l),A=de.dot(l,h)}a.y=_*v-m*A,a.z=x*A-m*v;var T=x*_-m*m;return a.y!==0&&(a.y/=T),a.z!==0&&(a.z/=T),a.x=1-a.y-a.z,a}var o6e,a6e,s6e,XF,$Q=Ee(()=>{Fr();bt();cr();De();nr();o6e=new E,a6e=new E,s6e=new E;y(cLt,"barycentricCoordinates");XF=cLt});var ime,eX,nme=Ee(()=>{Ze();De();st();ime={};ime.calculateACMR=function(e){e=B(e,B.EMPTY_OBJECT);var r=e.indices,n=e.maximumIndex,o=B(e.cacheSize,24);if(!p(r))throw new G("indices is required.");var a=r.length;if(a<3||a%3!==0)throw new G("indices length must be a multiple of three.");if(n<=0)throw new G("maximumIndex must be greater than zero.");if(o<3)throw new G("cacheSize must be greater than two.");if(!p(n)){n=0;for(var s=0,l=r[s];s<a;)l>n&&(n=l),++s,l=r[s]}for(var h=[],x=0;x<n+1;x++)h[x]=0;for(var m=o+1,v=0;v<a;++v)m-h[r[v]]>o&&(h[r[v]]=m,++m);return(m-o+1)/(a/3)};ime.tipsify=function(e){e=B(e,B.EMPTY_OBJECT);var r=e.indices,n=e.maximumIndex,o=B(e.cacheSize,24),a;function s(V,U,Q,J){for(;U.length>=1;){var oe=U[U.length-1];if(U.splice(U.length-1,1),V[oe].numLiveTriangles>0)return oe}for(;a<J;){if(V[a].numLiveTriangles>0)return++a,a-1;++a}return-1}y(s,"skipDeadEnd");function l(V,U,Q,J,oe,$,re){for(var ne=-1,le,ue=-1,ie=0;ie<Q.length;){var ce=Q[ie];J[ce].numLiveTriangles&&(le=0,oe-J[ce].timeStamp+2*J[ce].numLiveTriangles<=U&&(le=oe-J[ce].timeStamp),(le>ue||ue===-1)&&(ue=le,ne=ce)),++ie}return ne===-1?s(J,$,V,re):ne}if(y(l,"getNextVertex"),!p(r))throw new G("indices is required.");var h=r.length;if(h<3||h%3!==0)throw new G("indices length must be a multiple of three.");if(n<=0)throw new G("maximumIndex must be greater than zero.");if(o<3)throw new G("cacheSize must be greater than two.");var x=0,m=0,v=r[m],_=h;if(p(n))x=n+1;else{for(;m<_;)v>x&&(x=v),++m,v=r[m];if(x===-1)return 0;++x}var A=[],T;for(T=0;T<x;T++)A[T]={numLiveTriangles:0,timeStamp:0,vertexTriangles:[]};m=0;for(var w=0;m<_;)A[r[m]].vertexTriangles.push(w),++A[r[m]].numLiveTriangles,A[r[m+1]].vertexTriangles.push(w),++A[r[m+1]].numLiveTriangles,A[r[m+2]].vertexTriangles.push(w),++A[r[m+2]].numLiveTriangles,++w,m+=3;var S=0,P=o+1;a=1;var M=[],L=[],R,O,N=0,k=[],z=h/3,W=[];for(T=0;T<z;T++)W[T]=!1;for(var j,q;S!==-1;){M=[],O=A[S],q=O.vertexTriangles.length;for(var I=0;I<q;++I)if(w=O.vertexTriangles[I],!W[w]){W[w]=!0,m=w+w+w;for(var F=0;F<3;++F)j=r[m],M.push(j),L.push(j),k[N]=j,++N,R=A[j],--R.numLiveTriangles,P-R.timeStamp>o&&(R.timeStamp=P,++P),++m}S=l(r,o,M,A,P,L,x)}return k};eX=ime});function sX(e,r,n,o,a){e[r++]=n,e[r++]=o,e[r++]=o,e[r++]=a,e[r++]=a,e[r]=n}function fLt(e){for(var r=e.length,n=r/3*6,o=tr.createTypedArray(r,n),a=0,s=0;s<r;s+=3,a+=6)sX(o,a,e[s],e[s+1],e[s+2]);return o}function xLt(e){var r=e.length;if(r>=3){var n=(r-2)*6,o=tr.createTypedArray(r,n);sX(o,0,e[0],e[1],e[2]);for(var a=6,s=3;s<r;++s,a+=6)sX(o,a,e[s-1],e[s],e[s-2]);return o}return new Uint16Array}function hLt(e){if(e.length>0){for(var r=e.length-1,n=(r-1)*6,o=tr.createTypedArray(r,n),a=e[0],s=0,l=1;l<r;++l,s+=6)sX(o,s,a,e[l],e[l+1]);return o}return new Uint16Array}function l6e(e){var r={};for(var n in e)if(e.hasOwnProperty(n)&&p(e[n])&&p(e[n].values)){var o=e[n];r[n]=new wr({componentDatatype:o.componentDatatype,componentsPerAttribute:o.componentsPerAttribute,normalize:o.normalize,values:[]})}return r}function dLt(e,r,n){for(var o in r)if(r.hasOwnProperty(o)&&p(r[o])&&p(r[o].values))for(var a=r[o],s=0;s<a.componentsPerAttribute;++s)e[o].values.push(a.values[n*a.componentsPerAttribute+s])}function ame(e,r){if(p(r))for(var n=r.values,o=n.length,a=0;a<o;a+=3)E.unpack(n,a,My),Z.multiplyByPoint(e,My,My),E.pack(My,n,a)}function sme(e,r){if(p(r))for(var n=r.values,o=n.length,a=0;a<o;a+=3)E.unpack(n,a,My),We.multiplyByVector(e,My,My),My=E.normalize(My,My),E.pack(My,n,a)}function pLt(e,r){var n=e.length,o={},a=e[0][r].attributes,s;for(s in a)if(a.hasOwnProperty(s)&&p(a[s])&&p(a[s].values)){for(var l=a[s],h=l.values.length,x=!0,m=1;m<n;++m){var v=e[m][r].attributes[s];if(!p(v)||l.componentDatatype!==v.componentDatatype||l.componentsPerAttribute!==v.componentsPerAttribute||l.normalize!==v.normalize){x=!1;break}h+=v.values.length}x&&(o[s]=new wr({componentDatatype:l.componentDatatype,componentsPerAttribute:l.componentsPerAttribute,normalize:l.normalize,values:Ie.createTypedArray(l.componentDatatype,h)}),l.isInstanceAttribute&&(o[s].isInstanceAttribute=!0))}return o}function lme(e,r){var n=e.length,o,a,s,l,h=e[0].modelMatrix,x=p(e[0][r].indices),m=e[0][r].primitiveType;for(a=1;a<n;++a){if(!Z.equals(e[a].modelMatrix,h))throw new G("All instances must have the same modelMatrix.");if(p(e[a][r].indices)!==x)throw new G("All instance geometries must have an indices or not have one.");if(e[a][r].primitiveType!==m)throw new G("All instance geometries must have the same primitiveType.")}var v=pLt(e,r),_,A,T;for(o in v)if(v.hasOwnProperty(o))for(_=v[o].values,l=0,a=0;a<n;++a)for(A=e[a][r].attributes[o].values,T=A.length,s=0;s<T;++s)_[l++]=A[s];var w;if(x){var S=0;for(a=0;a<n;++a)S+=e[a][r].indices.length;var P=Ei.computeNumberOfVertices(new Ei({attributes:v,primitiveType:jt.POINTS})),M=tr.createTypedArray(P,S),L=0,R=0;for(a=0;a<n;++a){var O=e[a][r].indices,N=O.length;for(l=0;l<N;++l)M[L++]=R+O[l];R+=Ei.computeNumberOfVertices(e[a][r])}w=M}var k=new E,z=0,W;for(a=0;a<n;++a){if(W=e[a][r].boundingSphere,!p(W)){k=void 0;break}E.add(W.center,k,k)}if(p(k))for(E.divideByScalar(k,n,k),a=0;a<n;++a){W=e[a][r].boundingSphere;var j=E.magnitude(E.subtract(W.center,k,vLt))+W.radius;j>z&&(z=j)}return new Ei({attributes:v,indices:w,primitiveType:m,boundingSphere:p(k)?new Ue(k,z):void 0})}function yLt(e){if(p(e.indices))return e;var r=Ei.computeNumberOfVertices(e);if(r<3)throw new G("The number of vertices must be at least three.");if(r%3!==0)throw new G("The number of vertices must be a multiple of three.");for(var n=tr.createTypedArray(r,r),o=0;o<r;++o)n[o]=o;return e.indices=n,e}function ALt(e){var r=Ei.computeNumberOfVertices(e);if(r<3)throw new G("The number of vertices must be at least three.");var n=tr.createTypedArray(r,(r-2)*3);n[0]=1,n[1]=0,n[2]=2;for(var o=3,a=3;a<r;++a)n[o++]=a-1,n[o++]=0,n[o++]=a;return e.indices=n,e.primitiveType=jt.TRIANGLES,e}function CLt(e){var r=Ei.computeNumberOfVertices(e);if(r<3)throw new G("The number of vertices must be at least 3.");var n=tr.createTypedArray(r,(r-2)*3);n[0]=0,n[1]=1,n[2]=2,r>3&&(n[3]=0,n[4]=2,n[5]=3);for(var o=6,a=3;a<r-1;a+=2)n[o++]=a,n[o++]=a-1,n[o++]=a+1,a+2<r&&(n[o++]=a,n[o++]=a+1,n[o++]=a+2);return e.indices=n,e.primitiveType=jt.TRIANGLES,e}function TLt(e){if(p(e.indices))return e;var r=Ei.computeNumberOfVertices(e);if(r<2)throw new G("The number of vertices must be at least two.");if(r%2!==0)throw new G("The number of vertices must be a multiple of 2.");for(var n=tr.createTypedArray(r,r),o=0;o<r;++o)n[o]=o;return e.indices=n,e}function wLt(e){var r=Ei.computeNumberOfVertices(e);if(r<2)throw new G("The number of vertices must be at least two.");var n=tr.createTypedArray(r,(r-1)*2);n[0]=0,n[1]=1;for(var o=2,a=2;a<r;++a)n[o++]=a-1,n[o++]=a;return e.indices=n,e.primitiveType=jt.LINES,e}function ELt(e){var r=Ei.computeNumberOfVertices(e);if(r<2)throw new G("The number of vertices must be at least two.");var n=tr.createTypedArray(r,r*2);n[0]=0,n[1]=1;for(var o=2,a=2;a<r;++a)n[o++]=a-1,n[o++]=a;return n[o++]=r-1,n[o]=0,e.indices=n,e.primitiveType=jt.LINES,e}function bLt(e){switch(e.primitiveType){case jt.TRIANGLE_FAN:return ALt(e);case jt.TRIANGLE_STRIP:return CLt(e);case jt.TRIANGLES:return yLt(e);case jt.LINE_STRIP:return wLt(e);case jt.LINE_LOOP:return ELt(e);case jt.LINES:return TLt(e)}return e}function kS(e,r){Math.abs(e.y)<K.EPSILON6&&(r?e.y=-K.EPSILON6:e.y=K.EPSILON6)}function SLt(e,r,n){if(e.y!==0&&r.y!==0&&n.y!==0){kS(e,e.y<0),kS(r,r.y<0),kS(n,n.y<0);return}var o=Math.abs(e.y),a=Math.abs(r.y),s=Math.abs(n.y),l;o>a?o>s?l=K.sign(e.y):l=K.sign(n.y):a>s?l=K.sign(r.y):l=K.sign(n.y);var h=l<0;kS(e,h),kS(r,h),kS(n,h)}function Tg(e,r,n,o){E.add(e,E.multiplyByScalar(E.subtract(r,e,h6e),e.y/(e.y-r.y),h6e),n),E.clone(n,o),kS(n,!0),kS(o,!1)}function ILt(e,r,n){if(!(e.x>=0||r.x>=0||n.x>=0)){SLt(e,r,n);var o=e.y<0,a=r.y<0,s=n.y<0,l=0;l+=o?1:0,l+=a?1:0,l+=s?1:0;var h=ume.indices;l===1?(h[1]=3,h[2]=4,h[5]=6,h[7]=6,h[8]=5,o?(Tg(e,r,nB,aB),Tg(e,n,oB,sB),h[0]=0,h[3]=1,h[4]=2,h[6]=1):a?(Tg(r,n,nB,aB),Tg(r,e,oB,sB),h[0]=1,h[3]=2,h[4]=0,h[6]=2):s&&(Tg(n,e,nB,aB),Tg(n,r,oB,sB),h[0]=2,h[3]=0,h[4]=1,h[6]=0)):l===2&&(h[2]=4,h[4]=4,h[5]=3,h[7]=5,h[8]=6,o?a?s||(Tg(n,e,nB,aB),Tg(n,r,oB,sB),h[0]=0,h[1]=1,h[3]=0,h[6]=2):(Tg(r,n,nB,aB),Tg(r,e,oB,sB),h[0]=2,h[1]=0,h[3]=2,h[6]=1):(Tg(e,r,nB,aB),Tg(e,n,oB,sB),h[0]=1,h[1]=2,h[3]=1,h[6]=0));var x=ume.positions;return x[0]=e,x[1]=r,x[2]=n,x.length=3,(l===1||l===2)&&(x[3]=nB,x[4]=oB,x[5]=aB,x[6]=sB,x.length=7),ume}}function d6e(e,r){var n=e.attributes;if(n.position.values.length!==0){for(var o in n)if(n.hasOwnProperty(o)&&p(n[o])&&p(n[o].values)){var a=n[o];a.values=Ie.createTypedArray(a.componentDatatype,a.values)}var s=Ei.computeNumberOfVertices(e);return e.indices=tr.createTypedArray(s,e.indices),r&&(e.boundingSphere=Ue.fromVertices(n.position.values)),e}}function $F(e){var r=e.attributes,n={};for(var o in r)if(r.hasOwnProperty(o)&&p(r[o])&&p(r[o].values)){var a=r[o];n[o]=new wr({componentDatatype:a.componentDatatype,componentsPerAttribute:a.componentsPerAttribute,normalize:a.normalize,values:[]})}return new Ei({attributes:n,indices:[],primitiveType:e.primitiveType})}function hme(e,r,n){var o=p(e.geometry.boundingSphere);r=d6e(r,o),n=d6e(n,o),p(n)&&!p(r)?e.geometry=n:!p(n)&&p(r)?e.geometry=r:(e.westHemisphereGeometry=r,e.eastHemisphereGeometry=n,e.geometry=void 0)}function dme(e,r){var n=new e,o=new e,a=new e;return function(s,l,h,x,m,v,_,A){var T=e.fromArray(m,s*r,n),w=e.fromArray(m,l*r,o),S=e.fromArray(m,h*r,a);e.multiplyByScalar(T,x.x,T),e.multiplyByScalar(w,x.y,w),e.multiplyByScalar(S,x.z,S);var P=e.add(T,w,T);e.add(P,S,P),A&&e.normalize(P,P),e.pack(P,v,_*r)}}function nX(e,r,n,o,a,s,l,h,x,m,v,_,A,T,w,S){if(!(!p(s)&&!p(l)&&!p(h)&&!p(x)&&!p(m)&&T===0)){var P=E.fromArray(a,e*3,GH),M=E.fromArray(a,r*3,cme),L=E.fromArray(a,n*3,fme),R=XF(o,P,M,L,MLt);if(p(s)&&aX(e,r,n,R,s,_.normal.values,S,!0),p(m)){var O=E.fromArray(m,e*3,GH),N=E.fromArray(m,r*3,cme),k=E.fromArray(m,n*3,fme);E.multiplyByScalar(O,R.x,O),E.multiplyByScalar(N,R.y,N),E.multiplyByScalar(k,R.z,k);var z;!E.equals(O,E.ZERO)||!E.equals(N,E.ZERO)||!E.equals(k,E.ZERO)?(z=E.add(O,N,O),E.add(z,k,z),E.normalize(z,z)):(z=GH,z.x=0,z.y=0,z.z=0),E.pack(z,_.extrudeDirection.values,S*3)}if(p(v)&&DLt(e,r,n,R,v,_.applyOffset.values,S),p(l)&&aX(e,r,n,R,l,_.tangent.values,S,!0),p(h)&&aX(e,r,n,R,h,_.bitangent.values,S,!0),p(x)&&A6e(e,r,n,R,x,_.st.values,S),T>0)for(var W=0;W<T;W++){var j=A[W];BLt(e,r,n,R,S,w[j],_[j])}}}function BLt(e,r,n,o,a,s,l){var h=s.componentsPerAttribute,x=s.values,m=l.values;switch(h){case 4:PLt(e,r,n,o,x,m,a,!1);break;case 3:aX(e,r,n,o,x,m,a,!1);break;case 2:A6e(e,r,n,o,x,m,a,!1);break;default:m[a]=x[e]*o.x+x[r]*o.y+x[n]*o.z}}function qC(e,r,n,o,a,s){var l=e.position.values.length/3;if(a!==-1){var h=o[a],x=n[h];return x===-1?(n[h]=l,e.position.values.push(s.x,s.y,s.z),r.push(l),l):(r.push(x),x)}return e.position.values.push(s.x,s.y,s.z),r.push(l),l}function m6e(e){var r=e.geometry,n=r.attributes,o=n.position.values,a=p(n.normal)?n.normal.values:void 0,s=p(n.bitangent)?n.bitangent.values:void 0,l=p(n.tangent)?n.tangent.values:void 0,h=p(n.st)?n.st.values:void 0,x=p(n.extrudeDirection)?n.extrudeDirection.values:void 0,m=p(n.applyOffset)?n.applyOffset.values:void 0,v=r.indices,_=[];for(var A in n)n.hasOwnProperty(A)&&!RLt[A]&&p(n[A])&&_.push(A);var T=_.length,w=$F(r),S=$F(r),P,M,L,R,O,N=[];N.length=o.length/3;var k=[];for(k.length=o.length/3,O=0;O<N.length;++O)N[O]=-1,k[O]=-1;var z=v.length;for(O=0;O<z;O+=3){var W=v[O],j=v[O+1],q=v[O+2],I=E.fromArray(o,W*3),F=E.fromArray(o,j*3),V=E.fromArray(o,q*3),U=ILt(I,F,V);if(p(U)&&U.positions.length>3)for(var Q=U.positions,J=U.indices,oe=J.length,$=0;$<oe;++$){var re=J[$],ne=Q[re];ne.y<0?(P=S.attributes,M=S.indices,L=N):(P=w.attributes,M=w.indices,L=k),R=qC(P,M,L,v,re<3?O+re:-1,ne),nX(W,j,q,ne,o,a,l,s,h,x,m,P,_,T,n,R)}else p(U)&&(I=U.positions[0],F=U.positions[1],V=U.positions[2]),I.y<0?(P=S.attributes,M=S.indices,L=N):(P=w.attributes,M=w.indices,L=k),R=qC(P,M,L,v,O,I),nX(W,j,q,I,o,a,l,s,h,x,m,P,_,T,n,R),R=qC(P,M,L,v,O+1,F),nX(W,j,q,F,o,a,l,s,h,x,m,P,_,T,n,R),R=qC(P,M,L,v,O+2,V),nX(W,j,q,V,o,a,l,s,h,x,m,P,_,T,n,R)}hme(e,S,w)}function JF(e,r,n,o,a,s,l){if(!!p(l)){var h=E.fromArray(o,e*3,GH);E.equalsEpsilon(h,n,K.EPSILON10)?s.applyOffset.values[a]=l[e]:s.applyOffset.values[a]=l[r]}}function p6e(e){var r=e.geometry,n=r.attributes,o=n.position.values,a=p(n.applyOffset)?n.applyOffset.values:void 0,s=r.indices,l=$F(r),h=$F(r),x,m=s.length,v=[];v.length=o.length/3;var _=[];for(_.length=o.length/3,x=0;x<v.length;++x)v[x]=-1,_[x]=-1;for(x=0;x<m;x+=2){var A=s[x],T=s[x+1],w=E.fromArray(o,A*3,GH),S=E.fromArray(o,T*3,cme),P;Math.abs(w.y)<K.EPSILON6&&(w.y<0?w.y=-K.EPSILON6:w.y=K.EPSILON6),Math.abs(S.y)<K.EPSILON6&&(S.y<0?S.y=-K.EPSILON6:S.y=K.EPSILON6);var M=l.attributes,L=l.indices,R=_,O=h.attributes,N=h.indices,k=v,z=Yn.lineSegmentPlane(w,S,C6e,fme);if(p(z)){var W=E.multiplyByScalar(E.UNIT_Y,5*K.EPSILON9,LLt);w.y<0&&(E.negate(W,W),M=h.attributes,L=h.indices,R=v,O=l.attributes,N=l.indices,k=_);var j=E.add(z,W,OLt);P=qC(M,L,R,s,x,w),JF(A,T,w,o,P,M,a),P=qC(M,L,R,s,-1,j),JF(A,T,j,o,P,M,a),E.negate(W,W),E.add(z,W,j),P=qC(O,N,k,s,-1,j),JF(A,T,j,o,P,O,a),P=qC(O,N,k,s,x+1,S),JF(A,T,S,o,P,O,a)}else{var q,I,F;w.y<0?(q=h.attributes,I=h.indices,F=v):(q=l.attributes,I=l.indices,F=_),P=qC(q,I,F,s,x,w),JF(A,T,w,o,P,q,a),P=qC(q,I,F,s,x+1,S),JF(A,T,S,o,P,q,a)}}hme(e,h,l)}function y6e(e){for(var r=e.attributes,n=r.position.values,o=r.prevPosition.values,a=r.nextPosition.values,s=n.length,l=0;l<s;l+=3){var h=E.unpack(n,l,T6e);if(!(h.x>0)){var x=E.unpack(o,l,w6e);(h.y<0&&x.y>0||h.y>0&&x.y<0)&&(l-3>0?(o[l]=n[l-3],o[l+1]=n[l-2],o[l+2]=n[l-1]):E.pack(h,o,l));var m=E.unpack(a,l,xme);(h.y<0&&m.y>0||h.y>0&&m.y<0)&&(l+3<s?(a[l]=n[l+3],a[l+1]=n[l+4],a[l+2]=n[l+5]):E.pack(h,a,l))}}}function ULt(e){var r=e.geometry,n=r.attributes,o=n.position.values,a=n.prevPosition.values,s=n.nextPosition.values,l=n.expandAndWidth.values,h=p(n.st)?n.st.values:void 0,x=p(n.color)?n.color.values:void 0,m=p(n.dist)?n.dist.values:void 0,v=$F(r),_=$F(r),A,T,w,S=!1,P=o.length/3;for(A=0;A<P;A+=4){var M=A,L=A+2,R=E.fromArray(o,M*3,T6e),O=E.fromArray(o,L*3,w6e);if(Math.abs(R.y)<oX)for(R.y=oX*(O.y<0?-1:1),o[A*3+1]=R.y,o[(A+1)*3+1]=R.y,T=M*3;T<M*3+4*3;T+=3)a[T]=o[A*3],a[T+1]=o[A*3+1],a[T+2]=o[A*3+2];if(Math.abs(O.y)<oX)for(O.y=oX*(R.y<0?-1:1),o[(A+2)*3+1]=O.y,o[(A+3)*3+1]=O.y,T=M*3;T<M*3+4*3;T+=3)s[T]=o[(A+2)*3],s[T+1]=o[(A+2)*3+1],s[T+2]=o[(A+2)*3+2];var N=v.attributes,k=v.indices,z=_.attributes,W=_.indices,j=Yn.lineSegmentPlane(R,O,C6e,NLt);if(p(j)){S=!0;var q=E.multiplyByScalar(E.UNIT_Y,kLt,zLt);R.y<0&&(E.negate(q,q),N=_.attributes,k=_.indices,z=v.attributes,W=v.indices);var I=E.add(j,q,VLt);N.position.values.push(R.x,R.y,R.z,R.x,R.y,R.z),N.position.values.push(I.x,I.y,I.z),N.position.values.push(I.x,I.y,I.z),N.prevPosition.values.push(a[M*3],a[M*3+1],a[M*3+2]),N.prevPosition.values.push(a[M*3+3],a[M*3+4],a[M*3+5]),N.prevPosition.values.push(R.x,R.y,R.z,R.x,R.y,R.z),N.nextPosition.values.push(I.x,I.y,I.z),N.nextPosition.values.push(I.x,I.y,I.z),N.nextPosition.values.push(I.x,I.y,I.z),N.nextPosition.values.push(I.x,I.y,I.z),E.negate(q,q),E.add(j,q,I),z.position.values.push(I.x,I.y,I.z),z.position.values.push(I.x,I.y,I.z),z.position.values.push(O.x,O.y,O.z,O.x,O.y,O.z),z.prevPosition.values.push(I.x,I.y,I.z),z.prevPosition.values.push(I.x,I.y,I.z),z.prevPosition.values.push(I.x,I.y,I.z),z.prevPosition.values.push(I.x,I.y,I.z),z.nextPosition.values.push(O.x,O.y,O.z,O.x,O.y,O.z),z.nextPosition.values.push(s[L*3],s[L*3+1],s[L*3+2]),z.nextPosition.values.push(s[L*3+3],s[L*3+4],s[L*3+5]);var F=de.fromArray(l,M*2,v6e),V=Math.abs(F.y);N.expandAndWidth.values.push(-1,V,1,V),N.expandAndWidth.values.push(-1,-V,1,-V),z.expandAndWidth.values.push(-1,V,1,V),z.expandAndWidth.values.push(-1,-V,1,-V);var U=E.magnitudeSquared(E.subtract(j,R,xme));if(U/=E.magnitudeSquared(E.subtract(O,R,xme)),p(x)){var Q=Ce.fromArray(x,M*4,_6e),J=Ce.fromArray(x,L*4,_6e),oe=K.lerp(Q.x,J.x,U),$=K.lerp(Q.y,J.y,U),re=K.lerp(Q.z,J.z,U),ne=K.lerp(Q.w,J.w,U);for(T=M*4;T<M*4+2*4;++T)N.color.values.push(x[T]);for(N.color.values.push(oe,$,re,ne),N.color.values.push(oe,$,re,ne),z.color.values.push(oe,$,re,ne),z.color.values.push(oe,$,re,ne),T=L*4;T<L*4+2*4;++T)z.color.values.push(x[T])}if(p(h)){var le=de.fromArray(h,M*2,v6e),ue=de.fromArray(h,(A+3)*2,FLt),ie=K.lerp(le.x,ue.x,U);for(T=M*2;T<M*2+2*2;++T)N.st.values.push(h[T]);for(N.st.values.push(ie,le.y),N.st.values.push(ie,ue.y),z.st.values.push(ie,le.y),z.st.values.push(ie,ue.y),T=L*2;T<L*2+2*2;++T)z.st.values.push(h[T])}if(p(m)){var ce=E.fromArray(m,M*3,g6e),he=E.fromArray(m,L*3,g6e),_e=K.lerp(ce.x,he.x,U);for(T=M*3;T<M*3+2*3;++T)N.dist.values.push(m[T]);for(N.dist.values.push(_e,ce.y,ce.z),N.dist.values.push(_e,ce.y,ce.z),z.dist.values.push(_e,he.y,he.z),z.dist.values.push(_e,he.y,he.z),T=L*3;T<L*3+2*3;++T)z.dist.values.push(m[T])}w=N.position.values.length/3-4,k.push(w,w+2,w+1),k.push(w+1,w+2,w+3),w=z.position.values.length/3-4,W.push(w,w+2,w+1),W.push(w+1,w+2,w+3)}else{var Ae,be;for(R.y<0?(Ae=_.attributes,be=_.indices):(Ae=v.attributes,be=v.indices),Ae.position.values.push(R.x,R.y,R.z),Ae.position.values.push(R.x,R.y,R.z),Ae.position.values.push(O.x,O.y,O.z),Ae.position.values.push(O.x,O.y,O.z),T=A*3;T<A*3+4*3;++T)Ae.prevPosition.values.push(a[T]),Ae.nextPosition.values.push(s[T]);for(T=A*2;T<A*2+4*2;++T)Ae.expandAndWidth.values.push(l[T]),p(h)&&Ae.st.values.push(h[T]);if(p(x))for(T=A*4;T<A*4+4*4;++T)Ae.color.values.push(x[T]);if(p(m))for(T=A*3;T<A*3+4*3;++T)Ae.dist.values.push(m[T]);w=Ae.position.values.length/3-4,be.push(w,w+2,w+1),be.push(w+1,w+2,w+3)}}S&&(y6e(_),y6e(v)),hme(e,_,v)}var Tm,u6e,mLt,ome,My,tX,rX,vLt,Cg,kH,KF,ZF,gLt,c6e,_Lt,UH,Dy,f6e,x6e,iX,h6e,nB,oB,aB,sB,ume,PLt,aX,A6e,DLt,GH,cme,fme,MLt,RLt,C6e,LLt,OLt,v6e,FLt,T6e,w6e,xme,NLt,zLt,VLt,g6e,_6e,kLt,oX,na,rh=Ee(()=>{WC();$Q();hi();Fr();bt();Ci();Si();mi();Ze();De();st();Ax();iu();gs();_s();rH();_n();Ql();jf();nr();to();Rr();K0();un();nme();Tm={};y(sX,"addTriangle");y(fLt,"trianglesToLines");y(xLt,"triangleStripToLines");y(hLt,"triangleFanToLines");Tm.toWireframe=function(e){if(!p(e))throw new G("geometry is required.");var r=e.indices;if(p(r)){switch(e.primitiveType){case jt.TRIANGLES:e.indices=fLt(r);break;case jt.TRIANGLE_STRIP:e.indices=xLt(r);break;case jt.TRIANGLE_FAN:e.indices=hLt(r);break;default:throw new G("geometry.primitiveType must be TRIANGLES, TRIANGLE_STRIP, or TRIANGLE_FAN.")}e.primitiveType=jt.LINES}return e};Tm.createLineSegmentsForVectors=function(e,r,n){if(r=B(r,"normal"),!p(e))throw new G("geometry is required.");if(!p(e.attributes.position))throw new G("geometry.attributes.position is required.");if(!p(e.attributes[r]))throw new G("geometry.attributes must have an attribute with the same name as the attributeName parameter, "+r+".");n=B(n,1e4);for(var o=e.attributes.position.values,a=e.attributes[r].values,s=o.length,l=new Float64Array(2*s),h=0,x=0;x<s;x+=3)l[h++]=o[x],l[h++]=o[x+1],l[h++]=o[x+2],l[h++]=o[x]+a[x]*n,l[h++]=o[x+1]+a[x+1]*n,l[h++]=o[x+2]+a[x+2]*n;var m,v=e.boundingSphere;return p(v)&&(m=new Ue(v.center,v.radius+n)),new Ei({attributes:{position:new wr({componentDatatype:Ie.DOUBLE,componentsPerAttribute:3,values:l})},primitiveType:jt.LINES,boundingSphere:m})};Tm.createAttributeLocations=function(e){if(!p(e))throw new G("geometry is required.");var r=["position","positionHigh","positionLow","position3DHigh","position3DLow","position2DHigh","position2DLow","pickColor","normal","st","tangent","bitangent","extrudeDirection","compressedAttributes"],n=e.attributes,o={},a=0,s,l=r.length;for(s=0;s<l;++s){var h=r[s];p(n[h])&&(o[h]=a++)}for(var x in n)n.hasOwnProperty(x)&&!p(o[x])&&(o[x]=a++);return o};Tm.reorderForPreVertexCache=function(e){if(!p(e))throw new G("geometry is required.");var r=Ei.computeNumberOfVertices(e),n=e.indices;if(p(n)){for(var o=new Int32Array(r),a=0;a<r;a++)o[a]=-1;for(var s=n,l=s.length,h=tr.createTypedArray(r,l),x=0,m=0,v=0,_;x<l;)_=o[s[x]],_!==-1?h[m]=_:(_=s[x],o[_]=v,h[m]=v,++v),++x,++m;e.indices=h;var A=e.attributes;for(var T in A)if(A.hasOwnProperty(T)&&p(A[T])&&p(A[T].values)){for(var w=A[T],S=w.values,P=0,M=w.componentsPerAttribute,L=Ie.createTypedArray(w.componentDatatype,v*M);P<r;){var R=o[P];if(R!==-1)for(var O=0;O<M;O++)L[M*R+O]=S[M*P+O];++P}w.values=L}}return e};Tm.reorderForPostVertexCache=function(e,r){if(!p(e))throw new G("geometry is required.");var n=e.indices;if(e.primitiveType===jt.TRIANGLES&&p(n)){for(var o=n.length,a=0,s=0;s<o;s++)n[s]>a&&(a=n[s]);e.indices=eX.tipsify({indices:n,maximumIndex:a,cacheSize:r})}return e};y(l6e,"copyAttributesDescriptions");y(dLt,"copyVertex");Tm.fitToUnsignedShortIndices=function(e){if(!p(e))throw new G("geometry is required.");if(p(e.indices)&&e.primitiveType!==jt.TRIANGLES&&e.primitiveType!==jt.LINES&&e.primitiveType!==jt.POINTS)throw new G("geometry.primitiveType must equal to PrimitiveType.TRIANGLES, PrimitiveType.LINES, or PrimitiveType.POINTS.");var r=[],n=Ei.computeNumberOfVertices(e);if(p(e.indices)&&n>=K.SIXTY_FOUR_KILOBYTES){var o=[],a=[],s=0,l=l6e(e.attributes),h=e.indices,x=h.length,m;e.primitiveType===jt.TRIANGLES?m=3:e.primitiveType===jt.LINES?m=2:e.primitiveType===jt.POINTS&&(m=1);for(var v=0;v<x;v+=m){for(var _=0;_<m;++_){var A=h[v+_],T=o[A];p(T)||(T=s++,o[A]=T,dLt(l,e.attributes,A)),a.push(T)}s+m>=K.SIXTY_FOUR_KILOBYTES&&(r.push(new Ei({attributes:l,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV})),o=[],a=[],s=0,l=l6e(e.attributes))}a.length!==0&&r.push(new Ei({attributes:l,indices:a,primitiveType:e.primitiveType,boundingSphere:e.boundingSphere,boundingSphereCV:e.boundingSphereCV}))}else r.push(e);return r};u6e=new E,mLt=new qe;Tm.projectTo2D=function(e,r,n,o,a){if(!p(e))throw new G("geometry is required.");if(!p(r))throw new G("attributeName is required.");if(!p(n))throw new G("attributeName3D is required.");if(!p(o))throw new G("attributeName2D is required.");if(!p(e.attributes[r]))throw new G("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==Ie.DOUBLE)throw new G("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");var s=e.attributes[r];a=p(a)?a:new yo;for(var l=a.ellipsoid,h=s.values,x=new Float64Array(h.length),m=0,v=0;v<h.length;v+=3){var _=E.fromArray(h,v,u6e),A=l.cartesianToCartographic(_,mLt);if(!p(A))throw new G("Could not project point ("+_.x+", "+_.y+", "+_.z+") to 2D.");var T=a.project(A,u6e);x[m++]=T.x,x[m++]=T.y,x[m++]=T.z}return e.attributes[n]=s,e.attributes[o]=new wr({componentDatatype:Ie.DOUBLE,componentsPerAttribute:3,values:x}),delete e.attributes[r],e};ome={high:0,low:0};Tm.encodeAttribute=function(e,r,n,o){if(!p(e))throw new G("geometry is required.");if(!p(r))throw new G("attributeName is required.");if(!p(n))throw new G("attributeHighName is required.");if(!p(o))throw new G("attributeLowName is required.");if(!p(e.attributes[r]))throw new G("geometry must have attribute matching the attributeName argument: "+r+".");if(e.attributes[r].componentDatatype!==Ie.DOUBLE)throw new G("The attribute componentDatatype must be ComponentDatatype.DOUBLE.");for(var a=e.attributes[r],s=a.values,l=s.length,h=new Float32Array(l),x=new Float32Array(l),m=0;m<l;++m)Pn.encode(s[m],ome),h[m]=ome.high,x[m]=ome.low;var v=a.componentsPerAttribute;return e.attributes[n]=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:v,values:h}),e.attributes[o]=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:v,values:x}),delete e.attributes[r],e};My=new E;y(ame,"transformPoint");y(sme,"transformVector");tX=new Z,rX=new We;Tm.transformToWorldCoordinates=function(e){if(!p(e))throw new G("instance is required.");var r=e.modelMatrix;if(Z.equals(r,Z.IDENTITY))return e;var n=e.geometry.attributes;ame(r,n.position),ame(r,n.prevPosition),ame(r,n.nextPosition),(p(n.normal)||p(n.tangent)||p(n.bitangent))&&(Z.inverse(r,tX),Z.transpose(tX,tX),Z.getRotation(tX,rX),sme(rX,n.normal),sme(rX,n.tangent),sme(rX,n.bitangent));var o=e.geometry.boundingSphere;return p(o)&&(e.geometry.boundingSphere=Ue.transform(o,r,o)),e.modelMatrix=Z.clone(Z.IDENTITY),e};y(pLt,"findAttributesInAllGeometries");vLt=new E;y(lme,"combineGeometries");Tm.combineInstances=function(e){if(!p(e)||e.length<1)throw new G("instances is required and must have length greater than zero.");for(var r=[],n=[],o=e.length,a=0;a<o;++a){var s=e[a];p(s.geometry)?r.push(s):p(s.westHemisphereGeometry)&&p(s.eastHemisphereGeometry)&&n.push(s)}var l=[];return r.length>0&&l.push(lme(r,"geometry")),n.length>0&&(l.push(lme(n,"westHemisphereGeometry")),l.push(lme(n,"eastHemisphereGeometry"))),l};Cg=new E,kH=new E,KF=new E,ZF=new E;Tm.computeNormal=function(e){if(!p(e))throw new G("geometry is required.");if(!p(e.attributes.position)||!p(e.attributes.position.values))throw new G("geometry.attributes.position.values is required.");if(!p(e.indices))throw new G("geometry.indices is required.");if(e.indices.length<2||e.indices.length%3!==0)throw new G("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==jt.TRIANGLES)throw new G("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var r=e.indices,n=e.attributes,o=n.position.values,a=n.position.values.length/3,s=r.length,l=new Array(a),h=new Array(s/3),x=new Array(s),m;for(m=0;m<a;m++)l[m]={indexOffset:0,count:0,currentCount:0};var v=0;for(m=0;m<s;m+=3){var _=r[m],A=r[m+1],T=r[m+2],w=_*3,S=A*3,P=T*3;kH.x=o[w],kH.y=o[w+1],kH.z=o[w+2],KF.x=o[S],KF.y=o[S+1],KF.z=o[S+2],ZF.x=o[P],ZF.y=o[P+1],ZF.z=o[P+2],l[_].count++,l[A].count++,l[T].count++,E.subtract(KF,kH,KF),E.subtract(ZF,kH,ZF),h[v]=E.cross(KF,ZF,new E),v++}var M=0;for(m=0;m<a;m++)l[m].indexOffset+=M,M+=l[m].count;v=0;var L;for(m=0;m<s;m+=3){L=l[r[m]];var R=L.indexOffset+L.currentCount;x[R]=v,L.currentCount++,L=l[r[m+1]],R=L.indexOffset+L.currentCount,x[R]=v,L.currentCount++,L=l[r[m+2]],R=L.indexOffset+L.currentCount,x[R]=v,L.currentCount++,v++}var O=new Float32Array(a*3);for(m=0;m<a;m++){var N=m*3;if(L=l[m],E.clone(E.ZERO,Cg),L.count>0){for(v=0;v<L.count;v++)E.add(Cg,h[x[L.indexOffset+v]],Cg);E.equalsEpsilon(E.ZERO,Cg,K.EPSILON10)&&E.clone(h[x[L.indexOffset]],Cg)}E.equalsEpsilon(E.ZERO,Cg,K.EPSILON10)&&(Cg.z=1),E.normalize(Cg,Cg),O[N]=Cg.x,O[N+1]=Cg.y,O[N+2]=Cg.z}return e.attributes.normal=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:3,values:O}),e};gLt=new E,c6e=new E,_Lt=new E;Tm.computeTangentAndBitangent=function(e){if(!p(e))throw new G("geometry is required.");var r=e.attributes,n=e.indices;if(!p(r.position)||!p(r.position.values))throw new G("geometry.attributes.position.values is required.");if(!p(r.normal)||!p(r.normal.values))throw new G("geometry.attributes.normal.values is required.");if(!p(r.st)||!p(r.st.values))throw new G("geometry.attributes.st.values is required.");if(!p(n))throw new G("geometry.indices is required.");if(n.length<2||n.length%3!==0)throw new G("geometry.indices length must be greater than 0 and be a multiple of 3.");if(e.primitiveType!==jt.TRIANGLES)throw new G("geometry.primitiveType must be PrimitiveType.TRIANGLES.");var o=e.attributes.position.values,a=e.attributes.normal.values,s=e.attributes.st.values,l=e.attributes.position.values.length/3,h=n.length,x=new Array(l*3),m;for(m=0;m<x.length;m++)x[m]=0;var v,_,A;for(m=0;m<h;m+=3){var T=n[m],w=n[m+1],S=n[m+2];v=T*3,_=w*3,A=S*3;var P=T*2,M=w*2,L=S*2,R=o[v],O=o[v+1],N=o[v+2],k=s[P],z=s[P+1],W=s[M+1]-z,j=s[L+1]-z,q=1/((s[M]-k)*j-(s[L]-k)*W),I=(j*(o[_]-R)-W*(o[A]-R))*q,F=(j*(o[_+1]-O)-W*(o[A+1]-O))*q,V=(j*(o[_+2]-N)-W*(o[A+2]-N))*q;x[v]+=I,x[v+1]+=F,x[v+2]+=V,x[_]+=I,x[_+1]+=F,x[_+2]+=V,x[A]+=I,x[A+1]+=F,x[A+2]+=V}var U=new Float32Array(l*3),Q=new Float32Array(l*3);for(m=0;m<l;m++){v=m*3,_=v+1,A=v+2;var J=E.fromArray(a,v,gLt),oe=E.fromArray(x,v,_Lt),$=E.dot(J,oe);E.multiplyByScalar(J,$,c6e),E.normalize(E.subtract(oe,c6e,oe),oe),U[v]=oe.x,U[_]=oe.y,U[A]=oe.z,E.normalize(E.cross(J,oe,oe),oe),Q[v]=oe.x,Q[_]=oe.y,Q[A]=oe.z}return e.attributes.tangent=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:3,values:U}),e.attributes.bitangent=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:3,values:Q}),e};UH=new de,Dy=new E,f6e=new E,x6e=new E,iX=new de;Tm.compressVertices=function(e){if(!p(e))throw new G("geometry is required.");var r=e.attributes.extrudeDirection,n,o;if(p(r)){var a=r.values;o=a.length/3;var s=new Float32Array(o*2),l=0;for(n=0;n<o;++n){if(E.fromArray(a,n*3,Dy),E.equals(Dy,E.ZERO)){l+=2;continue}iX=Xo.octEncodeInRange(Dy,65535,iX),s[l++]=iX.x,s[l++]=iX.y}return e.attributes.compressedAttributes=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:2,values:s}),delete e.attributes.extrudeDirection,e}var h=e.attributes.normal,x=e.attributes.st,m=p(h),v=p(x);if(!m&&!v)return e;var _=e.attributes.tangent,A=e.attributes.bitangent,T=p(_),w=p(A),S,P,M,L;m&&(S=h.values),v&&(P=x.values),T&&(M=_.values),w&&(L=A.values);var R=m?S.length:P.length,O=m?3:2;o=R/O;var N=o,k=v&&m?2:1;k+=T||w?1:0,N*=k;var z=new Float32Array(N),W=0;for(n=0;n<o;++n){v&&(de.fromArray(P,n*2,UH),z[W++]=Xo.compressTextureCoordinates(UH));var j=n*3;m&&p(M)&&p(L)?(E.fromArray(S,j,Dy),E.fromArray(M,j,f6e),E.fromArray(L,j,x6e),Xo.octPack(Dy,f6e,x6e,UH),z[W++]=UH.x,z[W++]=UH.y):(m&&(E.fromArray(S,j,Dy),z[W++]=Xo.octEncodeFloat(Dy)),T&&(E.fromArray(M,j,Dy),z[W++]=Xo.octEncodeFloat(Dy)),w&&(E.fromArray(L,j,Dy),z[W++]=Xo.octEncodeFloat(Dy)))}return e.attributes.compressedAttributes=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:k,values:z}),m&&delete e.attributes.normal,v&&delete e.attributes.st,w&&delete e.attributes.bitangent,T&&delete e.attributes.tangent,e};y(yLt,"indexTriangles");y(ALt,"indexTriangleFan");y(CLt,"indexTriangleStrip");y(TLt,"indexLines");y(wLt,"indexLineStrip");y(ELt,"indexLineLoop");y(bLt,"indexPrimitive");y(kS,"offsetPointFromXZPlane");y(SLt,"offsetTriangleFromXZPlane");h6e=new E;y(Tg,"getXZIntersectionOffsetPoints");nB=new E,oB=new E,aB=new E,sB=new E,ume={positions:new Array(7),indices:new Array(3*3)};y(ILt,"splitTriangle");y(d6e,"updateGeometryAfterSplit");y($F,"copyGeometryForSplit");y(hme,"updateInstanceAfterSplit");y(dme,"generateBarycentricInterpolateFunction");PLt=dme(Ce,4),aX=dme(E,3),A6e=dme(de,2),DLt=y(function(e,r,n,o,a,s,l){var h=a[e]*o.x,x=a[r]*o.y,m=a[n]*o.z;s[l]=h+x+m>K.EPSILON6?1:0},"interpolateAndPackBoolean"),GH=new E,cme=new E,fme=new E,MLt=new E;y(nX,"computeTriangleAttributes");y(BLt,"genericInterpolate");y(qC,"insertSplitPoint");RLt={position:!0,normal:!0,bitangent:!0,tangent:!0,st:!0,extrudeDirection:!0,applyOffset:!0};y(m6e,"splitLongitudeTriangles");C6e=pn.fromPointNormal(E.ZERO,E.UNIT_Y),LLt=new E,OLt=new E;y(JF,"computeLineAttributes");y(p6e,"splitLongitudeLines");v6e=new de,FLt=new de,T6e=new E,w6e=new E,xme=new E,NLt=new E,zLt=new E,VLt=new E,g6e=new E,_6e=new Ce;y(y6e,"updateAdjacencyAfterSplit");kLt=5*K.EPSILON9,oX=K.EPSILON6;y(ULt,"splitLongitudePolyline");Tm.splitLongitude=function(e){if(!p(e))throw new G("instance is required.");var r=e.geometry,n=r.boundingSphere;if(p(n)){var o=n.center.x-n.radius;if(o>0||Ue.intersectPlane(n,pn.ORIGIN_ZX_PLANE)!==wi.INTERSECTING)return e}if(r.geometryType!==_y.NONE)switch(r.geometryType){case _y.POLYLINES:ULt(e);break;case _y.TRIANGLES:m6e(e);break;case _y.LINES:p6e(e);break}else bLt(r),r.primitiveType===jt.TRIANGLES?m6e(e):r.primitiveType===jt.LINES&&p6e(e);return e};na=Tm});function HH(e,r,n){e=B(e,0),r=B(r,0),n=B(n,0),this.value=new Float32Array([e,r,n])}var gl,Q2=Ee(()=>{cr();mi();Ze();De();y(HH,"OffsetGeometryInstanceAttribute");Object.defineProperties(HH.prototype,{componentDatatype:{get:function(){return Ie.FLOAT}},componentsPerAttribute:{get:function(){return 3}},normalize:{get:function(){return!1}}});HH.fromCartesian3=function(e){return X.defined("offset",e),new HH(e.x,e.y,e.z)};HH.toValue=function(e,r){return X.defined("offset",e),p(r)||(r=new Float32Array([e.x,e.y,e.z])),r[0]=e.x,r[1]=e.y,r[2]=e.z,r};gl=HH});function Op(e){this._ellipsoid=B(e,nt.WGS84),this._semimajorAxis=this._ellipsoid.maximumRadius,this._oneOverSemimajorAxis=1/this._semimajorAxis}var fo,Yf=Ee(()=>{bt();Si();Ze();De();st();Ii();nr();y(Op,"WebMercatorProjection");Object.defineProperties(Op.prototype,{ellipsoid:{get:function(){return this._ellipsoid}}});Op.mercatorAngleToGeodeticLatitude=function(e){return K.PI_OVER_TWO-2*Math.atan(Math.exp(-e))};Op.geodeticLatitudeToMercatorAngle=function(e){e>Op.MaximumLatitude?e=Op.MaximumLatitude:e<-Op.MaximumLatitude&&(e=-Op.MaximumLatitude);var r=Math.sin(e);return .5*Math.log((1+r)/(1-r))};Op.MaximumLatitude=Op.mercatorAngleToGeodeticLatitude(Math.PI);Op.prototype.project=function(e,r){var n=this._semimajorAxis,o=e.longitude*n,a=Op.geodeticLatitudeToMercatorAngle(e.latitude)*n,s=e.height;return p(r)?(r.x=o,r.y=a,r.z=s,r):new E(o,a,s)};Op.prototype.unproject=function(e,r){if(!p(e))throw new G("cartesian is required");var n=this._oneOverSemimajorAxis,o=e.x*n,a=Op.mercatorAngleToGeodeticLatitude(e.y*n),s=e.z;return p(r)?(r.longitude=o,r.latitude=a,r.height=s,r):new qe(o,a,s)};fo=Op});function GLt(e,r,n){var o=!n,a=e.length,s;if(!o&&a>1){var l=e[0].modelMatrix;for(s=1;s<a;++s)if(!Z.equals(l,e[s].modelMatrix)){o=!0;break}}if(o)for(s=0;s<a;++s)p(e[s].geometry)&&na.transformToWorldCoordinates(e[s]);else Z.multiplyTransformation(r,e[0].modelMatrix,r)}function mme(e,r){var n=e.attributes,o=n.position,a=o.values.length/o.componentsPerAttribute;n.batchId=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:1,values:new Float32Array(a)});for(var s=n.batchId.values,l=0;l<a;++l)s[l]=r}function HLt(e){for(var r=e.length,n=0;n<r;++n){var o=e[n];p(o.geometry)?mme(o.geometry,n):p(o.westHemisphereGeometry)&&p(o.eastHemisphereGeometry)&&(mme(o.westHemisphereGeometry,n),mme(o.eastHemisphereGeometry,n))}}function WLt(e){var r=e.instances,n=e.projection,o=e.elementIndexUintSupported,a=e.scene3DOnly,s=e.vertexCacheOptimize,l=e.compressVertices,h=e.modelMatrix,x,m,v,_=r.length;for(x=0;x<_;++x)if(p(r[x].geometry)){v=r[x].geometry.primitiveType;break}for(x=1;x<_;++x)if(p(r[x].geometry)&&r[x].geometry.primitiveType!==v)throw new G("All instance geometries must have the same primitiveType.");if(GLt(r,h,a),!a)for(x=0;x<_;++x)p(r[x].geometry)&&na.splitLongitude(r[x]);if(HLt(r),s)for(x=0;x<_;++x){var A=r[x];p(A.geometry)?(na.reorderForPostVertexCache(A.geometry),na.reorderForPreVertexCache(A.geometry)):p(A.westHemisphereGeometry)&&p(A.eastHemisphereGeometry)&&(na.reorderForPostVertexCache(A.westHemisphereGeometry),na.reorderForPreVertexCache(A.westHemisphereGeometry),na.reorderForPostVertexCache(A.eastHemisphereGeometry),na.reorderForPreVertexCache(A.eastHemisphereGeometry))}var T=na.combineInstances(r);for(_=T.length,x=0;x<_;++x){m=T[x];var w=m.attributes,S;if(a)for(S in w)w.hasOwnProperty(S)&&w[S].componentDatatype===Ie.DOUBLE&&na.encodeAttribute(m,S,S+"3DHigh",S+"3DLow");else for(S in w)if(w.hasOwnProperty(S)&&w[S].componentDatatype===Ie.DOUBLE){var P=S+"3D",M=S+"2D";na.projectTo2D(m,S,P,M,n),p(m.boundingSphere)&&S==="position"&&(m.boundingSphereCV=Ue.fromVertices(m.attributes.position2D.values)),na.encodeAttribute(m,P,P+"High",P+"Low"),na.encodeAttribute(m,M,M+"High",M+"Low")}l&&na.compressVertices(m)}if(!o){var L=[];for(_=T.length,x=0;x<_;++x)m=T[x],L=L.concat(na.fitToUnsignedShortIndices(m));T=L}return T}function pme(e,r,n,o){var a,s,l,h=o.length-1;if(h>=0){var x=o[h];a=x.offset+x.count,l=x.index,s=n[l].indices.length}else a=0,l=0,s=n[l].indices.length;for(var m=e.length,v=0;v<m;++v){var _=e[v],A=_[r];if(!!p(A)){var T=A.indices.length;a+T>s&&(a=0,s=n[++l].indices.length),o.push({index:l,offset:a,count:T}),a+=T}}}function qLt(e,r){var n=[];return pme(e,"geometry",r,n),pme(e,"westHemisphereGeometry",r,n),pme(e,"eastHemisphereGeometry",r,n),n}function jLt(e,r){var n=e.attributes;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o];p(a)&&p(a.values)&&r.push(a.values.buffer)}p(e.indices)&&r.push(e.indices.buffer)}function YLt(e,r){for(var n=e.length,o=0;o<n;++o)jLt(e[o],r)}function QLt(e){for(var r=1,n=e.length,o=0;o<n;o++){var a=e[o];if(++r,!!p(a)){var s=a.attributes;r+=7+2*Ue.packedLength+(p(a.indices)?a.indices.length:0);for(var l in s)if(s.hasOwnProperty(l)&&p(s[l])){var h=s[l];r+=6+h.values.length}}}return r}function XLt(e,r){var n=e.length,o=new Float64Array(1+n*19),a=0;o[a++]=n;for(var s=0;s<n;s++){var l=e[s];if(Z.pack(l.modelMatrix,o,a),a+=Z.packedLength,p(l.attributes)&&p(l.attributes.offset)){var h=l.attributes.offset.value;o[a]=h[0],o[a+1]=h[1],o[a+2]=h[2]}a+=3}return r.push(o.buffer),o}function KLt(e){for(var r=e,n=new Array(r[0]),o=0,a=1;a<r.length;){var s=Z.unpack(r,a),l;a+=Z.packedLength,p(r[a])&&(l={offset:new gl(r[a],r[a+1],r[a+2])}),a+=3,n[o++]={modelMatrix:s,attributes:l}}return n}function E6e(e){var r=e.length,n=1+(Ue.packedLength+1)*r,o=new Float32Array(n),a=0;o[a++]=r;for(var s=0;s<r;++s){var l=e[s];p(l)?(o[a++]=1,Ue.pack(e[s],o,a)):o[a++]=0,a+=Ue.packedLength}return o}function b6e(e){for(var r=new Array(e[0]),n=0,o=1;o<e.length;)e[o++]===1&&(r[n]=Ue.unpack(e,o)),++n,o+=Ue.packedLength;return r}var d1,eN,vme=Ee(()=>{hi();mi();Ze();De();st();Ii();iu();gs();_s();au();rh();_n();Rr();Q2();Yf();y(GLt,"transformToWorldCoordinates");y(mme,"addGeometryBatchId");y(HLt,"addBatchIds");y(WLt,"geometryPipeline");y(pme,"createPickOffsets");y(qLt,"createInstancePickOffsets");d1={};d1.combineGeometry=function(e){var r,n,o=e.instances,a=o.length,s,l,h=!1;a>0&&(r=WLt(e),r.length>0&&(n=na.createAttributeLocations(r[0]),e.createPickOffsets&&(s=qLt(o,r))),p(o[0].attributes)&&p(o[0].attributes.offset)&&(l=new Array(a),h=!0));for(var x=new Array(a),m=new Array(a),v=0;v<a;++v){var _=o[v],A=_.geometry;p(A)&&(x[v]=A.boundingSphere,m[v]=A.boundingSphereCV,h&&(l[v]=_.geometry.offsetAttribute));var T=_.eastHemisphereGeometry,w=_.westHemisphereGeometry;p(T)&&p(w)&&(p(T.boundingSphere)&&p(w.boundingSphere)&&(x[v]=Ue.union(T.boundingSphere,w.boundingSphere)),p(T.boundingSphereCV)&&p(w.boundingSphereCV)&&(m[v]=Ue.union(T.boundingSphereCV,w.boundingSphereCV)))}return{geometries:r,modelMatrix:e.modelMatrix,attributeLocations:n,pickOffsets:s,offsetInstanceExtend:l,boundingSpheres:x,boundingSpheresCV:m}};y(jLt,"transferGeometry");y(YLt,"transferGeometries");y(QLt,"countCreateGeometryResults");d1.packCreateGeometryResults=function(e,r){var n=new Float64Array(QLt(e)),o=[],a={},s=e.length,l=0;n[l++]=s;for(var h=0;h<s;h++){var x=e[h],m=p(x);if(n[l++]=m?1:0,!!m){n[l++]=x.primitiveType,n[l++]=x.geometryType,n[l++]=B(x.offsetAttribute,-1);var v=p(x.boundingSphere)?1:0;n[l++]=v,v&&Ue.pack(x.boundingSphere,n,l),l+=Ue.packedLength;var _=p(x.boundingSphereCV)?1:0;n[l++]=_,_&&Ue.pack(x.boundingSphereCV,n,l),l+=Ue.packedLength;var A=x.attributes,T=[];for(var w in A)A.hasOwnProperty(w)&&p(A[w])&&(T.push(w),p(a[w])||(a[w]=o.length,o.push(w)));n[l++]=T.length;for(var S=0;S<T.length;S++){var P=T[S],M=A[P];n[l++]=a[P],n[l++]=M.componentDatatype,n[l++]=M.componentsPerAttribute,n[l++]=M.normalize?1:0,n[l++]=M.isInstanceAttribute?1:0,n[l++]=M.values.length,n.set(M.values,l),l+=M.values.length}var L=p(x.indices)?x.indices.length:0;n[l++]=L,L>0&&(n.set(x.indices,l),l+=L)}}return r.push(n.buffer),{stringTable:o,packedData:n}};d1.unpackCreateGeometryResults=function(e){for(var r=e.stringTable,n=e.packedData,o,a=new Array(n[0]),s=0,l=1;l<n.length;){var h=n[l++]===1;if(!h){a[s++]=void 0;continue}var x=n[l++],m=n[l++],v=n[l++];v===-1&&(v=void 0);var _,A,T=n[l++]===1;T&&(_=Ue.unpack(n,l)),l+=Ue.packedLength;var w=n[l++]===1;w&&(A=Ue.unpack(n,l)),l+=Ue.packedLength;var S,P,M,L=new bo,R=n[l++];for(o=0;o<R;o++){var O=r[n[l++]],N=n[l++];M=n[l++];var k=n[l++]!==0,z=n[l++]!==0;S=n[l++],P=Ie.createTypedArray(N,S);for(var W=0;W<S;W++)P[W]=n[l++];L[O]=new wr({componentDatatype:N,componentsPerAttribute:M,normalize:k,values:P}),z&&(L[O].isInstanceAttribute=!0)}var j;if(S=n[l++],S>0){var q=P.length/M;for(j=tr.createTypedArray(q,S),o=0;o<S;o++)j[o]=n[l++]}a[s++]=new Ei({primitiveType:x,geometryType:m,boundingSphere:_,boundingSphereCV:A,indices:j,attributes:L,offsetAttribute:v})}return a};y(XLt,"packInstancesForCombine");y(KLt,"unpackInstancesForCombine");d1.packCombineGeometryParameters=function(e,r){for(var n=e.createGeometryResults,o=n.length,a=0;a<o;a++)r.push(n[a].packedData.buffer);return{createGeometryResults:e.createGeometryResults,packedInstances:XLt(e.instances,r),ellipsoid:e.ellipsoid,isGeographic:e.projection instanceof yo,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e.createPickOffsets}};d1.unpackCombineGeometryParameters=function(e){for(var r=KLt(e.packedInstances),n=e.createGeometryResults,o=n.length,a=0,s=0;s<o;s++)for(var l=d1.unpackCreateGeometryResults(n[s]),h=l.length,x=0;x<h;x++){var m=l[x],v=r[a];v.geometry=m,++a}var _=nt.clone(e.ellipsoid),A=e.isGeographic?new yo(_):new fo(_);return{instances:r,ellipsoid:_,projection:A,elementIndexUintSupported:e.elementIndexUintSupported,scene3DOnly:e.scene3DOnly,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:Z.clone(e.modelMatrix),createPickOffsets:e.createPickOffsets}};y(E6e,"packBoundingSpheres");y(b6e,"unpackBoundingSpheres");d1.packCombineGeometryResults=function(e,r){p(e.geometries)&&YLt(e.geometries,r);var n=E6e(e.boundingSpheres),o=E6e(e.boundingSpheresCV);return r.push(n.buffer,o.buffer),{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:n,boundingSpheresCV:o}};d1.unpackCombineGeometryResults=function(e){return{geometries:e.geometries,attributeLocations:e.attributeLocations,modelMatrix:e.modelMatrix,pickOffsets:e.pickOffsets,offsetInstanceExtend:e.offsetInstanceExtend,boundingSpheres:b6e(e.boundingSpheres),boundingSpheresCV:b6e(e.boundingSpheresCV)}};eN=d1});var ZLt,I0,lX=Ee(()=>{ZLt={READY:0,CREATING:1,CREATED:2,COMBINING:3,COMBINED:4,COMPLETE:5,FAILED:6},I0=Object.freeze(ZLt)});var wg,Uo,zh=Ee(()=>{wg={DISABLED:0,ENABLED:1,CAST_ONLY:2,RECEIVE_ONLY:3,NUMBER_OF_SHADOW_MODES:4};wg.castShadows=function(e){return e===wg.ENABLED||e===wg.CAST_ONLY};wg.receiveShadows=function(e){return e===wg.ENABLED||e===wg.RECEIVE_ONLY};wg.fromCastReceive=function(e,r){return e&&r?wg.ENABLED:e?wg.CAST_ONLY:r?wg.RECEIVE_ONLY:wg.DISABLED};Uo=Object.freeze(wg)});function S6e(e){return e===gme.REFLECT||e===gme.REFRACT}var gme,So,J0=Ee(()=>{gme={NORMAL:0,REFLECT:1,DEPTH:2,NORMAL_AND_DEPTH:3,POSTEFFECT_FILTER:4,RASTER:5,CLAMP:6,PICKRECT:7,SQRESULT:8};y(S6e,"isFBOSupportMulitViewport");So=Object.freeze(gme)});function JLt(e,r){this.positions=p(e)?e:[],this.holes=p(r)?r:[]}var ih,US=Ee(()=>{De();y(JLt,"PolygonHierarchy");ih=JLt});function GS(e){this._value=void 0,this._hasClone=!1,this._hasEquals=!1,this._definitionChanged=new It,this.setValue(e)}var es,jC=Ee(()=>{De();ti();y(GS,"ConstantProperty");Object.defineProperties(GS.prototype,{isConstant:{value:!0},definitionChanged:{get:function(){return this._definitionChanged}}});GS.prototype.getValue=function(e,r){return this._hasClone?this._value.clone(r):this._value};GS.prototype.setValue=function(e){var r=this._value;if(r!==e){var n=p(e),o=n&&typeof e.clone=="function",a=n&&typeof e.equals=="function",s=!a||!e.equals(r);s&&(this._hasClone=o,this._hasEquals=a,this._value=o?e.clone(this._value):e,this._definitionChanged.raiseEvent(this))}};GS.prototype.equals=function(e){return this===e||e instanceof GS&&(!this._hasEquals&&this._value===e._value||this._hasEquals&&this._value.equals(e._value))};GS.prototype.valueOf=function(){return this._value};GS.prototype.toString=function(){return String(this._value)};es=GS});function $Lt(e,r,n,o,a){return{configurable:o,get:function(){return this[r]},set:function(s){var l=this[r],h=this[n];p(h)&&(h(),this[n]=void 0);var x=s!==void 0;x&&(!p(s)||!p(s.getValue))&&p(a)&&(s=a(s)),l!==s&&(this[r]=s,this._definitionChanged.raiseEvent(this,e,s,l)),p(s)&&p(s.definitionChanged)&&(this[n]=s.definitionChanged.addEventListener(function(){this._definitionChanged.raiseEvent(this,e,s,s)},this))}}}function eOt(e){return new es(e)}function tOt(e,r,n){return $Lt(e,"_"+e.toString(),"_"+e.toString()+"Subscription",B(r,!1),B(n,eOt))}var gt,ks=Ee(()=>{Ze();De();jC();y($Lt,"createProperty");y(eOt,"createConstantProperty");y(tOt,"createPropertyDescriptor");gt=tOt});function By(){G.throwInstantiationError()}var Ne,Go=Ee(()=>{Ze();De();st();y(By,"Property");Object.defineProperties(By.prototype,{isConstant:{get:G.throwInstantiationError},definitionChanged:{get:G.throwInstantiationError}});By.prototype.getValue=G.throwInstantiationError;By.prototype.equals=G.throwInstantiationError;By.equals=function(e,r){return e===r||p(e)&&e.equals(r)};By.arrayEquals=function(e,r){if(e===r)return!0;if(!p(e)||!p(r)||e.length!==r.length)return!1;for(var n=e.length,o=0;o<n;o++)if(!By.equals(e[o],r[o]))return!1;return!0};By.isConstant=function(e){return!p(e)||e.isConstant};By.getValueOrUndefined=function(e,r,n){return p(e)?e.getValue(r,n):void 0};By.getValueOrDefault=function(e,r,n,o){return p(e)?B(e.getValue(r,o),n):n};By.getValueOrClonedDefault=function(e,r,n,o){var a;return p(e)&&(a=e.getValue(r,o)),p(a)||(a=n.clone(a)),a};Ne=By});function tN(e){this._definitionChanged=new It,this._color=void 0,this._colorSubscription=void 0,this.color=e}var Yi,h0=Ee(()=>{Ar();De();ti();ks();Go();y(tN,"ColorMaterialProperty");Object.defineProperties(tN.prototype,{isConstant:{get:function(){return Ne.isConstant(this._color)}},definitionChanged:{get:function(){return this._definitionChanged}},color:gt("color")});tN.prototype.getType=function(e){return"Color"};tN.prototype.getValue=function(e,r){return p(r)||(r={}),r.color=Ne.getValueOrClonedDefault(this._color,e,se.WHITE,r.color),r};tN.prototype.equals=function(e){return this===e||e instanceof tN&&Ne.equals(this._color,e._color)};Yi=tN});function rN(e){e=B(e,B.EMPTY_OBJECT),this._definitionChanged=new It,this._image=void 0,this._imageSubscription=void 0,this._repeat=void 0,this._repeatSubscription=void 0,this._color=void 0,this._colorSubscription=void 0,this._transparent=void 0,this._transparentSubscription=void 0,this._unique=!1,this.image=e.image,this.repeat=e.repeat,this.color=e.color,this.transparent=e.transparent,this._unique=e.unique}var rOt,iOt,nOt,lB,uX=Ee(()=>{Fr();Ar();Ze();De();ti();ks();Go();rOt=new de(1,1),iOt=!1,nOt=se.WHITE;y(rN,"ImageMaterialProperty");Object.defineProperties(rN.prototype,{isConstant:{get:function(){return Ne.isConstant(this._image)&&Ne.isConstant(this._repeat)}},definitionChanged:{get:function(){return this._definitionChanged}},image:gt("image"),repeat:gt("repeat"),color:gt("color"),transparent:gt("transparent")});rN.prototype.getType=function(e){return"Image"};rN.prototype.getValue=function(e,r){return p(r)||(r={}),r.image=Ne.getValueOrUndefined(this._image,e),r.repeat=Ne.getValueOrClonedDefault(this._repeat,e,rOt,r.repeat),r.color=Ne.getValueOrClonedDefault(this._color,e,nOt,r.color),Ne.getValueOrDefault(this._transparent,e,iOt)&&(r.color.alpha=Math.min(.99,r.color.alpha)),r};rN.prototype.equals=function(e){return this===e||e instanceof rN&&Ne.equals(this._image,e._image)&&Ne.equals(this._repeat,e._repeat)&&Ne.equals(this._color,e._color)&&Ne.equals(this._transparent,e._transparent)&&!this._unique&&!e._unique};lB=rN});function oOt(e){if(e instanceof se)return new Yi(e);if(typeof e=="string"||e instanceof ir||e instanceof HTMLCanvasElement||e instanceof HTMLVideoElement||e instanceof Vt){var r=new lB;return r.image=e,r}throw new G("Unable to infer material type: "+e)}function aOt(e,r){return gt(e,r,oOt)}var ju,Fp=Ee(()=>{Ar();st();hn();h0();ks();uX();yn();y(oOt,"createMaterialProperty");y(aOt,"createMaterialPropertyDescriptor");ju=aOt});function X2(e,r){e=B(e,0),this._near=e,r=B(r,Number.MAX_VALUE),this._far=r}var Qi,$0=Ee(()=>{Ze();De();st();y(X2,"DistanceDisplayCondition");Object.defineProperties(X2.prototype,{near:{get:function(){return this._near},set:function(e){this._near=e}},far:{get:function(){return this._far},set:function(e){this._far=e}}});X2.packedLength=2;X2.pack=function(e,r,n){if(!p(e))throw new G("value is required");if(!p(r))throw new G("array is required");return n=B(n,0),r[n++]=e.near,r[n]=e.far,r};X2.unpack=function(e,r,n){if(!p(e))throw new G("array is required");return r=B(r,0),p(n)||(n=new X2),n.near=e[r++],n.far=e[r],n};X2.equals=function(e,r){return e===r||p(e)&&p(r)&&e.near===r.near&&e.far===r.far};X2.clone=function(e,r){if(!!p(e))return p(r)||(r=new X2),r.near=e.near,r.far=e.far,r};X2.prototype.clone=function(e){return X2.clone(this,e)};X2.prototype.equals=function(e){return X2.equals(this,e)};Qi=X2});var HS,WH=Ee(()=>{HS=`void clipLineSegmentToNearPlane(
    vec3 p0,
    vec3 p1,
    out vec4 positionWC,
    out bool clipped,
    out bool culledByNearPlane,
    out vec4 clippedPositionEC)
{
    culledByNearPlane = false;
    clipped = false;

    vec3 p0ToP1 = p1 - p0;
    float magnitude = length(p0ToP1);
    vec3 direction = normalize(p0ToP1);

    // Distance that p0 is behind the near plane. Negative means p0 is
    // in front of the near plane.
    float endPoint0Distance =  czm_currentFrustum.x + p0.z;

    // Camera looks down -Z.
    // When moving a point along +Z: LESS VISIBLE
    //   * Points in front of the camera move closer to the camera.
    //   * Points behind the camrea move farther away from the camera.
    // When moving a point along -Z: MORE VISIBLE
    //   * Points in front of the camera move farther away from the camera.
    //   * Points behind the camera move closer to the camera.

    // Positive denominator: -Z, becoming more visible
    // Negative denominator: +Z, becoming less visible
    // Nearly zero: parallel to near plane
    float denominator = -direction.z;

    if (endPoint0Distance > 0.0 && abs(denominator) < czm_epsilon7)
    {
        // p0 is behind the near plane and the line to p1 is nearly parallel to
        // the near plane, so cull the segment completely.
        culledByNearPlane = true;
    }
    else if (endPoint0Distance > 0.0)
    {
        // p0 is behind the near plane, and the line to p1 is moving distinctly
        // toward or away from it.

        // t = (-plane distance - dot(plane normal, ray origin)) / dot(plane normal, ray direction)
        float t = endPoint0Distance / denominator;
        if (t < 0.0 || t > magnitude)
        {
            // Near plane intersection is not between the two points.
            // We already confirmed p0 is behind the naer plane, so now
            // we know the entire segment is behind it.
            culledByNearPlane = true;
        }
        else
        {
            // Segment crosses the near plane, update p0 to lie exactly on it.
            p0 = p0 + t * direction;

            // Numerical noise might put us a bit on the wrong side of the near plane.
            // Don't let that happen.
            p0.z = min(p0.z, -czm_currentFrustum.x);

            clipped = true;
        }
    }

    clippedPositionEC = vec4(p0, 1.0);
    positionWC = czm_eyeToWindowCoordinates(clippedPositionEC);
}

vec4 getPolylineWindowCoordinatesEC(vec4 positionEC, vec4 prevEC, vec4 nextEC, float expandDirection, float width, bool usePrevious, out float angle)
{
    // expandDirection +1 is to the _left_ when looking from positionEC toward nextEC.

#ifdef POLYLINE_DASH
    // Compute the window coordinates of the points.
    vec4 positionWindow = czm_eyeToWindowCoordinates(positionEC);
    vec4 previousWindow = czm_eyeToWindowCoordinates(prevEC);
    vec4 nextWindow = czm_eyeToWindowCoordinates(nextEC);

    // Determine the relative screen space direction of the line.
    vec2 lineDir;
    if (usePrevious) {
        lineDir = normalize(positionWindow.xy - previousWindow.xy);
    }
    else {
        lineDir = normalize(nextWindow.xy - positionWindow.xy);
    }
    angle = atan(lineDir.x, lineDir.y) - 1.570796327; // precomputed atan(1,0)

    // Quantize the angle so it doesn't change rapidly between segments.
    angle = floor(angle / czm_piOverFour + 0.5) * czm_piOverFour;
#endif

    vec4 clippedPrevWC, clippedPrevEC;
    bool prevSegmentClipped, prevSegmentCulled;
    clipLineSegmentToNearPlane(prevEC.xyz, positionEC.xyz, clippedPrevWC, prevSegmentClipped, prevSegmentCulled, clippedPrevEC);

    vec4 clippedNextWC, clippedNextEC;
    bool nextSegmentClipped, nextSegmentCulled;
    clipLineSegmentToNearPlane(nextEC.xyz, positionEC.xyz, clippedNextWC, nextSegmentClipped, nextSegmentCulled, clippedNextEC);

    bool segmentClipped, segmentCulled;
    vec4 clippedPositionWC, clippedPositionEC;
    clipLineSegmentToNearPlane(positionEC.xyz, usePrevious ? prevEC.xyz : nextEC.xyz, clippedPositionWC, segmentClipped, segmentCulled, clippedPositionEC);

    if (segmentCulled)
    {
        return vec4(0.0, 0.0, 0.0, 1.0);
    }

    vec2 directionToPrevWC = normalize(clippedPrevWC.xy - clippedPositionWC.xy);
    vec2 directionToNextWC = normalize(clippedNextWC.xy - clippedPositionWC.xy);

    // If a segment was culled, we can't use the corresponding direction
    // computed above. We should never see both of these be true without
    // \`segmentCulled\` above also being true.
    if (prevSegmentCulled)
    {
        directionToPrevWC = -directionToNextWC;
    }
    else if (nextSegmentCulled)
    {
        directionToNextWC = -directionToPrevWC;
    }

    vec2 thisSegmentForwardWC, otherSegmentForwardWC;
    if (usePrevious)
    {
        thisSegmentForwardWC = -directionToPrevWC;
        otherSegmentForwardWC = directionToNextWC;
    }
    else
    {
        thisSegmentForwardWC = directionToNextWC;
        otherSegmentForwardWC =  -directionToPrevWC;
    }

    vec2 thisSegmentLeftWC = vec2(-thisSegmentForwardWC.y, thisSegmentForwardWC.x);


    #ifdef LINEJOIN_BEVEL
    vec2 dir1 = normalize(thisSegmentForwardWC);
    vec2 dir2 = normalize(otherSegmentForwardWC);
    vec2 perp = vec2(-dir1.y, dir1.x);
    vec2 dir = normalize(perp);
    vec2 offset = dir * width * 0.5 * expandDirection * czm_pixelRatio;
    return vec4(clippedPositionWC.xy + offset, -clippedPositionWC.z, 1.0) * (czm_projection * clippedPositionEC).w;
    #else

    vec2 leftWC = thisSegmentLeftWC;
    float expandWidth = width * 0.5;

    // When lines are split at the anti-meridian, the position may be at the
    // same location as the next or previous position, and we need to handle
    // that to avoid producing NaNs.
    if (!czm_equalsEpsilon(prevEC.xyz - positionEC.xyz, vec3(0.0), czm_epsilon1) && !czm_equalsEpsilon(nextEC.xyz - positionEC.xyz, vec3(0.0), czm_epsilon1))
    {
        vec2 otherSegmentLeftWC = vec2(-otherSegmentForwardWC.y, otherSegmentForwardWC.x);

        vec2 leftSumWC = thisSegmentLeftWC + otherSegmentLeftWC;
        float leftSumLength = length(leftSumWC);
        leftWC = leftSumLength < czm_epsilon6 ? thisSegmentLeftWC : (leftSumWC / leftSumLength);

        // The sine of the angle between the two vectors is given by the formula
        //         |a x b| = |a||b|sin(theta)
        // which is
        //     float sinAngle = length(cross(vec3(leftWC, 0.0), vec3(-thisSegmentForwardWC, 0.0)));
        // Because the z components of both vectors are zero, the x and y coordinate will be zero.
        // Therefore, the sine of the angle is just the z component of the cross product.
        vec2 u = -thisSegmentForwardWC;
        vec2 v = leftWC;
        float sinAngle = abs(u.x * v.y - u.y * v.x);
        expandWidth = clamp(expandWidth / sinAngle, 0.0, width * 2.0);
    }

    vec2 offset = leftWC * expandDirection * expandWidth * czm_pixelRatio;
    return vec4(clippedPositionWC.xy + offset, -clippedPositionWC.z, 1.0) * (czm_projection * clippedPositionEC).w;
    #endif
}

vec4 getPolylineWindowCoordinates(vec4 position, vec4 previous, vec4 next, float expandDirection, float width, bool usePrevious, out float angle)
{
    vec4 positionEC = czm_modelViewRelativeToEye * position;
    vec4 prevEC = czm_modelViewRelativeToEye * previous;
    vec4 nextEC = czm_modelViewRelativeToEye * next;
    return getPolylineWindowCoordinatesEC(positionEC, prevEC, nextEC, expandDirection, width, usePrevious, angle);
}
`});var cX,_me=Ee(()=>{cX=`#ifdef VECTOR_TILE
uniform vec4 u_highlightColor;
#endif

varying vec2 v_st;
varying float v_alpha;

#ifdef TRAIL
uniform float spotIntensity;
varying vec3 v_dist;
varying float v_SpotPercent;
#endif

void main()
{
    czm_materialInput materialInput;

    vec2 st = v_st;
    st.t = czm_readNonPerspective(st.t, gl_FragCoord.w);

    materialInput.s = st.s;
    materialInput.st = st;
    materialInput.str = vec3(st, 0.0);

    czm_material material = czm_getMaterial(materialInput);
    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);
#ifdef VECTOR_TILE
    gl_FragColor *= u_highlightColor;
#endif

#ifdef ENABLE_DYNAMIC
    float alpha = v_alpha;
    if(bAsy_4 != 1.0){
        alpha = 0.0;
    }
    gl_FragColor.a = pow(max(0.0, sin(3.14159 * (alpha + (1.0 - 2.0*v_time_3)))), 3.5);
#endif

#ifdef TRAIL
    float elapsedTime = trailTime_1 - startTime_7;
    float t = mod(elapsedTime, period_6) / period_6; 
    float x = 0.0;
    float s1 = t * v_dist.y;
    float s2 = (t - trailLength_3) * v_dist.y;
    float trailLen = trailLength_3 * v_dist.y;
    if(t < trailLength_3 && v_dist.x > t * v_dist.y){
        x = v_dist.x - v_dist.y;
    }else{
        x = v_dist.x;
    }
    float percent = (x - s2) / trailLen;

    if(percent > 1.0 || percent < 0.0)
    {
        discard;
    }
    float fade = percent;
    if(percent > (1.0 - v_SpotPercent))
    {
        gl_FragColor.rgb *= spotIntensity_4;
    }
    gl_FragColor.a *= fade;
#endif


}
`});var I6e,P6e=Ee(()=>{I6e=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec3 position2DHigh;
attribute vec3 position2DLow;
attribute vec3 prevPosition3DHigh;
attribute vec3 prevPosition3DLow;
attribute vec3 prevPosition2DHigh;
attribute vec3 prevPosition2DLow;
attribute vec3 nextPosition3DHigh;
attribute vec3 nextPosition3DLow;
attribute vec3 nextPosition2DHigh;
attribute vec3 nextPosition2DLow;
attribute vec4 texCoordExpandAndBatchIndex;

varying vec2  v_st;
varying float v_width;
varying vec4 v_pickColor;
varying float v_polylineAngle;
varying float v_alpha;

void main()
{
    float texCoord = texCoordExpandAndBatchIndex.x;
    float expandDir = texCoordExpandAndBatchIndex.y;
    bool usePrev = texCoordExpandAndBatchIndex.z < 0.0;
    float batchTableIndex = texCoordExpandAndBatchIndex.w;

    vec2 widthAndShow = batchTable_getWidthAndShow(batchTableIndex);
    float width = widthAndShow.x + 0.5;
    float show = widthAndShow.y;

    if (width < 1.0)
    {
        show = 0.0;
    }

    vec4 pickColor = batchTable_getPickColor(batchTableIndex);

    vec4 p, prev, next;
    if (czm_morphTime == 1.0)
    {
        p = czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz);
        prev = czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz);
        next = czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz);
    }
    else if (czm_morphTime == 0.0)
    {
        p = czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy);
        prev = czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy);
        next = czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy);
    }
    else
    {
        p = czm_columbusViewMorph(
                czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy),
                czm_translateRelativeToEye(position3DHigh.xyz, position3DLow.xyz),
                czm_morphTime);
        prev = czm_columbusViewMorph(
                czm_translateRelativeToEye(prevPosition2DHigh.zxy, prevPosition2DLow.zxy),
                czm_translateRelativeToEye(prevPosition3DHigh.xyz, prevPosition3DLow.xyz),
                czm_morphTime);
        next = czm_columbusViewMorph(
                czm_translateRelativeToEye(nextPosition2DHigh.zxy, nextPosition2DLow.zxy),
                czm_translateRelativeToEye(nextPosition3DHigh.xyz, nextPosition3DLow.xyz),
                czm_morphTime);
    }

    #ifdef DISTANCE_DISPLAY_CONDITION
        vec3 centerHigh = batchTable_getCenterHigh(batchTableIndex);
        vec4 centerLowAndRadius = batchTable_getCenterLowAndRadius(batchTableIndex);
        vec3 centerLow = centerLowAndRadius.xyz;
        float radius = centerLowAndRadius.w;
        vec2 distanceDisplayCondition = batchTable_getDistanceDisplayCondition(batchTableIndex);

        float lengthSq;
        if (czm_sceneMode == czm_sceneMode2D)
        {
            lengthSq = czm_eyeHeight2D.y;
        }
        else
        {
            vec4 center = czm_translateRelativeToEye(centerHigh.xyz, centerLow.xyz);
            lengthSq = max(0.0, dot(center.xyz, center.xyz) - radius * radius);
        }

        float nearSq = distanceDisplayCondition.x * distanceDisplayCondition.x;
        float farSq = distanceDisplayCondition.y * distanceDisplayCondition.y;
        if (lengthSq < nearSq || lengthSq > farSq)
        {
            show = 0.0;
        }
    #endif

    float polylineAngle;
    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev, polylineAngle);
    gl_Position = czm_viewportOrthographic * positionWC * show;

    v_st.s = texCoord;
    v_st.t = czm_writeNonPerspective(clamp(expandDir, 0.0, 1.0), gl_Position.w);

    v_width = width;
    v_pickColor = pickColor;
    v_polylineAngle = polylineAngle;
    v_alpha = abs(texCoord);
}
`});function iN(e,r,n,o,a){this._format=e,this._width=r,this._height=n,this._buffer=o,this._datatype=a}var wm,WS=Ee(()=>{De();y(iN,"CompressedTextureBuffer");Object.defineProperties(iN.prototype,{internalFormat:{get:function(){return this._format}},width:{get:function(){return this._width}},height:{get:function(){return this._height}},bufferView:{get:function(){return this._buffer}},pixelDatatype:{get:function(){return this._datatype}}});iN.clone=function(e){if(!!p(e))return new iN(e._format,e._width,e._height,e._buffer,e._datatype)};iN.prototype.clone=function(){return iN.clone(this)};wm=iN});function lOt(e,r,n){if(n){if(!p(e))throw new G("resourceOrUrlOrBuffer is required.");var o;if(e instanceof ArrayBuffer||ArrayBuffer.isView(e))o=Je.resolve(e);else{var a=ir.createIfNeeded(e);o=a.fetchArrayBuffer()}return p(o)?o.then(function(s){if(!!p(s)){var l=[];return s instanceof ArrayBuffer?l.push(s):(s.byteOffset===0&&s.byteLength===s.buffer.byteLength||(s=s.slice(0,s.length)),l.push(s.buffer)),sOt.scheduleTask(s,l)}}).then(function(s){return wm.clone(s)}):void 0}else{if(p(fX)||(fX=new On("transcodeCRNToDXT",Number.POSITIVE_INFINITY),fX.initWebAssemblyModule({modulePath:"ThirdParty/crunch.js",wasmBinaryFile:"ThirdParty/crunch.wasm"}).then(function(){D6e=!0})),!D6e)return;if(!p(e))throw new G("resourceOrUrlOrBuffer is required.");var o;if(e instanceof ArrayBuffer||ArrayBuffer.isView(e))o=Je.resolve(e);else{var a=ir.createIfNeeded(e);o=a.fetchArrayBuffer()}return p(o)?o.then(function(l){if(!!p(l)){var h=[];l instanceof ArrayBuffer?h.push(l):(l.byteOffset===0&&l.byteLength===l.buffer.byteLength||(l=l.slice(0,l.length)),h.push(l.buffer));var x=B(r,!1);return fX.scheduleTask({data:l,bMipMap:x},h)}}).then(function(l){return wm.clone(l)}):void 0}}var fX,D6e,sOt,Id,m1=Ee(()=>{li();WS();De();st();hn();vl();Ze();D6e=!1,sOt=new On("transcodeCRNToDXTprevious",Number.POSITIVE_INFINITY);y(lOt,"loadCRN");Id=lOt});function uOt(e){X.defined("resourceOrUrlOrBuffer",e);var r;if(e instanceof ArrayBuffer||ArrayBuffer.isView(e))r=Je.resolve(e);else{var n=ir.createIfNeeded(e);r=n.fetchArrayBuffer()}if(!!p(r))return r.then(function(o){if(p(o))return fOt(o)})}function fOt(e){var r=new Uint8Array(e),n=!0,o;for(o=0;o<M6e.length;++o)if(M6e[o]!==r[o]){n=!1;break}if(!n)throw new Ht("Invalid KTX file.");var a,s;p(e.buffer)?(a=new DataView(e.buffer),s=e.byteOffset):(a=new DataView(e),s=0),s+=12;var l=a.getUint32(s,!0);if(s+=Np,l!==cOt)throw new Ht("File is the wrong endianness.");var h=a.getUint32(s,!0);s+=Np;var x=a.getUint32(s,!0);s+=Np;var m=a.getUint32(s,!0);s+=Np;var v=a.getUint32(s,!0);s+=Np;var _=a.getUint32(s,!0);s+=Np;var A=a.getUint32(s,!0);s+=Np;var T=a.getUint32(s,!0);s+=Np;var w=a.getUint32(s,!0);s+=Np;var S=a.getUint32(s,!0);s+=Np;var P=a.getUint32(s,!0);s+=Np;var M=a.getUint32(s,!0);s+=Np;var L=a.getUint32(s,!0);s+=Np,s+=L;var R=a.getUint32(s,!0);s+=Np;var O;if(p(e.buffer)?O=new Uint8Array(e.buffer,s,R):O=new Uint8Array(e,s,R),v===Se.RGB8?v=pt.RGB:v===Se.RGBA8&&(v=pt.RGBA),!pt.validate(v))throw new Ht("glInternalFormat is not a valid format.");if(pt.isCompressedFormat(v)){if(h!==0)throw new Ht("glType must be zero when the texture is compressed.");if(x!==1)throw new Ht("The type size for compressed textures must be 1.");if(m!==0)throw new Ht("glFormat must be zero when the texture is compressed.")}else{if(h!==Se.UNSIGNED_BYTE)throw new Ht("Only unsigned byte buffers are supported.");if(_!==m)throw new Ht("The base internal format must be the same as the format for uncompressed textures.")}if(w!==0)throw new Ht("3D textures are unsupported.");if(S!==0)throw new Ht("Texture arrays are unsupported.");var N=O.byteOffset,k=new Array(M);for(o=0;o<M;++o){for(var z=k[o]={},W=0;W<P;++W){var j=A>>o,q=T>>o,I=pt.isCompressedFormat(v)?pt.compressedTextureSizeInBytes(v,j,q):pt.textureSizeInBytes(v,h,j,q),F=new Uint8Array(O.buffer,N,I);z[B6e[W]]=new wm(v,j,q,F),N+=I}N+=3-(N+3)%4+4}var V=k;if(P===1)for(o=0;o<M;++o)V[o]=V[o][B6e[0]];return M===1&&(V=V[0]),V}var M6e,cOt,B6e,Np,zp,qS=Ee(()=>{li();cr();WS();De();Mn();hn();zo();co();y(uOt,"loadKTX");M6e=[171,75,84,88,32,49,49,187,13,10,26,10],cOt=67305985,B6e=["positiveX","negativeX","positiveY","negativeY","positiveZ","negativeZ"],Np=4;y(fOt,"parseKTX");zp=uOt});var R6e,L6e=Ee(()=>{R6e=`uniform sampler2D image;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);
    vec4 rampColor = texture2D(image, vec2(materialInput.aspect / (2.0 * czm_pi), 0.5));
    rampColor = czm_gammaCorrect(rampColor);
    material.diffuse = rampColor.rgb;
    material.alpha = rampColor.a;
    return material;
}
`});var O6e,F6e=Ee(()=>{O6e=`uniform sampler2D image;
uniform float strength;
uniform vec2 repeat;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;

    vec2 centerPixel = fract(repeat * st);
    float centerBump = texture2D(image, centerPixel).channel;

    float imageWidth = float(imageDimensions.x);
    vec2 rightPixel = fract(repeat * (st + vec2(1.0 / imageWidth, 0.0)));
    float rightBump = texture2D(image, rightPixel).channel;

    float imageHeight = float(imageDimensions.y);
    vec2 leftPixel = fract(repeat * (st + vec2(0.0, 1.0 / imageHeight)));
    float topBump = texture2D(image, leftPixel).channel;

    vec3 normalTangentSpace = normalize(vec3(centerBump - rightBump, centerBump - topBump, clamp(1.0 - strength, 0.1, 1.0)));
    vec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;

    material.normal = normalEC;
    material.diffuse = vec3(0.01);

    return material;
}
`});var N6e,z6e=Ee(()=>{N6e=`uniform vec4 lightColor;
uniform vec4 darkColor;
uniform vec2 repeat;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;

    // From Stefan Gustavson's Procedural Textures in GLSL in OpenGL Insights
    float b = mod(floor(repeat.s * st.s) + floor(repeat.t * st.t), 2.0);  // 0.0 or 1.0

    // Find the distance from the closest separator (region between two colors)
    float scaledWidth = fract(repeat.s * st.s);
    scaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));
    float scaledHeight = fract(repeat.t * st.t);
    scaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));
    float value = min(scaledWidth, scaledHeight);

    vec4 currentColor = mix(lightColor, darkColor, b);
    vec4 color = czm_antialias(lightColor, darkColor, currentColor, value, 0.03);

    color = czm_gammaCorrect(color);
    material.diffuse = color.rgb;
    material.alpha = color.a;

    return material;
}
`});var V6e,k6e=Ee(()=>{V6e=`uniform vec4 lightColor;
uniform vec4 darkColor;
uniform vec2 repeat;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    // From Stefan Gustavson's Procedural Textures in GLSL in OpenGL Insights
    float b = smoothstep(0.3, 0.32, length(fract(repeat * materialInput.st) - 0.5));  // 0.0 or 1.0

    vec4 color = mix(lightColor, darkColor, b);
    color = czm_gammaCorrect(color);
    material.diffuse = color.rgb;
    material.alpha = color.a;

    return material;
}
`});var U6e,G6e=Ee(()=>{U6e=`#ifdef GL_OES_standard_derivatives
    #extension GL_OES_standard_derivatives : enable
#endif

uniform vec4 color;
uniform float spacing;
uniform float width;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    float distanceToContour = mod(materialInput.height, spacing);

#ifdef GL_OES_standard_derivatives
    float dxc = abs(dFdx(materialInput.height));
    float dyc = abs(dFdy(materialInput.height));
    float dF = max(dxc, dyc) * czm_pixelRatio * width;
    float alpha = (distanceToContour < dF) ? 1.0 : 0.0;
#else
    float alpha = (distanceToContour < (czm_pixelRatio * width)) ? 1.0 : 0.0;
#endif

    vec4 outColor = czm_gammaCorrect(vec4(color.rgb, alpha));
    material.diffuse = outColor.rgb;
    material.alpha = outColor.a;

    return material;
}
`});var H6e,W6e=Ee(()=>{H6e=`uniform sampler2D image;
uniform float minimumHeight;
uniform float maximumHeight;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);
    float scaledHeight = clamp((materialInput.height - minimumHeight) / (maximumHeight - minimumHeight), 0.0, 1.0);
    vec4 rampColor = texture2D(image, vec2(scaledHeight, 0.5));
    rampColor = czm_gammaCorrect(rampColor);
    material.diffuse = rampColor.rgb;
    material.alpha = rampColor.a;
    return material;
}
`});var q6e,j6e=Ee(()=>{q6e=`uniform vec4 fadeInColor;
uniform vec4 fadeOutColor;
uniform float maximumDistance;
uniform bool repeat;
uniform vec2 fadeDirection;
uniform vec2 time;

float getTime(float t, float coord)
{
    float scalar = 1.0 / maximumDistance;
    float q  = distance(t, coord) * scalar;
    if (repeat)
    {
        float r = distance(t, coord + 1.0) * scalar;
        float s = distance(t, coord - 1.0) * scalar;
        q = min(min(r, s), q);
    }
    return clamp(q, 0.0, 1.0);
}

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;
    float s = getTime(time.x, st.s) * fadeDirection.s;
    float t = getTime(time.y, st.t) * fadeDirection.t;

    float u = length(vec2(s, t));
    vec4 color = mix(fadeInColor, fadeOutColor, u);

    color = czm_gammaCorrect(color);
    material.emission = color.rgb;
    material.alpha = color.a;

    return material;
}
`});var Y6e,Q6e=Ee(()=>{Y6e=`#ifdef GL_OES_standard_derivatives
    #extension GL_OES_standard_derivatives : enable
#endif

uniform vec4 color;
uniform float cellAlpha;
uniform vec2 lineCount;
uniform vec2 lineThickness;
uniform vec2 lineOffset;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;

    float scaledWidth = fract(lineCount.s * st.s - lineOffset.s);
    scaledWidth = abs(scaledWidth - floor(scaledWidth + 0.5));
    float scaledHeight = fract(lineCount.t * st.t - lineOffset.t);
    scaledHeight = abs(scaledHeight - floor(scaledHeight + 0.5));

    float value;
#ifdef GL_OES_standard_derivatives
    // Fuzz Factor - Controls blurriness of lines
    const float fuzz = 1.2;
    vec2 thickness = (lineThickness * czm_pixelRatio) - 1.0;

    // From "3D Engine Design for Virtual Globes" by Cozzi and Ring, Listing 4.13.
    vec2 dx = abs(dFdx(st));
    vec2 dy = abs(dFdy(st));
    vec2 dF = vec2(max(dx.s, dy.s), max(dx.t, dy.t)) * lineCount;
    value = min(
        smoothstep(dF.s * thickness.s, dF.s * (fuzz + thickness.s), scaledWidth),
        smoothstep(dF.t * thickness.t, dF.t * (fuzz + thickness.t), scaledHeight));
#else
    // Fuzz Factor - Controls blurriness of lines
    const float fuzz = 0.05;

    vec2 range = 0.5 - (lineThickness * 0.05);
    value = min(
        1.0 - smoothstep(range.s, range.s + fuzz, scaledWidth),
        1.0 - smoothstep(range.t, range.t + fuzz, scaledHeight));
#endif

    // Edges taken from RimLightingMaterial.glsl
    float dRim = 1.0 - abs(dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC)));
    float sRim = smoothstep(0.8, 1.0, dRim);
    value *= (1.0 - sRim);

    vec4 halfColor;
    halfColor.rgb = color.rgb * 0.5;
    halfColor.a = color.a * (1.0 - ((1.0 - cellAlpha) * value));
    halfColor = czm_gammaCorrect(halfColor);
    material.diffuse = halfColor.rgb;
    material.emission = halfColor.rgb;
    material.alpha = halfColor.a;

    return material;
}
`});var X6e,K6e=Ee(()=>{X6e=`uniform sampler2D image;
uniform float strength;
uniform vec2 repeat;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);
    
    vec4 textureValue = texture2D(image, fract(repeat * materialInput.st));
    vec3 normalTangentSpace = textureValue.channels;
    normalTangentSpace.xy = normalTangentSpace.xy * 2.0 - 1.0;
    normalTangentSpace.z = clamp(1.0 - strength, 0.1, 1.0);
    normalTangentSpace = normalize(normalTangentSpace);
    vec3 normalEC = materialInput.tangentToEyeMatrix * normalTangentSpace;
    
    material.normal = normalEC;
    
    return material;
}
`});var Z6e,J6e=Ee(()=>{Z6e=`#ifdef GL_OES_standard_derivatives
#extension GL_OES_standard_derivatives : enable
#endif

uniform vec4 color;

float getPointOnLine(vec2 p0, vec2 p1, float x)
{
    float slope = (p0.y - p1.y) / (p0.x - p1.x);
    return slope * (x - p0.x) + p0.y;
}

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;

#if defined(GL_OES_standard_derivatives) || defined(WEBGL2)
    float base = 1.0 - abs(fwidth(st.s)) * 10.0 * czm_pixelRatio;
#else
    float base = 0.975; // 2.5% of the line will be the arrow head
#endif

    vec2 center = vec2(1.0, 0.5);
    float ptOnUpperLine = getPointOnLine(vec2(base, 1.0), center, st.s);
    float ptOnLowerLine = getPointOnLine(vec2(base, 0.0), center, st.s);

    float halfWidth = 0.15;
    float s = step(0.5 - halfWidth, st.t);
    s *= 1.0 - step(0.5 + halfWidth, st.t);
    s *= 1.0 - step(base, st.s);

    float t = step(base, materialInput.st.s);
    t *= 1.0 - step(ptOnUpperLine, st.t);
    t *= step(ptOnLowerLine, st.t);

    // Find the distance from the closest separator (region between two colors)
    float dist;
    if (st.s < base)
    {
        float d1 = abs(st.t - (0.5 - halfWidth));
        float d2 = abs(st.t - (0.5 + halfWidth));
        dist = min(d1, d2);
    }
    else
    {
        float d1 = czm_infinity;
        if (st.t < 0.5 - halfWidth && st.t > 0.5 + halfWidth)
        {
            d1 = abs(st.s - base);
        }
        float d2 = abs(st.t - ptOnUpperLine);
        float d3 = abs(st.t - ptOnLowerLine);
        dist = min(min(d1, d2), d3);
    }

    vec4 outsideColor = vec4(0.0);
    vec4 currentColor = mix(outsideColor, color, clamp(s + t, 0.0, 1.0));
    vec4 outColor = czm_antialias(outsideColor, color, currentColor, dist);

    outColor = czm_gammaCorrect(outColor);
    material.diffuse = outColor.rgb;
    material.alpha = outColor.a;
    return material;
}
`});var $6e,e5e=Ee(()=>{$6e=`uniform vec4 color;
uniform vec4 gapColor;
uniform float dashLength;
uniform float dashPattern;
varying float v_polylineAngle;

const float maskLength = 16.0;

mat2 rotate(float rad) {
    float c = cos(rad);
    float s = sin(rad);
    return mat2(
        c, s,
        -s, c
    );
}

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 pos = rotate(v_polylineAngle) * gl_FragCoord.xy;

    // Get the relative position within the dash from 0 to 1
    float dashPosition = fract(pos.x / (dashLength * czm_pixelRatio));
    // Figure out the mask index.
    float maskIndex = floor(dashPosition * maskLength);
    // Test the bit mask.
    float maskTest = floor(dashPattern / pow(2.0, maskIndex));
    vec4 fragColor = (mod(maskTest, 2.0) < 1.0) ? gapColor : color;
    if (fragColor.a < 0.005) {   // matches 0/255 and 1/255
        discard;
    }

    fragColor = czm_gammaCorrect(fragColor);
    material.emission = fragColor.rgb;
    material.alpha = fragColor.a;
    return material;
}
`});var t5e,r5e=Ee(()=>{t5e=`uniform vec4 color;
uniform float glowPower;
uniform float taperPower;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;
    float glow = glowPower / abs(st.t - 0.5) - (glowPower / 0.5);

    if (taperPower <= 0.99999) {
        glow *= min(1.0, taperPower / (0.5 - st.s * 0.5) - (taperPower / 0.5));
    }

    glow = clamp(0.0, 2.0, glow);

    vec4 fragColor;
    fragColor.rgb = max(vec3(glow - 1.0 + color.rgb), color.rgb);
    fragColor.a = clamp(0.0, 1.0, glow) * color.a;
    fragColor = czm_gammaCorrect(fragColor);

    material.emission = fragColor.rgb;
    material.alpha = fragColor.a;

    return material;
}
`});var yme,i5e=Ee(()=>{yme=`uniform vec4 color;
uniform vec4 outlineColor;
uniform float outlineWidth;

varying float v_width;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    vec2 st = materialInput.st;
    float halfInteriorWidth =  0.5 * (v_width - outlineWidth) / v_width;
    float b = step(0.5 - halfInteriorWidth, st.t);
    b *= 1.0 - step(0.5 + halfInteriorWidth, st.t);

    // Find the distance from the closest separator (region between two colors)
    float d1 = abs(st.t - (0.5 - halfInteriorWidth));
    float d2 = abs(st.t - (0.5 + halfInteriorWidth));
    float dist = min(d1, d2);

    vec4 currentColor = mix(outlineColor, color, b);
    vec4 outColor = czm_antialias(outlineColor, color, currentColor, dist);
    outColor = czm_gammaCorrect(outColor);

    material.diffuse = outColor.rgb;
    material.alpha = outColor.a;

    return material;
}
`});var n5e,o5e=Ee(()=>{n5e=`uniform vec4 color;
uniform vec4 rimColor;
uniform float width;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    float d = 1.0 - dot(materialInput.normalEC, normalize(materialInput.positionToEyeEC));
    float s = smoothstep(1.0 - width, 1.0, d);

    vec4 outColor = czm_gammaCorrect(color);
    vec4 outRimColor = czm_gammaCorrect(rimColor);

    material.diffuse = outColor.rgb;
    material.emission = outRimColor.rgb * s;
    material.alpha = mix(outColor.a, outRimColor.a, s);

    return material;
}
`});var a5e,s5e=Ee(()=>{a5e=`uniform sampler2D image;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);
    vec4 rampColor = texture2D(image, vec2(materialInput.slope / (czm_pi / 2.0), 0.5));
    rampColor = czm_gammaCorrect(rampColor);
    material.diffuse = rampColor.rgb;
    material.alpha = rampColor.a;
    return material;
}
`});var l5e,u5e=Ee(()=>{l5e=`uniform vec4 evenColor;
uniform vec4 oddColor;
uniform float offset;
uniform float repeat;
uniform bool horizontal;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    // Based on the Stripes Fragment Shader in the Orange Book (11.1.2)
    float coord = mix(materialInput.st.s, materialInput.st.t, float(horizontal));
    float value = fract((coord - offset) * (repeat * 0.5));
    float dist = min(value, min(abs(value - 0.5), 1.0 - value));

    vec4 currentColor = mix(evenColor, oddColor, step(0.5, value));
    vec4 color = czm_antialias(evenColor, oddColor, currentColor, dist);
    color = czm_gammaCorrect(color);

    material.diffuse = color.rgb;
    material.alpha = color.a;

    return material;
}
`});var c5e,f5e=Ee(()=>{c5e=`// Thanks for the contribution Jonas

uniform sampler2D specularMap;
uniform sampler2D normalMap;
uniform vec4 baseWaterColor;
uniform vec4 blendColor;
uniform float frequency;
uniform float animationSpeed;
uniform float amplitude;
uniform float specularIntensity;
uniform float fadeFactor;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);

    float time = czm_frameNumber * animationSpeed;

    // fade is a function of the distance from the fragment and the frequency of the waves
    float fade = max(1.0, (length(materialInput.positionToEyeEC) / 10000000000.0) * frequency * fadeFactor);

    float specularMapValue = texture2D(specularMap, materialInput.st).r;

    // note: not using directional motion at this time, just set the angle to 0.0;
    vec4 noise = czm_getWaterNoise(normalMap, materialInput.st * frequency, time, 0.0);
    vec3 normalTangentSpace = noise.xyz * vec3(1.0, 1.0, (1.0 / amplitude));

    // fade out the normal perturbation as we move further from the water surface
    normalTangentSpace.xy /= fade;

    // attempt to fade out the normal perturbation as we approach non water areas (low specular map value)
    normalTangentSpace = mix(vec3(0.0, 0.0, 50.0), normalTangentSpace, specularMapValue);

    normalTangentSpace = normalize(normalTangentSpace);

    // get ratios for alignment of the new normal vector with a vector perpendicular to the tangent plane
    float tsPerturbationRatio = clamp(dot(normalTangentSpace, vec3(0.0, 0.0, 1.0)), 0.0, 1.0);

    // fade out water effect as specular map value decreases
    material.alpha = mix(blendColor.a, baseWaterColor.a, specularMapValue) * specularMapValue;

    // base color is a blend of the water and non-water color based on the value from the specular map
    // may need a uniform blend factor to better control this
    material.diffuse = mix(blendColor.rgb, baseWaterColor.rgb, specularMapValue);

    // diffuse highlights are based on how perturbed the normal is
    material.diffuse += (0.1 * tsPerturbationRatio);

    material.diffuse = material.diffuse;

    material.normal = normalize(materialInput.tangentToEyeMatrix * normalTangentSpace);

    material.specular = specularIntensity;
    material.shininess = 10.0;

    return material;
}
`});var x5e,h5e=Ee(()=>{x5e=`uniform vec4 color;

czm_material czm_getMaterial(czm_materialInput materialInput)
{
    czm_material material = czm_getDefaultMaterial(materialInput);
    material.diffuse = color.rgb;
    material.alpha = 1.0;
    return material;
}`});function Qr(e){this.type=void 0,this.shaderSource=void 0,this.materials=void 0,this.uniforms=void 0,this._uniforms=void 0,this.translucent=void 0,this._minificationFilter=B(e.minificationFilter,Dr.LINEAR),this._magnificationFilter=B(e.magnificationFilter,xi.LINEAR),this._strict=void 0,this._template=void 0,this._count=void 0,this._texturePaths={},this._loadedImages=[],this._loadedCubeMaps=[],this._textures={},this._updateFunctions=[],this._defaultTexture=void 0,this._wrapS=Jt.CLAMP_TO_EDGE,this._wrapT=Jt.CLAMP_TO_EDGE,xOt(e,this),Object.defineProperties(this,{type:{value:this.type,writable:!1}}),p(Qr._uniformList[this.type])||(Qr._uniformList[this.type]=Object.keys(this._uniforms))}function xOt(e,r){e=B(e,B.EMPTY_OBJECT),r._strict=B(e.strict,!1),r._count=B(e.count,0),r._template=Tn(B(e.fabric,B.EMPTY_OBJECT)),r._template.uniforms=Tn(B(r._template.uniforms,B.EMPTY_OBJECT)),r._template.materials=Tn(B(r._template.materials,B.EMPTY_OBJECT)),r.type=p(r._template.type)?r._template.type:$n(),r.shaderSource="",r.materials={},r.uniforms={},r._uniforms={},r._translucentFunctions=[];var n,o=Qr._materialCache.getMaterial(r.type);if(p(o)){var a=Tn(o.fabric,!0);r._template=ei(r._template,a,!0),n=o.translucent}pOt(r),p(o)||Qr._materialCache.addMaterial(r.type,r),gOt(r),TOt(r),EOt(r);var s=r._translucentFunctions.length===0?!0:void 0;if(n=B(n,s),n=B(e.translucent,n),p(n))if(typeof n=="function"){var l=y(function(){return n(r)},"wrappedTranslucent");r._translucentFunctions.push(l)}else r._translucentFunctions.push(n)}function Ame(e,r,n,o){if(p(e)){for(var a in e)if(e.hasOwnProperty(a)){var s=r.indexOf(a)!==-1;(o&&!s||!o&&s)&&n(a,r)}}}function d5e(e,r){for(var n="fabric: property name '"+e+"' is not valid. It should be ",o=0;o<r.length;o++){var a="'"+r[o]+"'";n+=o===r.length-1?"or "+a+".":a+", "}throw new G(n)}function hOt(e,r){var n="fabric: uniforms and materials cannot share the same property '"+e+"'";throw new G(n)}function pOt(e){var r=e._template,n=r.uniforms,o=r.materials,a=r.components;if(p(a)&&p(r.source))throw new G("fabric: cannot have source and components in the same template.");Ame(r,dOt,d5e,!0),Ame(a,mOt,d5e,!0);var s=[];for(var l in o)o.hasOwnProperty(l)&&s.push(l);Ame(n,s,hOt,!1)}function vOt(e,r){var n=r._template.materials;for(var o in n)if(n.hasOwnProperty(o)&&e.indexOf(o)>-1)return!0;return!1}function gOt(e){var r=e._template.components,n=e._template.source;if(p(n))e.shaderSource+=n+`
`;else{if(e.shaderSource+=`czm_material czm_getMaterial(czm_materialInput materialInput)
{
`,e.shaderSource+=`czm_material material = czm_getDefaultMaterial(materialInput);
`,p(r)){var o=Object.keys(e._template.materials).length>0;for(var a in r)if(r.hasOwnProperty(a))if(a==="diffuse"||a==="emission"){var s=o&&vOt(r[a],e),l=s?r[a]:"czm_gammaCorrect("+r[a]+")";e.shaderSource+="material."+a+" = "+l+`; 
`}else a==="alpha"?e.shaderSource+="material.alpha = "+r.alpha+`; 
`:e.shaderSource+="material."+a+" = "+r[a]+`;
`}e.shaderSource+=`return material;
}
`}}function AOt(e){var r;return function(n,o){var a=n.uniforms,s=a[e],l=r!==s;r=s;var h=n._textures[e],x,m;if(s instanceof HTMLVideoElement){if(s.readyState>=2){if(l&&p(h)&&(h!==o.defaultTexture&&h.destroy(),h=void 0),!p(h)||h===o.defaultTexture){var v=new Yr({minificationFilter:n._minificationFilter,magnificationFilter:n._magnificationFilter});h=new Vt({context:o,source:s,sampler:v}),n._textures[e]=h;return}h.copyFrom(s)}else p(h)||(n._textures[e]=o.defaultTexture);return}if(s instanceof Vt&&s!==h){n._texturePaths[e]=void 0;var _=n._textures[e];_!==n._defaultTexture&&_.destroy(),n._textures[e]=s,x=e+"Dimensions",a.hasOwnProperty(x)&&(m=a[x],m.x=s._width,m.y=s._height);return}if(p(h)||(n._texturePaths[e]=void 0,p(n._defaultTexture)||(n._defaultTexture=o.defaultTexture),h=n._textures[e]=n._defaultTexture,x=e+"Dimensions",a.hasOwnProperty(x)&&(m=a[x],m.x=h._width,m.y=h._height)),s!==Qr.DefaultImageId){var A=s instanceof ir;if(!p(n._texturePaths[e])||A&&s.url!==n._texturePaths[e].url||!A&&s!==n._texturePaths[e]){if(typeof s=="string"||A){var T=A?s:ir.createIfNeeded(s),w;_Ot.test(T.url)?w=zp(T):yOt.test(T.url)?w=Id(T):w=T.fetchImage(),Je(w,function(S){n._loadedImages.push({id:e,image:S})})}else(s instanceof HTMLCanvasElement||s instanceof HTMLImageElement)&&n._loadedImages.push({id:e,image:s});n._texturePaths[e]=s}}}}function COt(e){return function(r,n){var o=r.uniforms[e];if(o instanceof Fh){var a=r._textures[e];a!==r._defaultTexture&&a.destroy(),r._texturePaths[e]=void 0,r._textures[e]=o;return}if(p(r._textures[e])||(r._texturePaths[e]=void 0,r._textures[e]=n.defaultCubeMap),o!==Qr.DefaultCubeMapId){var s=o.positiveX+o.negativeX+o.positiveY+o.negativeY+o.positiveZ+o.negativeZ;if(s!==r._texturePaths[e]){var l=[ir.createIfNeeded(o.positiveX).fetchImage(),ir.createIfNeeded(o.negativeX).fetchImage(),ir.createIfNeeded(o.positiveY).fetchImage(),ir.createIfNeeded(o.negativeY).fetchImage(),ir.createIfNeeded(o.positiveZ).fetchImage(),ir.createIfNeeded(o.negativeZ).fetchImage()];Je.all(l).then(function(h){r._loadedCubeMaps.push({id:e,images:h})}),r._texturePaths[e]=s}}}}function TOt(e){var r=e._template.uniforms;for(var n in r)r.hasOwnProperty(n)&&p5e(e,n)}function p5e(e,r){var n=e._strict,o=e._template.uniforms,a=o[r],s=wOt(a);if(!p(s))throw new G("fabric: uniform '"+r+"' has invalid type.");var l;if(s==="channels"){if(l=qH(e,r,a,!1),l===0&&n)throw new G("strict: shader source does not use channels '"+r+"'.")}else{if(s==="sampler2D"){var h=r+"Dimensions";bOt(e,h)>0&&(o[h]={type:"ivec3",x:1,y:1},p5e(e,h))}var x=new RegExp("uniform\\s+"+s+"\\s+"+r+"\\s*;");if(!x.test(e.shaderSource)){var m="uniform "+s+" "+r+";";e.shaderSource=m+e.shaderSource}var v=r+"_"+e._count++;if(l=qH(e,r,v),l===1&&n)throw new G("strict: shader source does not use uniform '"+r+"'.");if(e.uniforms[r]=a,s==="sampler2D")e._uniforms[v]=function(){return e._textures[r]},e._updateFunctions.push(AOt(r));else if(s==="samplerCube")e._uniforms[v]=function(){return e._textures[r]},e._updateFunctions.push(COt(r));else if(s.indexOf("mat")!==-1){var _=new m5e[s];e._uniforms[v]=function(){return m5e[s].fromColumnMajorArray(e.uniforms[r],_)}}else e._uniforms[v]=function(){return e.uniforms[r]}}}function wOt(e){var r=e.type;if(!p(r)){var n=typeof e;if(n==="number")r="float";else if(n==="boolean")r="bool";else if(n==="string"||e instanceof Vt||e instanceof ir||e instanceof HTMLCanvasElement||e instanceof HTMLImageElement)/^([rgba]){1,4}$/i.test(e)?r="channels":e===Qr.DefaultCubeMapId?r="samplerCube":r="sampler2D";else if(n==="object")if(Array.isArray(e))(e.length===4||e.length===9||e.length===16)&&(r="mat"+Math.sqrt(e.length));else{var o=0;for(var a in e)e.hasOwnProperty(a)&&(o+=1);o>=2&&o<=4?r="vec"+o:o===6&&(r="samplerCube")}}return r}function EOt(e){var r=e._strict,n=e._template.materials;for(var o in n)if(n.hasOwnProperty(o)){var a=new Qr({strict:r,fabric:n[o],count:e._count});e._count=a._count,e._uniforms=ei(e._uniforms,a._uniforms,!0),e.materials[o]=a,e._translucentFunctions=e._translucentFunctions.concat(a._translucentFunctions);var s="czm_getMaterial",l=s+"_"+e._count++;qH(a,s,l),e.shaderSource=a.shaderSource+e.shaderSource;var h=l+"(materialInput)",x=qH(e,o,h);if(x===0&&r)throw new G("strict: shader source does not use material '"+o+"'.")}}function qH(e,r,n,o){o=B(o,!0);var a=0,s="([\\w])?",l="([\\w"+(o?".":"")+"])?",h=new RegExp(l+r+s,"g");return e.shaderSource=e.shaderSource.replace(h,function(x,m,v){return m||v?x:(a+=1,n)}),a}function bOt(e,r,n){return qH(e,r,r,n)}var dOt,mOt,m5e,_Ot,yOt,on,nh=Ee(()=>{Fr();c0();Ar();Ua();Dl();Ze();De();ur();st();m1();qS();CC();to();Rr();hn();l1();yn();L6e();F6e();z6e();k6e();G6e();W6e();j6e();Q6e();K6e();J6e();e5e();r5e();i5e();o5e();ra();s5e();u5e();Ia();pa();f5e();h5e();li();ya();y(Qr,"Material");Qr._uniformList={};Qr.fromType=function(e,r){if(!p(Qr._materialCache.getMaterial(e)))throw new G("material with type '"+e+"' does not exist.");var n=new Qr({fabric:{type:e}});if(p(r))for(var o in r)r.hasOwnProperty(o)&&(n.uniforms[o]=r[o]);return n};Qr.prototype.isTranslucent=function(){if(p(this.translucent))return typeof this.translucent=="function"?this.translucent():this.translucent;for(var e=!0,r=this._translucentFunctions,n=r.length,o=0;o<n;++o){var a=r[o];if(typeof a=="function"?e=e&&a():e=e&&a,!e)break}return e};Qr.prototype.update=function(e){var r,n,o=this._loadedImages,a=o.length;for(r=0;r<a;++r){var s=o[r];n=s.id;var l=s.image,h=new Yr({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter,wrapS:this._wrapS,wrapT:this._wrapT}),x;p(l.internalFormat)?x=new Vt({context:e,pixelFormat:l.internalFormat,width:l.width,height:l.height,source:{arrayBufferView:l.bufferView},sampler:h}):x=new Vt({context:e,source:l,sampler:h}),this._textures[n]=x;var m=n+"Dimensions";if(this.uniforms.hasOwnProperty(m)){var v=this.uniforms[m];v.x=x._width,v.y=x._height}}o.length=0;var _=this._loadedCubeMaps;for(a=_.length,r=0;r<a;++r){var A=_[r];n=A.id;var T=A.images,w=new Fh({context:e,source:{positiveX:T[0],negativeX:T[1],positiveY:T[2],negativeY:T[3],positiveZ:T[4],negativeZ:T[5]},sampler:new Yr({minificationFilter:this._minificationFilter,magnificationFilter:this._magnificationFilter})});this._textures[n]=w}_.length=0;var S=this._updateFunctions;for(a=S.length,r=0;r<a;++r)S[r](this,e);var P=this.materials;for(var M in P)P.hasOwnProperty(M)&&P[M].update(e)};Qr.prototype.isDestroyed=function(){return!1};Qr.prototype.destroy=function(){var e=this._textures;for(var r in e)if(e.hasOwnProperty(r)){var n=e[r];n!==this._defaultTexture&&n.destroy()}var o=this.materials;for(var a in o)o.hasOwnProperty(a)&&o[a].destroy();return $e(this)};y(xOt,"initializeMaterial");y(Ame,"checkForValidProperties");y(d5e,"invalidNameError");y(hOt,"duplicateNameError");dOt=["type","materials","uniforms","components","source"],mOt=["diffuse","specular","shininess","normal","emission","alpha"];y(pOt,"checkForTemplateErrors");y(vOt,"isMaterialFused");y(gOt,"createMethodDefinition");m5e={mat2:nu,mat3:We,mat4:Z},_Ot=/\.ktx$/i,yOt=/\.crn$/i;y(AOt,"createTexture2DUpdateFunction");y(COt,"createCubeMapUpdateFunction");y(TOt,"createUniforms");y(p5e,"createUniform");y(wOt,"getUniformType");y(EOt,"createSubMaterials");y(qH,"replaceToken");y(bOt,"getNumberOfTokens");Qr._materialCache={_materials:{},addMaterial:function(e,r){this._materials[e]=r},getMaterial:function(e){return this._materials[e]}};Qr.DefaultImageId="czm_defaultImage";Qr.DefaultCubeMapId="czm_defaultCubeMap";Qr.ColorType="Color";Qr._materialCache.addMaterial(Qr.ColorType,{fabric:{type:Qr.ColorType,uniforms:{color:new se(1,0,0,.5)},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}});Qr.ImageType="Image";Qr._materialCache.addMaterial(Qr.ImageType,{fabric:{type:Qr.ImageType,uniforms:{image:Qr.DefaultImageId,repeat:new de(1,1),color:new se(1,1,1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).rgb * color.rgb",alpha:"texture2D(image, fract(repeat * materialInput.st)).a * color.a"}},translucent:function(e){return e.uniforms.color.alpha<1}});Qr.DiffuseMapType="DiffuseMap";Qr._materialCache.addMaterial(Qr.DiffuseMapType,{fabric:{type:Qr.DiffuseMapType,uniforms:{image:Qr.DefaultImageId,channels:"rgb",repeat:new de(1,1)},components:{diffuse:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1});Qr.AlphaMapType="AlphaMap";Qr._materialCache.addMaterial(Qr.AlphaMapType,{fabric:{type:Qr.AlphaMapType,uniforms:{image:Qr.DefaultImageId,channel:"a",repeat:new de(1,1)},components:{alpha:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!0});Qr.SpecularMapType="SpecularMap";Qr._materialCache.addMaterial(Qr.SpecularMapType,{fabric:{type:Qr.SpecularMapType,uniforms:{image:Qr.DefaultImageId,channel:"r",repeat:new de(1,1)},components:{specular:"texture2D(image, fract(repeat * materialInput.st)).channel"}},translucent:!1});Qr.EmissionMapType="EmissionMap";Qr._materialCache.addMaterial(Qr.EmissionMapType,{fabric:{type:Qr.EmissionMapType,uniforms:{image:Qr.DefaultImageId,channels:"rgb",repeat:new de(1,1)},components:{emission:"texture2D(image, fract(repeat * materialInput.st)).channels"}},translucent:!1});Qr.BumpMapType="BumpMap";Qr._materialCache.addMaterial(Qr.BumpMapType,{fabric:{type:Qr.BumpMapType,uniforms:{image:Qr.DefaultImageId,channel:"r",strength:.8,repeat:new de(1,1)},source:O6e},translucent:!1});Qr.NormalMapType="NormalMap";Qr._materialCache.addMaterial(Qr.NormalMapType,{fabric:{type:Qr.NormalMapType,uniforms:{image:Qr.DefaultImageId,channels:"rgb",strength:.8,repeat:new de(1,1)},source:X6e},translucent:!1});Qr.GridType="Grid";Qr._materialCache.addMaterial(Qr.GridType,{fabric:{type:Qr.GridType,uniforms:{color:new se(0,1,0,1),cellAlpha:.1,lineCount:new de(8,8),lineThickness:new de(1,1),lineOffset:new de(0,0)},source:Y6e},translucent:function(e){var r=e.uniforms;return r.color.alpha<1||r.cellAlpha<1}});Qr.StripeType="Stripe";Qr._materialCache.addMaterial(Qr.StripeType,{fabric:{type:Qr.StripeType,uniforms:{horizontal:!0,evenColor:new se(1,1,1,.5),oddColor:new se(0,0,1,.5),offset:0,repeat:5},source:l5e},translucent:function(e){var r=e.uniforms;return r.evenColor.alpha<1||r.oddColor.alpha<1}});Qr.CheckerboardType="Checkerboard";Qr._materialCache.addMaterial(Qr.CheckerboardType,{fabric:{type:Qr.CheckerboardType,uniforms:{lightColor:new se(1,1,1,.5),darkColor:new se(0,0,0,.5),repeat:new de(5,5)},source:N6e},translucent:function(e){var r=e.uniforms;return r.lightColor.alpha<1||r.darkColor.alpha<1}});Qr.DotType="Dot";Qr._materialCache.addMaterial(Qr.DotType,{fabric:{type:Qr.DotType,uniforms:{lightColor:new se(1,1,0,.75),darkColor:new se(0,1,1,.75),repeat:new de(5,5)},source:V6e},translucent:function(e){var r=e.uniforms;return r.lightColor.alpha<1||r.darkColor.alpha<1}});Qr.WaterType="Water";Qr._materialCache.addMaterial(Qr.WaterType,{fabric:{type:Qr.WaterType,uniforms:{baseWaterColor:new se(.2,.3,.6,1),blendColor:new se(0,1,.699,1),specularMap:Qr.DefaultImageId,normalMap:Qr.DefaultImageId,frequency:10,animationSpeed:.01,amplitude:1,specularIntensity:.5,fadeFactor:1},source:c5e},translucent:function(e){var r=e.uniforms;return r.baseWaterColor.alpha<1||r.blendColor.alpha<1}});Qr.RimLightingType="RimLighting";Qr._materialCache.addMaterial(Qr.RimLightingType,{fabric:{type:Qr.RimLightingType,uniforms:{color:new se(1,0,0,.7),rimColor:new se(1,1,1,.4),width:.3},source:n5e},translucent:function(e){var r=e.uniforms;return r.color.alpha<1||r.rimColor.alpha<1}});Qr.FadeType="Fade";Qr._materialCache.addMaterial(Qr.FadeType,{fabric:{type:Qr.FadeType,uniforms:{fadeInColor:new se(1,0,0,1),fadeOutColor:new se(0,0,0,0),maximumDistance:.5,repeat:!0,fadeDirection:{x:!0,y:!0},time:new de(.5,.5)},source:q6e},translucent:function(e){var r=e.uniforms;return r.fadeInColor.alpha<1||r.fadeOutColor.alpha<1}});Qr.PolylineArrowType="PolylineArrow";Qr._materialCache.addMaterial(Qr.PolylineArrowType,{fabric:{type:Qr.PolylineArrowType,uniforms:{color:new se(1,1,1,1)},source:Z6e},translucent:!0});Qr.PolylineDashType="PolylineDash";Qr._materialCache.addMaterial(Qr.PolylineDashType,{fabric:{type:Qr.PolylineDashType,uniforms:{color:new se(1,0,1,1),gapColor:new se(0,0,0,0),dashLength:16,dashPattern:255},source:$6e},translucent:!0});Qr.PolylineGlowType="PolylineGlow";Qr._materialCache.addMaterial(Qr.PolylineGlowType,{fabric:{type:Qr.PolylineGlowType,uniforms:{color:new se(0,.5,1,1),glowPower:.25,taperPower:1},source:t5e},translucent:!0});Qr.PolylineOutlineType="PolylineOutline";Qr._materialCache.addMaterial(Qr.PolylineOutlineType,{fabric:{type:Qr.PolylineOutlineType,uniforms:{color:new se(1,1,1,1),outlineColor:new se(1,0,0,1),outlineWidth:1},source:yme},translucent:function(e){var r=e.uniforms;return r.color.alpha<1||r.outlineColor.alpha<1}});Qr.ElevationContourType="ElevationContour";Qr._materialCache.addMaterial(Qr.ElevationContourType,{fabric:{type:Qr.ElevationContourType,uniforms:{spacing:100,color:new se(1,0,0,1),width:1},source:U6e},translucent:!1});Qr.ElevationRampType="ElevationRamp";Qr._materialCache.addMaterial(Qr.ElevationRampType,{fabric:{type:Qr.ElevationRampType,uniforms:{image:Qr.DefaultImageId,minimumHeight:0,maximumHeight:1e4},source:H6e},translucent:!1});Qr.SlopeRampMaterialType="SlopeRamp";Qr._materialCache.addMaterial(Qr.SlopeRampMaterialType,{fabric:{type:Qr.SlopeRampMaterialType,uniforms:{image:Qr.DefaultImageId},source:a5e},translucent:!1});Qr.AspectRampMaterialType="AspectRamp";Qr._materialCache.addMaterial(Qr.AspectRampMaterialType,{fabric:{type:Qr.AspectRampMaterialType,uniforms:{image:Qr.DefaultImageId},source:R6e},translucent:!1});Qr.EmissionColorType="EmissionColor";Qr._materialCache.addMaterial(Qr.EmissionColorType,{fabric:{type:Qr.EmissionColorType,uniforms:{color:new se(1,1,1,1)},source:x5e},translucent:function(e){return e.uniforms.color.alpha<1}});Qr.PolylineDynamicType="PolylineDynamic";Qr._materialCache.addMaterial(Qr.PolylineDynamicType,{fabric:{type:Qr.PolylineDynamicType,uniforms:{color:new se(1,1,1,1),outlineColor:new se(1,0,0,1),outlineWidth:0,v_time:1,bAsy:1},source:yme},translucent:function(e){return!0}});Qr.PolylineTrailType="PolylineTrail";Qr._materialCache.addMaterial(Qr.PolylineTrailType,{fabric:{type:Qr.PolylineTrailType,uniforms:{color:new se(1,0,0,.5),trailTime:0,spotSize:1,trailLength:.03,spotIntensity:5,constantSpeed:0,period:1e3,startTime:0},components:{diffuse:"color.rgb",alpha:"color.a"}},translucent:function(e){return!0}});on=Qr});function IOt(e,r,n,o){if(X.defined("equalsEpsilon",r),!!p(e)){o=B(o,SOt),n=B(n,!1);var a=e.length;if(a<2)return e;var s,l,h;for(s=1;s<a&&(l=e[s-1],h=e[s],!r(l,h,o));++s);if(s===a)return n&&r(e[0],e[e.length-1],o)?e.slice(1):e;for(var x=e.slice(0,s);s<a;++s)h=e[s],r(l,h,o)||(x.push(h),l=h);return n&&x.length>1&&r(x[0],x[x.length-1],o)&&x.shift(),x}}var SOt,vu,K2=Ee(()=>{cr();Ze();De();nr();SOt=K.EPSILON10;y(IOt,"arrayRemoveDuplicates");vu=IOt});function Tme(e,r,n){if(e===0)return r*n;var o=e*e,a=o*o,s=a*o,l=s*o,h=l*o,x=h*o,m=n,v=Math.sin(2*m),_=Math.sin(4*m),A=Math.sin(6*m),T=Math.sin(8*m),w=Math.sin(10*m),S=Math.sin(12*m);return r*((1-o/4-3*a/64-5*s/256-175*l/16384-441*h/65536-4851*x/1048576)*m-(3*o/8+3*a/32+45*s/1024+105*l/4096+2205*h/131072+6237*x/524288)*v+(15*a/256+45*s/1024+525*l/16384+1575*h/65536+155925*x/8388608)*_-(35*s/3072+175*l/12288+3675*h/262144+13475*x/1048576)*A+(315*l/131072+2205*h/524288+43659*x/8388608)*T-(693*h/1310720+6237*x/5242880)*w+1001*x/8388608*S)}function POt(e,r,n){var o=e/n;if(r===0)return o;var a=o*o,s=a*o,l=s*o,h=r,x=h*h,m=x*x,v=m*x,_=v*x,A=_*x,T=A*x,w=Math.sin(2*o),S=Math.cos(2*o),P=Math.sin(4*o),M=Math.cos(4*o),L=Math.sin(6*o),R=Math.cos(6*o),O=Math.sin(8*o),N=Math.cos(8*o),k=Math.sin(10*o),z=Math.cos(10*o),W=Math.sin(12*o);return o+o*x/4+7*o*m/64+15*o*v/256+579*o*_/16384+1515*o*A/65536+16837*o*T/1048576+(3*o*m/16+45*o*v/256-o*(32*a-561)*_/4096-o*(232*a-1677)*A/16384+o*(399985-90560*a+512*l)*T/5242880)*S+(21*o*v/256+483*o*_/4096-o*(224*a-1969)*A/16384-o*(33152*a-112599)*T/1048576)*M+(151*o*_/4096+4681*o*A/65536+1479*o*T/16384-453*s*T/32768)*R+(1097*o*A/65536+42783*o*T/1048576)*N+8011*o*T/1048576*z+(3*x/8+3*m/16+213*v/2048-3*a*v/64+255*_/4096-33*a*_/512+20861*A/524288-33*a*A/512+l*A/1024+28273*T/1048576-471*a*T/8192+9*l*T/4096)*w+(21*m/256+21*v/256+533*_/8192-21*a*_/512+197*A/4096-315*a*A/4096+584039*T/16777216-12517*a*T/131072+7*l*T/2048)*P+(151*v/6144+151*_/4096+5019*A/131072-453*a*A/16384+26965*T/786432-8607*a*T/131072)*L+(1097*_/131072+1097*A/65536+225797*T/10485760-1097*a*T/65536)*O+(8011*A/2621440+8011*T/1048576)*k+293393*T/251658240*W}function nN(e,r){if(e===0)return Math.log(Math.tan(.5*(K.PI_OVER_TWO+r)));var n=e*Math.sin(r);return Math.log(Math.tan(.5*(K.PI_OVER_TWO+r)))-e/2*Math.log((1+n)/(1-n))}function DOt(e,r,n,o,a){var s=nN(e._ellipticity,n),l=nN(e._ellipticity,a);return Math.atan2(K.negativePiToPi(o-r),l-s)}function MOt(e,r,n,o,a,s,l){var h=e._heading,x=s-o,m=0;if(K.equalsEpsilon(Math.abs(h),K.PI_OVER_TWO,K.EPSILON8))if(r===n)m=r*Math.cos(a)*K.negativePiToPi(x);else{var v=Math.sin(a);m=r*Math.cos(a)*K.negativePiToPi(x)/Math.sqrt(1-e._ellipticitySquared*v*v)}else{var _=Tme(e._ellipticity,r,a),A=Tme(e._ellipticity,r,l);m=(A-_)/Math.cos(h)}return Math.abs(m)}function v5e(e,r,n,o){var a=E.normalize(o.cartographicToCartesian(r,Cme),BOt),s=E.normalize(o.cartographicToCartesian(n,Cme),Cme);X.typeOf.number.greaterThanOrEquals("value",Math.abs(Math.abs(E.angleBetween(a,s))-Math.PI),.0125);var l=o.maximumRadius,h=o.minimumRadius,x=l*l,m=h*h;e._ellipticitySquared=(x-m)/x,e._ellipticity=Math.sqrt(e._ellipticitySquared),e._start=qe.clone(r,e._start),e._start.height=0,e._end=qe.clone(n,e._end),e._end.height=0,e._heading=DOt(e,r.longitude,r.latitude,n.longitude,n.latitude),e._distance=MOt(e,o.maximumRadius,o.minimumRadius,r.longitude,r.latitude,n.longitude,n.latitude)}function g5e(e,r,n,o,a,s){var l=a*a,h,x,m;if(Math.abs(K.PI_OVER_TWO-Math.abs(r))>K.EPSILON8){var v=Tme(a,o,e.latitude),_=n*Math.cos(r),A=v+_;x=POt(A,a,o);var T=nN(a,e.latitude),w=nN(a,x);m=Math.tan(r)*(w-T),h=K.negativePiToPi(e.longitude+m)}else{x=e.latitude;var S;if(a===0)S=o*Math.cos(e.latitude);else{var P=Math.sin(e.latitude);S=o*Math.cos(e.latitude)/Math.sqrt(1-l*P*P)}m=n/S,r>0?h=K.negativePiToPi(e.longitude+m):h=K.negativePiToPi(e.longitude-m)}return p(s)?(s.longitude=h,s.latitude=x,s.height=0,s):new qe(h,x,0)}function p1(e,r,n){var o=B(n,nt.WGS84);this._ellipsoid=o,this._start=new qe,this._end=new qe,this._heading=void 0,this._distance=void 0,this._ellipticity=void 0,this._ellipticitySquared=void 0,p(e)&&p(r)&&v5e(this,e,r,o)}var BOt,Cme,Em,oN=Ee(()=>{bt();Si();cr();Ze();De();st();Ii();nr();y(Tme,"calculateM");y(POt,"calculateInverseM");y(nN,"calculateSigma");y(DOt,"calculateHeading");y(MOt,"calculateArcLength");BOt=new E,Cme=new E;y(v5e,"computeProperties");y(g5e,"interpolateUsingSurfaceDistance");y(p1,"EllipsoidRhumbLine");Object.defineProperties(p1.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},surfaceDistance:{get:function(){return X.defined("distance",this._distance),this._distance}},start:{get:function(){return this._start}},end:{get:function(){return this._end}},heading:{get:function(){return X.defined("distance",this._distance),this._heading}}});p1.fromStartHeadingDistance=function(e,r,n,o,a){X.defined("start",e),X.defined("heading",r),X.defined("distance",n),X.typeOf.number.greaterThan("distance",n,0);var s=B(o,nt.WGS84),l=s.maximumRadius,h=s.minimumRadius,x=l*l,m=h*h,v=Math.sqrt((x-m)/x);r=K.negativePiToPi(r);var _=g5e(e,r,n,s.maximumRadius,v);return!p(a)||p(o)&&!o.equals(a.ellipsoid)?new p1(e,_,s):(a.setEndPoints(e,_),a)};p1.prototype.setEndPoints=function(e,r){X.defined("start",e),X.defined("end",r),v5e(this,e,r,this._ellipsoid)};p1.prototype.interpolateUsingFraction=function(e,r){return this.interpolateUsingSurfaceDistance(e*this._distance,r)};p1.prototype.interpolateUsingSurfaceDistance=function(e,r){if(X.typeOf.number("distance",e),!p(this._distance)||this._distance===0)throw new G("EllipsoidRhumbLine must have distinct start and end set.");return g5e(this._start,this._heading,e,this._ellipsoid.maximumRadius,this._ellipticity,r)};p1.prototype.findIntersectionWithLongitude=function(e,r){if(X.typeOf.number("intersectionLongitude",e),!p(this._distance)||this._distance===0)throw new G("EllipsoidRhumbLine must have distinct start and end set.");var n=this._ellipticity,o=this._heading,a=Math.abs(o),s=this._start;if(e=K.negativePiToPi(e),K.equalsEpsilon(Math.abs(e),Math.PI,K.EPSILON14)&&(e=K.sign(s.longitude)*Math.PI),p(r)||(r=new qe),Math.abs(K.PI_OVER_TWO-a)<=K.EPSILON8)return r.longitude=e,r.latitude=s.latitude,r.height=0,r;if(K.equalsEpsilon(Math.abs(K.PI_OVER_TWO-a),K.PI_OVER_TWO,K.EPSILON8))return K.equalsEpsilon(e,s.longitude,K.EPSILON12)?void 0:(r.longitude=e,r.latitude=K.PI_OVER_TWO*K.sign(K.PI_OVER_TWO-o),r.height=0,r);var l=s.latitude,h=n*Math.sin(l),x=Math.tan(.5*(K.PI_OVER_TWO+l))*Math.exp((e-s.longitude)/Math.tan(o)),m=(1+h)/(1-h),v=s.latitude,_;do{_=v;var A=n*Math.sin(_),T=(1+A)/(1-A);v=2*Math.atan(x*Math.pow(T/m,n/2))-K.PI_OVER_TWO}while(!K.equalsEpsilon(v,_,K.EPSILON12));return r.longitude=e,r.latitude=v,r.height=0,r};p1.prototype.findIntersectionWithLatitude=function(e,r){if(X.typeOf.number("intersectionLatitude",e),!p(this._distance)||this._distance===0)throw new G("EllipsoidRhumbLine must have distinct start and end set.");var n=this._ellipticity,o=this._heading,a=this._start;if(!K.equalsEpsilon(Math.abs(o),K.PI_OVER_TWO,K.EPSILON8)){var s=nN(n,a.latitude),l=nN(n,e),h=Math.tan(o)*(l-s),x=K.negativePiToPi(a.longitude+h);return p(r)?(r.longitude=x,r.latitude=e,r.height=0,r):new qe(x,e,0)}};Em=p1});function C5e(e,r,n){var o=hX;o.length=e;var a;if(r===n){for(a=0;a<e;a++)o[a]=r;return o}var s=n-r,l=s/e;for(a=0;a<e;a++){var h=r+a*l;o[a]=h}return o}function kOt(e,r){var n=hX;n.length=e;for(var o=0;o<e;o++)n[o]+=r*Math.sin(Math.PI*o/e);return n}function UOt(e,r,n,o,a,s,l,h,x){var m=o.scaleToGeodeticSurface(e,mX),v=o.scaleToGeodeticSurface(r,T5e),_=bm.numberOfPoints(e,r,n),A=o.cartesianToCartographic(m,dX),T=o.cartesianToCartographic(v,xX),w=C5e(_,a,s);x>0&&(w=kOt(_,x)),wme.setEndPoints(A,T);var S=wme.surfaceDistance/_,P=h;A.height=a;var M=o.cartographicToCartesian(A,jS);E.pack(M,l,P),P+=3;for(var L=1;L<_;L++){var R=wme.interpolateUsingSurfaceDistance(L*S,xX);R.height=w[L],M=o.cartographicToCartesian(R,jS),E.pack(M,l,P),P+=3}return P}function GOt(e,r,n,o,a,s,l,h){var x=o.scaleToGeodeticSurface(e,mX),m=o.scaleToGeodeticSurface(r,T5e),v=o.cartesianToCartographic(x,dX),_=o.cartesianToCartographic(m,xX),A=bm.numberOfPointsRhumbLine(v,_,n),T=C5e(A,a,s);jH.ellipsoid.equals(o)||(jH=new Em(void 0,void 0,o)),jH.setEndPoints(v,_);var w=jH.surfaceDistance/A,S=h;v.height=a;var P=o.cartographicToCartesian(v,jS);E.pack(P,l,S),S+=3;for(var M=1;M<A;M++){var L=jH.interpolateUsingSurfaceDistance(M*w,xX);L.height=T[M],P=o.cartographicToCartesian(L,jS),E.pack(P,l,S),S+=3}return S}var bm,ROt,LOt,OOt,_5e,FOt,y5e,NOt,zOt,VOt,hX,dX,xX,jS,mX,T5e,wme,jH,A5e,HOt,ns,v1=Ee(()=>{bt();Si();Ze();De();st();Ii();VF();oN();jf();nr();Rr();K0();bm={};bm.numberOfPoints=function(e,r,n){var o=E.distance(e,r);return Math.ceil(o/n)};bm.numberOfPointsRhumbLine=function(e,r,n){var o=Math.pow(e.longitude-r.longitude,2)+Math.pow(e.latitude-r.latitude,2);return o=Math.max(o,K.EPSILON21),Math.ceil(Math.sqrt(o/(n*n)))};ROt=new qe;bm.extractHeights=function(e,r){for(var n=e.length,o=new Array(n),a=0;a<n;a++){var s=e[a];o[a]=r.cartesianToCartographic(s,ROt).height}return o};LOt=new Z,OOt=new E,_5e=new E,FOt=new pn(E.UNIT_X,0),y5e=new E,NOt=new pn(E.UNIT_X,0),zOt=new E,VOt=new E,hX=[];y(C5e,"subdivideHeights");y(kOt,"subdivideHeightsBySin");dX=new qe,xX=new qe,jS=new E,mX=new E,T5e=new E,wme=new Ey,jH=new Em;y(UOt,"generateCartesianArc");y(GOt,"generateCartesianRhumbArc");bm.wrapLongitude=function(e,r){var n=[],o=[];if(p(e)&&e.length>0){r=B(r,Z.IDENTITY);var a=Z.inverseTransformation(r,LOt),s=Z.multiplyByPoint(a,E.ZERO,OOt),l=E.normalize(Z.multiplyByPointAsVector(a,E.UNIT_Y,_5e),_5e),h=pn.fromPointNormal(s,l,FOt),x=E.normalize(Z.multiplyByPointAsVector(a,E.UNIT_X,y5e),y5e),m=pn.fromPointNormal(s,x,NOt),v=1;n.push(E.clone(e[0]));for(var _=n[0],A=e.length,T=1;T<A;++T){var w=e[T];if(pn.getPointDistance(m,_)<0||pn.getPointDistance(m,w)<0){var S=Yn.lineSegmentPlane(_,w,h,zOt);if(p(S)){var P=E.multiplyByScalar(l,5e-9,VOt);pn.getPointDistance(h,_)<0&&E.negate(P,P),n.push(E.add(S,P,new E)),o.push(v+1),E.negate(P,P),n.push(E.add(S,P,new E)),v=1}}n.push(E.clone(e[T])),v++,_=w}o.push(v)}return{positions:n,lengths:o}};bm.generateArc=function(e){p(e)||(e={});var r=e.positions;if(!p(r))throw new G("options.positions is required.");var n=r.length,o=B(e.ellipsoid,nt.WGS84),a=B(e.height,0),s=Array.isArray(a);if(n<1)return[];if(n===1){var l=o.scaleToGeodeticSurface(r[0],mX);if(a=s?a[0]:a,a!==0){var h=o.geodeticSurfaceNormal(l,jS);E.multiplyByScalar(h,a,h),E.add(l,h,l)}return[l.x,l.y,l.z]}var x=e.minDistance;if(!p(x)){var m=B(e.granularity,K.RADIANS_PER_DEGREE);x=K.chordLength(m,o.maximumRadius)}var v=0,_;for(_=0;_<n-1;_++)v+=bm.numberOfPoints(r[_],r[_+1],x);var A=e.hMax,T=(v+1)*3,w=new Array(T),S=0;for(_=0;_<n-1;_++){var P=r[_],M=r[_+1],L=s?a[_]:a,R=s?a[_+1]:a;S=UOt(P,M,x,o,L,R,w,S,A)}hX.length=0;var O=r[n-1],N=o.cartesianToCartographic(O,dX);N.height=s?a[n-1]:a;var k=o.cartographicToCartesian(N,jS);return E.pack(k,w,T-3),w};A5e=new qe,HOt=new qe;bm.generateRhumbArc=function(e){p(e)||(e={});var r=e.positions;if(!p(r))throw new G("options.positions is required.");var n=r.length,o=B(e.ellipsoid,nt.WGS84),a=B(e.height,0),s=Array.isArray(a);if(n<1)return[];if(n===1){var l=o.scaleToGeodeticSurface(r[0],mX);if(a=s?a[0]:a,a!==0){var h=o.geodeticSurfaceNormal(l,jS);E.multiplyByScalar(h,a,h),E.add(l,h,l)}return[l.x,l.y,l.z]}var x=B(e.granularity,K.RADIANS_PER_DEGREE),m=0,v,_=o.cartesianToCartographic(r[0],A5e),A;for(v=0;v<n-1;v++)A=o.cartesianToCartographic(r[v+1],HOt),m+=bm.numberOfPointsRhumbLine(_,A,x),_=qe.clone(A,A5e);var T=(m+1)*3,w=new Array(T),S=0;for(v=0;v<n-1;v++){var P=r[v],M=r[v+1],L=s?a[v]:a,R=s?a[v+1]:a;S=GOt(P,M,x,o,L,R,w,S)}hX.length=0;var O=r[n-1],N=o.cartesianToCartographic(O,dX);N.height=s?a[n-1]:a;var k=o.cartographicToCartesian(N,jS);return E.pack(k,w,T-3),w};bm.generateCartesianArc=function(e){for(var r=bm.generateArc(e),n=r.length/3,o=new Array(n),a=0;a<n;a++)o[a]=E.unpack(r,a*3);return o};bm.generateCartesianRhumbArc=function(e){for(var r=bm.generateRhumbArc(e),n=r.length/3,o=new Array(n),a=0;a<n;a++)o[a]=E.unpack(r,a*3);return o};ns=bm});function Z2(e,r){e=B(e,B.EMPTY_OBJECT),this._show=B(e.show,!0),this._width=B(e.width,1),this._loop=B(e.loop,!1),this._distanceDisplayCondition=e.distanceDisplayCondition,this._material=e.material,p(this._material)||(this._material=on.fromType(on.ColorType,{color:new se(1,1,1,1)}));var n=e.positions;p(n)||(n=[]),this._positions=n,this._actualPositions=vu(n,E.equalsEpsilon),this._loop&&this._actualPositions.length>2&&(this._actualPositions===this._positions&&(this._actualPositions=n.slice()),this._actualPositions.push(E.clone(this._actualPositions[0]))),this._length=this._actualPositions.length,this._id=e.id;var o;p(r)&&(o=Z.clone(r.modelMatrix)),this._modelMatrix=o,this._segments=ns.wrapLongitude(this._actualPositions,o),this._actualLength=void 0,this._propertiesChanged=new Uint32Array(E5e),this._polylineCollection=r,this._dirty=!1,this._pickId=void 0,this._boundingVolume=Ue.fromPoints(this._actualPositions),this._boundingVolumeWC=Ue.transform(this._boundingVolume,this._modelMatrix),this._boundingVolume2D=new Ue}function g1(e,r){++e._propertiesChanged[r];var n=e._polylineCollection;p(n)&&(n._updatePolyline(e,r),e._dirty=!0)}var w5e,WOt,qOt,jOt,YH,YOt,E5e,J2,Eme=Ee(()=>{K2();hi();bt();Ar();Ze();De();st();$0();Rr();v1();nh();y(Z2,"Polyline");w5e=Z2.POSITION_INDEX=0,WOt=Z2.SHOW_INDEX=1,qOt=Z2.WIDTH_INDEX=2,jOt=Z2.MATERIAL_INDEX=3,YH=Z2.POSITION_SIZE_INDEX=4,YOt=Z2.DISTANCE_DISPLAY_CONDITION=5,E5e=Z2.NUMBER_OF_PROPERTIES=6;y(g1,"makeDirty");Object.defineProperties(Z2.prototype,{show:{get:function(){return this._show},set:function(e){if(!p(e))throw new G("value is required.");e!==this._show&&(this._show=e,g1(this,WOt))}},positions:{get:function(){return this._positions},set:function(e){if(!p(e))throw new G("value is required.");var r=vu(e,E.equalsEpsilon);this._loop&&r.length>2&&(r===e&&(r=e.slice()),r.push(E.clone(r[0]))),(this._actualPositions.length!==r.length||this._actualPositions.length!==this._length)&&g1(this,YH),this._positions=e,this._actualPositions=r,this._length=r.length,this._boundingVolume=Ue.fromPoints(this._actualPositions,this._boundingVolume),this._boundingVolumeWC=Ue.transform(this._boundingVolume,this._modelMatrix,this._boundingVolumeWC),g1(this,w5e),this.update()}},material:{get:function(){return this._material},set:function(e){if(!p(e))throw new G("material is required.");this._material!==e&&(this._material=e,g1(this,jOt))}},width:{get:function(){return this._width},set:function(e){if(!p(e))throw new G("value is required.");var r=this._width;e!==r&&(this._width=e,g1(this,qOt))}},loop:{get:function(){return this._loop},set:function(e){if(!p(e))throw new G("value is required.");if(e!==this._loop){var r=this._actualPositions;e?r.length>2&&!E.equals(r[0],r[r.length-1])&&(r.length===this._positions.length&&(this._actualPositions=r=this._positions.slice()),r.push(E.clone(r[0]))):r.length>2&&E.equals(r[0],r[r.length-1])&&(r.length-1===this._positions.length?this._actualPositions=this._positions:r.pop()),this._loop=e,g1(this,YH)}}},id:{get:function(){return this._id},set:function(e){this._id=e,p(this._pickId)&&(this._pickId.object.id=e)}},pickId:{get:function(){return this._pickId}},distanceDisplayCondition:{get:function(){return this._distanceDisplayCondition},set:function(e){if(p(e)&&e.far<=e.near)throw new G("far distance must be greater than near distance.");Qi.equals(e,this._distanceDisplayCondition)||(this._distanceDisplayCondition=Qi.clone(e,this._distanceDisplayCondition),g1(this,YOt))}}});Z2.prototype.update=function(){var e=Z.IDENTITY;p(this._polylineCollection)&&(e=this._polylineCollection.modelMatrix);var r=this._segments.positions.length,n=this._segments.lengths,o=this._propertiesChanged[w5e]>0||this._propertiesChanged[YH]>0;if((!Z.equals(e,this._modelMatrix)||o)&&(this._segments=ns.wrapLongitude(this._actualPositions,e),this._boundingVolumeWC=Ue.transform(this._boundingVolume,e,this._boundingVolumeWC)),this._modelMatrix=Z.clone(e,this._modelMatrix),this._segments.positions.length!==r)g1(this,YH);else for(var a=n.length,s=0;s<a;++s)if(n[s]!==this._segments.lengths[s]){g1(this,YH);break}};Z2.prototype.getPickId=function(e){return p(this._pickId)||(this._pickId=e.createPickId({primitive:this,collection:this._polylineCollection,id:this._id})),this._pickId};Z2.prototype._clean=function(){this._dirty=!1;for(var e=this._propertiesChanged,r=0;r<E5e-1;++r)e[r]=0};Z2.prototype._destroy=function(){this._pickId=this._pickId&&this._pickId.destroy(),this._material=this._material&&this._material.destroy(),this._polylineCollection=void 0};J2=Z2});var QOt,Pd,pX=Ee(()=>{QOt={OCCLUDED:0,OCCLUDED_TRANSLUCENT:1,NON_OCCLUDED:2},Pd=Object.freeze(QOt)});function Ry(e){e=B(e,B.EMPTY_OBJECT),this.modelMatrix=Z.clone(B(e.modelMatrix,Z.IDENTITY)),this._modelMatrix=Z.clone(Z.IDENTITY),this.debugShowBoundingVolume=B(e.debugShowBoundingVolume,!1),this._opaqueRS=e.opaqueRS,this._translucentRS=e.translucentRS,this._colorCommands=[],this._polylinesUpdated=!1,this._polylinesRemoved=!1,this._createVertexArray=!1,this._propertiesChanged=new Uint32Array(R5e),this._polylines=[],this._polylineBuckets={},this._positionBufferUsage={bufferUsage:Nt.STATIC_DRAW,frameCount:0},this._mode=void 0,this._polylinesToUpdate=[],this._vertexArrays=[],this._positionBuffer=void 0,this._texCoordExpandAndBatchIndexBuffer=void 0,this._batchTable=void 0,this._createBatchTable=!1,this._useHighlightColor=!1,this._highlightColor=se.clone(se.WHITE);var r=this;this._uniformMap={u_highlightColor:function(){return r._highlightColor}},this._lineDisplayType=e.lineDisplayType,this._canAlwaysPick=!1,this._owner=e.owner}function $Ot(e,r){p(e._batchTable)&&e._batchTable.destroy();var n=[{functionName:"batchTable_getWidthAndShow",componentDatatype:Ie.UNSIGNED_BYTE,componentsPerAttribute:2},{functionName:"batchTable_getPickColor",componentDatatype:Ie.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0},{functionName:"batchTable_getCenterHigh",componentDatatype:Ie.FLOAT,componentsPerAttribute:3},{functionName:"batchTable_getCenterLowAndRadius",componentDatatype:Ie.FLOAT,componentsPerAttribute:4},{functionName:"batchTable_getDistanceDisplayCondition",componentDatatype:Ie.FLOAT,componentsPerAttribute:2}];e._batchTable=new Iy(r,n,e._polylines.length)}function eFt(e,r,n,o){for(var a=r.context,s=r.commandList,l=n.length,h=0,x=!0,m=e._vertexArrays,v=e.debugShowBoundingVolume,_=e._batchTable,A=_.getUniformMapCallback(),T=m.length,w=0;w<T;++w)for(var S=m[w],P=S.buckets,M=P.length,L=0;L<M;++L){for(var R=P[L],O=R.offset,N=R.bucket.shaderProgram,k=R.bucket.polylines,z=k.length,W,j,q=0,I,F,V=0;V<z;++V){var U=k[V],Q=iFt(U._material);if(Q!==W){if(p(W)&&q>0){var J=j.isTranslucent();h>=l?(I=new Yt({owner:e}),n.push(I)):I=n[h],++h,F=ei(A(j._uniforms),e._uniformMap),I.boundingVolume=Ue.clone(QH,I.boundingVolume),I.modelMatrix=o,I.shaderProgram=N,I.vertexArray=S.va,I.renderState=J?e._translucentRS:e._opaqueRS,I.pass=j.isTranslucent()?_t.TRANSLUCENT:_t.OPAQUE,I.debugShowBoundingVolume=v,I.pickId="v_pickColor",I.uniformMap=F,I.count=q,I.offset=O,O+=q,q=0,x=!0,r.passes.pick&&e._canAlwaysPick&&(I.pass=_t.OVERLAY_AGAINST_DEPTH),s.push(I)}j=U._material,j.update(a),W=Q}for(var oe=U._locatorBuckets,$=oe.length,re=0;re<$;++re){var ne=oe[re];ne.locator===R&&(q+=ne.count)}var le;r.mode===ze.SCENE3D?le=U._boundingVolumeWC:r.mode===ze.COLUMBUS_VIEW?le=U._boundingVolume2D:r.mode===ze.SCENE2D?p(U._boundingVolume2D)&&(le=Ue.clone(U._boundingVolume2D,S5e),le.center.x=0):p(U._boundingVolumeWC)&&p(U._boundingVolume2D)&&(le=Ue.union(U._boundingVolumeWC,U._boundingVolume2D,S5e)),x?(x=!1,Ue.clone(le,QH)):Ue.union(le,QH,QH)}p(W)&&q>0&&(h>=l?(I=new Yt({owner:e}),n.push(I)):I=n[h],++h,F=ei(A(j._uniforms),e._uniformMap),I.boundingVolume=Ue.clone(QH,I.boundingVolume),I.modelMatrix=o,I.shaderProgram=N,I.vertexArray=S.va,I.renderState=j.isTranslucent()?e._translucentRS:e._opaqueRS,I.pass=j.isTranslucent()?_t.TRANSLUCENT:_t.OPAQUE,I.debugShowBoundingVolume=v,I.pickId="v_pickColor",I.uniformMap=F,I.count=q,I.offset=O,r.passes.pick&&e._canAlwaysPick&&(I.pass=_t.OVERLAY_AGAINST_DEPTH),x=!0,s.push(I)),W=void 0}n.length=h}function tFt(e){var r=!1,n=e._propertiesChanged,o=e._positionBufferUsage;return n[Sme]?(o.bufferUsage!==Nt.STREAM_DRAW&&(r=!0,o.bufferUsage=Nt.STREAM_DRAW),o.frameCount=100):o.bufferUsage!==Nt.STATIC_DRAW&&(o.frameCount===0?(r=!0,o.bufferUsage=Nt.STATIC_DRAW):o.frameCount--),r}function P5e(e,r,n){e._createVertexArray=!1,Pme(e),N5e(e),nFt(e);var o=[[]],a=o[0],s=e._batchTable,l=e._useHighlightColor,h=[0],x=0,m=[[]],v=0,_=e._polylineBuckets,A,T;for(A in _)_.hasOwnProperty(A)&&(T=_[A],T.updateShader(r,s,l),v+=T.lengthOfPositions);if(v>0){var w=e._mode,S=new Float32Array(6*v*3),P=new Float32Array(v*4),M,L=0,R=0,O=0;for(A in _)if(_.hasOwnProperty(A)){T=_[A],T.write(S,P,L,R,O,s,r,n),w===ze.MORPHING&&(p(M)||(M=new Float32Array(6*v*3)),T.writeForMorph(M,L));var N=T.lengthOfPositions;L+=6*N*3,R+=N*4,O+=N*4,x=T.updateIndices(o,h,m,x)}var k=e._positionBufferUsage.bufferUsage,z=Nt.STATIC_DRAW;e._positionBuffer=or.createVertexBuffer({context:r,typedArray:S,usage:k});var W;p(M)&&(W=or.createVertexBuffer({context:r,typedArray:M,usage:k})),e._texCoordExpandAndBatchIndexBuffer=or.createVertexBuffer({context:r,typedArray:P,usage:z});for(var j=3*Float32Array.BYTES_PER_ELEMENT,q=4*Float32Array.BYTES_PER_ELEMENT,I=0,F=o.length,V=0;V<F;++V)if(a=o[V],a.length>0){var U=new Uint16Array(a),Q=or.createIndexBuffer({context:r,typedArray:U,usage:Nt.STATIC_DRAW,indexDatatype:tr.UNSIGNED_SHORT});I+=h[V];var J=6*(V*(j*K.SIXTY_FOUR_KILOBYTES)-I*j),oe=j+J,$=j+oe,re=j+$,ne=j+re,le=j+ne,ue=V*(q*K.SIXTY_FOUR_KILOBYTES)-I*q,ie=[{index:Vp.position3DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:J,strideInBytes:6*j},{index:Vp.position3DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:oe,strideInBytes:6*j},{index:Vp.position2DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:J,strideInBytes:6*j},{index:Vp.position2DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:oe,strideInBytes:6*j},{index:Vp.prevPosition3DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:$,strideInBytes:6*j},{index:Vp.prevPosition3DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:re,strideInBytes:6*j},{index:Vp.prevPosition2DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:$,strideInBytes:6*j},{index:Vp.prevPosition2DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:re,strideInBytes:6*j},{index:Vp.nextPosition3DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:ne,strideInBytes:6*j},{index:Vp.nextPosition3DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:le,strideInBytes:6*j},{index:Vp.nextPosition2DHigh,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:ne,strideInBytes:6*j},{index:Vp.nextPosition2DLow,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:le,strideInBytes:6*j},{index:Vp.texCoordExpandAndBatchIndex,componentsPerAttribute:4,componentDatatype:Ie.FLOAT,vertexBuffer:e._texCoordExpandAndBatchIndexBuffer,offsetInBytes:ue}],ce,he,_e,Ae;w===ze.SCENE3D?(ce=e._positionBuffer,he="vertexBuffer",_e=I5e,Ae="value"):w===ze.SCENE2D||w===ze.COLUMBUS_VIEW?(ce=I5e,he="value",_e=e._positionBuffer,Ae="vertexBuffer"):(ce=W,he="vertexBuffer",_e=e._positionBuffer,Ae="vertexBuffer"),ie[0][he]=ce,ie[1][he]=ce,ie[2][Ae]=_e,ie[3][Ae]=_e,ie[4][he]=ce,ie[5][he]=ce,ie[6][Ae]=_e,ie[7][Ae]=_e,ie[8][he]=ce,ie[9][he]=ce,ie[10][Ae]=_e,ie[11][Ae]=_e;var be=new zr({context:r,attributes:ie,indexBuffer:Q});e._vertexArrays.push({va:be,buckets:m[V]})}}}function rFt(e,r){return r instanceof Vt?r.id:r}function iFt(e){var r=on._uniformList[e.type],n=r.length;vX.length=2*n;for(var o=0,a=0;a<n;++a){var s=r[a];vX[o]=s,vX[o+1]=e._uniforms[s](),o+=2}return e.type+":"+JSON.stringify(vX,rFt)}function nFt(e){for(var r=e._mode,n=e._modelMatrix,o=e._polylineBuckets={},a=e._polylines,s=a.length,l=0;l<s;++l){var h=a[l];if(h._actualPositions.length>1){h.update();var x=h.material,m=o[x.type];p(m)||(m=o[x.type]=new YC(x,r,n)),m.addPolyline(h)}}}function oFt(e,r){var n=r.mode;(e._mode!==n||!Z.equals(e._modelMatrix,e.modelMatrix))&&(e._mode=n,e._modelMatrix=Z.clone(e.modelMatrix),e._createVertexArray=!0)}function Ime(e){if(e._polylinesRemoved){e._polylinesRemoved=!1;for(var r=[],n=e._polylines.length,o=0,a=0;o<n;++o){var s=e._polylines[o];p(s)&&(s._index=a++,r.push(s))}e._polylines=r}}function Pme(e){for(var r=e._polylines,n=r.length,o=0;o<n;++o)if(p(r[o])){var a=r[o]._bucket;p(a)&&(a.shaderProgram=a.shaderProgram&&a.shaderProgram.destroy())}}function N5e(e){for(var r=e._vertexArrays.length,n=0;n<r;++n)e._vertexArrays[n].va.destroy();e._vertexArrays.length=0}function z5e(e){for(var r=e._polylines,n=r.length,o=0;o<n;++o)p(r[o])&&r[o]._destroy()}function bme(e,r,n){this.count=e,this.offset=r,this.bucket=n}function YC(e,r,n){this.polylines=[],this.lengthOfPositions=0,this.material=e,this.shaderProgram=void 0,this.mode=r,this.modelMatrix=n}function V5e(e){return E.dot(E.UNIT_X,e._boundingVolume.center)<0||e._boundingVolume.intersectPlane(pn.ORIGIN_ZX_PLANE)===wi.INTERSECTING}var XOt,KOt,Sme,ZOt,b5e,JOt,R5e,Vp,L5e,O5e,F5e,QH,S5e,I5e,vX,Qf,Eg,bg,gX,aFt,sFt,lFt,uFt,cFt,D5e,fFt,aN,M5e,xFt,hFt,B5e,oh,QC=Ee(()=>{hi();Fr();bt();Ci();Si();Ar();Ua();mi();Ze();De();ur();st();Ax();ou();_n();Ql();nr();Rr();K0();zo();Vo();io();Pl();Kn();Ao();Zi();so();bn();yn();Co();WH();_me();P6e();QF();va();nh();Eme();zi();pX();cr();J0();XOt=J2.SHOW_INDEX,KOt=J2.WIDTH_INDEX,Sme=J2.POSITION_INDEX,ZOt=J2.MATERIAL_INDEX,b5e=J2.POSITION_SIZE_INDEX,JOt=J2.DISTANCE_DISPLAY_CONDITION,R5e=J2.NUMBER_OF_PROPERTIES,Vp={texCoordExpandAndBatchIndex:0,position3DHigh:1,position3DLow:2,position2DHigh:3,position2DLow:4,prevPosition3DHigh:5,prevPosition3DLow:6,prevPosition2DHigh:7,prevPosition2DLow:8,nextPosition3DHigh:9,nextPosition3DLow:10,nextPosition2DHigh:11,nextPosition2DLow:12};y(Ry,"PolylineCollection");Object.defineProperties(Ry.prototype,{length:{get:function(){return Ime(this),this._polylines.length}},lineDisplayType:{get:function(){return this._lineDisplayType},set:function(e){if(X.typeOf.number.greaterThanOrEquals("PolylineCollection.lineDisplayType",e,0),X.typeOf.number.lessThanOrEquals("PolylineCollection.lineDisplayType",e,2),this._lineDisplayType!==e){this._lineDisplayType=e;for(var r,n=this._polylines.length,o=0;o<n;o++){r=void 0;var a=this._polylines[o];if(!!p(a)){for(var s=o+1;s<n;s++){var l=this._polylines[s];if(!!p(l)&&l.id&&l.id===a._index+"-alpha"){r=l;break}}if(!p(r)&&this._lineDisplayType===Pd.OCCLUDED_TRANSLUCENT){var h={show:a.show,positions:a.positions,width:a.width,loop:a.loop,distanceDisplayCondition:a._distanceDisplayCondition},x=on.fromType(on.ColorType,{color:se.clone(a.material.uniforms.color,new se).withAlpha(.2)});x.uniforms.color.alpha=.2,h.material=x;var m=new J2(h,this);m.material=x,m._index=this._polylines.length,m.id=a._index+"-alpha",this._polylines.push(m),this._createVertexArray=!0,this._createBatchTable=!0}else p(r)&&this._lineDisplayType!==Pd.OCCLUDED_TRANSLUCENT&&this.remove(r)}}this._lineDisplayType===Pd.OCCLUDED_TRANSLUCENT?(this._opaqueRS=Et.fromCache({depthMask:!0,depthTest:{enabled:!0}}),this._translucentRS=Et.fromCache({depthMask:!1,depthTest:{enabled:!1}})):this._lineDisplayType===Pd.NON_OCCLUDED?this._opaqueRS=Et.fromCache({depthMask:!1,depthTest:{enabled:!1}}):this._lineDisplayType===Pd.OCCLUDED&&(this._opaqueRS=Et.fromCache({depthMask:!0,depthTest:{enabled:!0}}))}}}});Ry.prototype.add=function(e){var r=new J2(e,this);if(r._index=this._polylines.length,this._polylines.push(r),this._lineDisplayType===Pd.OCCLUDED_TRANSLUCENT){this._opaqueRS=Et.fromCache({depthMask:!0,depthTest:{enabled:!0}}),this._translucentRS=Et.fromCache({depthMask:!1,depthTest:{enabled:!1}});var n=on.fromType(on.ColorType,{color:se.clone(e.material.uniforms.color,new se).withAlpha(.2)});n.uniforms.color.alpha=.2;var o=new J2(e,this);o.material=n,o._index=this._polylines.length,o.id=r._index+"-alpha",this._polylines.push(o)}else this._lineDisplayType===Pd.NON_OCCLUDED?this._opaqueRS=Et.fromCache({depthMask:!1,depthTest:{enabled:!1}}):this._lineDisplayType===Pd.OCCLUDED&&(this._opaqueRS=Et.fromCache({depthMask:!0,depthTest:{enabled:!0}}));return this._createVertexArray=!0,this._createBatchTable=!0,r};Ry.prototype.remove=function(e){if(this.contains(e)){this._polylines[e._index]=void 0;var r=this._polylinesToUpdate.indexOf(e);if(r!==-1&&this._polylinesToUpdate.splice(r,1),this._polylinesRemoved=!0,this._createVertexArray=!0,this._createBatchTable=!0,p(e._bucket)){var n=e._bucket;n.shaderProgram=n.shaderProgram&&n.shaderProgram.destroy()}e._destroy();for(var o,a=0,s=this._polylines.length;a<s;a++){var l=this._polylines[a];l&&l.id&&l.id===e._index+"-alpha"&&(o=l)}if(p(o)){this._polylines[o._index]=void 0;var h=this._polylinesToUpdate.indexOf(e);h!==-1&&this._polylinesToUpdate.splice(h,1),o._destroy()}return!0}return!1};Ry.prototype.removeAll=function(){Pme(this),z5e(this),this._polylineBuckets={},this._polylinesRemoved=!1,this._polylines.length=0,this._polylinesToUpdate.length=0,this._createVertexArray=!0};Ry.prototype.contains=function(e){return p(e)&&e._polylineCollection===this};Ry.prototype.get=function(e){if(!p(e))throw new G("index is required.");return Ime(this),this._polylines[e]};y($Ot,"createBatchTable");L5e=new Pn,O5e=new Ce,F5e=new de;Ry.prototype.update=function(e){if(Ime(this),this._polylines.length!==0){var r=this._owner;if(e.multiViewportIndex>-1&&this._owner&&typeof r.getVisibleInViewport<"u"){var n=r.getVisibleInViewport(e.multiViewportIndex);if(!n)return}oFt(this,e);var o=e.context,a=e.mapProjection,s,l=this._propertiesChanged;if(this._createBatchTable){if(fi.maximumVertexTextureImageUnits===0)throw new Ht("Vertex texture fetch support is required to render polylines. The maximum number of vertex texture image units must be greater than zero.");$Ot(this,o),this._createBatchTable=!1}if(this._createVertexArray||tFt(this))P5e(this,o,a);else if(this._polylinesUpdated){var h=this._polylinesToUpdate;if(this._mode!==ze.SCENE3D)for(var x=h.length,m=0;m<x;++m)s=h[m],s.update();if(l[b5e]||l[ZOt])P5e(this,o,a);else for(var v=h.length,_=this._polylineBuckets,A=0;A<v;++A){s=h[A],l=s._propertiesChanged;var T=s._bucket,w=0;for(var S in _)if(_.hasOwnProperty(S)){if(_[S]===T){l[Sme]&&T.writeUpdate(w,s,this._positionBuffer,a);break}w+=_[S].lengthOfPositions}if((l[XOt]||l[KOt])&&this._batchTable.setBatchedAttribute(s._index,0,new de(s._width,s._show)),this._batchTable.attributes.length>2){if(l[Sme]||l[b5e]){var P=e.mode===ze.SCENE2D?s._boundingVolume2D:s._boundingVolumeWC,M=Pn.fromCartesian(P.center,L5e),L=Ce.fromElements(M.low.x,M.low.y,M.low.z,P.radius,O5e);this._batchTable.setBatchedAttribute(s._index,2,M.high),this._batchTable.setBatchedAttribute(s._index,3,L)}if(l[JOt]){var R=F5e;R.x=0,R.y=Number.MAX_VALUE;var O=s.distanceDisplayCondition;p(O)&&(R.x=O.near,R.y=O.far),this._batchTable.setBatchedAttribute(s._index,4,R)}}s._clean()}h.length=0,this._polylinesUpdated=!1}l=this._propertiesChanged;for(var N=0;N<R5e;++N)l[N]=0;var k=Z.IDENTITY;e.mode===ze.SCENE3D&&(k=this.modelMatrix);var z=e.passes,W=e.morphTime!==0;p(this._opaqueRS)||(this._opaqueRS=Et.fromCache({depthMask:W,depthTest:{enabled:W}})),p(this._translucentRS)||(this._translucentRS=Et.fromCache({blending:pi.ALPHA_BLEND,depthMask:!W,depthTest:{enabled:W}})),this._batchTable.update(e);var j=e._fboState.frameBufferType;if(j!==So.CLAMP&&(z.render||z.pick)){var q=this._colorCommands;eFt(this,e,q,k)}}};QH=new Ue,S5e=new Ue;y(eFt,"createCommandLists");Ry.prototype.isDestroyed=function(){return!1};Ry.prototype.destroy=function(){return N5e(this),Pme(this),z5e(this),this._batchTable=this._batchTable&&this._batchTable.destroy(),$e(this)};y(tFt,"computeNewBuffersUsage");I5e=[0,0,0];y(P5e,"createVertexArrays");y(rFt,"replacer");vX=[];y(iFt,"createMaterialId");y(nFt,"sortPolylinesIntoBuckets");y(oFt,"updateMode");y(Ime,"removePolylines");y(Pme,"releaseShaders");y(N5e,"destroyVertexArrays");Ry.prototype._updatePolyline=function(e,r){if(!(typeof e.id=="string"&&e.id.slice(-5)==="alpha")){if(this._polylinesUpdated=!0,e._dirty||this._polylinesToUpdate.push(e),this._lineDisplayType===Pd.OCCLUDED_TRANSLUCENT)for(var n=0;n<this._polylines.length;n++){var o=this._polylines[n];o.id&&o.id===e._index+"-alpha"&&(o._dirty||this._polylinesToUpdate.push(o),o.positions=e.positions,++this._propertiesChanged[r])}++this._propertiesChanged[r]}};y(z5e,"destroyPolylines");y(bme,"VertexArrayBucketLocator");y(YC,"PolylineBucket");YC.prototype.addPolyline=function(e){var r=this.polylines;r.push(e),e._actualLength=this.getPolylinePositionsLength(e),this.lengthOfPositions+=e._actualLength,e._bucket=this};YC.prototype.updateShader=function(e,r,n){if(!p(this.shaderProgram)){var o=["DISTANCE_DISPLAY_CONDITION"];n&&o.push("VECTOR_TILE"),this.material.shaderSource.search(/varying\s+float\s+v_polylineAngle;/g)!==-1&&o.push("POLYLINE_DASH"),this.material.type==="PolylineDynamic"&&o.push("ENABLE_DYNAMIC"),Gn.isInternetExplorer()||o.push("CLIP_POLYLINE"),o.push("LINEJOIN_BEVEL");var a=new yt({defines:o,sources:[`varying vec4 v_pickColor;
`,this.material.shaderSource,cX]}),s=r.getVertexShaderCallback()(I6e),l=new yt({defines:o,sources:[HS,s]});this.shaderProgram=fr.fromCache({context:e,vertexShaderSource:l,fragmentShaderSource:a,attributeLocations:Vp})}};y(V5e,"intersectsIDL");YC.prototype.getPolylinePositionsLength=function(e){var r;if(this.mode===ze.SCENE3D||!V5e(e))return r=e._actualPositions.length,r*4-4;var n=0,o=e._segments.lengths;r=o.length;for(var a=0;a<r;++a)n+=o[a]*4-4;return n};Qf=new E,Eg=new E,bg=new E,gX=new E,aFt=new Ce,sFt=new de;YC.prototype.write=function(e,r,n,o,a,s,l,h){for(var x=this.mode,m=h.ellipsoid.maximumRadius*K.PI,v=this.polylines,_=v.length,A=0;A<_;++A){for(var T=v[A],w=T.width,S=T.show&&w>0,P=T._index,M=this.getSegments(T,h),L=M.positions,R=M.lengths,O=L.length,N=T.getPickId(l).color,k=0,z=0,W,j=0;j<O;++j){j===0?T._loop?W=L[O-2]:(W=gX,E.subtract(L[0],L[1],W),E.add(L[0],W,W)):W=L[j-1],E.clone(W,Eg),E.clone(L[j],Qf),j===O-1?T._loop?W=L[1]:(W=gX,E.subtract(L[O-1],L[O-2],W),E.add(L[O-1],W,W)):W=L[j+1],E.clone(W,bg);var q=R[k];j===z+q&&(z+=q,++k);var I=j-z===0,F=j===z+R[k]-1;x===ze.SCENE2D&&(Eg.z=0,Qf.z=0,bg.z=0),(x===ze.SCENE2D||x===ze.MORPHING)&&(I||F)&&m-Math.abs(Qf.x)<1&&((Qf.x<0&&Eg.x>0||Qf.x>0&&Eg.x<0)&&E.clone(Qf,Eg),(Qf.x<0&&bg.x>0||Qf.x>0&&bg.x<0)&&E.clone(Qf,bg));for(var V=I?2:0,U=F?2:4,Q=V;Q<U;++Q){Pn.writeElements(Qf,e,n),Pn.writeElements(Eg,e,n+6),Pn.writeElements(bg,e,n+12);var J=Q-2<0?-1:1;r[a]=j/(O-1),r[a+1]=2*(Q%2)-1,r[a+2]=J,r[a+3]=P,n+=6*3,a+=4}}var oe=aFt;oe.x=se.floatToByte(N.red),oe.y=se.floatToByte(N.green),oe.z=se.floatToByte(N.blue),oe.w=se.floatToByte(N.alpha);var $=sFt;$.x=w,$.y=S?1:0;var re=x===ze.SCENE2D?T._boundingVolume2D:T._boundingVolumeWC,ne=Pn.fromCartesian(re.center,L5e),le=ne.high,ue=Ce.fromElements(ne.low.x,ne.low.y,ne.low.z,re.radius,O5e),ie=F5e;ie.x=0,ie.y=Number.MAX_VALUE;var ce=T.distanceDisplayCondition;p(ce)&&(ie.x=ce.near,ie.y=ce.far),s.setBatchedAttribute(P,0,$),s.setBatchedAttribute(P,1,oe),s.attributes.length>2&&(s.setBatchedAttribute(P,2,le),s.setBatchedAttribute(P,3,ue),s.setBatchedAttribute(P,4,ie))}};lFt=new E,uFt=new E,cFt=new E,D5e=new E;YC.prototype.writeForMorph=function(e,r){for(var n=this.modelMatrix,o=this.polylines,a=o.length,s=0;s<a;++s)for(var l=o[s],h=l._segments.positions,x=l._segments.lengths,m=h.length,v=0,_=0,A=0;A<m;++A){var T;A===0?l._loop?T=h[m-2]:(T=D5e,E.subtract(h[0],h[1],T),E.add(h[0],T,T)):T=h[A-1],T=Z.multiplyByPoint(n,T,uFt);var w=Z.multiplyByPoint(n,h[A],lFt),S;A===m-1?l._loop?S=h[1]:(S=D5e,E.subtract(h[m-1],h[m-2],S),E.add(h[m-1],S,S)):S=h[A+1],S=Z.multiplyByPoint(n,S,cFt);var P=x[v];A===_+P&&(_+=P,++v);for(var M=A-_===0,L=A===_+x[v]-1,R=M?2:0,O=L?2:4,N=R;N<O;++N)Pn.writeElements(w,e,r),Pn.writeElements(T,e,r+6),Pn.writeElements(S,e,r+12),r+=6*3}};fFt=new Array(1);YC.prototype.updateIndices=function(e,r,n,o){var a=n.length-1,s=new bme(0,o,this);n[a].push(s);var l=0,h=e[e.length-1],x=0;h.length>0&&(x=h[h.length-1]+1);for(var m=this.polylines,v=m.length,_=0;_<v;++_){var A=m[_];A._locatorBuckets=[];var T;if(this.mode===ze.SCENE3D){T=fFt;var w=A._actualPositions.length;if(w>0)T[0]=w;else continue}else T=A._segments.lengths;var S=T.length;if(S>0){for(var P=0,M=0;M<S;++M)for(var L=T[M]-1,R=0;R<L;++R){x+4>K.SIXTY_FOUR_KILOBYTES&&(A._locatorBuckets.push({locator:s,count:P}),P=0,r.push(4),h=[],e.push(h),x=0,s.count=l,l=0,o=0,s=new bme(0,0,this),n[++a]=[s]),h.push(x,x+2,x+1),h.push(x+1,x+2,x+3);let O=0;L>1&&R!==L-1&&(h.push(x+3,x+5,x+4),h.push(x+2,x+5,x+4),O=6),P+=6+O,l+=6+O,o+=6+O,x+=4}A._locatorBuckets.push({locator:s,count:P}),x+4>K.SIXTY_FOUR_KILOBYTES&&(r.push(0),h=[],e.push(h),x=0,s.count=l,o=0,l=0,s=new bme(0,0,this),n[++a]=[s])}A._clean()}return s.count=l,o};YC.prototype.getPolylineStartIndex=function(e){for(var r=this.polylines,n=0,o=r.length,a=0;a<o;++a){var s=r[a];if(s===e)break;n+=s._actualLength}return n};aN={positions:void 0,lengths:void 0},M5e=new Array(1),xFt=new E,hFt=new qe;YC.prototype.getSegments=function(e,r){var n=e._actualPositions;if(this.mode===ze.SCENE3D)return M5e[0]=n.length,aN.positions=n,aN.lengths=M5e,aN;V5e(e)&&(n=e._segments.positions);for(var o=r.ellipsoid,a=[],s=this.modelMatrix,l=n.length,h,x=xFt,m=0;m<l;++m)h=n[m],x=Z.multiplyByPoint(s,h,x),a.push(r.project(o.cartesianToCartographic(x,hFt)));if(a.length>0){e._boundingVolume2D=Ue.fromPoints(a,e._boundingVolume2D);var v=e._boundingVolume2D.center;e._boundingVolume2D.center=new E(v.z,v.x,v.y)}return aN.positions=a,aN.lengths=e._segments.lengths,aN};YC.prototype.writeUpdate=function(e,r,n,o){var a=this.mode,s=o.ellipsoid.maximumRadius*K.PI,l=r._actualLength;if(l){e+=this.getPolylineStartIndex(r);var h=B5e,x=6*l*3;!p(h)||h.length<x?h=B5e=new Float32Array(x):h.length>x&&(h=new Float32Array(h.buffer,0,x));var m=this.getSegments(r,o),v=m.positions,_=m.lengths,A=0,T=0,w=0,S;l=v.length;for(var P=0;P<l;++P){P===0?r._loop?S=v[l-2]:(S=gX,E.subtract(v[0],v[1],S),E.add(v[0],S,S)):S=v[P-1],E.clone(S,Eg),E.clone(v[P],Qf),P===l-1?r._loop?S=v[1]:(S=gX,E.subtract(v[l-1],v[l-2],S),E.add(v[l-1],S,S)):S=v[P+1],E.clone(S,bg);var M=_[T];P===w+M&&(w+=M,++T);var L=P-w===0,R=P===w+_[T]-1;a===ze.SCENE2D&&(Eg.z=0,Qf.z=0,bg.z=0),(a===ze.SCENE2D||a===ze.MORPHING)&&(L||R)&&s-Math.abs(Qf.x)<1&&((Qf.x<0&&Eg.x>0||Qf.x>0&&Eg.x<0)&&E.clone(Qf,Eg),(Qf.x<0&&bg.x>0||Qf.x>0&&bg.x<0)&&E.clone(Qf,bg));for(var O=L?2:0,N=R?2:4,k=O;k<N;++k)Pn.writeElements(Qf,h,A),Pn.writeElements(Eg,h,A+6),Pn.writeElements(bg,h,A+12),A+=6*3}n.copyFromArrayView(h,6*3*Float32Array.BYTES_PER_ELEMENT*e)}};oh=Ry});function _X(e){e=B(e,!0),this.value=_X.toValue(e)}var Io,Xc=Ee(()=>{mi();Ze();De();st();y(_X,"ShowGeometryInstanceAttribute");Object.defineProperties(_X.prototype,{componentDatatype:{get:function(){return Ie.UNSIGNED_BYTE}},componentsPerAttribute:{get:function(){return 1}},normalize:{get:function(){return!1}}});_X.toValue=function(e,r){if(!p(e))throw new G("show is required.");return p(r)?(r[0]=e,r):new Uint8Array([e])};Io=_X});function _1(e){e=B(e,{}),this._ellipsoid=B(e.ellipsoid,nt.WGS84),this._rectangle=B(e.rectangle,He.MAX_VALUE),this._projection=new yo(this._ellipsoid),this._numberOfLevelZeroTilesX=B(e.numberOfLevelZeroTilesX,2),this._numberOfLevelZeroTilesY=B(e.numberOfLevelZeroTilesY,1),this._customDPI=e.customDPI,this._scaleDenominators=e.scaleDenominators,this._tileWidth=B(e.tileWidth,256),this._tileHeight=B(e.tileHeight,256),this._beginLevel=B(e.beginLevel,0),this._origin=B(e.origin,void 0)}var Aa,ec=Ee(()=>{Fr();cr();Ze();De();Ii();iu();nr();Ni();y(_1,"GeographicTilingScheme");Object.defineProperties(_1.prototype,{ellipsoid:{get:function(){return this._ellipsoid}},rectangle:{get:function(){return this._rectangle}},projection:{get:function(){return this._projection}},beginLevel:{get:function(){return this._beginLevel}},origin:{get:function(){return this._origin}}});_1.prototype.getNumberOfXTilesAtLevel=function(e){if(p(this._customDPI)&&p(this._scaleDenominators)){var r=this.calculateResolution(e),n=this._tileWidth*r.x;return Math.ceil(this._rectangle.width/n)}return this._numberOfLevelZeroTilesX<<e-this._beginLevel};_1.prototype.getNumberOfYTilesAtLevel=function(e){if(p(this._customDPI)&&p(this._scaleDenominators)){var r=this.calculateResolution(e),n=this._tileHeight*r.y;return Math.ceil(this._rectangle.height/n)}return this._numberOfLevelZeroTilesY<<e-this._beginLevel};_1.prototype.rectangleToNativeRectangle=function(e,r){X.defined("rectangle",e);var n=K.toDegrees(e.west),o=K.toDegrees(e.south),a=K.toDegrees(e.east),s=K.toDegrees(e.north);return p(r)?(r.west=n,r.south=o,r.east=a,r.north=s,r):new He(n,o,a,s)};_1.prototype.tileXYToNativeRectangle=function(e,r,n,o){var a=this.tileXYToRectangle(e,r,n,o);return a.west=K.toDegrees(a.west),a.south=K.toDegrees(a.south),a.east=K.toDegrees(a.east),a.north=K.toDegrees(a.north),a};_1.prototype.tileXYToRectangle=function(e,r,n,o){var a=this._rectangle,s=p(this._origin)?this._origin.longitude:a.west,l=p(this._origin)?this._origin.latitude:a.north;if(p(this._customDPI)&&p(this._scaleDenominators)){var h=this.calculateResolution(n),_=s+e*this._tileWidth*h.x,A=s+(e+1)*this._tileWidth*h.x,w=l-r*this._tileHeight*h.y,S=l-(r+1)*this._tileHeight*h.y;return p(o)?(o.west=_,o.south=S,o.east=A,o.north=w,o):new He(_,S,A,w)}var x=this.getNumberOfXTilesAtLevel(n),m=this.getNumberOfYTilesAtLevel(n),v=a.width/x,_=e*v+a.west,A=(e+1)*v+a.west,T=a.height/m,w=a.north-r*T,S=a.north-(r+1)*T;return p(o)||(o=new He(_,S,A,w)),o.west=_,o.south=S,o.east=A,o.north=w,o};_1.prototype.positionToTileXY=function(e,r,n){var o=this._rectangle;if(!!He.contains(o,e)){var a=this.getNumberOfXTilesAtLevel(r),s=this.getNumberOfYTilesAtLevel(r),l=p(this._origin)?this._origin.longitude:o.west,h=p(this._origin)?this._origin.latitude:o.north,x=o.width/a,m=o.height/s;if(p(this._customDPI)&&p(this._scaleDenominators)){var v=this.calculateResolution(r);x=this._tileWidth*v.x,m=this._tileHeight*v.y}var _=e.longitude;o.east<o.west&&(_+=K.TWO_PI),p(this._origin)&&(a+=this._origin.longitude!=o.west?Math.ceil((e.longitude-this._origin.longitude)/x):0,s+=this._origin.latitude!=o.north?Math.ceil((this._origin.latitude-e.latitude)/m):0);var A=(_-l)/x|0;A>=a&&(A=a-1);var T=(h-e.latitude)/m|0;return T>=s&&(T=s-1),p(n)?(n.x=A,n.y=T,n):new de(A,T)}};_1.prototype.calculateResolution=function(e){var r=Math.min(e-this._beginLevel,this._scaleDenominators.length-1),n=this._scaleDenominators[r]*.0254/this._customDPI.x,o=this._scaleDenominators[r]*.0254/this._customDPI.y,a=nt.WGS84.maximumRadius;return new de(n/a,o/a)};Aa=_1});function W5e(e){qe.fromRadians(e.east,e.north,0,XH[0]),qe.fromRadians(e.west,e.north,0,XH[1]),qe.fromRadians(e.east,e.south,0,XH[2]),qe.fromRadians(e.west,e.south,0,XH[3]);var r=0,n=0,o=0,a=0,s=tc._terrainHeightsMaxLevel,l;for(l=0;l<=s;++l){for(var h=!1,x=0;x<4;++x){var m=XH[x];if(mFt.positionToTileXY(m,l,KH),x===0)o=KH.x,a=KH.y;else if(o!==KH.x||a!==KH.y){h=!0;break}}if(h)break;r=o,n=a}if(l!==0)return{x:r,y:n,level:l>s?s:l-1}}var k5e,U5e,G5e,Dme,dFt,H5e,mFt,XH,KH,tc,Zs,$2=Ee(()=>{hi();Xs();Fr();bt();Si();cr();Ze();De();st();Ii();ec();Ni();hn();k5e=new E,U5e=new E,G5e=new qe,Dme=new E,dFt=new E,H5e=new Ue,mFt=new Aa,XH=[new qe,new qe,new qe,new qe],KH=new de,tc={};tc.initialize=function(){var e=tc._initPromise;return p(e)||(e=ir.fetchJson(gi("Assets/approximateTerrainHeights.json")).then(function(r){tc._terrainHeights=r}),tc._initPromise=e),e};tc.getMinimumMaximumHeights=function(e,r){if(X.defined("rectangle",e),!p(tc._terrainHeights))throw new G("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");r=B(r,nt.WGS84);var n=W5e(e),o=tc._defaultMinTerrainHeight,a=tc._defaultMaxTerrainHeight;if(p(n)){var s=n.level+"-"+n.x+"-"+n.y,l=tc._terrainHeights[s];p(l)&&(o=l[0],a=l[1]),r.cartographicToCartesian(He.northeast(e,G5e),k5e),r.cartographicToCartesian(He.southwest(e,G5e),U5e),E.midpoint(U5e,k5e,Dme);var h=r.scaleToGeodeticSurface(Dme,dFt);if(p(h)){var x=E.distance(Dme,h);o=Math.min(o,-x)}else o=tc._defaultMinTerrainHeight}return o=Math.max(tc._defaultMinTerrainHeight,o),{minimumTerrainHeight:o,maximumTerrainHeight:a}};tc.getBoundingSphere=function(e,r){if(X.defined("rectangle",e),!p(tc._terrainHeights))throw new G("You must call ApproximateTerrainHeights.initialize and wait for the promise to resolve before using this function");r=B(r,nt.WGS84);var n=W5e(e),o=tc._defaultMaxTerrainHeight;if(p(n)){var a=n.level+"-"+n.x+"-"+n.y,s=tc._terrainHeights[a];p(s)&&(o=s[1])}var l=Ue.fromRectangle3D(e,r,0);return p(n)?(Ue.fromRectangle3D(e,r,o,H5e),Ue.union(l,H5e,l)):l};y(W5e,"getTileXYLevel");tc._terrainHeightsMaxLevel=6;tc._defaultMaxTerrainHeight=9e3;tc._defaultMinTerrainHeight=-1e5;tc._terrainHeights=void 0;tc._initPromise=void 0;Object.defineProperties(tc,{initialized:{get:function(){return p(tc._terrainHeights)}}});Zs=tc});var pFt,vn,kp=Ee(()=>{pFt={NONE:0,GEODESIC:1,RHUMB:2},vn=Object.freeze(pFt)});function QS(e){e=B(e,B.EMPTY_OBJECT);var r=e.positions;if(!p(r)||r.length<2)throw new G("At least two positions are required.");if(p(e.arcType)&&e.arcType!==vn.GEODESIC&&e.arcType!==vn.RHUMB)throw new G("Valid options for arcType are ArcType.GEODESIC and ArcType.RHUMB.");this.width=B(e.width,1),this._positions=r,this.granularity=B(e.granularity,9999),this.loop=B(e.loop,!1),this.arcType=B(e.arcType,vn.GEODESIC),this._ellipsoid=B(e.ellipsoid,nt.WGS84),this._projectionIndex=0,this._workerName="createGroundPolylineGeometry",this._scene3DOnly=!1}function Nme(e,r,n,o,a){var s=Sm(o,e,0,gFt),l=Sm(o,e,n,j5e),h=Sm(o,r,0,Y5e),x=y1(l,s,j5e),m=y1(h,s,Y5e);return E.cross(m,x,a),E.normalize(a,a)}function Mme(e,r,n,o,a,s,l,h,x,m,v){if(a!==0){var _;s===vn.GEODESIC?_=new Ey(e,r,l):s===vn.RHUMB&&(_=new Em(e,r,l));var A=_.surfaceDistance;if(!(A<a))for(var T=Nme(e,r,o,l,CFt),w=Math.ceil(A/a),S=A/w,P=S,M=w-1,L=h.length,R=0;R<M;R++){var O=_.interpolateUsingSurfaceDistance(P,_Ft),N=Sm(l,O,n,yFt),k=Sm(l,O,o,AFt);E.pack(T,h,L),E.pack(N,x,L),E.pack(k,m,L),v.push(O.latitude),v.push(O.longitude),L+=3,P+=S}}}function Sm(e,r,n,o){return qe.clone(r,Bme),Bme.height=n,qe.toCartesian(Bme,e,o)}function y1(e,r,n){return E.subtract(e,r,n),E.normalize(n,n),n}function Q5e(e,r,n,o){return o=y1(e,r,o),o=E.cross(o,n,o),o=E.normalize(o,o),o=E.cross(n,o,o),o}function Rme(e,r,n,o,a){var s=y1(n,r,h9e),l=Q5e(e,r,s,TFt),h=Q5e(o,r,s,wFt);if(K.equalsEpsilon(E.dot(l,h),SFt,K.EPSILON5))return a=E.cross(s,l,a),a=E.normalize(a,a),a;a=E.add(h,l,a),a=E.normalize(a,a);var x=E.cross(s,a,EFt);return E.dot(h,x)<bFt&&(a=E.negate(a,a)),a}function Z5e(e,r,n,o){var a=y1(n,r,RFt),s=E.dot(a,e);if(s>c9e||s<q5e){var l=y1(o,n,h9e),h=s<q5e?K.PI_OVER_TWO:-K.PI_OVER_TWO,x=hr.fromAxisAngle(l,h,OFt),m=We.fromQuaternion(x,LFt);return We.multiplyByVector(m,e,e),!0}return!1}function ZH(e,r,n,o,a){var s=qe.toCartesian(r,e._ellipsoid,FFt),l=E.add(s,n,$5e),h=!1,x=e._ellipsoid,m=x.cartesianToCartographic(l,J5e);Math.abs(r.longitude-m.longitude)>K.PI_OVER_TWO&&(h=!0,l=E.subtract(s,n,$5e),m=x.cartesianToCartographic(l,J5e)),m.height=0;var v=e.project(m,a);return a=E.subtract(v,o,a),a.z=0,a=E.normalize(a,a),h&&E.negate(a,a),a}function t9e(e,r,n,o,a,s){var l=E.subtract(r,e,NFt);E.normalize(l,l);var h=n-f9e,x=E.multiplyByScalar(l,h,e9e);E.add(e,x,a);var m=o-x9e;x=E.multiplyByScalar(l,m,e9e),E.add(r,x,s)}function CX(e,r){var n=pn.getPointDistance(TX,e),o=pn.getPointDistance(TX,r),a=zFt;K.equalsEpsilon(n,0,K.EPSILON2)?(a=y1(r,e,a),E.multiplyByScalar(a,K.EPSILON2,a),E.add(e,a,e)):K.equalsEpsilon(o,0,K.EPSILON2)&&(a=y1(e,r,a),E.multiplyByScalar(a,K.EPSILON2,a),E.add(r,a,r))}function VFt(e,r){var n=Math.abs(e.longitude),o=Math.abs(r.longitude);if(K.equalsEpsilon(n,K.PI,K.EPSILON11)){var a=K.sign(r.longitude);return e.longitude=a*(n-K.EPSILON11),1}else if(K.equalsEpsilon(o,K.PI,K.EPSILON11)){var s=K.sign(e.longitude);return r.longitude=s*(o-K.EPSILON11),2}return 0}function nNt(e,r,n,o,a,s,l){var h,x,m=r._ellipsoid,v=n.length/3-1,_=v*8,A=_*4,T=v*36,w=_>65535?new Uint32Array(T):new Uint16Array(T),S=new Float64Array(_*3),P=new Float32Array(A),M=new Float32Array(A),L=new Float32Array(A),R=new Float32Array(A),O=new Float32Array(A),N,k,z,W;l&&(N=new Float32Array(A),k=new Float32Array(A),z=new Float32Array(A),W=new Float32Array(_*2));var j=s.length/2,q=0,I=d9e;I.height=0;var F=m9e;F.height=0;var V=r9e,U=Lme;if(l)for(x=0,h=1;h<j;h++)I.latitude=s[x],I.longitude=s[x+1],F.latitude=s[x+2],F.longitude=s[x+3],V=r.project(I,V),U=r.project(F,U),q+=E.distance(V,U),x+=2;var Q=o.length/3;U=E.unpack(o,0,U);var J=0;for(x=3,h=1;h<Q;h++)V=E.clone(U,V),U=E.unpack(o,x,U),J+=E.distance(V,U),x+=3;var oe;x=3;var $=0,re=0,ne=0,le=0,ue=!1,ie=E.unpack(n,0,n9e),ce=E.unpack(o,0,Lme),he=E.unpack(a,0,o9e);if(e){var _e=E.unpack(n,n.length-6,i9e);Z5e(he,_e,ie,ce)&&(he=E.negate(he,he))}var Ae=0,be=0,pe=0;for(h=0;h<v;h++){var ge=E.clone(ie,i9e),Te=E.clone(ce,r9e),Pe=E.clone(he,kFt);ue&&(Pe=E.negate(Pe,Pe)),ie=E.unpack(n,x,n9e),ce=E.unpack(o,x,Lme),he=E.unpack(a,x,o9e),ue=Z5e(he,ge,ie,ce),I.latitude=s[$],I.longitude=s[$+1],F.latitude=s[$+2],F.longitude=s[$+3];var ye,ve,we,Be;if(l){var Fe=VFt(I,F);ye=r.project(I,YFt),ve=r.project(F,QFt);var ke=y1(ve,ye,s9e);ke.y=Math.abs(ke.y),we=Ome,Be=Fme,Fe===0||E.dot(ke,E.UNIT_Y)>c9e?(we=ZH(r,I,Pe,ye,Ome),Be=ZH(r,F,he,ve,Fme)):Fe===1?(Be=ZH(r,F,he,ve,Fme),we.x=0,we.y=K.sign(I.longitude-Math.abs(F.longitude)),we.z=0):(we=ZH(r,I,Pe,ye,Ome),Be.x=0,Be.y=K.sign(I.longitude-F.longitude),Be.z=0)}var Ge=E.distance(Te,ce),je=Pn.fromCartesian(ge,eNt),lt=E.subtract(ie,ge,XFt),ct=E.normalize(lt,a9e),Bt=E.subtract(Te,ge,KFt);Bt=E.normalize(Bt,Bt);var Dt=E.cross(ct,Bt,a9e);Dt=E.normalize(Dt,Dt);var Rt=E.cross(Bt,Pe,JFt);Rt=E.normalize(Rt,Rt);var kt=E.subtract(ce,ie,ZFt);kt=E.normalize(kt,kt);var sr=E.cross(he,kt,$Ft);sr=E.normalize(sr,sr);var Cr=Ge/J,pr=Ae/J,Ur=0,Lr,dr,Lt,qt=0,tt=0;if(l){Ur=E.distance(ye,ve),Lr=Pn.fromCartesian(ye,tNt),dr=E.subtract(ve,ye,s9e),Lt=E.normalize(dr,rNt);var at=Lt.x;Lt.x=Lt.y,Lt.y=-at,qt=Ur/q,tt=be/q}for(oe=0;oe<8;oe++){var vt=le+oe*4,ft=re+oe*2,St=vt+3,Zt=oe<4?1:-1,Le=oe===2||oe===3||oe===6||oe===7?1:-1;E.pack(je.high,P,vt),P[St]=lt.x,E.pack(je.low,M,vt),M[St]=lt.y,E.pack(Rt,L,vt),L[St]=lt.z,E.pack(sr,R,vt),R[St]=Cr*Zt,E.pack(Dt,O,vt);var Qe=pr*Le;Qe===0&&Le<0&&(Qe=Number.POSITIVE_INFINITY),O[St]=Qe,l&&(N[vt]=Lr.high.x,N[vt+1]=Lr.high.y,N[vt+2]=Lr.low.x,N[vt+3]=Lr.low.y,z[vt]=-we.y,z[vt+1]=we.x,z[vt+2]=Be.y,z[vt+3]=-Be.x,k[vt]=dr.x,k[vt+1]=dr.y,k[vt+2]=Lt.x,k[vt+3]=Lt.y,W[ft]=qt*Zt,Qe=tt*Le,Qe===0&&Le<0&&(Qe=Number.POSITIVE_INFINITY),W[ft+1]=Qe)}var me=qFt,it=jFt,Ot=HFt,rt=WFt,$t=He.fromCartographicArray(UFt,GFt),Tt=Zs.getMinimumMaximumHeights($t,m),yr=Tt.minimumTerrainHeight,xt=Tt.maximumTerrainHeight;pe+=yr,pe+=xt,t9e(ge,Te,yr,xt,me,Ot),t9e(ie,ce,yr,xt,it,rt);var ht=E.multiplyByScalar(Dt,K.EPSILON5,l9e);E.add(me,ht,me),E.add(it,ht,it),E.add(Ot,ht,Ot),E.add(rt,ht,rt),CX(me,it),CX(Ot,rt),E.pack(me,S,ne),E.pack(it,S,ne+3),E.pack(rt,S,ne+6),E.pack(Ot,S,ne+9),ht=E.multiplyByScalar(Dt,-2*K.EPSILON5,l9e),E.add(me,ht,me),E.add(it,ht,it),E.add(Ot,ht,Ot),E.add(rt,ht,rt),CX(me,it),CX(Ot,rt),E.pack(me,S,ne+12),E.pack(it,S,ne+15),E.pack(rt,S,ne+18),E.pack(Ot,S,ne+21),$+=2,x+=3,re+=16,ne+=24,le+=32,Ae+=Ge,be+=Ur}x=0;var kr=0;for(h=0;h<v;h++){for(oe=0;oe<u9e;oe++)w[x+oe]=p9e[oe]+kr;kr+=8,x+=u9e}var Mr=iNt;Ue.fromVertices(n,E.ZERO,3,Mr[0]),Ue.fromVertices(o,E.ZERO,3,Mr[1]);var At=Ue.fromBoundingSpheres(Mr);At.radius+=pe/(v*2);var Ai={position:new wr({componentDatatype:Ie.DOUBLE,componentsPerAttribute:3,normalize:!1,values:S}),startHiAndForwardOffsetX:YS(P),startLoAndForwardOffsetY:YS(M),startNormalAndForwardOffsetZ:YS(L),endNormalAndTextureCoordinateNormalizationX:YS(R),rightNormalAndTextureCoordinateNormalizationY:YS(O)};return l&&(Ai.startHiLo2D=YS(N),Ai.offsetAndRight2D=YS(k),Ai.startEndNormals2D=YS(z),Ai.texcoordNormalization2D=new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:2,normalize:!1,values:W})),new Ei({attributes:Ai,indices:w,boundingSphere:At})}function YS(e){return new wr({componentDatatype:Ie.FLOAT,componentsPerAttribute:4,normalize:!1,values:e})}var zme,vFt,c9e,q5e,f9e,x9e,gFt,j5e,Y5e,_Ft,yFt,AFt,CFt,Bme,TFt,wFt,EFt,h9e,bFt,SFt,TX,IFt,PFt,DFt,MFt,BFt,yX,AX,X5e,K5e,RFt,LFt,OFt,J5e,FFt,$5e,NFt,e9e,zFt,d9e,m9e,r9e,Lme,i9e,n9e,kFt,o9e,UFt,GFt,HFt,WFt,qFt,jFt,YFt,QFt,Ome,Fme,XFt,KFt,ZFt,a9e,JFt,$Ft,eNt,tNt,s9e,rNt,l9e,iNt,p9e,u9e,XS,JH=Ee(()=>{$2();kp();K2();hi();bt();Si();cr();mi();Ze();De();st();Ii();VF();oN();Ax();iu();gs();_s();jf();nr();to();K0();Ja();Ni();Yf();zme=[yo,fo],vFt=zme.length,c9e=Math.cos(K.toRadians(30)),q5e=Math.cos(K.toRadians(150)),f9e=0,x9e=1e3;y(QS,"GroundPolylineGeometry");Object.defineProperties(QS.prototype,{packedLength:{get:function(){return 1+this._positions.length*3+1+1+1+nt.packedLength+1+1}}});QS.setProjectionAndEllipsoid=function(e,r){for(var n=0,o=0;o<vFt;o++)if(r instanceof zme[o]){n=o;break}e._projectionIndex=n,e._ellipsoid=r.ellipsoid};gFt=new E,j5e=new E,Y5e=new E;y(Nme,"computeRightNormal");_Ft=new qe,yFt=new E,AFt=new E,CFt=new E;y(Mme,"interpolateSegment");Bme=new qe;y(Sm,"getPosition");QS.pack=function(e,r,n){X.typeOf.object("value",e),X.defined("array",r);var o=B(n,0),a=e._positions,s=a.length;r[o++]=s;for(var l=0;l<s;++l){var h=a[l];E.pack(h,r,o),o+=3}return r[o++]=e.granularity,r[o++]=e.loop?1:0,r[o++]=e.arcType,nt.pack(e._ellipsoid,r,o),o+=nt.packedLength,r[o++]=e._projectionIndex,r[o++]=e._scene3DOnly?1:0,r};QS.unpack=function(e,r,n){X.defined("array",e);for(var o=B(r,0),a=e[o++],s=new Array(a),l=0;l<a;l++)s[l]=E.unpack(e,o),o+=3;var h=e[o++],x=e[o++]===1,m=e[o++],v=nt.unpack(e,o);o+=nt.packedLength;var _=e[o++],A=e[o++]===1;if(!p(n)){var T=new QS({positions:s,granularity:h,loop:x,arcType:m,ellipsoid:v});return T._projectionIndex=_,T._scene3DOnly=A,T}return n._positions=s,n.granularity=h,n.loop=x,n.arcType=m,n._ellipsoid=v,n._projectionIndex=_,n._scene3DOnly=A,n};y(y1,"direction");y(Q5e,"tangentDirection");TFt=new E,wFt=new E,EFt=new E,h9e=new E,bFt=0,SFt=-1;y(Rme,"computeVertexMiterNormal");TX=pn.fromPointNormal(E.ZERO,E.UNIT_Y),IFt=new E,PFt=new E,DFt=new E,MFt=new E,BFt=new E,yX=new E,AX=new qe,X5e=new qe,K5e=new qe;QS.createGeometry=function(e){var r=!e._scene3DOnly,n=e.loop,o=e._ellipsoid,a=e.granularity,s=e.arcType,l=new zme[e._projectionIndex](o),h=f9e,x=x9e,m,v,_=e._positions,A=_.length;A===2&&(n=!1);var T,w,S,P,M=new Em(void 0,void 0,o),L,R,O,N=[_[0]];for(v=0;v<A-1;v++)T=_[v],w=_[v+1],L=Yn.lineSegmentPlane(T,w,TX,yX),p(L)&&!E.equalsEpsilon(L,T,K.EPSILON7)&&!E.equalsEpsilon(L,w,K.EPSILON7)&&(e.arcType===vn.GEODESIC?N.push(E.clone(L)):e.arcType===vn.RHUMB&&(O=o.cartesianToCartographic(L,AX).longitude,S=o.cartesianToCartographic(T,AX),P=o.cartesianToCartographic(w,X5e),M.setEndPoints(S,P),R=M.findIntersectionWithLongitude(O,K5e),L=o.cartographicToCartesian(R,yX),p(L)&&!E.equalsEpsilon(L,T,K.EPSILON7)&&!E.equalsEpsilon(L,w,K.EPSILON7)&&N.push(E.clone(L)))),N.push(w);n&&(T=_[A-1],w=_[0],L=Yn.lineSegmentPlane(T,w,TX,yX),p(L)&&!E.equalsEpsilon(L,T,K.EPSILON7)&&!E.equalsEpsilon(L,w,K.EPSILON7)&&(e.arcType===vn.GEODESIC?N.push(E.clone(L)):e.arcType===vn.RHUMB&&(O=o.cartesianToCartographic(L,AX).longitude,S=o.cartesianToCartographic(T,AX),P=o.cartesianToCartographic(w,X5e),M.setEndPoints(S,P),R=M.findIntersectionWithLongitude(O,K5e),L=o.cartographicToCartesian(R,yX),p(L)&&!E.equalsEpsilon(L,T,K.EPSILON7)&&!E.equalsEpsilon(L,w,K.EPSILON7)&&N.push(E.clone(L)))));var k=N.length,z=new Array(k);for(v=0;v<k;v++){var W=qe.fromCartesian(N[v],o);W.height=0,z[v]=W}if(z=vu(z,qe.equalsEpsilon),k=z.length,!(k<2)){var j=[],q=[],I=[],F=[],V=IFt,U=PFt,Q=DFt,J=MFt,oe=BFt,$=z[0],re=z[1],ne=z[k-1];for(V=Sm(o,ne,h,V),J=Sm(o,re,h,J),U=Sm(o,$,h,U),Q=Sm(o,$,x,Q),n?oe=Rme(V,U,Q,J,oe):oe=Nme($,re,x,o,oe),E.pack(oe,q,0),E.pack(U,I,0),E.pack(Q,F,0),j.push($.latitude),j.push($.longitude),Mme($,re,h,x,a,s,o,q,I,F,j),v=1;v<k-1;++v){V=E.clone(U,V),U=E.clone(J,U);var le=z[v];Sm(o,le,x,Q),Sm(o,z[v+1],h,J),Rme(V,U,Q,J,oe),m=q.length,E.pack(oe,q,m),E.pack(U,I,m),E.pack(Q,F,m),j.push(le.latitude),j.push(le.longitude),Mme(z[v],z[v+1],h,x,a,s,o,q,I,F,j)}var ue=z[k-1],ie=z[k-2];if(U=Sm(o,ue,h,U),Q=Sm(o,ue,x,Q),n){var ce=z[0];V=Sm(o,ie,h,V),J=Sm(o,ce,h,J),oe=Rme(V,U,Q,J,oe)}else oe=Nme(ie,ue,x,o,oe);if(m=q.length,E.pack(oe,q,m),E.pack(U,I,m),E.pack(Q,F,m),j.push(ue.latitude),j.push(ue.longitude),n){for(Mme(ue,$,h,x,a,s,o,q,I,F,j),m=q.length,v=0;v<3;++v)q[m+v]=q[v],I[m+v]=I[v],F[m+v]=F[v];j.push($.latitude),j.push($.longitude)}return nNt(n,l,I,F,q,j,r)}};RFt=new E,LFt=new We,OFt=new hr;y(Z5e,"breakMiter");J5e=new qe,FFt=new E,$5e=new E;y(ZH,"projectNormal");NFt=new E,e9e=new E;y(t9e,"adjustHeights");zFt=new E;y(CX,"nudgeXZ");y(VFt,"nudgeCartographic");d9e=new qe,m9e=new qe,r9e=new E,Lme=new E,i9e=new E,n9e=new E,kFt=new E,o9e=new E,UFt=[d9e,m9e],GFt=new He,HFt=new E,WFt=new E,qFt=new E,jFt=new E,YFt=new E,QFt=new E,Ome=new E,Fme=new E,XFt=new E,KFt=new E,ZFt=new E,a9e=new E,JFt=new E,$Ft=new E,eNt=new Pn,tNt=new Pn,s9e=new E,rNt=new E,l9e=new E,iNt=[new Ue,new Ue],p9e=[0,2,1,0,3,2,0,7,3,0,4,7,0,5,4,0,1,5,5,7,4,5,6,7,5,2,6,5,1,2,3,6,2,3,7,6],u9e=p9e.length;y(nNt,"generateGeometryAttributes");y(YS,"getVec4GeometryAttribute");QS._projectNormal=ZH;XS=QS});function oNt(e){if(e=B(e,B.EMPTY_OBJECT),!p(e.componentDatatype))throw new G("options.componentDatatype is required.");if(!p(e.componentsPerAttribute))throw new G("options.componentsPerAttribute is required.");if(e.componentsPerAttribute<1||e.componentsPerAttribute>4)throw new G("options.componentsPerAttribute must be between 1 and 4.");if(!p(e.value))throw new G("options.value is required.");this.componentDatatype=e.componentDatatype,this.componentsPerAttribute=e.componentsPerAttribute,this.normalize=B(e.normalize,!1),this.value=e.value}var Xf,$H=Ee(()=>{Ze();De();st();y(oNt,"GeometryInstanceAttribute");Xf=oNt});var v9e,g9e=Ee(()=>{v9e=`#ifdef GL_EXT_frag_depth
#extension GL_EXT_frag_depth : enable
#endif

varying vec4 v_startPlaneNormalEcAndHalfWidth;
varying vec4 v_endPlaneNormalEcAndBatchId;
varying vec4 v_rightPlaneEC; // Technically can compute distance for this here
varying vec4 v_endEcAndStartEcX;
varying vec4 v_texcoordNormalizationAndStartEcYZ;

#ifdef PER_INSTANCE_COLOR
varying vec4 v_color;
#endif

void main(void)
{
    float logDepthOrDepth = czm_branchFreeTernary(czm_sceneMode == czm_sceneMode2D, gl_FragCoord.z, czm_unpackDepth(texture2D(czm_globeDepthTexture, gl_FragCoord.xy / czm_globeDepthTextureDim.xy)));
    vec3 ecStart = vec3(v_endEcAndStartEcX.w, v_texcoordNormalizationAndStartEcYZ.zw);

    // Discard for sky
    if (logDepthOrDepth == 0.0) {
#ifdef DEBUG_SHOW_VOLUME
        gl_FragColor = vec4(1.0, 0.0, 0.0, 0.5);
        return;
#else // DEBUG_SHOW_VOLUME
        discard;
#endif // DEBUG_SHOW_VOLUME
    }

    vec4 eyeCoordinate = czm_windowToEyeCoordinates(gl_FragCoord.xy, logDepthOrDepth);
    eyeCoordinate /= eyeCoordinate.w;

    float halfMaxWidth = v_startPlaneNormalEcAndHalfWidth.w * czm_metersPerPixel(eyeCoordinate);
    // Check distance of the eye coordinate against the right-facing plane
    float widthwiseDistance = czm_planeDistance(v_rightPlaneEC, eyeCoordinate.xyz);

    // Check eye coordinate against the mitering planes
    float distanceFromStart = czm_planeDistance(v_startPlaneNormalEcAndHalfWidth.xyz, -dot(ecStart, v_startPlaneNormalEcAndHalfWidth.xyz), eyeCoordinate.xyz);
    float distanceFromEnd = czm_planeDistance(v_endPlaneNormalEcAndBatchId.xyz, -dot(v_endEcAndStartEcX.xyz, v_endPlaneNormalEcAndBatchId.xyz), eyeCoordinate.xyz);

    if (abs(widthwiseDistance) > halfMaxWidth || distanceFromStart < 0.0 || distanceFromEnd < 0.0) {
#ifdef DEBUG_SHOW_VOLUME
        gl_FragColor = vec4(1.0, 0.0, 0.0, 0.5);
        return;
#else // DEBUG_SHOW_VOLUME
        discard;
#endif // DEBUG_SHOW_VOLUME
    }

    // Check distance of the eye coordinate against start and end planes with normals in the right plane.
    // For computing unskewed lengthwise texture coordinate.
    // Can also be used for clipping extremely pointy miters, but in practice unnecessary because of miter breaking.

    // aligned plane: cross the right plane normal with miter plane normal, then cross the result with right again to point it more "forward"
    vec3 alignedPlaneNormal;

    // start aligned plane
    alignedPlaneNormal = cross(v_rightPlaneEC.xyz, v_startPlaneNormalEcAndHalfWidth.xyz);
    alignedPlaneNormal = normalize(cross(alignedPlaneNormal, v_rightPlaneEC.xyz));
    distanceFromStart = czm_planeDistance(alignedPlaneNormal, -dot(alignedPlaneNormal, ecStart), eyeCoordinate.xyz);

    // end aligned plane
    alignedPlaneNormal = cross(v_rightPlaneEC.xyz, v_endPlaneNormalEcAndBatchId.xyz);
    alignedPlaneNormal = normalize(cross(alignedPlaneNormal, v_rightPlaneEC.xyz));
    distanceFromEnd = czm_planeDistance(alignedPlaneNormal, -dot(alignedPlaneNormal, v_endEcAndStartEcX.xyz), eyeCoordinate.xyz);

#ifdef PER_INSTANCE_COLOR
    gl_FragColor = czm_gammaCorrect(v_color);
#else // PER_INSTANCE_COLOR
    // Clamp - distance to aligned planes may be negative due to mitering,
    // so fragment texture coordinate might be out-of-bounds.
    float s = clamp(distanceFromStart / (distanceFromStart + distanceFromEnd), 0.0, 1.0);
    s = (s * v_texcoordNormalizationAndStartEcYZ.x) + v_texcoordNormalizationAndStartEcYZ.y;
    float t = (widthwiseDistance + halfMaxWidth) / (2.0 * halfMaxWidth);

    czm_materialInput materialInput;

    materialInput.s = s;
    materialInput.st = vec2(s, t);
    materialInput.str = vec3(s, t, 0.0);

    czm_material material = czm_getMaterial(materialInput);
    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);
#endif // PER_INSTANCE_COLOR

    czm_writeDepthClampedToFarPlane();
}
`});var _9e,y9e=Ee(()=>{_9e=`varying vec3 v_forwardDirectionEC;
varying vec3 v_texcoordNormalizationAndHalfWidth;
varying float v_batchId;

#ifdef PER_INSTANCE_COLOR
varying vec4 v_color;
#else
varying vec2 v_alignedPlaneDistances;
varying float v_texcoordT;
#endif

float rayPlaneDistanceUnsafe(vec3 origin, vec3 direction, vec3 planeNormal, float planeDistance) {
    // We don't expect the ray to ever be parallel to the plane
    return (-planeDistance - dot(planeNormal, origin)) / dot(planeNormal, direction);
}

void main(void)
{
    vec4 eyeCoordinate = gl_FragCoord;
    eyeCoordinate /= eyeCoordinate.w;

#ifdef PER_INSTANCE_COLOR
    gl_FragColor = czm_gammaCorrect(v_color);
#else // PER_INSTANCE_COLOR
    // Use distances for planes aligned with segment to prevent skew in dashing
    float distanceFromStart = rayPlaneDistanceUnsafe(eyeCoordinate.xyz, -v_forwardDirectionEC, v_forwardDirectionEC.xyz, v_alignedPlaneDistances.x);
    float distanceFromEnd = rayPlaneDistanceUnsafe(eyeCoordinate.xyz, v_forwardDirectionEC, -v_forwardDirectionEC.xyz, v_alignedPlaneDistances.y);

    // Clamp - distance to aligned planes may be negative due to mitering
    distanceFromStart = max(0.0, distanceFromStart);
    distanceFromEnd = max(0.0, distanceFromEnd);

    float s = distanceFromStart / (distanceFromStart + distanceFromEnd);
    s = (s * v_texcoordNormalizationAndHalfWidth.x) + v_texcoordNormalizationAndHalfWidth.y;

    czm_materialInput materialInput;

    materialInput.s = s;
    materialInput.st = vec2(s, v_texcoordT);
    materialInput.str = vec3(s, v_texcoordT, 0.0);

    czm_material material = czm_getMaterial(materialInput);
    gl_FragColor = vec4(material.diffuse + material.emission, material.alpha);
#endif // PER_INSTANCE_COLOR
}
`});var A9e,C9e=Ee(()=>{A9e=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;

attribute vec4 startHiAndForwardOffsetX;
attribute vec4 startLoAndForwardOffsetY;
attribute vec4 startNormalAndForwardOffsetZ;
attribute vec4 endNormalAndTextureCoordinateNormalizationX;
attribute vec4 rightNormalAndTextureCoordinateNormalizationY;
attribute vec4 startHiLo2D;
attribute vec4 offsetAndRight2D;
attribute vec4 startEndNormals2D;
attribute vec2 texcoordNormalization2D;

attribute float batchId;

varying vec3 v_forwardDirectionEC;
varying vec3 v_texcoordNormalizationAndHalfWidth;
varying float v_batchId;

// For materials
#ifdef WIDTH_VARYING
varying float v_width;
#endif
#ifdef ANGLE_VARYING
varying float v_polylineAngle;
#endif

#ifdef PER_INSTANCE_COLOR
varying vec4 v_color;
#else
varying vec2 v_alignedPlaneDistances;
varying float v_texcoordT;
#endif

// Morphing planes using SLERP or NLERP doesn't seem to work, so instead draw the material directly on the shadow volume.
// Morph views are from very far away and aren't meant to be used precisely, so this should be sufficient.
void main()
{
    v_batchId = batchId;

    // Start position
    vec4 posRelativeToEye2D = czm_translateRelativeToEye(vec3(0.0, startHiLo2D.xy), vec3(0.0, startHiLo2D.zw));
    vec4 posRelativeToEye3D = czm_translateRelativeToEye(startHiAndForwardOffsetX.xyz, startLoAndForwardOffsetY.xyz);
    vec4 posRelativeToEye = czm_columbusViewMorph(posRelativeToEye2D, posRelativeToEye3D, czm_morphTime);
    vec3 posEc2D = (czm_modelViewRelativeToEye * posRelativeToEye2D).xyz;
    vec3 posEc3D = (czm_modelViewRelativeToEye * posRelativeToEye3D).xyz;
    vec3 startEC = (czm_modelViewRelativeToEye * posRelativeToEye).xyz;

    // Start plane
    vec4 startPlane2D;
    vec4 startPlane3D;
    startPlane2D.xyz = czm_normal * vec3(0.0, startEndNormals2D.xy);
    startPlane3D.xyz = czm_normal * startNormalAndForwardOffsetZ.xyz;
    startPlane2D.w = -dot(startPlane2D.xyz, posEc2D);
    startPlane3D.w = -dot(startPlane3D.xyz, posEc3D);

    // Right plane
    vec4 rightPlane2D;
    vec4 rightPlane3D;
    rightPlane2D.xyz = czm_normal * vec3(0.0, offsetAndRight2D.zw);
    rightPlane3D.xyz = czm_normal * rightNormalAndTextureCoordinateNormalizationY.xyz;
    rightPlane2D.w = -dot(rightPlane2D.xyz, posEc2D);
    rightPlane3D.w = -dot(rightPlane3D.xyz, posEc3D);

    // End position
    posRelativeToEye2D = posRelativeToEye2D + vec4(0.0, offsetAndRight2D.xy, 0.0);
    posRelativeToEye3D = posRelativeToEye3D + vec4(startHiAndForwardOffsetX.w, startLoAndForwardOffsetY.w, startNormalAndForwardOffsetZ.w, 0.0);
    posRelativeToEye = czm_columbusViewMorph(posRelativeToEye2D, posRelativeToEye3D, czm_morphTime);
    posEc2D = (czm_modelViewRelativeToEye * posRelativeToEye2D).xyz;
    posEc3D = (czm_modelViewRelativeToEye * posRelativeToEye3D).xyz;
    vec3 endEC = (czm_modelViewRelativeToEye * posRelativeToEye).xyz;
    vec3 forwardEc3D = czm_normal * normalize(vec3(startHiAndForwardOffsetX.w, startLoAndForwardOffsetY.w, startNormalAndForwardOffsetZ.w));
    vec3 forwardEc2D = czm_normal * normalize(vec3(0.0, offsetAndRight2D.xy));

    // End plane
    vec4 endPlane2D;
    vec4 endPlane3D;
    endPlane2D.xyz = czm_normal * vec3(0.0, startEndNormals2D.zw);
    endPlane3D.xyz = czm_normal * endNormalAndTextureCoordinateNormalizationX.xyz;
    endPlane2D.w = -dot(endPlane2D.xyz, posEc2D);
    endPlane3D.w = -dot(endPlane3D.xyz, posEc3D);

    // Forward direction
    v_forwardDirectionEC = normalize(endEC - startEC);

    vec2 cleanTexcoordNormalization2D;
    cleanTexcoordNormalization2D.x = abs(texcoordNormalization2D.x);
    cleanTexcoordNormalization2D.y = czm_branchFreeTernary(texcoordNormalization2D.y > 1.0, 0.0, abs(texcoordNormalization2D.y));
    vec2 cleanTexcoordNormalization3D;
    cleanTexcoordNormalization3D.x = abs(endNormalAndTextureCoordinateNormalizationX.w);
    cleanTexcoordNormalization3D.y = rightNormalAndTextureCoordinateNormalizationY.w;
    cleanTexcoordNormalization3D.y = czm_branchFreeTernary(cleanTexcoordNormalization3D.y > 1.0, 0.0, abs(cleanTexcoordNormalization3D.y));

    v_texcoordNormalizationAndHalfWidth.xy = mix(cleanTexcoordNormalization2D, cleanTexcoordNormalization3D, czm_morphTime);

#ifdef PER_INSTANCE_COLOR
    v_color = czm_batchTable_color(batchId);
#else // PER_INSTANCE_COLOR
    // For computing texture coordinates

    v_alignedPlaneDistances.x = -dot(v_forwardDirectionEC, startEC);
    v_alignedPlaneDistances.y = -dot(-v_forwardDirectionEC, endEC);
#endif // PER_INSTANCE_COLOR

#ifdef WIDTH_VARYING
    float width = czm_batchTable_width(batchId);
    float halfWidth = width * 0.5;
    v_width = width;
    v_texcoordNormalizationAndHalfWidth.z = halfWidth;
#else
    float halfWidth = 0.5 * czm_batchTable_width(batchId);
    v_texcoordNormalizationAndHalfWidth.z = halfWidth;
#endif

    // Compute a normal along which to "push" the position out, extending the miter depending on view distance.
    // Position has already been "pushed" by unit length along miter normal, and miter normals are encoded in the planes.
    // Decode the normal to use at this specific vertex, push the position back, and then push to where it needs to be.
    // Since this is morphing, compute both 3D and 2D positions and then blend.

    // ****** 3D ******
    // Check distance to the end plane and start plane, pick the plane that is closer
    vec4 positionEc3D = czm_modelViewRelativeToEye * czm_translateRelativeToEye(position3DHigh, position3DLow); // w = 1.0, see czm_computePosition
    float absStartPlaneDistance = abs(czm_planeDistance(startPlane3D, positionEc3D.xyz));
    float absEndPlaneDistance = abs(czm_planeDistance(endPlane3D, positionEc3D.xyz));
    vec3 planeDirection = czm_branchFreeTernary(absStartPlaneDistance < absEndPlaneDistance, startPlane3D.xyz, endPlane3D.xyz);
    vec3 upOrDown = normalize(cross(rightPlane3D.xyz, planeDirection)); // Points "up" for start plane, "down" at end plane.
    vec3 normalEC = normalize(cross(planeDirection, upOrDown));         // In practice, the opposite seems to work too.

    // Nudge the top vertex upwards to prevent flickering
    vec3 geodeticSurfaceNormal = normalize(cross(normalEC, forwardEc3D));
    geodeticSurfaceNormal *= float(0.0 <= rightNormalAndTextureCoordinateNormalizationY.w && rightNormalAndTextureCoordinateNormalizationY.w <= 1.0);
    geodeticSurfaceNormal *= MAX_TERRAIN_HEIGHT;
    positionEc3D.xyz += geodeticSurfaceNormal;

    // Determine if this vertex is on the "left" or "right"
    normalEC *= sign(endNormalAndTextureCoordinateNormalizationX.w);

    // A "perfect" implementation would push along normals according to the angle against forward.
    // In practice, just pushing the normal out by halfWidth is sufficient for morph views.
    positionEc3D.xyz += halfWidth * max(0.0, czm_metersPerPixel(positionEc3D)) * normalEC; // prevent artifacts when czm_metersPerPixel is negative (behind camera)

    // ****** 2D ******
    // Check distance to the end plane and start plane, pick the plane that is closer
    vec4 positionEc2D = czm_modelViewRelativeToEye * czm_translateRelativeToEye(position2DHigh.zxy, position2DLow.zxy); // w = 1.0, see czm_computePosition
    absStartPlaneDistance = abs(czm_planeDistance(startPlane2D, positionEc2D.xyz));
    absEndPlaneDistance = abs(czm_planeDistance(endPlane2D, positionEc2D.xyz));
    planeDirection = czm_branchFreeTernary(absStartPlaneDistance < absEndPlaneDistance, startPlane2D.xyz, endPlane2D.xyz);
    upOrDown = normalize(cross(rightPlane2D.xyz, planeDirection)); // Points "up" for start plane, "down" at end plane.
    normalEC = normalize(cross(planeDirection, upOrDown));         // In practice, the opposite seems to work too.

    // Nudge the top vertex upwards to prevent flickering
    geodeticSurfaceNormal = normalize(cross(normalEC, forwardEc2D));
    geodeticSurfaceNormal *= float(0.0 <= texcoordNormalization2D.y && texcoordNormalization2D.y <= 1.0);
    geodeticSurfaceNormal *= MAX_TERRAIN_HEIGHT;
    positionEc2D.xyz += geodeticSurfaceNormal;

    // Determine if this vertex is on the "left" or "right"
    normalEC *= sign(texcoordNormalization2D.x);
#ifndef PER_INSTANCE_COLOR
    // Use vertex's sidedness to compute its texture coordinate.
    v_texcoordT = clamp(sign(texcoordNormalization2D.x), 0.0, 1.0);
#endif

    // A "perfect" implementation would push along normals according to the angle against forward.
    // In practice, just pushing the normal out by halfWidth is sufficient for morph views.
    positionEc2D.xyz += halfWidth * max(0.0, czm_metersPerPixel(positionEc2D)) * normalEC; // prevent artifacts when czm_metersPerPixel is negative (behind camera)

    // Blend for actual position
    gl_Position = czm_projection * mix(positionEc2D, positionEc3D, czm_morphTime);

#ifdef ANGLE_VARYING
    // Approximate relative screen space direction of the line.
    vec2 approxLineDirection = normalize(vec2(v_forwardDirectionEC.x, -v_forwardDirectionEC.y));
    approxLineDirection.y = czm_branchFreeTernary(approxLineDirection.x == 0.0 && approxLineDirection.y == 0.0, -1.0, approxLineDirection.y);
    v_polylineAngle = czm_fastApproximateAtan(approxLineDirection.x, approxLineDirection.y);
#endif
}
`});var T9e,w9e=Ee(()=>{T9e=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;

// In 2D and in 3D, texture coordinate normalization component signs encodes:
// * X sign - sidedness relative to right plane
// * Y sign - is negative OR magnitude is greater than 1.0 if vertex is on bottom of volume
#ifndef COLUMBUS_VIEW_2D
attribute vec4 startHiAndForwardOffsetX;
attribute vec4 startLoAndForwardOffsetY;
attribute vec4 startNormalAndForwardOffsetZ;
attribute vec4 endNormalAndTextureCoordinateNormalizationX;
attribute vec4 rightNormalAndTextureCoordinateNormalizationY;
#else
attribute vec4 startHiLo2D;
attribute vec4 offsetAndRight2D;
attribute vec4 startEndNormals2D;
attribute vec2 texcoordNormalization2D;
#endif

attribute float batchId;

varying vec4 v_startPlaneNormalEcAndHalfWidth;
varying vec4 v_endPlaneNormalEcAndBatchId;
varying vec4 v_rightPlaneEC;
varying vec4 v_endEcAndStartEcX;
varying vec4 v_texcoordNormalizationAndStartEcYZ;

// For materials
#ifdef WIDTH_VARYING
varying float v_width;
#endif
#ifdef ANGLE_VARYING
varying float v_polylineAngle;
#endif

#ifdef PER_INSTANCE_COLOR
varying vec4 v_color;
#endif

void main()
{
#ifdef COLUMBUS_VIEW_2D
    vec3 ecStart = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(vec3(0.0, startHiLo2D.xy), vec3(0.0, startHiLo2D.zw))).xyz;

    vec3 forwardDirectionEC = czm_normal * vec3(0.0, offsetAndRight2D.xy);
    vec3 ecEnd = forwardDirectionEC + ecStart;
    forwardDirectionEC = normalize(forwardDirectionEC);

    // Right plane
    v_rightPlaneEC.xyz = czm_normal * vec3(0.0, offsetAndRight2D.zw);
    v_rightPlaneEC.w = -dot(v_rightPlaneEC.xyz, ecStart);

    // start plane
    vec4 startPlaneEC;
    startPlaneEC.xyz =  czm_normal * vec3(0.0, startEndNormals2D.xy);
    startPlaneEC.w = -dot(startPlaneEC.xyz, ecStart);

    // end plane
    vec4 endPlaneEC;
    endPlaneEC.xyz =  czm_normal * vec3(0.0, startEndNormals2D.zw);
    endPlaneEC.w = -dot(endPlaneEC.xyz, ecEnd);

    v_texcoordNormalizationAndStartEcYZ.x = abs(texcoordNormalization2D.x);
    v_texcoordNormalizationAndStartEcYZ.y = texcoordNormalization2D.y;

#else // COLUMBUS_VIEW_2D
    vec3 ecStart = (czm_modelViewRelativeToEye * czm_translateRelativeToEye(startHiAndForwardOffsetX.xyz, startLoAndForwardOffsetY.xyz)).xyz;
    vec3 offset = czm_normal * vec3(startHiAndForwardOffsetX.w, startLoAndForwardOffsetY.w, startNormalAndForwardOffsetZ.w);
    vec3 ecEnd = ecStart + offset;

    vec3 forwardDirectionEC = normalize(offset);

    // start plane
    vec4 startPlaneEC;
    startPlaneEC.xyz = czm_normal * startNormalAndForwardOffsetZ.xyz;
    startPlaneEC.w = -dot(startPlaneEC.xyz, ecStart);

    // end plane
    vec4 endPlaneEC;
    endPlaneEC.xyz = czm_normal * endNormalAndTextureCoordinateNormalizationX.xyz;
    endPlaneEC.w = -dot(endPlaneEC.xyz, ecEnd);

    // Right plane
    v_rightPlaneEC.xyz = czm_normal * rightNormalAndTextureCoordinateNormalizationY.xyz;
    v_rightPlaneEC.w = -dot(v_rightPlaneEC.xyz, ecStart);

    v_texcoordNormalizationAndStartEcYZ.x = abs(endNormalAndTextureCoordinateNormalizationX.w);
    v_texcoordNormalizationAndStartEcYZ.y = rightNormalAndTextureCoordinateNormalizationY.w;

#endif // COLUMBUS_VIEW_2D

    v_endEcAndStartEcX.xyz = ecEnd;
    v_endEcAndStartEcX.w = ecStart.x;
    v_texcoordNormalizationAndStartEcYZ.zw = ecStart.yz;

#ifdef PER_INSTANCE_COLOR
    v_color = czm_batchTable_color(batchId);
#endif // PER_INSTANCE_COLOR

    // Compute a normal along which to "push" the position out, extending the miter depending on view distance.
    // Position has already been "pushed" by unit length along miter normal, and miter normals are encoded in the planes.
    // Decode the normal to use at this specific vertex, push the position back, and then push to where it needs to be.
    vec4 positionRelativeToEye = czm_computePosition();

    // Check distance to the end plane and start plane, pick the plane that is closer
    vec4 positionEC = czm_modelViewRelativeToEye * positionRelativeToEye; // w = 1.0, see czm_computePosition
    float absStartPlaneDistance = abs(czm_planeDistance(startPlaneEC, positionEC.xyz));
    float absEndPlaneDistance = abs(czm_planeDistance(endPlaneEC, positionEC.xyz));
    vec3 planeDirection = czm_branchFreeTernary(absStartPlaneDistance < absEndPlaneDistance, startPlaneEC.xyz, endPlaneEC.xyz);
    vec3 upOrDown = normalize(cross(v_rightPlaneEC.xyz, planeDirection)); // Points "up" for start plane, "down" at end plane.
    vec3 normalEC = normalize(cross(planeDirection, upOrDown));           // In practice, the opposite seems to work too.

    // Extrude bottom vertices downward for far view distances, like for GroundPrimitives
    upOrDown = cross(forwardDirectionEC, normalEC);
    upOrDown = float(czm_sceneMode == czm_sceneMode3D) * upOrDown;
    upOrDown = float(v_texcoordNormalizationAndStartEcYZ.y > 1.0 || v_texcoordNormalizationAndStartEcYZ.y < 0.0) * upOrDown;
    upOrDown = min(GLOBE_MINIMUM_ALTITUDE, czm_geometricToleranceOverMeter * length(positionRelativeToEye.xyz)) * upOrDown;
    positionEC.xyz += upOrDown;

    v_texcoordNormalizationAndStartEcYZ.y = czm_branchFreeTernary(v_texcoordNormalizationAndStartEcYZ.y > 1.0, 0.0, abs(v_texcoordNormalizationAndStartEcYZ.y));

    // Determine distance along normalEC to push for a volume of appropriate width.
    // Make volumes about double pixel width for a conservative fit - in practice the
    // extra cost here is minimal compared to the loose volume heights.
    //
    // N = normalEC (guaranteed "right-facing")
    // R = rightEC
    // p = angle between N and R
    // w = distance to push along R if R == N
    // d = distance to push along N
    //
    //   N   R
    //  {  p| }      * cos(p) = dot(N, R) = w / d
    //  d  |  |w    * d = w / dot(N, R)
    //    { | }
    //       o---------- polyline segment ---->
    //
    float width = czm_batchTable_width(batchId);
#ifdef WIDTH_VARYING
    v_width = width;
#endif

    v_startPlaneNormalEcAndHalfWidth.xyz = startPlaneEC.xyz;
    v_startPlaneNormalEcAndHalfWidth.w = width * 0.5;

    v_endPlaneNormalEcAndBatchId.xyz = endPlaneEC.xyz;
    v_endPlaneNormalEcAndBatchId.w = batchId;

    width = width * max(0.0, czm_metersPerPixel(positionEC)); // width = distance to push along R
    width = width / dot(normalEC, v_rightPlaneEC.xyz); // width = distance to push along N

    // Determine if this vertex is on the "left" or "right"
#ifdef COLUMBUS_VIEW_2D
        normalEC *= sign(texcoordNormalization2D.x);
#else
        normalEC *= sign(endNormalAndTextureCoordinateNormalizationX.w);
#endif

    positionEC.xyz += width * normalEC;
    gl_Position = czm_depthClampFarPlane(czm_projection * positionEC);

#ifdef ANGLE_VARYING
    // Approximate relative screen space direction of the line.
    vec2 approxLineDirection = normalize(vec2(forwardDirectionEC.x, -forwardDirectionEC.y));
    approxLineDirection.y = czm_branchFreeTernary(approxLineDirection.x == 0.0 && approxLineDirection.y == 0.0, -1.0, approxLineDirection.y);
    v_polylineAngle = czm_fastApproximateAtan(approxLineDirection.x, approxLineDirection.y);
#endif
}
`});var aNt,Bn,Cx=Ee(()=>{aNt={TERRAIN:0,CESIUM_3D_TILE:1,S3M_TILE:2,BOTH:3,NUMBER_OF_CLASSIFICATION_TYPES:4},Bn=Object.freeze(aNt)});var E9e,b9e=Ee(()=>{E9e=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec3 prevPosition3DHigh;
attribute vec3 prevPosition3DLow;
attribute vec3 nextPosition3DHigh;
attribute vec3 nextPosition3DLow;
attribute vec2 expandAndWidth;
attribute vec4 color;
attribute float batchId;

varying vec4 v_color;

void main()
{
    float expandDir = expandAndWidth.x;
    float width = abs(expandAndWidth.y) + 0.5;
    bool usePrev = expandAndWidth.y < 0.0;

    vec4 p = czm_computePosition();
    vec4 prev = czm_computePrevPosition();
    vec4 next = czm_computeNextPosition();

    float angle;
    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev, angle);
    gl_Position = czm_viewportOrthographic * positionWC;

    v_color = color;
}
`});function uB(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.translucent,!0),n=!1,o=uB.VERTEX_FORMAT;this.material=void 0,this.translucent=r,this._vertexShaderSource=B(e.vertexShaderSource,Vme),this._fragmentShaderSource=B(e.fragmentShaderSource,sNt),this._renderState=Ml.getDefaultRenderState(r,n,e.renderState),this._closed=n,this._vertexFormat=o}var Vme,sNt,Ec,A1=Ee(()=>{Ze();ou();pl();Ede();b9e();WH();zS();Vme=`#define LINEJOIN_BEVEL 
`+HS+`
`+E9e,sNt=OH;Gn.isInternetExplorer()||(Vme=`#define CLIP_POLYLINE 
`+Vme);y(uB,"PolylineColorAppearance");Object.defineProperties(uB.prototype,{vertexShaderSource:{get:function(){return this._vertexShaderSource}},fragmentShaderSource:{get:function(){return this._fragmentShaderSource}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}}});uB.VERTEX_FORMAT=Er.POSITION_ONLY;uB.prototype.getFragmentShaderSource=Ml.prototype.getFragmentShaderSource;uB.prototype.isTranslucent=Ml.prototype.isTranslucent;uB.prototype.getRenderState=Ml.prototype.getRenderState;Ec=uB});var S9e,I9e=Ee(()=>{S9e=`attribute vec3 position3DHigh;
attribute vec3 position3DLow;
attribute vec3 prevPosition3DHigh;
attribute vec3 prevPosition3DLow;
attribute vec3 nextPosition3DHigh;
attribute vec3 nextPosition3DLow;
attribute vec2 expandAndWidth;
attribute vec2 st;
attribute float batchId;

#ifdef TRAIL

uniform float spotSize_2;
attribute vec3 dist;
varying vec3 v_dist;
varying float v_SpotPercent;
#endif
varying float v_width;
varying vec2 v_st;
varying float v_polylineAngle;
varying float v_alpha;

void main()
{
    float u = abs(expandAndWidth.x);
    float expandDir = expandAndWidth.x;
    float width = abs(expandAndWidth.y) + 0.5;
    bool usePrev = expandAndWidth.y < 0.0;

    vec4 p = czm_computePosition();
    vec4 prev = czm_computePrevPosition();
    vec4 next = czm_computeNextPosition();

    float angle;
    vec4 positionWC = getPolylineWindowCoordinates(p, prev, next, expandDir, width, usePrev, angle);
    gl_Position = czm_viewportOrthographic * positionWC;

    v_width = width;
    v_st.s = st.s;
    v_st.t = czm_writeNonPerspective(st.t, gl_Position.w);
    v_polylineAngle = angle;
    v_alpha = u;

#ifdef TRAIL
    float t = 0.0;
    v_dist = dist;
    v_SpotPercent = spotSize_2 / dist.y;
#endif
}
`});function cB(e){e=B(e,B.EMPTY_OBJECT);var r=B(e.translucent,!0),n=!1,o=cB.VERTEX_FORMAT;this.material=p(e.material)?e.material:on.fromType(on.ColorType),this.translucent=r,this._vertexShaderSource=B(e.vertexShaderSource,kme),this._fragmentShaderSource=B(e.fragmentShaderSource,lNt),this._renderState=Ml.getDefaultRenderState(r,n,e.renderState),this._closed=n,this._vertexFormat=o}var kme,lNt,Vh,fB=Ee(()=>{Ze();De();ou();pl();I9e();WH();_me();zS();nh();kme=`#define LINEJOIN_BEVEL 
`+HS+`
`+S9e,lNt=cX;Gn.isInternetExplorer()||(kme=`#define CLIP_POLYLINE 
`+kme);y(cB,"PolylineMaterialAppearance");Object.defineProperties(cB.prototype,{vertexShaderSource:{get:function(){var e=this._vertexShaderSource;return this.material.shaderSource.search(/varying\s+float\s+v_polylineAngle;/g)!==-1&&(e=`#define POLYLINE_DASH
`+e),this.material.type=="PolylineDynamic"&&(e=`#define ENABLE_DYNAMIC
`+e),this.material.type=="PolylineTrail"&&(e=`#define TRAIL
`+e),e}},fragmentShaderSource:{get:function(){var e=this._fragmentShaderSource;return this.material.type=="PolylineDynamic"&&(e=`#define ENABLE_DYNAMIC
`+e),this.material.type=="PolylineTrail"&&(e=`#define TRAIL
`+e),e}},renderState:{get:function(){return this._renderState}},closed:{get:function(){return this._closed}},vertexFormat:{get:function(){return this._vertexFormat}}});cB.VERTEX_FORMAT=Er.POSITION_AND_ST;cB.prototype.getFragmentShaderSource=Ml.prototype.getFragmentShaderSource;cB.prototype.isTranslucent=Ml.prototype.isTranslucent;cB.prototype.getRenderState=Ml.prototype.getRenderState;Vh=cB});var uNt,Fn,Im=Ee(()=>{co();uNt={NEVER:Se.NEVER,LESS:Se.LESS,EQUAL:Se.EQUAL,LESS_OR_EQUAL:Se.LEQUAL,GREATER:Se.GREATER,NOT_EQUAL:Se.NOTEQUAL,GREATER_OR_EQUAL:Se.GEQUAL,ALWAYS:Se.ALWAYS},Fn=Object.freeze(uNt)});var cNt,Pr,Pm=Ee(()=>{co();cNt={ZERO:Se.ZERO,KEEP:Se.KEEP,REPLACE:Se.REPLACE,INCREMENT:Se.INCR,DECREMENT:Se.DECR,INVERT:Se.INVERT,INCREMENT_WRAP:Se.INCR_WRAP,DECREMENT_WRAP:Se.DECR_WRAP},Pr=Object.freeze(cNt)});var wX,xo,Dm=Ee(()=>{Im();Pm();wX={CESIUM_3D_TILE_MASK:128,S3M_TILE:2,MODEL:6,SKIP_LOD_MASK:112,SKIP_LOD_BIT_SHIFT:4,CLASSIFICATION_MASK:15};wX.setCesium3DTileBit=function(){return{enabled:!0,frontFunction:Fn.ALWAYS,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.REPLACE},backFunction:Fn.ALWAYS,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.REPLACE},reference:wX.CESIUM_3D_TILE_MASK,mask:wX.CESIUM_3D_TILE_MASK}};xo=Object.freeze(wX)});function C1(e){e=B(e,B.EMPTY_OBJECT),this.geometryInstances=e.geometryInstances,this._hasPerInstanceColors=!0;var r=e.appearance;p(r)||(r=new Vh),this.appearance=r,this.show=B(e.show,!0),this.classificationType=B(e.classificationType,Bn.BOTH),this.debugShowBoundingVolume=B(e.debugShowBoundingVolume,!1),this._debugShowShadowVolume=B(e.debugShowShadowVolume,!1),this._primitiveOptions={geometryInstances:void 0,appearance:void 0,vertexCacheOptimize:!1,interleave:B(e.interleave,!1),releaseGeometryInstances:B(e.releaseGeometryInstances,!0),allowPicking:B(e.allowPicking,!0),asynchronous:B(e.asynchronous,!0),compressVertices:!1,_createShaderProgramFunction:void 0,_createCommandsFunction:void 0,_updateAndQueueCommandsFunction:void 0},this._zIndex=void 0,this._ready=!1,this._readyPromise=Je.defer(),this._primitive=void 0,this._sp=void 0,this._sp2D=void 0,this._spMorph=void 0,this._renderState=Ume(0),this._renderState3DTiles=Ume(1),this._renderStateS3M=Ume(2),this._renderStateMorph=Et.fromCache({cull:{enabled:!0,face:Du.FRONT},depthTest:{enabled:!0},blending:pi.ALPHA_BLEND,depthMask:!1})}function fNt(e,r,n){var o=r.context,a=e._primitive,s=a._attributeLocations,l=a._batchTable.getVertexShaderCallback()(T9e);l=Mo._appendShowToShader(a,l),l=Mo._appendDistanceDisplayConditionToShader(a,l),l=Mo._modifyShaderPosition(e,l,r.scene3DOnly);var h=a._batchTable.getVertexShaderCallback()(A9e);h=Mo._appendShowToShader(a,h),h=Mo._appendDistanceDisplayConditionToShader(a,h),h=Mo._modifyShaderPosition(e,h,r.scene3DOnly);var x=a._batchTable.getVertexShaderCallback()(v9e),m=["GLOBE_MINIMUM_ALTITUDE "+r.mapProjection.ellipsoid.minimumRadius.toFixed(1)],v="",_="";p(n.material)?(_=p(n.material)?n.material.shaderSource:"",_.search(/varying\s+float\s+v_polylineAngle;/g)!==-1&&m.push("ANGLE_VARYING"),_.search(/varying\s+float\s+v_width;/g)!==-1&&m.push("WIDTH_VARYING")):v="PER_INSTANCE_COLOR",m.push(v);var A=e.debugShowShadowVolume?["DEBUG_SHOW_VOLUME",v]:[v],T=new yt({defines:m,sources:[l]}),w=new yt({defines:A,sources:[_,x]});e._sp=fr.replaceCache({context:o,shaderProgram:a._sp,vertexShaderSource:T,fragmentShaderSource:w,attributeLocations:s});var S=o.shaderCache.getDerivedShaderProgram(e._sp,"2dColor");if(!p(S)){var P=new yt({defines:m.concat(["COLUMBUS_VIEW_2D"]),sources:[l]});S=o.shaderCache.createDerivedShaderProgram(e._sp,"2dColor",{context:o,shaderProgram:e._sp2D,vertexShaderSource:P,fragmentShaderSource:w,attributeLocations:s})}e._sp2D=S;var M=o.shaderCache.getDerivedShaderProgram(e._sp,"MorphColor");if(!p(M)){var L=new yt({defines:m.concat(["MAX_TERRAIN_HEIGHT "+Zs._defaultMaxTerrainHeight.toFixed(1)]),sources:[h]});x=a._batchTable.getVertexShaderCallback()(_9e);var R=new yt({defines:A,sources:[_,x]});M=o.shaderCache.createDerivedShaderProgram(e._sp,"MorphColor",{context:o,shaderProgram:e._spMorph,vertexShaderSource:L,fragmentShaderSource:R,attributeLocations:s})}e._spMorph=M}function Ume(e){return Et.fromCache({cull:{enabled:!0},blending:pi.ALPHA_BLEND,depthMask:!1,stencilTest:{enabled:e>0,frontFunction:Fn.EQUAL,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.KEEP},backFunction:Fn.EQUAL,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.KEEP},reference:e===2?xo.S3M_TILE:xo.CESIUM_3D_TILE_MASK,mask:xo.CLASSIFICATION_MASK}})}function xNt(e,r,n,o,a,s){var l=e._primitive,h=l._va.length;a.length=h,s.length=h;for(var x=r instanceof Ec,m=x?{}:n._uniforms,v=l._batchTable.getUniformMapCallback()(m),_=0;_<h;_++){var A=l._va[_],T=a[_];p(T)||(T=a[_]=new Yt({owner:e,primitiveType:l._primitiveType})),T.vertexArray=A,T.renderState=e._renderState,T.shaderProgram=e._sp,T.uniformMap=v,T.pass=_t.TERRAIN_CLASSIFICATION,T.pickId="czm_batchTable_pickColor(v_endPlaneNormalEcAndBatchId.w)";var w=Yt.shallowClone(T,T.derivedCommands.tileset);w.renderState=e._renderState3DTiles,w.pass=_t.CESIUM_3D_TILE_CLASSIFICATION,T.derivedCommands.tileset=w;var S=Yt.shallowClone(T,T.derivedCommands.S3M);S.renderState=e._renderStateS3M,S.pass=_t.ClampObject,T.derivedCommands.S3M=S;var P=Yt.shallowClone(T,T.derivedCommands.color2D);P.shaderProgram=e._sp2D,T.derivedCommands.color2D=P;var M=Yt.shallowClone(w,w.derivedCommands.color2D);M.shaderProgram=e._sp2D,w.derivedCommands.color2D=M;var L=Yt.shallowClone(S,S.derivedCommands.color2D);L.shaderProgram=e._sp2D,S.derivedCommands.color2D=L;var R=Yt.shallowClone(T,T.derivedCommands.colorMorph);R.renderState=e._renderStateMorph,R.shaderProgram=e._spMorph,R.pickId="czm_batchTable_pickColor(v_batchId)",T.derivedCommands.colorMorph=R}}function Gme(e,r,n,o,a,s,l){n.mode===ze.MORPHING?r=r.derivedCommands.colorMorph:n.mode!==ze.SCENE3D&&(r=r.derivedCommands.color2D),r&&(r.modelMatrix=o,r.boundingVolume=s,r.cull=a,r.debugShowBoundingVolume=l,n.commandList.push(r))}function hNt(e,r,n,o,a,s,l){var h=e._primitive;Mo._updateBoundingVolumes(h,r,a);var x;r.mode===ze.SCENE3D?x=h._boundingSphereWC:r.mode===ze.COLUMBUS_VIEW?x=h._boundingSphereCV:r.mode===ze.SCENE2D&&p(h._boundingSphere2D)?x=h._boundingSphere2D:p(h._boundingSphereMorph)&&(x=h._boundingSphereMorph);var m=r.mode===ze.MORPHING,v=e.classificationType,_=v===Bn.TERRAIN,A=v===Bn.S3M_TILE,T=v===Bn.CESIUM_3D_TILE&&!m;v===Bn.BOTH&&(_=!0,A=!0,T=!0);var w,S=r.passes;if(S.render||S.pick&&h.allowPicking)for(var P=n.length,M=0;M<P;++M){var L=x[M];_&&(w=n[M],Gme(e,w,r,a,s,L,l)),T&&(w=n[M].derivedCommands.tileset,Gme(e,w,r,a,s,L,l)),A&&(w=n[M].derivedCommands.S3M,Gme(e,w,r,a,s,L,l))}}var Sg,xB=Ee(()=>{$2();mi();Ze();De();ur();st();Ks();$H();JH();Kn();Ao();Zi();so();bn();g9e();y9e();C9e();w9e();li();va();Cx();Y2();A1();fB();_f();zi();Dm();Im();Pm();y(C1,"GroundPolylinePrimitive");Object.defineProperties(C1.prototype,{interleave:{get:function(){return this._primitiveOptions.interleave}},releaseGeometryInstances:{get:function(){return this._primitiveOptions.releaseGeometryInstances}},allowPicking:{get:function(){return this._primitiveOptions.allowPicking}},asynchronous:{get:function(){return this._primitiveOptions.asynchronous}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}},debugShowShadowVolume:{get:function(){return this._debugShowShadowVolume}}});C1.initializeTerrainHeights=function(){return Zs.initialize()};y(fNt,"createShaderProgram");y(Ume,"getRenderState");y(xNt,"createCommands");y(Gme,"updateAndQueueCommand");y(hNt,"updateAndQueueCommands");C1.prototype.update=function(e){if(!(!p(this._primitive)&&!p(this.geometryInstances))){if(!Zs.initialized){if(!this.asynchronous)throw new G("For synchronous GroundPolylinePrimitives, you must call GroundPolylinePrimitives.initializeTerrainHeights() and wait for the returned promise to resolve.");C1.initializeTerrainHeights();return}var r,n=this,o=this._primitiveOptions;if(!p(this._primitive)){var a=Array.isArray(this.geometryInstances)?this.geometryInstances:[this.geometryInstances],s=a.length,l=new Array(s),h;for(r=0;r<s;++r)if(h=a[r].attributes,!p(h)||!p(h.color)){this._hasPerInstanceColors=!1;break}for(r=0;r<s;++r){var x=a[r];h={};var m=x.attributes;for(var v in m)m.hasOwnProperty(v)&&(h[v]=m[v]);p(h.width)||(h.width=new Xf({componentDatatype:Ie.UNSIGNED_BYTE,componentsPerAttribute:1,value:[x.geometry.width]})),x.geometry._scene3DOnly=e.scene3DOnly,XS.setProjectionAndEllipsoid(x.geometry,e.mapProjection),l[r]=new Ui({geometry:x.geometry,attributes:h,id:x.id,pickPrimitive:n})}o.geometryInstances=l,o.appearance=this.appearance,o._createShaderProgramFunction=function(_,A,T){fNt(n,A,T)},o._createCommandsFunction=function(_,A,T,w,S,P,M){xNt(n,A,T,w,P,M)},o._updateAndQueueCommandsFunction=function(_,A,T,w,S,P,M,L){hNt(n,A,T,w,S,P,M)},this._primitive=new Mo(o),this._primitive.readyPromise.then(function(_){n._ready=!0,n.releaseGeometryInstances&&(n.geometryInstances=void 0);var A=_._error;p(A)?n._readyPromise.reject(A):n._readyPromise.resolve(n)})}if(this.appearance instanceof Ec&&!this._hasPerInstanceColors)throw new G("All GeometryInstances must have color attributes to use PolylineColorAppearance with GroundPolylinePrimitive.");this._primitive.appearance=this.appearance,this._primitive.show=this.show,this._primitive.debugShowBoundingVolume=this.debugShowBoundingVolume,this._primitive.update(e)}};C1.prototype.getGeometryInstanceAttributes=function(e){if(!p(this._primitive))throw new G("must call update before calling getGeometryInstanceAttributes");return this._primitive.getGeometryInstanceAttributes(e)};C1.isSupported=function(e){return e.frameState.context.depthTexture};C1.prototype.isDestroyed=function(){return!1};C1.prototype.destroy=function(){return this._primitive=this._primitive&&this._primitive.destroy(),this._sp=this._sp&&this._sp.destroy(),this._sp2D=void 0,this._spMorph=void 0,$e(this)};Sg=C1});function sN(e,r){this._callback=void 0,this._isConstant=void 0,this._definitionChanged=new It,this.setCallback(e,r)}var os,Ig=Ee(()=>{De();st();ti();y(sN,"CallbackProperty");Object.defineProperties(sN.prototype,{isConstant:{get:function(){return this._isConstant}},definitionChanged:{get:function(){return this._definitionChanged}}});sN.prototype.getValue=function(e,r){return this._callback(e,r)};sN.prototype.setCallback=function(e,r){if(!p(e))throw new G("callback is required.");if(!p(r))throw new G("isConstant is required.");var n=this._callback!==e||this._isConstant!==r;this._callback=e,this._isConstant=r,n&&this._definitionChanged.raiseEvent(this)};sN.prototype.equals=function(e){return this===e||e instanceof sN&&this._callback===e._callback&&this._isConstant===e._isConstant};os=sN});function e8(e,r){if(e=B(e,0),r=B(r,Number.MAX_VALUE),r<=e)throw new G("far distance must be greater than near distance.");this.value=new Float32Array([e,r])}var fa,yf=Ee(()=>{mi();Ze();De();st();y(e8,"DistanceDisplayConditionGeometryInstanceAttribute");Object.defineProperties(e8.prototype,{componentDatatype:{get:function(){return Ie.FLOAT}},componentsPerAttribute:{get:function(){return 2}},normalize:{get:function(){return!1}}});e8.fromDistanceDisplayCondition=function(e){if(!p(e))throw new G("distanceDisplayCondition is required.");if(e.far<=e.near)throw new G("distanceDisplayCondition.far distance must be greater than distanceDisplayCondition.near distance.");return new e8(e.near,e.far)};e8.toValue=function(e,r){if(!p(e))throw new G("distanceDisplayCondition is required.");return p(r)?(r[0]=e.near,r[1]=e.far,r):new Float32Array([e.near,e.far])};fa=e8});function dNt(e){return Array.isArray(e)&&(e=new ih(e)),new es(e)}function T1(e){this._show=void 0,this._showSubscription=void 0,this._material=void 0,this._materialSubscription=void 0,this._hierarchy=void 0,this._hierarchySubscription=void 0,this._height=void 0,this._heightSubscription=void 0,this._heightReference=void 0,this._heightReferenceSubscription=void 0,this._extrudedHeight=void 0,this._extrudedHeightSubscription=void 0,this._extrudedHeightReference=void 0,this._extrudedHeightReferenceSubscription=void 0,this._granularity=void 0,this._granularitySubscription=void 0,this._stRotation=void 0,this._stRotationSubscription=void 0,this._perPositionHeight=void 0,this._perPositionHeightSubscription=void 0,this._outline=void 0,this._outlineSubscription=void 0,this._outlineColor=void 0,this._outlineColorSubscription=void 0,this._outlineWidth=void 0,this._outlineWidthSubscription=void 0,this._fill=void 0,this._fillSubscription=void 0,this._closeTop=void 0,this._closeTopSubscription=void 0,this._closeBottom=void 0,this._closeBottomSubscription=void 0,this._shadows=void 0,this._shadowsSubscription=void 0,this._distanceDisplayCondition=void 0,this._distanceDisplayConditionSubscription=void 0,this._classificationType=void 0,this._classificationTypeSubscription=void 0,this._arcType=void 0,this._arcTypeSubscription=void 0,this._zIndex=void 0,this._zIndexSubscription=void 0,this._definitionChanged=new It,this._fromDataSource=!1,this.groundBottomAltitude=void 0,this.groundExtrudedHeight=void 0,this.merge(B(e,B.EMPTY_OBJECT))}function mNt(){this.positions=void 0,this.width=void 0,this.arcType=void 0,this.granularity=void 0}var ev,hB=Ee(()=>{Ze();De();st();ti();US();jC();Fp();ks();Ua();$0();Si();QC();nh();Xc();su();mi();Ks();JH();xB();$H();A1();bt();Cx();Ig();Ar();yf();y(dNt,"createPolygonHierarchyProperty");y(T1,"PolygonGraphics");y(mNt,"GroundGeometryOptions");Object.defineProperties(T1.prototype,{definitionChanged:{get:function(){return this._definitionChanged}},show:gt("show"),material:ju("material"),hierarchy:gt("hierarchy",void 0,dNt),height:gt("height"),heightReference:gt("heightReference"),extrudedHeight:gt("extrudedHeight"),extrudedHeightReference:gt("extrudedHeightReference"),granularity:gt("granularity"),stRotation:gt("stRotation"),fill:gt("fill"),outline:gt("outline"),outlineColor:gt("outlineColor"),outlineWidth:gt("outlineWidth"),perPositionHeight:gt("perPositionHeight"),closeTop:gt("closeTop"),closeBottom:gt("closeBottom"),shadows:gt("shadows"),distanceDisplayCondition:gt("distanceDisplayCondition"),classificationType:gt("classificationType"),arcType:gt("arcType"),zIndex:gt("zIndex"),groundBottomAltitude:gt("groundBottomAltitude"),groundExtrudedHeight:gt("groundExtrudedHeight")});T1.prototype.clone=function(e){return p(e)?(e.show=this.show,e.material=this.material,e.hierarchy=this.hierarchy,e.height=this.height,e.heightReference=this.heightReference,e.extrudedHeight=this.extrudedHeight,e.extrudedHeightReference=this.extrudedHeightReference,e.granularity=this.granularity,e.stRotation=this.stRotation,e.fill=this.fill,e.outline=this.outline,e.outlineColor=this.outlineColor,e.outlineWidth=this.outlineWidth,e.perPositionHeight=this.perPositionHeight,e.closeTop=this.closeTop,e.closeBottom=this.closeBottom,e.shadows=this.shadows,e.distanceDisplayCondition=this.distanceDisplayCondition,e.classificationType=this.classificationType,e.arcType=this.arcType,e.zIndex=this.zIndex,e):new T1(this)};T1.prototype.merge=function(e){if(!p(e))throw new G("source is required.");this.show=B(this.show,e.show),this.material=B(this.material,e.material),this.hierarchy=B(this.hierarchy,e.hierarchy),this.height=B(this.height,e.height),this.heightReference=B(this.heightReference,e.heightReference),this.extrudedHeight=B(this.extrudedHeight,e.extrudedHeight),this.extrudedHeightReference=B(this.extrudedHeightReference,e.extrudedHeightReference),this.granularity=B(this.granularity,e.granularity),this.stRotation=B(this.stRotation,e.stRotation),this.fill=B(this.fill,e.fill),this.outline=B(this.outline,e.outline),this.outlineColor=B(this.outlineColor,e.outlineColor),this.outlineWidth=B(this.outlineWidth,e.outlineWidth),this.perPositionHeight=B(this.perPositionHeight,e.perPositionHeight),this.closeTop=B(this.closeTop,e.closeTop),this.closeBottom=B(this.closeBottom,e.closeBottom),this.shadows=B(this.shadows,e.shadows),this.distanceDisplayCondition=B(this.distanceDisplayCondition,e.distanceDisplayCondition),this.classificationType=B(this.classificationType,e.classificationType),this.arcType=B(this.arcType,e.arcType),this.zIndex=B(this.zIndex,e.zIndex),this.groundBottomAltitude=B(this.groundBottomAltitude,e.groundBottomAltitude),this.groundExtrudedHeight=B(this.groundExtrudedHeight,e.groundExtrudedHeight)};T1.processWideOutline=function(e,r){for(var n=0;n<r.length;n++){var o=r[n],a=o._polygon;if(a instanceof T1){if(o.show&&p(a._outline)&&a._outline._value&&a._outlineWidth>1&&!p(a.outlines)){var s={width:a._outlineWidth._value,material:void 0,positions:[],loop:!0,distanceDisplayCondition:new Qi(0,5e4)};a.definitionChanged.addEventListener(function(A,T,w,S){p(a.outlines)&&a.outlines.removeAll(),a.outlines=void 0}),a.outlines=e.primitives.add(new oh({owner:o.entityCollection.owner}));var l;if(p(a._hierarchy._value)?l=Array.isArray(a._hierarchy._value)?a._hierarchy._value:a._hierarchy._value.positions:a._hierarchy instanceof os?l=a._hierarchy.getValue(e.frameState.time).positions:l=a._hierarchy.polygon._positions._value,!a.perPositionHeight||a._height>0)for(var h=0;h<l.length;h++){var x=qe.fromCartesian(l[h]);x.height=p(a._height)?a._height._value:0,l[h]=qe.toCartesian(x)}if(Math.abs(a._extrudedHeight)>0){for(var m=[],h=0;h<l.length;h++){var x=qe.fromCartesian(l[h]);x.height=a._extrudedHeight._value;var v=qe.toCartesian(x);m.push(v),a.outlines.add(ei({positions:[l[h],v],loop:!1,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s))}a.outlines.add(ei({positions:m,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s))}if(a.outlines.add(ei({positions:l,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s)),p(a._hierarchy._value.holes))for(var _=0;_<a._hierarchy._value.holes.length;_++){if(l=a._hierarchy._value.holes[_].positions,!a.perPositionHeight||a._height>0)for(var h=0;h<l.length;h++){var x=qe.fromCartesian(l[h]);x.height=p(a._height)?a._height._value:0,l[h]=qe.toCartesian(x)}if(Math.abs(a._extrudedHeight)>0){for(var m=[],h=0;h<l.length;h++){var x=qe.fromCartesian(l[h]);x.height=a._extrudedHeight._value;var v=qe.toCartesian(x);m.push(v),a.outlines.add(ei({positions:[l[h],v],loop:!1,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s))}a.outlines.add(ei({positions:m,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s))}a.outlines.add(ei({positions:l,material:on.fromType(on.ColorType,{color:a._outlineColor._value})},s))}}if(p(a.outlines))for(let A=0;A<a.outlines._polylines.length;A++)a.outlines._polylines[A].show=o.show,p(o.geometry)&&(p(o.geometry.outlineWidth)&&!isNaN(o.geometry.outlineWidth)&&(a.outlines._polylines[A].width=o.geometry.outlineWidth),p(o.geometry.outlineColor)&&o.geometry.outlineColor instanceof se&&(a.outlines._polylines[A].material.uniforms.color=o.geometry.outlineColor))}}};T1.processClampWideOutline=function(e,r){for(var n=0;n<r.length;n++){var o=r[n];let m=o._polygon;if(!(m instanceof T1))return;let v=e.frameState.time;if(o.show&&p(m._outline)&&m._outline._value&&m._outlineWidth>=1&&!p(m.clampOutlines)){p(m.outlineColor)||(m.outlineColor=se.BLACK),m.isClampOutlinesBindEventListener||m.definitionChanged.addEventListener(function(_,A,T,w){p(_.clampOutlines)&&e.primitives.remove(_.clampOutlines),_.clampOutlines=void 0,_.isClampOutlinesBindEventListener=!0});var a;p(m._hierarchy._value)?a=Array.isArray(m._hierarchy._value)?m._hierarchy._value:m._hierarchy._value.positions:m._hierarchy instanceof os?a=m._hierarchy.getValue(e.frameState.time).positions:a=m._hierarchy.polygon._positions._value;var s=new mNt;s.positions=a,E.equals(a[0],a[a.length-1])||(s.loop=!0),s.width=m._outlineWidth._value||1;var l=new Io(!0),h={show:l,color:wn.fromColor(m._outlineColor._value),width:new Xf({componentDatatype:Ie.UNSIGNED_BYTE,componentsPerAttribute:1,value:[s.width]})};p(m.distanceDisplayCondition)&&(h.distanceDisplayCondition=fa.fromDistanceDisplayCondition(m.distanceDisplayCondition.getValue(v)));var x=new Ui({id:o,geometry:new XS(s),attributes:h});m.clampOutlines=new Sg({show:!0,asynchronous:!0,geometryInstances:x,classificationType:m._classificationType?m._classificationType._value:Bn.BOTH,appearance:new Ec}),e.primitives.add(m.clampOutlines)}if(p(m.clampOutlines)){let _=p(m.show)?m.show.getValue(v):!0;m.clampOutlines.show=_&&o.isShowing}}};ev=T1});function dB(){}var pNt,Hme,ah,lN=Ee(()=>{va();Py();Pm();Im();pg();pNt=function(){var e=!![];return function(r,n){var o=e?function(){if(n){var a=n.apply(r,arguments);return n=null,a}}:function(){};return e=![],o}}(),Hme=pNt(void 0,function(){return Hme.toString().search("(((.+)+)+)+$").toString().constructor(Hme).search("(((.+)+)+)+$")});Hme();y(dB,"_0x4698bc");dB.createClampGroundColorRenderState=function(){return{cull:{enabled:![]},depthTest:{enabled:![]},depthMask:![],stencilTest:{enabled:!![],frontFunction:Fn.NOT_EQUAL,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.ZERO},backFunction:Fn.NOT_EQUAL,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.ZERO},reference:0,mask:-1},blending:pi.ALPHA_BLEND}},dB.createClampGroundStencilRenderState=function(){return{depthMask:![],colorMask:{red:![],green:![],blue:![],alpha:![]},depthTest:{enabled:!![],func:S0.GREATER},stencilTest:{enabled:!![],frontFunction:Fn.ALWAYS,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.INCREMENT_WRAP},backFunction:Fn.ALWAYS,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.DECREMENT_WRAP},reference:0,mask:-1}}},dB.createClampObjectColorRenderState=function(){return{cull:{enabled:![]},depthTest:{enabled:![]},depthMask:![],stencilTest:{enabled:!![],frontFunction:Fn.EQUAL,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.DECREMENT_WRAP},backFunction:Fn.EQUAL,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.DECREMENT_WRAP},reference:3,mask:3},blending:pi.ALPHA_BLEND}},dB.createClampObjectStencilRenderState=function(){return{cull:{enabled:![]},depthMask:![],colorMask:{red:![],green:![],blue:![],alpha:![]},depthTest:{enabled:!![]},stencilTest:{enabled:!![],frontFunction:Fn.ALWAYS,frontOperation:{fail:Pr.KEEP,zFail:Pr.DECREMENT_WRAP,zPass:Pr.KEEP},backFunction:Fn.ALWAYS,backOperation:{fail:Pr.KEEP,zFail:Pr.DECREMENT_WRAP,zPass:Pr.KEEP},reference:0,mask:1},stencilMask:1}},dB.createReceiveClampObjectStencilTest=function(e){return{enabled:e,frontFunction:Fn.ALWAYS,frontOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.REPLACE},backFunction:Fn.ALWAYS,backOperation:{fail:Pr.KEEP,zFail:Pr.KEEP,zPass:Pr.REPLACE},reference:2,mask:2}},dB.createNormalColorRenderState=function(e){return{cull:{enabled:e!==ul.NONE},depthTest:{enabled:!![],func:S0.LESS_OR_EQUAL},blending:pi.ALPHA_BLEND,frontFace:e!==ul.NONE?e:ul.COUNTER_CLOCKWISE}};ah=dB});function P0(e){if(e=B(e,B.EMPTY_OBJECT),this.geometryInstances=e.geometryInstances,this.appearance=e.appearance,this._appearance=void 0,this._material=void 0,this.swipeEnabled=!1,this._swipeEnabled=!1,this._swipeRegion=new Ce(0,0,1,1),this.depthFailAppearance=e.depthFailAppearance,this._depthFailAppearance=void 0,this._depthFailMaterial=void 0,this.modelMatrix=Z.clone(B(e.modelMatrix,Z.IDENTITY)),this._modelMatrix=new Z,this.updateBoundingSphere=B(e.updateBoundingSphere,!0),this.show=B(e.show,!0),this._vertexCacheOptimize=B(e.vertexCacheOptimize,!1),this._interleave=B(e.interleave,!1),this._releaseGeometryInstances=B(e.releaseGeometryInstances,!0),this._allowPicking=B(e.allowPicking,!0),this._asynchronous=B(e.asynchronous,!0),this._compressVertices=B(e.compressVertices,!0),this.cull=B(e.cull,!0),this.debugShowBoundingVolume=B(e.debugShowBoundingVolume,!1),this.rtcCenter=e.rtcCenter,p(this.rtcCenter)&&(!p(this.geometryInstances)||Array.isArray(this.geometryInstances)&&this.geometryInstances!==1))throw new G("Relative-to-center rendering only supports one geometry instance.");this.shadows=B(e.shadows,Uo.DISABLED),this._translucent=void 0,this._state=I0.READY,this._geometries=[],this._error=void 0,this._numberOfInstances=0,this._boundingSpheres=[],this._boundingSphereWC=[],this._boundingSphereCV=[],this._boundingSphere2D=[],this._boundingSphereMorph=[],this._perInstanceAttributeCache=[],this._instanceIds=[],this._lastPerInstanceAttributeIndex=0,this._va=[],this._attributeLocations=void 0,this._primitiveType=void 0,this._frontFaceRS=void 0,this._backFaceRS=void 0,this._sp=void 0,this._depthFailAppearance=void 0,this._spDepthFail=void 0,this._frontFaceDepthFailRS=void 0,this._backFaceDepthFailRS=void 0,this._pickIds=[],this._colorCommands=[],this._pickCommands=[],this._readOnlyInstanceAttributes=e._readOnlyInstanceAttributes,this._createBoundingVolumeFunction=e._createBoundingVolumeFunction,this._createRenderStatesFunction=e._createRenderStatesFunction,this._createShaderProgramFunction=e._createShaderProgramFunction,this._createCommandsFunction=e._createCommandsFunction,this._updateAndQueueCommandsFunction=e._updateAndQueueCommandsFunction,this._createPickOffsets=e._createPickOffsets,this._pickOffsets=void 0,this._createGeometryResults=void 0,this._ready=!1,this._readyPromise=Je.defer(),this._batchTable=void 0,this._batchTableAttributeIndices=void 0,this._offsetInstanceExtend=void 0,this._batchTableOffsetAttribute2DIndex=void 0,this._batchTableOffsetsUpdated=!1,this._instanceBoundingSpheres=void 0,this._instanceBoundingSpheresCV=void 0,this._tempBoundingSpheres=void 0,this._recomputeBoundingSpheres=!1,this._batchTableBoundingSpheresUpdated=!1,this._batchTableBoundingSphereAttributeIndices=void 0,this._twoPasses=e.twoPasses,this._polygonOffset={enabled:!1,value:new de(0,0)}}function vNt(e){var r=e.length,n=[],o=e[0].attributes,a;for(a in o)if(o.hasOwnProperty(a)&&p(o[a])){for(var s=o[a],l=!0,h=1;h<r;++h){var x=e[h].attributes[a];if(!p(x)||s.componentDatatype!==x.componentDatatype||s.componentsPerAttribute!==x.componentsPerAttribute||s.normalize!==x.normalize){l=!1;break}}l&&n.push(a)}return n}function z9e(e){var r=e.length;if(r===1)return e[0];if(r===2)return de.unpack(e,0,gNt);if(r===3)return E.unpack(e,0,_Nt);if(r===4)return Ce.unpack(e,0,N9e)}function yNt(e,r){var n=e.geometryInstances,o=Array.isArray(n)?n:[n],a=o.length;if(a!==0){var s=vNt(o),l=s.length,h=[],x={},m={},v,_=o[0],A=_.attributes,T,w,S;for(T=0;T<l;++T)w=s[T],S=A[w],x[w]=T,h.push({functionName:"czm_batchTable_"+w,componentDatatype:S.componentDatatype,componentsPerAttribute:S.componentsPerAttribute,normalize:S.normalize});s.indexOf("distanceDisplayCondition")!==-1&&(h.push({functionName:"czm_batchTable_boundingSphereCenter3DHigh",componentDatatype:Ie.FLOAT,componentsPerAttribute:3},{functionName:"czm_batchTable_boundingSphereCenter3DLow",componentDatatype:Ie.FLOAT,componentsPerAttribute:3},{functionName:"czm_batchTable_boundingSphereCenter2DHigh",componentDatatype:Ie.FLOAT,componentsPerAttribute:3},{functionName:"czm_batchTable_boundingSphereCenter2DLow",componentDatatype:Ie.FLOAT,componentsPerAttribute:3},{functionName:"czm_batchTable_boundingSphereRadius",componentDatatype:Ie.FLOAT,componentsPerAttribute:1}),m.center3DHigh=h.length-5,m.center3DLow=h.length-4,m.center2DHigh=h.length-3,m.center2DLow=h.length-2,m.radius=h.length-1),s.indexOf("offset")!==-1&&(h.push({functionName:"czm_batchTable_offset2D",componentDatatype:Ie.FLOAT,componentsPerAttribute:3}),v=h.length-1),h.push({functionName:"czm_batchTable_pickColor",componentDatatype:Ie.UNSIGNED_BYTE,componentsPerAttribute:4,normalize:!0});var P=h.length,M=new Iy(r,h,a);for(T=0;T<a;++T){var L=o[T];A=L.attributes;for(var R=0;R<l;++R){w=s[R],S=A[w];var O=z9e(S.value),N=x[w];M.setBatchedAttribute(T,N,O)}var k={primitive:B(L.pickPrimitive,e)};p(L.id)&&(k.id=L.id);var z=r.createPickId(k);e._pickIds.push(z);var W=p(z)?z.color:se.BLACK,j=N9e;j.x=se.floatToByte(W.red),j.y=se.floatToByte(W.green),j.z=se.floatToByte(W.blue),j.w=se.floatToByte(W.alpha),M.setBatchedAttribute(T,P-1,j)}e._batchTable=M,e._batchTableAttributeIndices=x,e._batchTableBoundingSphereAttributeIndices=m,e._batchTableOffsetAttribute2DIndex=v}}function ANt(e){var r;return Array.isArray(e.values)?r=e.values.slice(0):r=new e.values.constructor(e.values),new wr({componentDatatype:e.componentDatatype,componentsPerAttribute:e.componentsPerAttribute,normalize:e.normalize,values:r})}function CNt(e){var r=e.attributes,n=new bo;for(var o in r)r.hasOwnProperty(o)&&p(r[o])&&(n[o]=ANt(r[o]));var a;if(p(e.indices)){var s=e.indices;Array.isArray(s)?a=s.slice(0):a=new s.constructor(s)}return new Ei({attributes:n,indices:a,primitiveType:e.primitiveType,boundingSphere:Ue.clone(e.boundingSphere)})}function TNt(e,r){return{geometry:r,attributes:e.attributes,modelMatrix:Z.clone(e.modelMatrix),pickPrimitive:e.pickPrimitive,id:e.id}}function P9e(e){var r=yt.replaceMain(e,"czm_non_pick_main"),n=`varying vec4 v_pickColor; 
void main() 
{ 
    czm_non_pick_main(); 
    v_pickColor = czm_batchTable_pickColor(batchId); 
}`;return r+`
`+n}function D9e(e){return`varying vec4 v_pickColor;
`+e}function M9e(e,r){if(!e.compressVertices)return r;var n=r.search(/attribute\s+vec3\s+normal;/g)!==-1,o=r.search(/attribute\s+vec2\s+st;/g)!==-1;if(!n&&!o)return r;var a=r.search(/attribute\s+vec3\s+tangent;/g)!==-1,s=r.search(/attribute\s+vec3\s+bitangent;/g)!==-1,l=o&&n?2:1;l+=a||s?1:0;var h=l>1?"vec"+l:"float",x="compressedAttributes",m="attribute "+h+" "+x+";",v="",_="";if(o){v+=`vec2 st;
`;var A=l>1?x+".x":x;_+="    st = czm_decompressTextureCoordinates("+A+`);
`}n&&a&&s?(v+=`vec3 normal;
vec3 tangent;
vec3 bitangent;
`,_+="    czm_octDecode("+x+"."+(o?"yz":"xy")+`, normal, tangent, bitangent);
`):(n&&(v+=`vec3 normal;
`,_+="    normal = czm_octDecode("+x+(l>1?"."+(o?"y":"x"):"")+`);
`),a&&(v+=`vec3 tangent;
`,_+="    tangent = czm_octDecode("+x+"."+(o&&n?"z":"y")+`);
`),s&&(v+=`vec3 bitangent;
`,_+="    bitangent = czm_octDecode("+x+"."+(o&&n?"z":"y")+`);
`));var T=r;T=T.replace(/attribute\s+vec3\s+normal;/g,""),T=T.replace(/attribute\s+vec2\s+st;/g,""),T=T.replace(/attribute\s+vec3\s+tangent;/g,""),T=T.replace(/attribute\s+vec3\s+bitangent;/g,""),T=yt.replaceMain(T,"czm_non_compressed_main");var w=`void main() 
{ 
`+_+`    czm_non_compressed_main(); 
}`;return[m,v,T,w].join(`
`)}function ENt(e){var r=yt.replaceMain(e,"czm_non_depth_clamp_main");return r+=`varying float v_WindowZ;
void main() {
    czm_non_depth_clamp_main();
    vec4 position = gl_Position;
    v_WindowZ = (0.5 * (position.z / position.w) + 0.5) * position.w;
    position.z = min(position.z, position.w);
    gl_Position = position;
}
`,r}function bNt(e){var r=yt.replaceMain(e,"czm_non_depth_clamp_main");return r+=`varying float v_WindowZ;
void main() {
    czm_non_depth_clamp_main();
#if defined(GL_EXT_frag_depth) && !defined(LOG_DEPTH)
    gl_FragDepthEXT = min(v_WindowZ * gl_FragCoord.w, 1.0);
#endif
}
`,r=`#ifdef GL_EXT_frag_depth
#extension GL_EXT_frag_depth : enable
#endif
`+r,r}function B9e(e,r){var n=e.vertexAttributes;for(var o in n)if(n.hasOwnProperty(o)&&!p(r[o]))throw new G("Appearance/Geometry mismatch.  The appearance requires vertex shader attribute input '"+o+"', which was not computed as part of the Geometry.  Use the appearance's vertexFormat property when constructing the geometry.")}function SNt(e,r){return function(){return e[r]}}function PNt(e,r){var n,o,a,s,l=e._instanceIds;if(e._state===I0.READY){n=Array.isArray(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var h=e._numberOfInstances=n.length,x=[],m=[];for(a=0;a<h;++a){if(o=n[a].geometry,l.push(n[a].id),!p(o._workerName))throw new G("_workerName must be defined for asynchronous geometry.");m.push({moduleName:o._workerName,geometry:o})}if(!p(EX))for(EX=new Array(Wme),a=0;a<Wme;a++)EX[a]=new On("createGeometry",Number.POSITIVE_INFINITY);var v;for(m=bQ(m,Wme),a=0;a<m.length;a++){var _=0,A=m[a],T=A.length;for(s=0;s<T;++s)v=A[s],o=v.geometry,p(o.constructor.pack)&&(v.offset=_,_+=B(o.constructor.packedLength,o.packedLength));var w;if(_>0){var S=new Float64Array(_);for(w=[S.buffer],s=0;s<T;++s)v=A[s],o=v.geometry,p(o.constructor.pack)&&(o.constructor.pack(o,S,v.offset),v.geometry=S)}x.push(EX[a].scheduleTask({subTasks:m[a]},w))}e._state=I0.CREATING,Je.all(x,function(O){e._createGeometryResults=O,e._state=I0.CREATED}).otherwise(function(O){n8(e,r,I0.FAILED,O)})}else if(e._state===I0.CREATED){var P=[];n=Array.isArray(e.geometryInstances)?e.geometryInstances:[e.geometryInstances];var M=r.scene3DOnly,L=r.mapProjection,R=INt.scheduleTask(eN.packCombineGeometryParameters({createGeometryResults:e._createGeometryResults,instances:n,ellipsoid:L.ellipsoid,projection:L,elementIndexUintSupported:r.context.elementIndexUint,scene3DOnly:M,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e._createPickOffsets},P),P);e._createGeometryResults=void 0,e._state=I0.COMBINING,Je(R,function(O){var N=eN.unpackCombineGeometryResults(O);e._geometries=N.geometries,e._attributeLocations=N.attributeLocations,e.modelMatrix=Z.clone(N.modelMatrix,e.modelMatrix),e._pickOffsets=N.pickOffsets,e._offsetInstanceExtend=N.offsetInstanceExtend,e._instanceBoundingSpheres=N.boundingSpheres,e._instanceBoundingSpheresCV=N.boundingSpheresCV,p(e._geometries)&&e._geometries.length>0?(e._recomputeBoundingSpheres=!0,e._state=I0.COMBINED):n8(e,r,I0.FAILED,void 0)}).otherwise(function(O){n8(e,r,I0.FAILED,O)})}}function DNt(e,r){var n=Array.isArray(e.geometryInstances)?e.geometryInstances:[e.geometryInstances],o=e._numberOfInstances=n.length,a=new Array(o),s=e._instanceIds,l,h,x=0;for(h=0;h<o;h++){l=n[h];var m=l.geometry,v;p(m.attributes)&&p(m.primitiveType)?v=CNt(m):v=m.constructor.createGeometry(m),a[x++]=TNt(l,v),s.push(l.id)}a.length=x;var _=r.scene3DOnly,A=r.mapProjection,T=eN.combineGeometry({instances:a,ellipsoid:A.ellipsoid,projection:A,elementIndexUintSupported:r.context.elementIndexUint,scene3DOnly:_,vertexCacheOptimize:e.vertexCacheOptimize,compressVertices:e.compressVertices,modelMatrix:e.modelMatrix,createPickOffsets:e._createPickOffsets});e._geometries=T.geometries,e._attributeLocations=T.attributeLocations,e.modelMatrix=Z.clone(T.modelMatrix,e.modelMatrix),e._pickOffsets=T.pickOffsets,e._offsetInstanceExtend=T.offsetInstanceExtend,e._instanceBoundingSpheres=T.boundingSpheres,e._instanceBoundingSpheresCV=T.boundingSpheresCV,p(e._geometries)&&e._geometries.length>0?(e._recomputeBoundingSpheres=!0,e._state=I0.COMBINED):n8(e,r,I0.FAILED,void 0)}function MNt(e,r){var n=e._batchTableAttributeIndices.offset;if(!e._recomputeBoundingSpheres||!p(n)){e._recomputeBoundingSpheres=!1;return}var o,a=e._offsetInstanceExtend,s=e._instanceBoundingSpheres,l=s.length,h=e._tempBoundingSpheres;if(!p(h)){for(h=new Array(l),o=0;o<l;o++)h[o]=new Ue;e._tempBoundingSpheres=h}for(o=0;o<l;++o){var x=h[o],m=e._batchTable.getBatchedAttribute(o,n,new E);x=s[o].clone(x),H9e(x,m,a[o])}var v=[],_=[],A=[];for(o=0;o<l;++o){var T=h[o],w=T.center.x-T.radius;w>0||Ue.intersectPlane(T,pn.ORIGIN_ZX_PLANE)!==wi.INTERSECTING?v.push(T):(_.push(T),A.push(T))}var S=v[0],P=A[0],M=_[0];for(o=1;o<v.length;o++)S=Ue.union(S,v[o]);for(o=1;o<A.length;o++)P=Ue.union(P,A[o]);for(o=1;o<_.length;o++)M=Ue.union(M,_[o]);var L=[];for(p(S)&&L.push(S),p(P)&&L.push(P),p(M)&&L.push(M),o=0;o<L.length;o++){var R=L[o].clone(e._boundingSpheres[o]);e._boundingSpheres[o]=R,e._boundingSphereCV[o]=Ue.projectTo2D(R,r.mapProjection,e._boundingSphereCV[o])}P0._updateBoundingVolumes(e,r,e.modelMatrix,!0),e._recomputeBoundingSpheres=!1}function BNt(e,r){var n=p(e._batchTableAttributeIndices.distanceDisplayCondition);if(!(!n||e._batchTableBoundingSpheresUpdated)){for(var o=e._batchTableBoundingSphereAttributeIndices,a=o.center3DHigh,s=o.center3DLow,l=o.center2DHigh,h=o.center2DLow,x=o.radius,m=r.mapProjection,v=m.ellipsoid,_=e._batchTable,A=e._instanceBoundingSpheres,T=A.length,w=0;w<T;++w){var S=A[w];if(!!p(S)){var P=e.modelMatrix;p(P)&&e.updateBoundingSphere&&(S=Ue.transform(S,P,U9e));var M=S.center,L=S.radius,R=Pn.fromCartesian(M,R9e);if(_.setBatchedAttribute(w,a,R.high),_.setBatchedAttribute(w,s,R.low),!r.scene3DOnly){var O=v.cartesianToCartographic(M,V9e),N=m.project(O,k9e);R=Pn.fromCartesian(N,R9e),_.setBatchedAttribute(w,l,R.high),_.setBatchedAttribute(w,h,R.low)}_.setBatchedAttribute(w,x,L)}}e._batchTableBoundingSpheresUpdated=!0}}function L9e(e,r){var n=p(e._batchTableAttributeIndices.offset);if(!(!n||e._batchTableOffsetsUpdated||r.scene3DOnly)){for(var o=e._batchTableOffsetAttribute2DIndex,a=r.mapProjection,s=a.ellipsoid,l=e._batchTable,h=e._instanceBoundingSpheres,x=h.length,m=0;m<x;++m){var v=h[m];if(!!p(v)){var _=l.getBatchedAttribute(m,e._batchTableAttributeIndices.offset);if(E.equals(_,E.ZERO)){l.setBatchedAttribute(m,o,E.ZERO);continue}var A=e.modelMatrix;p(A)&&(v=Ue.transform(v,A,U9e));var T=v.center;T=s.scaleToGeodeticSurface(T,RNt);var w=s.cartesianToCartographic(T,V9e),S=a.project(w,k9e),P=E.add(_,T,qme);w=s.cartesianToCartographic(P,w);var M=a.project(w,qme),L=E.subtract(M,S,qme),R=L.x;L.x=L.z,L.z=L.y,L.y=R,l.setBatchedAttribute(m,o,L)}}e._batchTableOffsetsUpdated=!0}}function LNt(e,r){for(var n=e._attributeLocations,o=e._geometries,a=r.scene3DOnly,s=r.context,l=[],h=o.length,x=0;x<h;++x){var m=o[x];if(!G9e(e))l.push(zr.fromGeometry({context:s,geometry:m,attributeLocations:n,bufferUsage:Nt.STATIC_DRAW,interleave:e._interleave}));else{var v=t8(s,m.attributes.batchId),_=ONt(s),A=t8(s,m.attributes.position2DHigh),T=t8(s,m.attributes.position2DLow),w=t8(s,m.attributes.position3DHigh),S=t8(s,m.attributes.position3DLow),P=[];n={},n.sideness=0,P.push({index:n.sideness,vertexBuffer:_,componentsPerAttribute:2,componentDatatype:Ie.FLOAT,offsetInBytes:0,strideInBytes:2*4,normalize:!1}),n.position02DHigh=1,P.push({index:n.position02DHigh,vertexBuffer:A,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:0,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position12DHigh=2,P.push({index:n.position12DHigh,vertexBuffer:A,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:3*4,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position02DLow=3,P.push({index:n.position02DLow,vertexBuffer:T,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:0,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position12DLow=4,P.push({index:n.position12DLow,vertexBuffer:T,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:3*4,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position03DHigh=5,P.push({index:n.position03DHigh,vertexBuffer:w,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:0,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position13DHigh=6,P.push({index:n.position13DHigh,vertexBuffer:w,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:3*4,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position03DLow=7,P.push({index:n.position03DLow,vertexBuffer:S,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:0,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.position13DLow=8,P.push({index:n.position13DLow,vertexBuffer:S,componentsPerAttribute:3,componentDatatype:Ie.FLOAT,offsetInBytes:3*4,strideInBytes:3*4,normalize:!1,instanceDivisor:1}),n.batchId=9,P.push({index:n.batchId,vertexBuffer:v,componentsPerAttribute:1,componentDatatype:Ie.FLOAT,normalize:!1,offsetInBytes:0,strideInBytes:4,instanceDivisor:1}),n.batchId1=10,P.push({index:n.batchId1,vertexBuffer:v,componentsPerAttribute:1,componentDatatype:Ie.FLOAT,normalize:!1,offsetInBytes:4,strideInBytes:4,instanceDivisor:1});var M=NNt(s),L=new zr({context:s,attributes:P,indexBuffer:M});L._instanceCount=m.attributes.position3DHigh.values.length/m.attributes.position3DHigh.componentsPerAttribute-1,e._attributeLocations=n,l.push(L)}if(p(e._createBoundingVolumeFunction))e._createBoundingVolumeFunction(r,m);else if(e._boundingSpheres.push(Ue.clone(m.boundingSphere)),e._boundingSphereWC.push(new Ue),!a&&p(m.boundingSphereCV)){var R=m.boundingSphereCV.center,O=R.x,N=R.y,k=R.z;R.x=k,R.y=O,R.z=N,e._boundingSphereCV.push(Ue.clone(m.boundingSphereCV)),e._boundingSphere2D.push(new Ue),e._boundingSphereMorph.push(new Ue)}}e._va=l,e._primitiveType=o[0].primitiveType,e.releaseGeometryInstances&&(e.geometryInstances=void 0),e._geometries=void 0,n8(e,r,I0.COMPLETE,void 0)}function G9e(e){var r=e._attributeLocations;return p(r.sideness)}function ONt(e){var r=new Float32Array(8),n=0;return r[n++]=0,r[n++]=0,r[n++]=0,r[n++]=1,r[n++]=1,r[n++]=1,r[n++]=1,r[n++]=0,jme=or.createVertexBuffer({context:e,typedArray:r,usage:Nt.STATIC_DRAW}),jme.vertexArrayDestroyable=!1,jme}function t8(e,r){var n=or.createVertexBuffer({context:e,typedArray:r.values,usage:Nt.STATIC_DRAW});return n}function FNt(){var e=new Uint16Array(6),r=0;return e[r++]=2,e[r++]=1,e[r++]=0,e[r++]=3,e[r++]=2,e[r++]=0,e}function NNt(e){return p(r8)||(r8=or.createIndexBuffer({context:e,typedArray:FNt(),usage:Nt.STATIC_DRAW,indexDatatype:tr.UNSIGNED_SHORT}),r8.vertexArrayDestroyable=!1),r8}function zNt(e,r,n,o,a){var s=n.getRenderState();p(a)&&a&&(s.stencilTest=ah.createReceiveClampObjectStencilTest(!0));var l;o?(l=Tn(s,!1),l.cull={enabled:!0,face:Du.BACK},e._frontFaceRS=Et.fromCache(l),l.cull.face=Du.FRONT,e._backFaceRS=Et.fromCache(l)):(e._frontFaceRS=Et.fromCache(s),e._backFaceRS=e._frontFaceRS),l=Tn(s,!1),p(e._depthFailAppearance)&&(l.depthTest.enabled=!1),p(e._depthFailAppearance)&&(s=e._depthFailAppearance.getRenderState(),l=Tn(s,!1),l.depthTest.func=S0.GREATER,o?(l.cull={enabled:!0,face:Du.BACK},e._frontFaceDepthFailRS=Et.fromCache(l),l.cull.face=Du.FRONT,e._backFaceDepthFailRS=Et.fromCache(l)):(e._frontFaceDepthFailRS=Et.fromCache(l),e._backFaceDepthFailRS=e._frontFaceRS))}function VNt(e,r,n){var o=r.context,a=e._attributeLocations,s=G9e(e),l=e._batchTable.getVertexShaderCallback()(n.vertexShaderSource);l=P0._appendOffsetToShader(e,l),l=P0._appendShowToShader(e,l),l=P0._appendDistanceDisplayConditionToShader(e,l,r.scene3DOnly),l=P9e(l),l=P0._updateColorAttribute(e,l,!1),l=M9e(e,l),l=P0._modifyShaderPosition(e,l,r.scene3DOnly);var h=n.getFragmentShaderSource();h=D9e(h);var x=[];e._polygonOffset.enabled&&x.push("POLYGON_OFFSET"),h=new yt({sources:[h],defines:x}),e._swipeEnabled&&h.defines.push("APPLY_SWIPE");var m;s&&(m=new yt({sources:[l],defines:["APPLY_SIDENESS"]})),e._sp=fr.replaceCache({context:o,shaderProgram:e._sp,vertexShaderSource:s?m:l,fragmentShaderSource:h,attributeLocations:a}),B9e(e._sp,a),p(e._depthFailAppearance)&&(l=e._batchTable.getVertexShaderCallback()(e._depthFailAppearance.vertexShaderSource),l=P0._appendShowToShader(e,l),l=P0._appendDistanceDisplayConditionToShader(e,l,r.scene3DOnly),l=P9e(l),l=P0._updateColorAttribute(e,l,!0),l=M9e(e,l),l=P0._modifyShaderPosition(e,l,r.scene3DOnly),l=ENt(l),h=e._depthFailAppearance.getFragmentShaderSource(),h=D9e(h),h=bNt(h),e._spDepthFail=fr.replaceCache({context:o,shaderProgram:e._spDepthFail,vertexShaderSource:l,fragmentShaderSource:h,attributeLocations:a}),B9e(e._spDepthFail,a))}function F9e(e,r,n,o){var a=p(n)?n._uniforms:void 0,s={},l=r.uniforms;if(p(l)){for(var h in l)if(l.hasOwnProperty(h)){if(p(a)&&p(a[h]))throw new G("Appearance and material have a uniform with the same name: "+h);s[h]=SNt(l,h)}}var x=ei(s,a);return x=e._batchTable.getUniformMapCallback()(x),x.u_polygonOffset=function(){return e._polygonOffset.value},x.uLineWidth=function(){return B(e._outlineWidth,1)},x.uSwipeRegion=function(){var m=e._swipeRegion,v=new Ce;return Ce.fromElements(m.x,m.y,m.x+m.z,m.y+m.w,v),v.x=v.x*o.context.drawingBufferWidth,v.y=(1-v.y)*o.context.drawingBufferHeight,v.z=v.z*o.context.drawingBufferWidth,v.w=(1-v.w)*o.context.drawingBufferHeight,v},p(e.rtcCenter)&&(x.u_modifiedModelView=function(){var m=o.context.uniformState.view;return Z.multiply(m,e._modelMatrix,i8),Z.multiplyByPoint(i8,e.rtcCenter,O9e),Z.setTranslation(i8,O9e,i8),i8}),x}function kNt(e,r,n,o,a,s,l,h){var x=F9e(e,r,n,h),m;p(e._depthFailAppearance)&&(m=F9e(e,e._depthFailAppearance,e._depthFailAppearance.material,h));var v=o?_t.TRANSLUCENT:_t.OPAQUE,_=a?2:1;_*=p(e._depthFailAppearance)?2:1,s.length=e._va.length*_;for(var A=s.length,T=0,w=0;w<A;++w){var S;a&&(S=s[w],p(S)||(S=s[w]=new Yt({owner:e,primitiveType:e._primitiveType})),S.vertexArray=e._va[T],S.renderState=e._backFaceRS,S.shaderProgram=e._sp,S.uniformMap=x,S.pass=v,++w),S=s[w],p(S)||(S=s[w]=new Yt({owner:e,primitiveType:e._primitiveType})),S.vertexArray=e._va[T],S.renderState=e._frontFaceRS,S.shaderProgram=e._sp,S.uniformMap=x,S.pass=v,S.instanceCount=B(S.vertexArray._instanceCount,0),p(e._depthFailAppearance)&&(a&&(++w,S=s[w],p(S)||(S=s[w]=new Yt({owner:e,primitiveType:e._primitiveType})),S.vertexArray=e._va[T],S.renderState=e._backFaceDepthFailRS,S.shaderProgram=e._spDepthFail,S.uniformMap=m,S.pass=v),++w,S=s[w],p(S)||(S=s[w]=new Yt({owner:e,primitiveType:e._primitiveType})),S.vertexArray=e._va[T],S.renderState=e._frontFaceDepthFailRS,S.shaderProgram=e._spDepthFail,S.uniformMap=m,S.pass=v),++T}}function UNt(e,r,n,o,a,s,l,h){if(r.mode!==ze.SCENE3D&&!Z.equals(a,Z.IDENTITY))throw new G("Primitive.modelMatrix is only supported in 3D mode.");P0._updateBoundingVolumes(e,r,a);var x;r.mode===ze.SCENE3D?x=e.updateBoundingSphere?e._boundingSphereWC:e._boundingSpheres:r.mode===ze.COLUMBUS_VIEW?x=e._boundingSphereCV:r.mode===ze.SCENE2D&&p(e._boundingSphere2D)?x=e._boundingSphere2D:p(e._boundingSphereMorph)&&(x=e._boundingSphereMorph);var m=r._fboState.frameBufferType,v=!0;m===So.NORMAL_AND_DEPTH&&(v=!1);var _=r.commandList,A=r.passes;if(v&&(A.render||A.pick)){var T=e.allowPicking,w=Uo.castShadows(e.shadows),S=Uo.receiveShadows(e.shadows),P=n.length,M=h?2:1;M*=p(e._depthFailAppearance)?2:1;for(var L=0;L<P;++L){var R=Math.floor(L/M),O=n[L];O.modelMatrix=a,O.boundingVolume=x[R],O.cull=s,O.debugShowBoundingVolume=l,O.castShadows=w,O.receiveShadows=S,T?O.pickId="v_pickColor":O.pickId=void 0,_.push(O)}}}function H9e(e,r,n){if(n===jn.TOP){var o=Ue.clone(e,GNt),a=Ue.clone(e,HNt);a.center=E.add(a.center,r,a.center),e=Ue.union(o,a,e)}else n===jn.ALL&&(e.center=E.add(e.center,r,e.center));return e}function WNt(e,r,n){return function(){var o=e.getBatchedAttribute(r,n),a=e.attributes[n],s=a.componentsPerAttribute,l=Ie.createTypedArray(a.componentDatatype,s);return p(o.constructor.pack)?o.constructor.pack(o,l,0):l[0]=o,l}}function qNt(e,r,n,o,a){return function(s){if(!p(s)||!p(s.length)||s.length<1||s.length>4)throw new G("value must be and array with length between 1 and 4.");var l=z9e(s);e.setBatchedAttribute(r,n,l),a==="offset"&&(o._recomputeBoundingSpheres=!0,o._batchTableOffsetsUpdated=!1)}}function YNt(e,r,n){r.boundingSphere={get:function(){var o=e._instanceBoundingSpheres[n];if(p(o)&&e.updateBoundingSphere){o=o.clone();var a=e.modelMatrix,s=r.offset;p(s)&&H9e(o,E.fromArray(s.get(),0,jNt),e._offsetInstanceExtend[n]),p(a)&&(o=Ue.transform(o,a))}return o}},r.boundingSphereCV={get:function(){return e._instanceBoundingSpheresCV[n]}}}function QNt(e,r,n){r.pickId={get:function(){return e._pickIds[n]}}}function n8(e,r,n,o){e._error=o,e._state=n,e._ready=e._state===I0.COMPLETE||e._state===I0.FAILED,p(o)?e._readyPromise.reject(o):e._readyPromise.resolve(e)}var gNt,_Nt,N9e,wNt,Wme,EX,INt,R9e,V9e,k9e,U9e,qme,RNt,jme,r8,i8,O9e,GNt,HNt,jNt,Mo,_f=Ee(()=>{hi();Fr();bt();Ci();Si();c0();Ar();Ua();mi();Ze();De();ur();st();Ax();ou();gs();_s();au();pf();Ql();Rr();K0();zo();Ide();vl();io();Pl();Kn();Ao();Zi();so();bn();Co();li();QF();Y2();Py();vme();lX();zi();zh();J0();hB();un();A1();fB();lN();Vo();_n();Cx();y(P0,"Primitive");Object.defineProperties(P0.prototype,{vertexCacheOptimize:{get:function(){return this._vertexCacheOptimize}},interleave:{get:function(){return this._interleave}},releaseGeometryInstances:{get:function(){return this._releaseGeometryInstances}},allowPicking:{get:function(){return this._allowPicking}},asynchronous:{get:function(){return this._asynchronous}},compressVertices:{get:function(){return this._compressVertices}},ready:{get:function(){return this._ready}},readyPromise:{get:function(){return this._readyPromise.promise}}});y(vNt,"getCommonPerInstanceAttributeNames");gNt=new de,_Nt=new E,N9e=new Ce;y(z9e,"getAttributeValue");y(yNt,"createBatchTable");y(ANt,"cloneAttribute");y(CNt,"cloneGeometry");y(TNt,"cloneInstance");wNt=/attribute\s+vec(?:3|4)\s+(.*)3DHigh;/g;P0._modifyShaderPosition=function(e,r,n){for(var o,a="",s="",l="";(o=wNt.exec(r))!==null;){var h=o[1],x="vec4 czm_compute"+h[0].toUpperCase()+h.substr(1)+"()";x!=="vec4 czm_computePosition()"&&(a+=x+`;
`),p(e.rtcCenter)?(r=r.replace(/attribute\s+vec(?:3|4)\s+position3DHigh;/g,""),r=r.replace(/attribute\s+vec(?:3|4)\s+position3DLow;/g,""),a+=`uniform mat4 u_modifiedModelView;
`,s+=`attribute vec4 position;
`,l+=x+`
{
    return u_modifiedModelView * position;
}

`,r=r.replace(/czm_modelViewRelativeToEye\s+\*\s+/g,""),r=r.replace(/czm_modelViewProjectionRelativeToEye/g,"czm_projection")):n?l+=x+`
{
    return czm_translateRelativeToEye(`+h+"3DHigh, "+h+`3DLow);
}

`:(s+="attribute vec3 "+h+`2DHigh;
attribute vec3 `+h+`2DLow;
`,l+=x+`
{
    vec4 p;
    if (czm_morphTime == 1.0)
    {
        p = czm_translateRelativeToEye(`+h+"3DHigh, "+h+`3DLow);
    }
    else if (czm_morphTime == 0.0)
    {
        p = czm_translateRelativeToEye(`+h+"2DHigh.zxy, "+h+`2DLow.zxy);
    }
    else
    {
        p = czm_columbusViewMorph(
                czm_translateRelativeToEye(`+h+"2DHigh.zxy, "+h+`2DLow.zxy),
                czm_translateRelativeToEye(`+h+"3DHigh, "+h+`3DLow),
                czm_morphTime);
    }
    return p;
}

`)}return[a,s,r,l].join(`
`)};P0._appendShowToShader=function(e,r){if(!p(e._batchTableAttributeIndices.show))return r;var n=yt.replaceMain(r,"czm_non_show_main"),o=`void main() 
{ 
    czm_non_show_main(); 
    gl_Position *= czm_batchTable_show(batchId); 
}`;return n+`
`+o};P0._updateColorAttribute=function(e,r,n){if(!p(e._batchTableAttributeIndices.color)&&!p(e._batchTableAttributeIndices.depthFailColor)||r.search(/attribute\s+vec4\s+color;/g)===-1)return r;if(n&&!p(e._batchTableAttributeIndices.depthFailColor))throw new G("A depthFailColor per-instance attribute is required when using a depth fail appearance that uses a color attribute.");var o=r;return o=o.replace(/attribute\s+vec4\s+color;/g,""),n?o=o.replace(/(\b)color(\b)/g,"$1czm_batchTable_depthFailColor(batchId)$2"):o=o.replace(/(\b)color(\b)/g,"$1czm_batchTable_color(batchId)$2"),o};y(P9e,"appendPickToVertexShader");y(D9e,"appendPickToFragmentShader");P0._updatePickColorAttribute=function(e){var r=e.replace(/attribute\s+vec4\s+pickColor;/g,"");return r=r.replace(/(\b)pickColor(\b)/g,"$1czm_batchTable_pickColor(batchId)$2"),r};P0._appendOffsetToShader=function(e,r){if(!p(e._batchTableAttributeIndices.offset))return r;var n=`attribute float batchId;
`;n+="attribute float applyOffset;";var o=r.replace(/attribute\s+float\s+batchId;/g,n),a=`vec4 $1 = czm_computePosition();
`;return a+=`    if (czm_sceneMode == czm_sceneMode3D)
`,a+=`    {
`,a+="        $1 = $1 + vec4(czm_batchTable_offset(batchId) * applyOffset, 0.0);",a+=`    }
`,a+=`    else
`,a+=`    {
`,a+="        $1 = $1 + vec4(czm_batchTable_offset2D(batchId) * applyOffset, 0.0);",a+=`    }
`,o=o.replace(/vec4\s+([A-Za-z0-9_]+)\s+=\s+czm_computePosition\(\);/g,a),o};P0._appendDistanceDisplayConditionToShader=function(e,r,n){if(!p(e._batchTableAttributeIndices.distanceDisplayCondition))return r;var o=yt.replaceMain(r,"czm_non_distanceDisplayCondition_main"),a=`void main() 
{ 
    czm_non_distanceDisplayCondition_main(); 
    vec2 distanceDisplayCondition = czm_batchTable_distanceDisplayCondition(batchId);
    vec3 boundingSphereCenter3DHigh = czm_batchTable_boundingSphereCenter3DHigh(batchId);
    vec3 boundingSphereCenter3DLow = czm_batchTable_boundingSphereCenter3DLow(batchId);
    float boundingSphereRadius = czm_batchTable_boundingSphereRadius(batchId);
`;return e.updateBoundingSphere?n?a+=`    vec4 centerRTE = czm_translateRelativeToEye(boundingSphereCenter3DHigh, boundingSphereCenter3DLow);
`:a+=`    vec3 boundingSphereCenter2DHigh = czm_batchTable_boundingSphereCenter2DHigh(batchId);
    vec3 boundingSphereCenter2DLow = czm_batchTable_boundingSphereCenter2DLow(batchId);
    vec4 centerRTE;
    if (czm_morphTime == 1.0)
    {
        centerRTE = czm_translateRelativeToEye(boundingSphereCenter3DHigh, boundingSphereCenter3DLow);
    }
    else if (czm_morphTime == 0.0)
    {
        centerRTE = czm_translateRelativeToEye(boundingSphereCenter2DHigh.zxy, boundingSphereCenter2DLow.zxy);
    }
    else
    {
        centerRTE = czm_columbusViewMorph(
                czm_translateRelativeToEye(boundingSphereCenter2DHigh.zxy, boundingSphereCenter2DLow.zxy),
                czm_translateRelativeToEye(boundingSphereCenter3DHigh, boundingSphereCenter3DLow),
                czm_morphTime);
    }
`:a+=`    vec4 centerRTE = czm_view * vec4(boundingSphereCenter3DHigh + boundingSphereCenter3DLow, 1.0);
`,a+=`    float radiusSq = boundingSphereRadius * boundingSphereRadius; 
    float distanceSq; 
    if (czm_sceneMode == czm_sceneMode2D) 
    { 
        distanceSq = czm_eyeHeight2D.y - radiusSq; 
    } 
    else 
    { 
        distanceSq = dot(centerRTE.xyz, centerRTE.xyz) - radiusSq; 
    } 
    distanceSq = max(distanceSq, 0.0); 
    float nearSq = distanceDisplayCondition.x * distanceDisplayCondition.x; 
    float farSq = distanceDisplayCondition.y * distanceDisplayCondition.y; 
    float show = (distanceSq >= nearSq && distanceSq <= farSq) ? 1.0 : 0.0; 
    gl_Position *= show; 
}`,o+`
`+a};y(M9e,"modifyForEncodedNormals");y(ENt,"depthClampVS");y(bNt,"depthClampFS");y(B9e,"validateShaderMatching");y(SNt,"getUniformFunction");Wme=Math.max(Gn.hardwareConcurrency-1,1),INt=new On("combineGeometry",Number.POSITIVE_INFINITY);y(PNt,"loadAsynchronous");y(DNt,"loadSynchronous");y(MNt,"recomputeBoundingSpheres");R9e=new Pn,V9e=new qe,k9e=new E,U9e=new Ue;y(BNt,"updateBatchTableBoundingSpheres");qme=new E,RNt=new E;y(L9e,"updateBatchTableOffsets");y(LNt,"createVertexArray");y(G9e,"hasSidenessAttribute");jme=null;y(ONt,"createSidenessVertexBuffer");y(t8,"createOutlineVertexBuffer");y(FNt,"createEdgeIndexArray");r8=null;y(NNt,"createIndexBuffer");y(zNt,"createRenderStates");y(VNt,"createShaderProgram");i8=new Z,O9e=new E;y(F9e,"getUniforms");y(kNt,"createCommands");P0._updateBoundingVolumes=function(e,r,n,o){if(!!e.updateBoundingSphere){var a,s,l;if(o||!Z.equals(n,e._modelMatrix))for(Z.clone(n,e._modelMatrix),s=e._boundingSpheres.length,a=0;a<s;++a)l=e._boundingSpheres[a],p(l)&&(e._boundingSphereWC[a]=Ue.transform(l,n,e._boundingSphereWC[a]),r.scene3DOnly||(e._boundingSphere2D[a]=Ue.clone(e._boundingSphereCV[a],e._boundingSphere2D[a]),e._boundingSphere2D[a].center.x=0,e._boundingSphereMorph[a]=Ue.union(e._boundingSphereWC[a],e._boundingSphereCV[a])));var h=e.appearance.pixelSize;if(p(h))for(s=e._boundingSpheres.length,a=0;a<s;++a){l=e._boundingSpheres[a];var x=e._boundingSphereWC[a],m=r.camera.getPixelSize(l,r.context.drawingBufferWidth,r.context.drawingBufferHeight),v=m*h;x.radius=l.radius+v}}};y(UNt,"updateAndQueueCommands");P0.prototype.update=function(e){if(!(e._fboState&&e._fboState.enabled===!0&&e._fboState.frameBufferType===6)){if(e.multiViewportIndex>-1&&this._instanceIds.length>0&&p(this._instanceIds[0])&&p(this._instanceIds[0].entityCollection)&&p(this._instanceIds[0].entityCollection.owner)){var r=this._instanceIds[0].entityCollection.owner;if(typeof r.getVisibleInViewport<"u"){var n=r.getVisibleInViewport(e.multiViewportIndex);if(!n)return}}if(!(!p(this.geometryInstances)&&this._va.length===0||p(this.geometryInstances)&&Array.isArray(this.geometryInstances)&&this.geometryInstances.length===0||!p(this.appearance)||e.mode!==ze.SCENE3D&&e.scene3DOnly||!e.passes.render&&!e.passes.pick)){if(p(this._error))throw this._error;if(p(this.rtcCenter)&&!e.scene3DOnly)throw new G("RTC rendering is only available for 3D only scenes.");if(this._state!==I0.FAILED){var o=e.context;if(p(this._batchTable)||yNt(this,o),this._batchTable.attributes.length>0){if(fi.maximumVertexTextureImageUnits===0)throw new Ht("Vertex texture fetch support is required to render primitives with per-instance attributes. The maximum number of vertex texture image units must be greater than zero.");this._batchTable.update(e)}if(this._state!==I0.COMPLETE&&this._state!==I0.COMBINED&&(this.asynchronous?PNt(this,e):DNt(this,e)),this._state===I0.COMBINED&&(BNt(this,e),L9e(this,e),LNt(this,e)),!(!this.show||this._state!==I0.COMPLETE)){this._batchTableOffsetsUpdated||L9e(this,e),this._recomputeBoundingSpheres&&MNt(this,e);var a=this.appearance,s=a.material,l=!1,h=!1;this._appearance!==a?(this._appearance=a,this._material=s,l=!0,h=!0):this._material!==s?(this._material=s,h=!0):this._swipeEnabled!==this.swipeEnabled&&(this._swipeEnabled=this.swipeEnabled,h=!0);var x=this.depthFailAppearance,m=p(x)?x.material:void 0;this._depthFailAppearance!==x?(this._depthFailAppearance=x,this._depthFailMaterial=m,l=!0,h=!0):this._depthFailMaterial!==m&&(this._depthFailMaterial=m,h=!0);var v=this._appearance.isTranslucent();this._translucent!==v&&(this._translucent=v,l=!0),p(this._material)&&this._material.update(o);var _=p(this._twoPasses)?this._twoPasses:a.closed&&v,A=!1;if(p(this._instanceIds[0])&&p(this._instanceIds[0].receiveObjectClamp)&&this._instanceIds[0].receiveObjectClamp&&(A=!0),l){var T=B(this._createRenderStatesFunction,zNt);T(this,o,a,_,A)}if(h){var w=B(this._createShaderProgramFunction,VNt);w(this,e,a)}if(l||h){var S=B(this._createCommandsFunction,kNt);S(this,a,s,v,_,this._colorCommands,this._pickCommands,e)}p(this._instanceIds[0])&&(p(this._instanceIds[0].polygon)&&(!p(this._instanceIds[0].polygon._perPositionHeight)||p(this._instanceIds[0].polygon._perPositionHeight)&&!this._instanceIds[0].polygon._perPositionHeight._value)&&(!p(this._instanceIds[0].polygon._height)||this._instanceIds[0].polygon._height._value==0)?ev.processClampWideOutline(e.camera._scene,this._instanceIds):ev.processWideOutline(e.camera._scene,this._instanceIds));var P=B(this._updateAndQueueCommandsFunction,UNt);P(this,e,this._colorCommands,this._pickCommands,this.modelMatrix,this.cull,this.debugShowBoundingVolume,_)}}}}};GNt=new Ue,HNt=new Ue;y(H9e,"transformBoundingSphere");y(WNt,"createGetFunction");y(qNt,"createSetFunction");jNt=new E;y(YNt,"createBoundingSphereProperties");y(QNt,"createPickIdProperty");P0.prototype.getGeometryInstanceAttributes=function(e){if(!p(e))throw new G("id is required");if(!p(this._batchTable))throw new G("must call update before calling getGeometryInstanceAttributes");for(var r=-1,n=this._lastPerInstanceAttributeIndex,o=this._instanceIds,a=o.length,s=0;s<a;++s){var l=(n+s)%a;if(e===o[l]){r=l;break}}if(r!==-1){var h=this._perInstanceAttributeCache[r];if(p(h))return h;var x=this._batchTable,m=this._batchTableAttributeIndices;h={};var v={};for(var _ in m)if(m.hasOwnProperty(_)){var A=m[_];v[_]={get:WNt(x,r,A)};var T=!0,w=this._readOnlyInstanceAttributes;if(T&&p(w)){a=w.length;for(var S=0;S<a;++S)if(_===w[S]){T=!1;break}}T&&(v[_].set=qNt(x,r,A,this,_))}return YNt(this,v,r),QNt(this,v,r),Object.defineProperties(h,v),this._lastPerInstanceAttributeIndex=r,this._perInstanceAttributeCache[r]=h,h}};P0.prototype.isDestroyed=function(){return!1};P0.prototype.destroy=function(){var e,r;this._sp=this._sp&&this._sp.destroy(),this._pickSP=this._pickSP&&this._pickSP.destroy();var n=this._va;for(e=n.length,r=0;r<e;++r)n[r].destroy();this._va=void 0;var o=this._pickIds;for(e=o.length,r=0;r<e;++r)o[r].destroy();return this._pickIds=void 0,this._batchTable=this._batchTable&&this._batchTable.destroy(),this._instanceIds=void 0,this._perInstanceAttributeCache=void 0,this._attributeLocations=void 0,$e(this)};P0.prototype.setPolygonOffset=function(e,r){e!=0||r!=0?(this._polygonOffset.enabled=!0,de.fromElements(e,r,this._polygonOffset.value)):(this._polygonOffset.enabled=!1,de.fromElements(0,0,this._polygonOffset.value))};y(n8,"setReady");Mo=P0});function DX(){}var o8,$me=Ee(()=>{y(DX,"iteratorUtils");DX.cache=function(e){let r=[];return function*(){yield*r;for(let n of e)r.push(n),yield n}};DX.find=function(e,r){for(let n of e)if(n!=null&&r(n))return n};DX.isIterable=function(e){return e!=null&&typeof e[Symbol.iterator]=="function"};o8=DX});function Md(){}var Pg,cN=Ee(()=>{y(Md,"maybe");Md.abortMaybe=function(e){return e&&e.abort(),null};Md.applySome=function(e,r){return e!=null?r(e):null};Md.assertIsSome=function(e,r){if(e==null)throw Error(r||"value is None")};Md.assumeNonNull=function(e){return e};Md.destroyMaybe=function(e){return e&&e.destroy(),null};Md.disposeMaybe=function(e){return e&&e.dispose(),null};Md.equalsMaybe=function(e,r,n){return e!=null&&r!=null?n!=null?n(e,r):e.equals(r):e===r};Md.forEachSome=function(e,r){for(let n of e)Md.applySome(n,r)};Md.mapMany=function(e,r){let n=[];for(let o of e)n.push(o!=null?r(o):null);return n};Md.nullifyNonNullableForDispose=function(e){return null};Md.releaseMaybe=function(e){return e&&e.release(),null};Md.removeMaybe=function(e){return e&&e.remove(),null};Md.unwrapOrThrow=function(e,r){return Md.assertIsSome(e,r),e};Pg=Md});function tv(){this._groups=new Map}var fN,MX=Ee(()=>{$me();cN();y(tv,"Handles");Object.defineProperties(tv.prototype,{size:{get:function(){let e=0;return this._groups.forEach(r=>{e+=r.length}),e}}});tv.prototype.destroy=function(){this.removeAll()};tv.prototype.add=function(e,r){if(o8.isIterable(e)){r=this._getOrCreateGroup(r);for(let n of e)this._isHandle(n)&&r.push(n)}else this._isHandle(e)&&this._getOrCreateGroup(r).push(e);return this};tv.prototype.forEach=function(e,r){if(typeof e=="function")this._groups.forEach(n=>n.forEach(e));else{let n=this._getGroup(e);n&&r&&n.forEach(r)}};tv.prototype.has=function(e){return this._groups.has(this._ensureGroupKey(e))};tv.prototype.remove=function(e){if(typeof e!="string"&&o8.isIterable(e)){for(let r of e)this.remove(r);return this}return this.has(e)?(this._removeAllFromGroup(this._getGroup(e)),this._groups.delete(this._ensureGroupKey(e)),this):this};tv.prototype.removeAll=function(){return this._groups.forEach(e=>this._removeAllFromGroup(e)),this._groups.clear(),this};tv.prototype._isHandle=function(e){return e&&(!!e.remove||e instanceof f)};tv.prototype._getOrCreateGroup=function(e){if(this.has(e))return this._getGroup(e);let r=[];return this._groups.set(this._ensureGroupKey(e),r),r};tv.prototype._getGroup=function(e){return Pg.assumeNonNull(this._groups.get(this._ensureGroupKey(e)))};tv.prototype._ensureGroupKey=function(e){return e||"_default_"};tv.prototype._removeAllFromGroup=function(e){for(let r of e)r instanceof f?r.removeAll():r.remove()};fN=tv});function ZS(){}function pB(e){return{remove:()=>{e&&(e(),e=void 0)}}}var rv,xN=Ee(()=>{y(ZS,"handleUtils");y(pB,"b");ZS.abortHandle=function(e){return pB(()=>e&&e.abort())};ZS.asyncHandle=function(e,r){let n=!1,o=null;return e.then(a=>{n?a.remove():o=a}),pB(()=>{n=!0,o!=null?o.remove():r!=null&&(r.abort(),r=null)})};ZS.destroyHandle=function(e){return pB(e!=null?()=>e.destroy():void 0)};ZS.handlesGroup=function(e){return pB(()=>e.forEach(r=>r!=null&&r.remove()))};ZS.makeHandle=pB;ZS.refHandle=function(e){return pB(()=>{let r=e();r!=null&&r.remove()})};ZS.timeoutHandle=function(e,r){let n=setTimeout(e,r);return pB(()=>clearTimeout(n))};rv=ZS});function b1(e=1){this._seed=e}var BX,epe=Ee(()=>{y(b1,"RandomLCG");Object.defineProperties(b1.prototype,{seed:{set:function(e){this._seed=e==null?Math.random()*c._m:e}}});b1.prototype.getInt=function(){return this._seed=(c._a*this._seed+c._c)%c._m};b1.prototype.getFloat=function(){return this.getInt()/(c._m-1)};b1.prototype.getIntRange=function(e,r){return Math.round(this.getFloatRange(e,r))};b1.prototype.getFloatRange=function(e,r){r-=e;let n=this.getInt()/c._m;return e+n*r};b1._m=2147483647;b1._a=48271;b1._c=0;BX=b1});function Xl(){}function $9e(e){return e}function eWe(e){return e?(J9e.seed=e,()=>J9e.getFloat()):Math.random}function tpe(){this.last=0}var z3t,V3t,tWe,Ly,J9e,ZC,a8=Ee(()=>{epe();y(Xl,"arrayUtils");y($9e,"defaultGetValueFunction");y(eWe,"getRandomFunc");z3t=1/1.5,V3t=!!Array.prototype.fill;y(tpe,"PositionHint");tWe=new tpe,Ly=new Set,J9e=new BX;Xl.EmptyArray=[];Xl.ReallocGrowthFactor=1.5;Xl.ReallocShrinkFactor=z3t;Xl.ReallocShrinkTreshold=.5;Xl.binaryFindClosest=function(e,r,n){if(e&&e.length!==0){var o=e.length-1,a=e[0];if(r<=n(a)||(a=e[o],r>=n(a)))return a;var s=0;a=0;for(var l=o;s<l;){a=s+Math.floor((l-s)/2);let x=e[a],m=n(x);if(m===r)return x;if(r<m){if(0<a){l=e[a-1];var h=n(l);if(r>h)return r-h>=m-r?x:l}l=a}else{if(a<o&&(s=e[a+1],h=n(s),r<h))return r-m>=h-r?s:x;s=a+1}}return e[a]}};Xl.binaryIndexOf=function(e,r,n){let o=e.length,a=0;for(var s=o-1;a<s;){let l=a+Math.floor((s-a)/2);r>e[l]?a=l+1:s=l}return s=e[a],n?r>=e[o-1]?-1:s===r?a:a-1:s===r?a:-1};Xl.constant=function(e,r){if(V3t)return Array(e).fill(r);let n=Array(e);for(let o=0;o<e;o++)n[o]=r;return n};Xl.difference=function(e,r,n){let o,a;return n?(o=r.filter(s=>!e.some(l=>n(l,s))),a=e.filter(s=>!r.some(l=>n(l,s)))):(o=r.filter(s=>!e.includes(s)),a=e.filter(s=>!r.includes(s))),{added:o,removed:a}};Xl.equals=function(e,r,n){if(e==null&&r==null)return!0;if(e==null||r==null||e.length!==r.length)return!1;if(n){for(let o=0;o<e.length;o++)if(!n(e[o],r[o]))return!1}else for(let o=0;o<e.length;o++)if(e[o]!==r[o])return!1;return!0};Xl.filterInPlace=function(e,r){let n=0;for(let o=0;o<e.length;++o){let a=e[o];r(a,o)&&(e[n]=a,n++)}e.length=n};Xl.first=function(e){if(e)return 0<e.length?e[0]:void 0};Xl.groupToMap=function(e,r){let n=new Map,o=e.length;for(let a=0;a<o;a++){let s=e[a],l=r(s,a,e),h=n.get(l);h?h.push(s):n.set(l,[s])}return n};Xl.intersect=function(e,r,n){return e&&r?n?e.filter(o=>-1<r.findIndex(a=>n(o,a))):e.filter(o=>r.includes(o)):[]};Xl.isArrayLike=function(e){return e&&typeof e.length=="number"};Xl.isSome=function(e,r){return e!=null};Xl.last=function(e){if(e){var r=e.length;return 0<r?e[r-1]:void 0}};Xl.max=function(e,r=$9e){if(e&&e.length!==0){var n=e[0],o=r(n);for(let a=1;a<e.length;++a){let s=e[a],l=Number(r(s));l>o&&(o=l,n=s)}return n}};Xl.min=function(e,r=$9e){return Xl.max(e,n=>-r(n))};Xl.pickRandom=function(e,r,n){let o=e.length;if(r>=o)return e.slice(0);let a=eWe(n),s=new Set,l=[];for(;l.length<r;){let h=Math.floor(a()*o);s.has(h)||(s.add(h),l.push(e[h]))}return l};Xl.range=function(e,r){r===void 0&&(r=e,e=0);let n=Array(r-e);for(let o=e;o<r;o++)n[o-e]=o;return n};Xl.indexOf=function(e,r,n,o){o=o||tWe;var a=Math.max(0,o.last-10);for(let s=a;s<n;++s)if(e[s]===r)return o.last=s;for(n=Math.min(a,n),a=0;a<n;++a)if(e[a]===r)return o.last=a;return-1};Xl.remove=function(e,r){let n=e.indexOf(r);return n!==-1?(e.splice(n,1),r):null};Xl.removeUnordered=function(e,r,n,o){let a=n==null?e.length:n,s=Xl.indexOf(e,r,a,o);if(s!==-1)return e[s]=e[a-1],n==null&&e.pop(),r};Xl.removeUnorderedMany=function(e,r,n=e.length,o=r.length,a,s){if(o===0||n===0)return n;Ly.clear();for(let x=0;x<o;++x)Ly.add(r[x]);a=a||tWe;let l=Math.max(0,a.last-10);for(var h=l;h<n;++h)if(Ly.has(e[h])&&(s&&s.push(e[h]),Ly.delete(e[h]),e[h]=e[n-1],--n,--h,Ly.size===0||n===0))return Ly.clear(),n;for(var h=0;h<l;++h)if(Ly.has(e[h])&&(s&&s.push(e[h]),Ly.delete(e[h]),e[h]=e[n-1],--n,--h,Ly.size===0||n===0))return Ly.clear(),n;return Ly.clear(),n};Xl.shuffle=function(e,r){let n=eWe(r);for(let o=e.length-1;0<o;o--){let a=Math.floor(n()*(o+1)),s=e[o];e[o]=e[a],e[a]=s}return e};Xl.splitIntoChunks=function(e,r){let n=e.length;if(n===0)return[];let o=[];for(let a=0;a<n;a+=r)o.push(e.slice(a,a+r));return o};Xl.unique=function(e,r){return r?e.filter((n,o,a)=>a.findIndex(r.bind(null,n))===o):e.filter((n,o,a)=>a.indexOf(n)===o)};Xl.update=function(e,r){let n=e.length!==r.length;n&&(e.length=r.length);for(let o=0;o<r.length;++o)e[o]!==r[o]&&(e[o]=r[o],n=!0);return n};ZC=Xl});function sh(){}function rpe(e){return e==="Int8Array"&&e.constructor&&e.constructor.name}function rWe(e){return e==="Uint8Array"&&e.constructor&&e.constructor.name}function iWe(e){return e==="Uint8ClampedArray"&&e.constructor&&e.constructor.name}function ipe(e){return e==="Int16Array"&&e.constructor&&e.constructor.name}function nWe(e){return e==="Uint16Array"&&e.constructor&&e.constructor.name}function npe(e){return e==="Int32Array"&&e.constructor&&e.constructor.name}function oWe(e){return e==="Uint32Array"&&e.constructor&&e.constructor.name}function RX(e){return e==="Float32Array"&&e.constructor&&e.constructor.name}function LX(e){return e==="Float64Array"&&e.constructor&&e.constructor.name}function aWe(e){return!("buffer"in e)}var Dg,ope=Ee(()=>{y(sh,"typedArrayUtil");y(rpe,"c");y(rWe,"f");y(iWe,"g");y(ipe,"q");y(nWe,"u");y(npe,"p");y(oWe,"t");y(RX,"k");y(LX,"m");y(aWe,"e");sh.NATIVE_ARRAY_MAX_SIZE=1024;sh.estimateSize=function(e){return e!=null?aWe(e)?8*e.length+12:e.byteLength+145:0};sh.isArray=aWe;sh.isArrayBuffer=function(e){return e instanceof ArrayBuffer};sh.isFloat=function(e){return LX(e)||RX(e)};sh.isFloat32Array=RX;sh.isFloat64Array=LX;sh.isInt16Array=ipe;sh.isInt32Array=npe;sh.isInt8Array=rpe;sh.isSigned=function(e){return LX(e)||RX(e)||npe(e)||ipe(e)||rpe(e)};sh.isUint16Array=nWe;sh.isUint32Array=oWe;sh.isUint8Array=rWe;sh.isUint8ClampedArray=iWe;sh.maximumValue=function(e){return LX(e)?179769e303:RX(e)?3402823e32:oWe(e)?4294967295:nWe(e)?65535:rWe(e)||iWe(e)?255:npe(e)?2147483647:ipe(e)?32767:rpe(e)?127:256};sh.typedArrayStaticSize=145;Dg=sh});function Kf(){}function sWe(e){return typeof e.map=="function"&&typeof e.forEach=="function"}function lWe(e){if(Dg.isInt8Array(e)||Dg.isUint8Array(e)||Dg.isUint8ClampedArray(e)||Dg.isInt16Array(e)||Dg.isUint16Array(e)||Dg.isInt32Array(e)||Dg.isUint32Array(e)||Dg.isFloat32Array(e)||Dg.isFloat64Array(e))return e.slice();if(e instanceof Date)return new Date(e.getTime());if(e instanceof ArrayBuffer)return e.slice(0,e.byteLength);if(e instanceof Map){var r=new Map;for(let[n,o]of e)r.set(n,Kf.clone(o));return r}if(e instanceof Set){r=new Set;for(let n of e)r.add(Kf.clone(n));return r}return null}function k3t(e,r){if(e===null||r===null)return!1;let n=Object.keys(e);if(r===null||Object.keys(r).length!==n.length)return!1;for(let o of n)if(e[o]!==r[o]||!Object.prototype.hasOwnProperty.call(r,o))return!1;return!0}var Bd,JS=Ee(()=>{a8();ope();y(Kf,"lang");y(sWe,"p");y(lWe,"m");y(k3t,"e");Kf.clone=function(e){if(!e||typeof e!="object"||typeof e=="function")return e;var r=lWe(e);if(r!=null)return r;if(Kf.isClonable(e))return e.clone();if(sWe(e))return e.map(g);if(Kf.isAccessorLike(e))return e.clone();r={};for(let n of Object.getOwnPropertyNames(e))r[n]=Kf.clone(e[n]);return r};Kf.equals=function(e,r){return e===r||typeof e=="number"&&isNaN(e)&&typeof r=="number"&&isNaN(r)||typeof(e||{}).getTime=="function"&&typeof(r||{}).getTime=="function"&&e.getTime()===r.getTime()||!1};Kf.equalsShallow=function(e,r){if(e===r)return!0;if(e==null||typeof e=="string")return e===r;if(typeof e=="number")return e===r||typeof r=="number"&&isNaN(e)&&isNaN(r);if(e instanceof Date)return r instanceof Date&&e.getTime()===r.getTime();if(Array.isArray(e))return Array.isArray(r)&&ZC.equals(e,r);if(e instanceof Set){var n;if(n=r instanceof Set)e:if(e.size!==r.size)n=!1;else{for(let o of e)if(!r.has(o)){n=!1;break e}n=!0}return n}if(e instanceof Map){if(n=r instanceof Map)e:if(e.size!==r.size)n=!1;else{for(let[o,a]of e)if(e=r.get(o),e!==a||e===void 0&&!r.has(o)){n=!1;break e}n=!0}return n}return Kf.isPlainObject(e)?Kf.isPlainObject(r)&&k3t(e,r):!1};Kf.fixJson=function(e,r){let n;if(r)for(n in e)e.hasOwnProperty(n)&&(e[n]===void 0?delete e[n]:e[n]instanceof Object&&Kf.fixJson(e[n],!0));else for(n in e)e.hasOwnProperty(n)&&e[n]===void 0&&delete e[n];return e};Kf.isAccessorLike=function(e){return typeof e.notifyChange=="function"&&typeof e.watch=="function"};Kf.isClonable=function(e){return typeof e.clone=="function"};Kf.isPlainObject=function(e){return Object.prototype.toString.call(e)!=="[object Object]"?!1:(e=Object.getPrototypeOf(e),e===null||e===Object.prototype)};Kf.tryClone=function(e){if(!e||typeof e!="object"||typeof e=="function"||"HTMLElement"in globalThis&&e instanceof HTMLElement)return e;var r=lWe(e);if(r!=null)return r;if(sWe(e)){let n=!0;return e=e.map(o=>{let a=Kf.tryClone(o);return o!=null&&a==null&&(n=!1),a}),n?e:null}if(u(e))return e.clone();if(e instanceof File||e instanceof Blob)return e;if(!Kf.isAccessorLike(e)){r=new(Object.getPrototypeOf(e)).constructor;for(let n of Object.getOwnPropertyNames(e)){let o=e[n],a=Kf.tryClone(o);if(o!=null&&a==null)return null;r[n]=a}return r}return null};Bd=Kf});function Oy(){}function cWe(e){return e.__accessor__?e.__accessor__:null}function OX(e,r,n){return r?Object.keys(r).reduce((o,a)=>{let s=null;var l="merge";if(n&&(s=n.path?`${n.path}.${a}`:a,l=n.policy(s)),l==="replace"||l==="replace-arrays"&&Array.isArray(o[a]))return o[a]=r[a],o;if(o[a]===void 0)return o[a]=Bd.clone(r[a]),o;let h=o[a];if(l=r[a],h===l)return o;if(Array.isArray(l)||Array.isArray(o))h=h?Array.isArray(h)?o[a]=h.concat():o[a]=[h]:o[a]=[],l&&(Array.isArray(l)||(l=[l]),l.forEach(x=>{h.includes(x)||h.push(x)}));else if(l&&typeof l=="object")if(n){let x=n.path;n.path=Pg.assumeNonNull(s),o[a]=OX(h,l,n),n.path=x}else o[a]=OX(h,l,null);else(!o.hasOwnProperty(a)||r.hasOwnProperty(a))&&(o[a]=l);return o},e||{}):e}function ape(e){return Array.isArray(e)?e:e.split(".")}function uWe(e){return e.includes(",")?e.split(",").map(r=>r.trim()):[e.trim()]}function fWe(e){if(Array.isArray(e)){let r=[];for(let n of e)r.push(...uWe(n));return r}return uWe(e)}var Up,hN=Ee(()=>{xN();JS();cN();y(Oy,"utils");y(cWe,"g");y(OX,"q");y(ape,"u");y(uWe,"p");y(fWe,"t");Oy.getDependsInfo=function(e,r){let n=cWe(e);return n?n.getDependsInfo(e,r,""):""};Oy.getProperties=cWe;Oy.isPropertyDeclared=function(e,r){return e!=null&&e.metadatas&&e.metadatas[r]!=null};Oy.merge=function(e,r,n){return n?OX(e,r,{policy:n,path:""}):OX(e,r,null)};Oy.once=function(e){let r=!1;return()=>{r||(r=!0,e())}};Oy.parse=function(e,r,n,o){return r=fWe(r),r.length!==1?(r=r.map(a=>o(e,a,n)),rv.handlesGroup(r)):o(e,r[0],n)};Oy.parseConditionalPath=function(e){if(!e.includes("?"))return null;e=ape(e);let r=Array(e.length);for(let n=0;n<e.length;n++){let o=e[n];r[n]=o[o.length-1]==="?",r[n]&&(e[n]=o.slice(0,-1))}return{fullPath:e.join("."),conditional:r}};Oy.pathToArray=ape;Oy.pathToStringOrArray=function(e){return!e||typeof e=="string"&&!e.includes(".")?e:ape(e)};Oy.splitPath=fWe;Up=Oy});function FX(){}function xWe(e,r){if(e=e[e.length-1]==="?"?e.slice(0,-1):e,r.getItemAt!=null||Array.isArray(r)){var n=parseInt(e,10);if(!isNaN(n))return Array.isArray(r)?r[n]:r.at(n)}return 